/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.services.space.message.Release;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.cells.ThreadManagerMessageCallback;
import org.dcache.srm.SrmReleaseSpaceCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SrmReleaseSpaceCompanion
extends AbstractMessageCallback<Release> {
    private static final Logger _log = LoggerFactory.getLogger(SrmReleaseSpaceCompanion.class);
    private final long spaceToken;
    private final Long spaceToReleaseInBytes;
    private final SrmReleaseSpaceCallbacks callbacks;

    private SrmReleaseSpaceCompanion(long spaceToken, Long spaceToReleaseInBytes, SrmReleaseSpaceCallbacks callbacks) {
        this.spaceToken = spaceToken;
        this.spaceToReleaseInBytes = spaceToReleaseInBytes;
        this.callbacks = callbacks;
    }

    @Override
    public void failure(int rc, Object error) {
        _log.error("Space Release Failed rc" + rc + " error:" + error);
        this.callbacks.ReleaseSpaceFailed("Space Release Failed rc" + rc + " error:" + error);
    }

    public void noroute() {
        _log.error("No Route to SrmSpaceManager");
        this.callbacks.ReleaseSpaceFailed("No Route to SrmSpaceManager");
    }

    @Override
    public void success(Release releaseResponse) {
        _log.debug("success");
        this.callbacks.SpaceReleased(Long.toString(releaseResponse.getSpaceToken()), releaseResponse.getRemainingSizeInBytes());
    }

    public void timeout() {
        _log.error("Timeout waiting for answer from SrmSpaceManager");
        this.callbacks.ReleaseSpaceFailed("Timeout waiting for answer from SrmSpaceManager");
    }

    public String toString() {
        return this.getClass().getName() + " token:" + this.spaceToken + " releasesize:" + this.spaceToReleaseInBytes;
    }

    public static void releaseSpace(AuthorizationRecord user, long spaceToken, Long spaceToReleaseInBytes, SrmReleaseSpaceCallbacks callbacks, CellStub spaceManagerStub) {
        _log.debug("SrmReleaseSpaceCompanion.releaseSpace(" + user + ", token " + spaceToken + ", spaceToReleaseInBytes " + spaceToReleaseInBytes + ")");
        SrmReleaseSpaceCompanion companion = new SrmReleaseSpaceCompanion(spaceToken, spaceToReleaseInBytes, callbacks);
        Release release = new Release(spaceToken, spaceToReleaseInBytes);
        _log.debug("setting group=" + user.getVoGroup() + ", role=" + user.getVoRole());
        release.setAuthRecord(user);
        spaceManagerStub.send(release, Release.class, new ThreadManagerMessageCallback<Release>(companion));
    }
}

