/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.services.space.NoFreeSpaceException;
import diskCacheV111.services.space.SpaceAuthorizationException;
import diskCacheV111.services.space.SpaceExpiredException;
import diskCacheV111.services.space.SpaceReleasedException;
import diskCacheV111.services.space.message.Use;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.cells.ThreadManagerMessageCallback;
import org.dcache.srm.SrmUseSpaceCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SrmMarkSpaceAsBeingUsedCompanion
extends AbstractMessageCallback<Use> {
    private static final Logger _log = LoggerFactory.getLogger(SrmMarkSpaceAsBeingUsedCompanion.class);
    private final long spaceToken;
    private final String pnfPath;
    private final long sizeInBytes;
    private final long markLifetime;
    private final SrmUseSpaceCallbacks callbacks;
    private final boolean overwrite;

    private SrmMarkSpaceAsBeingUsedCompanion(long spaceToken, String pnfPath, long sizeInBytes, long markLifetime, boolean overwrite, SrmUseSpaceCallbacks callbacks) {
        this.spaceToken = spaceToken;
        this.pnfPath = pnfPath;
        this.sizeInBytes = sizeInBytes;
        this.markLifetime = markLifetime;
        this.callbacks = callbacks;
        this.overwrite = overwrite;
    }

    @Override
    public void failure(int rc, Object error) {
        _log.error("Marking Space as Being Used Failed rc:" + rc + " error:" + error);
        if (error == null) {
            this.callbacks.SrmUseSpaceFailed("Marking Space as Being Used failed");
        } else if (error instanceof NoFreeSpaceException) {
            this.callbacks.SrmNoFreeSpace(((NoFreeSpaceException)error).getMessage());
        } else if (error instanceof SpaceExpiredException) {
            this.callbacks.SrmExpired(((SpaceExpiredException)error).getMessage());
        } else if (error instanceof SpaceAuthorizationException) {
            this.callbacks.SrmNotAuthorized(((SpaceAuthorizationException)error).getMessage());
        } else if (error instanceof SpaceReleasedException) {
            this.callbacks.SrmReleased(((SpaceReleasedException)error).getMessage());
        } else if (error instanceof Exception) {
            this.callbacks.SrmUseSpaceFailed("Marking Space as Being Used failed =>" + ((Exception)error).getMessage());
        } else {
            this.callbacks.SrmUseSpaceFailed("Marking Space as Being Used failed =>" + error);
        }
    }

    public void noroute() {
        _log.error("No Route to to SrmSpaceManager");
        this.callbacks.SrmUseSpaceFailed("No Route to SrmSpaceManager");
    }

    @Override
    public void success(Use message) {
        _log.debug("success");
        this.callbacks.SpaceUsed();
    }

    public void timeout() {
        _log.error("Timeout waiting for answer from SrmSpaceManager");
        this.callbacks.SrmUseSpaceFailed("Timeout waiting for answer from SrmSpaceManager");
    }

    public String toString() {
        return this.getClass().getName() + " token:" + this.spaceToken + " size: " + this.sizeInBytes + " path: " + this.pnfPath + " lifetime: " + this.markLifetime;
    }

    public static void markSpace(AuthorizationRecord user, long spaceToken, String pnfPath, long sizeInBytes, long markLifetime, boolean overwrite, SrmUseSpaceCallbacks callbacks, CellStub spaceManagerStub) {
        _log.debug(" SrmMarkSpaceAsBeingUsedCompanion.markSpace(" + user + " spaceToken=" + spaceToken + " pnfsPath=" + pnfPath + " of " + sizeInBytes + " bytes, makr lifetime=" + markLifetime + ")");
        SrmMarkSpaceAsBeingUsedCompanion companion = new SrmMarkSpaceAsBeingUsedCompanion(spaceToken, pnfPath, sizeInBytes, markLifetime, overwrite, callbacks);
        Use use = new Use(spaceToken, user, pnfPath, null, sizeInBytes, markLifetime, overwrite);
        spaceManagerStub.send(use, Use.class, new ThreadManagerMessageCallback<Use>(companion));
    }
}

