/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DoorRequestInfoMessage;
import diskCacheV111.vehicles.PnfsDeleteEntryMessage;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.Serializable;
import java.util.EnumSet;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.namespace.FileType;
import org.dcache.srm.RemoveFileCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFileCompanion
extends AbstractMessageCallback<PnfsDeleteEntryMessage> {
    private static Logger _log = LoggerFactory.getLogger(RemoveFileCompanion.class);
    private static final CellPath BILLING_PATH = new CellPath("billing");
    private final AuthorizationRecord _user;
    private final RemoveFileCallbacks _callbacks;
    private final String _path;
    private final CellEndpoint _endpoint;

    private RemoveFileCompanion(AuthorizationRecord user, String path, RemoveFileCallbacks callbacks, CellEndpoint endpoint) {
        this._user = user;
        this._path = path;
        this._callbacks = callbacks;
        this._endpoint = endpoint;
    }

    public static void removeFile(AuthorizationRecord user, String path, RemoveFileCallbacks callbacks, CellStub pnfsStub, CellEndpoint endpoint) {
        RemoveFileCompanion companion = new RemoveFileCompanion(user, path, callbacks, endpoint);
        PnfsDeleteEntryMessage message = new PnfsDeleteEntryMessage(path, EnumSet.of(FileType.LINK, FileType.REGULAR));
        message.setSubject(user.toSubject());
        pnfsStub.send(message, PnfsDeleteEntryMessage.class, companion);
    }

    @Override
    public void success(PnfsDeleteEntryMessage message) {
        this.sendRemoveInfoToBilling(message.getPnfsId());
        this._callbacks.RemoveFileSucceeded();
    }

    @Override
    public void failure(int rc, Object error) {
        switch (rc) {
            case 10001: {
                this._callbacks.FileNotFound("No such file");
                break;
            }
            case 10015: {
                this._callbacks.FileNotFound("File is a directory");
                break;
            }
            case 10006: {
                this.timeout();
                break;
            }
            case 10018: {
                this._callbacks.PermissionDenied();
                break;
            }
            default: {
                this._callbacks.RemoveFileFailed(String.format("Deletion failed [rc=%d,msg=%s]", rc, error));
            }
        }
    }

    public void noroute() {
        this._callbacks.RemoveFileFailed("Deletion failed due to internal communication problem");
    }

    public void timeout() {
        this._callbacks.Timeout();
    }

    private void sendRemoveInfoToBilling(PnfsId pnfsid) {
        try {
            CellInfo info = this._endpoint.getCellInfo();
            DoorRequestInfoMessage msg = new DoorRequestInfoMessage(info.getCellName() + "@" + info.getDomainName(), "remove");
            msg.setSubject(this._user.toSubject());
            msg.setPath(this._path);
            msg.setPnfsId(pnfsid);
            this._endpoint.sendMessage(new CellMessage(BILLING_PATH, (Serializable)msg));
        }
        catch (NoRouteToCellException e) {
            _log.error("Failed to send remove message to billing: " + e.getMessage());
        }
    }
}

