/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import com.google.common.base.Objects;
import diskCacheV111.poolManager.PoolMonitorV5;
import diskCacheV111.srm.dcache.DcacheFileMetaData;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.FileLocality;
import diskCacheV111.util.FsPath;
import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.ProtocolInfo;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessMask;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.cells.ThreadManagerMessageCallback;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.pinmanager.PinManagerPinMessage;
import org.dcache.poolmanager.PoolMonitor;
import org.dcache.srm.FileMetaData;
import org.dcache.srm.PinCallbacks;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsGetFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinCompanion {
    private static final Logger _log = LoggerFactory.getLogger(PinCompanion.class);
    public static final String DISK_PIN_ID = "disk";
    private final Subject _subject;
    private final FsPath _path;
    private final String _clientHost;
    private final PinCallbacks _callbacks;
    private final long _pinLifetime;
    private final long _requestId;
    private final CellStub _pnfsStub;
    private final CellStub _poolManagerStub;
    private final CellStub _pinManagerStub;
    private final PoolMonitor _poolMonitor;
    private final boolean _isOnlinePinningEnabled;
    private Object _state;
    private FileAttributes _attributes;
    private PoolMgrSelectReadPoolMsg.Context _selectPoolContext;

    public static boolean isFakePinId(String pinId) {
        return Objects.equal((Object)pinId, (Object)DISK_PIN_ID);
    }

    private ProtocolInfo getProtocolInfo() {
        return new DCapProtocolInfo("DCap", 3, 0, new InetSocketAddress(this._clientHost, 0));
    }

    private PinCompanion(Subject subject, FsPath path, String clientHost, PinCallbacks callbacks, long pinLifetime, long requestId, boolean isOnlinePinningEnabled, PoolMonitor poolMonitor, CellStub pnfsStub, CellStub poolManagerStub, CellStub pinManagerStub) {
        this._subject = subject;
        this._path = path;
        this._clientHost = clientHost;
        this._callbacks = callbacks;
        this._pinLifetime = pinLifetime;
        this._requestId = requestId;
        this._isOnlinePinningEnabled = isOnlinePinningEnabled;
        this._poolMonitor = poolMonitor;
        this._pnfsStub = pnfsStub;
        this._poolManagerStub = poolManagerStub;
        this._pinManagerStub = pinManagerStub;
        this._state = new LookupState();
    }

    private void succeed(String pinId) {
        this._callbacks.Pinned((FileMetaData)new DcacheFileMetaData(this._attributes), pinId);
        this._state = new PinnedState();
    }

    private void fail(int rc, Object error) {
        switch (rc) {
            case 10001: {
                this._callbacks.FileNotFound("No such file");
                break;
            }
            case 10007: {
                this._callbacks.Unavailable(error.toString());
                break;
            }
            case 10018: {
                this._callbacks.Error("Permission denied");
                break;
            }
            case 10006: {
                _log.error("Internal timeout");
                this._callbacks.Timeout();
                break;
            }
            default: {
                _log.error(String.format("Pinning failed for %s [rc=%d,msg=%s]", this._path, rc, error));
                String reason = String.format("Failed to pin file [rc=%d,msg=%s]", rc, error);
                this._callbacks.PinningFailed(reason);
            }
        }
        this._state = new FailedState();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._path + "," + this._state.getClass().getSimpleName() + "]";
    }

    public static PinCompanion pinFile(Subject subject, FsPath path, String clientHost, PinCallbacks callbacks, long pinLifetime, long requestId, boolean isOnlinePinningEnabled, PoolMonitor poolMonitor, CellStub pnfsStub, CellStub poolManagerStub, CellStub pinManagerStub) {
        return new PinCompanion(subject, path, clientHost, callbacks, pinLifetime, requestId, isOnlinePinningEnabled, poolMonitor, pnfsStub, poolManagerStub, pinManagerStub);
    }

    private class FailedState {
        private FailedState() {
        }
    }

    private class PinnedState {
        private PinnedState() {
        }
    }

    private class PinningState
    extends CallbackState<PinManagerPinMessage> {
        public PinningState() {
            PinManagerPinMessage msg = new PinManagerPinMessage(PinCompanion.this._attributes, PinCompanion.this.getProtocolInfo(), String.valueOf(PinCompanion.this._requestId), PinCompanion.this._pinLifetime);
            msg.setSubject(PinCompanion.this._subject);
            PinCompanion.this._pinManagerStub.send(msg, PinManagerPinMessage.class, new ThreadManagerMessageCallback<PinManagerPinMessage>(this));
        }

        @Override
        public void success(PinManagerPinMessage message) {
            PinCompanion.this.succeed(String.valueOf(message.getPinId()));
        }
    }

    private class BringOnlineState
    extends CallbackState<PoolMgrSelectReadPoolMsg> {
        public BringOnlineState() {
            PoolMgrSelectReadPoolMsg msg = new PoolMgrSelectReadPoolMsg(PinCompanion.this._attributes, PinCompanion.this.getProtocolInfo(), PinCompanion.this._selectPoolContext);
            msg.setSkipCostUpdate(true);
            msg.setSubject(PinCompanion.this._subject);
            PinCompanion.this._poolManagerStub.send(msg, PoolMgrSelectReadPoolMsg.class, new ThreadManagerMessageCallback<PoolMgrSelectReadPoolMsg>(this));
        }

        @Override
        public void success(PoolMgrSelectReadPoolMsg message) {
            PinCompanion.this.succeed(PinCompanion.DISK_PIN_ID);
        }

        @Override
        public void failure(int rc, Object error) {
            if (rc == 10021) {
                PinCompanion.this._selectPoolContext = ((PoolMgrSelectReadPoolMsg)this.getReply()).getContext();
                PinCompanion.this._state = new LookupState();
            } else {
                super.failure(rc, error);
            }
        }
    }

    private class LookupState
    extends CallbackState<PnfsGetFileAttributes> {
        public LookupState() {
            EnumSet<FileAttribute> attributes = EnumSet.noneOf(FileAttribute.class);
            attributes.addAll(DcacheFileMetaData.getKnownAttributes());
            attributes.addAll(PinManagerPinMessage.getRequiredAttributes());
            attributes.addAll(PoolMonitorV5.getRequiredAttributesForFileLocality());
            attributes.add(FileAttribute.SIZE);
            attributes.add(FileAttribute.TYPE);
            attributes.add(FileAttribute.ACCESS_LATENCY);
            PnfsGetFileAttributes msg = new PnfsGetFileAttributes(PinCompanion.this._path.toString(), attributes);
            msg.setAccessMask(EnumSet.of(AccessMask.READ_DATA));
            msg.setSubject(PinCompanion.this._subject);
            PinCompanion.this._pnfsStub.send(msg, PnfsGetFileAttributes.class, new ThreadManagerMessageCallback<PnfsGetFileAttributes>(this));
        }

        private boolean isDirectory(FileAttributes attributes) {
            return PinCompanion.this._attributes.getFileType() == FileType.DIR;
        }

        private boolean isDiskFile(FileAttributes attributes) {
            return PinCompanion.this._attributes.getAccessLatency() == AccessLatency.ONLINE;
        }

        private boolean isOnline(FileAttributes attributes) {
            FileLocality locality = PinCompanion.this._poolMonitor.getFileLocality(PinCompanion.this._attributes, PinCompanion.this._clientHost);
            return locality == FileLocality.ONLINE;
        }

        @Override
        public void success(PnfsGetFileAttributes message) {
            PinCompanion.this._attributes = message.getFileAttributes();
            if (this.isDirectory(PinCompanion.this._attributes)) {
                PinCompanion.this._callbacks.FileNotFound("Path is a directory");
                PinCompanion.this._state = new FailedState();
            } else if (!this.isDiskFile(PinCompanion.this._attributes) || PinCompanion.this._isOnlinePinningEnabled) {
                PinCompanion.this._state = new PinningState();
            } else {
                FileLocality locality = PinCompanion.this._poolMonitor.getFileLocality(PinCompanion.this._attributes, PinCompanion.this._clientHost);
                switch (locality) {
                    case ONLINE: 
                    case ONLINE_AND_NEARLINE: {
                        PinCompanion.this.succeed(PinCompanion.DISK_PIN_ID);
                        break;
                    }
                    case UNAVAILABLE: {
                        PinCompanion.this.fail(10007, "File is currently unavailable");
                        break;
                    }
                    default: {
                        PinCompanion.this._state = new BringOnlineState();
                    }
                }
            }
        }
    }

    private abstract class CallbackState<T>
    extends AbstractMessageCallback<T> {
        private CallbackState() {
        }

        @Override
        public void failure(int rc, Object error) {
            PinCompanion.this.fail(rc, error);
        }
    }
}

