/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.srm.dcache;

import diskCacheV111.srm.FileMetaData;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.StorageInfo;
import java.util.EnumSet;
import java.util.Set;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.namespace.FileAttribute;
import org.dcache.srm.SRMUser;
import org.dcache.srm.v2_2.TAccessLatency;
import org.dcache.srm.v2_2.TFileLocality;
import org.dcache.srm.v2_2.TRetentionPolicy;
import org.dcache.srm.v2_2.TRetentionPolicyInfo;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcacheFileMetaData
extends org.dcache.srm.FileMetaData {
    private static final long serialVersionUID = 4486472517160693148L;
    private PnfsId pnfsId;
    private FileAttributes attributes;
    private static final Logger logger = LoggerFactory.getLogger(DcacheFileMetaData.class);

    public DcacheFileMetaData(PnfsId pnfsId) {
        this.pnfsId = pnfsId;
        this.fileId = pnfsId.toIdString();
    }

    public DcacheFileMetaData(PnfsId pnfsId, FileMetaData fmd) {
        super(fmd);
        this.pnfsId = pnfsId;
        this.fileId = pnfsId.toIdString();
    }

    public DcacheFileMetaData(FileAttributes attributes) {
        this.attributes = attributes;
        this.isPinned = false;
        this.isPermanent = true;
        this.isRegular = false;
        this.isDirectory = false;
        this.isLink = false;
        this.locality = TFileLocality.NONE;
        block21: for (FileAttribute attribute : attributes.getDefinedAttributes()) {
            block1 : switch (attribute) {
                case PNFSID: {
                    this.pnfsId = attributes.getPnfsId();
                    this.fileId = this.pnfsId.toString();
                    break;
                }
                case CHECKSUM: {
                    Set<Checksum> checksums = attributes.getChecksums();
                    for (Checksum checksum : checksums) {
                        this.checksumType = checksum.getType().getName().toLowerCase();
                        this.checksumValue = checksum.getValue();
                        if (checksum.getType() != ChecksumType.ADLER32) continue;
                        break block1;
                    }
                    continue block21;
                }
                case OWNER: {
                    this.owner = Integer.toString(attributes.getOwner());
                    break;
                }
                case OWNER_GROUP: {
                    this.group = Integer.toString(attributes.getGroup());
                    break;
                }
                case MODE: {
                    this.permMode = attributes.getMode();
                    break;
                }
                case TYPE: {
                    switch (attributes.getFileType()) {
                        case REGULAR: {
                            this.isRegular = true;
                            break block1;
                        }
                        case DIR: {
                            this.isDirectory = true;
                            break block1;
                        }
                        case LINK: {
                            this.isLink = true;
                            break block1;
                        }
                    }
                    break;
                }
                case ACCESS_TIME: {
                    this.lastAccessTime = attributes.getAccessTime();
                    break;
                }
                case MODIFICATION_TIME: {
                    this.lastModificationTime = attributes.getModificationTime();
                    break;
                }
                case CREATION_TIME: {
                    this.creationTime = attributes.getCreationTime();
                    break;
                }
                case SIZE: {
                    this.size = attributes.getSize();
                    break;
                }
                case RETENTION_POLICY: {
                    TAccessLatency latency = null;
                    if (attributes.isDefined(FileAttribute.ACCESS_LATENCY)) {
                        if (attributes.getAccessLatency().equals((Object)AccessLatency.ONLINE)) {
                            latency = TAccessLatency.ONLINE;
                        } else if (attributes.getAccessLatency().equals((Object)AccessLatency.NEARLINE)) {
                            latency = TAccessLatency.NEARLINE;
                        }
                    }
                    TRetentionPolicy retention = null;
                    if (attributes.getRetentionPolicy().equals((Object)RetentionPolicy.CUSTODIAL)) {
                        retention = TRetentionPolicy.CUSTODIAL;
                    } else if (attributes.getRetentionPolicy().equals((Object)RetentionPolicy.REPLICA)) {
                        retention = TRetentionPolicy.REPLICA;
                    } else if (attributes.getRetentionPolicy().equals((Object)RetentionPolicy.OUTPUT)) {
                        retention = TRetentionPolicy.OUTPUT;
                    }
                    if (retention == null) break;
                    this.retentionPolicyInfo = new TRetentionPolicyInfo(retention, latency);
                    break;
                }
                case STORAGEINFO: {
                    String writeToken;
                    StorageInfo storage_info = attributes.getStorageInfo();
                    this.isStored = storage_info.isStored();
                    if (storage_info.getMap() == null || (writeToken = storage_info.getMap().get("writeToken")) == null) break;
                    this.spaceTokens = new long[1];
                    try {
                        this.spaceTokens[0] = Long.parseLong(writeToken);
                        break;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public PnfsId getPnfsId() {
        return this.pnfsId;
    }

    public void setFileAttributes(FileAttributes attributes) {
        this.attributes = attributes;
    }

    public FileAttributes getFileAttributes() {
        return this.attributes;
    }

    public boolean isOwner(SRMUser user) {
        try {
            return Integer.parseInt(this.owner) == ((AuthorizationRecord)user).getUid();
        }
        catch (NumberFormatException nfe) {
            logger.error("owner is not a number: " + this.owner, (Throwable)nfe);
            throw nfe;
        }
        catch (ClassCastException cce) {
            logger.error("user is not a dCacheUser: " + user, (Throwable)cce);
            throw cce;
        }
    }

    public boolean isGroupMember(SRMUser user) {
        try {
            return Integer.parseInt(this.group) == ((AuthorizationRecord)user).getGid();
        }
        catch (NumberFormatException nfe) {
            logger.error("group is not a number: " + this.group, (Throwable)nfe);
            throw nfe;
        }
        catch (ClassCastException cce) {
            logger.error("user is not a dCacheUser: " + user, (Throwable)cce);
            throw cce;
        }
    }

    public static Set<FileAttribute> getKnownAttributes() {
        return EnumSet.of(FileAttribute.PNFSID, new FileAttribute[]{FileAttribute.STORAGEINFO, FileAttribute.CHECKSUM, FileAttribute.OWNER, FileAttribute.OWNER_GROUP, FileAttribute.MODE, FileAttribute.TYPE, FileAttribute.SIZE, FileAttribute.ACCESS_TIME, FileAttribute.MODIFICATION_TIME, FileAttribute.CREATION_TIME, FileAttribute.ACCESS_LATENCY, FileAttribute.RETENTION_POLICY});
    }
}

