/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.services.web.PoolCellQueryInfo;
import diskCacheV111.util.HTMLWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;

public class PoolGroupInfoTableWriter {
    private final HTMLWriter _html;

    public PoolGroupInfoTableWriter(HTMLWriter html) {
        this._html = html;
    }

    private static double round(double value) {
        return Math.floor(value * 10.0) / 10.0;
    }

    private void printRow(String group, long total, long freespace, long precious, long removable, String ... classes) {
        long mb = 0x100000L;
        double red = PoolGroupInfoTableWriter.round((float)(100L * precious) / (float)total);
        double green = PoolGroupInfoTableWriter.round((float)(100L * removable) / (float)total);
        double yellow = PoolGroupInfoTableWriter.round((float)(100L * freespace) / (float)total);
        double blue = Math.max(0.0, 100.0 - red - green - yellow);
        this._html.beginRow(classes);
        this._html.td("group", group);
        this._html.td("total", total / 0x100000L);
        this._html.td("free", freespace / 0x100000L);
        this._html.td("precious", precious / 0x100000L);
        this._html.td("layout", "<div>", "<div class=\"layout_precious\" style=\"width: ", String.format(Locale.US, "%.1f", red), "%\"></div>", "<div class=\"layout_rest\" style=\"width: ", String.format(Locale.US, "%.1f", blue), "%\"></div>", "<div class=\"layout_used\" style=\"width: ", String.format(Locale.US, "%.1f", green), "%\"></div>", "<div class=\"layout_free\" style=\"width: ", String.format(Locale.US, "%.1f", yellow), "%\"></div>", "</div>");
        this._html.endRow();
    }

    public void print(String base, SortedMap<String, Collection<Object>> info) {
        this._html.beginTable("sortable", "group", "PoolGroup", "total", "Total Space/MB", "free", "Free Space/MB", "precious", "Precious Space/MB", "layout", "<span>Layout   (<span class=\"layout_precious\">precious/</span><span class=\"layout_used\">used/</span><span class=\"layout_free\">free</span>)</span>");
        for (Map.Entry<String, Collection<Object>> entry : info.entrySet()) {
            String link = String.format("<a href=\"%s/%s/spaces\">%s</a>", base, entry.getKey(), entry.getKey());
            long[] spaces = this.sumUpSpaces(entry.getValue());
            this.printRow(link, spaces[0], spaces[1], spaces[2], spaces[3], null, "odd");
        }
        this._html.endTable();
    }

    private long[] sumUpSpaces(Collection<Object> itemSet) {
        long[] result = new long[4];
        for (Object i : itemSet) {
            try {
                PoolCellQueryInfo info = (PoolCellQueryInfo)i;
                PoolCellInfo cellInfo = info.getPoolCellInfo();
                if (!info.isOk() || !(cellInfo instanceof PoolCellInfo)) continue;
                PoolCostInfo.PoolSpaceInfo spaceInfo = cellInfo.getPoolCostInfo().getSpaceInfo();
                result[0] = result[0] + spaceInfo.getTotalSpace();
                result[1] = result[1] + spaceInfo.getFreeSpace();
                result[2] = result[2] + spaceInfo.getPreciousSpace();
                result[3] = result[3] + spaceInfo.getRemovableSpace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

