/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.web;

import dmg.cells.nucleus.CellEndpoint;
import dmg.util.HttpException;
import dmg.util.HttpRequest;
import dmg.util.HttpResponseEngine;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextPictureEngine
implements HttpResponseEngine {
    private static final Logger _log = LoggerFactory.getLogger(ContextPictureEngine.class);
    private CellEndpoint _endpoint;
    private Hashtable _domainHash = new Hashtable();
    private String[] _args;
    private DateFormat _dataFormat = new SimpleDateFormat("MMM d, hh.mm.ss");

    public ContextPictureEngine(CellEndpoint endpoint, String[] args) {
        this._endpoint = endpoint;
        this._args = args;
    }

    public void startup() {
    }

    public void shutdown() {
    }

    public void queryUrl(HttpRequest request) throws HttpException {
        String[] tokens = request.getRequestTokens();
        int offset = request.getRequestTokenOffset();
        _log.info("Offset : " + offset);
        for (int i = 0; i < tokens.length; ++i) {
            _log.info("" + i + " -> " + tokens[i]);
        }
        if (tokens.length < 2) {
            throw new HttpException(404, "Illegal Request");
        }
        String contextName = tokens[1];
        Object obj = this._endpoint.getDomainContext().get(contextName);
        if (!(obj instanceof byte[])) {
            throw new HttpException(404, "Not a picture");
        }
        byte[] picture = (byte[])obj;
        request.setContentType("image/png");
        request.printHttpHeader(picture.length);
        OutputStream stream = request.getOutputStream();
        try {
            stream.write(picture, 0, picture.length);
            stream.flush();
        }
        catch (IOException ee) {
            throw new HttpException(203, ee.getMessage());
        }
    }
}

