/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public final class TextParser {
    private static final String WHITESPACE_AND_QUOTES = " \t\r\n\"";
    private static final String DOUBLE_QUOTE = "\"";
    private String _text;
    private Collection set;

    public TextParser(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Search Text cannot be null.");
        }
        this._text = text;
        this.parseText();
    }

    public String[] getTokens() {
        String[] result = new String[this.set.size()];
        Iterator i = this.set.iterator();
        int j = 0;
        while (i.hasNext()) {
            result[j] = (String)i.next();
            ++j;
        }
        return result;
    }

    public void parseText() {
        this.set = new LinkedList();
        boolean returnTokens = true;
        String currentDelimeters = WHITESPACE_AND_QUOTES;
        StringTokenizer parser = new StringTokenizer(this._text, currentDelimeters, returnTokens);
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken(currentDelimeters);
            if (!this.isDoubleQuote(token)) {
                this.addToken(token, this.set);
                continue;
            }
            currentDelimeters = this.flipDelimiters(currentDelimeters);
        }
    }

    public Collection getTokenSet() {
        return this.set;
    }

    private boolean emptyText(String text) {
        return text == null || text.trim().equals("");
    }

    private void addToken(String token, Collection result) {
        if (!this.emptyText(token)) {
            result.add(token.trim());
        }
    }

    private boolean isDoubleQuote(String token) {
        return token.equals(DOUBLE_QUOTE);
    }

    private String flipDelimiters(String currentDelimeters) {
        String result = currentDelimeters.equals(WHITESPACE_AND_QUOTES) ? DOUBLE_QUOTE : WHITESPACE_AND_QUOTES;
        return result;
    }
}

