/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.poolManager.PoolManagerCellInfo;
import diskCacheV111.vehicles.PoolLinkInfo;
import diskCacheV111.vehicles.PoolMgrGetPoolLinks;
import diskCacheV111.vehicles.QuotaMgrCheckQuotaMessage;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageInfoQuotaObserver
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(StorageInfoQuotaObserver.class);
    private CellNucleus _nucleus;
    private Args _args;
    private File _configFile;
    private final Map<String, PoolSpaceInfo> _poolHash = new HashMap<String, PoolSpaceInfo>();
    private final Object _linkMapLock = new Object();
    private Map<String, LinkInfo> _linkMap;
    private String _poolManagerName = "PoolManager";
    private int _poolQuerySteps = 10;
    private long _poolQueryBreak = 100L;
    private boolean _poolsUpdated = true;
    private boolean _linksUpdated = true;
    private long _poolQueryInterval = 120000L;
    private long _poolManagerQueryInterval = 300000L;
    private long _poolValidityTimeout = 3L * this._poolQueryInterval;
    public static final String hh_show_link = "-a";
    public static final String hh_show_sci = "";
    public static final String hh_show_pool = "[<pool>]";
    public static final String hh_query_links = "";
    public static final String hh_query_poolmanager = "";
    public static final String hh_query_pools = "";
    public static final String hh_set_poolmanager_query_interval = "<PoolQueryInterval/seconds> # must be > 0 ";
    public static final String hh_set_pool_validity_timeout = "<PoolValidityTimeout/seconds> # must be > 0 ";
    public static final String hh_set_pool_query_interval = "<PoolQueryInterval/seconds> # must be > 0 ";
    public static final String hh_set_pool_query_break = "<PoolQueryBreak/millis> # no break if <= 0 ";
    public static final String hh_set_pool_query_steps = "<PoolQuerySteps> # no steps if <= 0";

    public StorageInfoQuotaObserver(String name, String args) throws Exception {
        super(name, StorageInfoQuotaObserver.class.getName(), args, false);
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        try {
            String configName = this._args.getOpt("config");
            if (configName != null && !configName.equals("")) {
                this._configFile = new File(configName);
            }
            _log.info("Query Engine will be started a bit delayed");
            this._nucleus.newThread((Runnable)new DoDelayedOnStartup(), "init").start();
        }
        catch (Exception ee) {
            _log.warn("<init> of WebCollector reports : " + ee.getMessage(), (Throwable)ee);
            this.start();
            this.kill();
            throw ee;
        }
        this.start();
    }

    public void messageArrived(CellMessage message) {
        CellPath source = message.getSourcePath();
        String sourceCell = source.getCellName();
        Serializable messageObject = message.getMessageObject();
        if (messageObject instanceof QuotaMgrCheckQuotaMessage) {
            this.queryQuotas(message, (QuotaMgrCheckQuotaMessage)messageObject);
        } else if (messageObject instanceof PoolMgrGetPoolLinks) {
            this.queryPoolLinks(message, (PoolMgrGetPoolLinks)messageObject);
        } else if (sourceCell.equals(this._poolManagerName)) {
            this.messageFromPoolManager(message);
        } else {
            this.messageFromPool(sourceCell, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInfo(PrintWriter pw) {
        int pools;
        pw.println("   Cell Name " + this.getCellName());
        pw.println("  Cell Class " + ((Object)((Object)this)).getClass().getName());
        pw.println("         Pool Query Interval/sec : " + this._poolQueryInterval / 1000L);
        pw.println("         Pool Query Break/millis : " + this._poolQueryBreak);
        pw.println("                Pool Query Steps : " + this._poolQuerySteps);
        pw.println("       Pool Validity Timeout/sec : " + this._poolValidityTimeout / 1000L);
        pw.println(" Pool Manager Query Interval/sec : " + this._poolManagerQueryInterval / 1000L);
        Map<String, PoolSpaceInfo> map = this._linkMapLock;
        synchronized (map) {
            pw.println(" Number of Links : " + (this._linkMap == null ? "Not yet known" : "" + this._linkMap.size()));
        }
        map = this._poolHash;
        synchronized (map) {
            pools = this._poolHash.size();
        }
        pw.println(" Number of pools : " + pools);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageFromPoolManager(CellMessage message) {
        Serializable obj = message.getMessageObject();
        if (obj instanceof List) {
            try {
                this.scanLinkInfo((List)((Object)obj));
            }
            catch (Exception ee) {
                _log.warn("Problem scanning link info : " + ee, (Throwable)ee);
            }
        } else if (obj instanceof PoolManagerCellInfo) {
            Map<String, PoolSpaceInfo> map = this._poolHash;
            synchronized (map) {
                for (Map.Entry entry : ((PoolManagerCellInfo)obj).getPoolMap().entrySet()) {
                    PoolSpaceInfo info = this._poolHash.get(entry.getKey());
                    if (info != null) continue;
                    info = new PoolSpaceInfo((String)entry.getKey(), (CellAddressCore)entry.getValue());
                    this._poolHash.put((String)entry.getKey(), info);
                }
            }
        } else if (obj instanceof NoRouteToCellException) {
            _log.warn("NoRouteToCell from PoolManager");
        } else {
            _log.warn("Unknow message arrived from PoolManager : " + obj.getClass().getName());
        }
    }

    private void messageFromPool(String poolName, CellMessage message) {
        Serializable obj = message.getMessageObject();
        if (obj instanceof Object[]) {
            try {
                this.scanSpaceInfo(poolName, (Object[])obj);
            }
            catch (Exception e) {
                _log.warn("Problem scanning space info : " + e, (Throwable)e);
            }
        } else if (obj instanceof NoRouteToCellException) {
            _log.warn("messageFromPool got NoRouteToCellException : " + obj);
        } else {
            _log.warn("messageFromPool got Unknown object : " + obj);
        }
    }

    private void queryQuotas(CellMessage message, QuotaMgrCheckQuotaMessage quota) {
        try {
            String storageClass = quota.getStorageClass();
            if (storageClass == null) {
                throw new IllegalArgumentException("No storage class specified");
            }
            Map<String, SpaceInfo> sci = this.createStorageInfoHash();
            SpaceInfo space = sci.get(storageClass);
            if (space == null) {
                throw new IllegalArgumentException("No such storage class : " + storageClass);
            }
            quota.setQuotas(0L, 0L, space._space);
        }
        catch (Exception e) {
            quota.setFailed(55, (Serializable)((Object)e.getMessage()));
        }
        message.revertDirection();
        try {
            this.sendMessage(message);
        }
        catch (Exception ee) {
            _log.warn("Problem replying PoolMgrGetPoolLinks message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryPoolLinks(CellMessage message, PoolMgrGetPoolLinks query) {
        this.resolveAllLinkInfos();
        try {
            ArrayList<LinkInfo> linkList;
            Object object = this._linkMapLock;
            synchronized (object) {
                if (this._linkMap == null) {
                    throw new Exception("Quota service not yet available (please wait)");
                }
                linkList = new ArrayList<LinkInfo>(this._linkMap.values());
            }
            ArrayList<PoolLinkInfo> result = new ArrayList<PoolLinkInfo>();
            for (LinkInfo info : linkList) {
                List storageClasses = info._storageClasses;
                String[] storageGroups = storageClasses == null ? new String[]{} : storageClasses.toArray(new String[storageClasses.size()]);
                long available = info._linkFreeSpace + info._linkRemovableSpace;
                PoolLinkInfo poolInfo = new PoolLinkInfo(info._name, available, storageGroups);
                result.add(poolInfo);
            }
            query.setPoolLinkInfos(result.toArray(new PoolLinkInfo[result.size()]));
        }
        catch (Exception ee) {
            _log.warn(ee.toString(), (Throwable)ee);
            query.setFailed(23, ee);
        }
        message.revertDirection();
        try {
            this.sendMessage(message);
        }
        catch (Exception ee) {
            _log.warn("Problem replying PoolMgrGetPoolLinks message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanLinkInfo(List<Object[]> linkList) {
        HashMap<String, LinkInfo> linkMap = new HashMap<String, LinkInfo>();
        for (Object[] link : linkList) {
            LinkInfo linkInfo;
            String linkName = link[0].toString();
            Object object = this._linkMapLock;
            synchronized (object) {
                linkInfo = this._linkMap == null ? null : this._linkMap.get(linkName);
            }
            if (linkInfo == null) {
                linkInfo = new LinkInfo(linkName);
            }
            object = linkInfo;
            synchronized (object) {
                linkInfo._pools = Arrays.asList((Object[])link[5]);
                linkInfo._storageClasses = Arrays.asList((String[])link[9]);
            }
            linkMap.put(linkName, linkInfo);
        }
        Object object = this._linkMapLock;
        synchronized (object) {
            this._linkMap = linkMap;
        }
        this._linksUpdated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanSpaceInfo(String poolName, Object[] result) {
        PoolSpaceInfo info;
        ArrayList<SpaceInfo> sciList = new ArrayList<SpaceInfo>();
        SpaceInfo sciSum = new SpaceInfo("total");
        long totalSpace = 0L;
        long freeSpace = 0L;
        long removableSpace = 0L;
        for (Object o : result) {
            Object[] x = (Object[])o;
            String sciName = (String)x[0];
            long[] counter = (long[])x[1];
            if (sciName.equals("total")) {
                totalSpace = counter[0];
                freeSpace = counter[1];
                removableSpace = counter[2];
                continue;
            }
            SpaceInfo sci = new SpaceInfo(sciName, counter[0], counter[1]);
            sciList.add(sci);
            if (counter.length > 2) {
                sci._preciousSpace = counter[2];
                sci._preciousFiles = counter[3];
                sci._stickySpace = counter[4];
                sci._stickyFiles = counter[5];
                sci._removableSpace = counter[6];
                sci._removableFiles = counter[7];
            }
            sciSum.add(sci);
        }
        Object object = this._poolHash;
        synchronized (object) {
            info = this._poolHash.get(poolName);
        }
        object = info;
        synchronized (object) {
            info._time = System.currentTimeMillis();
            PoolSpaceInfo.access$2802(info, sciList.toArray(new SpaceInfo[sciList.size()]));
            info._totalSpace = sciSum;
            info._poolSize = totalSpace;
            info._poolFreeSpace = freeSpace;
            info._poolRemovableSpace = removableSpace;
        }
        this._poolsUpdated = true;
    }

    private void queryPoolManager() {
        try {
            _log.debug("Sending xgetcellinfo to " + this._poolManagerName);
            CellMessage msg = new CellMessage(new CellPath(this._poolManagerName), (Serializable)((Object)"xgetcellinfo"));
            this.sendMessage(msg);
        }
        catch (NoRouteToCellException cee) {
            _log.warn("NoPath to cell : " + this._poolManagerName);
        }
        catch (Exception ee) {
            _log.warn("Exception in sending query to pool " + this._poolManagerName);
        }
    }

    private void queryLinks() {
        try {
            String command = "psux ls link -x -resolve";
            _log.debug("Sending poolManager query " + command + " to " + this._poolManagerName);
            CellMessage msg = new CellMessage(new CellPath(this._poolManagerName), (Serializable)((Object)command));
            this.sendMessage(msg);
        }
        catch (NoRouteToCellException cee) {
            _log.warn("NoPath to cell : " + this._poolManagerName);
        }
        catch (Exception ee) {
            _log.warn("Exception in sending query to pool : " + this._poolManagerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryPools() {
        ArrayList<PoolSpaceInfo> list;
        Map<String, PoolSpaceInfo> map = this._poolHash;
        synchronized (map) {
            list = new ArrayList<PoolSpaceInfo>(this._poolHash.values());
        }
        int counter = 0;
        for (PoolSpaceInfo info : list) {
            ++counter;
            CellAddressCore address = info._address;
            try {
                _log.debug("Sending pool query 'rep ls -s binary' to {}", (Object)address);
                CellMessage msg = new CellMessage(new CellPath(address), (Serializable)((Object)"rep ls -s -sum -binary"));
                this.sendMessage(msg);
            }
            catch (NoRouteToCellException cee) {
                _log.warn("NoPath to cell: {}", (Object)address);
            }
            catch (Exception ee) {
                _log.warn("Exception in sending query to pool: {}", (Object)address);
            }
            if (this._poolQuerySteps <= 0 || counter % this._poolQuerySteps != 0) continue;
            _log.info("Waiting a while (" + this._poolQueryBreak + ") millis");
            try {
                if (this._poolQueryBreak <= 0L) continue;
                Thread.sleep(this._poolQueryBreak);
            }
            catch (InterruptedException ee) {
                _log.warn("Query pool lock interrupted");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SpaceInfo> createStorageInfoHash() {
        ArrayList<PoolSpaceInfo> list;
        HashMap<String, SpaceInfo> sciMap = new HashMap<String, SpaceInfo>();
        Map<String, PoolSpaceInfo> map = this._poolHash;
        synchronized (map) {
            list = new ArrayList<PoolSpaceInfo>(this._poolHash.values());
        }
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            PoolSpaceInfo poolInfo;
            PoolSpaceInfo poolSpaceInfo = poolInfo = (PoolSpaceInfo)i$.next();
            synchronized (poolSpaceInfo) {
                SpaceInfo[] sciArray = poolInfo._storageClassInfo;
                if (sciArray == null) {
                    continue;
                }
                for (SpaceInfo sci : sciArray) {
                    SpaceInfo sumSci = (SpaceInfo)sciMap.get(sci._name);
                    if (sumSci == null) {
                        sumSci = new SpaceInfo(sci._name);
                        sciMap.put(sci._name, sci);
                    }
                    sumSci.add(sci);
                }
            }
        }
        return sciMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkInfo resolveLinkInfoByName(String linkName) {
        HashMap<String, PoolSpaceInfo> poolMap;
        LinkInfo info;
        Object object = this._linkMapLock;
        synchronized (object) {
            if (this._linkMap == null) {
                return null;
            }
            info = this._linkMap.get(linkName);
            if (info == null) {
                return null;
            }
        }
        Map<String, PoolSpaceInfo> map = this._poolHash;
        synchronized (map) {
            poolMap = new HashMap<String, PoolSpaceInfo>(this._poolHash);
        }
        return this.resolveLinkInfoByLink(info, poolMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAllLinkInfos() {
        HashMap<String, PoolSpaceInfo> poolMap;
        ArrayList<LinkInfo> linkList;
        if (!this._poolsUpdated && !this._linksUpdated) {
            return;
        }
        Map<String, PoolSpaceInfo> map = this._linkMapLock;
        synchronized (map) {
            if (this._linkMap == null) {
                return;
            }
            linkList = new ArrayList<LinkInfo>(this._linkMap.values());
        }
        map = this._poolHash;
        synchronized (map) {
            poolMap = new HashMap<String, PoolSpaceInfo>(this._poolHash);
        }
        for (LinkInfo info : linkList) {
            this.resolveLinkInfoByLink(info, poolMap);
        }
        this._linksUpdated = false;
        this._poolsUpdated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkInfo resolveLinkInfoByLink(LinkInfo info, Map<String, PoolSpaceInfo> poolMap) {
        List poolListOfLink;
        LinkInfo linkInfo = info;
        synchronized (linkInfo) {
            poolListOfLink = info._pools == null ? new ArrayList() : info._pools;
        }
        long now = System.currentTimeMillis();
        SpaceInfo sum = new SpaceInfo(info._name);
        long linkTotalSize = 0L;
        long linkFreeSpace = 0L;
        long linkRemovableSpace = 0L;
        for (Object pool : poolListOfLink) {
            String poolName = pool.toString();
            PoolSpaceInfo poolInfo = poolMap.get(poolName);
            if (poolInfo == null) continue;
            PoolSpaceInfo poolSpaceInfo = poolInfo;
            synchronized (poolSpaceInfo) {
                if (poolInfo == null || !poolInfo.wasValidAt(now)) {
                    continue;
                }
                sum.add(poolInfo._totalSpace);
                linkTotalSize += poolInfo._poolSize;
                linkFreeSpace += poolInfo._poolFreeSpace;
                linkRemovableSpace += poolInfo._poolRemovableSpace;
            }
        }
        LinkInfo linkInfo2 = info;
        synchronized (linkInfo2) {
            info._totalSpace = sum;
            info._linkTotalSize = linkTotalSize;
            info._linkFreeSpace = linkFreeSpace;
            info._linkRemovableSpace = linkRemovableSpace;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_show_link_$_0(Args args) {
        try {
            ArrayList<LinkInfo> linkList;
            boolean all = args.hasOption("a");
            StringBuilder sb = new StringBuilder();
            Object object = this._linkMapLock;
            synchronized (object) {
                if (this._linkMap == null) {
                    throw new Exception("Link Map Not yet received");
                }
                linkList = new ArrayList<LinkInfo>(this._linkMap.values());
            }
            this.resolveAllLinkInfos();
            Iterator i$ = linkList.iterator();
            while (i$.hasNext()) {
                LinkInfo info;
                LinkInfo linkInfo = info = (LinkInfo)i$.next();
                synchronized (linkInfo) {
                    sb.append(info._name);
                    if (info._totalSpace != null) {
                        sb.append("  ").append(info._totalSpace.toString());
                    }
                    sb.append("\n");
                    if (!all) {
                        continue;
                    }
                    List list = info._pools;
                    if (list != null) {
                        sb.append(" Pools:\n");
                        for (Object pool : list) {
                            sb.append("   ").append(pool.toString()).append("\n");
                        }
                    }
                    if ((list = info._storageClasses) != null) {
                        sb.append(" StorageClasses:\n");
                        for (Object storageClass : list) {
                            sb.append("   ").append(storageClass.toString()).append("\n");
                        }
                    }
                }
            }
            return sb.toString();
        }
        catch (Exception eeee) {
            _log.warn(eeee.toString(), (Throwable)eeee);
            return "Failed";
        }
    }

    public String ac_show_sci_$_0(Args args) {
        try {
            StringBuilder sb = new StringBuilder();
            Map<String, SpaceInfo> sciHash = this.createStorageInfoHash();
            Iterator<SpaceInfo> i$ = sciHash.values().iterator();
            while (i$.hasNext()) {
                SpaceInfo o;
                SpaceInfo info = o = i$.next();
                sb.append(info.toString()).append("\n");
            }
            return sb.toString();
        }
        catch (Exception ee) {
            _log.warn(ee.toString(), (Throwable)ee);
            return "Failed";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_show_pool_$_0_1(Args args) {
        try {
            StringBuilder sb = new StringBuilder();
            if (args.argc() == 0) {
                ArrayList<PoolSpaceInfo> list;
                Map<String, PoolSpaceInfo> map = this._poolHash;
                synchronized (map) {
                    list = new ArrayList<PoolSpaceInfo>(this._poolHash.values());
                }
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    PoolSpaceInfo info;
                    PoolSpaceInfo poolSpaceInfo = info = (PoolSpaceInfo)i$.next();
                    synchronized (poolSpaceInfo) {
                        sb.append(info.toString()).append("\n");
                    }
                }
                return sb.toString();
            }
            String poolName = args.argv(0);
            Map<String, PoolSpaceInfo> map = this._poolHash;
            synchronized (map) {
                SpaceInfo[] sci;
                String general;
                PoolSpaceInfo info = this._poolHash.get(poolName);
                if (info == null) {
                    throw new IllegalArgumentException("Pool not found : " + poolName);
                }
                PoolSpaceInfo poolSpaceInfo = info;
                synchronized (poolSpaceInfo) {
                    general = info.toString();
                    sci = info._storageClassInfo;
                }
                sb.append(general).append("\n");
                if (sci != null) {
                    for (SpaceInfo aSci : sci) {
                        sb.append(" ").append(aSci.toString()).append("\n");
                    }
                }
                return sb.toString();
            }
        }
        catch (Exception ee) {
            _log.warn(ee.toString(), (Throwable)ee);
            return "Failed";
        }
    }

    public String ac_query_links_$_0(Args args) {
        this.queryLinks();
        return "";
    }

    public String ac_query_poolmanager_$_0(Args args) {
        this.queryPoolManager();
        return "";
    }

    public String ac_query_pools_$_0(Args args) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                StorageInfoQuotaObserver.this.queryPools();
            }
        }).start();
        return "";
    }

    public String ac_set_poolmanager_query_interval_$_1(Args args) {
        long n = Long.parseLong(args.argv(0));
        if (n <= 0L) {
            throw new IllegalArgumentException("Pool Query Interval must be > 0");
        }
        this._poolManagerQueryInterval = n * 1000L;
        return "";
    }

    public String ac_set_pool_validity_timeout_$_1(Args args) {
        long n = Long.parseLong(args.argv(0));
        if (n <= 0L) {
            throw new IllegalArgumentException("Pool Query Interval must be > 0");
        }
        this._poolValidityTimeout = n * 1000L;
        return "";
    }

    public String ac_set_pool_query_interval_$_1(Args args) {
        long n = Long.parseLong(args.argv(0));
        if (n <= 0L) {
            throw new IllegalArgumentException("Pool Query Interval must be > 0");
        }
        this._poolQueryInterval = n * 1000L;
        return "";
    }

    public String ac_set_pool_query_break_$_1(Args args) {
        this._poolQueryBreak = Long.parseLong(args.argv(0));
        return "";
    }

    public String ac_set_pool_query_steps_$_1(Args args) {
        this._poolQuerySteps = Integer.parseInt(args.argv(0));
        return "";
    }

    private class QueryPools
    implements Runnable {
        private QueryPools() {
        }

        @Override
        public void run() {
            _log.info("Query Pools worker started");
            while (true) {
                StorageInfoQuotaObserver.this.queryPools();
                try {
                    Thread.currentThread();
                    Thread.sleep(StorageInfoQuotaObserver.this._poolQueryInterval);
                }
                catch (Exception ee) {
                    _log.warn("Query Pools worker interrupted");
                    _log.info("Query Pools worker finished");
                    return;
                }
            }
        }
    }

    private class QueryPoolManager
    implements Runnable {
        private QueryPoolManager() {
        }

        @Override
        public void run() {
            _log.info("Query Pool Manager worker started");
            while (true) {
                StorageInfoQuotaObserver.this.queryLinks();
                StorageInfoQuotaObserver.this.queryPoolManager();
                try {
                    Thread.currentThread();
                    Thread.sleep(StorageInfoQuotaObserver.this._poolManagerQueryInterval);
                }
                catch (Exception ee) {
                    _log.warn("Query Pool Manager worker interrupted");
                    _log.info("Query Pool Manager worker finished");
                    return;
                }
            }
        }
    }

    private class DoDelayedOnStartup
    implements Runnable {
        private DoDelayedOnStartup() {
        }

        @Override
        public void run() {
            _log.info("Collector will be delayed");
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (Exception ee) {
                return;
            }
            _log.info("QueryPoolManager now starting");
            StorageInfoQuotaObserver.this._nucleus.newThread((Runnable)new QueryPoolManager(), "QueryPoolManager").start();
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (Exception ee) {
                return;
            }
            _log.info("QueryPools now starting");
            StorageInfoQuotaObserver.this._nucleus.newThread((Runnable)new QueryPools(), "QueryPools").start();
        }
    }

    private class LinkInfo {
        private String _name;
        private List<?> _pools;
        private List<String> _storageClasses;
        private SpaceInfo _totalSpace;
        private long _linkTotalSize;
        private long _linkFreeSpace;
        private long _linkRemovableSpace;

        private LinkInfo(String name) {
            this._name = name;
        }
    }

    private class PoolSpaceInfo {
        private String _name;
        private long _time;
        private long _poolSize;
        private long _poolFreeSpace;
        private long _poolRemovableSpace;
        private SpaceInfo[] _storageClassInfo;
        private SpaceInfo _totalSpace;
        private final CellAddressCore _address;

        private PoolSpaceInfo(String name, CellAddressCore address) {
            this._name = name;
            this._address = address;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._name).append("={time=");
            if (!this.isValid()) {
                sb.append("Invalid");
            } else {
                sb.append(System.currentTimeMillis() - this._time);
            }
            if (this._storageClassInfo == null) {
                sb.append(";SciCount=NN");
            } else {
                sb.append(";SciCount=").append(this._storageClassInfo.length);
                sb.append(";").append(this._totalSpace.toString());
            }
            sb.append("}");
            return sb.toString();
        }

        public boolean isValid() {
            return this.wasValidAt(System.currentTimeMillis());
        }

        public boolean wasValidAt(long atThatTime) {
            return this._time > 0L && atThatTime - this._time < StorageInfoQuotaObserver.this._poolValidityTimeout;
        }

        static /* synthetic */ SpaceInfo[] access$2802(PoolSpaceInfo x0, SpaceInfo[] x1) {
            x0._storageClassInfo = x1;
            return x1;
        }
    }

    private class SpaceInfo {
        private String _name;
        private long _space;
        private long _files;
        private long _preciousSpace;
        private long _preciousFiles;
        private long _stickySpace;
        private long _stickyFiles;
        private long _removableSpace;
        private long _removableFiles;
        private long _poolTotalUsed;
        private long _poolTotalFree;

        private SpaceInfo(String name) {
            this._name = name;
        }

        private SpaceInfo(String name, long space, long files) {
            this._name = name;
            this._space = space;
            this._files = files;
        }

        public String toString() {
            return this._name + "={space=" + this._space + ";files=" + this._files + ";pSpace=" + this._preciousSpace + ";pFiles=" + this._preciousFiles + ";sSpace=" + this._stickySpace + ";sFiles=" + this._stickyFiles + ";rSpace=" + this._removableSpace + ";rFiles=" + this._removableFiles + ";used=" + this._poolTotalUsed + ";free=" + this._poolTotalFree + "}";
        }

        public void add(SpaceInfo sci) {
            if (sci == null) {
                return;
            }
            this._space += sci._space;
            this._files += sci._files;
            this._preciousSpace += sci._preciousSpace;
            this._preciousFiles += sci._preciousFiles;
            this._stickySpace += sci._stickySpace;
            this._stickyFiles += sci._stickyFiles;
            this._removableSpace += sci._removableSpace;
            this._removableFiles += sci._removableFiles;
            this._poolTotalUsed += sci._poolTotalUsed;
            this._poolTotalFree += sci._poolTotalFree;
        }
    }
}

