/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import diskCacheV111.services.space.SpaceState;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import java.io.Serializable;
import java.util.Date;

public class Space
implements Serializable {
    private static final long serialVersionUID = -1935368561781812540L;
    private long id;
    private String voGroup;
    private String voRole;
    private RetentionPolicy retentionPolicy;
    private AccessLatency accessLatency;
    private long linkGroupId;
    private long sizeInBytes;
    private long usedSizeInBytes;
    private long allocatedSpaceInBytes;
    private long creationTime;
    private long lifetime;
    private String description;
    private SpaceState state;

    public Space() {
    }

    public Space(long id, String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, long linkGroupId, long sizeInBytes, long creationTime, long lifetime, String description, SpaceState state, long used, long allocated) {
        this.setId(id);
        this.voGroup = voGroup;
        this.voRole = voRole;
        this.retentionPolicy = retentionPolicy;
        this.accessLatency = accessLatency;
        this.setLinkGroupId(linkGroupId);
        this.setSizeInBytes(sizeInBytes);
        this.setCreationTime(creationTime);
        this.setLifetime(lifetime);
        this.setDescription(description);
        this.setState(state);
        this.setUsedSizeInBytes(used);
        this.setAllocatedSpaceInBytes(allocated);
    }

    public Space(long id, String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, long linkGroupId, long sizeInBytes, long creationTime, long lifetime, String description, SpaceState state) {
        this.setId(id);
        this.voGroup = voGroup;
        this.voRole = voRole;
        this.retentionPolicy = retentionPolicy;
        this.accessLatency = accessLatency;
        this.setLinkGroupId(linkGroupId);
        this.setSizeInBytes(sizeInBytes);
        this.setCreationTime(creationTime);
        this.setLifetime(lifetime);
        this.setDescription(description);
        this.setState(state);
        this.setUsedSizeInBytes(0L);
        this.setAllocatedSpaceInBytes(0L);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getLinkGroupId() {
        return this.linkGroupId;
    }

    public void setLinkGroupId(long linkGroupId) {
        this.linkGroupId = linkGroupId;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SpaceState getState() {
        return this.state;
    }

    public void setState(SpaceState state) {
        this.state = state;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toStringBuffer(sb);
        return sb.toString();
    }

    public void toStringBuffer(StringBuffer sb) {
        sb.append(this.id).append(' ');
        sb.append("voGroup:").append(this.voGroup).append(' ');
        sb.append("voRole:").append(this.voRole).append(' ');
        sb.append("retentionPolicy:").append(this.retentionPolicy.toString()).append(' ');
        sb.append("accessLatency:").append(this.accessLatency.toString()).append(' ');
        sb.append("linkGroupId:").append(this.linkGroupId).append(' ');
        sb.append("size:").append(this.sizeInBytes).append(' ');
        sb.append("created:").append(new Date(this.creationTime)).append(' ');
        sb.append("lifetime:").append(this.lifetime).append("ms ");
        sb.append("expiration:").append(this.lifetime == -1L ? "NEVER" : new Date(this.creationTime + this.lifetime).toString()).append(' ');
        sb.append("description:").append(this.description).append(' ');
        sb.append("state:").append(this.state).append(' ');
        sb.append("used:").append(this.usedSizeInBytes).append(' ');
        sb.append("allocated:").append(this.allocatedSpaceInBytes).append(' ');
    }

    public String getVoGroup() {
        return this.voGroup;
    }

    public void setVoGroup(String voGroup) {
        this.voGroup = voGroup;
    }

    public String getVoRole() {
        return this.voRole;
    }

    public void setVoRole(String voRole) {
        this.voRole = voRole;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public void setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public AccessLatency getAccessLatency() {
        return this.accessLatency;
    }

    public void setAccessLatency(AccessLatency accessLatency) {
        this.accessLatency = accessLatency;
    }

    public long getUsedSizeInBytes() {
        return this.usedSizeInBytes;
    }

    public void setUsedSizeInBytes(long usedSizeInBytes) {
        this.usedSizeInBytes = usedSizeInBytes;
    }

    public long getAllocatedSpaceInBytes() {
        return this.allocatedSpaceInBytes;
    }

    public long getAvailableSpaceInBytes() {
        return this.sizeInBytes - this.usedSizeInBytes - this.allocatedSpaceInBytes;
    }

    public void setAllocatedSpaceInBytes(long allocated) {
        this.allocatedSpaceInBytes = allocated;
    }

    public long getExpirationTime() {
        return this.lifetime == -1L ? -1L : this.creationTime + this.lifetime;
    }
}

