/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import java.io.Serializable;

public final class ReservationState
implements Serializable {
    private static final long serialVersionUID = -8460158649607530815L;
    private final String name;
    private final int stateId;
    public static final ReservationState REQUESTED = new ReservationState("REQUESTED", 0);
    public static final ReservationState RESERVED = new ReservationState("RESERVED", 1);
    public static final ReservationState FAILED = new ReservationState("FAILED", 2);
    public static final ReservationState EXPIRED = new ReservationState("EXPIRED", 3);

    private ReservationState(String name, int stateId) {
        this.name = name;
        this.stateId = stateId;
    }

    public static ReservationState[] getAllStates() {
        return new ReservationState[]{REQUESTED, RESERVED, FAILED, EXPIRED};
    }

    public String toString() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public static ReservationState getState(String state) throws IllegalArgumentException {
        if (state == null || state.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        if (ReservationState.REQUESTED.name.equals(state)) {
            return REQUESTED;
        }
        if (ReservationState.RESERVED.name.equals(state)) {
            return RESERVED;
        }
        if (ReservationState.FAILED.name.equals(state)) {
            return FAILED;
        }
        if (ReservationState.EXPIRED.name.equals(state)) {
            return EXPIRED;
        }
        try {
            int stateId = Integer.parseInt(state);
            return ReservationState.getState(stateId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown State");
        }
    }

    public static ReservationState getState(int stateId) throws IllegalArgumentException {
        if (ReservationState.REQUESTED.stateId == stateId) {
            return REQUESTED;
        }
        if (ReservationState.RESERVED.stateId == stateId) {
            return RESERVED;
        }
        if (ReservationState.FAILED.stateId == stateId) {
            return FAILED;
        }
        if (ReservationState.EXPIRED.stateId == stateId) {
            return EXPIRED;
        }
        throw new IllegalArgumentException("Unknown State Id");
    }
}

