/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services.space;

import com.google.common.collect.Iterables;
import diskCacheV111.services.space.File;
import diskCacheV111.services.space.FileIO;
import diskCacheV111.services.space.FileState;
import diskCacheV111.services.space.LinkGroup;
import diskCacheV111.services.space.LinkGroupAuthorizationFile;
import diskCacheV111.services.space.LinkGroupAuthorizationRecord;
import diskCacheV111.services.space.LinkGroupIO;
import diskCacheV111.services.space.ManagerSchemaConstants;
import diskCacheV111.services.space.NoFreeSpaceException;
import diskCacheV111.services.space.Space;
import diskCacheV111.services.space.SpaceAuthorizationException;
import diskCacheV111.services.space.SpaceException;
import diskCacheV111.services.space.SpaceExpiredException;
import diskCacheV111.services.space.SpaceManagerAuthorizationPolicy;
import diskCacheV111.services.space.SpaceReleasedException;
import diskCacheV111.services.space.SpaceReservationIO;
import diskCacheV111.services.space.SpaceState;
import diskCacheV111.services.space.message.CancelUse;
import diskCacheV111.services.space.message.ExtendLifetime;
import diskCacheV111.services.space.message.GetFileSpaceTokensMessage;
import diskCacheV111.services.space.message.GetLinkGroupIdsMessage;
import diskCacheV111.services.space.message.GetLinkGroupNamesMessage;
import diskCacheV111.services.space.message.GetLinkGroupsMessage;
import diskCacheV111.services.space.message.GetSpaceMetaData;
import diskCacheV111.services.space.message.GetSpaceTokenIdsMessage;
import diskCacheV111.services.space.message.GetSpaceTokens;
import diskCacheV111.services.space.message.GetSpaceTokensMessage;
import diskCacheV111.services.space.message.Release;
import diskCacheV111.services.space.message.Reserve;
import diskCacheV111.services.space.message.Use;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.DBManager;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.IoPackage;
import diskCacheV111.util.Pgpass;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.util.ThreadManager;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.util.VOInfo;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsDeleteEntryNotificationMessage;
import diskCacheV111.vehicles.PoolAcceptFileMessage;
import diskCacheV111.vehicles.PoolFileFlushedMessage;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.PoolLinkGroupInfo;
import diskCacheV111.vehicles.PoolMgrGetPoolLinkGroups;
import diskCacheV111.vehicles.PoolMgrSelectWritePoolMsg;
import diskCacheV111.vehicles.PoolRemoveFilesMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.SerializationException;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.auth.FQAN;
import org.dcache.auth.GroupList;
import org.dcache.auth.Subjects;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.CellStub;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.JdbcConnectionPool;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsSetFileAttributes;
import org.dcache.vehicles.PoolManagerSelectLinkGroupForWriteMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Manager
extends AbstractCell
implements Runnable {
    private static final long EAGER_LINKGROUP_UPDATE_PERIOD = 1000L;
    private long spaceReservationCleanupPeriodInSeconds = 3600L;
    private String jdbcUrl;
    private String jdbcClass;
    private String user;
    private String pass;
    private String pwdfile;
    private long updateLinkGroupsPeriod = 180000L;
    private long currentUpdateLinkGroupsPeriod = 1000L;
    private long expireSpaceReservationsPeriod = 180000L;
    private boolean deleteStoredFileRecord;
    private String pnfsManager = "PnfsManager";
    private String poolManager = "PoolManager";
    private Thread updateLinkGroups;
    private Thread expireSpaceReservations;
    private AccessLatency defaultLatency = AccessLatency.NEARLINE;
    private RetentionPolicy defaultPolicy = RetentionPolicy.CUSTODIAL;
    private boolean reserveSpaceForNonSRMTransfers;
    private boolean returnFlushedSpaceToReservation = true;
    private boolean returnRemovedSpaceToReservation = true;
    private boolean cleanupExpiredSpaceFiles = true;
    private String linkGroupAuthorizationFileName;
    private boolean spaceManagerEnabled = true;
    private boolean matchVoGroupAndVoRole;
    public static final int currentSchemaVersion = 4;
    private int previousSchemaVersion;
    private Args _args;
    private long _poolManagerTimeout = 60L;
    private CellStub _poolManagerStub;
    private String spaceManagerAuthorizationPolicyClass = "diskCacheV111.services.space.SimpleSpaceManagerAuthorizationPolicy";
    private SpaceManagerAuthorizationPolicy authorizationPolicy;
    JdbcConnectionPool connection_pool;
    DBManager manager;
    private static Logger logger = LoggerFactory.getLogger(Manager.class);
    private static IoPackage<File> fileIO = new FileIO();
    private static IoPackage<Space> spaceReservationIO = new SpaceReservationIO();
    private static IoPackage<LinkGroup> linkGroupIO = new LinkGroupIO();
    public static final String hh_release = " <spaceToken> [ <bytes> ] # release the space reservation identified by <spaceToken>";
    public static final String hh_update_space_reservation = " [-size=<size>]  [-lifetime=<lifetime>] [-vog=<vogroup>] [-vor=<vorole>] <spaceToken> \n                                                     # set new size and/or lifetime for the space token \n                                                      # valid examples of size: 1000, 100kB, 100KB, 100KiB, 100MB, 100MiB, 100GB, 100GiB, 10.5TB, 100TiB \n                                                     # see http://en.wikipedia.org/wiki/Gigabyte for explanation \n                                                     # lifetime is in seconds (\"-1\" means infinity or permanent reservation";
    public static final String hh_update_link_groups = " #triggers update of the link groups";
    public static final String hh_ls = " [-lg=LinkGroupName] [-lgid=LinkGroupId] [-vog=vogroup] [-vor=vorole] [-desc=description] [-l] <id> # list space reservations";
    public static final String hh_ls_link_groups = " [-l] [-a]  <id> # list link groups";
    public static final String hh_ls_file_space_tokens = " <pnfsId>|<pnfsPath> # list space tokens that contain a file";
    public final String hh_reserve = "  [-vog=voGroup] [-vor=voRole] [-acclat=AccessLatency] [-retpol=RetentionPolicy] [-desc=Description]  [-lgid=LinkGroupId] [-lg=LinkGroupName] <sizeInBytes> <lifetimeInSecs (use quotes around negative one)> \n default value for AccessLatency is " + this.defaultLatency + "\n" + " default value for RetentionPolicy is " + this.defaultPolicy;
    public static final String hh_listInvalidSpaces = " [-e] [-r] <n> # e=expired, r=released, default is both, n=number of rows to retrieve";
    private static final int RELEASED = 1;
    private static final int EXPIRED = 2;
    private static final String[] badSpaceType = new String[]{"released", "expired", "released or expired"};
    public static final String SELECT_INVALID_SPACES = "SELECT * FROM " + ManagerSchemaConstants.SpaceTableName + " WHERE state = ";
    public static String SELECT_FILES_IN_SPACE = "SELECT * FROM " + ManagerSchemaConstants.SpaceFileTableName + " WHERE spaceReservationId = ?";
    public static final String hh_listFilesInSpace = " <space-id>";
    public static final String hh_removeFilesFromSpace = " [-r] [-t] [-s] [-f] -d] <Space Token># remove expired files from space, -r(reserved) -t(transferring) -s(stored) -f(flushed)";
    public static final String hh_remove_file = " -id=<file id> | -pnfsId=<pnfsId>  # remove file by spacefile id or pnfsid";
    private static final Object fixMissingSizeLock = new Object();
    private static final String SELECT_RECORDS_WITH_MISSING_SIZE = String.format("select f.* from srmspacefile f, srmspace s where f.state=%d and f.sizeinbytes=0 and f.spacereservationid=s.id and s.state=%d", FileState.STORED.getStateId(), SpaceState.RESERVED.getStateId());
    public static final String hh_fix_missing_size = "# See full help for details";
    public static final String fh_fix_missing_size = "Cleans up after a bug that was present in dCache 1.9.1-1 to 1.9.1-3. That \nbug caused files to be registered with a wrong size in the space manager.\nWarning: This command may take a long time to complete and may consume a\nlot of memory. Progress information can be found in the log file.";
    private static final String selectNextToken = "SELECT nexttoken  FROM srmspacemanagernextid";
    private static final String insertNextToken = "INSERT INTO srmspacemanagernextid (nexttoken) VALUES ( 0 )";
    private static final String selectVersion = "SELECT version FROM srmspacemanagerschemaversion";
    public static final String updateVersion = "UPDATE srmspacemanagerschemaversion SET version= 4";
    private static final String insertVersion = "INSERT INTO srmspacemanagerschemaversion (version) VALUES ( 4 )";
    private static final String alterLinkGroupTable = "ALTER TABLE " + ManagerSchemaConstants.LinkGroupTableName + " ADD COLUMN  onlineAllowed INT," + " ADD COLUMN  nearlineAllowed INT," + " ADD COLUMN  replicaAllowed INT," + " ADD COLUMN  outputAllowed INT," + " ADD COLUMN  custodialAllowed INT";
    private static final String updateLinkGroupTable = "UPDATE  " + ManagerSchemaConstants.LinkGroupTableName + "\n SET onlineAllowed = 1 ," + "\n     nearlineAllowed = 1 ," + "\n     replicaAllowed = CASE WHEN hsmType= 'None' THEN 1 ELSE 0 END," + "\n     outputAllowed = CASE WHEN hsmType= 'None' THEN 1 ELSE 0 END," + "\n     custodialAllowed = CASE WHEN hsmType= 'None' THEN 0 ELSE 1 END";
    private static final String alterLinkGroupTable1 = "ALTER TABLE " + ManagerSchemaConstants.LinkGroupTableName + " DROP  COLUMN  hsmType ";
    private static final Object createIndexLock = new Object();
    private static final String countPolicies = "SELECT count(*) from " + ManagerSchemaConstants.RetentionPolicyTableName;
    private static final String insertPolicy = "INSERT INTO " + ManagerSchemaConstants.RetentionPolicyTableName + " (id, name) VALUES (?,?)";
    private static final String countLatencies = "SELECT count(*) from " + ManagerSchemaConstants.AccessLatencyTableName;
    private static final String insertLatency = "INSERT INTO " + ManagerSchemaConstants.AccessLatencyTableName + " (id, name) VALUES (?,?)";
    public static final String selectNextIdForUpdate = "SELECT * from srmspacemanagernextid FOR UPDATE ";
    public static final long NEXT_LONG_STEP = 10000L;
    public static final String increaseNextId = "UPDATE srmspacemanagernextid SET NextToken=NextToken+10000";
    private long nextLongBase;
    private long _nextLongBase;
    private long nextLongIncrement = 10000L;
    public static final String selectLinkGroupVOs = "SELECT VOGroup,VORole FROM " + ManagerSchemaConstants.LinkGroupVOsTableName + " WHERE linkGroupId=?";
    public static final String onlineSelectionCondition = "lg.onlineallowed = 1 ";
    public static final String nearlineSelectionCondition = "lg.nearlineallowed = 1 ";
    public static final String replicaSelectionCondition = "lg.replicaallowed = 1 ";
    public static final String outputSelectionCondition = "lg.outputallowed = 1 ";
    public static final String custodialSelectionCondition = "lg.custodialAllowed = 1 ";
    public static final String voGroupSelectionCondition = " ( lgvo.VOGroup = ? OR lgvo.VOGroup = '*' ) ";
    public static final String voRoleSelectionCondition = " ( lgvo.VORole = ? OR lgvo.VORole = '*' ) ";
    public static final String spaceCondition = " lg.freespaceinbytes-lg.reservedspaceinbytes >= ? ";
    public static final String orderBy = " order by available desc ";
    public static final String selectLinkGroupInfoPart1 = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ? ";
    public static final String selectOnlineReplicaLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.onlineallowed = 1  and lg.replicaallowed = 1  and  ( lgvo.VOGroup = ? OR lgvo.VOGroup = '*' )  and  ( lgvo.VORole = ? OR lgvo.VORole = '*' )  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectOnlineOutputLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.onlineallowed = 1  and lg.outputallowed = 1  and  ( lgvo.VOGroup = ? OR lgvo.VOGroup = '*' )  and  ( lgvo.VORole = ? OR lgvo.VORole = '*' )  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectOnlineCustodialLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.onlineallowed = 1  and lg.custodialAllowed = 1  and  ( lgvo.VOGroup = ? OR lgvo.VOGroup = '*' )  and  ( lgvo.VORole = ? OR lgvo.VORole = '*' )  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectNearlineReplicaLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.nearlineallowed = 1  and lg.replicaallowed = 1  and  ( lgvo.VOGroup = ? OR lgvo.VOGroup = '*' )  and  ( lgvo.VORole = ? OR lgvo.VORole = '*' )  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectNearlineOutputLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.nearlineallowed = 1  and lg.outputallowed = 1  and  ( lgvo.VOGroup = ? OR lgvo.VOGroup = '*' )  and  ( lgvo.VORole = ? OR lgvo.VORole = '*' )  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectNearlineCustodialLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.nearlineallowed = 1  and lg.custodialAllowed = 1  and  ( lgvo.VOGroup = ? OR lgvo.VOGroup = '*' )  and  ( lgvo.VORole = ? OR lgvo.VORole = '*' )  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectAllOnlineReplicaLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.onlineallowed = 1  and lg.replicaallowed = 1  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectAllOnlineOutputLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.onlineallowed = 1  and lg.outputallowed = 1  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectAllOnlineCustodialLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.onlineallowed = 1  and lg.custodialAllowed = 1  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectAllNearlineReplicaLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.nearlineallowed = 1  and lg.replicaallowed = 1  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectAllNearlineOutputLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.nearlineallowed = 1  and lg.outputallowed = 1  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String selectAllNearlineCustodialLinkGroup = "SELECT lg.*,lg.freespaceinbytes-lg.reservedspaceinbytes as available \n from srmlinkgroup lg, srmlinkgroupvos lgvo\n where lg.id=lgvo.linkGroupId  and  lg.lastUpdateTime >= ?  and lg.nearlineallowed = 1  and lg.custodialAllowed = 1  and  lg.freespaceinbytes-lg.reservedspaceinbytes >= ?  order by available desc ";
    public static final String SELECT_SPACE_TOKENS_BY_DESCRIPTION = "SELECT * FROM " + ManagerSchemaConstants.SpaceTableName + " WHERE  state = ? AND description = ?";
    public static final String SELECT_SPACE_TOKENS_BY_VOGROUP = "SELECT * FROM " + ManagerSchemaConstants.SpaceTableName + " WHERE  state = ? AND voGroup = ?";
    public static final String SELECT_SPACE_TOKENS_BY_VOROLE = "SELECT * FROM " + ManagerSchemaConstants.SpaceTableName + " WHERE  state = ? AND  voRole = ?";
    public static final String SELECT_SPACE_TOKENS_BY_VOGROUP_AND_VOROLE = "SELECT * FROM " + ManagerSchemaConstants.SpaceTableName + " WHERE  state = ? AND voGroup = ? AND voRole = ?";
    public static final String SELECT_SPACE_FILE_BY_PNFSID = "SELECT * FROM " + ManagerSchemaConstants.SpaceFileTableName + " WHERE pnfsId = ? ";
    public static final String SELECT_SPACE_FILE_BY_PNFSPATH = "SELECT * FROM " + ManagerSchemaConstants.SpaceFileTableName + " WHERE pnfsPath = ? ";
    public static final String SELECT_SPACE_FILE_BY_PNFSID_AND_PNFSPATH = "SELECT * FROM " + ManagerSchemaConstants.SpaceFileTableName + " WHERE pnfsId = ? AND pnfsPath = ?";
    private final Object updateLinkGroupsSyncObject = new Object();
    private long latestLinkGroupUpdateTime = System.currentTimeMillis();
    private LinkGroupAuthorizationFile linkGroupAuthorizationFile;
    private long linkGroupAuthorizationFileLastUpdateTimestampt;
    private static final String INSERT_LINKGROUP_VO = "INSERT INTO " + ManagerSchemaConstants.LinkGroupVOsTableName + " ( VOGroup, VORole, linkGroupId ) VALUES ( ? , ? , ? )";
    private static final String DELETE_LINKGROUP_VO = "DELETE FROM " + ManagerSchemaConstants.LinkGroupVOsTableName + " WHERE VOGroup  = ? AND VORole = ? AND linkGroupId = ? ";

    public Manager(String name, String argString) throws InterruptedException, ExecutionException {
        super(name, argString);
        this.doInit();
    }

    @Override
    protected void init() throws Exception {
        String tmp;
        this._args = this.getArgs();
        this.jdbcUrl = this._args.getOpt("jdbcUrl");
        this.jdbcClass = this._args.getOpt("jdbcDriver");
        this.user = this._args.getOpt("dbUser");
        this.pass = this._args.getOpt("dbPass");
        this.pwdfile = this._args.getOpt("pgPass");
        String pgBasedPass = null;
        if (this.pwdfile != null && !this.pwdfile.trim().equals("")) {
            Pgpass pgpass = new Pgpass(this.pwdfile);
            pgBasedPass = pgpass.getPgpass(this.jdbcUrl, this.user);
        }
        if (pgBasedPass != null) {
            this.pass = pgBasedPass;
        }
        this.manager = DBManager.getInstance();
        this.manager.initConnectionPool(this.jdbcUrl, this.jdbcClass, this.user, this.pass);
        this.connection_pool = this.manager.getConnectionPool();
        this.spaceManagerEnabled = this.isOptionSetToTrueOrYes("spaceManagerEnabled", this.spaceManagerEnabled);
        logger.debug("spaceManagerEnabled={}", (Object)this.spaceManagerEnabled);
        if (this._args.hasOption("poolManager")) {
            this.poolManager = this._args.getOpt("poolManager");
        }
        if (this._args.hasOption("poolManagerTimeout")) {
            this._poolManagerTimeout = Long.parseLong(this._args.getOpt("poolManagerTimeout"));
        }
        if (this._args.hasOption("pnfsManager")) {
            this.pnfsManager = this._args.getOpt("pnfsManager");
        }
        if (this._args.hasOption("updateLinkGroupsPeriod")) {
            this.updateLinkGroupsPeriod = Long.parseLong(this._args.getOpt("updateLinkGroupsPeriod"));
        }
        if (this._args.hasOption("expireSpaceReservationsPeriod")) {
            this.expireSpaceReservationsPeriod = Long.parseLong(this._args.getOpt("expireSpaceReservationsPeriod"));
        }
        if (this._args.hasOption("cleanupPeriod")) {
            this.spaceReservationCleanupPeriodInSeconds = Long.parseLong(this._args.getOpt("cleanupPeriod"));
        }
        if (this._args.hasOption("defaultRetentionPolicy")) {
            this.defaultPolicy = RetentionPolicy.getRetentionPolicy((String)this._args.getOpt("defaultRetentionPolicy"));
        }
        if (this._args.hasOption("defaultAccessLatency")) {
            this.defaultLatency = AccessLatency.getAccessLatency((String)this._args.getOpt("defaultAccessLatency"));
        }
        if (this._args.hasOption("defaultAccessLatencyForSpaceReservation")) {
            this.defaultLatency = AccessLatency.getAccessLatency((String)this._args.getOpt("defaultAccessLatencyForSpaceReservation"));
        }
        if (this._args.hasOption("reserveSpaceForNonSRMTransfers")) {
            this.reserveSpaceForNonSRMTransfers = this._args.getOpt("reserveSpaceForNonSRMTransfers").equalsIgnoreCase("true");
        }
        if (this._args.hasOption("deleteStoredFileRecord")) {
            this.deleteStoredFileRecord = this._args.getOpt("deleteStoredFileRecord").equalsIgnoreCase("true");
        }
        if (this._args.hasOption("cleanupExpiredSpaceFiles")) {
            this.cleanupExpiredSpaceFiles = this._args.getOpt("cleanupExpiredSpaceFiles").equalsIgnoreCase("true");
        }
        if (this._args.hasOption("returnFlushedSpaceToReservation")) {
            this.returnFlushedSpaceToReservation = this._args.getOpt("returnFlushedSpaceToReservation").equalsIgnoreCase("true");
        }
        if (this._args.hasOption("returnRemovedSpaceToReservation")) {
            this.returnRemovedSpaceToReservation = this._args.getOpt("returnRemovedSpaceToReservation").equalsIgnoreCase("true");
        }
        if (this._args.hasOption("matchVoGroupAndVoRole")) {
            this.matchVoGroupAndVoRole = this._args.getOpt("matchVoGroupAndVoRole").equalsIgnoreCase("true");
        }
        if (this._args.hasOption("linkGroupAuthorizationFileName") && (tmp = this._args.getOpt("linkGroupAuthorizationFileName").trim()).length() > 0) {
            this.linkGroupAuthorizationFileName = tmp;
        }
        if (this.deleteStoredFileRecord && this.returnRemovedSpaceToReservation) {
            throw new IllegalArgumentException("configuration conflict: returnRemovedSpaceToReservation == true and deleteStoredFileRecord == true");
        }
        if (this._args.hasOption("spaceManagerAuthorizationPolicy")) {
            this.spaceManagerAuthorizationPolicyClass = this._args.getOpt("spaceManagerAuthorizationPolicy").trim();
        }
        this.authorizationPolicy = Class.forName(this.spaceManagerAuthorizationPolicyClass).asSubclass(SpaceManagerAuthorizationPolicy.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        this._poolManagerStub = new CellStub();
        this._poolManagerStub.setDestination(this.poolManager);
        this._poolManagerStub.setCellEndpoint((CellEndpoint)this);
        this._poolManagerStub.setTimeout(this._poolManagerTimeout * 1000L);
        this.dbinit();
        this.updateLinkGroups = new Thread((Runnable)this, "UpdateLinkGroups");
        this.updateLinkGroups.start();
        this.expireSpaceReservations = new Thread((Runnable)this, "ExpireThreadReservations");
        this.expireSpaceReservations.start();
    }

    @Override
    public void cleanUp() {
        if (this.updateLinkGroups != null) {
            this.updateLinkGroups.interrupt();
        }
        if (this.expireSpaceReservations != null) {
            this.expireSpaceReservations.interrupt();
        }
        super.cleanUp();
    }

    private boolean isOptionSetToTrueOrYes(String value, boolean default_value) {
        String tmpstr = this._args.getOpt(value);
        if (tmpstr != null) {
            return tmpstr.equalsIgnoreCase("true") || tmpstr.equalsIgnoreCase("on") || tmpstr.equalsIgnoreCase("yes") || tmpstr.equalsIgnoreCase("enabled");
        }
        return default_value;
    }

    public void getInfo(PrintWriter printWriter) {
        printWriter.println("space.Manager " + this.getCellName());
        printWriter.println("spaceManagerEnabled=" + this.spaceManagerEnabled);
        printWriter.println("JdbcUrl=" + this.jdbcUrl);
        printWriter.println("jdbcClass=" + this.jdbcClass);
        printWriter.println("databse user=" + this.user);
        printWriter.println("reservation space cleanup period in secs : " + this.spaceReservationCleanupPeriodInSeconds);
        printWriter.println("updateLinkGroupsPeriod=" + this.updateLinkGroupsPeriod);
        printWriter.println("expireSpaceReservationsPeriod=" + this.expireSpaceReservationsPeriod);
        printWriter.println("deleteStoredFileRecord=" + this.deleteStoredFileRecord);
        printWriter.println("pnfsManager=" + this.pnfsManager);
        printWriter.println("poolManager=" + this.poolManager);
        printWriter.println("defaultLatencyForSpaceReservations=" + this.defaultLatency);
        printWriter.println("reserveSpaceForNonSRMTransfers=" + this.reserveSpaceForNonSRMTransfers);
        printWriter.println("returnFlushedSpaceToReservation=" + this.returnFlushedSpaceToReservation);
        printWriter.println("returnRemovedSpaceToReservation=" + this.returnRemovedSpaceToReservation);
        printWriter.println("linkGroupAuthorizationFileName=" + this.linkGroupAuthorizationFileName);
    }

    public String ac_release_$_1_2(Args args) throws Exception {
        long reservationId = Long.parseLong(args.argv(0));
        if (args.argc() == 1) {
            this.updateSpaceState(reservationId, SpaceState.RELEASED);
            StringBuffer sb = new StringBuffer();
            Space space = this.getSpace(reservationId);
            space.toStringBuffer(sb);
            return sb.toString();
        }
        return "partial release is not supported yet";
    }

    public final long stringToSize(String s) {
        long size;
        int startIndex = 0;
        if (s.endsWith("kB") || s.endsWith("KB")) {
            String sSize;
            int endIndex = s.indexOf("KB");
            if (endIndex == -1) {
                endIndex = s.indexOf("kB");
            }
            size = (sSize = s.substring(startIndex, endIndex)).equals("") ? 1000L : (long)(Double.parseDouble(sSize) * 1000.0 + 0.5);
        } else {
            int endIndex;
            String sSize;
            size = s.endsWith("KiB") ? ((sSize = s.substring(startIndex, endIndex = s.indexOf("KiB"))).equals("") ? 1024L : (long)(Double.parseDouble(sSize) * 1024.0 + 0.5)) : (s.endsWith("MB") ? ((sSize = s.substring(startIndex, endIndex = s.indexOf("MB"))).equals("") ? 1000000L : (long)(Double.parseDouble(sSize) * 1000000.0 + 0.5)) : (s.endsWith("MiB") ? ((sSize = s.substring(startIndex, endIndex = s.indexOf("MiB"))).equals("") ? 0x100000L : (long)(Double.parseDouble(sSize) * 1048576.0 + 0.5)) : (s.endsWith("GB") ? ((sSize = s.substring(startIndex, endIndex = s.indexOf("GB"))).equals("") ? 1000000000L : (long)(Double.parseDouble(sSize) * 1.0E9 + 0.5)) : (s.endsWith("GiB") ? ((sSize = s.substring(startIndex, endIndex = s.indexOf("GiB"))).equals("") ? 0x40000000L : (long)(Double.parseDouble(sSize) * 1.073741824E9 + 0.5)) : (s.endsWith("TB") ? ((sSize = s.substring(startIndex, endIndex = s.indexOf("TB"))).equals("") ? 1000000000000L : (long)(Double.parseDouble(sSize) * 1.0E12 + 0.5)) : (s.endsWith("TiB") ? ((sSize = s.substring(startIndex, endIndex = s.indexOf("TiB"))).equals("") ? 0x10000000000L : (long)(Double.parseDouble(sSize) * 1.099511627776E12 + 0.5)) : Long.parseLong(s)))))));
        }
        if (size < 0L) {
            throw new IllegalArgumentException("size have to be non-negative");
        }
        return size;
    }

    public String ac_update_space_reservation_$_1(Args args) throws Exception {
        long reservationId = Long.parseLong(args.argv(0));
        String sSize = args.getOpt("size");
        String sLifetime = args.getOpt("lifetime");
        String voRole = args.getOpt("vor");
        String voGroup = args.getOpt("vog");
        if (sLifetime == null && sSize == null && voRole == null && voGroup == null) {
            return "Need to specify at least one option \"-lifetime\", \"-size\" \"-vog\" or \"-vor\". If -lifetime=\"-1\"  then the reservation will not expire";
        }
        Long longLifetime = null;
        if (sLifetime != null) {
            long lifetime = Long.parseLong(sLifetime);
            Long l = longLifetime = lifetime == -1L ? new Long(-1L) : new Long(lifetime * 1000L);
        }
        if (voRole != null || voGroup != null) {
            try {
                Space space = this.getSpace(reservationId);
                long lid = space.getLinkGroupId();
                LinkGroup lg = this.getLinkGroup(lid);
                boolean foundMatch = false;
                if (voGroup == null) {
                    voGroup = space.getVoGroup();
                }
                if (voRole == null) {
                    voRole = space.getVoRole();
                }
                for (VOInfo info : lg.getVOs()) {
                    if (!info.match(voGroup, voRole)) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    StringBuilder sb = new StringBuilder();
                    for (VOInfo info : lg.getVOs()) {
                        sb.append(info).append('\n');
                    }
                    throw new IllegalArgumentException("cannot change voGroup:voRole to " + voGroup + ":" + voRole + ". Supported vogroup:vorole pairs for this spacereservation\n" + sb.toString());
                }
            }
            catch (SQLException e) {
                return e.toString();
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        try {
            this.updateSpaceReservation(reservationId, voGroup, voRole, null, null, null, sSize != null ? Long.valueOf(this.stringToSize(sSize)) : null, longLifetime, null, null);
        }
        catch (SQLException e) {
            return e.toString();
        }
        StringBuffer sb = new StringBuffer();
        StringBuilder id = new StringBuilder();
        id.append(reservationId);
        this.listSpaceReservations(false, id.toString(), null, null, null, null, null, sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_update_link_groups_$_0(Args args) {
        Object object = this.updateLinkGroupsSyncObject;
        synchronized (object) {
            this.updateLinkGroupsSyncObject.notify();
        }
        return "update started";
    }

    public String ac_ls_$_0_1(Args args) throws Exception {
        String lgName = args.getOpt("lg");
        String lgid = args.getOpt("lgid");
        String voGroup = args.getOpt("vog");
        String voRole = args.getOpt("vor");
        String description = args.getOpt("desc");
        boolean isLongFormat = args.hasOption("l");
        String id = null;
        if (args.argc() == 1) {
            id = args.argv(0);
        }
        StringBuffer sb = new StringBuffer();
        if (description != null && id != null) {
            sb.append("Do not handle \"desc\" and id simultaneously\n");
            return sb.toString();
        }
        if (lgName == null && lgid == null && voGroup == null && description == null) {
            sb.append("Reservations:\n");
        }
        this.listSpaceReservations(isLongFormat, id, lgName, lgid, description, voGroup, voRole, sb);
        if (lgName == null && lgid == null && voGroup == null && description == null & id == null) {
            sb.append("\n\nLinkGroups:\n");
            this.listLinkGroups(isLongFormat, false, id, sb);
        }
        return sb.toString();
    }

    private void listSpaceReservations(boolean isLongFormat, String id, String linkGroupName, String linkGroupId, String description, String group, String role, StringBuffer sb) throws Exception {
        long lgId = 0L;
        LinkGroup lg = null;
        if (linkGroupId != null) {
            lgId = Long.parseLong(linkGroupId);
            lg = this.getLinkGroup(lgId);
        }
        if (linkGroupName != null) {
            lg = this.getLinkGroupByName(linkGroupName);
            if (lgId != 0L && lg.getId() != lgId) {
                sb.append("Cannot find LinkGroup with id=").append(linkGroupId).append(" and name=").append(linkGroupName);
                return;
            }
        }
        if (lg != null) {
            sb.append("Found LinkGroup:\n");
            lg.toStringBuffer(sb);
            sb.append("\n");
        }
        if (id != null) {
            Long longid = Long.valueOf(id);
            try {
                Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_ID, longid);
                if (spaces.isEmpty()) {
                    if (lg == null) {
                        sb.append("Space with id=").append(id).append(" not found ");
                    } else {
                        sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain space with id=").append(id);
                    }
                    return;
                }
                for (Space space : spaces) {
                    if (lg != null) {
                        if (space.getLinkGroupId() != lg.getId()) {
                            sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain space with id=").append(id);
                        }
                    } else {
                        space.toStringBuffer(sb);
                    }
                    sb.append('\n');
                }
                return;
            }
            catch (SQLException e) {
                if (lg == null) {
                    sb.append("Space with id=").append(id).append(" not found ");
                } else {
                    sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain space with id=").append(id);
                }
                return;
            }
        }
        if (linkGroupName == null && linkGroupId == null && description == null && group == null && role == null) {
            try {
                Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_CURRENT_SPACE_RESERVATIONS, new Object[0]);
                int count = spaces.size();
                long totalReserved = 0L;
                for (Space space : spaces) {
                    totalReserved += space.getSizeInBytes();
                    space.toStringBuffer(sb);
                    sb.append('\n');
                }
                sb.append("total number of reservations: ").append(count).append('\n');
                sb.append("total number of bytes reserved: ").append(totalReserved);
                return;
            }
            catch (SQLException sqle) {
                sb.append(sqle.getMessage());
                return;
            }
        }
        if (description == null && group == null && role == null && lg != null) {
            try {
                Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_LINKGROUP_ID, lg.getId());
                if (spaces.isEmpty()) {
                    sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain any space reservations\n");
                    return;
                }
                for (Space space : spaces) {
                    space.toStringBuffer(sb);
                    sb.append('\n');
                }
                return;
            }
            catch (SQLException e) {
                sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain any space reservations\n");
                return;
            }
        }
        if (description != null) {
            try {
                Set<Space> spaces = lg == null ? this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_DESC, description) : this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_DESC_AND_LINKGROUP_ID, description, lg.getId());
                if (spaces.isEmpty()) {
                    if (lg == null) {
                        sb.append("Space with description ").append(description).append(" not found ");
                    } else {
                        sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain space with description ").append(description);
                    }
                    return;
                }
                for (Space space : spaces) {
                    space.toStringBuffer(sb);
                    sb.append('\n');
                }
                return;
            }
            catch (SQLException e) {
                if (lg == null) {
                    sb.append("Space with description ").append(description).append(" not found ");
                } else {
                    sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain space with description ").append(description);
                }
                return;
            }
        }
        if (role != null && group != null) {
            try {
                Set<Space> spaces = lg == null ? this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_VOGROUP_AND_VOROLE, group, role) : this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_VOGROUP_AND_VOROLE_AND_LINKGROUP_ID, group, role, lg.getId());
                if (spaces.isEmpty()) {
                    if (lg == null) {
                        sb.append("Space with vorole ").append(role).append(" and vogroup ").append(group).append(" not found ");
                    } else {
                        sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain space with vorole ").append(role).append(" and vogroup ").append(group);
                    }
                    return;
                }
                for (Space space : spaces) {
                    space.toStringBuffer(sb);
                    sb.append('\n');
                }
                return;
            }
            catch (SQLException e) {
                if (lg == null) {
                    sb.append("Space with vorole ").append(role).append(" and vogroup ").append(group).append(" not found ");
                } else {
                    sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(lg.getName()).append(" does not contain space with vorole ").append(role).append(" and vogroup ").append(group);
                }
                return;
            }
        }
        if (group != null) {
            try {
                Set<Space> spaces = lg == null ? this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_VOGROUP, group) : this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_VOGROUP_AND_LINKGROUP_ID, group, lg.getId());
                if (spaces.isEmpty()) {
                    if (lg == null) {
                        sb.append("Space with vogroup ").append(group).append(" not found ");
                    } else {
                        sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(" does not contain space with vogroup=").append(group);
                    }
                    return;
                }
                for (Space space : spaces) {
                    space.toStringBuffer(sb);
                    sb.append('\n');
                }
                return;
            }
            catch (SQLException e) {
                if (lg == null) {
                    sb.append("Space with vogroup ").append(group).append(" not found ");
                } else {
                    sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(" does not contain space with vogroup=").append(group);
                }
                return;
            }
        }
        if (role != null) {
            try {
                Set<Space> spaces = lg == null ? this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_VOROLE, group) : this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_VOROLE_AND_LINKGROUP_ID, group, lg.getId());
                if (spaces.isEmpty()) {
                    if (lg == null) {
                        sb.append("Space with vogroup ").append(group).append(" not found ");
                    } else {
                        sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(" does not contain space with vorole=").append(role);
                    }
                    return;
                }
                for (Space space : spaces) {
                    space.toStringBuffer(sb);
                    sb.append('\n');
                }
            }
            catch (SQLException e) {
                if (lg == null) {
                    sb.append("Space with vogroup ").append(group).append(" not found ");
                }
                sb.append("LinkGroup with id=").append(lg.getId()).append(" and name=").append(" does not contain space with vorole=").append(role);
            }
        }
    }

    private void listLinkGroups(boolean isLongFormat, boolean all, String id, StringBuffer sb) {
        if (id != null) {
            long longid = Long.parseLong(id);
            try {
                LinkGroup lg = this.getLinkGroup(longid);
                lg.toStringBuffer(sb);
                sb.append('\n');
                return;
            }
            catch (SQLException e) {
                sb.append("LinkGroup  with id=").append(id).append(" not found ");
                return;
            }
        }
        try {
            Set<LinkGroup> groups = all ? this.manager.selectPrepared(linkGroupIO, LinkGroupIO.SELECT_ALL_LINKGROUPS, new Object[0]) : this.manager.selectPrepared(linkGroupIO, LinkGroupIO.SELECT_CURRENT_LINKGROUPS, this.latestLinkGroupUpdateTime);
            int count = groups.size();
            long totalReservable = 0L;
            long totalReserved = 0L;
            for (LinkGroup g : groups) {
                totalReservable += g.getAvailableSpaceInBytes();
                totalReserved += g.getReservedSpaceInBytes();
                g.toStringBuffer(sb);
                sb.append('\n');
            }
            sb.append("total number of linkGroups: ").append(count).append('\n');
            sb.append("total number of bytes reservable: ").append(totalReservable).append('\n');
            sb.append("total number of bytes reserved  : ").append(totalReserved).append('\n');
            sb.append("last time all link groups were updated: ").append(new Date(this.latestLinkGroupUpdateTime).toString()).append("(").append(this.latestLinkGroupUpdateTime).append(")");
        }
        catch (SQLException sqle) {
            sb.append(sqle.getMessage());
        }
    }

    public String ac_ls_link_groups_$_0_1(Args args) {
        boolean isLongFormat = args.hasOption("l");
        boolean all = args.hasOption("a");
        String id = null;
        if (args.argc() == 1) {
            id = args.argv(0);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n\nLinkGroups:\n");
        this.listLinkGroups(isLongFormat, all, id, sb);
        return sb.toString();
    }

    public String ac_ls_file_space_tokens_$_1(Args args) throws Exception {
        PnfsId pnfsId;
        String pnfsPath = args.argv(0);
        try {
            pnfsId = new PnfsId(pnfsPath);
            pnfsPath = null;
        }
        catch (Exception e) {
            pnfsId = null;
        }
        StringBuilder sb = new StringBuilder();
        long[] tokens = this.getFileSpaceTokens(pnfsId, pnfsPath);
        if (tokens != null && tokens.length > 0) {
            for (long token : tokens) {
                sb.append('\n').append(token);
            }
        } else {
            sb.append("\nno space tokens found for file:").append(args.argv(0));
        }
        return sb.toString();
    }

    public String ac_reserve_$_2(Args args) throws Exception {
        long reservationId;
        long sizeInBytes;
        try {
            sizeInBytes = this.stringToSize(args.argv(0));
        }
        catch (Exception e) {
            return "Cannot convert size specified (" + args.argv(0) + ") to non-negative number. \n" + "Valid definition of size:\n" + "\t\t - a number of bytes (long integer less than 2^64) \n" + "\t\t - 100kB, 100KB, 100KiB, 100MB, 100MiB, 100GB, 100GiB, 10.5TB, 100TiB \n" + "see http://en.wikipedia.org/wiki/Gigabyte for explanation";
        }
        long lifetime = Long.parseLong(args.argv(1));
        if (lifetime > 0L) {
            lifetime *= 1000L;
        }
        String voGroup = args.getOpt("vog");
        String voRole = args.getOpt("vor");
        String description = args.getOpt("desc");
        String latencyString = args.getOpt("acclat");
        String policyString = args.getOpt("retpol");
        AccessLatency latency = latencyString == null ? this.defaultLatency : AccessLatency.getAccessLatency((String)latencyString);
        RetentionPolicy policy = policyString == null ? this.defaultPolicy : RetentionPolicy.getRetentionPolicy((String)policyString);
        String lgIdString = args.getOpt("lgid");
        String lgName = args.getOpt("lg");
        if (lgIdString != null && lgName != null) {
            return "Error: both exclusive options -lg and -lgid are specified";
        }
        if (lgIdString == null && lgName == null) {
            try {
                reservationId = this.reserveSpace(voGroup, voRole, sizeInBytes, latency, policy, lifetime, description);
            }
            catch (Exception e) {
                return "Failed to find likgroup taht can accommodate this space reservation. \n" + e.getMessage() + '\n' + "check that you have any link groups that satisfy the following criteria: \n" + "\t can fit the size you are requesting (" + sizeInBytes + ")\n" + "\t vogroup,vorole you specified (" + voGroup + "," + voRole + ") are allowed, and \n" + "\t retention policy and access latency you specified (" + policyString + "," + latencyString + ") are allowed \n";
            }
        } else {
            Long[] linkGroups;
            LinkGroup lg;
            long lgId;
            if (lgIdString != null) {
                lgId = Long.parseLong(lgIdString);
                lg = this.getLinkGroup(lgId);
                if (lg == null) {
                    return "Error, could not find link group with id = " + lgIdString + '\n';
                }
            } else {
                lg = this.getLinkGroupByName(lgName);
                if (lg == null) {
                    return "Error, could not find link group with name = '" + lgName + "'\n";
                }
                lgId = lg.getId();
            }
            if ((linkGroups = this.findLinkGroupIds(sizeInBytes, voGroup, voRole, latency, policy)).length == 0) {
                return "Link Group " + lg + " is found, but it cannot accommodate the reservation requested, \n" + "check that the link group satisfies the following criteria: \n" + "\t it can fit the size you are requesting (" + sizeInBytes + ")\n" + "\t vogroup,vorole you specified (" + voGroup + "," + voRole + ") are allowed, and \n" + "\t retention policy and access latency you specified (" + policyString + "," + latencyString + ") are allowed \n";
            }
            boolean yes = false;
            for (Long linkGroup : linkGroups) {
                if (linkGroup != lgId) continue;
                yes = true;
                break;
            }
            if (!yes) {
                return "Link Group " + lg + " is found, but it cannot accommodate the reservation requested, \n" + "check that the link group satisfies the following criteria: \n" + "\t it can fit the size you are requesting (" + sizeInBytes + ")\n" + "\t vogroup,vorole you specified (" + voGroup + "," + voRole + ") are allowed, and \n" + "\t retention policy and access latency you specified (" + policyString + "," + latencyString + ") are allowed \n";
            }
            reservationId = this.reserveSpaceInLinkGroup(lgId, voGroup, voRole, sizeInBytes, latency, policy, lifetime, description);
        }
        StringBuffer sb = new StringBuffer();
        Space space = this.getSpace(reservationId);
        space.toStringBuffer(sb);
        return sb.toString();
    }

    public String ac_listInvalidSpaces_$_0_3(Args args) throws Exception {
        int argCount = args.optc();
        boolean doExpired = args.hasOption("e");
        boolean doReleased = args.hasOption("r");
        int nRows = 1000;
        if (args.argc() > 0) {
            nRows = Integer.parseInt(args.argv(0));
        }
        if (nRows < 0) {
            return "number of rows must be non-negative";
        }
        int listOptions = 3;
        if (doExpired || doReleased) {
            listOptions = 0;
            if (doExpired) {
                listOptions = 2;
                --argCount;
            }
            if (doReleased) {
                listOptions |= 1;
                --argCount;
            }
        }
        if (argCount != 0) {
            return "Unrecognized option.\nUsage: listInvalidSpaces [-e] [-r] <n> # e=expired, r=released, default is both, n=number of rows to retrieve";
        }
        List<Space> expiredSpaces = this.listInvalidSpaces(listOptions, nRows);
        if (expiredSpaces.isEmpty()) {
            return "There are no " + badSpaceType[listOptions - 1] + " spaces.";
        }
        StringBuilder report = new StringBuilder();
        for (Space es : expiredSpaces) {
            report.append(es.toString()).append('\n');
        }
        return report.toString();
    }

    public List<Space> listInvalidSpaces(int spaceTypes, int nRows) throws SQLException, Exception {
        String query;
        switch (spaceTypes) {
            case 2: {
                query = SELECT_INVALID_SPACES + SpaceState.EXPIRED.getStateId();
                break;
            }
            case 1: {
                query = SELECT_INVALID_SPACES + SpaceState.RELEASED.getStateId();
                break;
            }
            case 3: {
                query = SELECT_INVALID_SPACES + SpaceState.EXPIRED.getStateId() + " OR state = " + SpaceState.RELEASED.getStateId();
                break;
            }
            default: {
                String msg = "listInvalidSpaces: got invalid space type " + spaceTypes;
                throw new Exception(msg);
            }
        }
        Connection con = null;
        ArrayList<Space> result = new ArrayList<Space>();
        try {
            con = this.connection_pool.getConnection();
            logger.debug("executing statement: {}", (Object)query);
            PreparedStatement sqlStatement = con.prepareStatement(query);
            con.setAutoCommit(false);
            sqlStatement.setFetchSize(10000);
            sqlStatement.setMaxRows(nRows);
            ResultSet set = sqlStatement.executeQuery();
            while (set.next()) {
                Space space = new Space(set.getLong("id"), set.getString("voGroup"), set.getString("voRole"), RetentionPolicy.getRetentionPolicy((int)set.getInt("retentionPolicy")), AccessLatency.getAccessLatency((int)set.getInt("accessLatency")), set.getLong("linkGroupId"), set.getLong("sizeInBytes"), set.getLong("creationTime"), set.getLong("lifetime"), set.getString("description"), SpaceState.getState(set.getInt("state")), set.getLong("usedspaceinbytes"), set.getLong("allocatedspaceinbytes"));
                result.add(space);
            }
            set.close();
            sqlStatement.close();
            this.connection_pool.returnConnection(con);
            con = null;
        }
        catch (SQLException sqe) {
            if (con != null) {
                con.rollback();
                this.connection_pool.returnFailedConnection(con);
                con = null;
            }
            throw sqe;
        }
        finally {
            if (con != null) {
                this.connection_pool.returnConnection(con);
            }
        }
        return result;
    }

    public String ac_listFilesInSpace_$_1(Args args) throws Exception {
        long spaceId = Long.parseLong(args.argv(0));
        List<File> filesInSpace = this.listFilesInSpace(spaceId);
        if (filesInSpace.isEmpty()) {
            return "There are no files in this space.";
        }
        StringBuilder report = new StringBuilder();
        for (File file : filesInSpace) {
            report.append(file.toString()).append('\n');
        }
        return report.toString();
    }

    public List<File> listFilesInSpace(long spaceId) throws SQLException {
        Set<File> set = this.manager.selectPrepared(fileIO, FileIO.SELECT_BY_SPACERESERVATION_ID, spaceId);
        ArrayList<File> result = new ArrayList<File>(set);
        return result;
    }

    public String ac_removeFilesFromSpace_$_1_4(Args args) throws Exception {
        long spaceId = Long.parseLong(args.argv(0));
        int optCount = args.optc();
        StringBuilder sb = new StringBuilder();
        if (optCount == 0) {
            sb.append("No option specified, will remove expired RESERVED and TRANSFERRING files\n");
        }
        boolean doReserved = args.hasOption("r");
        boolean doTransferring = args.hasOption("t");
        boolean doStored = args.hasOption("s");
        boolean doFlushed = args.hasOption("f");
        Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_ID, spaceId);
        if (spaces.isEmpty()) {
            sb.append("Space with ").append(spaceId).append(" does not exist\n");
            return sb.toString();
        }
        for (Space space : spaces) {
            Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_EXPIRED_SPACEFILES1, System.currentTimeMillis(), space.getId());
            for (File file : files) {
                if (optCount == 0 ? file.getState() == FileState.STORED || file.getState() == FileState.FLUSHED : !doReserved && file.getState() == FileState.RESERVED || !doTransferring && file.getState() == FileState.TRANSFERRING || !doStored && file.getState() == FileState.STORED || !doFlushed && file.getState() == FileState.FLUSHED) continue;
                try {
                    this.removeFileFromSpace(file.getId());
                }
                catch (SQLException e) {
                    sb.append("Failed to remove file ").append(file).append("\n");
                    logger.warn("failed to remove file {}: {}", (Object)file, (Object)e.getMessage());
                }
            }
        }
        return sb.toString();
    }

    public String ac_remove_file(Args args) throws Exception {
        String sid = args.getOpt("id");
        String sPnfsId = args.getOpt("pnfsId");
        if (sid != null && sPnfsId != null) {
            return "do not handle \"-id\" and \"-pnfsId\" options simultaneously";
        }
        if (sid != null) {
            long id = Long.parseLong(sid);
            this.removeFileFromSpace(id);
            return "removed file with id=" + id;
        }
        if (sPnfsId != null) {
            PnfsId pnfsId = new PnfsId(sPnfsId);
            File f = this.getFile(pnfsId);
            this.removeFileFromSpace(f.getId());
            return "removed file with pnfsId=" + pnfsId;
        }
        return "please specify  \"-id=\" or \"-pnfsId=\" option";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixMissingSize() {
        Object object = fixMissingSizeLock;
        synchronized (object) {
            try {
                PnfsHandler pnfs = new PnfsHandler(new CellPath(this.pnfsManager));
                pnfs.setCellEndpoint((CellEndpoint)this);
                logger.info("fix missing size: Searching for files...");
                Set<File> files = this.manager.select(fileIO, SELECT_RECORDS_WITH_MISSING_SIZE);
                int counter = 0;
                for (File file : files) {
                    if (counter % 1000 == 0) {
                        logger.info("fix missing size: Processed {} of {} files.", (Object)counter, (Object)files.size());
                    }
                    long size = pnfs.getFileAttributes(file.getPnfsId(), EnumSet.of(FileAttribute.SIZE)).getSize();
                    this.updateSpaceFile(file.getId(), null, null, null, size, null, null);
                    ++counter;
                }
                logger.info("fix missing size: Done");
            }
            catch (CacheException | SQLException e) {
                logger.error("failed to fix missing size: {}", (Object)e.getMessage());
            }
        }
    }

    public String ac_fix_missing_size(Args args) {
        new Thread(){

            @Override
            public void run() {
                Manager.this.fixMissingSize();
            }
        }.start();
        return "Command is executed in a background thread.";
    }

    private void dbinit() throws SQLException {
        logger.debug("WE ARE IN DBINIT");
        String[] tables = new String[]{"srmspacemanagerschemaversion", "srmspacemanagernextid", ManagerSchemaConstants.LinkGroupTableName, ManagerSchemaConstants.LinkGroupVOsTableName, ManagerSchemaConstants.RetentionPolicyTableName, ManagerSchemaConstants.AccessLatencyTableName, ManagerSchemaConstants.SpaceTableName, ManagerSchemaConstants.SpaceFileTableName};
        String[] createTables = new String[]{"CREATE TABLE srmspacemanagerschemaversion ( version  INTEGER  )", "CREATE TABLE srmspacemanagernextid ( NextToken  BIGINT  )", ManagerSchemaConstants.CreateLinkGroupTable, ManagerSchemaConstants.CreateLinkGroupVOsTable, ManagerSchemaConstants.CreateRetentionPolicyTable, ManagerSchemaConstants.CreateAccessLatencyTable, ManagerSchemaConstants.CreateSpaceTable, ManagerSchemaConstants.CreateSpaceFileTable};
        Hashtable<String, Boolean> created = new Hashtable<String, Boolean>();
        for (int i = 0; i < tables.length; ++i) {
            String table = tables[i];
            created.put(table, Boolean.FALSE);
            try {
                if (this.manager.hasTable(table)) {
                    logger.info("presence of table \"{}\" verified", (Object)table);
                    continue;
                }
                this.manager.createTable(table, createTables[i]);
                created.put(table, Boolean.TRUE);
                continue;
            }
            catch (SQLException e) {
                logger.error("verfying table {} failed: {}", (Object)table, (Object)e.getMessage());
            }
        }
        this.updateSchemaVersion(created);
        Object obj = this.manager.selectPrepared(1, selectNextToken, new Object[0]);
        if (obj == null) {
            this.manager.insert(insertNextToken, new Object[0]);
        }
        this.insertRetentionPolicies();
        this.insertAccessLatencies();
    }

    private void updateSchemaVersion(Map<String, Boolean> created) throws SQLException {
        if (!created.get("srmspacemanagerschemaversion").booleanValue()) {
            Object o = this.manager.selectPrepared(1, selectVersion, new Object[0]);
            if (o != null) {
                this.previousSchemaVersion = (Integer)o;
                if (this.previousSchemaVersion < 4) {
                    this.manager.update(updateVersion, new Object[0]);
                }
            } else {
                created.put("srmspacemanagerschemaversion", Boolean.TRUE);
            }
        }
        if (created.get("srmspacemanagerschemaversion").booleanValue()) {
            this.manager.insert(insertVersion, new Object[0]);
            this.previousSchemaVersion = created.get(ManagerSchemaConstants.LinkGroupTableName) != false ? 4 : 0;
        }
        if (this.previousSchemaVersion == 4) {
            this.manager.createIndexes(ManagerSchemaConstants.SpaceFileTableName, "spacereservationid", "state", "pnfspath", "pnfsid", "creationtime", "lifetime");
            this.manager.createIndexes(ManagerSchemaConstants.SpaceTableName, "linkgroupid", "state", "description", "lifetime", "creationtime");
            return;
        }
        try {
            this.updateSchema();
        }
        catch (SQLException e) {
            logger.error("failed to update schema from {} to {}: {}", new Object[]{this.previousSchemaVersion, 4, e.getMessage()});
        }
    }

    private void updateSchema() throws SQLException {
        if (this.previousSchemaVersion == 4) {
            return;
        }
        logger.info("updating Schema, previous schema version number={}, updating to current version number {}", (Object)this.previousSchemaVersion, (Object)4);
        if (this.previousSchemaVersion == 0) {
            this.manager.batchUpdates(alterLinkGroupTable, updateLinkGroupTable, alterLinkGroupTable1);
            this.previousSchemaVersion = 1;
        }
        if (this.previousSchemaVersion == 1) {
            this.manager.batchUpdates("ALTER TABLE " + ManagerSchemaConstants.LinkGroupTableName + " ADD COLUMN  reservedspaceinbytes BIGINT", "ALTER TABLE " + ManagerSchemaConstants.SpaceTableName + " ADD COLUMN  usedspaceinbytes      BIGINT," + " ADD COLUMN  allocatedspaceinbytes  BIGINT");
            this.manager.createIndexes(ManagerSchemaConstants.SpaceFileTableName, "spacereservationid", "state", "pnfspath", "pnfsid", "creationtime", "lifetime");
            this.manager.createIndexes(ManagerSchemaConstants.SpaceTableName, "linkgroupid", "state", "description", "lifetime", "creationtime");
            try {
                Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_CURRENT_SPACE_RESERVATIONS, new Object[0]);
                for (Space space : spaces) {
                    try {
                        this.manager.update(" update srmspace set usedspaceinbytes=(  select coalesce(sum(sf.sizeinbytes),0)  from srmspace s left outer join srmspacefile sf on  s.id=sf.spacereservationid and sf.state=2 and s.id=?), allocatedspaceinbytes= ( select coalesce(sum(sf.sizeinbytes),0)  from srmspace s left outer join srmspacefile sf on  s.id=sf.spacereservationid and sf.state<2 and s.id=?) where srmspace.id=?", space.getId(), space.getId(), space.getId());
                    }
                    catch (SQLException e) {
                        logger.error("failed to execute {},?={}: {}", new Object[]{" update srmspace set usedspaceinbytes=(  select coalesce(sum(sf.sizeinbytes),0)  from srmspace s left outer join srmspacefile sf on  s.id=sf.spacereservationid and sf.state=2 and s.id=?), allocatedspaceinbytes= ( select coalesce(sum(sf.sizeinbytes),0)  from srmspace s left outer join srmspacefile sf on  s.id=sf.spacereservationid and sf.state<2 and s.id=?) where srmspace.id=?", space.getId(), e.getMessage()});
                    }
                }
            }
            catch (SQLException e) {
                logger.error("selectPrepare failed: {}", (Object)e.getMessage());
            }
            try {
                Set<LinkGroup> groups = this.manager.selectPrepared(new LinkGroupIO(), LinkGroupIO.SELECT_ALL, new Object[0]);
                for (LinkGroup group : groups) {
                    try {
                        this.manager.update(" update srmlinkgroup set reservedspaceinbytes=(  select coalesce(sum(s.sizeinbytes-s.usedspaceinbytes),0)  from srmlinkgroup lg left outer join srmspace s on  s.linkGroupId=lg.id and lg.id=? and s.state=0) where  srmlinkgroup.id=?", group.getId(), group.getId());
                    }
                    catch (SQLException e) {
                        logger.error("failed to execute {},?={}: {}", new Object[]{" update srmlinkgroup set reservedspaceinbytes=(  select coalesce(sum(s.sizeinbytes-s.usedspaceinbytes),0)  from srmlinkgroup lg left outer join srmspace s on  s.linkGroupId=lg.id and lg.id=? and s.state=0) where  srmlinkgroup.id=?", group.getId(), e.getMessage()});
                    }
                }
            }
            catch (SQLException e) {
                logger.error("selectPrepare failed: {}", (Object)e.getMessage());
            }
            this.previousSchemaVersion = 2;
        }
        if (this.previousSchemaVersion == 2) {
            this.manager.batchUpdates("ALTER TABLE " + ManagerSchemaConstants.SpaceFileTableName + " ADD COLUMN  deleted INTEGER");
            this.previousSchemaVersion = 3;
        }
        if (this.previousSchemaVersion == 3) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = createIndexLock;
                    synchronized (object) {
                        try {
                            Manager.this.manager.createIndexes(ManagerSchemaConstants.SpaceFileTableName, "pnfspath,state");
                        }
                        catch (SQLException e) {
                            logger.error("failed to create index on table {} columns , \"pnfspath,state\": {}", (Object)ManagerSchemaConstants.SpaceFileTableName, (Object)e.getMessage());
                        }
                    }
                }
            }.start();
            this.previousSchemaVersion = 4;
        }
    }

    private void insertRetentionPolicies() throws SQLException {
        RetentionPolicy[] policies = RetentionPolicy.getAllPolicies();
        Object o = this.manager.selectPrepared(1, countPolicies, new Object[0]);
        if (o != null && (Long)o == (long)policies.length) {
            return;
        }
        for (RetentionPolicy policy : policies) {
            try {
                this.manager.insert(insertPolicy, policy.getId(), policy.toString());
            }
            catch (SQLException sqle) {
                logger.error("insert retention policy {} failed: {}", (Object)policy, (Object)sqle.getMessage());
            }
        }
    }

    private void insertAccessLatencies() throws SQLException {
        AccessLatency[] latencies = AccessLatency.getAllLatencies();
        Object o = this.manager.selectPrepared(1, countLatencies, new Object[0]);
        if (o != null && (Long)o == (long)latencies.length) {
            return;
        }
        for (AccessLatency latency : latencies) {
            try {
                this.manager.insert(insertLatency, latency.getId(), latency.toString());
            }
            catch (SQLException sqle) {
                logger.error("insert access latency {} failed: {}", (Object)latency, (Object)sqle.getMessage());
            }
        }
    }

    public synchronized long getNextToken() {
        if (this.nextLongIncrement >= 10000L) {
            this.nextLongIncrement = 0L;
            this.incrementNextLongBase();
        }
        long nextLong = this.nextLongBase + this.nextLongIncrement++;
        logger.debug("return nextLong={}", (Object)nextLong);
        return nextLong;
    }

    public synchronized long getNextToken(Connection connection) {
        if (this.nextLongIncrement >= 10000L) {
            this.nextLongIncrement = 0L;
            try {
                this.incrementNextLongBase(connection);
            }
            catch (SQLException e) {
                logger.error("incrementNextLongBase failed: {}", (Object)e.getMessage());
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.nextLongBase = this._nextLongBase;
            }
            this._nextLongBase = this.nextLongBase + 10000L;
        }
        long nextLong = this.nextLongBase + this.nextLongIncrement++;
        logger.debug("return nextLong={}", (Object)nextLong);
        return nextLong;
    }

    private void incrementNextLongBase(Connection connection) throws SQLException {
        PreparedStatement s = connection.prepareStatement(selectNextIdForUpdate);
        logger.debug("getNextToken trying {}", (Object)selectNextIdForUpdate);
        ResultSet set = s.executeQuery();
        if (!set.next()) {
            s.close();
            throw new SQLException("table srmspacemanagernextid is empty!!!", "02000");
        }
        this.nextLongBase = set.getLong(1);
        s.close();
        logger.debug("nextLongBase is = {}", (Object)this.nextLongBase);
        s = connection.prepareStatement(increaseNextId);
        logger.debug("executing statement: {}", (Object)increaseNextId);
        int i = s.executeUpdate();
        s.close();
        connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNextLongBase() {
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            this.incrementNextLongBase(connection);
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            this.nextLongBase = this._nextLongBase;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
        this._nextLongBase = this.nextLongBase + 10000L;
    }

    private Long[] findLinkGroupIds(long sizeInBytes, String voGroup, String voRole, AccessLatency al, RetentionPolicy rp) throws SQLException {
        try {
            logger.debug("findLinkGroupIds(sizeInBytes={}, voGroup={} voRole={}, AccessLatency={}, RetentionPolicy={})", new Object[]{sizeInBytes, voGroup, voRole, al, rp});
            String select = al.equals((Object)AccessLatency.ONLINE) ? (rp.equals((Object)RetentionPolicy.REPLICA) ? selectOnlineReplicaLinkGroup : (rp.equals((Object)RetentionPolicy.OUTPUT) ? selectOnlineOutputLinkGroup : selectOnlineCustodialLinkGroup)) : (rp.equals((Object)RetentionPolicy.REPLICA) ? selectNearlineReplicaLinkGroup : (rp.equals((Object)RetentionPolicy.OUTPUT) ? selectNearlineOutputLinkGroup : selectNearlineCustodialLinkGroup));
            logger.debug("executing statement: {}?={}?={}?={}?={}", new Object[]{select, this.latestLinkGroupUpdateTime, voGroup, voRole, sizeInBytes});
            Set<LinkGroup> groups = this.manager.selectPrepared(linkGroupIO, select, this.latestLinkGroupUpdateTime, voGroup, voRole, sizeInBytes);
            ArrayList<Long> idlist = new ArrayList<Long>();
            for (LinkGroup group : groups) {
                idlist.add(group.getId());
            }
            return idlist.toArray(new Long[idlist.size()]);
        }
        catch (SQLException sqle) {
            logger.error("select failed: {}", (Object)sqle.getMessage());
            throw sqle;
        }
    }

    private Set<LinkGroup> findLinkGroupIds(long sizeInBytes, AccessLatency al, RetentionPolicy rp) throws SQLException {
        try {
            logger.debug("findLinkGroupIds(sizeInBytes={}, AccessLatency={}, RetentionPolicy={})", new Object[]{sizeInBytes, al, rp});
            String select = al.equals((Object)AccessLatency.ONLINE) ? (rp.equals((Object)RetentionPolicy.REPLICA) ? selectAllOnlineReplicaLinkGroup : (rp.equals((Object)RetentionPolicy.OUTPUT) ? selectAllOnlineOutputLinkGroup : selectAllOnlineCustodialLinkGroup)) : (rp.equals((Object)RetentionPolicy.REPLICA) ? selectAllNearlineReplicaLinkGroup : (rp.equals((Object)RetentionPolicy.OUTPUT) ? selectAllNearlineOutputLinkGroup : selectAllNearlineCustodialLinkGroup));
            logger.debug("executing statement: {} ?={}?={}", new Object[]{select, this.latestLinkGroupUpdateTime, sizeInBytes});
            Set<LinkGroup> groups = this.manager.selectPrepared(linkGroupIO, select, this.latestLinkGroupUpdateTime, sizeInBytes);
            return groups;
        }
        catch (SQLException sqle) {
            logger.error("select failed: {}", (Object)sqle.getMessage());
            throw sqle;
        }
    }

    public Space getSpace(long id) throws SQLException {
        logger.debug("Executing: {},?={}", (Object)SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_ID, (Object)id);
        Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATION_BY_ID, id);
        if (spaces.isEmpty()) {
            throw new SQLException("space reservation with id=" + id + " not found", "02000");
        }
        return (Space)Iterables.getFirst(spaces, null);
    }

    public LinkGroup getLinkGroup(long id) throws SQLException {
        Set<LinkGroup> groups = this.manager.selectPrepared(linkGroupIO, LinkGroupIO.SELECT_LINKGROUP_BY_ID, id);
        if (groups.isEmpty()) {
            throw new SQLException("linkGroup with id=" + id + " not found", "02000");
        }
        return (LinkGroup)Iterables.getFirst(groups, null);
    }

    public LinkGroup getLinkGroupByName(String name) throws SQLException {
        Set<LinkGroup> groups = this.manager.selectPrepared(linkGroupIO, LinkGroupIO.SELECT_LINKGROUP_BY_NAME, name);
        if (groups.isEmpty()) {
            throw new SQLException("linkGroup with name=" + name + " not found", "02000");
        }
        return (LinkGroup)Iterables.getFirst(groups, null);
    }

    @Nonnull
    public LinkGroup selectLinkGroupForUpdate(Connection connection, long id, long sizeInBytes) throws SQLException {
        try {
            return this.manager.selectForUpdate(connection, linkGroupIO, LinkGroupIO.SELECT_LINKGROUP_INFO_FOR_UPDATE, id, sizeInBytes);
        }
        catch (SQLException e) {
            if (Objects.equals(e.getSQLState(), "02000")) {
                throw new SQLException("There is no linkgroup with id=" + id + " and available space=" + sizeInBytes, e.getSQLState(), e.getErrorCode(), e);
            }
            throw e;
        }
    }

    @Nonnull
    public LinkGroup selectLinkGroupForUpdate(Connection connection, long id) throws SQLException {
        try {
            return this.manager.selectForUpdate(connection, linkGroupIO, LinkGroupIO.SELECT_LINKGROUP_FOR_UPDATE_BY_ID, id);
        }
        catch (SQLException e) {
            if (Objects.equals(e.getSQLState(), "02000")) {
                throw new SQLException("There is no linkgroup with id=" + id, e.getSQLState(), e.getErrorCode(), e);
            }
            throw e;
        }
    }

    @Nonnull
    public Space selectSpaceForUpdate(Connection connection, long id, long sizeInBytes) throws SQLException {
        try {
            return this.manager.selectForUpdate(connection, spaceReservationIO, SpaceReservationIO.SELECT_FOR_UPDATE_BY_ID_AND_SIZE, id, sizeInBytes);
        }
        catch (SQLException e) {
            if (Objects.equals(e.getSQLState(), "02000")) {
                throw new SQLException("There is no space reservation with id=" + id + " and available size=" + sizeInBytes, e.getSQLState(), e.getErrorCode(), e);
            }
            throw e;
        }
    }

    @Nonnull
    public Space selectSpaceForUpdate(Connection connection, long id) throws SQLException {
        try {
            return this.manager.selectForUpdate(connection, spaceReservationIO, SpaceReservationIO.SELECT_FOR_UPDATE_BY_ID, id);
        }
        catch (SQLException e) {
            if (Objects.equals(e.getSQLState(), "02000")) {
                throw new SQLException("There is no space reservation with id=" + id, e.getSQLState(), e.getErrorCode(), e);
            }
            throw e;
        }
    }

    @Nonnull
    public File selectFileForUpdate(Connection connection, PnfsId pnfsId) throws SQLException {
        try {
            return this.manager.selectForUpdate(connection, fileIO, FileIO.SELECT_FOR_UPDATE_BY_PNFSID, pnfsId.toString());
        }
        catch (SQLException e) {
            if (Objects.equals(e.getSQLState(), "02000")) {
                throw new SQLException("There is no file with pnfsid=" + pnfsId, e.getSQLState(), e.getErrorCode(), e);
            }
            throw e;
        }
    }

    @Nonnull
    public File selectFileForUpdate(Connection connection, long id) throws SQLException {
        try {
            return this.manager.selectForUpdate(connection, fileIO, FileIO.SELECT_FOR_UPDATE_BY_ID, id);
        }
        catch (SQLException e) {
            if (Objects.equals(e.getSQLState(), "02000")) {
                throw new SQLException("There is no file with id=" + id, e.getSQLState(), e.getErrorCode(), e);
            }
            throw e;
        }
    }

    @Nonnull
    public File selectFileFromSpaceForUpdate(Connection connection, String pnfsPath, long reservationId) throws SQLException {
        return this.manager.selectForUpdate(connection, fileIO, FileIO.SELECT_TRANSIENT_FILES_BY_PNFSPATH_AND_RESERVATIONID, pnfsPath, reservationId);
    }

    public void removeFileFromSpace(long id) throws SQLException {
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            File f = this.selectFileForUpdate(connection, id);
            this.removeFileFromSpace(connection, f);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
        }
        catch (SQLException sqle) {
            logger.error("delete failed: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    public void removeFileFromSpace(Connection connection, File f) throws SQLException {
        Space space = this.selectSpaceForUpdate(connection, f.getSpaceId());
        int rc = this.manager.delete(connection, FileIO.DELETE, f.getId());
        if (rc != 1) {
            throw new SQLException("delete returned row count =" + rc);
        }
        if (f.getState() == FileState.RESERVED || f.getState() == FileState.TRANSFERRING) {
            this.decrementAllocatedSpaceInSpaceReservation(connection, space, f.getSizeInBytes());
        } else if (f.getState() == FileState.STORED) {
            this.decrementUsedSpaceInSpaceReservation(connection, space, f.getSizeInBytes());
            this.incrementFreeSpaceInLinkGroup(connection, space.getLinkGroupId(), f.getSizeInBytes());
        }
    }

    public void updateSpaceState(long id, SpaceState spaceState) throws SQLException {
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            this.updateSpaceReservation(connection, id, null, null, null, null, null, null, null, null, spaceState);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
        }
        catch (SQLException sqle) {
            logger.error("update failed: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    public void updateSpaceLifetime(Connection connection, long id, long newLifetime) throws SQLException {
        this.updateSpaceReservation(connection, id, null, null, null, null, null, null, newLifetime, null, null);
    }

    public void updateSpaceReservation(Connection connection, long id, String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, Long linkGroupId, Long sizeInBytes, Long lifetime, String description, SpaceState state) throws SQLException {
        Space space = this.selectSpaceForUpdate(connection, id);
        this.updateSpaceReservation(connection, voGroup, voRole, retentionPolicy, accessLatency, linkGroupId, sizeInBytes, lifetime, description, state, space);
    }

    public void updateSpaceReservation(Connection connection, String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, Long linkGroupId, Long sizeInBytes, Long lifetime, String description, SpaceState state, Space space) throws SQLException {
        if (voGroup != null) {
            space.setVoGroup(voGroup);
        }
        if (voRole != null) {
            space.setVoRole(voRole);
        }
        if (retentionPolicy != null) {
            space.setRetentionPolicy(retentionPolicy);
        }
        if (accessLatency != null) {
            space.setAccessLatency(accessLatency);
        }
        long deltaSize = 0L;
        long oldSize = space.getSizeInBytes();
        LinkGroup group = null;
        if (sizeInBytes != null) {
            if (sizeInBytes < space.getUsedSizeInBytes() + space.getAllocatedSpaceInBytes()) {
                long usedSpace = space.getUsedSizeInBytes() + space.getAllocatedSpaceInBytes();
                throw new SQLException("Cannot downsize space reservation below " + usedSpace + "bytes, remove files first ");
            }
            deltaSize = sizeInBytes - oldSize;
            space.setSizeInBytes(sizeInBytes);
            group = this.selectLinkGroupForUpdate(connection, space.getLinkGroupId());
            if (group.getAvailableSpaceInBytes() < deltaSize) {
                throw new SQLException("No space available to resize space reservation");
            }
        }
        if (lifetime != null) {
            space.setLifetime(lifetime);
        }
        if (description != null) {
            space.setDescription(description);
        }
        SpaceState oldState = space.getState();
        if (state != null) {
            if (SpaceState.isFinalState(oldState)) {
                throw new SQLException("change from " + oldState + " to " + state + " is not allowed");
            }
            if (group == null) {
                group = this.selectLinkGroupForUpdate(connection, space.getLinkGroupId());
            }
            space.setState(state);
        }
        this.manager.update(connection, SpaceReservationIO.UPDATE, space.getVoGroup(), space.getVoRole(), space.getRetentionPolicy().getId(), space.getAccessLatency().getId(), space.getLinkGroupId(), space.getSizeInBytes(), space.getCreationTime(), space.getLifetime(), space.getDescription(), space.getState().getStateId(), space.getId());
        if (state == null) {
            if (sizeInBytes != null && deltaSize != 0L && !SpaceState.isFinalState(space.getState())) {
                this.incrementReservedSpaceInLinkGroup(connection, group.getId(), deltaSize);
            }
        } else if (SpaceState.isFinalState(space.getState())) {
            this.decrementReservedSpaceInLinkGroup(connection, group.getId(), oldSize - space.getUsedSizeInBytes());
        }
    }

    public void updateSpaceReservation(long id, String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, Long linkGroupId, Long sizeInBytes, Long lifetime, String description, SpaceState state) throws SQLException {
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            this.updateSpaceReservation(connection, id, voGroup, voRole, retentionPolicy, accessLatency, linkGroupId, sizeInBytes, lifetime, description, state);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
        }
        catch (SQLException sqle) {
            logger.error("update failed: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    public void expireSpaceReservations() {
        logger.debug("expireSpaceReservations()...");
        try {
            if (this.cleanupExpiredSpaceFiles) {
                long time = System.currentTimeMillis();
                Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_SPACE_RESERVATIONS_FOR_EXPIRED_FILES, time);
                for (Space space : spaces) {
                    Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_EXPIRED_SPACEFILES, System.currentTimeMillis(), space.getId());
                    for (File file : files) {
                        try {
                            this.removeFileFromSpace(file.getId());
                        }
                        catch (SQLException e) {
                            logger.error("failed to remove file {}: {}", (Object)file, (Object)e.getMessage());
                        }
                    }
                }
            }
            logger.debug("Executing: {}", (Object)SpaceReservationIO.SELECT_EXPIRED_SPACE_RESERVATIONS1);
            Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_EXPIRED_SPACE_RESERVATIONS1, System.currentTimeMillis());
            for (Space space : spaces) {
                try {
                    this.updateSpaceReservation(space.getId(), null, null, null, null, null, null, null, null, SpaceState.EXPIRED);
                }
                catch (SQLException e) {
                    logger.error("failed to remove expired reservation {}: {}", (Object)space, (Object)e.getMessage());
                }
            }
        }
        catch (SQLException sqle) {
            logger.error("expireSpaceReservations failed: {}", (Object)sqle.getMessage());
        }
    }

    public long insertSpaceReservation(String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, long linkGroupId, long sizeInBytes, long lifetime, String description, int state, long used, long allocated) throws SQLException {
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            long id = this.getNextToken(connection);
            this.insertSpaceReservation(connection, id, voGroup, voRole, retentionPolicy, accessLatency, linkGroupId, sizeInBytes, lifetime, description, state, used, allocated);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
            long l = id;
            return l;
        }
        catch (SQLException sqle) {
            logger.error("failed to insert space reservation: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    public void insertSpaceReservation(Connection connection, long id, String voGroup, String voRole, RetentionPolicy retentionPolicy, AccessLatency accessLatency, long linkGroupId, long sizeInBytes, long lifetime, String description, int state, long used, long allocated) throws SQLException {
        long creationTime = System.currentTimeMillis();
        LinkGroup g = this.selectLinkGroupForUpdate(connection, linkGroupId, sizeInBytes);
        int rc = this.manager.insert(connection, SpaceReservationIO.INSERT, id, voGroup, voRole, retentionPolicy == null ? 0 : retentionPolicy.getId(), accessLatency == null ? 0 : accessLatency.getId(), g.getId(), sizeInBytes, creationTime, lifetime, description, state, used, allocated);
        if (rc != 1) {
            throw new SQLException("insert returned row count =" + rc);
        }
        this.incrementReservedSpaceInLinkGroup(connection, linkGroupId, sizeInBytes);
    }

    public void getValidSpaceTokens(GetSpaceTokensMessage msg) throws SQLException {
        HashSet<Space> spaces;
        if (msg.getSpaceTokenId() != null) {
            spaces = new HashSet();
            Space space = this.getSpace(msg.getSpaceTokenId());
            spaces.add(space);
        } else {
            spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_CURRENT_SPACE_RESERVATIONS, new Object[0]);
        }
        msg.setSpaceTokenSet(spaces);
    }

    public void getValidSpaceTokenIds(GetSpaceTokenIdsMessage msg) throws SQLException {
        Set<Space> spaces = this.manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_CURRENT_SPACE_RESERVATIONS, new Object[0]);
        long[] ids = new long[spaces.size()];
        int j = 0;
        for (Space space : spaces) {
            ids[j++] = space.getId();
        }
        msg.setSpaceTokenIds(ids);
    }

    public void getLinkGroups(GetLinkGroupsMessage msg) throws SQLException {
        HashSet<LinkGroup> groups;
        if (msg.getLinkgroupidId() != null) {
            groups = new HashSet();
            LinkGroup lg = this.getLinkGroup(msg.getLinkgroupidId());
            groups.add(lg);
        } else {
            groups = this.manager.selectPrepared(linkGroupIO, LinkGroupIO.SELECT_ALL_LINKGROUPS, new Object[0]);
        }
        msg.setLinkGroupSet(groups);
    }

    public void getLinkGroupNames(GetLinkGroupNamesMessage msg) throws SQLException {
        Set<LinkGroup> groups = this.manager.selectPrepared(linkGroupIO, LinkGroupIO.SELECT_ALL_LINKGROUPS, new Object[0]);
        String[] names = new String[groups.size()];
        int j = 0;
        for (LinkGroup group : groups) {
            names[j++] = group.getName();
        }
        msg.setLinkGroupNames(names);
    }

    public void getLinkGroupIds(GetLinkGroupIdsMessage msg) throws SQLException {
        Set<LinkGroup> groups = this.manager.selectPrepared(linkGroupIO, LinkGroupIO.SELECT_ALL_LINKGROUPS, new Object[0]);
        long[] ids = new long[groups.size()];
        int j = 0;
        for (LinkGroup group : groups) {
            ids[j++] = group.getId();
        }
        msg.setLinkGroupIds(ids);
    }

    private Set<Space> findSpacesByVoGroupAndRole(String voGroup, String voRole) throws SQLException {
        if (voGroup != null && !voGroup.isEmpty() && voRole != null && !voRole.isEmpty()) {
            return this.manager.selectPrepared(spaceReservationIO, SELECT_SPACE_TOKENS_BY_VOGROUP_AND_VOROLE, SpaceState.RESERVED.getStateId(), voGroup, voRole);
        }
        if (voGroup != null && !voGroup.isEmpty()) {
            return this.manager.selectPrepared(spaceReservationIO, SELECT_SPACE_TOKENS_BY_VOGROUP, SpaceState.RESERVED.getStateId(), voGroup);
        }
        if (voRole != null && !voRole.isEmpty()) {
            return this.manager.selectPrepared(spaceReservationIO, SELECT_SPACE_TOKENS_BY_VOROLE, SpaceState.RESERVED.getStateId(), voRole);
        }
        return Collections.emptySet();
    }

    public long[] getSpaceTokens(AuthorizationRecord authRecord, String description) throws SQLException {
        HashSet<Space> spaces = new HashSet<Space>();
        if (description == null) {
            String voGroup = authRecord.getVoGroup();
            String voRole = authRecord.getVoRole();
            spaces.addAll(this.findSpacesByVoGroupAndRole(voGroup, voRole));
            for (GroupList groupList : authRecord.getGroupLists()) {
                Set<Space> foundSpaces;
                String attribute = groupList.getAttribute();
                if (FQAN.isValid((String)attribute)) {
                    FQAN fqan = new FQAN(attribute);
                    foundSpaces = this.findSpacesByVoGroupAndRole(fqan.getGroup(), fqan.getRole());
                } else {
                    foundSpaces = this.findSpacesByVoGroupAndRole(attribute, "");
                }
                spaces.addAll(foundSpaces);
            }
        } else {
            Set<Space> foundSpaces = this.manager.selectPrepared(spaceReservationIO, SELECT_SPACE_TOKENS_BY_DESCRIPTION, SpaceState.RESERVED.getStateId(), description);
            if (foundSpaces != null) {
                spaces.addAll(foundSpaces);
            }
        }
        long[] tokens = new long[spaces.size()];
        int i = 0;
        for (Space space : spaces) {
            tokens[i++] = space.getId();
        }
        return tokens;
    }

    public long[] getFileSpaceTokens(PnfsId pnfsId, String pnfsPath) throws SQLException {
        if (pnfsId == null && pnfsPath == null) {
            throw new IllegalArgumentException("getFileSpaceTokens: all arguments are nulls, not supported");
        }
        Set<File> files = null;
        if (pnfsId != null && pnfsPath != null) {
            files = this.manager.selectPrepared(fileIO, SELECT_SPACE_FILE_BY_PNFSID_AND_PNFSPATH, pnfsId.toString(), new FsPath(pnfsPath).toString());
        } else {
            if (pnfsId != null) {
                files = this.manager.selectPrepared(fileIO, SELECT_SPACE_FILE_BY_PNFSID, pnfsId.toString());
            }
            if (pnfsPath != null) {
                files = this.manager.selectPrepared(fileIO, SELECT_SPACE_FILE_BY_PNFSPATH, new FsPath(pnfsPath).toString());
            }
        }
        long[] tokens = new long[files.size()];
        int i = 0;
        for (File file : files) {
            tokens[i++] = file.getSpaceId();
        }
        return tokens;
    }

    public void deleteSpaceReservation(Connection connection, Space space) throws SQLException {
        this.manager.delete(connection, SpaceReservationIO.DELETE_SPACE_RESERVATION, space.getId());
        this.decrementReservedSpaceInLinkGroup(connection, space.getLinkGroupId(), space.getSizeInBytes() - space.getUsedSizeInBytes());
    }

    public void deleteSpaceReservation(long id) throws SQLException {
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            Space space = this.selectSpaceForUpdate(connection, id);
            this.deleteSpaceReservation(connection, space);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
        }
        catch (SQLException sqle) {
            logger.error("failed to delete space reservation: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    public void updateSpaceFile(long id, String voGroup, String voRole, PnfsId pnfsId, Long sizeInBytes, Long lifetime, Integer state) throws SQLException {
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            this.updateSpaceFile(connection, id, voGroup, voRole, pnfsId, sizeInBytes, lifetime, state);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
        }
        catch (SQLException sqle) {
            logger.error("update failed: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    public void updateSpaceFile(Connection connection, long id, String voGroup, String voRole, PnfsId pnfsId, Long sizeInBytes, Long lifetime, Integer state) throws SQLException {
        File f = this.selectFileForUpdate(connection, id);
        this.updateSpaceFile(connection, id, voGroup, voRole, pnfsId, sizeInBytes, lifetime, state, f);
    }

    public void updateSpaceFile(Connection connection, long id, String voGroup, String voRole, PnfsId pnfsId, Long sizeInBytes, Long lifetime, Integer state, File f) throws SQLException {
        int rc;
        if (voGroup != null) {
            f.setVoGroup(voGroup);
        }
        if (voRole != null) {
            f.setVoRole(voRole);
        }
        long oldSize = f.getSizeInBytes();
        long deltaSize = 0L;
        Space space = null;
        if (sizeInBytes != null && (deltaSize = sizeInBytes - oldSize) != 0L) {
            f.setSizeInBytes(sizeInBytes);
            Connection newConnection = null;
            try {
                newConnection = this.connection_pool.getConnection();
                newConnection.setAutoCommit(false);
                space = this.selectSpaceForUpdate(newConnection, f.getSpaceId());
                if (deltaSize > space.getAvailableSpaceInBytes()) {
                    this.updateSpaceReservation(newConnection, null, null, null, null, null, (Long)(space.getSizeInBytes() + deltaSize - space.getAvailableSpaceInBytes()), null, null, null, space);
                }
                newConnection.commit();
                this.connection_pool.returnConnection(newConnection);
                newConnection = null;
            }
            catch (SQLException e) {
                logger.error("failed to update space reservation: {}", (Object)e.getMessage());
                if (newConnection != null) {
                    newConnection.rollback();
                    this.connection_pool.returnFailedConnection(newConnection);
                    newConnection = null;
                }
                throw e;
            }
            space = this.selectSpaceForUpdate(connection, f.getSpaceId());
        }
        if (lifetime != null) {
            f.setLifetime(lifetime);
        }
        FileState oldState = f.getState();
        if (state != null) {
            if (space == null) {
                space = this.selectSpaceForUpdate(connection, f.getSpaceId());
            }
            f.setState(FileState.getState(state));
        }
        if (pnfsId != null) {
            f.setPnfsId(pnfsId);
        }
        if ((rc = f.getPnfsId() != null ? this.manager.update(connection, FileIO.UPDATE, f.getVoGroup(), f.getVoRole(), f.getSizeInBytes(), f.getLifetime(), f.getPnfsId().toString(), f.getState().getStateId(), f.getId()) : this.manager.update(connection, FileIO.UPDATE_WO_PNFSID, f.getVoGroup(), f.getVoRole(), f.getSizeInBytes(), f.getLifetime(), f.getState().getStateId(), f.getId())) != 1) {
            throw new SQLException("Update failed, row count=" + rc);
        }
        if (state == null) {
            if (sizeInBytes != null && deltaSize != 0L) {
                if (f.getState() == FileState.STORED) {
                    this.incrementUsedSpaceInSpaceReservation(connection, space, deltaSize);
                    this.decrementFreeSpaceInLinkGroup(connection, space.getLinkGroupId(), deltaSize);
                }
                if (f.getState() == FileState.RESERVED || f.getState() == FileState.TRANSFERRING) {
                    this.incrementAllocatedSpaceInSpaceReservation(connection, space, deltaSize);
                }
            }
        } else if (oldState == FileState.RESERVED || oldState == FileState.TRANSFERRING) {
            if (f.getState() == FileState.STORED) {
                this.decrementAllocatedSpaceInSpaceReservation(connection, space, oldSize);
                this.incrementUsedSpaceInSpaceReservation(connection, space, f.getSizeInBytes());
                this.decrementFreeSpaceInLinkGroup(connection, space.getLinkGroupId(), f.getSizeInBytes());
            } else if (f.getState() == FileState.FLUSHED) {
                this.decrementAllocatedSpaceInSpaceReservation(connection, space, oldSize);
            }
        } else if (oldState == FileState.STORED) {
            if (f.getState() == FileState.FLUSHED) {
                this.decrementUsedSpaceInSpaceReservation(connection, space, oldSize);
                this.incrementFreeSpaceInLinkGroup(connection, space.getLinkGroupId(), f.getSizeInBytes());
            } else if (f.getState() == FileState.RESERVED || f.getState() == FileState.TRANSFERRING) {
                this.decrementUsedSpaceInSpaceReservation(connection, space, oldSize);
                this.incrementAllocatedSpaceInSpaceReservation(connection, space, f.getSizeInBytes());
                this.incrementFreeSpaceInLinkGroup(connection, space.getLinkGroupId(), f.getSizeInBytes());
            }
        }
    }

    public void removePnfsIdOfFileInSpace(Connection connection, long id, Integer state) throws SQLException {
        if (state == null) {
            this.manager.update(connection, FileIO.REMOVE_PNFSID_ON_SPACEFILE, id);
        } else {
            this.manager.update(connection, FileIO.REMOVE_PNFSID_AND_CHANGE_STATE_SPACEFILE, id, state);
        }
    }

    public long insertFileInSpace(String voGroup, String voRole, long spaceReservationId, long sizeInBytes, long lifetime, String pnfsPath, PnfsId pnfsId, int state) throws SQLException, SpaceException {
        pnfsPath = new FsPath(pnfsPath).toString();
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            long id = this.getNextToken(connection);
            this.insertFileInSpace(connection, id, voGroup, voRole, spaceReservationId, sizeInBytes, lifetime, pnfsPath, pnfsId, state);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
            long l = id;
            return l;
        }
        catch (SpaceException | SQLException sqle) {
            logger.error("insert failed: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    public void insertFileInSpace(Connection connection, long id, String voGroup, String voRole, long spaceReservationId, long sizeInBytes, long lifetime, String pnfsPath, PnfsId pnfsId, int state) throws SQLException, SpaceException {
        pnfsPath = new FsPath(pnfsPath).toString();
        long creationTime = System.currentTimeMillis();
        Space space = this.selectSpaceForUpdate(connection, spaceReservationId, 0L);
        if (this.matchVoGroupAndVoRole) {
            if (voGroup == null) {
                if (space.getVoGroup() != null && !space.getVoGroup().equals("") && !space.getVoGroup().equals("*")) {
                    throw new SpaceAuthorizationException("VO group does not match, specified null, must be " + space.getVoGroup());
                }
            } else if (space.getVoGroup() != null) {
                if (!space.getVoGroup().equals(voGroup) && !space.getVoGroup().equals("*")) {
                    throw new SpaceAuthorizationException("VO group does not match, specified " + voGroup + ", must be " + space.getVoGroup());
                }
            } else {
                throw new SpaceAuthorizationException("VO group does not match, specified " + voGroup + ", must be null");
            }
            if (voRole == null) {
                if (space.getVoRole() != null && !space.getVoRole().equals("") && !space.getVoRole().equals("*")) {
                    throw new SpaceAuthorizationException("VO role does not match, specified null, must be " + space.getVoRole());
                }
            } else if (space.getVoRole() != null) {
                if (!space.getVoRole().equals(voRole) && !space.getVoRole().equals("*")) {
                    throw new SpaceAuthorizationException("VO role does not match, specified " + voRole + ", must be " + space.getVoRole());
                }
            } else {
                throw new SpaceAuthorizationException("VO role does not match, specified " + voRole + ", must be null");
            }
        }
        long currentTime = System.currentTimeMillis();
        if (space.getLifetime() != -1L && space.getCreationTime() + space.getLifetime() < currentTime) {
            throw new SpaceExpiredException("space with id=" + spaceReservationId + " has expired");
        }
        if (space.getState() == SpaceState.EXPIRED) {
            throw new SpaceExpiredException("space with id=" + spaceReservationId + " has expired");
        }
        if (space.getState() == SpaceState.RELEASED) {
            throw new SpaceReleasedException("space with id=" + spaceReservationId + " was released");
        }
        if (space.getAvailableSpaceInBytes() < sizeInBytes) {
            throw new NoFreeSpaceException("space with id=" + spaceReservationId + " does not have enough space");
        }
        int rc = pnfsId == null ? this.manager.insert(connection, FileIO.INSERT_WO_PNFSID, id, voGroup, voRole, spaceReservationId, sizeInBytes, creationTime, lifetime, pnfsPath, state) : this.manager.insert(connection, FileIO.INSERT_W_PNFSID, id, voGroup, voRole, spaceReservationId, sizeInBytes, creationTime, lifetime, pnfsPath, pnfsId.toString(), state);
        if (rc != 1) {
            throw new SQLException("insert returned row count =" + rc);
        }
        if (state == FileState.RESERVED.getStateId() || state == FileState.TRANSFERRING.getStateId()) {
            this.incrementAllocatedSpaceInSpaceReservation(connection, space, sizeInBytes);
        } else if (state == FileState.STORED.getStateId()) {
            this.incrementUsedSpaceInSpaceReservation(connection, space, sizeInBytes);
            this.decrementAllocatedSpaceInSpaceReservation(connection, space, sizeInBytes);
            this.decrementFreeSpaceInLinkGroup(connection, space.getLinkGroupId(), sizeInBytes);
        }
    }

    public File getFile(PnfsId pnfsId) throws SQLException {
        Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_BY_PNFSID, pnfsId.toString());
        if (files.isEmpty()) {
            throw new SQLException("file with pnfsId=" + pnfsId + " is not found", "02000");
        }
        if (files.size() > 1) {
            throw new SQLException("found two records with pnfsId=" + pnfsId);
        }
        return (File)Iterables.getFirst(files, null);
    }

    public File getFile(String pnfsPath) throws SQLException {
        pnfsPath = new FsPath(pnfsPath).toString();
        Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_BY_PNFSPATH, pnfsPath);
        if (files.isEmpty()) {
            throw new SQLException("file with pnfsPath=" + pnfsPath + " is not found", "02000");
        }
        if (files.size() > 1) {
            throw new SQLException("found two records with pnfsPath=" + pnfsPath);
        }
        return (File)Iterables.getFirst(files, null);
    }

    public Set<File> getFiles(String pnfsPath) throws SQLException {
        pnfsPath = new FsPath(pnfsPath).toString();
        Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_BY_PNFSPATH, pnfsPath);
        if (files.isEmpty()) {
            throw new SQLException("file with pnfsPath=" + pnfsPath + " is not found", "02000");
        }
        return files;
    }

    public File getFile(long id) throws SQLException {
        Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_BY_ID, id);
        if (files.isEmpty()) {
            throw new SQLException("file with id=" + id + " is not found", "02000");
        }
        if (files.size() > 1) {
            throw new SQLException("found two records with id=" + id);
        }
        return (File)Iterables.getFirst(files, null);
    }

    public static void main(String[] args) {
        block22: {
            if (args == null || args.length == 0) {
                System.err.println("Need to specify DB connection arguments");
                System.err.println("e.g.: -jdbcUrl=jdbc:postgresql://localhost/dcache  -jdbcDriver=org.postgresql.Driver -dbUser=srmdcache -dbPass=srmdcache");
                System.exit(1);
            }
            Args arguments = new Args(args);
            String jdbcUrl = arguments.getOpt("jdbcUrl");
            String jdbcClass = arguments.getOpt("jdbcDriver");
            String user = arguments.getOpt("dbUser");
            String pass = arguments.getOpt("dbPass");
            String pwdfile = arguments.getOpt("pgPass");
            String pgBasedPass = null;
            if (pwdfile != null && !pwdfile.trim().equals("")) {
                Pgpass pgpass = new Pgpass(pwdfile);
                pgBasedPass = pgpass.getPgpass(jdbcUrl, user);
            }
            if (pgBasedPass != null) {
                pass = pgBasedPass;
            }
            try {
                DBManager manager = DBManager.getInstance();
                manager.initConnectionPool(jdbcUrl, jdbcClass, user, pass);
                int previousVersion = 0;
                Object o = null;
                try {
                    o = manager.selectPrepared(1, selectVersion, new Object[0]);
                }
                catch (SQLException e) {
                    System.err.println("srmspacemanagerschemaversion does not exist - do nothing");
                    System.exit(0);
                }
                if (o != null) {
                    previousVersion = (Integer)o;
                }
                if (previousVersion != true) break block22;
                StringBuilder sb = new StringBuilder();
                sb.append("\n");
                sb.append("\t\t    VERY IMPORTANT \n");
                sb.append("\n");
                sb.append("\tWe discovered that your current space manager schema version is ").append(previousVersion).append(".\n");
                sb.append("\tWe are upgrading to schema version 2.\n");
                sb.append("\tWe are going to update information in srmspace and srmlinkgroup tables\n");
                sb.append("\n");
                sb.append("\t+--------------------------------------------------------+\n");
                sb.append("\t|      FOR THE SPACE RESERVATIONS TO WORK CORRECTLY      |\n");
                sb.append("\t| IT IS ABSOLUTELY IMPORTANT TO LET THESE QUERIES FINISH |\n");
                sb.append("\t| IT MAY TAKE A LONG TIME (MINUTES), PLEASE BEAR WITH US |\n");
                sb.append("\t|                 DO NOT INTERRUPT                       |\n");
                sb.append("\t| THIS ACTION WILL NOT BE REPEATED IN SUBSEQUENT STARTUPS|\n");
                sb.append("\t+--------------------------------------------------------+\n");
                System.out.println(sb.toString());
                try {
                    manager.batchUpdates("ALTER TABLE " + ManagerSchemaConstants.LinkGroupTableName + " ADD COLUMN  reservedspaceinbytes BIGINT", "ALTER TABLE " + ManagerSchemaConstants.SpaceTableName + " ADD COLUMN  usedspaceinbytes      BIGINT," + " ADD COLUMN  allocatedspaceinbytes  BIGINT");
                    manager.createIndexes(ManagerSchemaConstants.SpaceFileTableName, "spacereservationid", "state", "pnfspath", "pnfsid", "creationtime", "lifetime");
                    manager.createIndexes(ManagerSchemaConstants.SpaceTableName, "linkgroupid", "state", "description", "lifetime", "creationtime");
                    manager.update(updateVersion, new Object[0]);
                    try {
                        Set<Space> spaces = manager.selectPrepared(spaceReservationIO, SpaceReservationIO.SELECT_CURRENT_SPACE_RESERVATIONS, new Object[0]);
                        System.out.println("Found " + spaces.size() + " space reservations to update");
                        for (Space space : spaces) {
                            try {
                                manager.update(" update srmspace set usedspaceinbytes=(  select coalesce(sum(sf.sizeinbytes),0)  from srmspace s left outer join srmspacefile sf on  s.id=sf.spacereservationid and sf.state=2 and s.id=?), allocatedspaceinbytes= ( select coalesce(sum(sf.sizeinbytes),0)  from srmspace s left outer join srmspacefile sf on  s.id=sf.spacereservationid and sf.state<2 and s.id=?) where srmspace.id=?", space.getId(), space.getId(), space.getId());
                            }
                            catch (SQLException e) {
                                System.err.println("failed to execute  update srmspace set usedspaceinbytes=(  select coalesce(sum(sf.sizeinbytes),0)  from srmspace s left outer join srmspacefile sf on  s.id=sf.spacereservationid and sf.state=2 and s.id=?), allocatedspaceinbytes= ( select coalesce(sum(sf.sizeinbytes),0)  from srmspace s left outer join srmspacefile sf on  s.id=sf.spacereservationid and sf.state<2 and s.id=?) where srmspace.id=?,?=" + space.getId());
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    try {
                        Set<LinkGroup> groups = manager.selectPrepared(linkGroupIO, LinkGroupIO.SELECT_ALL, new Object[0]);
                        if (groups != null) {
                            System.out.println("Found " + groups.size() + " link groups to update");
                            for (LinkGroup group : groups) {
                                try {
                                    manager.update(" update srmlinkgroup set reservedspaceinbytes=(  select coalesce(sum(s.sizeinbytes-s.usedspaceinbytes),0)  from srmlinkgroup lg left outer join srmspace s on  s.linkGroupId=lg.id and lg.id=? and s.state=0) where  srmlinkgroup.id=?", group.getId(), group.getId());
                                }
                                catch (SQLException e) {
                                    System.err.println("failed to execute  update srmlinkgroup set reservedspaceinbytes=(  select coalesce(sum(s.sizeinbytes-s.usedspaceinbytes),0)  from srmlinkgroup lg left outer join srmspace s on  s.linkGroupId=lg.id and lg.id=? and s.state=0) where  srmlinkgroup.id=?,?=" + group.getId());
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    System.out.println("\tSUCCESSFULLY UPDATED SPACE MANAGER SCHEMA TO VERSION 2");
                    System.out.println("\tIT IS SAFE TO START SRM");
                    System.out.println("\tStarting SRM\n");
                    System.exit(0);
                }
                catch (SQLException e) {
                    System.err.println("THINGS WENT WRONG! PLEASE DO NOT ATTEMPT TO START SRM");
                    System.err.println("send mail with the output to litvinse@fnal.gov");
                    System.err.println("I will try diagnose the problem and give you solution");
                    System.exit(1);
                }
            }
            catch (SQLException e) {
                System.err.println("Caught SQL exception");
                e.printStackTrace();
                System.exit(1);
            }
            catch (Exception e) {
                System.err.println("Caught Exception");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    @Override
    public void messageArrived(final CellMessage envelope) {
        Serializable rawMessage = envelope.getMessageObject();
        logger.trace("Message  arrived: {} from {}", (Object)rawMessage, (Object)envelope.getSourcePath());
        if (!(rawMessage instanceof Message)) {
            logger.warn("Unknown payload {}: {}", (Object)rawMessage.getClass().getCanonicalName(), (Object)rawMessage);
            return;
        }
        final Message message = (Message)rawMessage;
        if (this.spaceManagerEnabled) {
            if (this.isNotificationMessage(message) || this.isSpaceManagerMessage(message) || this.isInterceptedMessage(message)) {
                ThreadManager.execute(new Runnable(){

                    @Override
                    public void run() {
                        Manager.this.processMessage(envelope, message);
                    }
                });
            } else if (!message.isReply()) {
                this.forwardToPoolmanager(envelope);
            }
        } else if (!this.isNotificationMessage(message)) {
            if (this.isSpaceManagerMessage(message)) {
                this.returnFailedResponse((Serializable)((Object)"SpaceManager is disabled in configuration"), message, envelope);
            } else if (!message.isReply()) {
                this.forwardToPoolmanager(envelope);
            }
        }
    }

    private boolean isSpaceManagerMessage(Object message) {
        return message instanceof Reserve || message instanceof GetSpaceTokensMessage || message instanceof GetSpaceTokenIdsMessage || message instanceof GetLinkGroupsMessage || message instanceof GetLinkGroupNamesMessage || message instanceof GetLinkGroupIdsMessage || message instanceof Release || message instanceof Use || message instanceof CancelUse || message instanceof GetSpaceMetaData || message instanceof GetSpaceTokens || message instanceof ExtendLifetime || message instanceof GetFileSpaceTokensMessage;
    }

    private boolean isNotificationMessage(Object message) {
        return message instanceof PoolFileFlushedMessage || message instanceof PoolRemoveFilesMessage || message instanceof PnfsDeleteEntryNotificationMessage;
    }

    private boolean isInterceptedMessage(Object message) {
        return message instanceof PoolMgrSelectWritePoolMsg || message instanceof DoorTransferFinishedMessage || message instanceof PoolAcceptFileMessage;
    }

    private void processMessage(CellMessage cellMessage, Message spaceMessage) {
        boolean replyRequired;
        block25: {
            replyRequired = spaceMessage.getReplyRequired();
            try {
                Message message;
                if (spaceMessage instanceof Reserve) {
                    Reserve reserve = (Reserve)spaceMessage;
                    this.reserveSpace(reserve);
                    break block25;
                }
                if (spaceMessage instanceof GetSpaceTokensMessage) {
                    message = (GetSpaceTokensMessage)spaceMessage;
                    this.getValidSpaceTokens((GetSpaceTokensMessage)message);
                    break block25;
                }
                if (spaceMessage instanceof GetSpaceTokenIdsMessage) {
                    message = (GetSpaceTokenIdsMessage)spaceMessage;
                    this.getValidSpaceTokenIds((GetSpaceTokenIdsMessage)message);
                    break block25;
                }
                if (spaceMessage instanceof GetLinkGroupsMessage) {
                    message = (GetLinkGroupsMessage)spaceMessage;
                    this.getLinkGroups((GetLinkGroupsMessage)message);
                    break block25;
                }
                if (spaceMessage instanceof GetLinkGroupNamesMessage) {
                    message = (GetLinkGroupNamesMessage)spaceMessage;
                    this.getLinkGroupNames((GetLinkGroupNamesMessage)message);
                    break block25;
                }
                if (spaceMessage instanceof GetLinkGroupIdsMessage) {
                    message = (GetLinkGroupIdsMessage)spaceMessage;
                    this.getLinkGroupIds((GetLinkGroupIdsMessage)message);
                    break block25;
                }
                if (spaceMessage instanceof Release) {
                    Release release = (Release)spaceMessage;
                    this.releaseSpace(release);
                    break block25;
                }
                if (spaceMessage instanceof Use) {
                    Use use = (Use)spaceMessage;
                    this.useSpace(use);
                    break block25;
                }
                if (spaceMessage instanceof CancelUse) {
                    CancelUse cancelUse = (CancelUse)spaceMessage;
                    this.cancelUseSpace(cancelUse);
                    break block25;
                }
                if (spaceMessage instanceof PoolMgrSelectWritePoolMsg) {
                    this.selectPool(cellMessage, (PoolMgrSelectWritePoolMsg)spaceMessage, false);
                    replyRequired = false;
                    break block25;
                }
                if (spaceMessage instanceof GetSpaceMetaData) {
                    GetSpaceMetaData getSpaceMetaData = (GetSpaceMetaData)spaceMessage;
                    this.getSpaceMetaData(getSpaceMetaData);
                    break block25;
                }
                if (spaceMessage instanceof GetSpaceTokens) {
                    GetSpaceTokens getSpaceTokens = (GetSpaceTokens)spaceMessage;
                    this.getSpaceTokens(getSpaceTokens);
                    break block25;
                }
                if (spaceMessage instanceof ExtendLifetime) {
                    ExtendLifetime extendLifetime = (ExtendLifetime)spaceMessage;
                    this.extendLifetime(extendLifetime);
                    break block25;
                }
                if (spaceMessage instanceof PoolFileFlushedMessage) {
                    PoolFileFlushedMessage fileFlushed = (PoolFileFlushedMessage)spaceMessage;
                    this.fileFlushed(fileFlushed);
                    break block25;
                }
                if (spaceMessage instanceof PoolRemoveFilesMessage) {
                    PoolRemoveFilesMessage fileRemoved = (PoolRemoveFilesMessage)spaceMessage;
                    this.fileRemoved(fileRemoved);
                    break block25;
                }
                if (spaceMessage instanceof GetFileSpaceTokensMessage) {
                    GetFileSpaceTokensMessage getFileTokens = (GetFileSpaceTokensMessage)spaceMessage;
                    this.getFileSpaceTokens(getFileTokens);
                    break block25;
                }
                if (spaceMessage instanceof PnfsDeleteEntryNotificationMessage) {
                    PnfsDeleteEntryNotificationMessage msg = (PnfsDeleteEntryNotificationMessage)spaceMessage;
                    this.markFileDeleted(msg);
                    break block25;
                }
                throw new RuntimeException("Unexpected " + spaceMessage.getClass() + ": Please report this to support@dcache.org");
            }
            catch (SpaceException se) {
                logger.error("failed to process message: {}", (Object)se.getMessage());
                spaceMessage.setFailed(-2, se);
            }
            catch (SQLException e) {
                logger.error("database activity failed: {}", (Object)e.getMessage());
                spaceMessage.setFailed(-1, e);
            }
            catch (Throwable t) {
                logger.error("an operation failed:", t);
                spaceMessage.setFailed(-1, t);
            }
        }
        if (replyRequired) {
            try {
                logger.debug("Sending reply {}", (Object)spaceMessage);
                cellMessage.revertDirection();
                this.sendMessage(cellMessage);
            }
            catch (Exception e) {
                logger.error("can't reply message: {}", (Object)e.getMessage());
            }
        } else {
            logger.debug("reply is not required, finished processing");
        }
    }

    @Override
    public void messageToForward(final CellMessage envelope) {
        final Serializable message = envelope.getMessageObject();
        if (this.spaceManagerEnabled && this.isInterceptedMessage(message)) {
            ThreadManager.execute(new Runnable(){

                @Override
                public void run() {
                    Manager.this.processMessageToForward(envelope, (Message)message);
                }
            });
        } else {
            if (message instanceof PoolIoFileMessage && !((Message)message).isReply()) {
                envelope.getDestinationPath().insert(this.poolManager);
            }
            super.messageToForward(envelope);
        }
    }

    public void processMessageToForward(CellMessage envelope, Message message) {
        logger.trace("messageToForward,  arrived: type={} value={} from {} going to {}", new Object[]{message.getClass().getName(), message, envelope.getSourcePath(), envelope.getDestinationPath()});
        try {
            if (message instanceof PoolMgrSelectWritePoolMsg) {
                this.selectPool(envelope, (PoolMgrSelectWritePoolMsg)message, true);
            } else if (message instanceof PoolAcceptFileMessage) {
                PoolAcceptFileMessage poolRequest = (PoolAcceptFileMessage)message;
                if (poolRequest.isReply()) {
                    PnfsId pnfsId = poolRequest.getPnfsId();
                    this.transferStarted(pnfsId, poolRequest.getReturnCode() == 0);
                } else {
                    this.transferToBeStarted(poolRequest);
                    envelope.getDestinationPath().insert(this.poolManager);
                }
            } else if (message instanceof DoorTransferFinishedMessage) {
                DoorTransferFinishedMessage finished = (DoorTransferFinishedMessage)message;
                try {
                    this.transferFinished(finished);
                }
                catch (Exception e) {
                    finished.setFailed(1, e);
                }
            }
        }
        catch (Exception e) {
            logger.error("forwarding msg failed: {}", (Object)e.getMessage(), (Object)e);
        }
        super.messageToForward(envelope);
    }

    public void exceptionArrived(ExceptionEvent ee) {
        logger.error("exception arrived: {}", (Object)ee.toString());
        super.exceptionArrived(ee);
    }

    public void returnFailedResponse(Serializable reason, Message spaceManagerMessage, CellMessage cellMessage) {
        if (reason != null && !(reason instanceof Serializable)) {
            reason = reason.toString();
        }
        try {
            spaceManagerMessage.setReply();
            spaceManagerMessage.setFailed(1, (Serializable)reason);
            cellMessage.revertDirection();
            this.sendMessage(cellMessage);
        }
        catch (Exception e) {
            logger.error("cannot send a failed response: {}", (Object)e.getMessage());
        }
    }

    public void returnMessage(Message message, CellMessage cellMessage) {
        try {
            message.setReply();
            cellMessage.revertDirection();
            this.sendMessage(cellMessage);
        }
        catch (Exception e) {
            logger.error("cannot send a response: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() == this.expireSpaceReservations) {
            while (true) {
                this.expireSpaceReservations();
                try {
                    Thread.sleep(this.expireSpaceReservationsPeriod);
                }
                catch (InterruptedException ie) {
                    logger.debug("expire SpaceReservations thread has been interrupted");
                    return;
                }
            }
        }
        if (Thread.currentThread() == this.updateLinkGroups) {
            while (true) {
                this.updateLinkGroups();
                Object object = this.updateLinkGroupsSyncObject;
                synchronized (object) {
                    try {
                        this.updateLinkGroupsSyncObject.wait(this.currentUpdateLinkGroupsPeriod);
                    }
                    catch (InterruptedException ie) {
                        logger.debug("update LinkGroup thread has been interrupted");
                        return;
                    }
                }
            }
        }
    }

    private void updateLinkGroupAuthorizationFile() {
        if (this.linkGroupAuthorizationFileName == null) {
            return;
        }
        java.io.File f = new java.io.File(this.linkGroupAuthorizationFileName);
        if (!f.exists()) {
            this.linkGroupAuthorizationFile = null;
        }
        long lastModified = f.lastModified();
        if (this.linkGroupAuthorizationFile == null || lastModified >= this.linkGroupAuthorizationFileLastUpdateTimestampt) {
            this.linkGroupAuthorizationFileLastUpdateTimestampt = lastModified;
            try {
                this.linkGroupAuthorizationFile = new LinkGroupAuthorizationFile(this.linkGroupAuthorizationFileName);
            }
            catch (Exception e) {
                logger.error("failed to parse LinkGroupAuthorizationFile: {}", (Object)e.getMessage());
            }
        }
    }

    private void updateLinkGroups() {
        PoolMgrGetPoolLinkGroups getLinkGroups;
        this.currentUpdateLinkGroupsPeriod = 1000L;
        long currentTime = System.currentTimeMillis();
        CellMessage cellMessage = new CellMessage(new CellPath(this.poolManager), (Serializable)new PoolMgrGetPoolLinkGroups());
        try {
            cellMessage = this.sendAndWait(cellMessage, 300000L);
            if (cellMessage == null) {
                logger.error("failed to update linkgroups: request timed out");
                return;
            }
            if (cellMessage.getMessageObject() == null) {
                logger.error("failed to update linkgroups: reply message is null");
                return;
            }
            if (!(cellMessage.getMessageObject() instanceof PoolMgrGetPoolLinkGroups)) {
                return;
            }
            getLinkGroups = (PoolMgrGetPoolLinkGroups)cellMessage.getMessageObject();
            if (getLinkGroups.getReturnCode() != 0) {
                logger.error("PoolMgrGetPoolLinkGroups reply return code ={} error Object= {}", (Object)getLinkGroups.getReturnCode(), (Object)getLinkGroups.getErrorObject());
                return;
            }
        }
        catch (Exception e) {
            logger.error("failed to update linkgroups: {}", (Object)e.getMessage());
            return;
        }
        this.currentUpdateLinkGroupsPeriod = this.updateLinkGroupsPeriod;
        PoolLinkGroupInfo[] poolLinkGroupInfos = getLinkGroups.getPoolLinkGroupInfos();
        if (poolLinkGroupInfos.length == 0) {
            return;
        }
        this.updateLinkGroupAuthorizationFile();
        for (PoolLinkGroupInfo info : poolLinkGroupInfos) {
            LinkGroupAuthorizationRecord record;
            String linkGroupName = info.getName();
            long avalSpaceInBytes = info.getAvailableSpaceInBytes();
            VOInfo[] vos = null;
            boolean onlineAllowed = info.isOnlineAllowed();
            boolean nearlineAllowed = info.isNearlineAllowed();
            boolean replicaAllowed = info.isReplicaAllowed();
            boolean outputAllowed = info.isOutputAllowed();
            boolean custodialAllowed = info.isCustodialAllowed();
            if (this.linkGroupAuthorizationFile != null && (record = this.linkGroupAuthorizationFile.getLinkGroupAuthorizationRecord(linkGroupName)) != null) {
                vos = record.getVOInfoArray();
            }
            try {
                this.updateLinkGroup(linkGroupName, avalSpaceInBytes, currentTime, onlineAllowed, nearlineAllowed, replicaAllowed, outputAllowed, custodialAllowed, vos);
            }
            catch (SQLException sqle) {
                logger.error("update of linkGroup {} failed: {}", (Object)linkGroupName, (Object)sqle.getMessage());
            }
        }
        this.latestLinkGroupUpdateTime = currentTime;
    }

    private long updateLinkGroup(String linkGroupName, long freeSpace, long updateTime, boolean onlineAllowed, boolean nearlineAllowed, boolean replicaAllowed, boolean outputAllowed, boolean custodialAllowed, VOInfo[] linkGroupVOs) throws SQLException {
        Connection connection = null;
        try {
            long id;
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            try {
                LinkGroup group = this.manager.selectForUpdate(connection, linkGroupIO, LinkGroupIO.SELECT_LINKGROUP_FOR_UPDATE_BY_NAME, linkGroupName);
                id = group.getId();
            }
            catch (SQLException e) {
                logger.error("failed to update linkgroup {}: {}", (Object)linkGroupName, (Object)e.getMessage());
                try {
                    connection.rollback();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                id = this.getNextToken(connection);
                try {
                    this.manager.insert(connection, LinkGroupIO.INSERT, id, linkGroupName, freeSpace, updateTime, onlineAllowed ? 1 : 0, nearlineAllowed ? 1 : 0, replicaAllowed ? 1 : 0, outputAllowed ? 1 : 0, custodialAllowed ? 1 : 0, 0);
                }
                catch (SQLException e1) {
                    logger.error("failed to insert linkgroup {}: {}", (Object)linkGroupName, (Object)e1.getMessage());
                    if (connection != null) {
                        connection.rollback();
                        this.connection_pool.returnFailedConnection(connection);
                        connection = null;
                    }
                    throw e1;
                }
            }
            this.manager.update(connection, LinkGroupIO.UPDATE, freeSpace, updateTime, onlineAllowed ? 1 : 0, nearlineAllowed ? 1 : 0, replicaAllowed ? 1 : 0, outputAllowed ? 1 : 0, custodialAllowed ? 1 : 0, id);
            PreparedStatement sqlStatement2 = connection.prepareStatement(selectLinkGroupVOs);
            sqlStatement2.setLong(1, id);
            ResultSet VOsSet = sqlStatement2.executeQuery();
            HashSet<VOInfo> insertVOs = new HashSet<VOInfo>();
            if (linkGroupVOs != null) {
                insertVOs.addAll(Arrays.asList(linkGroupVOs));
            }
            HashSet<VOInfo> deleteVOs = new HashSet<VOInfo>();
            while (VOsSet.next()) {
                String nextVORole;
                String nextVOGroup = VOsSet.getString(1);
                VOInfo nextVO = new VOInfo(nextVOGroup, nextVORole = VOsSet.getString(2));
                if (insertVOs.contains(nextVO)) {
                    insertVOs.remove(nextVO);
                    continue;
                }
                deleteVOs.add(nextVO);
            }
            VOsSet.close();
            sqlStatement2.close();
            for (VOInfo nextVo : insertVOs) {
                this.manager.update(connection, INSERT_LINKGROUP_VO, nextVo.getVoGroup(), nextVo.getVoRole(), id);
            }
            for (VOInfo nextVo : deleteVOs) {
                this.manager.update(connection, DELETE_LINKGROUP_VO, nextVo.getVoGroup(), nextVo.getVoRole(), id);
            }
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
            long l = id;
            return l;
        }
        catch (SQLException sqle) {
            logger.error("update failed: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    private void releaseSpace(Release release) throws SQLException, SpaceException {
        logger.debug("releaseSpace({})", (Object)release);
        long spaceToken = release.getSpaceToken();
        Long spaceToReleaseInBytes = release.getReleaseSizeInBytes();
        Space space = this.getSpace(spaceToken);
        AuthorizationRecord authRecord = release.getAuthRecord();
        this.authorizationPolicy.checkReleasePermission(authRecord, space);
        if (spaceToReleaseInBytes != null) {
            throw new UnsupportedOperationException("partial release is not supported yet");
        }
        this.updateSpaceState(spaceToken, SpaceState.RELEASED);
    }

    private void reserveSpace(Reserve reserve) throws SQLException, SpaceException {
        if (reserve.getRetentionPolicy() == null) {
            throw new IllegalArgumentException("reserveSpace : retentionPolicy=null is not supported");
        }
        long reservationId = this.reserveSpace(reserve.getAuthRecord(), reserve.getSizeInBytes(), reserve.getAccessLatency() == null ? this.defaultLatency : reserve.getAccessLatency(), reserve.getRetentionPolicy(), reserve.getLifetime(), reserve.getDescription(), null, null, null);
        reserve.setSpaceToken(reservationId);
    }

    public File reserveAndUseSpace(String pnfsPath, PnfsId pnfsId, long size, AccessLatency latency, RetentionPolicy policy, AuthorizationRecord authRecord, ProtocolInfo protocolInfo, FileAttributes fileAttributes) throws SQLException, SpaceException {
        long sizeInBytes = size;
        long lifetime = 3600000L;
        String description = null;
        Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_TRANSFERRING_OR_RESERVED_BY_PNFSPATH, pnfsPath = new FsPath(pnfsPath).toString());
        if (files != null && !files.isEmpty()) {
            throw new SQLException("Already have " + files.size() + " record(s) with pnfsPath=" + pnfsPath);
        }
        long reservationId = this.reserveSpace(authRecord, sizeInBytes, latency, policy, lifetime, description, protocolInfo, fileAttributes, pnfsId);
        Space space = this.getSpace(reservationId);
        long fileId = this.useSpace(reservationId, space.getVoGroup(), space.getVoRole(), sizeInBytes, lifetime, pnfsPath, pnfsId);
        File file = this.getFile(fileId);
        return file;
    }

    private void useSpace(Use use) throws SQLException, SpaceException {
        logger.debug("useSpace({})", (Object)use);
        long reservationId = use.getSpaceToken();
        long sizeInBytes = use.getSizeInBytes();
        String voGroup = use.getAuthRecord().getVoGroup();
        String voRole = use.getAuthRecord().getVoRole();
        String pnfsPath = use.getPnfsName();
        PnfsId pnfsId = use.getPnfsId();
        long lifetime = use.getLifetime();
        long fileId = this.useSpace(reservationId, voGroup, voRole, sizeInBytes, lifetime, pnfsPath, pnfsId);
        use.setFileId(fileId);
    }

    private void transferToBeStarted(PoolAcceptFileMessage poolRequest) {
        PnfsId pnfsId = poolRequest.getPnfsId();
        logger.debug("transferToBeStarted({})", (Object)pnfsId);
        try {
            File f = this.getFile(pnfsId);
            Space s = this.getSpace(f.getSpaceId());
            FileAttributes fileAttributes = poolRequest.getFileAttributes();
            fileAttributes.setAccessLatency(s.getAccessLatency());
            fileAttributes.setRetentionPolicy(s.getRetentionPolicy());
            if (fileAttributes.getSize() == 0L && f.getSizeInBytes() > 1L) {
                fileAttributes.setSize(f.getSizeInBytes());
            }
            logger.debug("transferToBeStarted(), set AL to {} RP to {}, sending message to {}", new Object[]{s.getAccessLatency(), s.getRetentionPolicy(), this.pnfsManager});
            try {
                FileAttributes attributesToUpdate = new FileAttributes();
                attributesToUpdate.setAccessLatency(s.getAccessLatency());
                attributesToUpdate.setRetentionPolicy(s.getRetentionPolicy());
                PnfsSetFileAttributes msg = new PnfsSetFileAttributes(pnfsId, attributesToUpdate);
                msg.setReplyRequired(false);
                this.sendMessage(new CellMessage(new CellPath(this.pnfsManager), (Serializable)msg));
            }
            catch (Exception e) {
                logger.error("failed to send PnfsSetStorageInfoMessage message to pnfsmanager: {}", (Object)e.getMessage());
            }
        }
        catch (SQLException sqle) {
            if (Objects.equals(sqle.getSQLState(), "02000")) {
                logger.debug("failed to get space reservation: {}", (Object)sqle.getMessage());
            }
            logger.error("failed to get space reservation: {}", (Object)sqle.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferStarted(PnfsId pnfsId, boolean success) {
        block16: {
            logger.debug("transferStarted({},{})", (Object)pnfsId, (Object)success);
            Connection connection = null;
            try {
                connection = this.connection_pool.getConnection();
                connection.setAutoCommit(false);
                if (!success) {
                    logger.error("transfer start up failed");
                    File f = this.selectFileForUpdate(connection, pnfsId);
                    if (f.getState() == FileState.RESERVED || f.getState() == FileState.TRANSFERRING) {
                        this.removePnfsIdOfFileInSpace(connection, f.getId(), FileState.RESERVED.getStateId());
                        connection.commit();
                        this.connection_pool.returnConnection(connection);
                        connection = null;
                    } else {
                        connection.commit();
                        this.connection_pool.returnConnection(connection);
                        connection = null;
                    }
                    return;
                }
                File f = this.selectFileForUpdate(connection, pnfsId);
                if (f.getState() == FileState.RESERVED || f.getState() == FileState.TRANSFERRING) {
                    this.updateSpaceFile(connection, f.getId(), null, null, null, null, null, FileState.TRANSFERRING.getStateId(), f);
                    connection.commit();
                    this.connection_pool.returnConnection(connection);
                    connection = null;
                } else {
                    connection.commit();
                    this.connection_pool.returnConnection(connection);
                    connection = null;
                }
            }
            catch (SQLException sqle) {
                if (Objects.equals(sqle.getSQLState(), "02000")) {
                    logger.debug("transferStarted failed: {}", (Object)sqle.getMessage());
                } else {
                    logger.error("transferStarted failed: {}", (Object)sqle.getMessage());
                }
                if (connection == null) break block16;
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            finally {
                if (connection != null) {
                    this.connection_pool.returnConnection(connection);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private void transferFinished(DoorTransferFinishedMessage finished) throws Exception {
        block27: {
            boolean weDeleteStoredFileRecord = this.deleteStoredFileRecord;
            PnfsId pnfsId = finished.getPnfsId();
            long size = finished.getFileAttributes().getSize();
            boolean success = finished.getReturnCode() == 0;
            logger.debug("transferFinished({},{})", (Object)pnfsId, (Object)success);
            Connection connection = null;
            try {
                File f;
                connection = this.connection_pool.getConnection();
                connection.setAutoCommit(false);
                try {
                    f = this.selectFileForUpdate(connection, pnfsId);
                }
                catch (SQLException e) {
                    if (Objects.equals(e.getSQLState(), "02000")) {
                        logger.debug("failed to find file {}: {}", (Object)pnfsId, (Object)e.getMessage());
                    } else {
                        logger.error("failed to find file {}: {}", (Object)pnfsId, (Object)e.getMessage());
                    }
                    if (connection != null) {
                        connection.rollback();
                        this.connection_pool.returnConnection(connection);
                        connection = null;
                    }
                    if (connection != null) {
                        this.connection_pool.returnConnection(connection);
                    }
                    return;
                }
                catch (Exception e) {
                    logger.error("failed to find file {}", (Object)pnfsId, (Object)e);
                    if (connection != null) {
                        connection.rollback();
                        this.connection_pool.returnConnection(connection);
                        connection = null;
                    }
                    if (connection != null) {
                        this.connection_pool.returnConnection(connection);
                    }
                    return;
                }
                long spaceId = f.getSpaceId();
                if (f.getState() == FileState.RESERVED || f.getState() == FileState.TRANSFERRING) {
                    if (success) {
                        RetentionPolicy rp;
                        if (this.returnFlushedSpaceToReservation && weDeleteStoredFileRecord && (rp = this.getSpace(spaceId).getRetentionPolicy()).equals((Object)RetentionPolicy.CUSTODIAL)) {
                            weDeleteStoredFileRecord = false;
                        }
                        if (weDeleteStoredFileRecord) {
                            logger.debug("file transfered, deleting file record");
                            this.removeFileFromSpace(connection, f);
                        } else {
                            this.updateSpaceFile(connection, f.getId(), null, null, null, size, null, FileState.STORED.getStateId(), f);
                        }
                    } else {
                        this.updateSpaceFile(connection, f.getId(), null, null, null, null, null, FileState.RESERVED.getStateId(), f);
                        this.removePnfsIdOfFileInSpace(connection, f.getId(), null);
                    }
                    connection.commit();
                    this.connection_pool.returnConnection(connection);
                    connection = null;
                } else {
                    logger.debug("transferFinished({}): file state={}", (Object)pnfsId, (Object)f.getState());
                    connection.commit();
                    this.connection_pool.returnConnection(connection);
                    connection = null;
                }
                break block27;
                {
                    catch (SQLException sqle) {
                        logger.error("transferFinished failed: {}", (Object)sqle.getMessage());
                        if (connection != null) {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException sqle1) {
                                // empty catch block
                            }
                            this.connection_pool.returnFailedConnection(connection);
                            connection = null;
                        }
                        throw sqle;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (connection != null) {
                    this.connection_pool.returnConnection(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileFlushed(PoolFileFlushedMessage fileFlushed) throws Exception {
        block15: {
            if (!this.returnFlushedSpaceToReservation) {
                return;
            }
            PnfsId pnfsId = fileFlushed.getPnfsId();
            Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_BY_PNFSID, pnfsId.toString());
            if (files.isEmpty()) {
                return;
            }
            logger.debug("fileFlushed({})", (Object)pnfsId);
            FileAttributes fileAttributes = fileFlushed.getFileAttributes();
            AccessLatency ac = fileAttributes.getAccessLatency();
            if (ac.equals((Object)AccessLatency.ONLINE)) {
                logger.debug("File Access latency is ONLINE fileFlushed does nothing");
                return;
            }
            long size = fileAttributes.getSize();
            Connection connection = null;
            try {
                connection = this.connection_pool.getConnection();
                connection.setAutoCommit(false);
                File f = this.selectFileForUpdate(connection, pnfsId);
                if (f.getState() == FileState.STORED) {
                    if (this.deleteStoredFileRecord) {
                        logger.debug("returnSpaceToReservation, deleting file record");
                        this.removeFileFromSpace(connection, f);
                    } else {
                        this.updateSpaceFile(connection, f.getId(), null, null, null, size, null, FileState.FLUSHED.getStateId(), f);
                        connection.commit();
                        this.connection_pool.returnConnection(connection);
                        connection = null;
                    }
                } else {
                    logger.debug("returnSpaceToReservation({}): file state={}", (Object)pnfsId, (Object)f.getState());
                    connection.commit();
                    this.connection_pool.returnConnection(connection);
                    connection = null;
                }
            }
            catch (SQLException sqle) {
                logger.error("failed to return space to reservation: {}", (Object)sqle.getMessage());
                if (connection == null) break block15;
                try {
                    connection.rollback();
                }
                catch (SQLException sqle1) {
                    // empty catch block
                }
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            finally {
                if (connection != null) {
                    this.connection_pool.returnConnection(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileRemoved(PoolRemoveFilesMessage fileRemoved) {
        logger.debug("fileRemoved()");
        String[] pnfsIdStrings = fileRemoved.getFiles();
        if (pnfsIdStrings == null || pnfsIdStrings.length == 0) {
            return;
        }
        for (String pnfsIdString : pnfsIdStrings) {
            PnfsId pnfsId;
            try {
                pnfsId = new PnfsId(pnfsIdString);
            }
            catch (Exception e) {
                logger.error("badly formed PNFS-ID: {}", (Object)e.getMessage());
                continue;
            }
            logger.debug("fileRemoved({})", (Object)pnfsId);
            if (!this.returnRemovedSpaceToReservation) {
                return;
            }
            Connection connection = null;
            try {
                connection = this.connection_pool.getConnection();
                connection.setAutoCommit(false);
                File f = this.selectFileForUpdate(connection, pnfsId);
                this.removeFileFromSpace(connection, f);
                connection.commit();
                this.connection_pool.returnConnection(connection);
                connection = null;
            }
            catch (SQLException sqle) {
                logger.debug("failed to remove file from space: {}", (Object)sqle.getMessage());
                logger.debug("fileRemoved({}): file not in a reservation, do nothing", (Object)pnfsId);
                if (connection == null) continue;
                try {
                    connection.rollback();
                }
                catch (SQLException sqle1) {
                    // empty catch block
                }
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            finally {
                if (connection != null) {
                    this.connection_pool.returnConnection(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUseSpace(CancelUse cancelUse) throws SQLException, SpaceException {
        block13: {
            logger.debug("cancelUseSpace({})", (Object)cancelUse);
            long reservationId = cancelUse.getSpaceToken();
            String pnfsPath = cancelUse.getPnfsName();
            Connection connection = null;
            try {
                File f;
                connection = this.connection_pool.getConnection();
                connection.setAutoCommit(false);
                try {
                    f = this.selectFileFromSpaceForUpdate(connection, pnfsPath, reservationId);
                }
                catch (SQLException sqle) {
                    if (connection != null) {
                        this.connection_pool.returnConnection(connection);
                        connection = null;
                    }
                    if (connection != null) {
                        this.connection_pool.returnFailedConnection(connection);
                        connection = null;
                    }
                    return;
                }
                if (f.getState() != FileState.RESERVED && f.getState() != FileState.TRANSFERRING) break block13;
                try {
                    this.removeFileFromSpace(connection, f);
                    this.connection_pool.returnConnection(connection);
                    connection = null;
                }
                finally {
                    if (connection != null) {
                        logger.warn("failed to remove file {}", (Object)pnfsPath);
                        this.connection_pool.returnFailedConnection(connection);
                        connection = null;
                    }
                }
            }
            finally {
                if (connection != null) {
                    this.connection_pool.returnFailedConnection(connection);
                    connection = null;
                }
            }
        }
    }

    private long reserveSpace(String voGroup, String voRole, long sizeInBytes, AccessLatency latency, RetentionPolicy policy, long lifetime, String description) throws SQLException, SpaceException {
        logger.debug("reserveSpace(group={}, role={}, sz={}, latency={}, policy={}, lifetime={}, description={}", new Object[]{voGroup, voRole, sizeInBytes, latency, policy, lifetime, description});
        boolean needHsmBackup = policy.equals((Object)RetentionPolicy.CUSTODIAL);
        logger.debug("policy is {}, needHsmBackup is {}", (Object)policy, (Object)needHsmBackup);
        Long[] linkGroups = this.findLinkGroupIds(sizeInBytes, voGroup, voRole, latency, policy);
        if (linkGroups.length == 0) {
            logger.warn("find LinkGroup Ids returned 0 linkGroups, no linkGroups found");
            throw new NoFreeSpaceException(" no space available");
        }
        Long linkGroupId = linkGroups[0];
        return this.reserveSpaceInLinkGroup(linkGroupId, voGroup, voRole, sizeInBytes, latency, policy, lifetime, description);
    }

    private long reserveSpace(AuthorizationRecord authRecord, long sizeInBytes, AccessLatency latency, RetentionPolicy policy, long lifetime, String description, ProtocolInfo protocolInfo, FileAttributes fileAttributes, PnfsId pnfsId) throws SQLException, SpaceException {
        VOInfo voInfo;
        logger.debug("reserveSpace( ar={}, sz={}, latency={}, policy={}, lifetime={}, description={}", new Object[]{authRecord, sizeInBytes, latency, policy, lifetime, description});
        boolean needHsmBackup = policy.equals((Object)RetentionPolicy.CUSTODIAL);
        logger.debug("policy is {}, needHsmBackup is {}", (Object)policy, (Object)needHsmBackup);
        Set<LinkGroup> linkGroups = this.findLinkGroupIds(sizeInBytes, latency, policy);
        if (linkGroups.isEmpty()) {
            logger.warn("failed to find matching linkgroup");
            throw new NoFreeSpaceException(" no space available");
        }
        HashMap<String, VOInfo> linkGroupNameVoInfoMap = new HashMap<String, VOInfo>();
        for (LinkGroup linkGroup : linkGroups) {
            try {
                voInfo = this.authorizationPolicy.checkReservePermission(authRecord, linkGroup);
                linkGroupNameVoInfoMap.put(linkGroup.getName(), voInfo);
            }
            catch (SpaceAuthorizationException e) {}
        }
        if (linkGroupNameVoInfoMap.isEmpty()) {
            logger.warn("failed to find linkgroup where user is authorized to reserve space.");
            throw new SpaceAuthorizationException("Failed to find LinkGroup where user is authorized to reserve space.");
        }
        List<String> linkGroupNames = new ArrayList<String>(linkGroupNameVoInfoMap.keySet());
        logger.debug("Found {} linkgroups protocolInfo={}, storageInfo={}, pnfsId={}", new Object[]{linkGroups.size(), protocolInfo, fileAttributes, pnfsId});
        if (linkGroupNameVoInfoMap.size() > 1 && protocolInfo != null && fileAttributes != null) {
            try {
                PoolManagerSelectLinkGroupForWriteMessage msg = new PoolManagerSelectLinkGroupForWriteMessage(pnfsId, fileAttributes, protocolInfo, sizeInBytes);
                msg.setLinkGroups(linkGroupNames);
                logger.debug("Sending PoolManagerSelectLinkGroupForWriteMessage");
                msg = this._poolManagerStub.sendAndWait(msg);
                linkGroupNames = msg.getLinkGroups();
                logger.debug("received PoolManagerSelectLinkGroupForWriteMessage reply, number of LinkGroups={}", (Object)linkGroupNames.size());
                if (linkGroupNames.isEmpty()) {
                    throw new SpaceAuthorizationException("PoolManagerSelectLinkGroupForWriteMessage: Failed to find LinkGroup where user is authorized to reserve space.");
                }
            }
            catch (TimeoutCacheException e) {
                throw new SpaceException("PoolManagerSelectLinkGroupForWriteMessage: request timed out ", e);
            }
            catch (CacheException e) {
                throw new SpaceException("Internal error : PoolManagerSelectLinkGroupForWriteMessage  exception ", e);
            }
            catch (InterruptedException e) {
                throw new SpaceException("Request was interrupted", e);
            }
            catch (SpaceAuthorizationException e) {
                logger.warn("authorization problem: {}", (Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                throw new SpaceException("Internal error : Failed to get list of link group ids from Pool Manager " + e.getMessage());
            }
        }
        String linkGroupName = (String)linkGroupNames.get(0);
        voInfo = (VOInfo)linkGroupNameVoInfoMap.get(linkGroupName);
        LinkGroup linkGroup = null;
        for (LinkGroup lg : linkGroups) {
            if (!lg.getName().equals(linkGroupName)) continue;
            linkGroup = lg;
            break;
        }
        logger.debug("Chose linkgroup {}", linkGroup);
        return this.reserveSpaceInLinkGroup(linkGroup.getId(), voInfo.getVoGroup(), voInfo.getVoRole(), sizeInBytes, latency, policy, lifetime, description);
    }

    private long reserveSpaceInLinkGroup(long linkGroupId, String voGroup, String voRole, long sizeInBytes, AccessLatency latency, RetentionPolicy policy, long lifetime, String description) throws SQLException {
        logger.debug("reserveSpaceInLinkGroup(linkGroupId={}, group={}, role={}, sz={}, latency={}, policy={}, lifetime={}, description={})", new Object[]{linkGroupId, voGroup, voRole, sizeInBytes, latency, policy, lifetime, description});
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            long spaceReservationId = this.getNextToken(connection);
            this.insertSpaceReservation(connection, spaceReservationId, voGroup, voRole, policy, latency, linkGroupId, sizeInBytes, lifetime, description, 0, 0L, 0L);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
            long l = spaceReservationId;
            return l;
        }
        catch (SQLException sqle) {
            logger.error("failed to reserve space: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    private long useSpace(long reservationId, String voGroup, String voRole, long sizeInBytes, long lifetime, String pnfsPath, PnfsId pnfsId) throws SQLException, SpaceException {
        Connection connection = null;
        Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_TRANSFERRING_OR_RESERVED_BY_PNFSPATH, pnfsPath = new FsPath(pnfsPath).toString());
        if (files != null && !files.isEmpty()) {
            throw new SQLException("Already have " + files.size() + " record(s) with pnfsPath=" + pnfsPath);
        }
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            long fileId = this.getNextToken(connection);
            this.insertFileInSpace(connection, fileId, voGroup, voRole, reservationId, sizeInBytes, lifetime, pnfsPath, pnfsId, SpaceState.RESERVED.getStateId());
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
            long l = fileId;
            return l;
        }
        catch (SpaceException | SQLException sqle) {
            logger.error("failed to insert file into space: {}", (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectPool(CellMessage cellMessage, PoolMgrSelectWritePoolMsg selectWritePool, boolean isReply) throws Exception {
        FileAttributes fileAttributes;
        File file;
        block27: {
            block26: {
                logger.debug("selectPool({})", (Object)selectWritePool);
                String pnfsPath = selectWritePool.getPnfsPath();
                PnfsId pnfsId = selectWritePool.getPnfsId();
                if (pnfsPath == null) {
                    logger.debug("selectPool: pnfsPath is null");
                    if (!isReply) {
                        logger.debug("just forwarding the message to {}", (Object)this.poolManager);
                        cellMessage.getDestinationPath().add(new CellPath(this.poolManager));
                        cellMessage.nextDestination();
                        this.sendMessage(cellMessage);
                    }
                    return;
                }
                file = null;
                try {
                    logger.debug("selectPool: getFiles({})", (Object)pnfsPath);
                    Set<File> files = this.getFiles(pnfsPath);
                    for (File f : files) {
                        if (f.getPnfsId() != null) continue;
                        file = f;
                        break;
                    }
                }
                catch (Exception e) {
                    logger.info("failed to find pool: {}", (Object)e.getMessage());
                }
                fileAttributes = selectWritePool.getFileAttributes();
                if (file == null) {
                    AccessLatency al = fileAttributes.getAccessLatency();
                    RetentionPolicy rp = fileAttributes.getRetentionPolicy();
                    String defaultSpaceToken = fileAttributes.getStorageInfo().getMap().get("writeToken");
                    ProtocolInfo protocolInfo = selectWritePool.getProtocolInfo();
                    Subject subject = selectWritePool.getSubject();
                    AuthorizationRecord authRecord = Subjects.getFqans((Subject)subject).isEmpty() && Subjects.getUserName((Subject)subject) == null ? null : new AuthorizationRecord(subject);
                    if (defaultSpaceToken == null) {
                        if (this.reserveSpaceForNonSRMTransfers && authRecord != null) {
                            logger.debug("selectPool: file is not found, no prior reservations for this file, calling reserveAndUseSpace()");
                            file = this.reserveAndUseSpace(pnfsPath, null, selectWritePool.getPreallocated(), al, rp, authRecord, protocolInfo, fileAttributes);
                            logger.debug("selectPool: file is not found, reserveAndUseSpace() returned {}", (Object)file);
                            break block26;
                        } else {
                            logger.debug("selectPool: file is not found, no prior reservations for this file reserveSpaceForNonSRMTransfers={} authrecord={}", (Object)this.reserveSpaceForNonSRMTransfers, authRecord != null ? authRecord : "none");
                            if (!isReply) {
                                this.forwardToPoolmanager(cellMessage);
                            }
                            return;
                        }
                    }
                    logger.debug("selectPool: file is not found, found default space token, calling useSpace()");
                    String voGroup = null;
                    String voRole = null;
                    long lifetime = 3600000L;
                    if (authRecord != null) {
                        voGroup = authRecord.getVoGroup();
                        voRole = authRecord.getVoRole();
                    }
                    long spaceToken = Long.parseLong(defaultSpaceToken);
                    long fileId = this.useSpace(spaceToken, voGroup, voRole, selectWritePool.getPreallocated(), lifetime, pnfsPath, null);
                    file = this.getFile(fileId);
                } else if (isReply && selectWritePool.getReturnCode() == 0) {
                    logger.debug("selectPool: file is not null, calling updateSpaceFile()");
                    this.updateSpaceFile(file.getId(), null, null, pnfsId, null, null, null);
                }
            }
            if (isReply && selectWritePool.getReturnCode() != 0) {
                Connection connection = null;
                try {
                    connection = this.connection_pool.getConnection();
                    connection.setAutoCommit(false);
                    this.removePnfsIdOfFileInSpace(connection, file.getId(), null);
                    connection.commit();
                    this.connection_pool.returnConnection(connection);
                    connection = null;
                }
                catch (SQLException sqle) {
                    logger.error("failed to remove file {}: {}", (Object)file, (Object)sqle.getMessage());
                    if (connection == null) break block27;
                    try {
                        connection.rollback();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.connection_pool.returnFailedConnection(connection);
                    connection = null;
                }
                finally {
                    if (connection != null) {
                        this.connection_pool.returnConnection(connection);
                    }
                }
            }
        }
        if (!isReply) {
            long spaceId = file.getSpaceId();
            Space space = this.getSpace(spaceId);
            long linkGroupid = space.getLinkGroupId();
            LinkGroup linkGroup = this.getLinkGroup(linkGroupid);
            String linkGroupName = linkGroup.getName();
            selectWritePool.setLinkGroup(linkGroupName);
            StorageInfo storageInfo = selectWritePool.getStorageInfo();
            storageInfo.setKey("SpaceToken", Long.toString(spaceId));
            if (fileAttributes.getSize() == 0L && file.getSizeInBytes() > 1L) {
                fileAttributes.setSize(file.getSizeInBytes());
            }
            if (space.getDescription() != null) {
                storageInfo.setKey("SpaceTokenDescription", space.getDescription());
            }
            cellMessage.getDestinationPath().add(new CellPath(this.poolManager));
            cellMessage.nextDestination();
            logger.debug("selectPool: found linkGroup = {}, forwarding message", (Object)linkGroupName);
            this.sendMessage(cellMessage);
        }
    }

    private void forwardToPoolmanager(CellMessage cellMessage) {
        logger.debug("just forwarding the message to {}", (Object)this.poolManager);
        cellMessage.getDestinationPath().add(new CellPath(this.poolManager));
        cellMessage.nextDestination();
        try {
            this.sendMessage(cellMessage);
        }
        catch (NoRouteToCellException | SerializationException e) {
            logger.error("failed to forward message: {}", (Object)e.getMessage());
        }
    }

    public void markFileDeleted(PnfsDeleteEntryNotificationMessage msg) throws Exception {
        File file;
        if (msg.getReturnCode() != 0) {
            return;
        }
        if (msg.getPnfsId() == null) {
            return;
        }
        try {
            Set<File> files = this.manager.selectPrepared(fileIO, FileIO.SELECT_BY_PNFSID, msg.getPnfsId().toString());
            if (files.isEmpty()) {
                return;
            }
            if (files.size() > 1) {
                throw new SQLException("found two records with pnfsId=" + (msg.getPnfsId() != null ? msg.getPnfsId() : "null"));
            }
            file = (File)Iterables.getFirst(files, null);
        }
        catch (Exception e) {
            logger.error("failed to retrieve file {} {}: {}", new Object[]{msg.getPnfsId() != null ? msg.getPnfsId() : "(no PNFS-ID)", msg.getPnfsPath() != null ? msg.getPnfsPath() : "(no path)", e.getMessage()});
            return;
        }
        logger.debug("Marking file as deleted {}", (Object)file);
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            File f = this.selectFileForUpdate(connection, file.getId());
            int rc = this.manager.update(connection, FileIO.UPDATE_DELETED_FLAG, 1, f.getId());
            if (rc != 1) {
                throw new SQLException("Update failed, row count=" + rc);
            }
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
        }
        catch (SQLException e) {
            logger.error("failed to mark file {} as deleted: {}", (Object)file, (Object)e.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw e;
        }
    }

    public String getPnfsManager() {
        return this.pnfsManager;
    }

    public String getPoolManager() {
        return this.poolManager;
    }

    public void getSpaceMetaData(GetSpaceMetaData gsmd) throws Exception {
        long[] tokens = gsmd.getSpaceTokens();
        if (tokens == null) {
            throw new IllegalArgumentException("null space tokens");
        }
        Space[] spaces = new Space[tokens.length];
        for (int i = 0; i < spaces.length; ++i) {
            try {
                spaces[i] = this.getSpace(tokens[i]);
                continue;
            }
            catch (Exception e) {
                logger.error("failed to find space {}: {}", (Object)tokens[i], (Object)e.getMessage());
                spaces[i] = null;
            }
        }
        gsmd.setSpaces(spaces);
    }

    public void getSpaceTokens(GetSpaceTokens gst) throws Exception {
        String description = gst.getDescription();
        long[] tokens = this.getSpaceTokens(gst.getAuthRecord(), description);
        gst.setSpaceToken(tokens);
    }

    public void getFileSpaceTokens(GetFileSpaceTokensMessage getFileTokens) throws Exception {
        PnfsId pnfsId = getFileTokens.getPnfsId();
        String pnfsPath = getFileTokens.getPnfsPath();
        if (pnfsId == null && pnfsPath == null) {
            throw new IllegalArgumentException("null voGroup");
        }
        long[] tokens = this.getFileSpaceTokens(pnfsId, pnfsPath);
        getFileTokens.setSpaceToken(tokens);
    }

    public void extendLifetime(ExtendLifetime extendLifetime) throws Exception {
        long token = extendLifetime.getSpaceToken();
        long newLifetime = extendLifetime.getNewLifetime();
        Connection connection = null;
        try {
            connection = this.connection_pool.getConnection();
            connection.setAutoCommit(false);
            Space space = this.selectSpaceForUpdate(connection, token);
            if (SpaceState.isFinalState(space.getState())) {
                connection.rollback();
                this.connection_pool.returnConnection(connection);
                connection = null;
                throw new Exception("Space Is already Released");
            }
            long creationTime = space.getCreationTime();
            long lifetime = space.getLifetime();
            if (lifetime == -1L) {
                connection.rollback();
                this.connection_pool.returnConnection(connection);
                connection = null;
                return;
            }
            if (newLifetime == -1L) {
                this.manager.update(connection, SpaceReservationIO.UPDATE_LIFETIME, newLifetime, token);
                connection.commit();
                this.connection_pool.returnConnection(connection);
                connection = null;
                return;
            }
            long currentTime = System.currentTimeMillis();
            long remainingLifetime = creationTime + lifetime - currentTime;
            if (remainingLifetime > newLifetime) {
                connection.rollback();
                this.connection_pool.returnConnection(connection);
                connection = null;
                return;
            }
            this.manager.update(connection, SpaceReservationIO.UPDATE_LIFETIME, newLifetime, token);
            connection.commit();
            this.connection_pool.returnConnection(connection);
            connection = null;
        }
        catch (SQLException sqle) {
            logger.error("failed to extend lifetime for {}: {}", (Object)token, (Object)sqle.getMessage());
            if (connection != null) {
                connection.rollback();
                this.connection_pool.returnFailedConnection(connection);
                connection = null;
            }
            throw sqle;
        }
        finally {
            if (connection != null) {
                this.connection_pool.returnConnection(connection);
            }
        }
    }

    public void decrementReservedSpaceInLinkGroup(Connection connection, long id, long size) throws SQLException {
        this.manager.update(connection, LinkGroupIO.DECREMENT_RESERVED_SPACE, size, id);
    }

    public void incrementReservedSpaceInLinkGroup(Connection connection, long id, long size) throws SQLException {
        this.manager.update(connection, LinkGroupIO.INCREMENT_RESERVED_SPACE, size, id);
    }

    public void decrementFreeSpaceInLinkGroup(Connection connection, long id, long size) throws SQLException {
        this.manager.update(connection, LinkGroupIO.DECREMENT_FREE_SPACE, size, id);
    }

    public void incrementFreeSpaceInLinkGroup(Connection connection, long id, long size) throws SQLException {
        this.manager.update(connection, LinkGroupIO.INCREMENT_FREE_SPACE, size, id);
    }

    public void decrementAllocatedSpaceInSpaceReservation(Connection connection, Space space, long size) throws SQLException {
        this.manager.update(connection, SpaceReservationIO.DECREMENT_ALLOCATED_SPACE, size, space.getId());
    }

    public void incrementAllocatedSpaceInSpaceReservation(Connection connection, Space space, long size) throws SQLException {
        this.manager.update(connection, SpaceReservationIO.INCREMENT_ALLOCATED_SPACE, size, space.getId());
    }

    public void decrementUsedSpaceInSpaceReservation(Connection connection, Space space, long size) throws SQLException {
        LinkGroup group = this.selectLinkGroupForUpdate(connection, space.getLinkGroupId());
        this.manager.update(connection, SpaceReservationIO.DECREMENT_USED_SPACE, size, space.getId());
        if (space.getState() == SpaceState.RESERVED) {
            this.incrementReservedSpaceInLinkGroup(connection, group.getId(), size);
        }
    }

    public void incrementUsedSpaceInSpaceReservation(Connection connection, Space space, long size) throws SQLException {
        LinkGroup group = this.selectLinkGroupForUpdate(connection, space.getLinkGroupId());
        this.manager.update(connection, SpaceReservationIO.INCREMENT_USED_SPACE, size, space.getId());
        if (space.getState() == SpaceState.RESERVED) {
            this.decrementReservedSpaceInLinkGroup(connection, group.getId(), size);
        }
    }
}

