/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services;

import diskCacheV111.poolManager.PoolManagerCellInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import dmg.util.CellCron;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolStatisticsV0
extends CellAdapter
implements CellCron.TaskRunnable {
    private static final Logger _log = LoggerFactory.getLogger(PoolStatisticsV0.class);
    private CellNucleus _nucleus;
    private Args _args;
    private static final String GET_REP_STATISTICS = "rep ls -s -binary";
    private static final String GET_CELL_INFO = "xgetcellinfo";
    private static final String GET_POOL_STATISTICS = "get pool statistics";
    private static final String RESET_POOL_STATISTICS = "clear pool statistics";
    private static final int YESTERDAY = 0;
    private static final int TODAY = 2;
    private static final int TRANSFER_IN = 8;
    private static final int TRANSFER_OUT = 9;
    private static final int RESTORE = 10;
    private static final int STORE = 11;
    private static final String defaultAuthor = "&copy; dCache.org ";
    private SimpleDateFormat _pathFromDate = new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "yyyy-MM-dd-HH'.raw'");
    private SimpleDateFormat _dayPathFromDate = new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "yyyy-MM-dd-'day.raw'");
    private SimpleDateFormat _dayDiffPathFromDate = new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator + "dd" + File.separator + "yyyy-MM-dd-'day.drw'");
    private SimpleDateFormat _todayHtmlBaseFromDate = new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator + "yyyy-MM-dd-");
    private SimpleDateFormat _htmlPathFromDate = new SimpleDateFormat("yyyy" + File.separator + "MM" + File.separator + "dd");
    private SimpleDateFormat _yearOfCalendar = new SimpleDateFormat("yyyy");
    private SimpleDateFormat _monthOfCalendar = new SimpleDateFormat("MMM MM yyyy");
    private SimpleDateFormat _dayOfCalendar = new SimpleDateFormat("MM/dd yyyy (EEE)");
    private SimpleDateFormat _dayOfCalendarKey = new SimpleDateFormat("EEE-MM/dd-yyyy");
    private CellCron _cron = new CellCron(false);
    private Thread _cronTimer;
    private CellCron.TimerTask _hourly;
    private File _dbBase;
    private File _htmlBase;
    private static String _domainName = "dCache.Unknown.Org";
    private Map<String, Map<String, long[]>> _recentPoolStatistics;
    private boolean _createHtmlTree = true;
    private String _images = "/images";
    private static String _bodyString = "<body bgcolor=white>";
    public static final String hh_set_html_body = "<bodyString> ; eg: \"<body background=/images/bg.svg>\"";
    public static final String hh_create_html = "[<year> [<month> [[<day>]]]";
    public static final String hh_create_stat = "[<outputFileName>]";
    public static final String hh_show = "[<pattern>]";

    public PoolStatisticsV0(String name, String args) throws Exception {
        super(name, args, false);
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        try {
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... <baseDirectory> [-htmlBase=<htmlBase>|none] [-create] [-images=<images>]");
            }
            this._htmlBase = this._dbBase = new File(this._args.argv(0));
            String tmp = this._args.getOpt("htmlBase");
            if (tmp != null && tmp.length() > 0) {
                if (tmp.equals("none")) {
                    this._createHtmlTree = false;
                } else {
                    this._htmlBase = new File(tmp);
                }
            }
            if ((tmp = this._args.getOpt("domain")) != null) {
                _domainName = tmp;
            }
            if (this._args.hasOption("create")) {
                if (!this._dbBase.exists()) {
                    this._dbBase.mkdirs();
                }
                if (this._createHtmlTree && !this._htmlBase.exists()) {
                    this._htmlBase.mkdirs();
                }
            } else if (!this._dbBase.exists() || this._createHtmlTree && !this._htmlBase.exists()) {
                throw new IllegalArgumentException("Either <baseDirectory> or <htmlBase> doesn't exist");
            }
            this._cronTimer = this._nucleus.newThread((Runnable)this._cron, "Cron");
            this._cronTimer.start();
            this._hourly = this._cron.add(55, (CellCron.TaskRunnable)this, "Hour");
        }
        catch (Exception ee) {
            this.start();
            this.kill();
            throw ee;
        }
        this.start();
    }

    public void getInfo(PrintWriter pw) {
        pw.println("   Cell Name : " + this.getCellName());
        pw.println("  Cell Class : " + ((Object)((Object)this)).getClass().getName());
        pw.println("     Version : $Revision$");
        pw.println("   Stat Base : " + this._dbBase);
        pw.println("   Html Base : " + this._htmlBase);
        pw.println("      Images : " + this._images);
        pw.println("    Next Run : " + this._hourly);
    }

    public void messageArrived(CellMessage message) {
    }

    private String getNiceDayOfCalendar(Calendar calendar) {
        return this._dayOfCalendar.format(calendar.getTime());
    }

    private File getCurrentPath(Calendar calendar) {
        return new File(this._dbBase, this._pathFromDate.format(calendar.getTime()));
    }

    private File getTodayPath(Calendar calendar) {
        return new File(this._dbBase, this._dayPathFromDate.format(calendar.getTime()));
    }

    private File getTodayHtmlPath(Calendar calendar) {
        return new File(this._dbBase, this._todayHtmlBaseFromDate.format(calendar.getTime()));
    }

    private File getTodayDiffPath(Calendar calendar) {
        return new File(this._dbBase, this._dayDiffPathFromDate.format(calendar.getTime()));
    }

    private File getYesterdayPath(Calendar calendar) {
        calendar = (Calendar)calendar.clone();
        calendar.set(6, calendar.get(6) - 1);
        return this.getTodayPath(calendar);
    }

    private File getHtmlPath(Calendar calendar) {
        return new File(this._htmlBase, this._htmlPathFromDate.format(calendar.getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File from, File to) throws IOException {
        FileInputStream in = new FileInputStream(from);
        try {
            FileOutputStream out = new FileOutputStream(to);
            try {
                int rc;
                byte[] buffer = new byte[16384];
                while ((rc = ((InputStream)in).read(buffer, 0, buffer.length)) > 0) {
                    ((OutputStream)out).write(buffer, 0, rc);
                }
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception iii) {}
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception eee) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDiffFile(File today, File yesterday, File resultFile) throws IOException {
        DataStore todayStore = new DataStore(today);
        Map<String, long[]> todayMap = todayStore.getLinearMap();
        String todayTimeString = (String)todayStore.get("timestamp");
        long todayTime = 0L;
        try {
            todayTime = todayTimeString == null ? 0L : Long.parseLong(todayTimeString);
        }
        catch (Exception ee) {
            // empty catch block
        }
        Map<String, long[]> yesterdayMap = new DataStore(yesterday).getLinearMap();
        HashMap<String, long[]> resultMap = new HashMap<String, long[]>();
        for (Map.Entry<String, long[]> entry : todayMap.entrySet()) {
            String key = entry.getKey();
            long[] counter = entry.getValue();
            long[] result = new long[12];
            long[] yesterdayCounter = yesterdayMap.get(key);
            if (yesterdayCounter == null) {
                result[0] = -1L;
                result[1] = -1L;
            } else {
                result[0] = yesterdayCounter[0];
                result[1] = yesterdayCounter[1];
            }
            System.arraycopy(counter, 0, result, 2, 10);
            resultMap.put(key, result);
        }
        resultFile.delete();
        PrintWriter pw = new PrintWriter(new FileWriter(resultFile));
        try {
            pw.println("#");
            Iterator<Map.Entry<String, Object>> it = todayStore.iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                pw.println("# " + entry.getKey() + "=" + entry.getValue());
            }
            pw.println("#");
            for (Map.Entry entry : resultMap.entrySet()) {
                pw.print((String)entry.getKey());
                for (long l : (long[])entry.getValue()) {
                    pw.print(" ");
                    pw.print(l);
                }
                pw.println("");
            }
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception eee) {}
        }
    }

    public void run(CellCron.TimerTask task) {
        if (task == this._hourly) {
            _log.info("Hourly ticker : " + new Date());
            Calendar calendar = (Calendar)task.getCalendar().clone();
            new HourlyRunner(calendar);
            task.repeatNextHour();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtmlMonth(Calendar calendar) throws IOException {
        File dir = this.getHtmlPath(calendar).getParentFile();
        File[] list = dir.listFiles(new MonthFileFilter());
        list = this.resortFileList(list, -1);
        long[] counter = new long[12];
        long[] total = new long[12];
        long[] lastInMonth = new long[12];
        BaseStatisticsHtml html = new BaseStatisticsHtml();
        html.setSorted(false);
        html.setTitle(this._monthOfCalendar.format(calendar.getTime()));
        html.setKeyType("Date");
        html.setAuthor(defaultAuthor);
        html.setHeader(new MonthDirectoryHeader(calendar.getTime()));
        int n = list.length;
        for (int i = 0; i < n; ++i) {
            File x = new File(list[i], "total.raw");
            if (!x.exists()) continue;
            try {
                BufferedReader br = new BufferedReader(new FileReader(x));
                try {
                    String line = br.readLine();
                    if (line == null || line.length() < 12) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    String key = this._dayOfCalendar.format(new Date(Long.parseLong(st.nextToken())));
                    for (int j = 0; j < counter.length; ++j) {
                        counter[j] = Long.parseLong(st.nextToken());
                    }
                    if (i == 0) {
                        System.arraycopy(counter, 0, lastInMonth, 0, counter.length);
                    }
                    this.add(total, counter);
                    html.add(key, list[i].getName() + File.separator + "index.html", counter);
                    continue;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException eee) {}
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(new File(dir, "index.html")));){
            html.setPrintWriter(pw);
            html.dump();
        }
        total[0] = counter[0];
        total[1] = counter[1];
        total[2] = lastInMonth[2];
        total[3] = lastInMonth[3];
        this.printTotal(new File(dir, "total.raw"), total, calendar.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtmlYear(Calendar calendar) throws IOException {
        File dir = this.getHtmlPath(calendar).getParentFile().getParentFile();
        File[] list = dir.listFiles(new MonthFileFilter());
        list = this.resortFileList(list, -1);
        long[] counter = new long[12];
        long[] total = new long[12];
        long[] lastInMonth = new long[12];
        BaseStatisticsHtml html = new BaseStatisticsHtml();
        html.setSorted(false);
        html.setTitle(this._yearOfCalendar.format(calendar.getTime()));
        html.setKeyType("Date");
        html.setAuthor(defaultAuthor);
        html.setHeader(new YearDirectoryHeader(calendar.getTime()));
        int n = list.length;
        for (int i = 0; i < n; ++i) {
            File x = new File(list[i], "total.raw");
            if (!x.exists()) continue;
            try {
                BufferedReader br = new BufferedReader(new FileReader(x));
                try {
                    String line = br.readLine();
                    if (line == null || line.length() < 12) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    String key = this._monthOfCalendar.format(new Date(Long.parseLong(st.nextToken())));
                    for (int j = 0; j < counter.length; ++j) {
                        counter[j] = Long.parseLong(st.nextToken());
                    }
                    if (i == 0) {
                        System.arraycopy(counter, 0, lastInMonth, 0, counter.length);
                    }
                    this.add(total, counter);
                    html.add(key, list[i].getName() + File.separator + "index.html", counter);
                    continue;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException eee) {}
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(new File(dir, "index.html")));){
            html.setPrintWriter(pw);
            html.dump();
        }
        total[0] = counter[0];
        total[1] = counter[1];
        total[2] = lastInMonth[2];
        total[3] = lastInMonth[3];
        this.printTotal(new File(dir, "total.raw"), total, calendar.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHtmlTop() throws IOException {
        File dir = this._htmlBase;
        File[] list = dir.listFiles(new YearFileFilter());
        list = this.resortFileList(list, -1);
        long[] counter = new long[12];
        long[] total = new long[12];
        long[] lastInYear = new long[12];
        BaseStatisticsHtml html = new BaseStatisticsHtml();
        html.setSorted(false);
        html.setTitle("dCache Statistics of dCache Domain : " + _domainName);
        html.setKeyType("Year");
        html.setAuthor(defaultAuthor);
        html.setHeader(new TopDirectoryHeader());
        int n = list.length;
        for (int i = 0; i < n; ++i) {
            File x = new File(list[i], "total.raw");
            if (!x.exists()) continue;
            try {
                BufferedReader br = new BufferedReader(new FileReader(x));
                try {
                    String line = br.readLine();
                    if (line == null || line.length() < 12) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    st.nextToken();
                    String key = this._yearOfCalendar.format(new Date(Long.parseLong(st.nextToken())));
                    for (int j = 0; j < counter.length; ++j) {
                        counter[j] = Long.parseLong(st.nextToken());
                    }
                    if (i == 0) {
                        System.arraycopy(counter, 0, lastInYear, 0, counter.length);
                    }
                    this.add(total, counter);
                    html.add(key, list[i].getName() + File.separator + "index.html", counter);
                    continue;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception eee) {}
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(new File(dir, "index.html")));){
            html.setPrintWriter(pw);
            html.dump();
        }
        total[0] = counter[0];
        total[1] = counter[1];
        total[2] = lastInYear[2];
        total[3] = lastInYear[3];
        this.printTotal(new File(dir, "total.raw"), total, new Date());
    }

    private File[] resortFileList(File[] list, final int direction) {
        TreeSet<File> sorted = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return direction * f1.getName().compareTo(f2.getName());
            }
        });
        Collections.addAll(sorted, list);
        return sorted.toArray(new File[sorted.size()]);
    }

    public String ac_set_html_body_$_1(Args args) {
        _bodyString = args.argv(0);
        return "";
    }

    public String ac_create_html_$_0_3(Args args) throws IOException {
        if (args.argc() == 3) {
            int year = Integer.parseInt(args.argv(0));
            int month = Integer.parseInt(args.argv(1));
            int day = Integer.parseInt(args.argv(2));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            this.prepareDailyHtmlFiles(calendar);
        } else if (args.argc() == 2) {
            int year = Integer.parseInt(args.argv(0));
            int month = Integer.parseInt(args.argv(1));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, 1);
            this.updateHtmlMonth(calendar);
        } else if (args.argc() == 1) {
            int year = Integer.parseInt(args.argv(0));
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(1, year);
            calendar.set(2, 1);
            calendar.set(5, 1);
            this.updateHtmlYear(calendar);
        } else if (args.argc() == 0) {
            this.updateHtmlTop();
        }
        return "Done";
    }

    public String ac_create_stat_$_0_1(Args args) {
        if (args.argc() == 0) {
            this._nucleus.newThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        _log.info("Starting internal Manual run");
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            PoolStatisticsV0.this._recentPoolStatistics = null;
                        }
                        Map map = PoolStatisticsV0.this.createStatisticsMap();
                        2 var2_4 = this;
                        synchronized (var2_4) {
                            PoolStatisticsV0.this._recentPoolStatistics = map;
                        }
                        _log.info("Finishing internal Manual run");
                    }
                    catch (Exception e) {
                        _log.info("Aborting internal Manual run " + e);
                    }
                }
            }, "internal").start();
            return "Thread started for internal run";
        }
        final File file = new File(args.argv(0));
        this._nucleus.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    _log.info("Starting Manual run for file : " + file);
                    PoolStatisticsV0.this.createHourlyRawFile(file, new GregorianCalendar());
                    _log.info("Finishing Manual run for file : " + file);
                }
                catch (Exception e) {
                    _log.info("Aborting Manual run for file : " + file + " " + e);
                }
            }
        }, file.toString()).start();
        return "Thread started for : " + args.argv(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_show_$_0_1(Args args) {
        Map<String, Map<String, long[]>> map;
        PoolStatisticsV0 poolStatisticsV0 = this;
        synchronized (poolStatisticsV0) {
            map = this._recentPoolStatistics;
        }
        if (map == null) {
            return "Pool Statistics not available yet";
        }
        if (args.argc() == 0) {
            StringBuffer st = new StringBuffer();
            this.dumpStatistics(map, st);
            return st.toString();
        }
        Pattern p = Pattern.compile(args.argv(0));
        PatternIterator pi = new PatternIterator(p);
        PoolStatisticsV0.dumpStatistics(map, pi);
        StringBuffer sb = pi.getStringBuffer();
        long[] counters = pi.getCounters();
        sb.append("* *");
        for (long counter : counters) {
            sb.append(" ").append(counter);
        }
        return sb.toString();
    }

    private Map<String, Map<String, long[]>> doInternalRun() throws InterruptedException, IOException, NoRouteToCellException {
        return this.mergeStorageClassMaps(this.getPoolRepositoryStatistics(), this.getBillingStatistics());
    }

    private Map<String, Map<String, long[]>> createStatisticsMap() throws InterruptedException, IOException, NoRouteToCellException {
        Map<String, Map<String, long[]>> pool = this.getPoolRepositoryStatistics();
        Map<String, Map<String, long[]>> billing = this.getBillingStatistics();
        return this.mergeStorageClassMaps(pool, billing);
    }

    private void createHourlyRawFile(File outputFile, Calendar calendar) throws InterruptedException, Exception {
        if (outputFile.exists() || !outputFile.getParentFile().canWrite()) {
            throw new IOException("File exists or directory not writable : " + outputFile);
        }
        DataStore store = new DataStore(this.createStatisticsMap());
        store.setTime(calendar.getTime());
        store.store(outputFile);
    }

    private static void dumpStatistics(Map<String, Map<String, long[]>> result, Iteratable mapentry) {
        for (Map.Entry<String, Map<String, long[]>> entry : result.entrySet()) {
            String poolName = entry.getKey();
            Map<String, long[]> classes = entry.getValue();
            for (Map.Entry<String, long[]> classEntry : classes.entrySet()) {
                String className = classEntry.getKey();
                long[] values = classEntry.getValue();
                mapentry.mapEntry(poolName, className, values);
            }
        }
    }

    private void printIndex(File file, String title) throws IOException {
        try (PrintWriter pw = new PrintWriter(new FileWriter(file));){
            pw.println("<html><head><title>" + title + "</title></head>");
            pw.println(_bodyString);
            pw.print("<center><h2>");
            pw.print(_domainName);
            pw.println("</h2></center>");
            pw.println("<hr>");
            pw.print("<pre>   <a href=\"/docs/statisticsHelp.html\">Help</a>");
            pw.print("      <a href=\"/\">Birds Home</a>");
            pw.print("      <a href=\"../../../index.html\">Top</a>");
            pw.print("      <a href=\"../../index.html\">This Year</a>");
            pw.println("      <a href=\"../index.html\">This Month</a></pre>");
            pw.println("<hr>");
            pw.println("<center><h1>" + title + "</h1></center>");
            pw.println("<center>");
            pw.println("<h3><a href=\"pools.html\">Pools</a></h3>");
            pw.println("<h3><a href=\"classes.html\">Classes</a></h3>");
            pw.println("<h3><a href=\"total.drw\">Raw</a></h3>");
            pw.println("</center>");
            pw.println("</body></html>");
        }
    }

    private void prepareDailyHtmlFiles(Calendar calendar) {
        File diffFile = this.getTodayDiffPath(calendar);
        if (!diffFile.exists()) {
            _log.warn("prepareDailyHtmlFiles : File not found : " + diffFile);
            return;
        }
        File dir = this.getHtmlPath(calendar);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            this.copyFile(diffFile, new File(dir, "total.drw"));
            Map<String, Map<String, long[]>> map = new DataStore(diffFile).getMap();
            this.prepareDailyHtml(map, dir, calendar.getTime());
            this.printIndex(new File(dir, "index.html"), this.getNiceDayOfCalendar(calendar));
        }
        catch (IOException ee) {
            _log.warn("Can't prepare Html directory : " + dir, (Throwable)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, long[]>>[] prepareDailyHtml(Map<String, Map<String, long[]>> poolMap, File pathBase, Date date) throws IOException {
        PrintWriter pw;
        HashMap<String, long[]> poolMap2;
        BaseStatisticsHtml html;
        long[] sum;
        Iterator<Map.Entry<String, Map<String, Object>>> entries = poolMap.entrySet().iterator();
        HashMap<Object, HashMap<String, long[]>> classMap2 = new HashMap<Object, HashMap<String, long[]>>();
        DayDirectoryHeader header = new DayDirectoryHeader(date, this._dayOfCalendar);
        BaseStatisticsHtml allPoolsHtml = new BaseStatisticsHtml();
        allPoolsHtml.setSorted(true);
        allPoolsHtml.setTitle("Pools");
        allPoolsHtml.setKeyType("PoolNames");
        allPoolsHtml.setAuthor(defaultAuthor);
        allPoolsHtml.setHeader(header);
        long[] total = null;
        while (entries.hasNext()) {
            Object className;
            Map.Entry<String, Map<String, long[]>> entry = entries.next();
            String poolName = entry.getKey();
            Map<String, long[]> map = entry.getValue();
            Iterator<Map.Entry<String, long[]>> classEntries = map.entrySet().iterator();
            sum = null;
            html = new BaseStatisticsHtml();
            html.setSorted(true);
            html.setTitle("Pool : " + poolName);
            html.setKeyType("ClassNames");
            html.setAuthor(defaultAuthor);
            html.setHeader(header);
            while (classEntries.hasNext()) {
                Map.Entry<String, long[]> classEntry = classEntries.next();
                className = classEntry.getKey();
                long[] values = classEntry.getValue();
                if (sum == null) {
                    sum = new long[values.length];
                }
                this.add(sum, values);
                if (total == null) {
                    total = new long[values.length];
                }
                this.add(total, values);
                poolMap2 = (HashMap<String, long[]>)classMap2.get(className);
                if (poolMap2 == null) {
                    poolMap2 = new HashMap<String, long[]>();
                    classMap2.put(className, poolMap2);
                }
                poolMap2.put(poolName, values);
                html.add((String)className, "class-" + (String)className + ".html", values);
            }
            if (sum != null) {
                allPoolsHtml.add(poolName, "pool-" + poolName + ".html", sum);
            }
            pw = new PrintWriter(new FileWriter(new File(pathBase, "pool-" + poolName + ".html")));
            className = null;
            try {
                html.setPrintWriter(pw);
                html.dump();
            }
            catch (Throwable x2) {
                className = x2;
                throw x2;
            }
            finally {
                if (pw == null) continue;
                if (className != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable x2) {
                        ((Throwable)className).addSuppressed(x2);
                    }
                    continue;
                }
                pw.close();
            }
        }
        try (PrintWriter allPw = new PrintWriter(new FileWriter(new File(pathBase, "pools.html")));){
            allPoolsHtml.setPrintWriter(allPw);
            allPoolsHtml.dump();
        }
        this.printTotal(new File(pathBase, "total.raw"), total, date);
        BaseStatisticsHtml allClassesHtml = new BaseStatisticsHtml();
        allClassesHtml.setSorted(true);
        allClassesHtml.setTitle("Classes");
        allClassesHtml.setAuthor(defaultAuthor);
        allClassesHtml.setKeyType("ClassNames");
        allClassesHtml.setHeader(header);
        for (Map.Entry<String, Map<String, Object>> entry : classMap2.entrySet()) {
            String className = entry.getKey();
            poolMap2 = entry.getValue();
            sum = null;
            html = new BaseStatisticsHtml();
            html.setSorted(true);
            html.setTitle("Class " + className);
            html.setAuthor(defaultAuthor);
            html.setKeyType("Pools");
            html.setHeader(header);
            for (Map.Entry poolEntry : poolMap2.entrySet()) {
                String poolName = (String)poolEntry.getKey();
                long[] values = (long[])poolEntry.getValue();
                if (sum == null) {
                    sum = new long[values.length];
                }
                this.add(sum, values);
                html.add(poolName, "pool-" + poolName + ".html", values);
            }
            if (sum != null) {
                allClassesHtml.add(className, "class-" + className + ".html", sum);
            }
            pw = new PrintWriter(new FileWriter(new File(pathBase, "class-" + className + ".html")));
            Throwable throwable = null;
            try {
                html.setPrintWriter(pw);
                html.dump();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw == null) continue;
                if (throwable != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                pw.close();
            }
        }
        allPw = new PrintWriter(new FileWriter(new File(pathBase, "classes.html")));
        try {
            allClassesHtml.setPrintWriter(allPw);
            allClassesHtml.dump();
        }
        finally {
            allPw.close();
        }
        return new Map[]{poolMap, classMap2};
    }

    private void printTotal(File filename, long[] total, Date date) throws IOException {
        try (PrintWriter dayTotal = new PrintWriter(new FileWriter(filename));){
            String day = this._dayOfCalendarKey.format(date);
            dayTotal.print(day);
            dayTotal.print(" ");
            dayTotal.print(date.getTime());
            for (long aTotal : total) {
                dayTotal.print(" ");
                dayTotal.print(aTotal);
            }
            dayTotal.println("");
        }
    }

    private void add(long[] sum, long[] add) {
        int l = Math.min(sum.length, add.length);
        for (int i = 0; i < l; ++i) {
            if (add[i] <= -1L) continue;
            int n = i;
            sum[n] = sum[n] + add[i];
        }
    }

    private static void dumpStatistics(Map<String, Map<String, long[]>> result, final PrintWriter pw) {
        PoolStatisticsV0.dumpStatistics(result, new Iteratable(){

            @Override
            public void mapEntry(String poolName, String className, long[] counters) {
                pw.print(poolName + " " + className + " ");
                for (long counter : counters) {
                    pw.print(counter);
                    pw.print(" ");
                }
                pw.println("");
            }
        });
        pw.flush();
    }

    private void dumpStatistics(Map<String, Map<String, long[]>> result, final StringBuffer pw) {
        PoolStatisticsV0.dumpStatistics(result, new Iteratable(){

            @Override
            public void mapEntry(String poolName, String className, long[] counters) {
                pw.append(poolName).append(" ").append(className).append(" ");
                for (long counter : counters) {
                    pw.append(counter);
                    pw.append(" ");
                }
                pw.append("\n");
            }
        });
    }

    private Map<String, Map<String, long[]>> mergeStorageClassMaps(Map<String, Map<String, long[]>> fromPools, Map<String, Map<String, long[]>> fromBilling) {
        int i;
        int preset;
        long[] resultArray;
        long[] values;
        Map<String, long[]> stat;
        Map<String, long[]> resultClasses;
        HashMap<String, Map<String, long[]>> result = new HashMap<String, Map<String, long[]>>();
        for (String poolName : fromPools.keySet()) {
            resultClasses = (Map<String, long[]>)result.get(poolName);
            if (resultClasses == null) {
                resultClasses = new HashMap<String, long[]>();
                result.put(poolName, resultClasses);
            }
            if ((stat = fromPools.get(poolName)) == null) continue;
            for (String className : stat.keySet()) {
                values = stat.get(className);
                if (values == null) continue;
                resultArray = resultClasses.get(className);
                if (resultArray == null) {
                    resultArray = new long[10];
                    resultClasses.put(className, resultArray);
                    preset = fromBilling.get(poolName) == null ? -1 : 0;
                    for (i = 2; i < 10; ++i) {
                        resultArray[i] = preset;
                    }
                }
                System.arraycopy(values, 0, resultArray, 0, 2);
            }
        }
        for (String poolName : fromBilling.keySet()) {
            resultClasses = result.get(poolName);
            if (resultClasses == null) {
                resultClasses = new HashMap<String, long[]>();
                result.put(poolName, resultClasses);
            }
            if ((stat = fromBilling.get(poolName)) == null) continue;
            for (String className : stat.keySet()) {
                values = stat.get(className);
                if (values == null) continue;
                resultArray = resultClasses.get(className);
                if (resultArray == null) {
                    resultArray = new long[10];
                    resultClasses.put(className, resultArray);
                    preset = fromPools.get(poolName) == null ? -1 : 0;
                    for (i = 0; i < 2; ++i) {
                        resultArray[i] = preset;
                    }
                }
                System.arraycopy(values, 0, resultArray, 2, 8);
            }
        }
        return result;
    }

    private Map<String, Map<String, long[]>> getPoolRepositoryStatistics() throws InterruptedException, NoRouteToCellException, IOException {
        HashMap<String, Map<String, long[]>> map = new HashMap<String, Map<String, long[]>>();
        CellMessage m = new CellMessage(new CellPath("PoolManager"), (Serializable)((Object)GET_CELL_INFO));
        _log.info("getPoolRepositoryStatistics : asking PoolManager for cell info");
        m = this._nucleus.sendAndWait(m, 20000L);
        if (m == null) {
            throw new IOException("xgetcellinfo timed out");
        }
        Serializable o = m.getMessageObject();
        if (!(o instanceof PoolManagerCellInfo)) {
            throw new IOException("Illegal Reply from PoolManager : " + o.getClass().getName());
        }
        PoolManagerCellInfo info = (PoolManagerCellInfo)o;
        _log.info("getPoolRepositoryStatistics :  PoolManager replied : {}", (Object)info);
        for (Map.Entry pool : info.getPoolMap().entrySet()) {
            CellAddressCore address = (CellAddressCore)pool.getValue();
            m = new CellMessage(new CellPath(address), (Serializable)((Object)GET_REP_STATISTICS));
            try {
                _log.info("getPoolRepositoryStatistics : asking {} for statistics", (Object)address);
                m = this._nucleus.sendAndWait(m, 20000L);
                if (m == null) {
                    _log.warn("getPoolRepositoryStatistics : timeout {}", (Object)address);
                    continue;
                }
                _log.info("getPoolRepositoryStatistics : {} replied : {}", (Object)address, (Object)m);
                Object[] result = (Object[])m.getMessageObject();
                HashMap<String, long[]> classMap = new HashMap<String, long[]>();
                for (Object entry : result) {
                    Object[] e = (Object[])entry;
                    classMap.put((String)e[0], (long[])e[1]);
                }
                _log.info("getPoolRepositoryStatistics : {} replied with {}", (Object)address, classMap);
                map.put((String)pool.getKey(), (Map<String, long[]>)classMap);
            }
            catch (InterruptedException ie) {
                _log.warn("getPoolRepositoryStatistics : sendAndWait interrupted");
                throw ie;
            }
            catch (NoRouteToCellException eee) {
                _log.warn("getPoolRepositoryStatistics : {} : {}", (Object)address, (Object)eee);
            }
        }
        return map;
    }

    private void resetBillingStatistics() {
        _log.info("Resetting Billing statistics");
        CellMessage m = new CellMessage(new CellPath("billing"), (Serializable)((Object)RESET_POOL_STATISTICS));
        try {
            this._nucleus.sendMessage(m);
        }
        catch (NoRouteToCellException ee) {
            _log.warn("Couldn't reset pool statistics : " + (Object)((Object)ee));
        }
    }

    private Map<String, Map<String, long[]>> getBillingStatistics() throws InterruptedException, NoRouteToCellException, IOException {
        HashMap<String, Map<String, long[]>> map = new HashMap<String, Map<String, long[]>>();
        CellMessage m = new CellMessage(new CellPath("billing"), (Serializable)((Object)GET_POOL_STATISTICS));
        _log.info("getBillingStatistics : asking billing for generic pool statistics");
        m = this._nucleus.sendAndWait(m, 20000L);
        if (m == null) {
            throw new IOException("'get pool statistics' timed out");
        }
        Serializable o = m.getMessageObject();
        if (!(o instanceof Map)) {
            throw new IOException("Illegal Reply from billing : " + o.getClass().getName());
        }
        Map generic = (Map)((Object)o);
        _log.info("getBillingStatistics :  billing replied with " + generic);
        for (String poolName : generic.keySet()) {
            m = new CellMessage(new CellPath("billing"), (Serializable)((Object)("get pool statistics " + poolName)));
            try {
                _log.info("getBillingStatistics : asking billing for [" + poolName + "] statistics");
                m = this._nucleus.sendAndWait(m, 20000L);
                if (m == null) {
                    _log.warn("'get pool statistics' : timed out for " + poolName);
                    continue;
                }
                Map result = (Map)((Object)m.getMessageObject());
                _log.info("getBillingStatistics :  billing replied with " + result);
                map.put(poolName, result);
            }
            catch (InterruptedException ie) {
                _log.warn("'get pool statistics' : sendAndWait interrupted");
                throw ie;
            }
            catch (NoRouteToCellException eee) {
                _log.warn("'get pool statistics' : " + poolName + " : " + (Object)((Object)eee));
            }
        }
        return map;
    }

    private void printLegend(PrintWriter pw) {
        String tableHeaderBg = "#007a95";
        String tableRowBg = "white";
        String greenBox = "/images/greenbox.gif";
        String redBox = "/images/greenbox.gif";
        String blueBox = "/images/greenbox.gif";
        String yellowBox = "/images/greenbox.gif";
        String navyBox = "/images/greenbox.gif";
        String cyanBox = "/images/greenbox.gif";
        String orangeBox = "/images/greenbox.gif";
        pw.println("<table border=1 cellpadding=0 cellspacing=0 width=\"90%\">");
        pw.println("<tr><th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Year</font></th>");
        pw.println("<th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Absolute Values</font></th>");
        pw.println("<th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Data / GBytes</font></th>");
        pw.println("<th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Relative Values</font></th>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<th rowspan=3 align=center bgcolor=\"white\"><a href=\"2004/index.html\">2004</a>");
        pw.println("</th>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=129 height=10>");
        pw.println("<img src=\"" + greenBox + "\" width=370 height=10><img src=\"" + greenBox + "\" width=0 height=10></td>");
        pw.println("<td align=center bgcolor=\"" + tableRowBg + "\">8310<font color=\"red\">");
        pw.println(" + 23767</font><font color=\"red\"> + 0</font></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=25 height=10");
        pw.println("><img src=\"" + greenBox + "\" width=74 height=10><img src=\"" + greenBox + "\" width=0 height=10></td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=174 height=10></td>");
        pw.println("<td align=center bgcolor=\"" + tableRowBg + "\">11216</td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=34 height=10></td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=402 height=10>");
        pw.println("<img src=\"" + greenBox + "\" width=0 height=10></td>");
        pw.println("<td align=center bgcolor=\"" + tableRowBg + "\">25798 + 0</td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=80 height=10>");
        pw.println("<img src=\"" + greenBox + "\" width=0 height=10></td>");
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("</center>");
        pw.println("<p>");
        pw.println("<blockquote>");
        pw.println("<table border=1 cellpadding=4 cellspacing=0>");
        pw.println("<tr>");
        pw.println("<th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Type</font></th>");
        pw.println("<th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Color</font></th>");
        pw.println("<th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Description</font></th>");
        pw.println("<th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Color</font></th>");
        pw.println("<th bgcolor=\"" + tableHeaderBg + "\"><font color=white>Description</font></th>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>Amount of data in repository</font></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=140 height=10></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>Beginning of interval</font></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=140 height=10></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>End of interval</font></td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>Data transferred into dCache</font></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=140 height=10></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>from HSM</font></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=140 height=10></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>from client</font></td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>Data transferred from dCache</font></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=140 height=10></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>to client</font></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><img src=\"" + greenBox + "\" width=140 height=10></td>");
        pw.println("<td bgcolor=\"" + tableRowBg + "\"><font color=blue>to HSM</font></td>");
        pw.println("</tr>");
        pw.println("</table>");
    }

    public static void main(String[] args) throws Exception {
        DataStore store = new DataStore(new File("xxinput"));
        store.store(new File("xxoutput"));
    }

    private static class BaseStatisticsHtml {
        private int _height = 10;
        private int _absoluteWidth = 500;
        private int _relativeWidth = 100;
        private String[] _bgcolor = new String[]{"white", "#bebebe"};
        private PrintWriter _pw;
        private String _imageBase = "/images/";
        private String _poolYesterday = this._imageBase + "greenbox.gif";
        private String _poolToday = this._imageBase + "redbox.gif";
        private String _restore = this._imageBase + "bluebox.gif";
        private String _transferIn = this._imageBase + "navybox.gif";
        private String _transferOut = this._imageBase + "yellowbox.gif";
        private String _store = this._imageBase + "orangebox.gif";
        private long _absoluteNorm = 1L;
        private Map<String, Object[]> _map;
        private long _maxCounterValue;
        private String _title = "Title";
        private String _author = "dCache Team";
        private String _tableTitleColor = "#115259";
        private String _keyType = "Key";
        private String[] _tableTitles = new String[]{this._keyType, "Absolute Values", "Data / MBytes", "Relative Values"};
        private HtmlDrawable _header;

        private BaseStatisticsHtml() {
        }

        private void setHeader(HtmlDrawable drawable) {
            this._header = drawable;
        }

        public void setSorted(boolean sorted) {
            this._map = sorted ? new TreeMap() : new LinkedHashMap();
            this._maxCounterValue = 0L;
        }

        public void setKeyType(String keyType) {
            this._tableTitles[0] = keyType;
        }

        public void setPrintWriter(PrintWriter pw) {
            this._pw = pw;
        }

        public void reset() {
            this._maxCounterValue = 0L;
        }

        public void add(String title, String link, long[] counter) {
            Object[] o = new Object[]{title, this.makeLink(link), counter};
            this._maxCounterValue = Math.max(this._maxCounterValue, this.getNorm(counter));
            this._map.put(title, o);
        }

        public void setTitle(String title) {
            this._title = title;
        }

        public void setAuthor(String author) {
            this._author = author;
        }

        public void dump() {
            this.printHeader(this._title);
            if (this._header != null) {
                this._header.draw(this._pw);
            }
            this.printTitle(this._title);
            this.printTableHeader();
            this._absoluteNorm = this._maxCounterValue;
            Iterator<Object[]> it = this._map.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                Object[] o = it.next();
                this.printRow((String)o[0], (String)o[1], (long[])o[2], this._bgcolor[i % 2]);
                ++i;
            }
            this.printTableTrailer();
            this.printTrailer(this._author + " ; Created : " + new Date().toString());
        }

        private String makeLink(String link) {
            StringBuilder sb = new StringBuilder();
            int n = link.length();
            block3: for (int i = 0; i < n; ++i) {
                char c = link.charAt(i);
                switch (c) {
                    case ':': {
                        sb.append("%3A");
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        private void printTableHeader() {
            this._pw.println("<center><table border=1 cellpadding=0 cellspacing=0 width=\"90%\">");
            this._pw.print("<tr>");
            for (String title : this._tableTitles) {
                this._pw.print("<th bgcolor=\"");
                this._pw.print(this._tableTitleColor);
                this._pw.print("\"><font color=white>");
                this._pw.print(title);
                this._pw.println("</font></th>");
            }
            this._pw.println("</tr>");
        }

        private void printTableTrailer() {
            this._pw.println("</table></center>");
            this._pw.flush();
        }

        private void printHeader(String title) {
            this._pw.print("<html><head><title>");
            this._pw.print(title);
            this._pw.println("</title></head>" + _bodyString);
            this._pw.print("<center><h2>");
            this._pw.print(_domainName);
            this._pw.println("</h2></center>");
        }

        private void printTitle(String title) {
            this._pw.print("<center><h1>");
            this._pw.print(title);
            this._pw.println("</h1></center>");
        }

        private void printTrailer(String author) {
            if (author != null) {
                this._pw.print("<hr><address>");
                this._pw.print(author);
                this._pw.println("</address>");
            }
            this._pw.println("</body></html>");
            this._pw.flush();
        }

        private long getNorm(long[] counter) {
            return Math.max(counter[0] + counter[10] + counter[8], Math.max(counter[2], counter[11] + counter[9]));
        }

        private String printUnit(long counter) {
            if (counter <= 0L) {
                return "0";
            }
            String unit = "" + counter / 0x100000L;
            StringBuilder sb = new StringBuilder();
            int j = unit.length() - 1;
            int c = 0;
            while (j >= 0) {
                if (c > 0 && c % 3 == 0) {
                    sb.append('.');
                }
                sb.append(unit.charAt(j));
                --j;
                ++c;
            }
            return sb.reverse().toString();
        }

        private void printRow(String title, String link, long[] counter, String bgColor) {
            long norm = this.getNorm(counter);
            this.printTR();
            this._pw.print("<th rowspan=3 align=center bgcolor=\"");
            this._pw.print(bgColor);
            this._pw.print("\">");
            this.printHREF(title, link);
            this._pw.println("</th>");
            this.printTD(bgColor, false);
            int content = 0;
            int value = (int)((double)counter[0] / (double)this._absoluteNorm * (double)this._absoluteWidth);
            content += this.printImage(this._poolYesterday, value, this._height);
            value = (int)((double)counter[10] / (double)this._absoluteNorm * (double)this._absoluteWidth);
            content += this.printImage(this._restore, value, this._height);
            value = (int)((double)counter[8] / (double)this._absoluteNorm * (double)this._absoluteWidth);
            this.printTDEnd(content += this.printImage(this._transferIn, value, this._height));
            this.printTD(bgColor, true);
            this.print("" + this.printUnit(counter[0]));
            this.print(" + " + this.printUnit(counter[10]), "red");
            this.print(" + " + this.printUnit(counter[8]), "red");
            this.printTDEnd(1);
            this.printTD(bgColor, false);
            content = 0;
            value = (int)((double)counter[0] / (double)norm * (double)this._relativeWidth);
            content += this.printImage(this._poolYesterday, value, this._height);
            value = (int)((double)counter[10] / (double)norm * (double)this._relativeWidth);
            content += this.printImage(this._restore, value, this._height);
            value = (int)((double)counter[8] / (double)norm * (double)this._relativeWidth);
            this.printTDEnd(content += this.printImage(this._transferIn, value, this._height));
            this.printTREnd();
            this.printTR();
            this.printTD(bgColor, false);
            content = 0;
            value = (int)((double)counter[2] / (double)this._absoluteNorm * (double)this._absoluteWidth);
            this.printTDEnd(content += this.printImage(this._poolToday, value, this._height));
            this.printTD(bgColor, true);
            this.print("" + this.printUnit(counter[2]));
            this.printTDEnd(1);
            this.printTD(bgColor, false);
            content = 0;
            value = (int)((double)counter[2] / (double)norm * (double)this._relativeWidth);
            this.printTDEnd(content += this.printImage(this._poolToday, value, this._height));
            this.printTREnd();
            this.printTR();
            this.printTD(bgColor, false);
            content = 0;
            value = (int)((double)counter[9] / (double)this._absoluteNorm * (double)this._absoluteWidth);
            content += this.printImage(this._transferOut, value, this._height);
            value = (int)((double)counter[11] / (double)this._absoluteNorm * (double)this._absoluteWidth);
            this.printTDEnd(content += this.printImage(this._store, value, this._height));
            this.printTD(bgColor, true);
            this.print("" + this.printUnit(counter[9]));
            this.print(" + " + this.printUnit(counter[11]));
            this.printTDEnd(1);
            this.printTD(bgColor, false);
            content = 0;
            value = (int)((double)counter[9] / (double)norm * (double)this._relativeWidth);
            content += this.printImage(this._transferOut, value, this._height);
            value = (int)((double)counter[11] / (double)norm * (double)this._relativeWidth);
            this.printTDEnd(content += this.printImage(this._store, value, this._height));
            this.printTREnd();
        }

        private void printTR() {
            this._pw.println("<tr>");
        }

        private void printTREnd() {
            this._pw.println("</tr>");
        }

        private int printImage(String imageFile, int width, int height) {
            if (width <= 0) {
                return 0;
            }
            this._pw.print("<img src=\"");
            this._pw.print(imageFile);
            this._pw.print("\" width=");
            this._pw.print(Math.max(width, 0));
            this._pw.print(" height=");
            this._pw.print(height);
            this._pw.print(">");
            return 1;
        }

        private void printTD(String bgcolor, boolean center) {
            this._pw.print("<td ");
            if (center) {
                this._pw.print("align=center ");
            }
            this._pw.print("bgcolor=\"");
            this._pw.print(bgcolor);
            this._pw.print("\">");
        }

        private void print(String string) {
            this.print(string, null);
        }

        private void print(String string, String color) {
            if (color != null) {
                this._pw.print("<font color=\"");
                this._pw.print(color);
                this._pw.print("\">");
            }
            this._pw.print(string);
            if (color != null) {
                this._pw.print("</font>");
            }
        }

        private void printTDEnd(int content) {
            if (content == 0) {
                this._pw.print("&nbsp;");
            }
            this._pw.println("</td>");
        }

        private void printHREF(String title, String link) {
            this._pw.print("<a href=\"");
            this._pw.print(link);
            this._pw.print("\">");
            this._pw.print(title);
            this._pw.println("</a>");
        }
    }

    private static class TopDirectoryHeader
    implements HtmlDrawable {
        private TopDirectoryHeader() {
        }

        @Override
        public void draw(PrintWriter pw) {
            pw.print("<hr><pre>    ");
            pw.print("<a href=\"/docs/statisticsHelp.html\">Help</a>         ");
            pw.print("<a href=\"/\">Birds Home</a>         ");
            pw.println("</pre><hr>");
        }
    }

    private static class YearDirectoryHeader
    implements HtmlDrawable {
        private Date _date;

        private YearDirectoryHeader(Date date) {
            this._date = date;
        }

        @Override
        public void draw(PrintWriter pw) {
            pw.print("<hr><pre>    ");
            pw.print("<a href=\"/docs/statisticsHelp.html\">Help</a>         ");
            pw.print("<a href=\"/\">Birds Home</a>         ");
            pw.print("<a href=\"../index.html\">Top</a>         ");
            pw.println("</pre><hr>");
        }
    }

    private class MonthDirectoryHeader
    implements HtmlDrawable {
        private Date _date;

        private MonthDirectoryHeader(Date date) {
            this._date = date;
        }

        @Override
        public void draw(PrintWriter pw) {
            pw.print("<hr><pre>    ");
            pw.print("<a href=\"/docs/statisticsHelp.html\">Help</a>         ");
            pw.print("<a href=\"/\">Birds Home</a>         ");
            pw.print("<a href=\"../../index.html\">Top</a>         ");
            pw.print("<a href=\"../index.html\">This Year</a>         ");
            pw.println("</pre><hr>");
        }
    }

    private static class DayDirectoryHeader
    implements HtmlDrawable {
        private final Date _date;
        private final SimpleDateFormat _dayOfCalendar;

        private DayDirectoryHeader(Date date, SimpleDateFormat dayOfCalendar) {
            this._date = date;
            this._dayOfCalendar = dayOfCalendar;
        }

        @Override
        public void draw(PrintWriter pw) {
            pw.print("<hr><pre>    ");
            pw.print("<a href=\"/docs/statisticsHelp.html\">Help</a>         ");
            pw.print("<a href=\"/\">Birds Home</a>         ");
            pw.print("<a href=\"../../../index.html\">Top</a>         ");
            pw.print("<a href=\"../../index.html\">This Year</a>         ");
            pw.print("<a href=\"../index.html\">This Month</a>         ");
            pw.print("<a href=\"index.html\">Today</a>         ");
            pw.print("<a href=\"pools.html\">Pools</a>         ");
            pw.print("<a href=\"classes.html\">Classes</a>         ");
            pw.print("<a href=\"total.drw\">Raw</a>");
            pw.println("</pre><hr>");
            pw.println("<center><h1>" + this._dayOfCalendar.format(this._date) + "</h1></center>");
        }
    }

    private static class DataStore {
        private Map<String, Map<String, long[]>> _data;
        private Map<String, Object> _attributes = new HashMap<String, Object>();
        private int _minCount = 64;
        private int _maxCount;

        public DataStore(Map<String, Map<String, long[]>> data) {
            this._data = data;
        }

        public DataStore(File file) throws IOException {
            this.load(file);
        }

        public Map<String, long[]> getLinearMap() {
            final HashMap<String, long[]> map = new HashMap<String, long[]>();
            PoolStatisticsV0.dumpStatistics((Map<String, Map<String, long[]>>)this._data, new Iteratable(){

                @Override
                public void mapEntry(String pool, String className, long[] counters) {
                    map.put(pool + " " + className, counters);
                }
            });
            return map;
        }

        public Iterator<Map.Entry<String, Object>> iterator() {
            return this._attributes.entrySet().iterator();
        }

        public void setTime(Date date) {
            this.add("timestamp", date.getTime());
            this.add("date", date);
        }

        public int getMinColumn() {
            return this._minCount;
        }

        public int getMaxColumn() {
            return this._maxCount;
        }

        private void add(String key, Object value) {
            this._attributes.put(key, value);
        }

        public Map<String, Map<String, long[]>> getMap() {
            return this._data;
        }

        private Object get(String key) {
            return this._attributes.get(key);
        }

        public void store(File file) throws IOException {
            try (PrintWriter pw = new PrintWriter(new FileWriter(file));){
                pw.println("#");
                for (Map.Entry<String, Object> entry : this._attributes.entrySet()) {
                    pw.println("# " + entry.getKey() + "=" + entry.getValue());
                }
                pw.println("#");
                PoolStatisticsV0.dumpStatistics((Map<String, Map<String, long[]>>)this._data, pw);
            }
        }

        private void scanAttributes(String line) {
            if (line.length() < 3) {
                return;
            }
            if ((line = line.substring(2).trim()).length() == 0) {
                return;
            }
            int indx = line.indexOf(61);
            if (indx == -1 || indx == line.length() - 1) {
                this._attributes.put(line, "");
            } else if (indx != 0) {
                this._attributes.put(line.substring(0, indx).trim(), line.substring(indx + 1).trim());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load(File f) throws IOException {
            BufferedReader br = new BufferedReader(new FileReader(f));
            HashMap<String, Map<String, long[]>> map = new HashMap<String, Map<String, long[]>>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    int i;
                    if (line.length() > 0 && line.charAt(0) == '#') {
                        this.scanAttributes(line);
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(line);
                    if (!st.hasMoreTokens()) continue;
                    String poolName = st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    String className = st.nextToken();
                    long[] counter = new long[64];
                    int n = counter.length;
                    for (i = 0; i < n && st.hasMoreTokens(); ++i) {
                        counter[i] = Long.parseLong(st.nextToken());
                    }
                    this._minCount = Math.min(this._minCount, i);
                    this._maxCount = Math.max(this._maxCount, i);
                    long[] res = new long[i];
                    System.arraycopy(counter, 0, res, 0, i);
                    Map<String, long[]> classMap = map.get(poolName);
                    if (classMap == null) {
                        classMap = new HashMap<String, long[]>();
                        map.put(poolName, classMap);
                    }
                    classMap.put(className, res);
                }
                this._data = map;
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception ee) {}
            }
        }
    }

    private static class PatternIterator
    implements Iteratable {
        private Pattern _pattern;
        private StringBuffer _sb;
        private long[] _sum = new long[16];
        private int _mx;

        private PatternIterator(Pattern pattern) {
            this._pattern = pattern;
            this._sb = new StringBuffer();
        }

        @Override
        public void mapEntry(String poolName, String className, long[] counters) {
            StringBuilder sb = new StringBuilder();
            sb.append(poolName).append(" ").append(className).append(" ");
            for (long counter : counters) {
                sb.append(counter);
                sb.append(" ");
            }
            String line = sb.toString();
            if (!this._pattern.matcher(line).matches()) {
                return;
            }
            this._sb.append(line).append("\n");
            int n = counters.length;
            int m = this._sum.length;
            for (int i = 0; i < n && i < m; ++i) {
                if (this._sum[i] <= -1L) continue;
                int n2 = i;
                this._sum[n2] = this._sum[n2] + counters[i];
            }
            this._mx = Math.max(this._mx, counters.length);
        }

        public long[] getCounters() {
            long[] result = new long[this._mx];
            System.arraycopy(this._sum, 0, result, 0, this._mx);
            return result;
        }

        public String toString() {
            return this._sb.toString();
        }

        public StringBuffer getStringBuffer() {
            return this._sb;
        }
    }

    private static interface HtmlDrawable {
        public void draw(PrintWriter var1);
    }

    private static interface Iteratable {
        public void mapEntry(String var1, String var2, long[] var3);
    }

    private static class YearFileFilter
    implements FileFilter {
        private YearFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && file.getName().length() == 4;
        }
    }

    private static class MonthFileFilter
    implements FileFilter {
        private MonthFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && file.getName().length() == 2;
        }
    }

    private class HourlyRunner
    implements Runnable {
        private Calendar _calendar;

        private HourlyRunner(Calendar calendar) {
            this._calendar = calendar;
            PoolStatisticsV0.this._nucleus.newThread((Runnable)this, "FreeRunner").start();
        }

        @Override
        public void run() {
            File path = PoolStatisticsV0.this.getCurrentPath(this._calendar);
            File parent = path.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try {
                _log.info("Starting hourly run for : " + path);
                PoolStatisticsV0.this.createHourlyRawFile(path, this._calendar);
                _log.info("Hourly run finished for : " + path);
                File today = PoolStatisticsV0.this.getTodayPath(this._calendar);
                _log.info("Creating daily file : " + today);
                today.delete();
                PoolStatisticsV0.this.copyFile(path, today);
                _log.info("Daily file done : " + today);
                File yesterday = PoolStatisticsV0.this.getYesterdayPath(this._calendar);
                if (yesterday.exists()) {
                    File diffFile = PoolStatisticsV0.this.getTodayDiffPath(this._calendar);
                    _log.info("Starting diff run for : " + yesterday);
                    PoolStatisticsV0.this.createDiffFile(today, yesterday, diffFile);
                    _log.info("Finishing diff run for : " + diffFile);
                }
                if (this._calendar.get(11) == 23) {
                    PoolStatisticsV0.this.resetBillingStatistics();
                }
            }
            catch (Exception ee) {
                _log.warn("Exception in full run for : " + path, (Throwable)ee);
                path.delete();
            }
            if (!PoolStatisticsV0.this._createHtmlTree) {
                return;
            }
            try {
                _log.info("Creating html tree");
                PoolStatisticsV0.this.prepareDailyHtmlFiles(this._calendar);
                if (this._calendar.get(11) == 23) {
                    PoolStatisticsV0.this.updateHtmlMonth(this._calendar);
                    PoolStatisticsV0.this.updateHtmlYear(this._calendar);
                    PoolStatisticsV0.this.updateHtmlTop();
                }
            }
            catch (Exception eee) {
                _log.warn("Exception in creating html tree for : " + path, (Throwable)eee);
            }
        }
    }
}

