/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.services;

import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.PoolMgrReplicateFileMsg;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import dmg.util.Formats;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHoppingManager
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(FileHoppingManager.class);
    private CellNucleus _nucleus;
    private Args _args;
    private Map<String, Entry> _map;
    private final Object _mapLock;
    private int _totalRequests;
    private File _configFile;
    private CellPath _defaultDestinationPath;
    public static final String fh_define_hop = "define hop OPTIONS <name> <pattern> precious|cached|keep\n    OPTIONS\n       -destination=<cellDestination> # default : PoolManager\n       -overwrite\n       -retry\n       -continue\n       -source=write|restore|*   #  !!!! for experts only      StorageInfoOptions\n         -host=<destinationHostIp>\n         -protType=dCap|ftp...\n         -protMinor=<minorProtocolVersion>\n         -protMajor=<majorProtocolVersion>\n";
    public static final String hh_define_hop = "OPTONS <name> <pattern> precious|cached|keep # see 'help define hop'";
    public static final String hh_rename_hop = "<oldName> <newName>";
    public static final String hh_undefine_hop = "<name>";
    public static final String hh_save = "";
    public static final String hh_ls_hop = "[<ruleName>] -count";

    public FileHoppingManager(String name, String args) throws Exception {
        block7: {
            super(name, FileHoppingManager.class.getName(), args, false);
            this._map = new TreeMap<String, Entry>();
            this._mapLock = new Object();
            this._defaultDestinationPath = new CellPath("PoolManager");
            this._args = this.getArgs();
            this._nucleus = this.getNucleus();
            try {
                if (this._args.argc() < 1) {
                    throw new IllegalArgumentException("Usage : <configFileName> OPTIONS ");
                }
                this._configFile = new File(this._args.argv(0));
                if (this._configFile.exists()) break block7;
                File configDir = this._configFile.getParentFile();
                if (configDir == null || !configDir.exists()) {
                    throw new IllegalArgumentException("Config directory doesn't exit : " + configDir);
                }
                try {
                    if (!this._configFile.createNewFile()) {
                        throw new IllegalArgumentException("Couldn't create config file : " + this._configFile);
                    }
                }
                catch (Exception ee) {
                    throw new IllegalArgumentException("Couldn't create config file : " + this._configFile + " : " + ee.getMessage());
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                this.start();
                this.kill();
                throw ee;
            }
        }
        this.runSetupFile(this._configFile);
        this._nucleus.export();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runSetupFile(File setupFile) throws Exception {
        if (!setupFile.exists()) {
            throw new IllegalArgumentException("Setup File not found : " + setupFile);
        }
        BufferedReader reader = new BufferedReader(new FileReader(setupFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                try {
                    _log.info("Executing : " + line);
                    String answer = this.command(line);
                    if (answer.length() <= 0) continue;
                    _log.info("Answer    : " + answer);
                }
                catch (Exception ee) {
                    _log.warn("Exception : " + ee.toString());
                }
            }
            return;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSetup() throws Exception {
        File setupFile = this._configFile.getCanonicalFile();
        File tmpFile = new File(setupFile.getParent(), "." + setupFile.getName());
        PrintWriter writer = new PrintWriter(new FileWriter(tmpFile));
        try {
            writer.print("#\n# Setup of ");
            writer.print(this._nucleus.getCellName());
            writer.print(" (");
            writer.print(((Object)((Object)this)).getClass().getName());
            writer.print(") at ");
            writer.println(new Date().toString());
            writer.println("#");
            Object object = this._mapLock;
            synchronized (object) {
                Iterator<Entry> i$ = this._map.values().iterator();
                while (i$.hasNext()) {
                    Entry o;
                    Entry e = o = i$.next();
                    writer.println(e.toCommandString());
                }
            }
            writer.println("#");
        }
        catch (Exception ee) {
            tmpFile.delete();
            throw ee;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception eee) {}
        }
        if (!tmpFile.renameTo(setupFile)) {
            tmpFile.delete();
            throw new IllegalArgumentException("Rename failed : " + this._configFile);
        }
    }

    public void getInfo(PrintWriter pw) {
        pw.println("     Cell Name  : " + this.getCellName());
        pw.println("    Cell Class  : " + ((Object)((Object)this)).getClass().getName());
        pw.println("       Version  : $Id: FileHoppingManager.java,v 1.3 2006-04-21 11:21:33 patrick Exp $");
        pw.println("  Total Requsts : " + this._totalRequests);
        pw.println("Number of Rules : " + this._map.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_define_hop_$_3(Args args) {
        String name = args.argv(0);
        String patternStr = args.argv(1);
        String modeStr = args.argv(2);
        String destination = args.getOpt("destination");
        boolean overwrite = args.hasOption("overwrite");
        String hostName = args.getOpt("host");
        String protocol = args.getOpt("protType");
        String protMinor = args.getOpt("protMinor");
        String protMajor = args.getOpt("protMajor");
        String source = args.getOpt("source");
        Entry entry = this._map.get(name);
        if (entry != null && !overwrite) {
            throw new IllegalArgumentException("Entry already exists : " + name);
        }
        entry = new Entry(name, patternStr, modeStr);
        entry.setProtocolInfo(hostName, protocol, protMajor, protMinor);
        entry.setDestination(destination);
        entry.setRetry(args.hasOption("retry"));
        entry.setContinue(args.hasOption("continue"));
        if (source != null) {
            entry.setSource(source);
        }
        Object object = this._mapLock;
        synchronized (object) {
            this._map.put(name, entry);
        }
        return hh_save;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_rename_hop_$_2(Args args) {
        String oldName = args.argv(0);
        String newName = args.argv(1);
        Object object = this._mapLock;
        synchronized (object) {
            Entry oldEntry = this._map.remove(oldName);
            if (oldEntry == null) {
                throw new IllegalArgumentException("currentName not found : " + oldName);
            }
            Entry newEntry = this._map.get(newName);
            if (newEntry != null) {
                throw new IllegalArgumentException("newName already exists: " + newName);
            }
            oldEntry._name = newName;
            this._map.put(newName, oldEntry);
        }
        return hh_save;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_undefine_hop_$_1(Args args) {
        String name = args.argv(0);
        Object object = this._mapLock;
        synchronized (object) {
            this._map.remove(name);
        }
        return hh_save;
    }

    public void messageToForward(CellMessage cellMessage) {
        _log.info("Message to forward : " + cellMessage.getMessageObject().getClass().getName());
    }

    public void replicateReplyArrived(CellMessage message, PoolMgrReplicateFileMsg replicate) {
        _log.info("replicateReplyArrived : " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(CellMessage message) {
        Serializable request = message.getMessageObject();
        _log.info("messageArrived : " + request + " : " + message);
        if (request instanceof PoolMgrReplicateFileMsg) {
            PoolMgrReplicateFileMsg replicate = (PoolMgrReplicateFileMsg)request;
            if (replicate.isReply()) {
                this.replicateReplyArrived(message, replicate);
                return;
            }
            replicate.setReplyRequired(true);
            StorageInfo storageInfo = replicate.getStorageInfo();
            if (storageInfo == null) {
                return;
            }
            ++this._totalRequests;
            String storageClass = storageInfo.getStorageClass() + "@" + storageInfo.getHsm();
            String replicationSource = storageInfo.getKey("replication.source");
            ProtocolInfo originalProtocolInfo = replicate.getProtocolInfo();
            int matchCount = 0;
            Object object = this._mapLock;
            synchronized (object) {
                for (Entry o : this._map.values()) {
                    Entry entry = o;
                    if (!entry._pattern.matcher(storageClass).matches() || !entry._source.equals("*") && !entry._source.contains(replicationSource)) continue;
                    ++matchCount;
                    _log.info("Entry found for : SC=<" + storageClass + "> source=" + replicationSource + " : " + entry);
                    entry._hit++;
                    CellPath path = entry._path == null ? this._defaultDestinationPath : entry._path;
                    replicate.setDestinationFileStatus(entry._status);
                    ProtocolInfo info = entry._info == null ? originalProtocolInfo : entry._info;
                    replicate.setProtocolInfo(info);
                    try {
                        this.sendMessage(new CellMessage((CellPath)path.clone(), (Serializable)replicate));
                    }
                    catch (Exception ee) {
                        _log.warn("Problem : couldn't forward message to : " + entry._path + " : " + ee);
                    }
                    if (entry._continue) continue;
                    break;
                }
            }
            _log.info("Total match count for <" + storageClass + "> was " + matchCount);
        }
    }

    public String ac_save(Args args) throws Exception {
        this.dumpSetup();
        return "Data written to " + this._configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_ls_hop_$_0_1(Args args) {
        StringBuilder sb = new StringBuilder();
        boolean count = args.hasOption("count") || args.hasOption("c");
        Object object = this._mapLock;
        synchronized (object) {
            if (args.argc() == 0) {
                if (count) {
                    Iterator<Entry> i$ = this._map.values().iterator();
                    while (i$.hasNext()) {
                        Entry o;
                        Entry e = o = i$.next();
                        sb.append(Formats.field((String)e._name, (int)15, (int)4)).append("   ").append(Formats.field((String)e._patternStr, (int)30, (int)1)).append("   ").append(Formats.field((String)(hh_save + e._hit), (int)7, (int)4)).append("\n");
                    }
                } else {
                    Iterator<Entry> i$ = this._map.values().iterator();
                    while (i$.hasNext()) {
                        Entry o;
                        Entry e = o = i$.next();
                        sb.append(e.toCommandString()).append("\n");
                    }
                }
            } else {
                String ruleName = args.argv(0);
                Entry e = this._map.get(ruleName);
                if (e == null) {
                    throw new IllegalArgumentException("Rule not found : " + ruleName);
                }
                sb.append(e.toCommandString()).append("\n");
            }
        }
        return sb.toString();
    }

    private class Entry {
        private String _name;
        private boolean _retry;
        private boolean _continue;
        private String _patternStr;
        private Pattern _pattern;
        private int _status;
        private String _statusStr;
        private String _dest;
        private CellPath _path;
        private String _source = "write";
        private ProtocolInfo _info;
        private String _hostName;
        private String _protType;
        private int _protMinor;
        private int _protMajor;
        private int _hit;

        private Entry(String name, String patternStr, String modeString) {
            this._name = name;
            this._patternStr = patternStr;
            this._pattern = Pattern.compile(patternStr);
            this._statusStr = modeString == null ? "keep" : modeString;
            this._status = this.getModeByString(this._statusStr);
        }

        public String toCommandString() {
            StringBuilder sb = new StringBuilder();
            sb.append("define hop ").append(this._name).append(" \"").append(this._patternStr).append("\" ").append(this._statusStr);
            if (this._info != null) {
                sb.append(" -host=").append(this._hostName).append(" -protType=").append(this._protType).append(" -protMinor=").append(this._protMinor).append(" -protMajor=").append(this._protMajor);
            }
            if (this._dest != null) {
                sb.append(" -destination=").append(this._dest);
            }
            sb.append(" -source=").append(this._source);
            if (this._continue) {
                sb.append(" -continue");
            }
            if (this._retry) {
                sb.append(" -retry");
            }
            return sb.toString();
        }

        public void setContinue(boolean isContinue) {
            this._continue = isContinue;
        }

        public void setRetry(boolean isRetry) {
            this._retry = isRetry;
        }

        public void setSource(String source) {
            this._source = source;
        }

        public void setDestination(String destination) {
            if (destination == null) {
                return;
            }
            this._dest = destination;
            this._path = new CellPath(this._dest);
        }

        public int getModeByString(String modeStr) {
            int mode;
            if (modeStr == null) {
                mode = 0;
            } else if (modeStr.equals("precious")) {
                mode = 1;
            } else if (modeStr.equals("cached")) {
                mode = 2;
            } else if (modeStr.equals("keep")) {
                mode = 0;
            } else {
                throw new IllegalArgumentException("Mode string : precious|cached|keep");
            }
            return mode;
        }

        public void setProtocolInfo(String hostName, String protType, String protMajor, String protMinor) {
            if (hostName != null || protType != null || protMinor != null || protMajor != null) {
                this._hostName = hostName == null ? "localhost" : hostName;
                this._protType = protType == null ? "DCap" : protType;
                this._protMinor = protMinor == null ? 0 : Integer.parseInt(protMinor);
                this._protMajor = protMajor == null ? 3 : Integer.parseInt(protMajor);
                this._info = new DCapProtocolInfo(this._protType, this._protMajor, this._protMajor, new InetSocketAddress(hostName, 0));
            }
        }

        public ProtocolInfo getProtocolInfo() {
            return this._info;
        }

        public String toString() {
            return this._name + "=\"" + this._patternStr + "\";st=" + this._status + ";dest=" + this._path + ";source=" + this._source + ";info=" + (this._info == null ? "None" : this._info.toString());
        }
    }
}

