/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.replicaManager;

import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.replicaManager.DCacheCoreControllerV2;
import diskCacheV111.replicaManager.ReplicaDbV1;
import diskCacheV111.replicaManager.Semaphore;
import diskCacheV111.repository.CacheRepositoryEntryInfo;
import diskCacheV111.util.Pgpass;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PnfsAddCacheLocationMessage;
import diskCacheV111.vehicles.PnfsModifyCacheLocationMessage;
import diskCacheV111.vehicles.PoolModifyModeMessage;
import diskCacheV111.vehicles.PoolRemoveFilesMessage;
import diskCacheV111.vehicles.PoolStatusChangedMessage;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaManagerV2
extends DCacheCoreControllerV2 {
    private static final String _svnId = "$Id$";
    private static final Logger _log = LoggerFactory.getLogger(ReplicaManagerV2.class);
    private boolean _debug;
    private String _jdbcUrl = "jdbc:postgresql://localhost/replicas";
    private String _driver = "org.postgresql.Driver";
    private String _user = "postgres";
    private String _pass = "NoPassword";
    private String _pwdfile;
    private ReplicaDbV1 _dbrmv2;
    private boolean _useDB;
    private Args _args;
    private Adjuster _adj;
    private WatchPools _watchPools;
    private Thread _watchDog;
    private Thread _dbThread;
    private Thread _adjThread;
    private boolean _stopThreads;
    private boolean _runAdjuster = true;
    private boolean _XXcheckPoolHost;
    private int _repId = 1;
    private int _redId = 1;
    private int _cntOnlinePools;
    private final Set<String> _poolsToWait = new HashSet<String>();
    private Map<String, String> _poolMap;
    private int _repMin = 2;
    private int _repMax = 3;
    private final ResilientPools _resilientPools;
    private final Object _dbLock = new Object();
    private boolean _initDbActive;
    private boolean _runPoolWatchDog;
    private boolean _hotRestart = true;
    private InitDbRunnable _initDbRunnable;
    private final long SECOND = 1000L;
    private final long MINUTE = 60000L;
    private final long HOUR = 3600000L;
    private long _delayDBStartTO = 1200000L;
    private long _delayAdjStartTO = 1260000L;
    private long _delayPoolScan = 120000L;
    private final DBUpdateMonitor _dbUpdated = new DBUpdateMonitor();
    public static final String hh_debug = "true | false";
    public static final String hh_enable_same_host_replication = "true | false";
    public static final String hh_XX_check_pool_host = "true | false  # experimental, can be changed";
    public static final String hh_db_wakeup = "                     # wakeup DB initialization on startup when it waits pools to connect";
    public static final String hh_show_pool = "<pool>               # show pool status";
    public static final String hh_set_pool = "<pool> <state>";
    public static final String hh_ls_unique = "<pool>               # check if pool drained off (has unique pndfsIds)";
    public static final String hh_ls_pnfsid = "[<pnfsId>]           # DEBUG: list pools for pnfsid[s], from DB";
    public static final String hh_show_hostmap = " [<pool>] # show pool to host mapping";
    public static final String hh_set_hostmap = " <pool> <host> # set TEMPORARILY pool to host mapping";
    public static final String hh_remove_hostmap = " <pool>  # remove pool to host mapping for the pool 'pool'";
    public static final String hh_update = "<pnfsid> [-c]           # DEBUG: get pools list from pnfs, '-c' confirm with pools";
    public static final String hh_reduce = "<pnfsId>";
    public static final String hh_replicate = "<pnfsId>";
    public static final String hh_copy = "<pnfsId> <sourcePool>|* <destinationPool>  #  does not check for free space in dest";
    public static final String hh_exclude = "<pnfsId> [iErrCode [sErrorMessage] ]  # exclude <pnfsId> from replication";
    public static final String hh_release = "<pnfsId>               # removes transaction/'BAD' status for pnfsId";
    public static final String hh_pool_inventory = "<pool>          # DEBUG - danger, DB not locked";
    public static final String hh_clear = "<pnfsid>                 # DEBUG: removes pnfsid from replicas table in DB";

    public boolean getDebugRM() {
        return this._debug;
    }

    public void setDebugRM(boolean d) {
        this._debug = d;
    }

    public void setDebug2(boolean d) {
        this._debug = d;
        super.setDebug(d);
    }

    public void setCheckPoolHost(boolean d) {
        this._XXcheckPoolHost = d;
    }

    private boolean getCheckPoolHost() {
        return this._XXcheckPoolHost;
    }

    private void initResilientPools() {
        while (true) {
            try {
                List<String> l;
                while ((l = this._resilientPools.init()) == null) {
                }
            }
            catch (Exception ex) {
                _log.warn("InitResilientPools() - got exception '" + ex + "'");
                continue;
            }
            break;
        }
    }

    @Override
    public List<String> getPoolListResilient() throws Exception {
        List<String> poolList = this.getPoolList();
        poolList.retainAll(this._resilientPools.getResilientPools());
        return poolList;
    }

    private void parseDBArgs() {
        Pgpass pgpass;
        String p;
        String cfPass;
        String cfUser;
        String cfDriver;
        _log.info("Parse DB arguments " + this._args);
        String cfURL = this._args.getOpt("dbURL");
        if (cfURL != null) {
            this._jdbcUrl = cfURL;
        }
        if ((cfDriver = this._args.getOpt("jdbcDrv")) != null) {
            this._driver = cfDriver;
        }
        if ((cfUser = this._args.getOpt("dbUser")) != null) {
            this._user = cfUser;
        }
        if ((cfPass = this._args.getOpt("dbPass")) != null) {
            this._pass = cfPass;
        }
        this._pwdfile = this._args.getOpt("pgPass");
        if (this._jdbcUrl == null || this._driver == null || this._user == null || this._pass == null && this._pwdfile == null) {
            throw new IllegalArgumentException("Not enough arguments to Init SQL database");
        }
        if (this._pwdfile != null && this._pwdfile.length() > 0 && (p = (pgpass = new Pgpass(this._pwdfile)).getPgpass(cfURL, cfUser)) != null) {
            this._pass = p;
        }
    }

    private void parseArgs() {
        String argCheckPoolHost;
        String argSameHost;
        String maxWorkers;
        String sExcludedFilesExpirationTO;
        String poolWatchDogPeriod;
        String waitReduceTO;
        String waitReplicateTO;
        String waitDBUpdateTO;
        String delayAdjStartTO;
        String delayDBStartTO;
        String max;
        String min = this._args.getOpt("min");
        if (min != null) {
            this._repMin = Integer.parseInt(min);
            this._adj.setMin(this._repMin);
            _log.info("Set _repMin=" + this._repMin);
        }
        if ((max = this._args.getOpt("max")) != null) {
            this._repMax = Integer.parseInt(max);
            this._adj.setMax(this._repMax);
            _log.info("Set _repMax=" + this._repMax);
        }
        if ((delayDBStartTO = this._args.getOpt("delayDBStartTO")) != null) {
            this._delayDBStartTO = Integer.parseInt(delayDBStartTO) * 1000;
            _log.info("Set _delayDBStartTO=" + this._delayDBStartTO + " ms");
        }
        if ((delayAdjStartTO = this._args.getOpt("delayAdjStartTO")) != null) {
            this._delayAdjStartTO = Integer.parseInt(delayAdjStartTO) * 1000;
            _log.info("Set _delayAdjStartTO=" + this._delayAdjStartTO + " ms");
        }
        if ((waitDBUpdateTO = this._args.getOpt("waitDBUpdateTO")) != null) {
            long timeout = (long)Integer.parseInt(waitDBUpdateTO) * 1000L;
            this._adj.setWaitDBUpdateTO(timeout);
            _log.info("Set waitDBUpdateTO=" + timeout + " ms");
        }
        if ((waitReplicateTO = this._args.getOpt("waitReplicateTO")) != null) {
            long timeout = (long)Integer.parseInt(waitReplicateTO) * 1000L;
            this._adj.setWaitReplicateTO(timeout);
            _log.info("Set waitReplicateTO=" + timeout + " ms");
        }
        if ((waitReduceTO = this._args.getOpt("waitReduceTO")) != null) {
            long timeout = (long)Integer.parseInt(waitReduceTO) * 1000L;
            this._adj.setWaitReduceTO(timeout);
            _log.info("Set waitReduceTO=" + timeout + " ms");
        }
        if ((poolWatchDogPeriod = this._args.getOpt("poolWatchDogPeriod")) != null) {
            long timeout = (long)Integer.parseInt(poolWatchDogPeriod) * 1000L;
            this._watchPools.setPeriod(timeout);
            _log.info("Set poolWatchDogPeriod=" + timeout + " ms");
        }
        if ((sExcludedFilesExpirationTO = this._args.getOpt("excludedFilesExpirationTO")) != null) {
            long timeout = (long)Integer.parseInt(sExcludedFilesExpirationTO) * 1000L;
            this._watchPools.setExcludedExpiration(timeout);
            _log.info("Set excludedFilesExpirationTO=" + timeout + " ms");
        }
        if ((maxWorkers = this._args.getOpt("maxWorkers")) != null) {
            int mx = Integer.parseInt(maxWorkers);
            this._adj.setMaxWorkers(mx);
            _log.info("Set adjuster maxWorkers=" + mx);
        }
        if (this._args.hasOption("coldStart")) {
            this._hotRestart = false;
        }
        if (this._args.hasOption("hotRestart")) {
            this._hotRestart = true;
        }
        if ((argSameHost = this._args.getOpt("enableSameHostReplica")) != null) {
            this.setEnableSameHostReplica(Boolean.valueOf(argSameHost));
        }
        if ((argCheckPoolHost = this._args.getOpt("XXcheckPoolHost")) != null) {
            this.setCheckPoolHost(Boolean.valueOf(argCheckPoolHost));
        }
    }

    public ReplicaManagerV2(String cellName, String args) {
        super(cellName, args);
        this._args = this.getArgs();
        String argDebug = this._args.getOpt("debug");
        if (argDebug != null) {
            this._debug = Boolean.valueOf(argDebug);
        }
        this.setDebug(this._debug);
        this.parseDBArgs();
        _log.debug("Setup database with: URL=" + this._jdbcUrl + " driver=" + this._driver + " user=" + this._user + " passwd=********");
        ReplicaDbV1.setup(this._jdbcUrl, this._driver, this._user, this._pass);
        try {
            this._dbrmv2 = this.installReplicaDb();
        }
        catch (Exception ex) {
            _log.warn("ERROR, can not instantiate replica DB - got exception, now exiting\n==================================================================Check if DB server running and restart Replica Manager");
            System.exit(1);
        }
        this._adj = new Adjuster(this._repMin, this._repMax);
        this._watchPools = new WatchPools();
        _log.warn("ReplicaManager   version: $Id$");
        _log.warn("DCacheController version: " + super.getSvnId());
        _log.info("Parse arguments");
        this.parseArgs();
        this._resilientPools = new ResilientPools(this._args);
        this._initDbRunnable = new InitDbRunnable(this._delayDBStartTO);
        _log.info("Create threads");
        this._dbThread = this.getNucleus().newThread((Runnable)this._initDbRunnable, "RepMgr-initDB");
        this._adjThread = this.getNucleus().newThread((Runnable)this._adj, "RepMgr-Adjuster");
        this._watchDog = this.getNucleus().newThread((Runnable)this._watchPools, "RepMgr-PoolWatchDog");
        _log.info("Start Init DB  thread");
        this._dbThread.start();
        _log.info("Start Adjuster thread");
        this._adjThread.start();
        _log.info("Starting cell");
        this.start();
    }

    public void cleanUp() {
        _log.debug("=== cleanUp called ===");
        this._stopThreads = true;
        this._runPoolWatchDog = false;
        try {
            if (this._dbThread != null) {
                this._dbThread.interrupt();
            }
            if (this._adjThread != null) {
                this._adjThread.interrupt();
            }
            if (this._watchDog != null) {
                this._watchDog.interrupt();
            }
            if (this._dbThread != null) {
                this._dbThread.join(500L);
            }
            if (this._adjThread != null) {
                this._adjThread.join(500L);
            }
            if (this._watchDog != null) {
                this._watchDog.join(500L);
            }
        }
        catch (InterruptedException e) {
            _log.warn("Replica manager failed to shut down", (Throwable)e);
        }
        super.cleanUp();
    }

    @Override
    public void cellCreated(CellEvent ce) {
        super.cellCreated(ce);
        _log.debug("=== cellCreated called ===, ce=" + ce);
    }

    @Override
    public void cellDied(CellEvent ce) {
        super.cellDied(ce);
        _log.debug("=== cellDied called ===, ce=" + ce);
    }

    @Override
    public void cellExported(CellEvent ce) {
        super.cellExported(ce);
        _log.debug("=== cellExported called ===, ce=" + ce);
    }

    @Override
    public void routeAdded(CellEvent ce) {
        super.routeAdded(ce);
        _log.debug("=== routeAdded called ===, ce=" + ce);
    }

    @Override
    public void routeDeleted(CellEvent ce) {
        super.routeDeleted(ce);
        _log.debug("=== routeDeleted called ===, ce=" + ce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("       Version : $Id$");
        super.getInfo(pw);
        Object object = this._dbLock;
        synchronized (object) {
            pw.println(" initDb Active : " + this._initDbActive);
        }
        pw.println(" debug : " + this.getDebugRM());
        pw.println(" enableSameHostReplica : " + this.getEnableSameHostReplica());
        pw.println(" XXcheckPoolHost : " + this.getCheckPoolHost());
    }

    private ReplicaDbV1 installReplicaDb() {
        return new ReplicaDbV1(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbUpdatePool(String poolName) throws Exception {
        List<CacheRepositoryEntryInfo> fileList;
        int loop;
        _log.info(" dbUpdatePool " + poolName);
        try {
            loop = 1;
            while (true) {
                block18: {
                    try {
                        fileList = this.getPoolRepository(poolName);
                        break;
                    }
                    catch (ConcurrentModificationException cmee) {
                        _log.warn(" dbUpdatePool - Pnfs List was invalidated. retry=" + loop + " pool=" + poolName);
                        if (loop == 4) {
                            throw cmee;
                        }
                    }
                    catch (MissingResourceException mre) {
                        _log.warn(" dbUpdatePool - Can not get PnfsId List. retry=" + loop + " pool=" + poolName);
                        if (loop != 4) break block18;
                        throw mre;
                    }
                }
                ++loop;
            }
        }
        catch (Exception ee) {
            _log.warn(" dbUpdatePool - Problem fetching repository from " + poolName + " : " + ee);
            _log.debug(ee.toString(), (Throwable)ee);
            throw ee;
        }
        _log.info(" dbUpdatePool - Got " + fileList.size() + " pnfsIds from " + poolName);
        this._dbrmv2.removePool(poolName);
        this._dbrmv2.addPnfsToPool(fileList, poolName);
        if (this._XXcheckPoolHost) {
            try {
                loop = 1;
                while (true) {
                    try {
                        String hostName = this.getPoolHost(poolName);
                        if (hostName == null) break;
                        Map mre = this._hostMap;
                        synchronized (mre) {
                            this._hostMap.put(poolName, hostName);
                            _log.debug("dbUpdatePool: _hostMap updated, pool=" + poolName + " host=" + hostName);
                        }
                    }
                    catch (NoRouteToCellException ex) {
                        _log.warn(" dbUpdatePool - get hostname - No route to cell. retry=" + loop + " pool=" + poolName);
                        if (loop == 4) {
                            throw ex;
                        }
                        ++loop;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ee) {
                _log.warn(" dbUpdatePool - Problem get/set host name for the pool " + poolName + " : " + ee);
                _log.debug(ee.toString(), (Throwable)ee);
                throw ee;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDb() {
        Object object = this._dbLock;
        synchronized (object) {
            _log.info("Starting cleanupDb()");
            this._poolMap = new HashMap<String, String>();
            if (this._hotRestart) {
                _log.info("Clear DB for online pools");
                _log.debug("Save old db pools state into map");
                this._dbrmv2.clearTransactions();
                Iterator<String> p = this._dbrmv2.getPools();
                while (p.hasNext()) {
                    String pool = p.next();
                    String poolSts = this._dbrmv2.getPoolStatus(pool);
                    this._poolMap.put(pool, poolSts);
                    _log.debug("Add to poolMap : [" + pool + "] " + poolSts);
                    if (!poolSts.equals("online")) continue;
                    this._poolsToWait.add(pool);
                    this._dbrmv2.clearPool(pool);
                }
                ((ReplicaDbV1.DbIterator)p).close();
            } else {
                _log.info("Cleanup DB");
                this._dbrmv2.clearAll();
                this._dbrmv2.clearTransactions();
            }
            this._cntOnlinePools = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws Exception {
        _log.info("Starting initDb()");
        Object object = this._dbLock;
        synchronized (object) {
            this.initResilientPools();
            _log.debug("Asking for Pool List");
            List<String> allPools = this.getPoolList();
            _log.info("Got " + allPools.size() + " pools (any pools) connected");
            List<String> pools = this.getPoolListResilient();
            _log.info("Got " + pools.size() + " resilient pools connected");
            Iterator<String> i$ = pools.iterator();
            while (i$.hasNext()) {
                String pool;
                String poolName = pool = i$.next();
                _log.debug("Got pool [" + poolName + "]");
                String oldStatus = this._poolMap.get(poolName);
                _log.debug("Got from poolMap : " + poolName + " " + oldStatus);
                this._dbrmv2.setPoolStatus(poolName, "offline");
                try {
                    this.dbUpdatePool(poolName);
                }
                catch (Exception ee) {
                    _log.info(" initDb - Problem fetching repository from " + poolName + " : " + ee);
                    _log.info(" initDb - pool " + poolName + " stays '" + "offline" + "'");
                    continue;
                }
                String newStatus = oldStatus == null || oldStatus.equals("UNKNOWN") ? "online" : oldStatus;
                this._dbrmv2.setPoolStatus(poolName, newStatus);
                if (!newStatus.equals("online")) continue;
                this._poolsToWait.remove(poolName);
                _log.debug("Pool " + poolName + " set online, _poolsToWait.size()=" + this._poolsToWait.size());
                ++this._cntOnlinePools;
            }
            this._useDB = true;
        }
        _log.info("Init DB done");
    }

    private int poolDisable(String poolName) {
        int modeBits = 63;
        return this.setPoolMode(poolName, modeBits);
    }

    private int poolEnable(String poolName) {
        int modeBits = 0;
        return this.setPoolMode(poolName, modeBits);
    }

    private int poolRdOnly(String poolName) {
        int modeBits = 29;
        return this.setPoolMode(poolName, modeBits);
    }

    private int setPoolMode(String poolName, int modeBits) {
        PoolModifyModeMessage reply;
        int rc = 1;
        String rm = "Replica Manager Command";
        PoolV2Mode mode = new PoolV2Mode(modeBits);
        PoolModifyModeMessage msg = new PoolModifyModeMessage(poolName, mode);
        msg.setStatusInfo(rc, rm);
        try {
            reply = (PoolModifyModeMessage)this.sendObject(poolName, (Serializable)msg);
        }
        catch (Exception ee) {
            _log.warn("setPoolMode pool=" + poolName + ", mode=" + new PoolV2Mode(modeBits).toString() + " - got exception '" + ee.getMessage() + "'");
            return -1;
        }
        if (reply.getReturnCode() != 0) {
            _log.warn("setPoolMode pool=" + poolName + ", mode=" + new PoolV2Mode(modeBits).toString() + " - error '" + reply.getErrorObject().toString() + "'");
            return -1;
        }
        return 0;
    }

    public String ac_debug_$_1(Args args) {
        String cmd = args.argv(0);
        if (cmd.equalsIgnoreCase("true")) {
            this.setDebug2(true);
            _log.info("debug true");
            return "debug true";
        }
        if (cmd.equalsIgnoreCase("false")) {
            this.setDebug2(false);
            _log.info("debug false");
            return "debug false";
        }
        _log.info("Wrong argument '" + cmd + "'");
        return "wrong argument";
    }

    public String ac_enable_same_host_replication_$_1(Args args) {
        String m;
        String cmd = args.argv(0);
        String msg = "same host replication ";
        if (cmd.equalsIgnoreCase("true")) {
            this.setEnableSameHostReplica(true);
            m = msg + "enabled";
        } else if (cmd.equalsIgnoreCase("false")) {
            this.setEnableSameHostReplica(false);
            m = msg + "disabled";
        } else {
            m = "Wrong argument '" + cmd + "'";
        }
        _log.info(m);
        return m;
    }

    public String ac_XX_check_pool_host_$_1(Args args) {
        String m;
        String cmd = args.argv(0);
        String msg = "check pool host ";
        if (cmd.equalsIgnoreCase("true")) {
            this.setCheckPoolHost(true);
            m = msg + "true";
        } else if (cmd.equalsIgnoreCase("false")) {
            this.setCheckPoolHost(false);
            m = msg + "false";
        } else {
            m = "Wrong argument '" + cmd + "'";
        }
        _log.info(m);
        return m;
    }

    public String ac_db_wakeup(Args args) {
        if (this._initDbRunnable != null) {
            this._initDbRunnable.wakeupWaitInit();
            return "woke up db";
        }
        return "_initDbRunnable is not instantiated";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_show_pool_$_1(Args args) {
        String poolStatus;
        String poolName = args.argv(0);
        Object object = this._dbLock;
        synchronized (object) {
            poolStatus = this._dbrmv2.getPoolStatus(poolName);
        }
        String s = "Pool '" + poolName + "' status " + poolStatus;
        _log.info("INFO: {}", (Object)s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_set_pool_$_2(Args args) {
        String poolName = args.argv(0);
        String poolStatus = args.argv(1);
        boolean updatedOK = false;
        boolean setOK = false;
        String sErrRet = "Resilient Pools List is not defined (yet), ignore";
        if (this._resilientPools == null) {
            _log.debug(sErrRet);
            return sErrRet;
        }
        List l = this._resilientPools.getResilientPools();
        if (l == null) {
            _log.debug(sErrRet);
            return sErrRet;
        }
        if (!l.contains(poolName)) {
            String sErrRet2 = "Pool " + poolName + " is not resilient pool, ignore command";
            _log.debug(sErrRet2);
            return sErrRet2;
        }
        Object object = this._dbLock;
        synchronized (object) {
            String poolStatusOld = this._dbrmv2.getPoolStatus(poolName);
            _log.info("Pool '" + poolName + "' status was " + poolStatusOld);
            if (poolStatus.equals("down") || poolStatus.equals("online") || poolStatus.equals("offline") || poolStatus.equals("offline-prepare") || poolStatus.equals("drainoff")) {
                boolean countablePool;
                boolean bl = countablePool = poolStatus.equals("online") || poolStatus.equals("offline-prepare") || poolStatus.equals("drainoff");
                if (countablePool) {
                    setOK = true;
                }
                if (countablePool && setOK || !countablePool) {
                    if ((poolStatusOld.equals("down") || poolStatusOld.equals("UNKNOWN")) && !poolStatus.equals("down") || poolStatus.equals("online") && !poolStatus.equals(poolStatusOld)) {
                        try {
                            this.dbUpdatePool(poolName);
                            this._dbrmv2.setPoolStatus(poolName, poolStatus);
                            _log.info("setpool, pool " + poolName + " state change to '" + poolStatus + "' updated in DB");
                        }
                        catch (Exception ex) {
                            _log.info(" setpool - Problem fetching repository from " + poolName + " : " + ex);
                            _log.info(" setpool - pool " + poolName + " stays '" + poolStatusOld + "'");
                        }
                    } else {
                        this._dbrmv2.setPoolStatus(poolName, poolStatus);
                        _log.info("Pool '" + poolName + "' status set to " + poolStatus);
                    }
                }
                if (poolStatus.equals("down") || poolStatus.equals("offline")) {
                    setOK = true;
                }
                updatedOK = true;
            }
        }
        if (updatedOK && setOK) {
            _log.info("setpool, pool " + poolName + ", notify All");
            this._dbUpdated.wakeup();
            return "ok";
        }
        _log.info("Can not set pool '" + poolName + "' state to " + poolStatus + ", ignored");
        if (updatedOK && setOK) {
            _log.info("Tansaction error: pool state or DB modified, but not both");
        }
        return "error";
    }

    public String ac_ls_unique_$_1(Args args) {
        String poolName = args.argv(0);
        _log.info("pool '" + poolName + "'");
        List<Object> uniqueList = this.findUniqueFiles(poolName);
        int uniqueFiles = uniqueList.size();
        _log.info("Found " + uniqueFiles + " unique files in pool '" + poolName + "'");
        for (Object pnfsId : uniqueList) {
            _log.info("Unique in " + poolName + ", pnfsId=" + pnfsId);
        }
        return "Found " + uniqueFiles;
    }

    private List<Object> findUniqueFiles(String poolName) {
        String rec;
        ArrayList<String> missingList = new ArrayList<String>();
        ArrayList<String> inPoolList = new ArrayList<String>();
        Iterator<String> inPool = this._dbrmv2.pnfsIds(poolName);
        Iterator<String> missing = this._dbrmv2.getMissing();
        while (missing.hasNext()) {
            rec = missing.next();
            missingList.add(rec);
        }
        ((ReplicaDbV1.DbIterator)missing).close();
        while (inPool.hasNext()) {
            rec = inPool.next();
            inPoolList.add(rec);
        }
        ((ReplicaDbV1.DbIterator)inPool).close();
        HashSet inPoolSet = new HashSet(inPoolList);
        ArrayList<Object> uniqueList = new ArrayList<Object>();
        for (Object e : missingList) {
            if (!inPoolSet.contains(e)) continue;
            uniqueList.add(e);
        }
        return uniqueList;
    }

    public String ac_ls_pnfsid_$_0_1(Args args) {
        StringBuilder sb = new StringBuilder();
        if (args.argc() == 0) {
            Iterator<String> it = this._dbrmv2.pnfsIds();
            while (it.hasNext()) {
                PnfsId pnfsId = new PnfsId(it.next());
                sb.append(this.printCacheLocation(pnfsId)).append("\n");
            }
            ((ReplicaDbV1.DbIterator)it).close();
        } else {
            PnfsId pnfsId = new PnfsId(args.argv(0));
            sb.append(this.printCacheLocation(pnfsId)).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_show_hostmap_$_0_1(Args args) {
        StringBuilder sb = new StringBuilder();
        if (args.argc() == 0) {
            Map map = this._hostMap;
            synchronized (map) {
                for (Object o : this._hostMap.keySet()) {
                    String poolName = o.toString();
                    String hostName = (String)this._hostMap.get(poolName);
                    sb.append(poolName).append(" ").append(hostName).append("\n");
                }
            }
        }
        String poolName = args.argv(0);
        if (poolName != null) {
            Map map = this._hostMap;
            synchronized (map) {
                String hostName = (String)this._hostMap.get(poolName);
                sb.append(poolName).append(" ").append(hostName).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_set_hostmap_$_2(Args args) {
        StringBuilder sb = new StringBuilder();
        String poolName = args.argv(0);
        String hostName = args.argv(1);
        if (poolName != null && hostName != null) {
            Map map = this._hostMap;
            synchronized (map) {
                this._hostMap.put(poolName, hostName);
            }
            sb.append("set hostmap ").append(poolName).append(" ").append(hostName).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_remove_hostmap_$_1(Args args) {
        StringBuilder sb = new StringBuilder();
        String poolName = args.argv(0);
        if (poolName != null) {
            Map map = this._hostMap;
            synchronized (map) {
                this._hostMap.remove(poolName);
            }
            sb.append("remove hostmap ").append(poolName).append("\n");
        }
        return sb.toString();
    }

    public String ac_update_$_1(Args args) throws Exception {
        StringBuilder sb = new StringBuilder();
        PnfsId pnfsId = new PnfsId(args.argv(0));
        sb.append("Old : ").append(this.printCacheLocation(pnfsId)).append("\n");
        List<String> list = this.getCacheLocationList(pnfsId, args.hasOption("c"));
        this._dbrmv2.clearPools(pnfsId);
        for (String location : list) {
            this._dbrmv2.addPool(pnfsId, location.toString());
        }
        sb.append("New : ").append(this.printCacheLocation(pnfsId)).append("\n");
        return sb.toString();
    }

    public String ac_reduce_$_1(Args args) {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        ReducePnfsIDRunnable r = new ReducePnfsIDRunnable(pnfsId);
        this.getNucleus().newThread((Runnable)r).start();
        return "initiated (See pinboard for more information)";
    }

    public String ac_replicate_$_1(Args args) {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        ReplicatePnfsIDRunnable r = new ReplicatePnfsIDRunnable(pnfsId);
        this.getNucleus().newThread((Runnable)r).start();
        return "initiated (See pinboard for more information)";
    }

    public String ac_copy_$_3(Args args) throws Exception {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        String source = args.argv(1);
        String destination = args.argv(2);
        HashSet<String> set = new HashSet<String>();
        Iterator<String> it = this._dbrmv2.getPools(pnfsId);
        while (it.hasNext()) {
            set.add(it.next());
        }
        ((ReplicaDbV1.DbIterator)it).close();
        if (set.isEmpty()) {
            throw new IllegalArgumentException("No source found for p2p");
        }
        if (source.equals("*")) {
            source = (String)set.iterator().next();
        }
        if (!set.contains(source)) {
            throw new IllegalArgumentException("Source " + source + " not found in pools list");
        }
        if (set.contains(destination)) {
            throw new IllegalArgumentException("Destination " + destination + " already found in pools list");
        }
        DCacheCoreControllerV2.TaskObserver observer = this.movePnfsId(pnfsId, source, destination);
        return observer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_exclude_$_1_3(Args args) {
        long timeStamp = System.currentTimeMillis();
        PnfsId pnfsId = new PnfsId(args.argv(0));
        String iErr = args.argc() > 1 ? args.argv(1) : "-2";
        String eMsg = args.argc() > 2 ? args.argv(2) : "Operator intervention";
        Object object = this._dbLock;
        synchronized (object) {
            this._dbrmv2.addExcluded(pnfsId, timeStamp, iErr, eMsg);
        }
        String msg = "pnfsId=" + pnfsId + " excluded from replication";
        _log.info(msg);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_release_$_1(Args args) {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        Object object = this._dbLock;
        synchronized (object) {
            this._dbrmv2.removeTransaction(pnfsId);
        }
        String msg = "pnfsId=" + pnfsId + " released";
        _log.info(msg + ",  (active transaction or 'exclude' status cleared)");
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_pool_inventory_$_1(Args args) {
        String poolName = args.argv(0);
        Object object = this._dbLock;
        synchronized (object) {
            if (this._initDbActive) {
                throw new IllegalArgumentException("InitDb still active");
            }
            this._initDbActive = true;
        }
        dbUpdatePoolRunnable r = new dbUpdatePoolRunnable(poolName);
        this.getNucleus().newThread((Runnable)r, "RepMgr-dbUpdatePool").start();
        return "Initiated";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_clear_$_1(Args args) {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        Object object = this._dbLock;
        synchronized (object) {
            this._dbrmv2.clearPools(pnfsId);
        }
        return "";
    }

    private String printCacheLocation(PnfsId pnfsId) {
        StringBuilder sb = new StringBuilder();
        sb.append(pnfsId.toString()).append(" ");
        Iterator<String> it = this._dbrmv2.getPools(pnfsId);
        while (it.hasNext()) {
            sb.append(it.next()).append(" ");
        }
        ((ReplicaDbV1.DbIterator)it).close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheLocationModified(PnfsModifyCacheLocationMessage msg, boolean wasAdded) {
        PnfsId pnfsId = msg.getPnfsId();
        String poolName = msg.getPoolName();
        String strLocModified = "cacheLocationModified : pnfsID " + pnfsId + (wasAdded ? " added to" : " removed from") + " pool " + poolName;
        List l = this._resilientPools.getResilientPools();
        if (l == null) {
            _log.debug(strLocModified);
            _log.debug("Resilient Pools List is not defined (yet), ignore file added/removed");
            return;
        }
        if (!l.contains(poolName)) {
            _log.debug(strLocModified);
            _log.debug("Pool " + poolName + " is not resilient pool, ignore file added/removed");
            return;
        }
        _log.info(strLocModified);
        Object object = this._dbLock;
        synchronized (object) {
            if (!this._useDB) {
                _log.info("DB not ready yet, ignore ::" + strLocModified);
                return;
            }
            if (this._debug) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.printCacheLocation(pnfsId)).append("\n");
                _log.debug("Pool list in DB before " + (wasAdded ? "Insertion" : "Removal") + "\n" + "for pnfsId=" + pnfsId + " \n" + sb.toString());
            }
            if (wasAdded) {
                this._dbrmv2.addPool(pnfsId, poolName);
            } else {
                this._dbrmv2.removePool(pnfsId, poolName);
            }
            _log.debug("cacheLocationModified() : DB updated, notify All");
        }
        this._dbUpdated.addPnfsId(pnfsId);
        this._dbUpdated.wakeupByPnfsId();
        _log.info("cacheLocationModified : pnfsID " + pnfsId + (wasAdded ? " added to" : " removed from") + " pool " + poolName + " - DB updated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheLocationAdded(List<PnfsAddCacheLocationMessage> ml) {
        List lres = this._resilientPools.getResilientPools();
        if (lres == null) {
            _log.debug("Resilient Pools List is not defined (yet), ignore added replica list");
            return;
        }
        LinkedList<Replica> rList = new LinkedList<Replica>();
        for (PnfsAddCacheLocationMessage msg : ml) {
            PnfsId pnfsId = msg.getPnfsId();
            String poolName = msg.getPoolName();
            if (lres.contains(poolName)) {
                Replica r = new Replica(pnfsId, poolName);
                rList.add(r);
                _log.debug("cacheLocationAdded(List) : add replica to update list " + r);
                continue;
            }
            _log.debug("cacheLocationAdded(List) : skip replica {" + pnfsId + "," + poolName + "} - pool is not on my resilient pool list");
        }
        int count = rList.size();
        if (count == 0) {
            return;
        }
        Object object = this._dbLock;
        synchronized (object) {
            if (!this._useDB) {
                _log.debug("cacheLocationAdded(): DB not ready yet, skip " + rList.size() + " replica updates");
                return;
            }
            for (Replica r : rList) {
                this._dbUpdated.addPnfsId(r.getPnfsId());
                this._dbrmv2.addPool(r.getPnfsId(), r.getPool());
            }
        }
        _log.debug("cacheLocationAdded(List) : added " + count + " pnfsid(s) to DB, notify All");
        this._dbUpdated.wakeupByPnfsId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPoolStatusChangedMessage(PoolStatusChangedMessage msg) {
        boolean doPoolInventory;
        boolean onReplicaMgrCommand;
        String poolStatus;
        String msPool = msg.getPoolName();
        String msPoolStatus = msg.getPoolStatus();
        String strStatusChanged = "Pool " + msPool + " status changed to " + msPoolStatus;
        List l = this._resilientPools.getResilientPools();
        if (l == null) {
            _log.debug(strStatusChanged);
            _log.debug("Resilient Pools List is not defined (yet), ignore pool status change");
            return;
        }
        if (!l.contains(msPool)) {
            _log.debug(strStatusChanged);
            _log.debug("Pool " + msPool + " is not resilient pool, ignore pool status change");
            return;
        }
        switch (msPoolStatus) {
            case "DOWN": {
                poolStatus = "down";
                break;
            }
            case "UP": 
            case "RESTART": {
                poolStatus = "online";
                break;
            }
            case "UNKNOWN": {
                poolStatus = "down";
                _log.info("poolStatusChanged ERROR, pool " + msPool + " state changed to '" + msPoolStatus + "'" + " - set pool status to " + poolStatus);
                break;
            }
            default: {
                _log.info("poolStatusChanged ERROR, pool " + msPool + " state changed to unknown state '" + msPoolStatus + "'" + ", message ignored");
                return;
            }
        }
        _log.info("poolStatusChanged, pool " + msPool + " state changed to '" + poolStatus + "'");
        String detailString = msg.getDetailMessage();
        if (this._debug) {
            int pState = msg.getPoolState();
            PoolV2Mode pMode = msg.getPoolMode();
            int detailCode = msg.getDetailCode();
            _log.debug("PoolStatusChangedMessage msg=" + msg);
            _log.debug("pool_state=" + pState);
            _log.debug("pool_mode=" + (pMode == null ? "null" : pMode.toString()));
            _log.debug("detail_code=" + detailCode);
            _log.debug("detail_string=" + (detailString == null ? "null" : detailString));
        }
        boolean bl = onReplicaMgrCommand = detailString != null && detailString.equals("Replica Manager Command");
        if (onReplicaMgrCommand) {
            _log.debug("pool status changed on RM command");
        }
        String poolName = msPool;
        boolean bl2 = doPoolInventory = poolStatus.equals("online") || poolStatus.equals("offline") || poolStatus.equals("offline-prepare");
        if (!onReplicaMgrCommand || poolStatus.equals("online")) {
            Object object = this._dbLock;
            synchronized (object) {
                if (!this._useDB) {
                    _log.info("DB not ready yet, skip DB update");
                    return;
                }
                this.updatePool(poolName, poolStatus, doPoolInventory);
            }
            this._dbUpdated.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePool(String poolName, String poolStatus, boolean doPoolInventory) {
        Object object = this._dbLock;
        synchronized (object) {
            String poolStatusOld = this._dbrmv2.getPoolStatus(poolName);
            if (poolStatusOld.equals("drainoff")) {
                _log.info("poolStatusChanged, Pool '" + poolName + "' status is " + poolStatusOld + ", ignore pool status change messages");
            } else {
                _log.info("poolStatusChanged, Pool '" + poolName + "' status was " + poolStatusOld);
                if (poolStatus.equals("online")) {
                    this._poolsToWait.remove(poolName);
                }
                if (!doPoolInventory) {
                    this._dbrmv2.setPoolStatus(poolName, poolStatus);
                    _log.info("poolStatusChanged, pool " + poolName + " state change to '" + poolStatus + "' updated in DB, notify All");
                } else {
                    this._dbrmv2.setPoolStatus(poolName, "offline");
                    try {
                        this.dbUpdatePool(poolName);
                        this._dbrmv2.setPoolStatus(poolName, poolStatus);
                        _log.info("poolStatusChanged, pool " + poolName + " state change to '" + poolStatus + "' updated in DB, notify All");
                    }
                    catch (Exception ee) {
                        _log.info(" poolStatusChanged - Problem fetching repository from " + poolName + " : " + ee);
                        _log.info(" poolStatusChanged - pool " + poolName + " stays '" + "offline" + "'");
                    }
                }
                Set<String> set = this._poolsToWait;
                synchronized (set) {
                    if (this._initDbRunnable != null && this._initDbRunnable.isWaiting() && this._poolsToWait.size() == 0) {
                        this._poolsToWait.notifyAll();
                        _log.debug("Got all online pools back online, wakeup InitDB");
                    }
                }
            }
        }
        if (poolStatus.equals("down")) {
            this.taskTearDownByPoolName(poolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPoolRemoveFiles(PoolRemoveFilesMessage msg) {
        String poolName = msg.getPoolName();
        String[] filesList = msg.getFiles();
        if (filesList == null) {
            _log.debug("PoolRemoveFilesMessage - no file list defined");
            return;
        }
        int fileCount = 0;
        for (int j = 0; j < filesList.length; ++j) {
            PnfsId pnfsId;
            if (filesList[j] == null) {
                _log.debug("ReplicaManager: pnfsid[" + j + "]='null' in PoolRemoveFilesMessage");
                continue;
            }
            String stringPnfsId = filesList[j];
            try {
                pnfsId = new PnfsId(stringPnfsId);
            }
            catch (IllegalArgumentException ex) {
                _log.debug("Can not construct pnfsId for '" + stringPnfsId + "'");
                continue;
            }
            Object object = this._dbLock;
            synchronized (object) {
                if (!this._useDB) {
                    _log.info("DB not ready yet, skip DB update");
                    return;
                }
                this._dbrmv2.clearPools(pnfsId);
                ++fileCount;
            }
            _log.debug("ReplicaManager: PoolRemoveFiles(): pnfsId[" + j + "]=" + stringPnfsId + " cleared in DB");
        }
        if (fileCount > 0) {
            this._dbUpdated.wakeup();
        }
    }

    @Override
    public void taskFinished(DCacheCoreControllerV2.TaskObserver task) {
        _log.info("TaskFinished callback: task " + task);
        if (task.getType().equals("Reduction")) {
            DCacheCoreControllerV2.ReductionObserver rt = (DCacheCoreControllerV2.ReductionObserver)task;
            _log.debug("taskFinished() reduction " + rt.getPnfsId() + " at " + rt.getPool());
        }
        if (task.getType().equals("Replication")) {
            DCacheCoreControllerV2.MoverTask mt = (DCacheCoreControllerV2.MoverTask)task;
            _log.debug("taskFinished() replication " + mt.getPnfsId() + " from " + mt.getSrcPool() + " to   " + mt.getDstPool());
        }
    }

    static /* synthetic */ boolean access$2700(ReplicaManagerV2 x0) {
        return x0._hotRestart;
    }

    static /* synthetic */ void access$2800(ReplicaManagerV2 x0) {
        x0.cleanupDb();
    }

    static /* synthetic */ long access$2900(ReplicaManagerV2 x0) {
        return x0._delayPoolScan;
    }

    static /* synthetic */ void access$3000(ReplicaManagerV2 x0) throws Exception {
        x0.initDb();
    }

    static /* synthetic */ Set access$3100(ReplicaManagerV2 x0) {
        return x0._poolsToWait;
    }

    private class Replica {
        private PnfsId _id;
        private String _pool;

        public Replica(PnfsId id, String p) {
            this._id = id;
            this._pool = p;
        }

        public PnfsId getPnfsId() {
            return this._id;
        }

        public String getPool() {
            return this._pool;
        }

        public String toString() {
            return "{" + this._id + "," + this._pool + "}";
        }
    }

    private class dbUpdatePoolRunnable
    implements Runnable {
        String _poolName;

        public dbUpdatePoolRunnable(String poolName) {
            this._poolName = poolName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ReplicaManagerV2.this._dbLock;
            synchronized (object) {
                try {
                    ReplicaManagerV2.this.dbUpdatePool(this._poolName);
                }
                catch (Exception ee) {
                    _log.info(" poolStatusChanged - Problem fetching repository from " + this._poolName + " : " + ee);
                }
                finally {
                    ReplicaManagerV2.this._initDbActive = false;
                }
            }
            ReplicaManagerV2.this._dbUpdated.wakeup();
        }
    }

    private class WatchPools
    implements Runnable {
        Set<String> _knownPoolSet = new HashSet<String>();
        int cntNoChangeMsgLastTime;
        private long _period = 600000L;
        private long _expire = 43200000L;
        private boolean _restarted;
        private ReplicaDbV1 _db;

        public WatchPools() {
            this._db = ReplicaManagerV2.this.installReplicaDb();
        }

        public void setPeriod(long p) {
            this._period = p;
        }

        public long getPeriod() {
            return this._period;
        }

        public void setExcludedExpiration(long e) {
            this._expire = e;
        }

        public long getExcludedExpiration() {
            return this._expire;
        }

        @Override
        public void run() {
            _log.info("Starting pool watch dog thread");
            this._restarted = true;
            do {
                try {
                    if (!ReplicaManagerV2.this._runPoolWatchDog) break;
                    Thread.sleep(this._period);
                    this.runit();
                }
                catch (InterruptedException ex) {
                    _log.info("WatchPool Thread was interrupted");
                    break;
                }
                catch (Exception ex) {
                    _log.info("WatchPool Thread got exception, continue", (Throwable)ex);
                }
            } while (ReplicaManagerV2.this._runPoolWatchDog && !ReplicaManagerV2.this._stopThreads);
            _log.info("PoolWatch watch dog thread stopped");
            this._db.setHeartBeat("PoolWatchDog", "stopped");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runit() throws Exception {
            String hbMsg;
            boolean updated = false;
            if (this._restarted) {
                this._restarted = false;
                this._knownPoolSet = new HashSet<String>();
                Iterator<String> p = this._db.getPools();
                while (p.hasNext()) {
                    String pool = p.next();
                    if (!this._db.getPoolStatus(pool).equals("online")) continue;
                    this._knownPoolSet.add(pool);
                }
                ((ReplicaDbV1.DbIterator)p).close();
            }
            List<String> poolList = ReplicaManagerV2.this.getPoolListResilient();
            HashSet<String> newPoolSet = new HashSet<String>(poolList);
            HashSet<String> oldPoolSet = new HashSet<String>(this._knownPoolSet);
            for (String inext : poolList) {
                if (!oldPoolSet.contains(inext)) continue;
                oldPoolSet.remove(inext);
                newPoolSet.remove(inext);
            }
            ArrayList<String> arrived = new ArrayList<String>(newPoolSet);
            ArrayList<String> departed = new ArrayList<String>(oldPoolSet);
            if (arrived.size() == 0 && departed.size() == 0) {
                hbMsg = "no changes";
                if (++this.cntNoChangeMsgLastTime < 5) {
                    _log.info("WatchPool - no pools arrived or departed");
                } else if (this.cntNoChangeMsgLastTime == 5) {
                    _log.info("WatchPool - no pools arrived or departed, throttle future 'no change' messages ");
                }
            } else {
                hbMsg = "conf changed";
                this.cntNoChangeMsgLastTime = 0;
                if (arrived.size() == 0) {
                    _log.info("WatchPool - no new pools arrived");
                } else {
                    for (Object e : arrived) {
                        String poolName = (String)e;
                        _log.info("WatchPool - pool arrived '" + poolName + "'");
                        Object object = ReplicaManagerV2.this._dbLock;
                        synchronized (object) {
                            String poolStatusOld = this._db.getPoolStatus(poolName);
                            if (!(poolStatusOld.equals("drainoff") || poolStatusOld.equals("offline") || poolStatusOld.equals("offline-prepare") || poolStatusOld.equals("online"))) {
                                ReplicaManagerV2.this.updatePool((String)e, "online", true);
                                updated = true;
                            }
                        }
                    }
                }
                if (departed.size() == 0) {
                    _log.info("WatchPool - no pools departed");
                } else {
                    for (Object e : departed) {
                        _log.info("WatchPool - pool departed '" + e + "'");
                        Object object = ReplicaManagerV2.this._dbLock;
                        synchronized (object) {
                            ReplicaManagerV2.this.updatePool((String)e, "down", false);
                            updated = true;
                        }
                    }
                }
            }
            int releasedCount = 0;
            try {
                long now = System.currentTimeMillis();
                releasedCount = this._db.releaseExcluded(now - this.getExcludedExpiration());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (updated || releasedCount > 0) {
                ReplicaManagerV2.this._dbUpdated.wakeup();
            }
            this._knownPoolSet = new HashSet<String>(poolList);
            this._db.setHeartBeat("PoolWatchDog", hbMsg);
        }
    }

    private class InitDbRunnable
    implements Runnable {
        private long _delayStart;
        Thread myThread;
        boolean _waiting;

        public InitDbRunnable(long delay) {
            this._delayStart = delay;
        }

        public InitDbRunnable() {
            this(0L);
        }

        public void wakeupWaitInit() {
            if (this.myThread != null && this._waiting) {
                this.myThread.interrupt();
            } else {
                _log.info("DB thread does not sleep");
            }
        }

        public boolean isWaiting() {
            return this._waiting;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ReplicatePnfsIDRunnable
    implements Runnable {
        PnfsId _pnfsId;

        public ReplicatePnfsIDRunnable(PnfsId pnfsId) {
            this._pnfsId = pnfsId;
        }

        @Override
        public void run() {
            if (ReplicaManagerV2.this._adj == null) {
                _log.info("adjuster class not instantiated yet");
                return;
            }
            _log.info(this._pnfsId.toString() + " Starting replication");
            try {
                ReplicaManagerV2.this._adj.replicateAsync(this._pnfsId, true);
                _log.info(this._pnfsId.toString() + " async replication started");
            }
            catch (Exception ex) {
                _log.info(this._pnfsId.toString() + " got exception " + ex);
            }
        }
    }

    private class ReducePnfsIDRunnable
    implements Runnable {
        PnfsId _pnfsId;

        public ReducePnfsIDRunnable(PnfsId pnfsId) {
            this._pnfsId = pnfsId;
        }

        @Override
        public void run() {
            if (ReplicaManagerV2.this._adj == null) {
                _log.info("adjuster class not instantiated yet");
                return;
            }
            _log.info(this._pnfsId.toString() + " Starting replication");
            try {
                ReplicaManagerV2.this._adj.reduceAsync(this._pnfsId);
                _log.info(this._pnfsId.toString() + " async reduction started");
            }
            catch (Exception ex) {
                _log.info(this._pnfsId.toString() + " got exception " + ex);
            }
        }
    }

    private class Adjuster
    implements Runnable {
        private long waitDBUpdateTO = 600000L;
        private long waitReplicateTO = 43200000L;
        private long waitReduceTO = 43200000L;
        private int _min = 2;
        private int _max = 2;
        private int _maxWorkers = 4;
        private int _replicated;
        private int _removed;
        private String _status = "not updated yet";
        private Semaphore workerCount;
        private Semaphore workerCountRM;
        private int _cntThrottleMsgs;
        private boolean _throttleMsgs;
        private Set<String> _poolsWritable = new HashSet<String>();
        private Set<String> _poolsReadable = new HashSet<String>();
        private ReplicaDbV1 _db;

        public Adjuster(int min, int max) {
            this._min = min;
            this._max = max;
            this._db = ReplicaManagerV2.this.installReplicaDb();
        }

        public void setMin(int min) {
            this._min = min;
        }

        public void setMax(int max) {
            this._max = max;
        }

        public void setWaitDBUpdateTO(long delay) {
            this.waitDBUpdateTO = delay;
        }

        public long getWaitDBUpdateTO() {
            return this.waitDBUpdateTO;
        }

        public void setWaitReplicateTO(long delay) {
            this.waitReplicateTO = delay;
        }

        public void setWaitReduceTO(long delay) {
            this.waitReduceTO = delay;
        }

        public void setMaxWorkers(int n) {
            this._maxWorkers = n;
        }

        private boolean stopping() {
            return !ReplicaManagerV2.this._runAdjuster || ReplicaManagerV2.this._stopThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                this.workerCount = new Semaphore(this._maxWorkers);
                this.workerCountRM = new Semaphore(this._maxWorkers);
                _log.info("Adjuster Thread started");
                do {
                    if (ReplicaManagerV2.this._dbThread != null) {
                        _log.info("Adjuster - wait for Init DB to finish");
                        try {
                            ReplicaManagerV2.this._dbThread.join();
                            break block27;
                        }
                        catch (InterruptedException ex) {
                            _log.info("Adjuster - Waiting for connections to complete was interrupted, " + (ReplicaManagerV2.this._stopThreads ? "stop thread" : "continue"));
                            continue;
                        }
                        catch (Exception ex) {
                            _log.info("Adjuster - Got exception " + ex + "waiting for Init DB thread to complete, wait");
                            continue;
                        }
                    }
                    _log.warn("Adjuster - did not get DB thread (it can be an error), so sleep for 60 sec and retry");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ex) {
                        _log.info("Adjuster - Waiting for connections to complete was interrupted, " + (ReplicaManagerV2.this._stopThreads ? "stop thread" : "continue"));
                    }
                } while (!ReplicaManagerV2.this._stopThreads);
                return;
            }
            if (ReplicaManagerV2.this._watchDog == null) {
                _log.info("Starting pool watch dog for the first time - internal ERROR, class _watchDog not instantiated, startup aborted");
                this._db.setHeartBeat("Adjuster", "aborted");
                return;
            }
            if (ReplicaManagerV2.this._runPoolWatchDog) {
                _log.info("Trying to start pool watch dog - Watch dog already running");
            } else {
                _log.info("Adjuster - start pool watch dog");
                ReplicaManagerV2.this._runPoolWatchDog = true;
                ReplicaManagerV2.this._watchDog.start();
            }
            _log.info("=== Adjuster Ready, Start the loop ===");
            boolean haveMore = true;
            this._cntThrottleMsgs = 0;
            this._throttleMsgs = false;
            while (!this.stopping()) {
                try {
                    boolean dbUpdatedSnapshot;
                    DBUpdateMonitor dBUpdateMonitor = ReplicaManagerV2.this._dbUpdated;
                    synchronized (dBUpdateMonitor) {
                        dbUpdatedSnapshot = ReplicaManagerV2.this._dbUpdated.reset();
                        if (!dbUpdatedSnapshot && !haveMore) {
                            this._db.setHeartBeat("Adjuster", "waitDbUpdate");
                            _log.debug("Adjuster : wait for DB update");
                            ReplicaManagerV2.this._dbUpdated.wait(this.waitDBUpdateTO);
                        }
                    }
                    if (this.stopping()) {
                        _log.debug("Adjuster Thread - stopping");
                        break;
                    }
                    if (dbUpdatedSnapshot || haveMore) {
                        this._cntThrottleMsgs = 0;
                        this._throttleMsgs = false;
                    }
                    if (dbUpdatedSnapshot) {
                        _log.info("Adjuster : DB updated, scan DB and replicate or reduce");
                    } else if (haveMore) {
                        _log.info("Adjuster : adjustment incomplete, rescan DB");
                    } else {
                        String msg = "Adjuster : no DB updates for " + this.waitDBUpdateTO / 1000L + " sec, rescan DB";
                        if (++this._cntThrottleMsgs < 5) {
                            _log.info(msg);
                        } else if (this._cntThrottleMsgs == 5) {
                            _log.info(msg + "; throttle future 'no DB updates' messages ");
                            this._throttleMsgs = true;
                        }
                    }
                    haveMore = this.runAdjustment();
                    if (haveMore && !dbUpdatedSnapshot && !this._throttleMsgs) {
                        _log.info("Adjuster : pass finished, adjustment is  " + (haveMore ? "NOT complete" : "complete"));
                        continue;
                    }
                    _log.debug("Adjuster : pass finished haveMore=" + haveMore + " dbUpdatedSnapshot=" + dbUpdatedSnapshot + " _throttleMsgs=" + this._throttleMsgs);
                }
                catch (InterruptedException ee) {
                    _log.info("Adjuster : thread was interrupted");
                    if (!ReplicaManagerV2.this._stopThreads) continue;
                    break;
                }
            }
            this._db.setHeartBeat("Adjuster", "done");
            _log.debug("Adjuster : done");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean runAdjustment() {
            _log.debug("Adjuster - started");
            HashSet<String> poolsWritable = new HashSet<String>();
            Iterator<String> it = this._db.getPoolsWritable();
            while (it.hasNext()) {
                poolsWritable.add(it.next());
            }
            ((ReplicaDbV1.DbIterator)it).close();
            this._poolsWritable = poolsWritable;
            HashSet<String> poolsReadable = new HashSet<String>();
            it = this._db.getPoolsReadable();
            while (it.hasNext()) {
                poolsReadable.add(it.next());
            }
            ((ReplicaDbV1.DbIterator)it).close();
            this._poolsReadable = poolsReadable;
            boolean haveMore = false;
            try (Iterator<String> itDrain = this.scanDrainoff();){
                haveMore |= this.processReplication(itDrain, "drainoff");
            }
            if (!ReplicaManagerV2.this._stopThreads && !ReplicaManagerV2.this._dbUpdated.booleanValue()) {
                try (Iterator<String> itOffline = this.scanOffline();){
                    haveMore |= this.processReplication(itOffline, "offline-prepare");
                }
                if (!ReplicaManagerV2.this._stopThreads && !ReplicaManagerV2.this._dbUpdated.booleanValue()) {
                    int min = this._min;
                    try (Iterator<Object[]> itDeficient = this.scanDeficient(min);){
                        haveMore |= this.processReplicateDeficient(itDeficient, min);
                    }
                    if (!ReplicaManagerV2.this._stopThreads && !ReplicaManagerV2.this._dbUpdated.booleanValue()) {
                        int max = this._max;
                        try (Iterator<Object[]> itRedundant = this.scanRedundant(max);){
                            haveMore |= this.processReduceRedundant(itRedundant, max);
                        }
                        if (ReplicaManagerV2.this._stopThreads || !ReplicaManagerV2.this._dbUpdated.booleanValue()) {
                            // empty if block
                        }
                    }
                }
            }
            return haveMore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Iterator<String> scanDrainoff() {
            Iterator<String> it;
            _log.debug("Adjuster - scan drainoff");
            this._setStatus("Adjuster - scan drainoff");
            this._db.setHeartBeat("Adjuster", "scan drainOff");
            Object object = ReplicaManagerV2.this._dbLock;
            synchronized (object) {
                it = this._db.getInDrainoffOnly();
            }
            return it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Iterator<String> scanOffline() {
            Iterator<String> it;
            _log.debug("Adjuster - scan offline-prepare");
            this._setStatus("Adjuster - scan offline-prepare");
            this._db.setHeartBeat("Adjuster", "scan offline-prepare");
            Object object = ReplicaManagerV2.this._dbLock;
            synchronized (object) {
                it = this._db.getInOfflineOnly();
            }
            return it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Iterator<Object[]> scanDeficient(int min) {
            Iterator<Object[]> it;
            _log.debug("Adjuster - scan deficient");
            this._setStatus("Adjuster - scan deficient");
            this._db.setHeartBeat("Adjuster", "scan deficient");
            Object object = ReplicaManagerV2.this._dbLock;
            synchronized (object) {
                it = this._db.getDeficient(min);
            }
            return it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Iterator<Object[]> scanRedundant(int max) {
            Iterator<Object[]> it;
            _log.debug("Adjuster - scan redundant");
            this._setStatus("Adjuster - scan redundant");
            this._db.setHeartBeat("Adjuster", "scan redundant");
            Object object = ReplicaManagerV2.this._dbLock;
            synchronized (object) {
                it = this._db.getRedundant(max);
            }
            return it;
        }

        protected boolean processReplication(Iterator<String> it, String detail) {
            boolean updated = false;
            boolean haveMore = false;
            while (!ReplicaManagerV2.this._stopThreads && !(updated = ReplicaManagerV2.this._dbUpdated.booleanValue()) && it.hasNext()) {
                PnfsId pnfsId = new PnfsId(it.next());
                if (ReplicaManagerV2.this._dbUpdated.hasPnfsId(pnfsId)) {
                    haveMore = true;
                    continue;
                }
                this.replicateAsync(pnfsId, false);
            }
            if (ReplicaManagerV2.this._stopThreads) {
                _log.debug("processReplication() - stopThreads detected, stopping");
            } else if (updated) {
                _log.debug("processReplication() - DB update detected,  break processing of " + detail + " pools cycle");
            }
            return it.hasNext() || haveMore;
        }

        protected boolean processReplicateDeficient(Iterator<Object[]> it, int min) {
            int records = 0;
            int corrupted = 0;
            int belowMin = 0;
            boolean updated = false;
            boolean haveMore = false;
            while (!ReplicaManagerV2.this._stopThreads && !(updated = ReplicaManagerV2.this._dbUpdated.booleanValue()) && it.hasNext()) {
                ++records;
                Object[] rec = it.next();
                if (rec.length < 2) {
                    ++corrupted;
                    continue;
                }
                PnfsId pnfsId = new PnfsId((String)rec[0]);
                int count = (Integer)rec[1];
                int delta = min - count;
                if (delta <= 0) {
                    ++belowMin;
                    continue;
                }
                if (delta > 1) {
                    haveMore = true;
                }
                if (ReplicaManagerV2.this._dbUpdated.hasPnfsId(pnfsId)) {
                    haveMore = true;
                    continue;
                }
                this.replicateAsync(pnfsId, false);
            }
            if (corrupted > 0) {
                _log.warn("Error in processReplicateDeficient(): DB.getDeficient() record length <2 in " + corrupted + "/" + records + " records");
            }
            if (belowMin > 0) {
                _log.warn("Error in processReplicateDeficient(): DB.getDeficient() replica count greater or equal specified min=" + min + " in " + belowMin + "/" + records + " records");
            }
            if (ReplicaManagerV2.this._stopThreads) {
                _log.debug("processReplicateDeficient() - stopThreads detected, stopping");
            } else if (updated) {
                _log.debug("processReplicateDeficient() - DB update detected, break replication pass");
            }
            return it.hasNext() || haveMore;
        }

        protected boolean processReduceRedundant(Iterator<Object[]> it, int max) {
            int records = 0;
            int corrupted = 0;
            int aboveMax = 0;
            boolean updated = false;
            boolean haveMore = false;
            while (!ReplicaManagerV2.this._stopThreads && !(updated = ReplicaManagerV2.this._dbUpdated.booleanValue()) && it.hasNext()) {
                ++records;
                Object[] rec = it.next();
                if (rec.length < 2) {
                    ++corrupted;
                    continue;
                }
                PnfsId pnfsId = new PnfsId((String)rec[0]);
                int count = (Integer)rec[1];
                int delta = count - max;
                if (delta <= 0) {
                    ++aboveMax;
                    continue;
                }
                if (delta > 1) {
                    haveMore = true;
                }
                if (ReplicaManagerV2.this._dbUpdated.hasPnfsId(pnfsId)) {
                    haveMore = true;
                    continue;
                }
                this.reduceAsync(pnfsId);
            }
            if (corrupted > 0) {
                _log.warn("Error in processReplicateDeficient(): DB.getRedundant() record length <2 in " + corrupted + "/" + records + " records");
            }
            if (aboveMax > 0) {
                _log.warn("Error in processReplicateDeficient(): DB.getRedundant() replica count greater or equal specified max=" + max + " in " + aboveMax + "/" + records + " records");
            }
            if (ReplicaManagerV2.this._stopThreads) {
                _log.debug("processReduceRedundant() - stopThreads detected, stopping");
            } else if (updated) {
                _log.debug("processReduceRedundant() - DB update detected, break reduction pass");
            }
            return it.hasNext() || haveMore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void excludePnfsId(PnfsId pnfsId, String errcode, String errmsg) {
            Object object = ReplicaManagerV2.this._dbLock;
            synchronized (object) {
                long timeStamp = System.currentTimeMillis();
                this._db.addExcluded(pnfsId, timeStamp, errcode, errmsg);
            }
            _log.info("pnfsId=" + pnfsId + " excluded from replication. ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replicateAsync(PnfsId pnfsId, boolean extended) {
            Replicator r;
            boolean noWorker = true;
            int cnt = 0;
            do {
                try {
                    _log.debug("replicateAsync - get worker");
                    cnt = this.workerCount.acquire();
                    _log.debug("replicateAsync - got worker OK");
                    noWorker = false;
                }
                catch (InterruptedException ex) {
                    if (ReplicaManagerV2.this._stopThreads) {
                        _log.info("replicateAsync: waiting for awailable worker thread interrupted, stop thread");
                        return;
                    }
                    _log.info("replicateAsync: waiting for awailable worker thread interrupted, retry");
                }
            } while (noWorker);
            Replicator replicator = r = new Replicator(pnfsId, ReplicaManagerV2.this._repId, cnt, extended);
            synchronized (replicator) {
                ReplicaManagerV2.this.getNucleus().newThread((Runnable)r, "RepMgr-Replicator-" + ReplicaManagerV2.this._repId).start();
                ReplicaManagerV2.this._repId++;
                try {
                    r.wait();
                }
                catch (InterruptedException ex1) {
                    _log.info("replicateAsync: Waiting for release from replicator thread to was interrupted, " + (ReplicaManagerV2.this._stopThreads ? "stop thread" : "continue"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reduceAsync(PnfsId pnfsId) {
            Reducer r;
            boolean noWorker = true;
            int cnt = 0;
            do {
                try {
                    _log.debug("reduceAsync - get worker");
                    cnt = this.workerCountRM.acquire();
                    _log.debug("reduceAsync - got worker - OK");
                    noWorker = false;
                }
                catch (InterruptedException ex) {
                    if (ReplicaManagerV2.this._stopThreads) {
                        _log.info("reduceAsync: waiting for awailable worker thread interrupted, stop thread");
                        return;
                    }
                    _log.info("reduceAsync: waiting for awailable worker thread interrupted, retry");
                }
            } while (noWorker);
            Reducer reducer = r = new Reducer(pnfsId, ReplicaManagerV2.this._redId, cnt);
            synchronized (reducer) {
                ReplicaManagerV2.this.getNucleus().newThread((Runnable)r, "RepMgr-Reducer-" + ReplicaManagerV2.this._redId).start();
                ReplicaManagerV2.this._redId++;
                try {
                    r.wait();
                }
                catch (InterruptedException ex1) {
                    _log.info("reduceAsync: Waiting for release from reducer thread was interrupted, " + (ReplicaManagerV2.this._stopThreads ? "stop thread" : "continue"));
                }
            }
        }

        private void _setStatus(String status) {
            this._status = status;
        }

        private class Reducer
        implements Runnable {
            private PnfsId _pnfsId;
            private int _Id;
            int _wCnt;

            Reducer(PnfsId pnfsId, int Id, int cnt) {
                this._pnfsId = pnfsId;
                this._Id = Id;
                this._wCnt = cnt;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ReplicaManagerV2.this._stopThreads) {
                        _log.info("Reducer ID=" + this._Id + ", pnfsId=" + this._pnfsId + " can not start - " + "shutdown detected");
                    } else {
                        _log.info("Reducer ID=" + this._Id + ", pnfsId=" + this._pnfsId + " starting" + ", now " + (Adjuster.this._maxWorkers - this._wCnt) + "/" + Adjuster.this._maxWorkers + " workers are active");
                        this.reduce(this._pnfsId);
                    }
                }
                catch (InterruptedException ex) {
                    _log.info("Reducer for pnfsId=" + this._pnfsId + " got exception " + ex);
                }
                finally {
                    Reducer reducer = this;
                    synchronized (reducer) {
                        this.notifyAll();
                    }
                    this._wCnt = Adjuster.this.workerCountRM.release();
                    _log.info("Reducer ID=" + this._Id + ", pnfsId=" + this._pnfsId + " finished" + ", now " + (Adjuster.this._maxWorkers - this._wCnt) + "/" + Adjuster.this._maxWorkers + " workers are active");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void reduce(PnfsId pnfsId) throws InterruptedException {
                DCacheCoreControllerV2.ReductionObserver observer;
                Adjuster.this._setStatus("Adjuster - reducing " + pnfsId);
                long start = System.currentTimeMillis();
                long timeToStop = start + Adjuster.this.waitReduceTO;
                try {
                    observer = (DCacheCoreControllerV2.ReductionObserver)ReplicaManagerV2.this.removeCopy(pnfsId, Adjuster.this._poolsWritable);
                }
                catch (Exception ee) {
                    _log.info("reduce(" + pnfsId + ") reported : " + ee);
                    return;
                }
                String poolName = observer.getPool();
                _log.info(pnfsId.toString() + " Reducing");
                Object object = ReplicaManagerV2.this._dbLock;
                synchronized (object) {
                    Adjuster.this._db.addTransaction(pnfsId, start, -1);
                }
                object = this;
                synchronized (object) {
                    this.notifyAll();
                }
                object = observer;
                synchronized (object) {
                    long timerToWait = timeToStop - start;
                    long currentTime = System.currentTimeMillis();
                    while (timerToWait > 0L && !observer.isDone()) {
                        observer.wait(timerToWait);
                        currentTime = System.currentTimeMillis();
                        timerToWait = timeToStop - currentTime;
                    }
                    if (!observer.isDone()) {
                        observer.setErrorCode(-1, "reduce pnfsID=" + pnfsId + ", Timed out after " + (currentTime - start) + " ms");
                    }
                }
                long stop = System.currentTimeMillis();
                int oErr = observer.getErrorCode();
                String eMsg = observer.getErrorMessage();
                long timeStamp = System.currentTimeMillis();
                if (oErr == 0) {
                    Adjuster.this._removed++;
                    _log.info(pnfsId.toString() + " reduction done after " + (stop - start) + " ms, result " + observer);
                    Object object2 = ReplicaManagerV2.this._dbLock;
                    synchronized (object2) {
                        Adjuster.this._db.removePool(pnfsId, poolName);
                        Adjuster.this._db.removeTransaction(pnfsId);
                    }
                    _log.debug("reduce(" + pnfsId + ") : cleanup action record and remove pnfsid from the pool=" + poolName + "- DB updated");
                } else {
                    _log.info(pnfsId.toString() + " reduction ERROR, result=[" + observer + "]");
                    Object object3 = ReplicaManagerV2.this._dbLock;
                    synchronized (object3) {
                        Adjuster.this._db.removeTransaction(pnfsId);
                        Adjuster.this._db.addExcluded(pnfsId, timeStamp, String.valueOf(oErr), eMsg);
                    }
                    _log.info("pnfsId=" + pnfsId + " excluded from replication. " + "(err=" + oErr + ", " + eMsg + ")");
                }
            }
        }

        private class Replicator
        implements Runnable {
            private PnfsId _pnfsId;
            private int _Id;
            int _wCnt;
            private boolean _extended;

            Replicator(PnfsId pnfsId, int Id, int cnt, boolean extended) {
                this._pnfsId = pnfsId;
                this._Id = Id;
                this._wCnt = cnt;
                this._extended = extended;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ReplicaManagerV2.this._stopThreads) {
                        _log.info("Replicator ID=" + this._Id + ", pnfsId=" + this._pnfsId + " can not start - shutdown detected");
                    } else {
                        _log.info("Replicator ID=" + this._Id + ", pnfsId=" + this._pnfsId + " starting, now " + (Adjuster.this._maxWorkers - this._wCnt) + "/" + Adjuster.this._maxWorkers + " workers are active");
                        this.replicate(this._pnfsId);
                    }
                }
                catch (InterruptedException ex) {
                    _log.info("Replicator for pnfsId=" + this._pnfsId + " got exception " + ex);
                }
                finally {
                    Replicator replicator = this;
                    synchronized (replicator) {
                        this.notifyAll();
                    }
                    this._wCnt = Adjuster.this.workerCount.release();
                    _log.info("Replicator ID=" + this._Id + ", pnfsId=" + this._pnfsId + " finished, now " + (Adjuster.this._maxWorkers - this._wCnt) + "/" + Adjuster.this._maxWorkers + " workers are active");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void replicate(PnfsId pnfsId) throws InterruptedException {
                String oErrMsg;
                DCacheCoreControllerV2.MoverTask observer;
                Adjuster.this._setStatus("Adjuster - Replicating " + pnfsId);
                long start = System.currentTimeMillis();
                long timeToStop = start + Adjuster.this.waitReplicateTO;
                try {
                    observer = this._extended ? ReplicaManagerV2.this.replicatePnfsId(pnfsId, Adjuster.this._poolsReadable, Adjuster.this._poolsWritable) : ReplicaManagerV2.this.replicatePnfsId(pnfsId, Adjuster.this._poolsWritable, Adjuster.this._poolsWritable);
                }
                catch (MissingResourceException mrex) {
                    String exMsg = mrex.getMessage();
                    String exClass = mrex.getClassName();
                    String exKey = mrex.getKey();
                    _log.info("replicate(" + pnfsId + ") reported : " + mrex);
                    if (exMsg.startsWith("Pnfs File not found :") || exMsg.equals("Pnfs lookup failed") || exMsg.startsWith("Not a valid PnfsId")) {
                        Adjuster.this.excludePnfsId(pnfsId, "", exMsg);
                    } else {
                        _log.debug("msg='" + exMsg + "'  class='" + exClass + "' key='" + exKey + "' ");
                    }
                    return;
                }
                catch (IllegalArgumentException iaex) {
                    boolean sigFound;
                    _log.info("replicate(" + pnfsId + ") reported : " + iaex);
                    String exMsg = iaex.getMessage();
                    boolean bl = sigFound = exMsg.startsWith("Select source pool error : ") || exMsg.startsWith("Select destination pool error : ");
                    if (sigFound) {
                        Adjuster.this.excludePnfsId(pnfsId, "", exMsg);
                    }
                    if (exMsg.startsWith("replicatePnfsId, argument")) {
                        _log.info("There are not enough pools to get replica from or to put it to; try operation later");
                        sigFound = true;
                    } else if (exMsg.startsWith("Try again :")) {
                        _log.info(exMsg);
                        sigFound = true;
                    }
                    _log.debug("msg='" + exMsg + "' " + (sigFound ? "signature OK" : "signature not found"));
                    return;
                }
                catch (Exception ee) {
                    _log.warn("replicate(" + pnfsId + ") reported : " + ee + ", excluding", (Throwable)ee);
                    Adjuster.this.excludePnfsId(pnfsId, "", ee.getMessage());
                    return;
                }
                String poolName = observer.getDstPool();
                _log.info(pnfsId.toString() + " Replicating");
                Object sigFound = ReplicaManagerV2.this._dbLock;
                synchronized (sigFound) {
                    Adjuster.this._db.addTransaction(pnfsId, start, 1);
                }
                sigFound = this;
                synchronized (sigFound) {
                    this.notifyAll();
                }
                sigFound = observer;
                synchronized (sigFound) {
                    long timerToWait = timeToStop - start;
                    long currentTime = System.currentTimeMillis();
                    while (timerToWait > 0L && !observer.isDone()) {
                        observer.wait(timerToWait);
                        currentTime = System.currentTimeMillis();
                        timerToWait = timeToStop - currentTime;
                    }
                    if (!observer.isDone()) {
                        observer.setErrorCode(-1, "replicate pnfsID=" + pnfsId + ", Timed out after " + (currentTime - start) + " ms");
                    }
                }
                long stop = System.currentTimeMillis();
                boolean completedOK = false;
                boolean exclude = false;
                int oErr = observer.getErrorCode();
                String excludeReason = oErrMsg = observer.getErrorMessage();
                long timeStamp = System.currentTimeMillis();
                if (oErr == 0) {
                    completedOK = true;
                    Adjuster.this._replicated++;
                    _log.info(pnfsId.toString() + " replication done after " + (stop - start) + " ms, result " + observer);
                    _log.debug("replicate(" + pnfsId + ") : cleanup action record and add pnfsid to the pool=" + poolName + "- updating DB");
                } else {
                    _log.info(pnfsId.toString() + " replication ERROR=" + oErr + ", timer=" + (stop - start) + " ms, error " + oErrMsg);
                    if (oErr == 102) {
                        exclude = true;
                    } else if (oErr <= 0 && oErr < -100) {
                        exclude = true;
                    }
                }
                Object object = ReplicaManagerV2.this._dbLock;
                synchronized (object) {
                    if (completedOK) {
                        Adjuster.this._db.addPool(pnfsId, poolName);
                    }
                    Adjuster.this._db.removeTransaction(pnfsId);
                    if (exclude) {
                        Adjuster.this._db.addExcluded(pnfsId, timeStamp, String.valueOf(oErr), excludeReason);
                    }
                }
                if (exclude) {
                    _log.info("pnfsId=" + pnfsId + " is excluded from replication. (err=" + oErr + ", " + excludeReason + ")");
                }
            }
        }
    }

    private class DBUpdateMonitor {
        private boolean _bool = false;
        private Collection<String> _updatedPnfsId = new LinkedHashSet<String>();
        static final int _maxPnfsIdHashSize = 16384;

        DBUpdateMonitor() {
        }

        public synchronized boolean reset() {
            boolean ret = this._bool || this._updatedPnfsId.size() > 0;
            this._bool = false;
            this._updatedPnfsId.clear();
            return ret;
        }

        public synchronized boolean booleanValue() {
            return this._bool;
        }

        public synchronized void wakeup() {
            this._bool = true;
            try {
                this.notifyAll();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }

        public synchronized void sendNotify() {
            try {
                this.notifyAll();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }

        public synchronized void wakeupByPnfsId() {
            if (this._updatedPnfsId.size() > 16384) {
                this.wakeup();
            } else {
                this.sendNotify();
            }
        }

        public synchronized void addPnfsId(PnfsId p) {
            this._updatedPnfsId.add(p.toString());
        }

        public synchronized boolean hasPnfsId(PnfsId p) {
            return this._updatedPnfsId.contains(p.toString());
        }
    }

    public class ResilientPools {
        private List<String> _resPoolsList;
        private String _resilientPoolGroupName = "ResilientPools";

        private List<String> getResilientPools() {
            return this._resPoolsList;
        }

        public ResilientPools(Args args) {
            String group = args.getOpt("resilientGroupName");
            if (group != null && !group.equals("")) {
                this._resilientPoolGroupName = group;
                _log.warn("resilientGroupName=" + group + "\n");
            } else {
                _log.warn("Argument 'resilientGroupName' is not defined, use default settings: _resilientPoolGroupName={}", (Object)this._resilientPoolGroupName);
            }
        }

        public List<String> init() throws Exception {
            _log.debug("Asking for Resilient Pools Group List, resilientPoolGroupName=" + this._resilientPoolGroupName);
            try {
                this._resPoolsList = ReplicaManagerV2.this.getPoolGroup(this._resilientPoolGroupName);
            }
            catch (Exception ex) {
                _log.warn("ERROR: ##### Can not get Resilient Pools Group " + this._resilientPoolGroupName + " ####");
                throw ex;
            }
            if (this._resPoolsList == null) {
                _log.warn("ERROR: ##### Can not get Resilient Pools Group " + this._resilientPoolGroupName + " ####");
                throw new Exception("Can not get Group " + this._resilientPoolGroupName);
            }
            _log.info("Got " + this._resPoolsList.size() + " pools listed in the group " + this._resilientPoolGroupName);
            if (this._resPoolsList.size() == 0) {
                _log.warn("ERROR: ##### Group " + this._resilientPoolGroupName + " is empty ####");
                throw new Exception("Group " + this._resilientPoolGroupName + " is empty");
            }
            _log.info("ResilientPools pools: " + this._resPoolsList);
            return this._resPoolsList;
        }
    }
}

