/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.replicaManager;

import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.repository.CacheRepositoryEntryInfo;
import diskCacheV111.util.IteratorCookie;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.SpreadAndWait;
import diskCacheV111.util.UptimeParser;
import diskCacheV111.vehicles.CostModulePoolInfoTable;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsAddCacheLocationMessage;
import diskCacheV111.vehicles.PnfsClearCacheLocationMessage;
import diskCacheV111.vehicles.PnfsGetCacheLocationsMessage;
import diskCacheV111.vehicles.PnfsGetStorageInfoMessage;
import diskCacheV111.vehicles.PnfsModifyCacheLocationMessage;
import diskCacheV111.vehicles.Pool2PoolTransferMsg;
import diskCacheV111.vehicles.PoolCheckFileMessage;
import diskCacheV111.vehicles.PoolCheckMessage;
import diskCacheV111.vehicles.PoolManagerGetPoolListMessage;
import diskCacheV111.vehicles.PoolQueryRepositoryMsg;
import diskCacheV111.vehicles.PoolRemoveFilesMessage;
import diskCacheV111.vehicles.PoolStatusChangedMessage;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.UOID;
import dmg.util.Args;
import dmg.util.CommandSyntaxException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DCacheCoreControllerV2
extends CellAdapter {
    private static final String _svnId = "$Id$";
    private static final Logger _log = LoggerFactory.getLogger(DCacheCoreControllerV2.class);
    private String _cellName;
    private Args _args;
    private CellNucleus _nucleus;
    private static final long _timeout = 120000L;
    private static final long _TO_GetPoolRepository = 120000L;
    private static final long _TO_GetPoolTags = 120000L;
    private static final long _TO_MessageQueueUpdate = 15000L;
    private static final long _TO_GetStorageInfo = 120000L;
    private static final long _TO_GetCacheLocationList = 120000L;
    private static final long _TO_GetPoolGroup = 120000L;
    private static final long _TO_GetPoolList = 120000L;
    private static final long _TO_GetFreeSpace = 120000L;
    private static final long _TO_SendObject = 120000L;
    private boolean _dcccDebug;
    private final BlockingQueue<CellMessage> _msgFifo;
    private LinkedList<PnfsAddCacheLocationMessage> _cachedPnfsAddCacheLocationMessage = new LinkedList();
    private static CostModulePoolInfoTable _costTable;
    private static final Object _costTableLock;
    protected final Map<String, String> _hostMap = new TreeMap<String, String>();
    protected boolean _enableSameHostReplica;
    public static final String hh_task_ls = " # list pending tasks";
    public static final String hh_task_remove = "<task_id> # remove task";
    private long __taskId = 10000L;
    private final HashMap<Long, TaskObserver> _taskHash = new LinkedHashMap<Long, TaskObserver>();
    private final HashMap<UOID, MoverTask> _messageHash = new HashMap();
    private final HashMap<String, ReductionObserver> _modificationHash = new HashMap();
    private P2pObserver _p2p = new P2pObserver();
    private Random _random = new Random(System.currentTimeMillis());
    protected static final String selectSourcePoolError = "Select source pool error : ";
    protected static final String selectDestinationPoolError = "Select destination pool error : ";

    public void setEnableSameHostReplica(boolean d) {
        this._enableSameHostReplica = d;
    }

    public boolean getEnableSameHostReplica() {
        return this._enableSameHostReplica;
    }

    public void setDebug(boolean d) {
        this._dcccDebug = d;
    }

    public boolean getDebug() {
        return this._dcccDebug;
    }

    public DCacheCoreControllerV2(String cellName, String args) {
        super(cellName, args, false);
        this._cellName = cellName;
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        this._msgFifo = new LinkedBlockingQueue<CellMessage>();
        this.useInterpreter(true);
        new MessageTimeoutThread();
        new MessageProcessThread();
        this._nucleus.export();
        _log.info("Starting");
    }

    protected abstract List<String> getPoolListResilient() throws Exception;

    public Serializable commandArrived(String str, CommandSyntaxException cse) {
        if (str.startsWith("Removed ")) {
            _log.debug("commandArrived (ignored):  cse=[" + cse + "], str = [" + str + "]");
            return null;
        }
        if (str.startsWith("Failed to remove ") || str.startsWith("Syntax Error") || str.startsWith("(3) CacheException") || str.startsWith("diskCacheV111.")) {
            _log.warn("commandArrived (ignored): cse=[" + cse + "], str = [" + str + "]");
            return null;
        }
        _log.debug("commandArrived - call super cse=[" + cse + "], str = [" + str + "]");
        return super.commandArrived(str, cse);
    }

    public String getSvnId() {
        return _svnId;
    }

    public void getInfo(PrintWriter pw) {
        pw.println("       Version : " + this.getSvnId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_task_ls(Args args) {
        StringBuilder sb = new StringBuilder();
        HashMap<Long, TaskObserver> hashMap = this._taskHash;
        synchronized (hashMap) {
            for (TaskObserver o : this._taskHash.values()) {
                sb.append(((Object)o).toString()).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_task_remove_$_1(Args args) {
        StringBuilder sb = new StringBuilder();
        String s = args.argv(0);
        if (s.equals("*")) {
            HashSet<TaskObserver> allTasks;
            sb.append("Removed:\n");
            HashMap<Long, TaskObserver> hashMap = this._taskHash;
            synchronized (hashMap) {
                allTasks = new HashSet<TaskObserver>(this._taskHash.values());
            }
            for (TaskObserver task : allTasks) {
                if (task == null) continue;
                task.setErrorCode(-2, "Removed by command");
                sb.append(task.toString()).append("\n");
            }
        } else {
            HashSet<TaskObserver> allTasks;
            boolean poolFound = false;
            HashMap<Long, TaskObserver> task = this._taskHash;
            synchronized (task) {
                allTasks = new HashSet<TaskObserver>(this._taskHash.values());
            }
            for (TaskObserver task2 : allTasks) {
                if (task2 == null || task2.isDone() || (!task2.getType().equals("Reduction") || !((ReductionObserver)task2).getPool().equals(s)) && (!task2.getType().equals("Replication") || !((MoverTask)task2).getSrcPool().equals(s) && !((MoverTask)task2).getDstPool().equals(s))) continue;
                poolFound = true;
                task2.setErrorCode(-2, "Removed by command");
                sb.append(task2.toString()).append("\n");
            }
            if (!poolFound) {
                TaskObserver task2;
                Long id = Long.parseLong(args.argv(0));
                HashMap<Long, TaskObserver> hashMap = this._taskHash;
                synchronized (hashMap) {
                    task2 = this._taskHash.get(id);
                }
                if (task2 == null) {
                    sb.append("task ").append(id).append(" not found");
                } else {
                    task2.setErrorCode(-2, "Removed by command");
                    sb.append(task2.toString());
                }
            }
        }
        return sb.toString();
    }

    private synchronized long __nextTaskId() {
        return this.__taskId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void taskTearDownByPoolName(String poolName) {
        HashSet<TaskObserver> allTasks;
        HashMap<Long, TaskObserver> hashMap = this._taskHash;
        synchronized (hashMap) {
            allTasks = new HashSet<TaskObserver>(this._taskHash.values());
        }
        for (TaskObserver task : allTasks) {
            if (task == null || task.isDone() || (!task.getType().equals("Reduction") || !((ReductionObserver)task).getPool().equals(poolName)) && (!task.getType().equals("Replication") || !((MoverTask)task).getSrcPool().equals(poolName) && !((MoverTask)task).getDstPool().equals(poolName))) continue;
            task.setErrorCode(-3, "Task tear down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskObserver movePnfsId(PnfsId pnfsId, String source, String destination) throws Exception {
        FileAttributes fileAttributes = this.getFileAttributes(pnfsId);
        HashSet<String> hash = new HashSet<String>(this.getCacheLocationList(pnfsId, false));
        if (!hash.contains(source)) {
            throw new IllegalStateException("PnfsId " + pnfsId + " not found in " + source);
        }
        if (hash.contains(destination)) {
            throw new IllegalStateException("PnfsId " + pnfsId + " already found in " + destination);
        }
        Pool2PoolTransferMsg req = new Pool2PoolTransferMsg(source, destination, fileAttributes);
        req.setDestinationFileStatus(1);
        CellMessage msg = new CellMessage(new CellPath(destination), (Serializable)req);
        MoverTask task = new MoverTask(pnfsId, source, destination);
        HashMap<UOID, MoverTask> hashMap = this._messageHash;
        synchronized (hashMap) {
            this.sendMessage(msg);
            this._messageHash.put(msg.getUOID(), task);
        }
        return task;
    }

    protected TaskObserver removeCopy(PnfsId pnfsId, Set<String> writablePools) throws Exception {
        List<String> sourcePoolList = this.getCacheLocationList(pnfsId, false);
        sourcePoolList.retainAll(writablePools);
        if (sourcePoolList.size() == 0) {
            throw new IllegalStateException("no deletable replica found for pnfsId=" + pnfsId);
        }
        List<String> confirmedSourcePoolList = this.confirmCacheLocationList(pnfsId, sourcePoolList);
        if (confirmedSourcePoolList.size() <= 0) {
            _log.debug("pnfsid = " + pnfsId + ", writable pools=" + writablePools);
            _log.debug("pnfsid = " + pnfsId + ", confirmed pools=" + confirmedSourcePoolList);
            throw new IllegalArgumentException("no deletable 'online' replica found for pnfsId=" + pnfsId);
        }
        if (confirmedSourcePoolList.size() == 1) {
            throw new IllegalArgumentException("Can't reduce to 0 writable ('online') copies, pnfsId=" + pnfsId + " confirmed pool=" + confirmedSourcePoolList);
        }
        String source = confirmedSourcePoolList.get(this._random.nextInt(confirmedSourcePoolList.size()));
        return new ReductionObserver(pnfsId, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String bestDestPool(List<Object> pools, long fileSize, Set<String> srcHosts) throws Exception {
        double bestCost = 1.0;
        PoolCostInfo bestCostInfo = null;
        boolean spaceFound = false;
        boolean qFound = false;
        Object object = _costTableLock;
        synchronized (object) {
            long removable;
            long free;
            long precious;
            long total;
            this.getCostTable(this);
            if (_costTable == null) {
                throw new IllegalArgumentException("CostTable is not defined (null pointer)");
            }
            for (Object pool : pools) {
                try {
                    PoolCostInfo costInfo;
                    String poolName = pool.toString();
                    if (!this._enableSameHostReplica && srcHosts != null) {
                        Map<String, String> map = this._hostMap;
                        synchronized (map) {
                            String host = this._hostMap.get(poolName);
                            if (host != null && !host.equals("") && srcHosts.contains(host)) {
                                _log.debug("best pool: skip destination pool " + poolName + ", destination host " + host + " is on the source host list " + srcHosts);
                                continue;
                            }
                        }
                    }
                    if ((costInfo = _costTable.getPoolCostInfoByName(poolName)) == null) {
                        _log.info("bestPool : can not find costInfo for pool " + poolName + " in _costTable");
                        continue;
                    }
                    total = costInfo.getSpaceInfo().getTotalSpace();
                    precious = costInfo.getSpaceInfo().getPreciousSpace();
                    free = costInfo.getSpaceInfo().getFreeSpace();
                    removable = costInfo.getSpaceInfo().getRemovableSpace();
                    long available = free + removable;
                    long used = total - available;
                    PoolCostInfo.PoolQueueInfo cq = costInfo.getP2pClientQueue();
                    int qmax = cq.getMaxActive();
                    qmax = qmax == 0 ? 1 : qmax;
                    qmax = qmax < 0 ? 0 : qmax;
                    int qlength = this._p2p.getClientCount(poolName);
                    double itCost = (double)used / (double)total;
                    if (free < fileSize) continue;
                    spaceFound = true;
                    if (qlength >= qmax) continue;
                    qFound = true;
                    if (!(itCost < bestCost)) continue;
                    bestCost = itCost;
                    bestCostInfo = costInfo;
                }
                catch (Exception e) {
                    _log.warn("bestPool : ignore exception " + e);
                    if (!this._dcccDebug) continue;
                    _log.debug("Stack dump for ignored exception :");
                    e.printStackTrace();
                }
            }
            if (bestCostInfo == null) {
                throw new IllegalArgumentException("Try again : Can not find good destination pool - no space is available or p2p client queue is full.  File size=" + fileSize + ", spaceFound=" + spaceFound + ", queueAvailable=" + qFound);
            }
            total = bestCostInfo.getSpaceInfo().getTotalSpace();
            precious = bestCostInfo.getSpaceInfo().getPreciousSpace() + fileSize;
            free = bestCostInfo.getSpaceInfo().getFreeSpace() - fileSize;
            removable = bestCostInfo.getSpaceInfo().getRemovableSpace();
            bestCostInfo.setSpaceUsage(total, free, precious, removable);
        }
        String bestPool = bestCostInfo.getPoolName();
        _log.debug("best pool: " + bestPool + "; cost = " + bestCost);
        return bestPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MoverTask replicatePnfsId(PnfsId pnfsId, Set<String> readablePools, Set<String> writablePools) throws Exception {
        if (readablePools.size() == 0) {
            throw new IllegalArgumentException("replicatePnfsId, argument readablePools.size() == 0  for pnfsId=" + pnfsId);
        }
        if (writablePools.size() == 0) {
            throw new IllegalArgumentException("replicatePnfsId, argument writablePools.size() == 0  for pnfsId=" + pnfsId);
        }
        List<String> pnfsidPoolList = this.getCacheLocationList(pnfsId, false);
        HashSet<String> allPools = new HashSet<String>(this.getPoolListResilient());
        Vector<String> sourcePoolList = new Vector<String>(pnfsidPoolList);
        if (sourcePoolList.size() == 0) {
            throw new IllegalArgumentException("Select source pool error : PnfsManager reported no pools (cacheinfoof) for pnfsId=" + pnfsId);
        }
        sourcePoolList.retainAll(allPools);
        if (sourcePoolList.size() == 0) {
            throw new IllegalArgumentException("Select source pool error : there are no resilient pools in the pool list provided by PnfsManager for pnfsId=" + pnfsId);
        }
        sourcePoolList.retainAll(readablePools);
        if (sourcePoolList.size() == 0) {
            throw new IllegalArgumentException("Select source pool error :  replica found in resilient pool(s) but the pool is not in online,drainoff or offline-prepare state. pnfsId=" + pnfsId);
        }
        List<String> confirmedSourcePoolList = this.confirmCacheLocationList(pnfsId, sourcePoolList);
        if (confirmedSourcePoolList.size() == 0) {
            throw new IllegalArgumentException("Select source pool error : pools selectable for read did not confirm they have pnfsId=" + pnfsId);
        }
        String source = confirmedSourcePoolList.get(this._random.nextInt(confirmedSourcePoolList.size()));
        Vector<Object> destPools = new Vector<Object>(allPools);
        destPools.removeAll(pnfsidPoolList);
        Set<String> set = writablePools;
        synchronized (set) {
            destPools.retainAll(writablePools);
        }
        if (destPools.size() == 0) {
            throw new IllegalArgumentException("Select destination pool error :  no pools found in online state and not having listed pnfsId=" + pnfsId);
        }
        FileAttributes fileAttributes = this.getFileAttributes(pnfsId);
        long fileSize = fileAttributes.getSize();
        HashSet<String> sourceHosts = new HashSet<String>();
        for (Object e : sourcePoolList) {
            String poolName = e.toString();
            String host = this._hostMap.get(poolName);
            sourceHosts.add(host);
        }
        String destination = this.bestDestPool(destPools, fileSize, sourceHosts);
        return this.replicatePnfsId(fileAttributes, source, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoverTask replicatePnfsId(FileAttributes attributes, String source, String destination) throws Exception {
        PnfsId pnfsId = attributes.getPnfsId();
        _log.info("Sending p2p for " + pnfsId + " " + source + " -> " + destination);
        Pool2PoolTransferMsg req = new Pool2PoolTransferMsg(source, destination, attributes);
        req.setDestinationFileStatus(1);
        CellMessage msg = new CellMessage(new CellPath(destination), (Serializable)req);
        MoverTask task = new MoverTask(pnfsId, source, destination);
        HashMap<UOID, MoverTask> hashMap = this._messageHash;
        synchronized (hashMap) {
            this.sendMessage(msg);
            this._messageHash.put(msg.getUOID(), task);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCostTable(CellAdapter cell) throws InterruptedException, NoRouteToCellException {
        Object object = _costTableLock;
        synchronized (object) {
            if (_costTable == null || System.currentTimeMillis() > _costTable.getTimestamp() + 240000L) {
                String command = "xcm ls";
                CellMessage cellMessage = new CellMessage(new CellPath("PoolManager"), (Serializable)((Object)command));
                _log.debug("getCostTable(): sendMessage,  command=[" + command + "]\n" + "message=" + cellMessage);
                CellMessage reply = cell.sendAndWait(cellMessage, 120000L);
                _log.debug("DEBUG: Cost table reply arrived");
                if (reply == null || !(reply.getMessageObject() instanceof CostModulePoolInfoTable)) {
                    throw new IllegalArgumentException("received null pointer or wrong object type from PoolManager in getCostTable");
                }
                Serializable obj = reply.getMessageObject();
                if (obj == null) {
                    throw new IllegalArgumentException("received null pointer from getCostTable from PoolManager");
                }
                _costTable = (CostModulePoolInfoTable)obj;
            }
        }
    }

    public void reportGetFreeSpaceProblem(CellMessage msg) {
        if (msg == null) {
            _log.warn("Request Timed out");
            return;
        }
        Serializable o = msg.getMessageObject();
        if (o instanceof Exception) {
            _log.warn("GetFreeSpace: got exception" + ((Exception)o).getMessage());
        } else if (o instanceof String) {
            _log.warn("GetFreeSpace: got error '" + o.toString() + "'");
        } else {
            _log.warn("GetFreeSpace: Unexpected class arrived : " + o.getClass().getName());
        }
    }

    public void cellCreated(CellEvent ce) {
        super.cellCreated(ce);
        _log.debug("DCCC cellCreated called, ce=" + ce);
    }

    public void cellDied(CellEvent ce) {
        super.cellDied(ce);
        _log.debug("DCCC cellDied called, ce=" + ce);
    }

    public void cellExported(CellEvent ce) {
        super.cellExported(ce);
        _log.debug("DCCC cellExported called, ce=" + ce);
    }

    public void routeAdded(CellEvent ce) {
        super.routeAdded(ce);
        _log.debug("DCCC routeAdded called, ce=" + ce);
    }

    public void routeDeleted(CellEvent ce) {
        super.routeDeleted(ce);
        _log.debug("DCCC routeDeleted called, ce=" + ce);
    }

    public void messageArrived(CellMessage msg) {
        _log.debug("DCacheCoreController: message arrived. Original msg=" + msg);
        boolean expected = this.preprocessCellMessage(msg);
        if (expected) {
            try {
                this._msgFifo.put(msg);
            }
            catch (InterruptedException ex) {
                _log.debug("DCacheCoreController: messageArrived() - ignore InterruptedException");
            }
        }
    }

    protected CellMessage messageQueuePeek() {
        return (CellMessage)this._msgFifo.peek();
    }

    public boolean preprocessCellMessage(CellMessage msg) {
        Serializable obj = msg.getMessageObject();
        if (obj == null) {
            _log.debug("DCacheCoreController: preprocess Cell message null <" + msg + ">");
            return false;
        }
        if (this._dcccDebug && obj instanceof Object[]) {
            _log.debug("DCacheCoreController: preprocess Cell message Object[] <" + msg + ">");
            Object[] arr = (Object[])obj;
            for (int j = 0; j < arr.length; ++j) {
                _log.debug("msg[" + j + "]='" + arr[j].toString() + "'");
            }
            return false;
        }
        boolean taskFound = false;
        boolean msgFound = true;
        if (obj instanceof PnfsAddCacheLocationMessage) {
            PnfsAddCacheLocationMessage paclm = (PnfsAddCacheLocationMessage)obj;
            _log.debug("DCacheCoreController: preprocess Cell message PnfsAddCacheLocationMessage <" + paclm + ">");
        } else if (obj instanceof PnfsClearCacheLocationMessage) {
            PnfsClearCacheLocationMessage pcclm = (PnfsClearCacheLocationMessage)obj;
            _log.debug("DCacheCoreController: preprocess Cell message PnfsClearCacheLocationMessage <" + pcclm + ">");
        } else if (obj instanceof PoolStatusChangedMessage) {
            PoolStatusChangedMessage pscm = (PoolStatusChangedMessage)obj;
            _log.debug("DCacheCoreController: preprocess Cell message PoolStatusChangedMessage <" + pscm + ">");
        } else if (obj instanceof PoolRemoveFilesMessage) {
            PoolRemoveFilesMessage prmf = (PoolRemoveFilesMessage)obj;
            _log.debug("DCacheCoreController: preprocess Cell message PoolRemoveFilesMessage <" + prmf + ">");
        } else {
            msgFound = false;
            taskFound = this._messageHash.containsKey(msg.getLastUOID());
        }
        if (obj instanceof Pool2PoolTransferMsg) {
            Pool2PoolTransferMsg m = (Pool2PoolTransferMsg)obj;
            _log.debug("DCacheCoreController: preprocess DUMP Cell message Pool2PoolTransferMsg " + m + " isReply=" + m.isReply() + " id=" + m.getId());
        }
        _log.debug("DCacheCoreController: preprocess Cell message. msgFound=" + msgFound + " taskFound=" + taskFound + " msg uiod O=" + msg.getLastUOID());
        if (!msgFound && !taskFound) {
            _log.warn("DCacheCoreController: preprocess Cell message - ignore unexpected message " + msg);
        }
        return msgFound || taskFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCellMessage(CellMessage msg) {
        TaskObserver task;
        int maxAddListSize = 1023;
        LinkedList<PnfsAddCacheLocationMessage> l = this._cachedPnfsAddCacheLocationMessage;
        Serializable obj = msg.getMessageObject();
        CellMessage nextMsg = this.messageQueuePeek();
        Serializable nextObj = nextMsg == null ? null : nextMsg.getMessageObject();
        boolean isPnfsAddCacheLocationMessage = obj instanceof PnfsAddCacheLocationMessage;
        boolean nextPnfsAddCacheLocationMessage = nextObj != null && nextObj instanceof PnfsAddCacheLocationMessage;
        _log.debug("DCacheCoreController: process queued CellMessage. Before adding msg=" + msg + " qsize=" + l.size() + " next=" + nextPnfsAddCacheLocationMessage);
        if (isPnfsAddCacheLocationMessage) {
            l.add((PnfsAddCacheLocationMessage)obj);
        }
        if (!(isPnfsAddCacheLocationMessage && nextPnfsAddCacheLocationMessage && l.size() < 1023 || l.size() == 0)) {
            _log.debug("DCacheCoreController: process queued CellMessage. Flush queue qsize=" + l.size());
            this.processPnfsAddCacheLocationMessage(l);
            l.clear();
        }
        if (isPnfsAddCacheLocationMessage) {
            return;
        }
        if (obj instanceof PnfsClearCacheLocationMessage) {
            this.processPnfsClearCacheLocationMessage((PnfsClearCacheLocationMessage)obj);
            return;
        }
        if (obj instanceof PoolStatusChangedMessage) {
            this.processPoolStatusChangedMessage((PoolStatusChangedMessage)obj);
            return;
        }
        if (obj instanceof PoolRemoveFilesMessage) {
            this.processPoolRemoveFiles((PoolRemoveFilesMessage)obj);
            return;
        }
        HashMap<UOID, MoverTask> hashMap = this._messageHash;
        synchronized (hashMap) {
            task = this._messageHash.remove(msg.getLastUOID());
        }
        if (task != null) {
            _log.debug("DCacheCoreController: process CellMessage, task found for UOID=" + msg.getLastUOID());
            task.messageArrived(msg);
        } else {
            _log.warn("DCacheCoreController: processCellMessage() - ignore message, task not found message=[" + msg + "]");
        }
    }

    protected void processPoolStatusChangedMessage(PoolStatusChangedMessage msg) {
        _log.debug("DCacheCoreController: default processPoolStatusChangedMessage() called for" + msg);
    }

    protected void processPoolRemoveFiles(PoolRemoveFilesMessage msg) {
        _log.debug("DCacheCoreController: default processPoolRemoveFilesMessage() called");
        String poolName = msg.getPoolName();
        String[] filesList = msg.getFiles();
        if (poolName == null) {
            _log.debug("PoolRemoveFilesMessage - no pool defined");
            return;
        }
        if (filesList == null) {
            _log.debug("PoolRemoveFilesMessage - no file list defined");
            return;
        }
        for (int j = 0; j < filesList.length; ++j) {
            if (filesList[j] == null) {
                _log.debug("DCCC: default PoolRemoveFiles(): file[" + j + "]='null' removed from pool " + poolName);
                continue;
            }
            String stringPnfsId = filesList[j];
            _log.debug("DCCC: default PoolRemoveFiles(): file[" + j + "]=" + stringPnfsId + " removed from pool " + poolName);
        }
    }

    private void processPnfsAddCacheLocationMessage(PnfsAddCacheLocationMessage msg) {
        this.cacheLocationModified(msg, true);
    }

    private void processPnfsAddCacheLocationMessage(List<PnfsAddCacheLocationMessage> ml) {
        this.cacheLocationAdded(ml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPnfsClearCacheLocationMessage(PnfsModifyCacheLocationMessage msg) {
        String poolName = msg.getPoolName();
        PnfsId pnfsId = msg.getPnfsId();
        String key = pnfsId.getId() + "@" + poolName;
        this.cacheLocationModified(msg, false);
        HashMap<String, ReductionObserver> hashMap = this._modificationHash;
        synchronized (hashMap) {
            ReductionObserver o = this._modificationHash.get(key);
            _log.debug("processPnfsClearCacheLocationMessage() : TaskObserver=<" + o + ">;msg=[" + msg + "]");
            if (o != null && o.getPnfsId().equals(pnfsId)) {
                o.messageArrived(msg);
            }
        }
    }

    public abstract void cacheLocationModified(PnfsModifyCacheLocationMessage var1, boolean var2);

    public abstract void cacheLocationAdded(List<PnfsAddCacheLocationMessage> var1);

    public abstract void taskFinished(TaskObserver var1);

    protected FileAttributes getFileAttributes(PnfsId pnfsId) throws MissingResourceException, NoRouteToCellException, InterruptedException {
        PnfsGetStorageInfoMessage msg = new PnfsGetStorageInfoMessage(pnfsId);
        CellMessage cellMessage = new CellMessage(new CellPath("PnfsManager"), (Serializable)msg);
        CellMessage answer = this.sendAndWait(cellMessage, 120000L);
        if (answer == null) {
            throw new MissingResourceException("Timeout 120000", "PnfsManager", "PnfsGetStorageInfoMessage");
        }
        msg = (PnfsGetStorageInfoMessage)answer.getMessageObject();
        if (msg.getReturnCode() != 0) {
            _log.debug("getFileAttributes() PnfsGetStorageInfoMessage answer error: err=" + msg.getReturnCode() + ", message='" + msg + "'");
            if (msg.getReturnCode() == 10001) {
                throw new MissingResourceException("Pnfs File not found : " + msg.getErrorObject().toString(), "PnfsManager", "PnfsGetStorageInfoMessage");
            }
            throw new MissingResourceException(msg.getErrorObject().toString(), "PnfsManager", "PnfsGetStorageInfoMessage");
        }
        return msg.getFileAttributes();
    }

    protected void removeCopy(PnfsId pnfsId, String poolName, boolean force) throws Exception {
        CellMessage msg = new CellMessage(new CellPath(poolName), (Serializable)((Object)("rep rm " + (force ? " -force " : "") + pnfsId)));
        this.sendMessage(msg);
    }

    protected List<String> getCacheLocationList(PnfsId pnfsId, boolean checked) throws MissingResourceException, NoRouteToCellException, InterruptedException {
        PoolCheckFileMessage query;
        PnfsGetCacheLocationsMessage msg = new PnfsGetCacheLocationsMessage(pnfsId);
        CellMessage cellMessage = new CellMessage(new CellPath("PnfsManager"), (Serializable)msg);
        CellMessage answer = this.sendAndWait(cellMessage, 120000L);
        if (answer == null) {
            throw new MissingResourceException("Timeout 120000", "PnfsManager", "PnfsGetCacheLocation");
        }
        msg = (PnfsGetCacheLocationsMessage)answer.getMessageObject();
        if (msg.getReturnCode() != 0) {
            _log.debug("getCacheLocationList(...) PnfsGetCacheLocationsMessage answer error: err=" + msg.getReturnCode() + ", message='" + msg + "'");
            if (msg.getReturnCode() == 10001) {
                throw new MissingResourceException("Pnfs File not found : " + msg.getErrorObject().toString(), "PnfsManager", "PnfsGetCacheLocationsMessage");
            }
            throw new MissingResourceException(msg.getErrorObject().toString(), "PnfsManager", "PnfsGetCacheLocationsMessage");
        }
        if (!checked) {
            return new ArrayList<String>(msg.getCacheLocations());
        }
        HashSet<String> assumed = new HashSet<String>(msg.getCacheLocations());
        HashSet<String> confirmed = new HashSet<String>();
        if (assumed.size() <= 0) {
            return new ArrayList<String>(confirmed);
        }
        SpreadAndWait controller = new SpreadAndWait((CellEndpoint)this, 120000L);
        for (Object e : assumed) {
            String poolName = e.toString();
            query = new PoolCheckFileMessage(poolName, pnfsId);
            CellMessage cellMessage2Pool = new CellMessage(new CellPath(poolName), (Serializable)query);
            try {
                controller.send(cellMessage2Pool);
            }
            catch (Exception eeee) {
                _log.warn("Problem sending query to " + query.getPoolName() + " " + eeee);
            }
        }
        controller.waitForReplies();
        Iterator<CellMessage> i = controller.getReplies();
        while (i.hasNext()) {
            query = (PoolCheckFileMessage)i.next().getMessageObject();
            _log.debug("getCacheLocationList : PoolCheckFileMessage=" + query);
            if (!query.getHave()) continue;
            confirmed.add(query.getPoolName());
        }
        return new ArrayList<String>(confirmed);
    }

    protected List<String> confirmCacheLocationList(PnfsId pnfsId, List<String> poolList) throws InterruptedException {
        PoolCheckFileMessage query;
        HashSet<String> assumed = new HashSet<String>(poolList);
        HashSet<String> confirmed = new HashSet<String>();
        if (assumed.size() <= 0) {
            return new ArrayList<String>(confirmed);
        }
        SpreadAndWait controller = new SpreadAndWait((CellEndpoint)this, 120000L);
        for (Object e : assumed) {
            String poolName = e.toString();
            query = new PoolCheckFileMessage(poolName, pnfsId);
            CellMessage cellMessage2Pool = new CellMessage(new CellPath(poolName), (Serializable)query);
            try {
                controller.send(cellMessage2Pool);
            }
            catch (Exception ex) {
                _log.warn("Problem sending query to " + query.getPoolName() + " " + ex);
            }
        }
        controller.waitForReplies();
        Iterator<CellMessage> i = controller.getReplies();
        while (i.hasNext()) {
            query = (PoolCheckFileMessage)i.next().getMessageObject();
            _log.debug("confirmCacheLocationList : PoolCheckFileMessage=" + query);
            if (!query.getHave()) continue;
            confirmed.add(query.getPoolName());
        }
        return new ArrayList<String>(confirmed);
    }

    protected List<String> getPoolList() throws MissingResourceException, NoRouteToCellException, InterruptedException {
        PoolManagerGetPoolListMessage msg = new PoolManagerGetPoolListMessage();
        CellMessage cellMessage = new CellMessage(new CellPath("PoolManager"), (Serializable)msg);
        CellMessage answer = this.sendAndWait(cellMessage, 120000L);
        if (answer == null) {
            throw new MissingResourceException("Timeout : 120000", "PoolManager", "PoolManagerGetPoolListMessage");
        }
        msg = (PoolManagerGetPoolListMessage)answer.getMessageObject();
        if (msg.getReturnCode() != 0) {
            throw new MissingResourceException(msg.getErrorObject().toString(), "PoolManager", "PoolManagerGetPoolListMessage");
        }
        return msg.getPoolList();
    }

    protected List<String> getPoolGroup(String pGroup) throws InterruptedException, NoRouteToCellException {
        String command = "psux ls pgroup " + pGroup;
        CellMessage cellMessage = new CellMessage(new CellPath("PoolManager"), (Serializable)((Object)command));
        _log.debug("getPoolGroup: sendMessage, command=[" + command + "]\n" + "message=" + cellMessage);
        CellMessage reply = this.sendAndWait(cellMessage, 120000L);
        if (reply == null || !(reply.getMessageObject() instanceof Object[])) {
            this.reportProblemGPG(reply);
            return null;
        }
        Object[] r = (Object[])reply.getMessageObject();
        if (r.length != 3) {
            _log.info("getPoolGroup: The length of reply=" + r.length + " != 3");
            return null;
        }
        String groupName = (String)r[0];
        Object[] poolsArray = (Object[])r[1];
        ArrayList<String> poolList = new ArrayList<String>();
        _log.debug("Length of the group=" + poolsArray.length);
        for (int j = 0; j < poolsArray.length; ++j) {
            _log.debug("Pool " + j + " : " + poolsArray[j]);
            poolList.add((String)poolsArray[j]);
        }
        _log.debug("getPoolGroup: Info: '{}' pool group name='{}'", (Object)pGroup, (Object)groupName);
        if (_log.isDebugEnabled()) {
            _log.debug("Pools: {}", (Object)Arrays.toString(poolsArray));
        }
        return poolList;
    }

    private void reportProblemGPG(CellMessage msg) {
        if (msg == null) {
            _log.info("Request Timed out");
            return;
        }
        Serializable o = msg.getMessageObject();
        if (o instanceof Exception) {
            _log.info("GetPoolGroup: got exception" + ((Exception)o).getMessage());
        } else if (o instanceof String) {
            _log.info("GetPoolGroup: got error '" + o.toString() + "'");
        } else {
            _log.info("GetPoolGroup: Unexpected class arrived : " + o.getClass().getName());
        }
    }

    protected String getPoolHost(String poolName) throws InterruptedException, NoRouteToCellException {
        PoolCheckMessage msg = new PoolCheckMessage(poolName);
        msg.setReplyRequired(true);
        CellMessage cellMessage = new CellMessage(new CellPath(poolName), (Serializable)((Object)"xgetcellinfo"));
        _log.debug("getHostPool: send xgetcellinfo message to pool " + poolName);
        CellMessage answer = this.sendAndWait(cellMessage, 120000L);
        if (answer == null) {
            throw new MissingResourceException("Timeout : 120000", poolName, "xgetcellinfo");
        }
        if (!(answer.getMessageObject() instanceof PoolCellInfo)) {
            throw new IllegalArgumentException("getPoolHost() received wrong object type from Pool " + poolName + ", obj=" + answer.getMessageObject());
        }
        PoolCellInfo msgAnswer = (PoolCellInfo)answer.getMessageObject();
        if (msgAnswer.getErrorCode() != 0) {
            throw new MissingResourceException("getPoolHost(): received error from pool=" + poolName + ", error=" + msgAnswer.getErrorCode() + ", error message='" + msgAnswer.getErrorMessage() + "'", " pool ", poolName);
        }
        Map<String, String> map = msgAnswer.getTagMap();
        String poolHost = map == null ? null : map.get("hostname");
        _log.debug("getHostPool: msgAnswer=" + msgAnswer);
        _log.debug("getHostPool: tag map=" + map);
        return poolHost;
    }

    protected List<CacheRepositoryEntryInfo> getPoolRepository(String poolName) throws MissingResourceException, ConcurrentModificationException, NoRouteToCellException, InterruptedException {
        ArrayList<CacheRepositoryEntryInfo> list = new ArrayList<CacheRepositoryEntryInfo>();
        IteratorCookie cookie = new IteratorCookie();
        while (!cookie.done()) {
            PoolQueryRepositoryMsg msg = new PoolQueryRepositoryMsg(poolName, cookie);
            CellMessage cellMessage = new CellMessage(new CellPath(poolName), (Serializable)msg);
            CellMessage answer = this.sendAndWait(cellMessage, 120000L);
            if (answer == null) {
                throw new MissingResourceException("PoolQueryRepositoryMsg timed out", poolName, " 120000");
            }
            msg = (PoolQueryRepositoryMsg)answer.getMessageObject();
            cookie = msg.getCookie();
            if (cookie.invalidated()) {
                throw new ConcurrentModificationException("Pool file list of " + poolName + " was invalidated");
            }
            list.addAll(msg.getInfos());
        }
        return list;
    }

    protected Object sendObject(String cellPath, Serializable object) throws Exception {
        return this.sendObject(new CellPath(cellPath), object);
    }

    protected Object sendObject(CellPath cellPath, Serializable object) throws Exception {
        CellMessage res = this.sendAndWait(new CellMessage(cellPath, object), 120000L);
        if (res == null) {
            throw new Exception("Request timed out");
        }
        return res.getMessageObject();
    }

    static {
        _costTableLock = new Object();
    }

    public class MoverTask
    extends TaskObserver {
        private PnfsId _pnfsId;
        private String _srcPool;
        private String _dstPool;
        private boolean _pnfsIdDeleted;

        public MoverTask(PnfsId pnfsId, String source, String destination) {
            super("Replication");
            this._pnfsId = pnfsId;
            this._srcPool = source;
            this._dstPool = destination;
            DCacheCoreControllerV2.this._p2p.add(this._srcPool, this._dstPool);
        }

        protected void moverTaskFinishedHook() {
            DCacheCoreControllerV2.this._p2p.remove(this._srcPool, this._dstPool);
        }

        public PnfsId getPnfsId() {
            return this._pnfsId;
        }

        public String getSrcPool() {
            return this._srcPool;
        }

        public String getDstPool() {
            return this._dstPool;
        }

        public boolean isPnfsIdDeleted() {
            return this._pnfsIdDeleted;
        }

        public void setPnfsIdDeleted(boolean b) {
            this._pnfsIdDeleted = b;
        }

        @Override
        public void messageArrived(CellMessage msg) {
            Message reply;
            if (msg.getMessageObject() instanceof NoRouteToCellException) {
                this.setErrorCode(-103, "MoverTask: dmg.cells.nucleus.NoRouteToCellException");
                _log.debug("MoverTask got error NoRouteToCellException");
                return;
            }
            try {
                reply = (Message)msg.getMessageObject();
            }
            catch (Exception ex) {
                this.setErrorCode(-101, "MoverTask: exception converting reply message=" + ex.getMessage());
                return;
            }
            if (reply.getReturnCode() == 0) {
                this.setOk();
            } else {
                this.setErrorCode(reply.getReturnCode(), reply.getErrorObject().toString());
                _log.debug("MoverTask got error ReturnCode=" + reply.getReturnCode() + ", ErrorObject=[" + reply.getReturnCode() + "]" + "reply=\n[" + reply + "]");
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Id=").append(super.getId()).append(";type=");
            sb.append(this._type).append("( ").append(this._pnfsId).append(" ").append(this._srcPool).append(" -> ").append(this._dstPool).append(" )");
            sb.append(";status=").append(this._status).append(";");
            if (this._done) {
                sb.append("Rc=");
                if (this._errorCode == 0) {
                    sb.append(0).append(";");
                } else {
                    sb.append("{").append(this._errorCode).append(",").append(this._errorMsg).append("};");
                }
            } else {
                sb.append("runtime= ").append(UptimeParser.valueOf((System.currentTimeMillis() - super.getCreationTime()) / 1000L));
            }
            return sb.toString();
        }
    }

    public class ReductionObserver
    extends TaskObserver {
        protected PnfsId _pnfsId;
        protected String _poolName;
        protected TaskObserver _oldTask;
        private String _key;
        private boolean _pnfsIdDeleted;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ReductionObserver(PnfsId pnfsId, String poolName) throws Exception {
            super("Reduction");
            this._pnfsId = pnfsId;
            this._poolName = poolName;
            this._key = this._pnfsId.getId() + "@" + poolName;
            HashMap hashMap = DCacheCoreControllerV2.this._modificationHash;
            synchronized (hashMap) {
                DCacheCoreControllerV2.this.removeCopy(this._pnfsId, this._poolName, true);
                this._oldTask = DCacheCoreControllerV2.this._modificationHash.put(this._key, this);
                if (this._oldTask != null) {
                    _log.warn("ReductionObserver() internal error: task overriden in the _modificationHash, old task=" + this._oldTask);
                }
            }
        }

        @Override
        public void messageArrived(Message reply) {
            if (reply.getReturnCode() == 0) {
                this.setOk();
            } else {
                this.setErrorCode(reply.getReturnCode(), reply.getErrorObject().toString());
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Id=").append(super.getId()).append(";type=");
            sb.append(this._type).append("( ").append(this._pnfsId).append(" ").append(this._poolName).append(" )");
            sb.append(";status=").append(this._status).append(";");
            if (this._done) {
                sb.append("Rc=");
                if (this._errorCode == 0) {
                    sb.append(0).append(";");
                } else {
                    sb.append("{").append(this._errorCode).append(",").append(this._errorMsg).append("};");
                }
            } else {
                sb.append("runtime= ").append(UptimeParser.valueOf((System.currentTimeMillis() - super.getCreationTime()) / 1000L));
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished() {
            HashMap hashMap = DCacheCoreControllerV2.this._modificationHash;
            synchronized (hashMap) {
                DCacheCoreControllerV2.this._modificationHash.remove(this._key);
            }
            super.finished();
        }

        public PnfsId getPnfsId() {
            return this._pnfsId;
        }

        public String getPool() {
            return this._poolName;
        }

        public boolean isPnfsIdDeleted() {
            return this._pnfsIdDeleted;
        }

        public void setPnfsIdDeleted(boolean b) {
            this._pnfsIdDeleted = b;
        }
    }

    public class TaskObserver {
        private long _id;
        protected String _type;
        protected int _errorCode;
        protected String _errorMsg;
        protected boolean _done;
        protected String _status;
        private long _creationTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskObserver(String type) {
            this._id = DCacheCoreControllerV2.this.__nextTaskId();
            this._status = "Active";
            this._type = type;
            this._creationTime = System.currentTimeMillis();
            HashMap hashMap = DCacheCoreControllerV2.this._taskHash;
            synchronized (hashMap) {
                DCacheCoreControllerV2.this._taskHash.put(this._id, this);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Id=").append(this._id).append(";type=").append(this._type).append(";status=").append(this._status).append(";");
            if (this._done) {
                sb.append("Rc=");
                if (this._errorCode == 0) {
                    sb.append(0).append(";");
                } else {
                    sb.append("{").append(this._errorCode).append(",").append(this._errorMsg).append("};");
                }
            }
            return sb.toString();
        }

        public void setOk() {
            this.setErrorCode(0, null);
        }

        public int getErrorCode() {
            return this._errorCode;
        }

        public String getErrorMessage() {
            return this._errorMsg;
        }

        public void setErrorCode(int errorCode, String errorString) {
            this._errorCode = errorCode;
            this._errorMsg = errorString;
            this._status = "done";
            this.finished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            this._done = true;
            DCacheCoreControllerV2.this.taskFinished(this);
            if (this.getType().equals("Replication")) {
                MoverTask mt = (MoverTask)this;
                mt.moverTaskFinishedHook();
            }
            Object object = DCacheCoreControllerV2.this._taskHash;
            synchronized (object) {
                DCacheCoreControllerV2.this._taskHash.remove(new Long(this._id));
            }
            _log.debug("Task finished - notifyAll waiting for _taskHash");
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }

        public boolean isDone() {
            return this._done;
        }

        public String getType() {
            return this._type;
        }

        public long getId() {
            return this._id;
        }

        public void messageArrived(CellMessage msg) {
            _log.debug("DCacheCoreController::TaskObserver - CellMessage arrived, " + msg);
        }

        public void messageArrived(Message msg) {
            _log.debug("DCacheCoreController::TaskObserver - Message arrived, " + msg);
        }

        public void setStatus(String status) {
            this._status = status;
        }

        public long getCreationTime() {
            return this._creationTime;
        }
    }

    private class P2pObserver {
        private Hashtable<String, AtomicInteger> _p2pClientCount;
        private Hashtable<String, AtomicInteger> _p2pServerCount;

        public synchronized void reset() {
            this._p2pClientCount = new Hashtable();
            this._p2pServerCount = new Hashtable();
        }

        public P2pObserver() {
            this.reset();
        }

        public int getClientCount(String dst) {
            AtomicInteger clientCount = this._p2pClientCount.get(dst);
            return clientCount != null ? clientCount.get() : 0;
        }

        public int getServerCount(String src) {
            AtomicInteger serverCount = this._p2pServerCount.get(src);
            return serverCount != null ? serverCount.get() : 0;
        }

        public synchronized void add(String src, String dst) {
            AtomicInteger serverCount = this._p2pServerCount.get(src);
            if (serverCount == null) {
                serverCount = new AtomicInteger(1);
                this._p2pServerCount.put(src, serverCount);
            } else {
                serverCount.incrementAndGet();
            }
            AtomicInteger clientCount = this._p2pClientCount.get(dst);
            if (clientCount == null) {
                clientCount = new AtomicInteger(1);
                this._p2pClientCount.put(dst, clientCount);
            } else {
                clientCount.incrementAndGet();
            }
        }

        public synchronized void remove(String src, String dst) {
            AtomicInteger clients;
            AtomicInteger servers = this._p2pServerCount.get(src);
            if (servers != null && servers.decrementAndGet() <= 0) {
                this._p2pServerCount.remove(src);
            }
            if ((clients = this._p2pClientCount.get(dst)) != null && clients.decrementAndGet() <= 0) {
                this._p2pClientCount.remove(dst);
            }
        }
    }

    private class MessageProcessThread
    implements Runnable {
        private final String _threadName = "DCacheCoreController-MessageProcessing";

        public MessageProcessThread() {
            DCacheCoreControllerV2.this._nucleus.newThread((Runnable)this, "DCacheCoreController-MessageProcessing").start();
        }

        @Override
        public void run() {
            _log.info("Thread <" + Thread.currentThread().getName() + "> started");
            boolean done = false;
            while (!done) {
                CellMessage message;
                try {
                    message = (CellMessage)DCacheCoreControllerV2.this._msgFifo.take();
                }
                catch (InterruptedException e) {
                    done = true;
                    continue;
                }
                try {
                    DCacheCoreControllerV2.this.processCellMessage(message);
                }
                catch (Throwable ex) {
                    _log.warn(Thread.currentThread().getName() + " : " + ex);
                }
            }
            _log.info("Thread <" + Thread.currentThread().getName() + "> finished");
        }
    }

    private class MessageTimeoutThread
    implements Runnable {
        private String _threadName = "DCacheCoreController-MessageTimeout";

        public MessageTimeoutThread() {
            DCacheCoreControllerV2.this._nucleus.newThread((Runnable)this, this._threadName).start();
        }

        @Override
        public void run() {
            while (true) {
                DCacheCoreControllerV2.this._nucleus.updateWaitQueue();
                try {
                    Thread.currentThread();
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    _log.info(this._threadName + " thread interrupted");
                    _log.info(this._threadName + " thread finished");
                    return;
                }
            }
        }
    }
}

