/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.replicaManager;

import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Pool2PoolTransferMsg;
import diskCacheV111.vehicles.PoolCheckFileMessage;
import diskCacheV111.vehicles.PoolModifyPersistencyMessage;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyManager
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(CopyManager.class);
    private final Object _processLock = new Object();
    private boolean _isActive;
    private Thread _worker;
    private CopyWorker _copy;
    private String _status = "IDLE";
    private Parameter _parameter = new Parameter();
    private PoolRepository _poolRepository;
    private long _repositoryTimeout = 600000L;
    private String _source;
    private String[] _destination;
    private boolean _precious;
    public static final String hh_stop = "[-interrupt]  # DEBUG only";
    public static final String hh_drain = " # drains current transfers but doesn't start new transfers";
    public static final String fh_ls = "  ls [options] [pnfsId]\n       OPTIONS\n          -e :  lists transfers with error state (overwrites all other options)\n          -d :  lists 'done' in addition to 'active' transfers\n          -w :  lists 'wait' in addition to 'active' transfers\n          -a :  lists all transfers (wait,active,done)\n";
    public static final String hh_ls = "[-d] [-w] [-a] [pnfsId]";
    public static final String hh_copy = "<fromPool> <toPool> [toPool2 [...]] [-max=<maxParallel>] [-precious]";

    public CopyManager(String cellName, String args) {
        super(cellName, args);
        this.start();
    }

    private void resetParameter(String from, String to, boolean precious) {
        this._source = from;
        this._destination = new String[1];
        this._destination[0] = to;
        this._precious = precious;
        this._parameter.reset();
    }

    private void resetParameter(String from, String[] toArray, boolean precious) {
        this._source = from;
        this._destination = toArray;
        this._precious = precious;
        this._parameter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_stop(Args args) {
        boolean inter = args.hasOption("interrupt");
        Object object = this._processLock;
        synchronized (object) {
            if (!this._isActive) {
                throw new IllegalStateException("No copy process active");
            }
            if (this._parameter._stopped) {
                throw new IllegalStateException("Process already stopped");
            }
            this._parameter._stopped = true;
            if (inter) {
                this._worker.interrupt();
            }
        }
        return "Stop initiated " + (inter ? "(interrupted)" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_drain(Args args) {
        Object object = this._processLock;
        synchronized (object) {
            if (!this._isActive) {
                throw new IllegalStateException("No copy process active");
            }
            this._parameter._stopped = true;
            this._processLock.notifyAll();
        }
        return "Interrupt initiated";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_ls_$_0_1(Args args) {
        PoolRepository rep;
        boolean w = args.hasOption("w");
        boolean d = args.hasOption("d");
        boolean a = args.hasOption("a");
        boolean e = args.hasOption("e");
        StringBuilder sb = new StringBuilder();
        Object object = this._processLock;
        synchronized (object) {
            rep = this._poolRepository;
        }
        if (rep == null) {
            throw new IllegalArgumentException("No pool repository yet [" + this._status + "]");
        }
        if (args.argc() > 0) {
            String pnfsId = args.argv(0);
            PoolFileEntry entry = rep.getRepositoryMap().get(pnfsId);
            if (entry == null) {
                throw new IllegalArgumentException("Transfer not found for " + pnfsId);
            }
            sb.append(entry.toString()).append("\n");
            return sb.toString();
        }
        for (PoolFileEntry entry : rep.getRepositoryMap().values()) {
            String entryString = entry.toString() + "\n";
            if (a) {
                sb.append(entryString);
                continue;
            }
            if (e) {
                if (entry.returnCode == 0) continue;
                sb.append(entryString);
                continue;
            }
            switch (entry.state) {
                case 1: 
                case 2: {
                    sb.append(entryString);
                    break;
                }
                case 3: {
                    if (!d) break;
                    sb.append(entryString);
                    break;
                }
                case 0: {
                    if (!w) break;
                    sb.append(entryString);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInfo(PrintWriter pw) {
        float value;
        int i;
        PoolRepository rep;
        Parameter p;
        pw.println("     Name : " + this.getCellName());
        pw.println("    Class : " + ((Object)((Object)this)).getClass().getName());
        pw.println("  Version : $Id$");
        pw.println("     Mode : " + (this._isActive ? "ACTIVE" : "IDLE") + " " + (this._parameter._stopped ? "STOPPED" : ""));
        pw.println("   Status : " + this._status);
        if (this._parameter._started == 0L) {
            return;
        }
        pw.print(" Transfer : " + this._source + " -> ");
        for (String s : this._destination) {
            pw.print(s + " ");
        }
        pw.println("");
        pw.println("  Started : " + new Date(this._parameter._started));
        if (this._parameter._finished != 0L) {
            pw.println(" Finished : " + new Date(this._parameter._finished));
        }
        pw.println("    Param : " + this._parameter);
        Object i$ = this._processLock;
        synchronized (i$) {
            p = this._parameter;
            rep = this._poolRepository;
        }
        if (p == null || rep == null || rep.getTotalSize() == 0L) {
            return;
        }
        if (p._started == 0L) {
            return;
        }
        float percent = (float)p._bytesFinished / (float)rep.getTotalSize();
        float percentFailed = (float)p._bytesFailed / (float)rep.getTotalSize();
        pw.println(" Progress");
        int maxSize = 40;
        int done = (int)(percent * (float)maxSize);
        int failed = (int)(percentFailed * (float)maxSize);
        done = Math.min(done, 40);
        pw.println(" +----------------------------------------+");
        pw.print(" |");
        for (i = 0; i < failed; ++i) {
            pw.print("?");
        }
        while (i < done) {
            pw.print("*");
            ++i;
        }
        while (i < maxSize) {
            pw.print(" ");
            ++i;
        }
        pw.println("| " + (int)((double)percent * 100.0) + " %");
        pw.println(" +----------------------------------------+");
        long now = p._finished != 0L ? p._finished : System.currentTimeMillis();
        long diff = now - p._started;
        if (diff == 0L) {
            return;
        }
        float bytesPerSecond = (float)p._bytesFinished / (float)diff * 1000.0f;
        String[] units = new String[]{"Bytes", "KBytes", "MBytes", "GBytes", "TBytes"};
        i = 0;
        for (value = bytesPerSecond; i < units.length && value > 1024.0f; value /= 1024.0f, ++i) {
        }
        pw.println(" Average Speed : " + value + " " + units[i] + "/second");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_copy_$_2_999(Args args) {
        Object object = this._processLock;
        synchronized (object) {
            if (this._isActive) {
                throw new IllegalStateException("Copy process is active");
            }
            int dests = args.argc() - 1;
            String from = args.argv(0);
            String[] to = new String[dests];
            for (int i = 0; i < dests; ++i) {
                to[i] = args.argv(i + 1);
            }
            this.resetParameter(from, to, args.hasOption("precious"));
            String max = args.getOpt("max");
            if (max != null) {
                this._parameter._maxActive = Integer.parseInt(max);
            }
            this._copy = new CopyWorker();
            this._worker = this.getNucleus().newThread((Runnable)this._copy, "Worker");
            this._worker.start();
            this._isActive = true;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(String newStatus) {
        _log.info("STATUS : " + newStatus);
        Object object = this._processLock;
        synchronized (object) {
            this._status = newStatus;
        }
    }

    private PoolCellInfo getPoolInfo(String poolName) throws Exception {
        CellMessage msg = new CellMessage(new CellPath(poolName), (Serializable)((Object)"rep ls -l"));
        if ((msg = this.sendAndWait(msg, this._repositoryTimeout)) == null) {
            throw new Exception("Request to " + poolName + " timed out ");
        }
        Serializable obj = msg.getMessageObject();
        if (obj == null || !(obj instanceof PoolCellInfo)) {
            throw new IllegalArgumentException("Answer empty or invalid");
        }
        return (PoolCellInfo)obj;
    }

    private void getSourcePoolInfos() throws Exception {
        this._parameter._sourceInfo = this.getPoolInfo(this._source);
    }

    private void getDestinationPoolInfos() throws Exception {
        Parameter.access$2402(this._parameter, new PoolCellInfo[this._destination.length]);
        for (int i = 0; i < this._destination.length; ++i) {
            ((Parameter)this._parameter)._destinationInfo[i] = this.getPoolInfo(this._destination[i]);
        }
    }

    private boolean checkFileInPool(PnfsId pnfsId, String poolName) throws InterruptedException {
        try {
            PoolCheckFileMessage msg = new PoolCheckFileMessage(poolName, pnfsId);
            CellMessage carrier = new CellMessage(new CellPath(poolName), (Serializable)msg);
            carrier = this.sendAndWait(carrier, this._repositoryTimeout);
            if (carrier == null) {
                throw new Exception("Request to " + poolName + " timed out");
            }
            msg = (PoolCheckFileMessage)carrier.getMessageObject();
            return msg.getHave();
        }
        catch (Exception e) {
            _log.warn("Problem checking file : " + pnfsId + " on pool " + poolName + " : " + e);
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery(PoolFileEntry entry) {
        Object object = this._processLock;
        synchronized (object) {
            entry.timestamp = System.currentTimeMillis();
            PoolCheckFileMessage query = new PoolCheckFileMessage(this._source, entry.getPnfsId());
            CellMessage msg = new CellMessage(new CellPath(this._source), (Serializable)query);
            this._parameter._currentlyActive++;
            try {
                _log.info("sendQuery : sending query for " + entry);
                this.sendMessage(msg);
            }
            catch (Exception ee) {
                this.setEntryFinished(entry, 1, ee);
                return;
            }
            entry.state = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendState(PoolFileEntry entry) {
        Object object = this._processLock;
        synchronized (object) {
            entry.timestamp = System.currentTimeMillis();
            PoolModifyPersistencyMessage pool = new PoolModifyPersistencyMessage(entry._destination, entry.getPnfsId(), true);
            CellMessage out = new CellMessage(new CellPath(entry._destination), (Serializable)pool);
            try {
                _log.info("sendQuery : sending query for " + entry);
                this.sendMessage(out);
                entry.state = 2;
            }
            catch (Exception ee) {
                this.setEntryFinished(entry, 5, ee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransfer(PoolFileEntry entry) {
        Object object = this._processLock;
        synchronized (object) {
            entry.timestamp = System.currentTimeMillis();
            FileAttributes fileAttributes = new FileAttributes();
            fileAttributes.setPnfsId(entry.getPnfsId());
            Pool2PoolTransferMsg pool2pool = new Pool2PoolTransferMsg(this._source, entry._destination, fileAttributes);
            CellMessage msg = new CellMessage(new CellPath(entry._destination), (Serializable)pool2pool);
            try {
                _log.info("startTransfer : sending 'start transfer' for " + entry);
                this.sendMessage(msg);
            }
            catch (Exception ee) {
                this.setEntryFinished(entry, 1, ee);
                return;
            }
            entry.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pool2poolAnswerArrived(Pool2PoolTransferMsg msg) {
        PnfsId pnfsId = msg.getPnfsId();
        String poolName = msg.getDestinationPoolName();
        Object object = this._processLock;
        synchronized (object) {
            PoolFileEntry entry = this._poolRepository.getRepositoryMap().get(pnfsId.toString());
            if (entry == null) {
                _log.warn("p2pAnswerArrived : entry not found in rep : " + pnfsId);
                return;
            }
            _log.info("pool2poolAnswerArrived: " + entry + " -> " + msg.getReturnCode());
            if (msg.getReturnCode() == 0) {
                entry.transferOk = true;
                if (entry.isPrecious()) {
                    _log.info("pool2poolAnswerArrived for " + pnfsId + " Sending precious to " + poolName);
                    PoolModifyPersistencyMessage pool = new PoolModifyPersistencyMessage(poolName, pnfsId, true);
                    CellMessage out = new CellMessage(new CellPath(poolName), (Serializable)pool);
                    try {
                        this.sendMessage(out);
                        entry.state = 2;
                    }
                    catch (Exception ee) {
                        this.setEntryFinished(entry, 3, ee);
                    }
                } else {
                    entry.stateOk = true;
                    this.setEntryFinished(entry);
                }
            } else {
                this.setEntryFinished(entry, 2, msg.getErrorObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poolModifyPersistencyAnswerArrived(PoolModifyPersistencyMessage msg) {
        PnfsId pnfsId = msg.getPnfsId();
        Object object = this._processLock;
        synchronized (object) {
            PoolFileEntry entry = this._poolRepository.getRepositoryMap().get(pnfsId.toString());
            _log.info("poolModifyPersistencyAnswerArrived: " + entry + " -> " + msg.getReturnCode());
            if (msg.getReturnCode() == 0) {
                entry.stateOk = true;
                this.setEntryFinished(entry);
            } else {
                this.setEntryFinished(entry, 5, msg.getErrorObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poolCheckFileAnswerArrived(PoolCheckFileMessage msg) {
        PnfsId pnfsId = msg.getPnfsId();
        Object object = this._processLock;
        synchronized (object) {
            PoolFileEntry entry = this._poolRepository.getRepositoryMap().get(pnfsId.toString());
            _log.info("poolCheckFileAnswerArrived: " + entry + " -> " + msg);
            if (msg.getReturnCode() == 0) {
                if (entry.state == 4) {
                    if (msg.getHave()) {
                        _log.info("poolCheckFile answer for initial query ok for " + entry);
                        this.startTransfer(entry);
                    } else {
                        _log.info("poolCheckFile answer for initial query 'file not found' for " + entry);
                        this.setEntryFinished(entry);
                    }
                } else if (entry.state == 5) {
                    if (msg.getHave()) {
                        _log.info("poolCheckFile answer for final query ok for " + entry);
                        this.sendState(entry);
                    } else {
                        _log.info("poolCheckFile answer for final query 'file not found' for " + entry);
                        this.setEntryFinished(entry);
                    }
                } else {
                    this.setEntryFinished(entry, 10, "checkFileAnswer arrived in illegal state " + entry.state);
                }
            } else {
                this.setEntryFinished(entry, 5, msg.getErrorObject());
            }
        }
    }

    private void setEntryFinished(PoolFileEntry entry) {
        this.setEntryFinished(entry, 0, null);
    }

    private void setEntryFinished(PoolFileEntry entry, int rc, Object ro) {
        entry.state = 3;
        entry.returnCode = rc;
        entry.returnObject = ro;
        this._parameter._filesFinished++;
        this._parameter._bytesFinished += entry.getSize();
        if (rc != 0) {
            this._parameter._filesFailed++;
            this._parameter._bytesFailed += entry.getSize();
        }
        this._parameter._currentlyActive--;
        this._processLock.notifyAll();
    }

    public void messageArrived(CellMessage message) {
        Serializable obj = message.getMessageObject();
        if (obj instanceof Pool2PoolTransferMsg) {
            this.pool2poolAnswerArrived((Pool2PoolTransferMsg)obj);
        } else if (obj instanceof PoolModifyPersistencyMessage) {
            this.poolModifyPersistencyAnswerArrived((PoolModifyPersistencyMessage)obj);
        } else if (obj instanceof PoolCheckFileMessage) {
            this.poolCheckFileAnswerArrived((PoolCheckFileMessage)obj);
        } else {
            _log.warn("Unexpected message arrived : " + message);
        }
    }

    public PoolRepository getExtendedPoolRepository(String poolName, long timeout) throws Exception {
        CellMessage msg = new CellMessage(new CellPath(poolName), (Serializable)((Object)"rep ls -l"));
        if ((msg = this.sendAndWait(msg, timeout)) == null) {
            throw new Exception("Request to " + poolName + " timed out ");
        }
        Serializable obj = msg.getMessageObject();
        if (obj == null || !(obj instanceof String)) {
            throw new Exception("Answer empty or invalid");
        }
        HashMap<String, PoolFileEntry> map = new HashMap<String, PoolFileEntry>();
        StringTokenizer st = new StringTokenizer((String)((Object)obj), "\n");
        long total = 0L;
        int counter = 0;
        while (st.hasMoreTokens()) {
            String entryString = st.nextToken();
            try {
                PoolFileEntry entry = new PoolFileEntry(entryString);
                total += entry.getSize();
                ++counter;
                map.put(entry.getPnfsId().toString(), entry);
            }
            catch (Exception ee) {
                _log.warn("Invalid format " + entryString);
            }
        }
        return new PoolRepository(map, counter, total);
    }

    private class PoolFileEntry {
        private static final int IDLE = 0;
        private static final int TRANSFER = 1;
        private static final int STATE = 2;
        private static final int DONE = 3;
        private static final int QUERY_1 = 4;
        private static final int QUERY_2 = 5;
        private long _size;
        private boolean _isPrecious;
        private PnfsId _pnfsId;
        private boolean _exists = true;
        private String _destination;
        private boolean transferOk;
        private boolean stateOk;
        private Object returnObject;
        private int returnCode;
        private int state = 0;
        private long timestamp;

        private PoolFileEntry(String fileEntryString) {
            StringTokenizer st = new StringTokenizer(fileEntryString);
            this._pnfsId = new PnfsId(st.nextToken());
            this._isPrecious = st.nextToken().startsWith("<-P");
            this._size = Long.parseLong(st.nextToken());
        }

        public long getSize() {
            return this._size;
        }

        public boolean isPrecious() {
            return this._isPrecious;
        }

        public PnfsId getPnfsId() {
            return this._pnfsId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._pnfsId.toString()).append(";size=").append(this._size).append(";p=").append(this._isPrecious).append(";d=").append(this._destination == null ? "?" : this._destination).append(";").append(this.state == 0 ? "IDLE" : (this.state == 1 ? "TRANSFER" : (this.state == 2 ? "STATE" : (this.state == 3 ? "DONE" : "<unknown>")))).append(";T=").append(this.transferOk).append(";S=").append(this.stateOk).append(";");
            if (this.returnCode == 0) {
                sb.append("OK;");
            } else {
                sb.append("RC={").append(this.returnCode).append(",").append(this.returnObject == null ? "" : this.returnObject.toString()).append("}");
            }
            return sb.toString();
        }
    }

    private class PoolRepository {
        private final long _totalSize;
        private final int _fileCount;
        private final Map<String, PoolFileEntry> _map;

        private PoolRepository(Map<String, PoolFileEntry> map, int counter, long total) {
            this._map = map;
            this._fileCount = counter;
            this._totalSize = total;
        }

        public long getTotalSize() {
            return this._totalSize;
        }

        public int getFileCount() {
            return this._fileCount;
        }

        public Map<String, PoolFileEntry> getRepositoryMap() {
            return this._map;
        }
    }

    private class CopyWorker
    implements Runnable {
        private CopyWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CopyManager.this.setStatus("Waiting for pool repository of " + CopyManager.this._source);
                PoolRepository rep = CopyManager.this.getExtendedPoolRepository(CopyManager.this._source, CopyManager.this._repositoryTimeout);
                Object object = CopyManager.this._processLock;
                synchronized (object) {
                    CopyManager.this._poolRepository = rep;
                }
                CopyManager.this.setStatus("Processing " + rep.getFileCount() + " files");
                this.processFiles(CopyManager.this._poolRepository.getRepositoryMap());
                CopyManager.this.setStatus("Done with " + rep.getFileCount() + " files");
            }
            catch (Exception ee) {
                CopyManager.this.setStatus("Run  stopped : " + ee);
            }
            finally {
                Object object = CopyManager.this._processLock;
                synchronized (object) {
                    CopyManager.this._isActive = false;
                    CopyManager.this._parameter._finished = System.currentTimeMillis();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFiles(Map<String, PoolFileEntry> map) throws InterruptedException {
            Thread us = Thread.currentThread();
            int poolIndex = 0;
            for (PoolFileEntry entry : map.values()) {
                if (!CopyManager.this._precious || entry.isPrecious()) {
                    entry._destination = CopyManager.this._destination[poolIndex];
                    _log.info("Next entry to process : " + entry);
                    Object object = CopyManager.this._processLock;
                    synchronized (object) {
                        while (!us.isInterrupted() && !CopyManager.this._parameter._stopped && CopyManager.this._parameter._currentlyActive >= CopyManager.this._parameter._maxActive) {
                            CopyManager.this._processLock.wait();
                        }
                        if (CopyManager.this._parameter._stopped) {
                            break;
                        }
                        _log.info("Starting query for : " + entry);
                        CopyManager.this.sendQuery(entry);
                        _log.info("Starting transfer Done for : " + entry);
                    }
                }
                poolIndex = (poolIndex + 1) % CopyManager.this._destination.length;
            }
            _log.info(CopyManager.this._parameter._stopped ? "processing stopped" : "All files submitted");
            Object object = CopyManager.this._processLock;
            synchronized (object) {
                _log.info("Waiting for residual transfers to be finished : " + CopyManager.this._parameter._currentlyActive);
                while (!us.isInterrupted() && CopyManager.this._parameter._currentlyActive > 0) {
                    CopyManager.this._processLock.wait();
                }
                if (us.isInterrupted()) {
                    throw new InterruptedException("Interrupted in 'adjust status' loop");
                }
            }
            _log.info("Finished");
        }
    }

    private class Parameter {
        private PoolCellInfo _sourceInfo;
        private PoolCellInfo[] _destinationInfo;
        private long _started;
        private long _finished;
        private int _filesFinished;
        private long _bytesFinished;
        private int _filesFailed;
        private long _bytesFailed;
        private int _currentlyActive;
        private int _maxActive = 4;
        private boolean _stopped;

        private Parameter() {
        }

        public void reset() {
            this._sourceInfo = null;
            this._destinationInfo = null;
            this._filesFinished = 0;
            this._bytesFinished = 0L;
            this._filesFailed = 0;
            this._bytesFailed = 0L;
            this._maxActive = 4;
            this._currentlyActive = 0;
            this._stopped = false;
            this._started = System.currentTimeMillis();
            this._finished = 0L;
        }

        public String toString() {
            return "Progress(f,b)=" + this._filesFinished + "," + this._bytesFinished + ";Failed(f,b)=" + this._filesFailed + "," + this._bytesFailed + ";Active(c,m)=" + this._currentlyActive + "," + this._maxActive;
        }

        static /* synthetic */ PoolCellInfo[] access$2402(Parameter x0, PoolCellInfo[] x1) {
            x0._destinationInfo = x1;
            return x1;
        }
    }
}

