/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.pools;

import java.io.Serializable;

public class PoolV2Mode
implements Serializable {
    private static final long serialVersionUID = -3620447515380724292L;
    public static final int ENABLED = 0;
    public static final int DISABLED = 1;
    public static final int DISABLED_FETCH = 2;
    public static final int DISABLED_STORE = 4;
    public static final int DISABLED_STAGE = 8;
    public static final int DISABLED_P2P_CLIENT = 16;
    public static final int DISABLED_P2P_SERVER = 32;
    public static final int DISABLED_DEAD = 64;
    public static final int DISABLED_STRICT = 63;
    public static final int DISABLED_RDONLY = 29;
    private static final String[] __modeString = new String[]{"fetch", "store", "stage", "p2p-client", "p2p-server", "dead"};
    private int _mode = 0;

    public String toString() {
        int mode = this.getMode();
        if (mode == 0) {
            return "enabled";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("disabled(");
        boolean first = true;
        for (String modeString : __modeString) {
            if (((mode >>= 1) & 1) == 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(modeString);
        }
        sb.append(")");
        return sb.toString();
    }

    public PoolV2Mode() {
        this(0);
    }

    public PoolV2Mode(int mode) {
        this._mode = mode;
    }

    public synchronized void setMode(int mode) {
        this._mode = mode == 0 ? 0 : mode | 1;
    }

    public synchronized int getMode() {
        return this._mode;
    }

    public synchronized boolean isDisabled(int mask) {
        return (this._mode & mask) == mask;
    }

    public synchronized boolean isDisabled() {
        return this._mode != 0;
    }

    public synchronized boolean isEnabled() {
        return this._mode == 0;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PoolV2Mode)) {
            return false;
        }
        return ((PoolV2Mode)obj)._mode == this._mode;
    }

    public synchronized int hashCode() {
        return this._mode;
    }
}

