/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.pools;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PoolCostInfo
implements Serializable {
    private static final long serialVersionUID = 5181562551679185500L;
    private PoolQueueInfo _store;
    private PoolQueueInfo _restore;
    private PoolQueueInfo _mover;
    private PoolQueueInfo _p2p;
    private PoolQueueInfo _p2pClient;
    private Map<String, NamedPoolQueueInfo> _extendedMoverHash;
    private final String _defaultQueueName;
    private PoolSpaceInfo _space;
    private final String _poolName;
    private double _moverCostFactor;

    public PoolCostInfo(String poolName) {
        this._poolName = poolName;
        this._defaultQueueName = "regular";
    }

    public String getPoolName() {
        return this._poolName;
    }

    public PoolQueueInfo getStoreQueue() {
        return this._store;
    }

    public PoolQueueInfo getRestoreQueue() {
        return this._restore;
    }

    public PoolQueueInfo getMoverQueue() {
        return this._mover;
    }

    public PoolQueueInfo getP2pQueue() {
        return this._p2p;
    }

    public PoolQueueInfo getP2pClientQueue() {
        return this._p2pClient;
    }

    public PoolSpaceInfo getSpaceInfo() {
        return this._space;
    }

    public Map<String, NamedPoolQueueInfo> getMoverQueues() {
        HashMap moverQueues = this._extendedMoverHash != null ? Maps.newHashMap(this._extendedMoverHash) : Maps.newHashMap();
        if (this._store != null) {
            moverQueues.put("Stores", new NamedPoolQueueInfo("Stores", this._store));
        }
        if (this._restore != null) {
            moverQueues.put("Restores", new NamedPoolQueueInfo("Restores", this._restore));
        }
        if (this._mover != null) {
            moverQueues.put("Movers", new NamedPoolQueueInfo("Movers", this._mover));
        }
        if (this._p2p != null) {
            moverQueues.put("P2P-Server", new NamedPoolQueueInfo("P2P-Server", this._p2p));
        }
        if (this._p2pClient != null) {
            moverQueues.put("P2P-Client", new NamedPoolQueueInfo("P2P-Client", this._p2pClient));
        }
        return moverQueues;
    }

    public void setSpaceUsage(long total, long free, long precious, long removable) {
        this._space = new PoolSpaceInfo(total, free, precious, removable);
    }

    public void setSpaceUsage(long total, long free, long precious, long removable, long lru) {
        this._space = new PoolSpaceInfo(total, free, precious, removable, lru);
    }

    public void setQueueSizes(int moverActive, int moverMaxActive, int moverQueued, int restoreActive, int restoreMaxActive, int restoreQueued, int storeActive, int storeMaxActive, int storeQueued) {
        this._mover = new PoolQueueInfo(moverActive, moverMaxActive, moverQueued, 0, 0);
        this._restore = new PoolQueueInfo(restoreActive, restoreMaxActive, restoreQueued, 0, restoreActive + restoreQueued);
        this._store = new PoolQueueInfo(storeActive, storeMaxActive, storeQueued, storeActive + storeQueued, 0);
    }

    public void addExtendedMoverQueueSizes(String name, int moverActive, int moverMaxActive, int moverQueued, int moverReaders, int moverWriters) {
        NamedPoolQueueInfo info = new NamedPoolQueueInfo(name, moverActive, moverMaxActive, moverQueued, moverReaders, moverWriters);
        if (this._extendedMoverHash == null) {
            this._extendedMoverHash = new HashMap<String, NamedPoolQueueInfo>();
        }
        this._extendedMoverHash.put(name, info);
    }

    public Map<String, NamedPoolQueueInfo> getExtendedMoverHash() {
        return this._extendedMoverHash;
    }

    public String getDefaultQueueName() {
        return this._defaultQueueName;
    }

    public void setP2pServerQueueSizes(int p2pActive, int p2pMaxActive, int p2pQueued) {
        this._p2p = new PoolQueueInfo(p2pActive, p2pMaxActive, p2pQueued, p2pActive + p2pQueued, 0);
    }

    public void setP2pClientQueueSizes(int p2pClientActive, int p2pClientMaxActive, int p2pClientQueued) {
        this._p2pClient = new PoolQueueInfo(p2pClientActive, p2pClientMaxActive, p2pClientQueued, 0, p2pClientActive + p2pClientQueued);
    }

    public void setMoverCostFactor(double moverCostFactor) {
        this._moverCostFactor = moverCostFactor;
    }

    public double getMoverCostFactor() {
        return this._moverCostFactor;
    }

    public int getWriters() {
        int writers = 0;
        if (this._store != null) {
            writers += this._store.getWriters();
        }
        if (this._restore != null) {
            writers += this._restore.getWriters();
        }
        if (this._p2p != null) {
            writers += this._p2p.getWriters();
        }
        if (this._p2pClient != null) {
            writers += this._p2pClient.getWriters();
        }
        if (this._extendedMoverHash != null) {
            for (PoolQueueInfo poolQueueInfo : this._extendedMoverHash.values()) {
                writers += poolQueueInfo.getWriters();
            }
        } else if (this._mover != null) {
            writers += this._mover.getWriters();
        }
        return writers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._poolName).append("={R={").append(this._restore.toString()).append("};S={").append(this._store.toString()).append("};M={").append(this._mover.toString());
        if (this._p2p != null) {
            sb.append("};PS={").append(this._p2p.toString());
        }
        if (this._p2pClient != null) {
            sb.append("};PC={").append(this._p2pClient.toString());
        }
        sb.append("};SP={").append(this._space.toString()).append("};");
        if (this._extendedMoverHash != null) {
            sb.append("XM={");
            for (PoolQueueInfo poolQueueInfo : this._extendedMoverHash.values()) {
                sb.append(poolQueueInfo.toString()).append(";");
            }
            sb.append("};");
        }
        sb.append("}");
        return sb.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this._moverCostFactor = 0.5;
        stream.defaultReadObject();
    }

    public class PoolSpaceInfo
    implements Serializable {
        private static final long serialVersionUID = -8966065301943351970L;
        private long _total;
        private long _free;
        private long _precious;
        private long _removable;
        private long _lru;
        private long _gap;
        private double _breakEven;

        private PoolSpaceInfo(long total, long free, long precious, long removable) {
            this(total, free, precious, removable, 0L);
        }

        private PoolSpaceInfo(long total, long free, long precious, long removable, long lru) {
            if (total < free) {
                throw new IllegalArgumentException("total >= free");
            }
            if (total < precious) {
                throw new IllegalArgumentException("total >= precious");
            }
            if (total < removable) {
                throw new IllegalArgumentException("total >= removable");
            }
            this._total = total;
            this._free = free;
            this._precious = precious;
            this._removable = removable;
            this._lru = lru;
        }

        public void setParameter(double breakEven, long gap) {
            this._breakEven = breakEven;
            this._gap = gap;
        }

        public String toString() {
            return "t=" + this._total + ";f=" + this._free + ";p=" + this._precious + ";r=" + this._removable + ";lru=" + this._lru + ";{g=" + this._gap + ";b=" + this._breakEven + "}";
        }

        public long getFreeSpace() {
            return this._free;
        }

        public long getTotalSpace() {
            return this._total;
        }

        public long getPreciousSpace() {
            return this._precious;
        }

        public long getRemovableSpace() {
            return this._removable;
        }

        public long getUsedSpace() {
            return this._total - this._free;
        }

        public long getPinnedSpace() {
            return this._total - this._free - this._precious - this._removable;
        }

        public long getGap() {
            return this._gap;
        }

        public double getBreakEven() {
            return this._breakEven;
        }

        public long getLRUSeconds() {
            return this._lru;
        }

        public void modifyPinnedSpace(long diff) {
            this._free = Math.max(0L, Math.min(this._free - diff, this._total - this._removable - this._precious));
        }
    }

    public class PoolQueueInfo
    implements Serializable {
        private static final long serialVersionUID = 1304697767284208011L;
        private int _active;
        private int _maxActive;
        private int _queued;
        private int _readers;
        private int _writers;

        private PoolQueueInfo(int active, int maxActive, int queued, int readers, int writers) {
            this._active = active;
            this._maxActive = maxActive;
            this._queued = queued;
            this._readers = readers;
            this._writers = writers;
        }

        public String toString() {
            return "a=" + this._active + ";m=" + this._maxActive + ";q=" + this._queued + ";r=" + this._readers + ";w=" + this._writers;
        }

        public int getActive() {
            return this._active;
        }

        public int getMaxActive() {
            return this._maxActive;
        }

        public int getQueued() {
            return this._queued;
        }

        public int getReaders() {
            if (this._readers + this._writers > 0 || this._active + this._queued == 0) {
                return this._readers;
            }
            if (this == PoolCostInfo.this._p2pClient) {
                return 0;
            }
            if (this == PoolCostInfo.this._p2p) {
                return this._active + this._queued;
            }
            if (this == PoolCostInfo.this._store) {
                return this._active + this._queued;
            }
            if (this == PoolCostInfo.this._restore) {
                return 0;
            }
            return (this._active + this._queued + 1) / 2;
        }

        public int getWriters() {
            if (this._readers + this._writers > 0 || this._active + this._queued == 0) {
                return this._writers;
            }
            if (this == PoolCostInfo.this._p2pClient) {
                return this._active + this._queued;
            }
            if (this == PoolCostInfo.this._p2p) {
                return 0;
            }
            if (this == PoolCostInfo.this._store) {
                return 0;
            }
            if (this == PoolCostInfo.this._restore) {
                return this._active + this._queued;
            }
            return (this._active + this._queued) / 2;
        }

        public void modifyQueue(int diff) {
            int total = Math.max(0, this._active + this._queued + diff);
            this._active = Math.min(total, this._maxActive);
            this._queued = Math.max(0, total - this._maxActive);
        }
    }

    public class NamedPoolQueueInfo
    extends PoolQueueInfo {
        private static final long serialVersionUID = -7097362707394583875L;
        private String _name;

        private NamedPoolQueueInfo(String name, int active, int maxActive, int queued, int readers, int writers) {
            super(active, maxActive, queued, readers, writers);
            this._name = name;
        }

        private NamedPoolQueueInfo(String name, PoolQueueInfo queue) {
            this(name, queue.getActive(), queue.getMaxActive(), queue.getQueued(), queue.getReaders(), queue.getWriters());
        }

        public String getName() {
            return this._name;
        }

        @Override
        public String toString() {
            return this._name + "={" + super.toString() + "}";
        }
    }
}

