/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.pools;

import diskCacheV111.pools.CostCalculatable;
import diskCacheV111.pools.PoolCostInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.MissingResourceException;

public class CostCalculationEngine
implements Serializable {
    private static final long serialVersionUID = -5879481746924995686L;
    private final Class<? extends CostCalculatable> _class;
    private transient Constructor<? extends CostCalculatable> _constructor;
    private static final Class<?>[] _classArgs = new Class[]{PoolCostInfo.class};

    public CostCalculationEngine(String algorithmClass) throws ClassNotFoundException, NoSuchMethodException {
        this._class = Class.forName(algorithmClass).asSubclass(CostCalculatable.class);
        this._constructor = this._class.getConstructor(_classArgs);
    }

    public CostCalculatable getCostCalculatable(PoolCostInfo info) throws MissingResourceException {
        Object[] args = new Object[]{info};
        try {
            CostCalculatable costCalculatable = this._constructor.newInstance(args);
            return costCalculatable;
        }
        catch (Exception ee) {
            throw new MissingResourceException("Can't create cost calculator : " + ee, this._class.getName(), info.getPoolName());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            this._constructor = this._class.getConstructor(_classArgs);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Failed to read CostCalculationEngine", e);
        }
    }
}

