/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.poolManager.UGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class Unit
implements Serializable,
PoolSelectionUnit.SelectionUnit {
    private static final long serialVersionUID = -2534629882175347637L;
    String _name;
    int _type;
    Map<String, UGroup> _uGroupList = new HashMap<String, UGroup>();

    Unit(String name, int type) {
        this._name = name;
        this._type = type;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getCanonicalName() {
        return this.getName();
    }

    private String getType() {
        switch (this._type) {
            case 1: {
                return "Store";
            }
            case 2: {
                return "DCache";
            }
            case 4: {
                return "Protocol";
            }
            case 3: {
                return "Net";
            }
        }
        return "Unknown";
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionUnitGroup> getMemberOfUnitGroups() {
        return new ArrayList<PoolSelectionUnit.SelectionUnitGroup>(this._uGroupList.values());
    }

    @Override
    public String getUnitType() {
        return this.getType();
    }

    public String toString() {
        return this._name + "  (type=" + this.getType() + ";canonical=" + this.getCanonicalName() + ";uGroups=" + this._uGroupList.size() + ")";
    }
}

