/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import com.google.common.collect.ImmutableMap;
import diskCacheV111.poolManager.PoolMonitorV5;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CheckStagePermission;
import diskCacheV111.util.CostException;
import diskCacheV111.util.DestinationCostException;
import diskCacheV111.util.ExtendedRunnable;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.SourceCostException;
import diskCacheV111.util.ThreadPool;
import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.Pool2PoolTransferMsg;
import diskCacheV111.vehicles.PoolFetchFileMessage;
import diskCacheV111.vehicles.PoolHitInfoMessage;
import diskCacheV111.vehicles.PoolMgrReplicateFileMsg;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.RestoreHandlerInfo;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.WarningPnfsFileInfoMessage;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.UOID;
import dmg.util.Args;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PartitionManager;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.poolmanager.PoolSelector;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContainerV5
extends AbstractCellComponent
implements Runnable,
CellCommandListener,
CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(RequestContainerV5.class);
    private static final String POOL_UNKNOWN_STRING = "<unknown>";
    private static final String STRING_NEVER = "never";
    private static final String STRING_BESTEFFORT = "besteffort";
    private static final String STRING_NOTCHECKED = "notchecked";
    private static final int DEFAULT_RETRY_INTERVAL = 60000;
    private final Map<UOID, PoolRequestHandler> _messageHash = new HashMap<UOID, PoolRequestHandler>();
    private final Map<String, PoolRequestHandler> _handlerHash = new HashMap<String, PoolRequestHandler>();
    private String _warningPath = "billing";
    private long _retryTimer = 900000L;
    private int _maxRequestClumping = 1;
    private String _onError = "suspend";
    private int _maxRetries = 3;
    private int _maxRestore = -1;
    private CheckStagePermission _stagePolicyDecisionPoint;
    private boolean _sendHitInfo;
    private int _restoreExceeded;
    private boolean _suspendIncoming;
    private boolean _suspendStaging;
    private PoolSelectionUnit _selectionUnit;
    private PoolMonitorV5 _poolMonitor;
    private PnfsHandler _pnfsHandler;
    private final SimpleDateFormat _formatter = new SimpleDateFormat("MM.dd HH:mm:ss");
    private ThreadPool _threadPool;
    private final Map<PnfsId, CacheException> _selections = new HashMap<PnfsId, CacheException>();
    private PartitionManager _partitionManager;
    private long _checkFilePingTimer = 600000L;
    private final int _stagingRetryInterval;
    private final Thread _tickerThread;
    public static final EnumSet<RequestState> allStates = EnumSet.allOf(RequestState.class);
    public static final EnumSet<RequestState> allStatesExceptStage = EnumSet.complementOf(EnumSet.of(RequestState.ST_STAGE));
    public static final String hh_rc_set_max_threads = "<threadCount> # 0 : no limits";
    public static final String hh_rc_set_sameHostCopy = "never|besteffort|notchecked";
    public static final String hh_rc_set_sameHostRetry = "never|besteffort|notchecked";
    public static final String fh_rc_set_max_restore = "Limit total number of concurrent restores.  If the total number of\nrestores reaches this limit then any additional restores will fail;\nwhen the total number of restores drops below limit then additional\nrestores will be accepted.  Setting the limit to \"0\" will result in\nall restores failing; setting the limit to \"unlimited\" will remove\nthe limit.";
    public static final String hh_rc_set_max_restore = "<maxNumberOfRestores>";
    public static final String hh_rc_select = "[<pnfsId> [<errorNumber> [<errorMessage>]] [-remove]]";
    public static final String hh_rc_set_warning_path = " # where to send the warnings to";
    public static final String fh_rc_set_poolpingtimer = " rc set poolpingtimer <timer/seconds>     If set to a nonzero value, the restore handler will frequently    check the pool whether the request is still pending, failed    or has been successful";
    public static final String hh_rc_set_poolpingtimer = "<checkPoolFileTimer/seconds>";
    public static final String hh_rc_set_retry = "<retryTimer/seconds>";
    public static final String hh_rc_set_max_retries = "<maxNumberOfRetries>";
    public static final String hh_rc_suspend = "[on|off] -all";
    public static final String hh_rc_onerror = "suspend|fail";
    public static final String fh_rc_retry = "NAME\n           rc retry\n\nSYNOPSIS\n           I)  rc retry <pnfsId> [OPTIONS]\n           II) rc retry * -force-all [OPTIONS]\n\nDESCRIPTION\n           Forces a 'restore request' to be retried.\n           While  using syntax I, a single request  is retried,\n           syntax II retries all requests which reported an error.\n           If the '-force-all' options is given, all requests are\n           retried, regardless of their current status.\n";
    public static final String hh_rc_retry = "<pnfsId>|* -force-all";
    public static final String hh_rc_failed = "<pnfsId> [<errorNumber> [<errorMessage>]]";
    public static final String hh_rc_destroy = "<pnfsId> # !!!  use with care";
    public static final String hh_rc_ls = " [<regularExpression>] [-w] [-l] # lists pending requests";
    public static final String hh_xrc_ls = " # lists pending requests (binary)";
    public static final String hh_replicate = " <pnfsid> <client IP>";

    public RequestContainerV5(int stagingRetryInterval) {
        this._stagingRetryInterval = stagingRetryInterval;
        this._tickerThread = new Thread((Runnable)this, "Container-ticker");
        this._tickerThread.start();
    }

    public RequestContainerV5() {
        this(60000);
    }

    public void shutdown() {
        this._tickerThread.interrupt();
    }

    public void setPoolSelectionUnit(PoolSelectionUnit selectionUnit) {
        this._selectionUnit = selectionUnit;
    }

    public void setPoolMonitor(PoolMonitorV5 poolMonitor) {
        this._poolMonitor = poolMonitor;
    }

    public void setPnfsHandler(PnfsHandler pnfsHandler) {
        this._pnfsHandler = pnfsHandler;
    }

    public void setPartitionManager(PartitionManager partitionManager) {
        this._partitionManager = partitionManager;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    public void setHitInfoMessages(boolean sendHitInfo) {
        this._sendHitInfo = sendHitInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(CellMessage envelope, Object message) {
        PoolRequestHandler handler;
        UOID uoid = envelope.getLastUOID();
        Map<UOID, PoolRequestHandler> map = this._messageHash;
        synchronized (map) {
            handler = this._messageHash.remove(uoid);
            if (handler == null) {
                return;
            }
        }
        handler.mailForYou(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                ArrayList<PoolRequestHandler> list;
                Thread.sleep(this._stagingRetryInterval);
                Map<String, PoolRequestHandler> map = this._handlerHash;
                synchronized (map) {
                    list = new ArrayList<PoolRequestHandler>(this._handlerHash.values());
                }
                for (PoolRequestHandler handler : list) {
                    if (handler == null) continue;
                    handler.alive();
                }
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Throwable t) {
                Thread thisThread = Thread.currentThread();
                Thread.UncaughtExceptionHandler ueh = thisThread.getUncaughtExceptionHandler();
                ueh.uncaughtException(thisThread, t);
            }
        }
        _log.debug("Container-ticker done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poolStatusChanged(String poolName, int poolStatus) {
        _log.info("Restore Manager : got 'poolRestarted' for " + poolName);
        try {
            ArrayList<PoolRequestHandler> list;
            Map<String, PoolRequestHandler> map = this._handlerHash;
            synchronized (map) {
                list = new ArrayList<PoolRequestHandler>(this._handlerHash.values());
            }
            for (PoolRequestHandler rph : list) {
                if (rph == null) continue;
                switch (poolStatus) {
                    case 1: {
                        if (rph.getPoolCandidate().equals(POOL_UNKNOWN_STRING)) {
                            _log.info("Restore Manager : retrying : " + rph);
                            rph.retry();
                        }
                    }
                    case 2: {
                        if (!rph.getPoolCandidate().equals(poolName)) break;
                        _log.info("Restore Manager : retrying : " + rph);
                        rph.retry();
                    }
                }
            }
        }
        catch (RuntimeException e) {
            _log.error("Problem retrying pool " + poolName, (Throwable)e);
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        Partition def = this._partitionManager.getDefaultPartition();
        pw.println("Restore Controller [$Revision$]\n");
        pw.println("      Retry Timeout : " + this._retryTimer / 1000L + " seconds");
        pw.println("  Thread Controller : " + this._threadPool);
        pw.println("    Maximum Retries : " + this._maxRetries);
        pw.println("    Pool Ping Timer : " + this._checkFilePingTimer / 1000L + " seconds");
        pw.println("           On Error : " + this._onError);
        pw.println("       Warning Path : " + this._warningPath);
        pw.println("          Allow p2p : " + (def._p2pAllowed ? "on" : "off") + " oncost=" + (def._p2pOnCost ? "on" : "off") + " fortransfer=" + (def._p2pForTransfer ? "on" : "off"));
        pw.println("      Allow staging : " + (def._hasHsmBackend ? "on" : "off"));
        pw.println("Allow stage on cost : " + (def._stageOnCost ? "on" : "off"));
        pw.println("      Restore Limit : " + (this._maxRestore < 0 ? "unlimited" : "" + this._maxRestore));
        pw.println("   Restore Exceeded : " + this._restoreExceeded);
        if (this._suspendIncoming) {
            pw.println("   Suspend Incoming : on (not persistent)");
        }
        if (this._suspendStaging) {
            pw.println("   Suspend Staging  : on (not persistent)");
        }
    }

    @Override
    public void printSetup(PrintWriter pw) {
        pw.append("#\n# Submodule [rc] : ").append(this.getClass().toString()).append("\n#\n");
        pw.append("rc onerror ").println(this._onError);
        pw.append("rc set max retries ").println(this._maxRetries);
        pw.append("rc set retry ").println(this._retryTimer / 1000L);
        pw.append("rc set warning path ").println(this._warningPath);
        pw.append("rc set poolpingtimer ").println(this._checkFilePingTimer / 1000L);
        pw.append("rc set max restore ").println(this._maxRestore < 0 ? "unlimited" : "" + this._maxRestore);
        pw.append("rc set max threads ").println(this._threadPool.getMaxThreadCount());
    }

    public String ac_rc_set_max_threads_$_1(Args args) {
        int n = Integer.parseInt(args.argv(0));
        this._threadPool.setMaxThreadCount(n);
        return "New max thread count : " + n;
    }

    public String ac_rc_set_sameHostCopy_$_1(Args args) {
        this._partitionManager.setProperties("default", (Map<String, String>)ImmutableMap.of((Object)"sameHostCopy", (Object)args.argv(0)));
        return "";
    }

    public String ac_rc_set_sameHostRetry_$_1(Args args) {
        this._partitionManager.setProperties("default", (Map<String, String>)ImmutableMap.of((Object)"sameHostRetry", (Object)args.argv(0)));
        return "";
    }

    public String ac_rc_set_max_restore_$_1(Args args) {
        if (args.argv(0).equals("unlimited")) {
            this._maxRestore = -1;
            return "";
        }
        int n = Integer.parseInt(args.argv(0));
        if (n < 0) {
            throw new IllegalArgumentException("must be >=0");
        }
        this._maxRestore = n;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_rc_select_$_0_3(Args args) {
        Map<PnfsId, CacheException> map = this._selections;
        synchronized (map) {
            if (args.argc() == 0) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<PnfsId, CacheException> entry : this._selections.entrySet()) {
                    sb.append(entry.getKey().toString()).append("  ").append(entry.getValue().toString()).append("\n");
                }
                return sb.toString();
            }
            boolean remove = args.hasOption("remove");
            PnfsId pnfsId = new PnfsId(args.argv(0));
            if (remove) {
                this._selections.remove(pnfsId);
                return "";
            }
            int errorNumber = args.argc() > 1 ? Integer.parseInt(args.argv(1)) : 1;
            String errorMessage = args.argc() > 2 ? args.argv(2) : "Failed-" + errorNumber;
            this._selections.put(pnfsId, new CacheException(errorNumber, errorMessage));
        }
        return "";
    }

    public String ac_rc_set_warning_path_$_0_1(Args args) {
        if (args.argc() > 0) {
            this._warningPath = args.argv(0);
        }
        return this._warningPath;
    }

    public String ac_rc_set_poolpingtimer_$_1(Args args) {
        this._checkFilePingTimer = 1000L * Long.parseLong(args.argv(0));
        return "";
    }

    public String ac_rc_set_retry_$_1(Args args) {
        this._retryTimer = 1000L * Long.parseLong(args.argv(0));
        return "";
    }

    public String ac_rc_set_max_retries_$_1(Args args) {
        this._maxRetries = Integer.parseInt(args.argv(0));
        return "";
    }

    public String ac_rc_suspend_$_0_1(Args args) {
        boolean all = args.hasOption("all");
        if (args.argc() == 0) {
            if (all) {
                this._suspendIncoming = true;
            }
            this._suspendStaging = true;
        } else {
            String mode;
            switch (mode = args.argv(0)) {
                case "on": {
                    if (all) {
                        this._suspendIncoming = true;
                    }
                    this._suspendStaging = true;
                    break;
                }
                case "off": {
                    if (all) {
                        this._suspendIncoming = false;
                    }
                    this._suspendStaging = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Usage : rc suspend [on|off]");
                }
            }
        }
        return "";
    }

    public String ac_rc_onerror_$_1(Args args) {
        String onerror = args.argv(0);
        if (!onerror.equals("suspend") && !onerror.equals("fail")) {
            throw new IllegalArgumentException("Usage : rc onerror fail|suspend");
        }
        this._onError = onerror;
        return "onerror " + this._onError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_rc_retry_$_1(Args args) {
        boolean forceAll = args.hasOption("force-all");
        if (args.argv(0).equals("*")) {
            ArrayList<PoolRequestHandler> all;
            Map<String, PoolRequestHandler> map = this._handlerHash;
            synchronized (map) {
                all = new ArrayList<PoolRequestHandler>(this._handlerHash.values());
            }
            for (PoolRequestHandler rph : all) {
                if (!forceAll && rph._currentRc == 0) continue;
                rph.retry();
            }
        } else {
            PoolRequestHandler rph;
            Map<String, PoolRequestHandler> map = this._handlerHash;
            synchronized (map) {
                rph = this._handlerHash.get(args.argv(0));
                if (rph == null) {
                    throw new IllegalArgumentException("Not found : " + args.argv(0));
                }
            }
            rph.retry();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_rc_failed_$_1_3(Args args) {
        PoolRequestHandler rph;
        int errorNumber = args.argc() > 1 ? Integer.parseInt(args.argv(1)) : 1;
        String errorString = args.argc() > 2 ? args.argv(2) : "Operator Intervention";
        Map<String, PoolRequestHandler> map = this._handlerHash;
        synchronized (map) {
            rph = this._handlerHash.get(args.argv(0));
            if (rph == null) {
                throw new IllegalArgumentException("Not found : " + args.argv(0));
            }
        }
        rph.failed(errorNumber, errorString);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_rc_destroy_$_1(Args args) {
        Map<String, PoolRequestHandler> map = this._handlerHash;
        synchronized (map) {
            PoolRequestHandler rph = this._handlerHash.get(args.argv(0));
            if (rph == null) {
                throw new IllegalArgumentException("Not found : " + args.argv(0));
            }
            this._handlerHash.remove(args.argv(0));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_rc_ls_$_0_1(Args args) {
        StringBuilder sb = new StringBuilder();
        Pattern pattern = args.argc() > 0 ? Pattern.compile(args.argv(0)) : null;
        boolean isLongListing = args.hasOption("l");
        if (!args.hasOption("w")) {
            ArrayList<PoolRequestHandler> allRequestHandlers;
            Map<String, PoolRequestHandler> map = this._handlerHash;
            synchronized (map) {
                allRequestHandlers = new ArrayList<PoolRequestHandler>(this._handlerHash.values());
            }
            for (PoolRequestHandler poolRequestHandler : allRequestHandlers) {
                if (poolRequestHandler == null) continue;
                String line = poolRequestHandler.toString();
                if (pattern != null && !pattern.matcher(line).matches()) continue;
                sb.append(line).append("\n");
                if (!isLongListing) continue;
                for (CellMessage m : poolRequestHandler.getMessages()) {
                    PoolMgrSelectReadPoolMsg request = (PoolMgrSelectReadPoolMsg)m.getMessageObject();
                    sb.append("    ").append(request.getProtocolInfo()).append('\n');
                }
            }
        } else {
            HashMap<UOID, PoolRequestHandler> allPendingRequestHandlers = new HashMap<UOID, PoolRequestHandler>();
            Map<UOID, PoolRequestHandler> i$ = this._messageHash;
            synchronized (i$) {
                allPendingRequestHandlers.putAll(this._messageHash);
            }
            for (Map.Entry entry : allPendingRequestHandlers.entrySet()) {
                UOID uoid = (UOID)entry.getKey();
                PoolRequestHandler h = (PoolRequestHandler)entry.getValue();
                if (h == null) continue;
                String line = uoid.toString() + " " + h.toString();
                if (pattern != null && !pattern.matcher(line).matches()) continue;
                sb.append(line).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ac_xrc_ls(Args args) {
        ArrayList<PoolRequestHandler> all;
        Map<String, PoolRequestHandler> map = this._handlerHash;
        synchronized (map) {
            all = new ArrayList<PoolRequestHandler>(this._handlerHash.values());
        }
        ArrayList<RestoreHandlerInfo> list = new ArrayList<RestoreHandlerInfo>();
        for (PoolRequestHandler h : all) {
            if (h == null) continue;
            list.add(h.getRestoreHandlerInfo());
        }
        return list.toArray(new RestoreHandlerInfo[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(CellMessage envelope, PoolMgrSelectReadPoolMsg request) throws PatternSyntaxException, IOException {
        boolean enforceP2P = false;
        PnfsId pnfsId = request.getPnfsId();
        ProtocolInfo protocolInfo = request.getProtocolInfo();
        EnumSet<RequestState> allowedStates = request.getAllowedStates();
        String hostName = protocolInfo instanceof IpProtocolInfo ? ((IpProtocolInfo)protocolInfo).getSocketAddress().getAddress().getHostAddress() : "NoSuchHost";
        String netName = this._selectionUnit.getNetIdentifier(hostName);
        String protocolNameFromInfo = protocolInfo.getProtocol() + "/" + protocolInfo.getMajorVersion();
        String protocolName = this._selectionUnit.getProtocolUnit(protocolNameFromInfo);
        if (protocolName == null) {
            throw new IllegalArgumentException("Protocol not found : " + protocolNameFromInfo);
        }
        if (request instanceof PoolMgrReplicateFileMsg) {
            if (request.isReply()) {
                _log.warn("Unexpected PoolMgrReplicateFileMsg arrived (is a reply)");
                return;
            }
            enforceP2P = true;
        }
        String canonicalName = pnfsId + "@" + netName + "-" + protocolName + (enforceP2P ? "-p2p" : "");
        _log.info("Adding request for : " + canonicalName);
        Map<String, PoolRequestHandler> map = this._handlerHash;
        synchronized (map) {
            PoolRequestHandler handler = this._handlerHash.get(canonicalName);
            if (handler == null) {
                handler = new PoolRequestHandler(pnfsId, canonicalName, allowedStates);
                this._handlerHash.put(canonicalName, handler);
            }
            handler.addRequest(envelope);
        }
    }

    public String ac_replicate_$_2(Args args) {
        String commandReply = "Replication initiated...";
        try {
            FileAttributes fileAttributes = this._pnfsHandler.getFileAttributes(new PnfsId(args.argv(0)), PoolMgrReplicateFileMsg.getRequiredAttributes());
            PoolMgrReplicateFileMsg req = new PoolMgrReplicateFileMsg(fileAttributes, new DCapProtocolInfo("DCap", 3, 0, new InetSocketAddress(args.argv(1), 2222)));
            this.sendMessage(new CellMessage(new CellPath("PoolManager"), (Serializable)req));
        }
        catch (NoRouteToCellException e) {
            commandReply = "P2P failed : " + e.getMessage();
        }
        catch (CacheException e) {
            commandReply = "P2P failed : " + e.getMessage();
        }
        return commandReply;
    }

    private void sendInfoMessage(PnfsId pnfsId, StorageInfo storageInfo, int rc, String infoMessage) {
        try {
            WarningPnfsFileInfoMessage info = new WarningPnfsFileInfoMessage("PoolManager", "PoolManager", pnfsId, rc, infoMessage);
            info.setStorageInfo(storageInfo);
            this.sendMessage(new CellMessage(new CellPath(this._warningPath), (Serializable)info));
        }
        catch (NoRouteToCellException e) {
            _log.warn("Couldn't send WarningInfoMessage: {}", (Object)e.toString());
        }
    }

    private void sendHitMsg(PnfsId pnfsId, String poolName, boolean cached) {
        try {
            PoolHitInfoMessage msg = new PoolHitInfoMessage(poolName, pnfsId);
            msg.setFileCached(cached);
            this.sendMessage(new CellMessage(new CellPath(this._warningPath), (Serializable)msg));
        }
        catch (NoRouteToCellException e) {
            _log.warn("Couldn't report hit info for {}: {}", (Object)pnfsId, (Object)e.toString());
        }
    }

    public void setStageConfigurationFile(String path) {
        this._stagePolicyDecisionPoint = new CheckStagePermission(path);
    }

    static /* synthetic */ long access$500(RequestContainerV5 x0) {
        return x0._checkFilePingTimer;
    }

    static /* synthetic */ PartitionManager access$700(RequestContainerV5 x0) {
        return x0._partitionManager;
    }

    private class PoolRequestHandler {
        protected PnfsId _pnfsId;
        protected final List<CellMessage> _messages = new ArrayList<CellMessage>();
        protected int _retryCounter;
        private final CDC _cdc = new CDC();
        private UOID _waitingFor;
        private long _waitUntil;
        private String _status = "[<idle>]";
        private RequestState _state = RequestState.ST_INIT;
        private final Collection<RequestState> _allowedStates;
        private boolean _stagingDenied;
        private int _currentRc;
        private String _currentRm = "";
        private PoolInfo _bestPool;
        private PoolInfo _poolCandidate;
        private String _stageCandidateHost;
        private String _stageCandidatePool;
        private PoolInfo _p2pDestinationPool;
        private PoolInfo _p2pSourcePool;
        private final long _started = System.currentTimeMillis();
        private String _name;
        private FileAttributes _fileAttributes;
        private StorageInfo _storageInfo;
        private ProtocolInfo _protocolInfo;
        private String _linkGroup;
        private boolean _enforceP2P;
        private int _destinationFileStatus = 0;
        private CheckFilePingHandler _pingHandler = new CheckFilePingHandler(RequestContainerV5.access$500(RequestContainerV5.this));
        private PoolSelector _poolSelector;
        private Partition _parameter = RequestContainerV5.access$700(RequestContainerV5.this).getDefaultPartition();
        private long _nextTtlTimeout = Long.MAX_VALUE;
        private static final int RT_OK = 1;
        private static final int RT_FOUND = 2;
        private static final int RT_NOT_FOUND = 3;
        private static final int RT_ERROR = 4;
        private static final int RT_OUT_OF_RESOURCES = 5;
        private static final int RT_COST_EXCEEDED = 7;
        private static final int RT_NOT_PERMITTED = 8;
        private static final int RT_S_COST_EXCEEDED = 9;
        private static final int RT_DELAY = 10;
        private static final int CONTINUE = 0;
        private static final int WAIT = 1;
        private final Deque<Object> _fifo = new LinkedList<Object>();
        private boolean _stateEngineActive;
        private boolean _forceContinue;
        private boolean _overwriteCost;

        public PoolRequestHandler(PnfsId pnfsId, String canonicalName, Collection<RequestState> allowedStates) {
            this._pnfsId = pnfsId;
            this._name = canonicalName;
            this._allowedStates = allowedStates;
        }

        public void addRequest(CellMessage message) {
            this._messages.add(message);
            this._stagingDenied = false;
            long ttl = message.getTtl();
            if (ttl < Long.MAX_VALUE) {
                long timeout = System.currentTimeMillis() + ttl;
                this._nextTtlTimeout = Math.min(this._nextTtlTimeout, timeout);
            }
            if (this._poolSelector != null) {
                return;
            }
            PoolMgrSelectReadPoolMsg request = (PoolMgrSelectReadPoolMsg)message.getMessageObject();
            this._linkGroup = request.getLinkGroup();
            this._protocolInfo = request.getProtocolInfo();
            this._fileAttributes = request.getFileAttributes();
            this._storageInfo = this._fileAttributes.getStorageInfo();
            this._retryCounter = request.getContext().getRetryCounter();
            this._stageCandidateHost = request.getContext().getPreviousStageHost();
            this._stageCandidatePool = request.getContext().getPreviousStagePool();
            if (request instanceof PoolMgrReplicateFileMsg) {
                this._enforceP2P = true;
                this._destinationFileStatus = ((PoolMgrReplicateFileMsg)request).getDestinationFileStatus();
            }
            this._poolSelector = RequestContainerV5.this._poolMonitor.getPoolSelector(this._fileAttributes, this._protocolInfo, this._linkGroup);
            this.add(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CellMessage> getMessages() {
            Map map = RequestContainerV5.this._handlerHash;
            synchronized (map) {
                return new ArrayList<CellMessage>(this._messages);
            }
        }

        public String getPoolCandidate() {
            if (this._poolCandidate != null) {
                return this._poolCandidate.getName();
            }
            if (this._p2pDestinationPool != null) {
                return this._p2pDestinationPool.getName();
            }
            return RequestContainerV5.POOL_UNKNOWN_STRING;
        }

        private String getPoolCandidateState() {
            if (this._poolCandidate != null) {
                return this._poolCandidate.getName();
            }
            if (this._p2pDestinationPool != null) {
                return (this._p2pSourcePool == null ? RequestContainerV5.POOL_UNKNOWN_STRING : this._p2pSourcePool) + "->" + this._p2pDestinationPool;
            }
            return RequestContainerV5.POOL_UNKNOWN_STRING;
        }

        public RestoreHandlerInfo getRestoreHandlerInfo() {
            return new RestoreHandlerInfo(this._name, this._messages.size(), this._retryCounter, this._started, this.getPoolCandidateState(), this._status, this._currentRc, this._currentRm);
        }

        public String toString() {
            return this._name + " m=" + this._messages.size() + " r=" + this._retryCounter + " [" + this.getPoolCandidateState() + "] [" + this._status + "] " + "{" + this._currentRc + "," + this._currentRm + "}";
        }

        private void mailForYou(Object message) {
            this.add(message);
        }

        private void alive() {
            Object[] command = new Object[]{"alive"};
            this.add(command);
        }

        private void retry() {
            Object[] command = new Object[]{"retry"};
            this.add(command);
        }

        private void failed(int errorNumber, String errorMessage) {
            if (errorNumber > 0) {
                Object[] command = new Object[]{"failed", errorNumber, errorMessage == null ? "Error-" + this._currentRc : errorMessage};
                this.add(command);
                return;
            }
            throw new IllegalArgumentException("Error number must be > 0");
        }

        private void waitFor(long millis) {
            this._waitUntil = System.currentTimeMillis() + millis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearSteering() {
            Map map = RequestContainerV5.this._messageHash;
            synchronized (map) {
                if (this._waitingFor != null) {
                    RequestContainerV5.this._messageHash.remove(this._waitingFor);
                }
            }
            this._waitingFor = null;
            this._waitUntil = 0L;
            this._pingHandler.stop();
        }

        private void setError(int errorCode, String errorMessage) {
            this._currentRc = errorCode;
            this._currentRm = errorMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean sendFetchRequest(PoolInfo pool) throws NoRouteToCellException {
            CellMessage cellMessage = new CellMessage(new CellPath(pool.getAddress()), (Serializable)new PoolFetchFileMessage(pool.getName(), this._fileAttributes));
            Map map = RequestContainerV5.this._messageHash;
            synchronized (map) {
                if (RequestContainerV5.this._maxRestore >= 0 && RequestContainerV5.this._messageHash.size() >= RequestContainerV5.this._maxRestore) {
                    return false;
                }
                RequestContainerV5.this.sendMessage(cellMessage);
                RequestContainerV5.this._poolMonitor.messageToCostModule(cellMessage);
                this._waitingFor = cellMessage.getUOID();
                RequestContainerV5.this._messageHash.put(this._waitingFor, this);
                this._status = "Staging " + RequestContainerV5.this._formatter.format(new Date());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendPool2PoolRequest(PoolInfo sourcePool, PoolInfo destPool) throws NoRouteToCellException {
            Pool2PoolTransferMsg pool2pool = new Pool2PoolTransferMsg(sourcePool.getName(), destPool.getName(), this._fileAttributes);
            pool2pool.setDestinationFileStatus(this._destinationFileStatus);
            _log.info("[p2p] Sending transfer request: " + pool2pool);
            CellMessage cellMessage = new CellMessage(new CellPath(destPool.getAddress()), (Serializable)pool2pool);
            Map map = RequestContainerV5.this._messageHash;
            synchronized (map) {
                RequestContainerV5.this.sendMessage(cellMessage);
                RequestContainerV5.this._poolMonitor.messageToCostModule(cellMessage);
                if (this._waitingFor != null) {
                    RequestContainerV5.this._messageHash.remove(this._waitingFor);
                }
                this._waitingFor = cellMessage.getUOID();
                RequestContainerV5.this._messageHash.put(this._waitingFor, this);
                this._status = "[P2P " + RequestContainerV5.this._formatter.format(new Date()) + "]";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expireRequests() {
            Map map = RequestContainerV5.this._handlerHash;
            synchronized (map) {
                long now = System.currentTimeMillis();
                this._nextTtlTimeout = Long.MAX_VALUE;
                Iterator<CellMessage> i = this._messages.iterator();
                while (i.hasNext()) {
                    CellMessage message = i.next();
                    long ttl = message.getTtl();
                    if (message.getLocalAge() >= ttl) {
                        _log.info("Discarding request from " + message.getSourcePath().getCellName() + " because its time to live has been exceeded.");
                        i.remove();
                        continue;
                    }
                    if (ttl >= Long.MAX_VALUE) continue;
                    this._nextTtlTimeout = Math.min(this._nextTtlTimeout, now + ttl);
                }
            }
        }

        private boolean answerRequest(int count) {
            if (this._currentRc != 0) {
                count = 100000;
            }
            Iterator<CellMessage> messages = this._messages.iterator();
            for (int i = 0; i < count && messages.hasNext(); ++i) {
                CellMessage m = messages.next();
                PoolMgrSelectReadPoolMsg rpm = (PoolMgrSelectReadPoolMsg)m.getMessageObject();
                rpm.setContext(this._retryCounter + 1, this._stageCandidateHost, this._stageCandidatePool);
                if (this._currentRc == 0) {
                    rpm.setPoolName(this._poolCandidate.getName());
                    rpm.setPoolAddress(this._poolCandidate.getAddress());
                    rpm.setSucceeded();
                } else {
                    rpm.setFailed(this._currentRc, (Serializable)((Object)this._currentRm));
                }
                try {
                    m.revertDirection();
                    RequestContainerV5.this.sendMessage(m);
                    RequestContainerV5.this._poolMonitor.messageToCostModule(m);
                    if (!rpm.getSkipCostUpdate()) {
                        RequestContainerV5.this._poolMonitor.messageToCostModule(m);
                    }
                }
                catch (NoRouteToCellException e) {
                    _log.warn("Exception answering request: {}", (Object)e.toString());
                }
                messages.remove();
            }
            return messages.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Object obj) {
            Deque<Object> deque = this._fifo;
            synchronized (deque) {
                _log.info("Adding Object : " + obj);
                this._fifo.addFirst(obj);
                if (this._stateEngineActive) {
                    return;
                }
                _log.info("Starting Engine");
                this._stateEngineActive = true;
                try {
                    RequestContainerV5.this._threadPool.invokeLater(new RunEngine(), "Read-" + this._pnfsId);
                }
                catch (RuntimeException e) {
                    this._stateEngineActive = false;
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stateLoop() {
            _log.info("ACTIVATING STATE ENGINE " + this._pnfsId + " " + (System.currentTimeMillis() - this._started));
            while (!Thread.interrupted()) {
                Object inputObject;
                if (!this._forceContinue) {
                    Deque<Object> deque = this._fifo;
                    synchronized (deque) {
                        if (this._fifo.size() == 0) {
                            this._stateEngineActive = false;
                            return;
                        }
                        inputObject = this._fifo.removeLast();
                    }
                } else {
                    inputObject = null;
                }
                this._forceContinue = false;
                try {
                    _log.info("StageEngine called in mode " + (Object)((Object)this._state) + " with object " + (inputObject == null ? "(NULL)" : (inputObject instanceof Object[] ? ((Object[])inputObject)[0].toString() : inputObject.getClass().getName())));
                    this.stateEngine(inputObject);
                    _log.info("StageEngine left with: {} ({})", (Object)this._state, (Object)(this._forceContinue ? "Continue" : "Wait"));
                }
                catch (RuntimeException e) {
                    _log.error("Unexpected Exception in state loop for " + this._pnfsId, (Throwable)e);
                }
            }
        }

        private boolean canStage() {
            if (this._stagingDenied || !this._allowedStates.contains((Object)RequestState.ST_STAGE)) {
                return false;
            }
            for (CellMessage envelope : this._messages) {
                try {
                    PoolMgrSelectReadPoolMsg msg = (PoolMgrSelectReadPoolMsg)envelope.getMessageObject();
                    if (!RequestContainerV5.this._stagePolicyDecisionPoint.canPerformStaging(msg.getSubject(), msg.getStorageInfo())) continue;
                    return true;
                }
                catch (IOException | PatternSyntaxException e) {
                    _log.error("Failed to verify stage permissions: " + e.getMessage());
                }
            }
            this._stagingDenied = true;
            return false;
        }

        private void nextStep(RequestState state, int shouldContinue) {
            if (this._currentRc == 10016 || this._currentRc == 10001) {
                this._state = RequestState.ST_DONE;
                this._forceContinue = true;
                this._status = "Failed";
                RequestContainerV5.this.sendInfoMessage(this._pnfsId, this._storageInfo, this._currentRc, "Failed " + this._currentRm);
            } else if (state == RequestState.ST_STAGE && !this.canStage()) {
                this._state = RequestState.ST_DONE;
                this._forceContinue = true;
                this._status = "Failed";
                _log.debug("Subject is not authorized to stage");
                this._currentRc = 10019;
                this._currentRm = "File not online. Staging not allowed.";
                RequestContainerV5.this.sendInfoMessage(this._pnfsId, this._storageInfo, this._currentRc, "Permission denied." + this._currentRm);
            } else if (!this._allowedStates.contains((Object)state)) {
                this._state = RequestState.ST_DONE;
                this._forceContinue = true;
                this._status = "Failed";
                _log.debug("No permission to perform {}", (Object)state);
                this._currentRc = 10018;
                this._currentRm = "Permission denied.";
                RequestContainerV5.this.sendInfoMessage(this._pnfsId, this._storageInfo, this._currentRc, "Permission denied for " + (Object)((Object)state));
            } else {
                this._state = state;
                boolean bl = this._forceContinue = shouldContinue == 0;
                if (this._state != RequestState.ST_DONE) {
                    this._currentRc = 0;
                    this._currentRm = "";
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stateEngine(Object inputObject) {
            switch (this._state) {
                case ST_INIT: {
                    _log.debug("stateEngine: case ST_INIT");
                    Map map = RequestContainerV5.this._selections;
                    synchronized (map) {
                        CacheException ce = (CacheException)RequestContainerV5.this._selections.get(this._pnfsId);
                        if (ce != null) {
                            this.setError(ce.getRc(), ce.getMessage());
                            this.nextStep(RequestState.ST_DONE, 0);
                            return;
                        }
                    }
                    if (inputObject == null) {
                        if (RequestContainerV5.this._suspendIncoming) {
                            this.setError(1005, "Suspend enforced");
                            this.suspend("Suspended (forced)");
                            return;
                        }
                        if (this._enforceP2P) {
                            this.setError(0, "");
                            this.nextStep(RequestState.ST_POOL_2_POOL, 0);
                            return;
                        }
                        int rc = this.askIfAvailable();
                        if (rc == 2) {
                            this.setError(0, "");
                            this.nextStep(RequestState.ST_DONE, 0);
                            _log.info("AskIfAvailable found the object");
                            if (!RequestContainerV5.this._sendHitInfo) break;
                            RequestContainerV5.this.sendHitMsg(this._pnfsId, this._bestPool != null ? this._bestPool.getName() : "<UNKNOWN>", true);
                            break;
                        }
                        if (rc == 3) {
                            _log.debug(" stateEngine: RT_NOT_FOUND ");
                            if (this._parameter._hasHsmBackend && this._storageInfo.isStored()) {
                                _log.debug(" stateEngine: parameter has HSM backend and the file is stored on tape ");
                                this.nextStep(RequestState.ST_STAGE, 0);
                            } else {
                                _log.debug(" stateEngine: case 1: parameter has NO HSM backend or case 2: the HSM backend exists but the file isn't stored on it.");
                                this._poolCandidate = null;
                                this.setError(1010, "Pool unavailable");
                                this.suspendIfEnabled("Suspended (pool unavailable)");
                            }
                            if (!RequestContainerV5.this._sendHitInfo || this._poolCandidate != null) break;
                            RequestContainerV5.this.sendHitMsg(this._pnfsId, this._bestPool != null ? this._bestPool.getName() : "<UNKNOWN>", false);
                            break;
                        }
                        if (rc == 8) {
                            this._overwriteCost = true;
                            this.nextStep(this._parameter._p2pAllowed || !this._parameter._hasHsmBackend ? RequestState.ST_POOL_2_POOL : RequestState.ST_STAGE, 0);
                            break;
                        }
                        if (rc == 7) {
                            if (this._parameter._p2pOnCost) {
                                this.nextStep(RequestState.ST_POOL_2_POOL, 0);
                                break;
                            }
                            if (this._parameter._hasHsmBackend && this._parameter._stageOnCost) {
                                this.nextStep(RequestState.ST_STAGE, 0);
                                break;
                            }
                            this.setError(127, "Cost exceeded (st,p2p not allowed)");
                            this.nextStep(RequestState.ST_DONE, 0);
                            break;
                        }
                        if (rc != 4) break;
                        _log.debug(" stateEngine: RT_ERROR");
                        this.nextStep(RequestState.ST_STAGE, 0);
                        _log.info("AskIfAvailable returned an error, will continue with Staging");
                        break;
                    }
                    if (!(inputObject instanceof Object[])) break;
                    this.handleCommandObject((Object[])inputObject);
                    break;
                }
                case ST_POOL_2_POOL: {
                    _log.debug("stateEngine: case ST_POOL_2_POOL");
                    if (inputObject != null) break;
                    int rc = this.askForPoolToPool(this._overwriteCost);
                    if (rc == 2) {
                        this.nextStep(RequestState.ST_WAITING_FOR_POOL_2_POOL, 1);
                        this._status = "Pool2Pool " + RequestContainerV5.this._formatter.format(new Date());
                        this.setError(0, "");
                        this._pingHandler.startP2P(this._p2pDestinationPool);
                        if (!RequestContainerV5.this._sendHitInfo) break;
                        RequestContainerV5.this.sendHitMsg(this._pnfsId, this._p2pSourcePool != null ? this._p2pSourcePool.getName() : "<UNKNOWN>", true);
                        break;
                    }
                    if (rc == 8) {
                        if (this._bestPool == null) {
                            if (this._enforceP2P) {
                                this.nextStep(RequestState.ST_DONE, 0);
                                break;
                            }
                            if (this._parameter._hasHsmBackend && this._storageInfo.isStored()) {
                                _log.info("ST_POOL_2_POOL : Pool to pool not permitted, trying to stage the file");
                                this.nextStep(RequestState.ST_STAGE, 0);
                                break;
                            }
                            this.setError(265, "Pool to pool not permitted");
                            this.suspendIfEnabled("Suspended");
                            break;
                        }
                        this._poolCandidate = this._bestPool;
                        _log.info("ST_POOL_2_POOL : Choosing high cost pool " + this._poolCandidate);
                        this.setError(0, "");
                        this.nextStep(RequestState.ST_DONE, 0);
                        break;
                    }
                    if (rc == 9) {
                        _log.info("ST_POOL_2_POOL : RT_S_COST_EXCEEDED");
                        if (this._parameter._hasHsmBackend && this._parameter._stageOnCost && this._storageInfo.isStored()) {
                            if (this._enforceP2P) {
                                this.nextStep(RequestState.ST_DONE, 0);
                                break;
                            }
                            _log.info("ST_POOL_2_POOL : staging");
                            this.nextStep(RequestState.ST_STAGE, 0);
                            break;
                        }
                        if (this._bestPool != null) {
                            this._poolCandidate = this._bestPool;
                            _log.info("ST_POOL_2_POOL : Choosing high cost pool " + this._poolCandidate);
                            this.setError(0, "");
                            this.nextStep(RequestState.ST_DONE, 0);
                            break;
                        }
                        this.setError(194, "PANIC : File not present in any reasonable pool");
                        this.nextStep(RequestState.ST_DONE, 0);
                        break;
                    }
                    if (rc == 7) {
                        if (this._bestPool == null) {
                            if (this._enforceP2P) {
                                this.nextStep(RequestState.ST_DONE, 0);
                                break;
                            }
                            this.setError(192, "PANIC : File not present in any reasonable pool");
                            this.nextStep(RequestState.ST_DONE, 0);
                            break;
                        }
                        this._poolCandidate = this._bestPool;
                        _log.info(" found high cost object");
                        this.setError(0, "");
                        this.nextStep(RequestState.ST_DONE, 0);
                        break;
                    }
                    if (this._enforceP2P) {
                        this.nextStep(RequestState.ST_DONE, 0);
                        break;
                    }
                    if (this._parameter._hasHsmBackend && this._storageInfo.isStored()) {
                        this.nextStep(RequestState.ST_STAGE, 0);
                        break;
                    }
                    this.suspendIfEnabled("Suspended");
                    break;
                }
                case ST_STAGE: {
                    _log.debug("stateEngine: case ST_STAGE");
                    if (inputObject != null) break;
                    if (RequestContainerV5.this._suspendStaging) {
                        this.setError(1005, "Suspend enforced");
                        this.suspend("Suspended Stage (forced)");
                        return;
                    }
                    int rc = this.askForStaging();
                    if (rc == 2) {
                        this.nextStep(RequestState.ST_WAITING_FOR_STAGING, 1);
                        this._status = "Staging " + RequestContainerV5.this._formatter.format(new Date());
                        this.setError(0, "");
                        this._pingHandler.startStage(this._poolCandidate);
                        break;
                    }
                    if (rc == 5) {
                        RequestContainerV5.this._restoreExceeded++;
                        this.outOfResources("Restore");
                        break;
                    }
                    this.errorHandler();
                    break;
                }
                case ST_WAITING_FOR_POOL_2_POOL: {
                    _log.debug("stateEngine: case ST_WAITING_FOR_POOL_2_POOL");
                    if (inputObject instanceof Message) {
                        int rc = this.exercisePool2PoolReply((Message)inputObject);
                        if (rc == 1) {
                            if (this._parameter._p2pForTransfer && !this._enforceP2P) {
                                this.setError(10021, "Pool locations changed due to p2p transfer");
                                this.nextStep(RequestState.ST_DONE, 0);
                                break;
                            }
                            this.nextStep(RequestState.ST_DONE, 0);
                            break;
                        }
                        _log.info("ST_POOL_2_POOL : Pool to pool reported a problem");
                        if (this._parameter._hasHsmBackend && this._storageInfo.isStored()) {
                            _log.info("ST_POOL_2_POOL : trying to stage the file");
                            this.nextStep(RequestState.ST_STAGE, 0);
                            break;
                        }
                        this.errorHandler();
                        break;
                    }
                    if (inputObject instanceof Object[]) {
                        this.handleCommandObject((Object[])inputObject);
                        break;
                    }
                    this._pingHandler.gotReply(inputObject);
                    break;
                }
                case ST_WAITING_FOR_STAGING: {
                    _log.debug("stateEngine: case ST_WAITING_FOR_STAGING");
                    if (inputObject instanceof Message) {
                        int rc = this.exerciseStageReply((Message)inputObject);
                        if (rc == 1) {
                            if (this._parameter._p2pForTransfer) {
                                this.setError(10021, "Pool locations changed due to stage");
                                this.nextStep(RequestState.ST_DONE, 0);
                                break;
                            }
                            this.nextStep(RequestState.ST_DONE, 0);
                            break;
                        }
                        if (rc == 10) {
                            this.suspend("Suspended By HSM request");
                            break;
                        }
                        this.errorHandler();
                        break;
                    }
                    if (inputObject instanceof Object[]) {
                        this.handleCommandObject((Object[])inputObject);
                        break;
                    }
                    this._pingHandler.gotReply(inputObject);
                    break;
                }
                case ST_SUSPENDED: {
                    _log.debug("stateEngine: case ST_SUSPENDED");
                    if (inputObject instanceof Object[]) {
                        this.handleCommandObject((Object[])inputObject);
                    }
                    return;
                }
                case ST_DONE: {
                    _log.debug("stateEngine: case ST_DONE");
                    if (inputObject != null) break;
                    this.clearSteering();
                    Map map = RequestContainerV5.this._handlerHash;
                    synchronized (map) {
                        if (this.answerRequest(RequestContainerV5.this._maxRequestClumping)) {
                            this.setError(10017, "Request clumping limit reached");
                            this.nextStep(RequestState.ST_DONE, 0);
                        } else {
                            RequestContainerV5.this._handlerHash.remove(this._name);
                        }
                        break;
                    }
                }
            }
        }

        private void handleCommandObject(Object[] c) {
            String command;
            switch (command = c[0].toString()) {
                case "failed": {
                    this.clearSteering();
                    this.setError((Integer)c[1], c[2].toString());
                    this.nextStep(RequestState.ST_DONE, 0);
                    break;
                }
                case "retry": {
                    this._status = "Retry enforced";
                    this._retryCounter = -1;
                    this.clearSteering();
                    this.setError(10021, "Operator asked for retry");
                    this.nextStep(RequestState.ST_DONE, 0);
                    break;
                }
                case "alive": {
                    long now = System.currentTimeMillis();
                    if (now > this._nextTtlTimeout) {
                        this.expireRequests();
                    }
                    if (this._waitUntil > 0L && now > this._waitUntil) {
                        this.clearSteering();
                        this.nextStep(this._state, 0);
                        break;
                    }
                    this._pingHandler.alive();
                }
            }
        }

        private void outOfResources(String detail) {
            this.clearSteering();
            this.setError(5, "Resource temporarily unavailable : " + detail);
            this.nextStep(RequestState.ST_DONE, 0);
            this._status = "Failed";
            RequestContainerV5.this.sendInfoMessage(this._pnfsId, this._storageInfo, this._currentRc, "Failed " + this._currentRm);
        }

        private void fail() {
            if (this._currentRc == 0) {
                _log.error("Error handler called without an error");
                this.setError(666, "Pool selection failed");
            }
            this.nextStep(RequestState.ST_DONE, 0);
        }

        private void suspend(String status) {
            _log.debug(" stateEngine: SUSPENDED/WAIT ");
            this._status = status + " " + RequestContainerV5.this._formatter.format(new Date());
            this.nextStep(RequestState.ST_SUSPENDED, 1);
            RequestContainerV5.this.sendInfoMessage(this._pnfsId, this._storageInfo, this._currentRc, "Suspended (" + this._currentRm + ")");
        }

        private void suspendIfEnabled(String status) {
            if (RequestContainerV5.this._onError.equals("suspend")) {
                this.suspend(status);
            } else {
                this.fail();
            }
        }

        private void errorHandler() {
            if (this._retryCounter >= RequestContainerV5.this._maxRetries) {
                this.suspendIfEnabled("Suspended");
            } else {
                this.fail();
            }
        }

        private int exerciseStageReply(Message messageArrived) {
            try {
                if (messageArrived instanceof PoolFetchFileMessage) {
                    int rc;
                    PoolFetchFileMessage reply = (PoolFetchFileMessage)messageArrived;
                    this._currentRc = reply.getReturnCode();
                    switch (this._currentRc) {
                        case 0: {
                            rc = 1;
                            break;
                        }
                        case 10013: {
                            this._currentRm = "Suspend by HSM request : " + reply.getErrorObject() == null ? "No info" : reply.getErrorObject().toString();
                            rc = 10;
                            break;
                        }
                        default: {
                            this._currentRm = reply.getErrorObject() == null ? "Error=" + this._currentRc : reply.getErrorObject().toString();
                            rc = 4;
                        }
                    }
                    return rc;
                }
                throw new CacheException(204, "Invalid message arrived : " + messageArrived.getClass().getName());
            }
            catch (CacheException e) {
                this._currentRc = e.getRc();
                this._currentRm = e.getMessage();
                _log.warn("exerciseStageReply: {} ", (Object)e.toString());
                return 4;
            }
            catch (RuntimeException e) {
                this._currentRc = 102;
                this._currentRm = e.getMessage();
                _log.error("exerciseStageReply", (Throwable)e);
                return 4;
            }
        }

        private int exercisePool2PoolReply(Message messageArrived) {
            try {
                if (messageArrived instanceof Pool2PoolTransferMsg) {
                    Pool2PoolTransferMsg reply = (Pool2PoolTransferMsg)messageArrived;
                    _log.info("Pool2PoolTransferMsg replied with : " + reply);
                    this._currentRc = reply.getReturnCode();
                    if (this._currentRc == 0) {
                        this._poolCandidate = this._p2pDestinationPool;
                        return 1;
                    }
                    this._currentRm = reply.getErrorObject() == null ? "Error=" + this._currentRc : reply.getErrorObject().toString();
                    return 4;
                }
                throw new CacheException(205, "Invalid message arrived : " + messageArrived.getClass().getName());
            }
            catch (CacheException e) {
                this._currentRc = e.getRc();
                this._currentRm = e.getMessage();
                _log.warn("exercisePool2PoolReply: {}", (Object)e.toString());
                return 4;
            }
            catch (RuntimeException e) {
                this._currentRc = 102;
                this._currentRm = e.getMessage();
                _log.error("exercisePool2PoolReply", (Throwable)e);
                return 4;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int askIfAvailable() {
            try {
                this._bestPool = this._poolSelector.selectReadPool();
                this._parameter = this._poolSelector.getCurrentPartition();
            }
            catch (FileNotInCacheException e) {
                _log.info("[read] {}", (Object)e.getMessage());
                int n = 3;
                return n;
            }
            catch (PermissionDeniedCacheException e) {
                _log.info("[read] {}", (Object)e.getMessage());
                int n = 8;
                return n;
            }
            catch (CostException e) {
                if (e.getPool() == null) {
                    _log.info("[read] {}", (Object)e.getMessage());
                    this.setError(125, e.getMessage());
                    int n = 4;
                    return n;
                }
                this._bestPool = e.getPool();
                this._parameter = this._poolSelector.getCurrentPartition();
                if (e.shouldTryAlternatives()) {
                    _log.info("[read] {} ({})", (Object)e.getMessage(), (Object)this._bestPool);
                    int n = 7;
                    return n;
                }
            }
            catch (CacheException e) {
                String err = "Read pool selection failed: " + e.getMessage();
                _log.warn(err);
                this.setError(130, err);
                int n = 4;
                return n;
            }
            catch (RuntimeException e) {
                _log.error("Read pool selection failed", (Throwable)e);
                this.setError(130, "Read pool selection failed: " + e.toString());
                int n = 4;
                return n;
            }
            finally {
                _log.info("[read] Took  {} ms", (Object)(System.currentTimeMillis() - this._started));
            }
            this._poolCandidate = this._bestPool;
            this.setError(0, "");
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int askForPoolToPool(boolean overwriteCost) {
            try {
                Partition.P2pPair pools = this._poolSelector.selectPool2Pool(overwriteCost);
                this._p2pSourcePool = pools.source;
                this._p2pDestinationPool = pools.destination;
                _log.info("[p2p] source={};dest={}", (Object)this._p2pSourcePool, (Object)this._p2pDestinationPool);
                this.sendPool2PoolRequest(this._p2pSourcePool, this._p2pDestinationPool);
                int n = 2;
                return n;
            }
            catch (PermissionDeniedCacheException e) {
                this.setError(e.getRc(), e.getMessage());
                _log.warn("[p2p] {}", (Object)e.toString());
                int n = 8;
                return n;
            }
            catch (SourceCostException e) {
                this.setError(e.getRc(), e.getMessage());
                _log.info("[p2p] {}", (Object)e.getMessage());
                int n = 9;
                return n;
            }
            catch (DestinationCostException e) {
                this.setError(e.getRc(), e.getMessage());
                _log.info("[p2p] {}", (Object)e.getMessage());
                int n = 7;
                return n;
            }
            catch (CacheException e) {
                this.setError(e.getRc(), e.getMessage());
                _log.warn("[p2p] {}", (Object)e.getMessage());
                int n = 4;
                return n;
            }
            catch (NoRouteToCellException e) {
                this.setError(128, e.getMessage());
                _log.error("[p2p] {}", (Object)e.toString());
                int n = 4;
                return n;
            }
            catch (RuntimeException e) {
                this.setError(128, e.getMessage());
                _log.error("[p2p] contact support@dcache.org", (Throwable)e);
                int n = 4;
                return n;
            }
            finally {
                _log.info("[p2p] Selection took {} ms", (Object)(System.currentTimeMillis() - this._started));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int askForStaging() {
            try {
                PoolInfo pool;
                this._poolCandidate = pool = this._poolSelector.selectStagePool(this._stageCandidatePool, this._stageCandidateHost);
                this._stageCandidatePool = pool.getName();
                this._stageCandidateHost = pool.getHostName();
                _log.info("[staging] poolCandidate -> {}", (Object)this._poolCandidate);
                if (!this.sendFetchRequest(this._poolCandidate)) {
                    int n = 5;
                    return n;
                }
                this.setError(0, "");
                int n = 2;
                return n;
            }
            catch (CostException e) {
                if (e.getPool() != null) {
                    this._poolCandidate = e.getPool();
                    this._stageCandidatePool = e.getPool().getName();
                    this._stageCandidateHost = e.getPool().getHostName();
                    int n = 2;
                    return n;
                }
                _log.info("[stage] {}", (Object)e.getMessage());
                this.setError(125, e.getMessage());
                int n = 4;
                return n;
            }
            catch (CacheException e) {
                this.setError(e.getRc(), e.getMessage());
                _log.warn("[stage] {}", (Object)e.getMessage());
                int n = 3;
                return n;
            }
            catch (NoRouteToCellException e) {
                this.setError(128, e.getMessage());
                _log.error("[stage] {}", (Object)e.toString());
                int n = 4;
                return n;
            }
            catch (RuntimeException e) {
                this.setError(128, e.getMessage());
                _log.error("[stage] contact support@dcache.org", (Throwable)e);
                int n = 4;
                return n;
            }
            finally {
                _log.info("[stage] Selection took {} ms", (Object)(System.currentTimeMillis() - this._started));
            }
        }

        public class RunEngine
        implements ExtendedRunnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (CDC ignored = PoolRequestHandler.this._cdc.restore();){
                    PoolRequestHandler.this.stateLoop();
                }
                finally {
                    Deque deque = PoolRequestHandler.this._fifo;
                    synchronized (deque) {
                        PoolRequestHandler.this._stateEngineActive = false;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runFailed() {
                Deque deque = PoolRequestHandler.this._fifo;
                synchronized (deque) {
                    PoolRequestHandler.this._stateEngineActive = false;
                }
            }

            public String toString() {
                return PoolRequestHandler.this.toString();
            }
        }

        private class CheckFilePingHandler {
            private long _timeInterval;
            private long _timer;
            private PoolInfo _candidate;
            private PingState _state = PingState.STOPPED;
            private String _query;

            private CheckFilePingHandler(long timerInterval) {
                this._timeInterval = timerInterval;
            }

            private void startP2P(PoolInfo candidate) {
                if (this._timeInterval <= 0L || candidate == null) {
                    return;
                }
                this._candidate = candidate;
                this._timer = this._timeInterval + System.currentTimeMillis();
                this._state = PingState.WAITING;
                this._query = "pp ls";
            }

            private void startStage(PoolInfo candidate) {
                if (this._timeInterval <= 0L || candidate == null) {
                    return;
                }
                this._candidate = candidate;
                this._timer = this._timeInterval + System.currentTimeMillis();
                this._state = PingState.WAITING;
                this._query = "rh ls";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void stop() {
                this._candidate = null;
                this._state = PingState.STOPPED;
                Map map = RequestContainerV5.this._messageHash;
                synchronized (map) {
                    if (PoolRequestHandler.this._waitingFor != null) {
                        RequestContainerV5.this._messageHash.remove(PoolRequestHandler.this._waitingFor);
                    }
                }
            }

            private void alive() {
                if (this._candidate == null || this._timer == 0L) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now > this._timer) {
                    switch (this._state) {
                        case WAITING: {
                            _log.info("CheckFilePingHandler : sending " + this._query + " to " + this._candidate);
                            this.sendQuery();
                            this._state = PingState.QUERYING;
                            break;
                        }
                        case QUERYING: {
                            _log.info("CheckFilePingHandler : request died");
                            this.stop();
                            PoolRequestHandler.this.setError(10006, "Replication/staging timed out");
                            PoolRequestHandler.this.errorHandler();
                            break;
                        }
                        case STOPPED: {
                            return;
                        }
                    }
                    this._timer = this._timeInterval + now;
                }
            }

            private void gotReply(Object object) {
                String s;
                if (this._state == PingState.QUERYING && object instanceof String && (s = (String)object).contains(PoolRequestHandler.this._pnfsId.toString())) {
                    _log.info("CheckFilePingHandler : request is alive");
                    this._state = PingState.WAITING;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void sendQuery() {
                CellMessage envelope = new CellMessage(new CellPath(this._candidate.getAddress()), (Serializable)((Object)this._query));
                Map map = RequestContainerV5.this._messageHash;
                synchronized (map) {
                    try {
                        RequestContainerV5.this.sendMessage(envelope);
                        PoolRequestHandler.this._waitingFor = envelope.getUOID();
                        RequestContainerV5.this._messageHash.put(PoolRequestHandler.this._waitingFor, PoolRequestHandler.this);
                    }
                    catch (NoRouteToCellException e) {
                        _log.warn("Can't send pool ping to {}: {}", (Object)this._candidate, (Object)e.toString());
                    }
                }
            }
        }
    }

    public static enum RequestState {
        ST_INIT,
        ST_DONE,
        ST_POOL_2_POOL,
        ST_STAGE,
        ST_WAITING,
        ST_WAITING_FOR_STAGING,
        ST_WAITING_FOR_POOL_2_POOL,
        ST_SUSPENDED;

    }

    private static enum PingState {
        STOPPED,
        WAITING,
        QUERYING;

    }
}

