/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.Unit;

class ProtocolUnit
extends Unit {
    private static final long serialVersionUID = 4588437437939085320L;
    private String _protocol;
    private int _version = -1;

    ProtocolUnit(String name) {
        super(name, 4);
        int pos = name.indexOf("/");
        if (pos < 0 || pos == 0 || name.length() - 1 == pos) {
            throw new IllegalArgumentException("Wrong format for protocol unit <protocol>/<version>");
        }
        this._protocol = name.substring(0, pos);
        String version = name.substring(pos + 1);
        try {
            this._version = version.equals("*") ? -1 : Integer.parseInt(version);
        }
        catch (Exception ee) {
            throw new IllegalArgumentException("Wrong format : Protocol version must be * or numerical");
        }
    }

    @Override
    public String getName() {
        return this._protocol + (this._version > -1 ? "/" + this._version : "/*");
    }
}

