/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import diskCacheV111.poolManager.Link;
import diskCacheV111.poolManager.LinkComparator;
import diskCacheV111.poolManager.LinkGroup;
import diskCacheV111.poolManager.LinkMap;
import diskCacheV111.poolManager.NetHandler;
import diskCacheV111.poolManager.NetUnit;
import diskCacheV111.poolManager.PGroup;
import diskCacheV111.poolManager.Pool;
import diskCacheV111.poolManager.PoolCore;
import diskCacheV111.poolManager.PoolPreferenceLevel;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.poolManager.ProtocolUnit;
import diskCacheV111.poolManager.UGroup;
import diskCacheV111.poolManager.Unit;
import diskCacheV111.vehicles.GenericStorageInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.util.Args;
import dmg.util.CommandSyntaxException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellSetupProvider;
import org.dcache.util.Glob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolSelectionUnitV2
implements Serializable,
PoolSelectionUnit,
CellCommandListener,
CellSetupProvider {
    private static final String __version = "$Id: PoolSelectionUnitV2.java,v 1.42 2007-10-25 14:03:54 tigran Exp $";
    private static final Logger _log = LoggerFactory.getLogger(PoolSelectionUnitV2.class);
    private static final String NO_NET = "<no net>";
    public static final int STORE = 1;
    public static final int DCACHE = 2;
    public static final int NET = 3;
    public static final int PROTOCOL = 4;
    private static final long serialVersionUID = 4852540784324544199L;
    private final Map<String, PGroup> _pGroups = new HashMap<String, PGroup>();
    private final Map<String, Pool> _pools = new HashMap<String, Pool>();
    private final Map<String, Link> _links = new HashMap<String, Link>();
    private final Map<String, LinkGroup> _linkGroups = new HashMap<String, LinkGroup>();
    private final Map<String, UGroup> _uGroups = new HashMap<String, UGroup>();
    private final Map<String, Unit> _units = new HashMap<String, Unit>();
    private boolean _useRegex;
    private boolean _allPoolsActive;
    private final ReadWriteLock _psuReadWriteLock = new ReentrantReadWriteLock();
    private final Lock _psuReadLock = this._psuReadWriteLock.readLock();
    private final Lock _psuWriteLock = this._psuReadWriteLock.writeLock();
    private final NetHandler _netHandler = new NetHandler();
    private boolean _protocolsChecked;
    public static final String hh_psu_set_allpoolsactive = "on|off";
    public static final String hh_psu_netmatch = "<host address>";
    public static final String hh_psu_match = "[-linkGroup=<link group>] read|cache|write|p2p <store unit>|* <dCache unit>|* <net unit>|* <protocol unit>|* ";
    public static final String hh_psu_match2 = "<unit> [...] [-net=<net unit>}";
    public static final String hh_psu_create_pgroup = "<pool group>";
    public static final String hh_psu_set_regex = "on | off";
    public static final String hh_psu_create_pool = "<pool> [-noping]";
    public static final String hh_psu_set_pool = "<pool glob> enabled|disabled|ping|noping|rdonly|notrdonly";
    public static final String hh_psu_set_enabled = "<pool glob>";
    public static final String hh_psu_set_disabled = "<pool glob>";
    public static final String hh_psu_create_link = "<link> <unit group> [...]";
    public static final String hh_psu_create_ugroup = "<unit group>";
    public static final String hh_psu_create_unit = "-net|-store|-dcache|-protocol <name>";
    public static final String fh_psu_create_unit = "NAME\n\tpsu create unit\n\nSYNOPSIS\n\tpsu create unit UNITTYPE NAME\n\nDESCRIPTION\n\tCreates a new unit of the specified type.  A unit is a predicate\n\tthat is used to select which pools are eligable for a specific user\n\trequest (to read data from dCache or write data).  Units are\n\tcombined in unit-groups; see psu create unitgroup for more details.\n\n\tThe UNITTYPE is one of '-net', '-store', '-dcache' or '-protocol'\n\tto create a network, store, dCache or protocol unit, respectively.\n\n\tThe NAME of the unit describes which particular subset of user\n\trequests will be selected; for example, a network unit with the\n\tname '10.1.0.0/24' will select only those requests from a computer\n\twith an IP address matching that subnet.\n\n\tThe NAME for network units is either an IPv4 address, IPv6 address,\n\tan IPv4 subnet or an IPv6 subnet.  Subnets may be written either\n\tusing CIDR notation or as an IP address and netmask, joined by a\n\t'/'.\n\n\tThe NAME for store units has the form <StorageClass>@<HSM-type>.\n\tBoth <StorageClass> and <HSM-type> may be replaced with a '*' to\n\tmatch any value.  If the HSM-type is 'osm' then <StorageClass> is\n\tconstructed by joining the store-name and store-group with a colon:\n\t<StoreName>:<StoreGroup>@osm.\n\n\tThe NAME for a dcache unit is an arbitrary string.  This matches\n\tagainst the optional cache-class that may be set within the\n\tnamespace in a similar fashion to the storage-class.\n\n\tThe NAME for a protocol unit has the form <protocol>/<version>. If\n\t<version> is '*' then all versions of that protocol match.\n\nOPTIONS\n\tnone\n";
    public static final String hh_psu_create_linkGroup = "<group name> [-reset]";
    public static final String hh_psux_ls_pool = "[<pool>]";
    public static final String hh_psux_ls_pgroup = "[<pool group>]";
    public static final String hh_psux_ls_unit = "[<unit>]";
    public static final String hh_psux_ls_ugroup = "[<unit group>]";
    public static final String hh_psux_ls_link = "[<link>] [-x] [-resolve]";
    public static final String hh_psux_match = "[-linkGroup=<link group>] read|cache|write <store unit> <dCache unit> <net unit> <protocol unit>";
    public static final String hh_psu_ls_pool = "[-l] [-a] [<pool glob> [...]]";
    public static final String hh_psu_ls_pgroup = "[-l] [-a] [<pool group> [...]]";
    public static final String hh_psu_ls_link = "[-l] [-a] [ <link> [...]]";
    public static final String hh_psu_ls_ugroup = "[-l] [-a] [<unit group> [...]]";
    public static final String hh_psu_ls_netunits = "";
    public static final String hh_psu_ls_unit = " [-a] [<unit> [...]]";
    public static final String hh_psu_ls_linkGroup = "[-l] [<link group1> ... <link groupN>]";
    public static final String hh_psu_dump_setup = "";
    public static final String hh_psu_remove_unit = "<unit> [-net]";
    public static final String hh_psu_remove_ugroup = "<unit group>";
    public static final String hh_psu_remove_pgroup = "<pool group>";
    public static final String hh_psu_remove_pool = "<pool>";
    public static final String hh_psu_removefrom_ugroup = "<unit group> <unit> -net";
    public static final String hh_psu_removefrom_pgroup = "<pool group> <pool>";
    public static final String hh_psu_removefrom_linkGroup = "<link group> <link>";
    public static final String hh_psu_remove_linkGroup = "<link group>";
    public static final String hh_psu_remove_link = "<link>";
    public static final String hh_psu_addto_pgroup = "<pool group> <pool>";
    public static final String hh_psu_addto_ugroup = "<unit group> <unit>";
    public static final String hh_psu_addto_linkGroup = "<link group> <link>";
    public static final String hh_psu_unlink = "<link> <pool>|<pool group>";
    public static final String hh_psu_add_link = "<link> <pool>|<pool group>";
    public static final String hh_psu_set_active = "<pool>|* [-no]";
    public static final String hh_psu_set_link = "<link> [-readpref=<readpref>] [-writepref=<writepref>] [-cachepref=<cachepref>] [-p2ppref=<p2ppref>] [-section=<section>|NONE]";
    public static final String hh_psu_set_linkGroup_attribute = "<link group> [-r] attribute=value";
    public static final String hh_psu_remove_linkGroup_attribute = "<link group> attribute=value";
    public static final String hh_psu_set_linkGroup_custodialAllowed = "<link group> <true|false>";
    public static final String hh_psu_set_linkGroup_outputAllowed = "<link group> <true|false>";
    public static final String hh_psu_set_linkGroup_replicaAllowed = "<link group> <true|false>";
    public static final String hh_psu_set_linkGroup_onlineAllowed = "<link group> <true|false>";
    public static final String hh_psu_set_linkGroup_nearlineAllowed = "<link group> <true|false>";
    public static final String hh_psu_clear_im_really_sure = "# don't use this command";

    @Override
    public String getVersion() {
        return __version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PoolSelectionUnit.SelectionLink> getLinks() {
        this._psuReadLock.lock();
        try {
            ArrayList<PoolSelectionUnit.SelectionLink> arrayList = new ArrayList<PoolSelectionUnit.SelectionLink>(this._links.values());
            return arrayList;
        }
        finally {
            this._psuReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PoolSelectionUnit.SelectionUnit> getSelectionUnits() {
        this._psuReadLock.lock();
        try {
            ArrayList<PoolSelectionUnit.SelectionUnit> arrayList = new ArrayList<PoolSelectionUnit.SelectionUnit>(this._units.values());
            return arrayList;
        }
        finally {
            this._psuReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PoolSelectionUnit.SelectionUnitGroup> getUnitGroups() {
        this._psuReadLock.lock();
        try {
            ArrayList<PoolSelectionUnit.SelectionUnitGroup> arrayList = new ArrayList<PoolSelectionUnit.SelectionUnitGroup>(this._uGroups.values());
            return arrayList;
        }
        finally {
            this._psuReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PoolSelectionUnit.SelectionLink> getLinksPointingToPoolGroup(String poolGroup) throws NoSuchElementException {
        this._psuReadLock.lock();
        try {
            PGroup group = this._pGroups.get(poolGroup);
            if (group == null) {
                throw new NoSuchElementException("No such pool group: " + poolGroup);
            }
            ArrayList<PoolSelectionUnit.SelectionLink> arrayList = new ArrayList<PoolSelectionUnit.SelectionLink>(group._linkList.values());
            return arrayList;
        }
        finally {
            this._psuReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolSelectionUnit.SelectionLink getLinkByName(String name) throws NoSuchElementException {
        Link link = null;
        this._psuReadLock.lock();
        try {
            link = this._links.get(name);
            if (link == null) {
                throw new NoSuchElementException("Link not found : " + name);
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDefinedPools(boolean enabledOnly) {
        ArrayList<String> list = new ArrayList<String>();
        this._psuReadLock.lock();
        try {
            for (Pool pool : this._pools.values()) {
                if (enabledOnly && !pool.isEnabled()) continue;
                list.add(pool.getName());
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getActivePools() {
        ArrayList<String> list = new ArrayList<String>();
        this._psuReadLock.lock();
        try {
            for (Pool pool : this._pools.values()) {
                if (!pool.isEnabled() || !pool.isActive()) continue;
                list.add(pool.getName());
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void beforeSetup() {
        this.clear();
    }

    @Override
    public void afterSetup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printSetup(PrintWriter pw) {
        this._psuReadLock.lock();
        try {
            pw.append("#\n# Printed by ").append(this.getClass().getName()).append(" at ").append(new Date().toString()).append("\n#\n#\n");
            pw.append("psu set regex ").append(this._useRegex ? "on" : "off").append("\n");
            pw.append("psu set allpoolsactive ").append(this._allPoolsActive ? "on" : "off").append("\n");
            pw.append("#\n# The units ...\n#\n");
            for (Unit unit : this._units.values()) {
                int type = unit._type;
                pw.append("psu create unit ").append(type == 1 ? "-store " : (type == 2 ? "-dcache" : (type == 4 ? "-protocol" : "-net   "))).append(" ").append(unit.getName()).append("\n");
            }
            pw.append("#\n# The unit Groups ...\n#\n");
            for (UGroup uGroup : this._uGroups.values()) {
                pw.append("psu create ugroup ").append(uGroup.getName()).append("\n");
                for (Unit unit : uGroup._unitList.values()) {
                    pw.append("psu addto ugroup ").append(uGroup.getName()).append(" ").append(unit.getName()).append("\n");
                }
            }
            pw.append("#\n# The pools ...\n#\n");
            for (Pool pool : this._pools.values()) {
                pw.append("psu create pool ").append(pool.getName());
                if (!pool.isPing()) {
                    pw.append(" -noping");
                }
                if (!pool.isEnabled()) {
                    pw.append(" -disabled");
                }
                pw.append("\n");
            }
            pw.append("#\n# The pool groups ...\n#\n");
            for (PGroup pGroup : this._pGroups.values()) {
                pw.append("psu create pgroup ").append(pGroup.getName()).append("\n");
                for (Pool pool : pGroup._poolList.values()) {
                    pw.append("psu addto pgroup ").append(pGroup.getName()).append(" ").append(pool.getName()).append("\n");
                }
            }
            pw.append("#\n# The links ...\n#\n");
            for (Link link : this._links.values()) {
                pw.append("psu create link ").append(link.getName());
                for (UGroup group : link._uGroupList.values()) {
                    pw.append(" ").append(group.getName());
                }
                pw.append("\n");
                pw.append("psu set link ").append(link.getName()).append(" ").println(link.getAttraction());
                for (PoolCore poolCore : link._poolList.values()) {
                    pw.append("psu add link ").append(link.getName()).append(" ").println(poolCore.getName());
                }
            }
            pw.append("#\n# The link Groups ...\n#\n");
            for (LinkGroup linkGroup : this._linkGroups.values()) {
                pw.append("psu create linkGroup ").append(linkGroup.getName());
                pw.append("\n");
                pw.append("psu set linkGroup custodialAllowed ").append(linkGroup.getName()).append(" ").println(linkGroup.isCustodialAllowed());
                pw.append("psu set linkGroup replicaAllowed ").append(linkGroup.getName()).append(" ").println(linkGroup.isReplicaAllowed());
                pw.append("psu set linkGroup nearlineAllowed ").append(linkGroup.getName()).append(" ").println(linkGroup.isNearlineAllowed());
                pw.append("psu set linkGroup outputAllowed ").append(linkGroup.getName()).append(" ").println(linkGroup.isOutputAllowed());
                pw.append("psu set linkGroup onlineAllowed ").append(linkGroup.getName()).append(" ").println(linkGroup.isOnlineAllowed());
                for (Map.Entry<String, Set<String>> aAttribute : linkGroup.attributes().entrySet()) {
                    String attributeName = aAttribute.getKey();
                    for (String aAttributeValue : aAttribute.getValue()) {
                        pw.append("psu set linkGroup attribute ").append(linkGroup.getName()).append(" ").append(attributeName).append("=").println(aAttributeValue);
                    }
                }
                for (PoolSelectionUnit.SelectionLink link : linkGroup.links()) {
                    pw.append("psu addto linkGroup ").append(linkGroup.getName()).append(" ").println(link.getName());
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this._psuWriteLock.lock();
        try {
            this._netHandler.clear();
            this._pGroups.clear();
            this._pools.clear();
            this._links.clear();
            this._uGroups.clear();
            this._units.clear();
            this._linkGroups.clear();
        }
        finally {
            this._psuWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(String poolName, boolean active) {
        this._psuWriteLock.lock();
        try {
            Pool pool = this._pools.get(poolName);
            if (pool != null) {
                pool.setActive(active);
            }
        }
        finally {
            this._psuWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActive(String poolName) {
        long active = 100000000L;
        this._psuReadLock.lock();
        try {
            Pool pool = this._pools.get(poolName);
            if (pool != null) {
                active = pool.getActive();
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setEnabled(Glob glob, boolean enabled) {
        this._psuWriteLock.lock();
        try {
            int count = 0;
            for (Pool pool : this.getPools(glob.toPattern())) {
                ++count;
                pool.setEnabled(enabled);
            }
            int n = count;
            return n;
        }
        finally {
            this._psuWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(String poolName) {
        boolean isEnabled = false;
        this._psuReadLock.lock();
        try {
            Pool pool = this._pools.get(poolName);
            if (pool != null) {
                isEnabled = pool.isEnabled();
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolSelectionUnit.SelectionPool getPool(String poolName) {
        PoolSelectionUnit.SelectionPool pool = null;
        this._psuReadLock.lock();
        try {
            pool = this._pools.get(poolName);
        }
        finally {
            this._psuReadLock.unlock();
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolSelectionUnit.SelectionPool getPool(String poolName, boolean create) {
        Pool pool = this._pools.get(poolName);
        if (pool != null || !create) {
            return pool;
        }
        pool = new Pool(poolName);
        this._psuReadLock.lock();
        try {
            this._pools.put(pool.getName(), pool);
            PGroup group = this._pGroups.get("default");
            if (group == null) {
                throw new IllegalArgumentException("Not found : default");
            }
            pool._pGroupList.put(group.getName(), group);
            group._poolList.put(pool.getName(), pool);
        }
        finally {
            this._psuReadLock.unlock();
        }
        return pool;
    }

    public Map<String, Link> match(Map<String, Link> map, Unit unit, PoolSelectionUnit.DirectionType ioType) {
        Map<String, Link> newmap = this.match(unit, null, ioType);
        if (map == null) {
            return newmap;
        }
        HashMap<String, Link> resultMap = new HashMap<String, Link>();
        for (Link link : map.values()) {
            if (newmap.get(link.getName()) == null) continue;
            resultMap.put(link.getName(), link);
        }
        return resultMap;
    }

    private LinkMap match(LinkMap linkMap, Unit unit, LinkGroup linkGroup, PoolSelectionUnit.DirectionType ioType) {
        Map<String, Link> map = this.match(unit, linkGroup, ioType);
        for (Link link : map.values()) {
            linkMap.addLink(link);
        }
        return linkMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PoolPreferenceLevel[] match(PoolSelectionUnit.DirectionType type, String netUnitName, String protocolUnitName, StorageInfo storageInfo, String linkGroupName) {
        String storeUnitName = storageInfo.getStorageClass() + "@" + storageInfo.getHsm();
        String dCacheUnitName = storageInfo.getCacheClass();
        _log.debug("running match: type={} store={} dCacheUnit={} net={} protocol={} SI={} linkGoup={}", new Object[]{type, storeUnitName, dCacheUnitName, netUnitName, protocolUnitName, storageInfo, linkGroupName});
        Map<String, String> variableMap = storageInfo.getMap();
        PoolPreferenceLevel[] result = null;
        this._psuReadLock.lock();
        try {
            Unit unit;
            ArrayList<Unit> list = new ArrayList<Unit>();
            if (this._useRegex) {
                Unit universalCoverage = null;
                Unit classCoverage = null;
                for (Unit unit2 : this._units.values()) {
                    if (unit2._type != 1) continue;
                    if (unit2.getName().equals("*@*")) {
                        universalCoverage = unit2;
                        continue;
                    }
                    if (unit2.getName().equals("*@" + storeUnitName)) {
                        classCoverage = unit2;
                        continue;
                    }
                    if (!Pattern.matches(unit2.getName(), storeUnitName)) continue;
                    list.add(unit2);
                    break;
                }
                if (list.isEmpty()) {
                    if (classCoverage != null) {
                        list.add(classCoverage);
                    } else {
                        if (universalCoverage == null) throw new IllegalArgumentException("Unit not found : " + storeUnitName);
                        list.add(universalCoverage);
                    }
                }
            } else {
                unit = this._units.get(storeUnitName);
                if (unit == null) {
                    int ind = storeUnitName.lastIndexOf("@");
                    if (ind <= 0 || ind >= storeUnitName.length() - 1) throw new IllegalArgumentException("IllegalUnitFormat : " + storeUnitName);
                    String template = "*@" + storeUnitName.substring(ind + 1);
                    unit = this._units.get(template);
                    if (unit == null && (unit = this._units.get("*@*")) == null) {
                        _log.debug("no matching storage unit found for: {}", (Object)storeUnitName);
                        throw new IllegalArgumentException("Unit not found : " + storeUnitName);
                    }
                }
                _log.debug("matching storage unit found for: {}", (Object)storeUnitName);
                list.add(unit);
            }
            if (protocolUnitName != null) {
                unit = this.findProtocolUnit(protocolUnitName);
                if (unit == null) {
                    _log.debug("no matching protocol unit found for: {}", (Object)protocolUnitName);
                    throw new IllegalArgumentException("Unit not found : " + protocolUnitName);
                }
                _log.debug("matching protocol unit found: {}", (Object)unit);
                list.add(unit);
            }
            if (dCacheUnitName != null) {
                unit = this._units.get(dCacheUnitName);
                if (unit == null) {
                    _log.debug("no matching dCache unit found for: {}", (Object)dCacheUnitName);
                    throw new IllegalArgumentException("Unit not found : " + dCacheUnitName);
                }
                _log.debug("matching dCache unit found: {}", (Object)unit);
                list.add(unit);
            }
            if (netUnitName != null) {
                try {
                    unit = this._netHandler.match(netUnitName);
                    if (unit == null) {
                        _log.debug("no matching net unit found for: {}", (Object)netUnitName);
                        throw new IllegalArgumentException("Unit not matched : " + netUnitName);
                    }
                    _log.debug("matching net unit found: {}" + unit);
                    list.add(unit);
                }
                catch (UnknownHostException uhe) {
                    throw new IllegalArgumentException("NetUnit not resolved : " + netUnitName);
                }
            }
            int fitCount = list.size();
            TreeSet<Link> sortedSet = new TreeSet<Link>(new LinkComparator(type));
            LinkGroup linkGroup = null;
            if (linkGroupName != null && (linkGroup = this._linkGroups.get(linkGroupName)) == null) {
                _log.debug("LinkGroup not found : {}", (Object)linkGroupName);
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            LinkMap matchingLinks = new LinkMap();
            for (Unit unit3 : list) {
                matchingLinks = this.match(matchingLinks, unit3, linkGroup, type);
            }
            Iterator<Link> linkIterator = matchingLinks.iterator();
            while (linkIterator.hasNext()) {
                Link link = linkIterator.next();
                if (link._uGroupList.size() > fitCount || variableMap != null && !link.exec(variableMap)) continue;
                sortedSet.add(link);
            }
            int pref = -1;
            ArrayList listList = new ArrayList();
            ArrayList<Link> current = null;
            switch (type) {
                case READ: {
                    for (Link link : sortedSet) {
                        if (link._readPref < 1) continue;
                        if (link._readPref != pref) {
                            current = new ArrayList<Link>();
                            listList.add(current);
                            pref = link._readPref;
                        }
                        current.add(link);
                    }
                    break;
                }
                case CACHE: {
                    for (Link link : sortedSet) {
                        if (link._cachePref < 1) continue;
                        if (link._cachePref != pref) {
                            current = new ArrayList();
                            listList.add(current);
                            pref = link._cachePref;
                        }
                        current.add(link);
                    }
                    break;
                }
                case P2P: {
                    for (Link link : sortedSet) {
                        int tmpPref = link._p2pPref < 0 ? link._readPref : link._p2pPref;
                        if (tmpPref < 1) continue;
                        if (tmpPref != pref) {
                            current = new ArrayList();
                            listList.add(current);
                            pref = tmpPref;
                        }
                        current.add(link);
                    }
                    break;
                }
                case WRITE: {
                    for (Link link : sortedSet) {
                        if (link._writePref < 1) continue;
                        if (link._writePref != pref) {
                            current = new ArrayList();
                            listList.add(current);
                            pref = link._writePref;
                        }
                        current.add(link);
                    }
                    break;
                }
            }
            List[] x = listList.toArray(new List[listList.size()]);
            result = new PoolPreferenceLevel[x.length];
            for (int i = 0; i < x.length; ++i) {
                List linkList = x[i];
                ArrayList<String> resultList = new ArrayList<String>();
                String tag = null;
                for (Link link : linkList) {
                    if (tag == null && link._tag != null) {
                        tag = link._tag;
                    }
                    for (PoolCore poolCore : link._poolList.values()) {
                        if (poolCore instanceof Pool) {
                            Pool pool = (Pool)poolCore;
                            _log.debug("Pool: {} can read from tape? : {}", (Object)pool, (Object)pool.canReadFromTape());
                            if (!(type == PoolSelectionUnit.DirectionType.READ && pool.canRead() || type == PoolSelectionUnit.DirectionType.CACHE && pool.canReadFromTape() && this.poolCanStageFile(pool, storageInfo) || type == PoolSelectionUnit.DirectionType.WRITE && pool.canWrite()) && (type != PoolSelectionUnit.DirectionType.P2P || !pool.canWriteForP2P()) || !this._allPoolsActive && !pool.isActive()) continue;
                            resultList.add(pool.getName());
                            continue;
                        }
                        for (Pool pool : ((PGroup)poolCore)._poolList.values()) {
                            _log.debug("Pool: {} can read from tape? : {}", (Object)pool, (Object)pool.canReadFromTape());
                            if (!(type == PoolSelectionUnit.DirectionType.READ && pool.canRead() || type == PoolSelectionUnit.DirectionType.CACHE && pool.canReadFromTape() && this.poolCanStageFile(pool, storageInfo) || type == PoolSelectionUnit.DirectionType.WRITE && pool.canWrite()) && (type != PoolSelectionUnit.DirectionType.P2P || !pool.canWriteForP2P()) || !this._allPoolsActive && !pool.isActive()) continue;
                            resultList.add(pool.getName());
                        }
                    }
                }
                result[i] = new PoolPreferenceLevel(resultList, tag);
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        if (!_log.isDebugEnabled()) return result;
        StringBuilder sb = new StringBuilder("match done: ");
        for (int i = 0; i < result.length; ++i) {
            sb.append("[").append(i).append("] :");
            for (String poolName : result[i].getPoolList()) {
                sb.append(" ").append(poolName);
            }
        }
        _log.debug(sb.toString());
        return result;
    }

    @Override
    public String getProtocolUnit(String protocolUnitName) {
        Unit unit = this.findProtocolUnit(protocolUnitName);
        return unit == null ? null : unit.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unit findProtocolUnit(String protocolUnitName) {
        if (protocolUnitName == null || protocolUnitName.length() == 0) {
            return null;
        }
        int position = protocolUnitName.indexOf(47);
        if (position < 0 || position == 0 || position == protocolUnitName.length() - 1) {
            throw new IllegalArgumentException("Not a valid protocol specification : " + protocolUnitName);
        }
        Unit unit = null;
        this._psuReadLock.lock();
        try {
            unit = this._units.get(protocolUnitName);
            if (unit != null) {
                Unit unit2 = unit;
                return unit2;
            }
            unit = this._units.get(protocolUnitName.substring(0, position) + "/*");
            if (unit == null) {
                unit = this._units.get("*/*");
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNetIdentifier(String address) throws UnknownHostException {
        this._psuReadLock.lock();
        try {
            NetUnit unit = this._netHandler.match(address);
            if (unit == null) {
                String string = NO_NET;
                return string;
            }
            String string = unit.getCanonicalName();
            return string;
        }
        finally {
            this._psuReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Link> match(Unit unit, LinkGroup linkGroup, PoolSelectionUnit.DirectionType iotype) {
        HashMap<String, Link> map = new HashMap<String, Link>();
        this._psuReadLock.lock();
        try {
            for (UGroup uGroup : unit._uGroupList.values()) {
                for (Link link : uGroup._linkList.values()) {
                    if (linkGroup == null) {
                        if (iotype != PoolSelectionUnit.DirectionType.READ && link.getLinkGroup() != null) continue;
                        _log.debug("link {} matching to unit {}", (Object)link.getName(), (Object)unit);
                        map.put(link.getName(), link);
                        continue;
                    }
                    if (!linkGroup.contains(link)) continue;
                    _log.debug("link {} matching to unit {}", (Object)link.getName(), (Object)unit);
                    map.put(link.getName(), link);
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String ac_psu_set_allpoolsactive_$_1(Args args) throws CommandSyntaxException {
        String mode = args.argv(0);
        this._psuWriteLock.lock();
        try {
            switch (mode) {
                case "on": 
                case "true": {
                    this._allPoolsActive = true;
                    return "";
                }
                case "off": 
                case "false": {
                    this._allPoolsActive = false;
                    return "";
                }
                default: {
                    throw new CommandSyntaxException("Syntax error");
                }
            }
        }
        finally {
            this._psuWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_netmatch_$_1(Args args) throws UnknownHostException {
        NetUnit unit = null;
        this._psuReadLock.lock();
        try {
            unit = this._netHandler.match(args.argv(0));
        }
        finally {
            this._psuReadLock.unlock();
        }
        if (unit == null) {
            throw new IllegalArgumentException("Host not a unit : " + args.argv(0));
        }
        return unit.toString();
    }

    public String ac_psu_match_$_5(Args args) throws Exception {
        try {
            long start = System.currentTimeMillis();
            StorageInfo si = GenericStorageInfo.valueOf(args.argv(1), args.argv(2));
            PoolPreferenceLevel[] list = this.match(args.argv(0).equals("*") ? PoolSelectionUnit.DirectionType.ANY : PoolSelectionUnit.DirectionType.valueOf(args.argv(0).toUpperCase()), args.argv(3).equals("*") ? null : args.argv(3), args.argv(4).equals("*") ? null : args.argv(4), si, args.getOpt("linkGroup"));
            start = System.currentTimeMillis() - start;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                String tag = list[i].getTag();
                sb.append("Preference : ").append(i).append("\n");
                sb.append("       Tag : ").append(tag == null ? "NONE" : tag).append("\n");
                for (String s : list[i].getPoolList()) {
                    sb.append("  ").append(s).append("\n");
                }
            }
            sb.append("(time used : ").append(start).append(" millis)\n");
            return sb.toString();
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_match2_$_1_99(Args args) {
        StringBuilder sb = new StringBuilder();
        Map<String, Link> map = null;
        int required = args.argc();
        this._psuReadLock.lock();
        try {
            for (int i = 0; i < args.argc(); ++i) {
                String unitName = args.argv(i);
                Unit unit = this._units.get(unitName);
                if (unit == null) {
                    throw new IllegalArgumentException("Unit not found : " + unitName);
                }
                map = this.match(map, unit, PoolSelectionUnit.DirectionType.READ);
            }
            String netUnitName = args.getOpt("net");
            if (netUnitName != null) {
                NetUnit unit = this._netHandler.find(new NetUnit(netUnitName));
                if (unit == null) {
                    throw new IllegalArgumentException("Unit not found in netList : " + netUnitName);
                }
                map = this.match(map, unit, PoolSelectionUnit.DirectionType.READ);
            }
            for (Link link : map.values()) {
                if (link._uGroupList.size() != required) continue;
                sb.append("Link : ").append(link.toString()).append("\n");
                for (PoolSelectionUnit.SelectionPool pool : link.pools()) {
                    sb.append("    ").append(pool.getName()).append("\n");
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_create_pgroup_$_1(Args args) {
        String name = args.argv(0);
        this._psuWriteLock.lock();
        try {
            if (this._pGroups.get(name) != null) {
                throw new IllegalArgumentException("Duplicated entry : " + name);
            }
            PGroup group = new PGroup(name);
            this._pGroups.put(group.getName(), group);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    public String ac_psu_set_regex_$_1(Args args) {
        String retVal;
        String onOff;
        switch (onOff = args.argv(0)) {
            case "on": {
                this._useRegex = true;
                retVal = "regex turned on";
                break;
            }
            case "off": {
                this._useRegex = false;
                retVal = "regex turned off";
                break;
            }
            default: {
                throw new IllegalArgumentException("please set regex either on or off");
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_create_pool_$_1(Args args) {
        String name = args.argv(0);
        this._psuWriteLock.lock();
        try {
            if (this._pools.get(name) != null) {
                throw new IllegalArgumentException("Duplicated entry : " + name);
            }
            Pool pool = new Pool(name);
            if (args.hasOption("noping")) {
                pool.setPing(false);
            }
            if (args.hasOption("disabled")) {
                pool.setEnabled(false);
            }
            this._pools.put(pool.getName(), pool);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_pool_$_2(Args args) {
        Pattern pattern = Glob.parseGlobToPattern((String)args.argv(0));
        String mode = args.argv(1);
        this._psuWriteLock.lock();
        try {
            int count = 0;
            block19: for (Pool pool : this.getPools(pattern)) {
                ++count;
                switch (mode) {
                    case "enabled": {
                        pool.setEnabled(true);
                        continue block19;
                    }
                    case "disabled": {
                        pool.setEnabled(false);
                        continue block19;
                    }
                    case "ping": {
                        pool.setPing(true);
                        continue block19;
                    }
                    case "noping": {
                        pool.setPing(false);
                        continue block19;
                    }
                    case "rdonly": {
                        pool.setReadOnly(true);
                        continue block19;
                    }
                    case "notrdonly": {
                        pool.setReadOnly(false);
                        continue block19;
                    }
                }
                throw new IllegalArgumentException("mode not supported : " + mode);
            }
            String string = this.poolCountDescriptionFor(count) + " updated";
            return string;
        }
        finally {
            this._psuWriteLock.unlock();
        }
    }

    public String ac_psu_set_enabled_$_1(Args args) {
        int count = this.setEnabled(new Glob(args.argv(0)), true);
        return this.poolCountDescriptionFor(count) + " enabled";
    }

    public String ac_psu_set_disabled_$_1(Args args) {
        int count = this.setEnabled(new Glob(args.argv(0)), false);
        return this.poolCountDescriptionFor(count) + " disabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_create_link_$_2_99(Args args) {
        String name = args.argv(0);
        this._psuWriteLock.lock();
        try {
            if (this._links.get(name) != null) {
                throw new IllegalArgumentException("Duplicated entry : " + name);
            }
            Link link = new Link(name);
            for (int i = 1; i < args.argc(); ++i) {
                String uGroupName = args.argv(i);
                UGroup uGroup = this._uGroups.get(uGroupName);
                if (uGroup == null) {
                    throw new IllegalArgumentException("uGroup not found : " + uGroupName);
                }
                link._uGroupList.put(uGroup.getName(), uGroup);
            }
            for (UGroup group : link._uGroupList.values()) {
                group._linkList.put(link.getName(), link);
            }
            this._links.put(link.getName(), link);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_create_ugroup_$_1(Args args) {
        String name = args.argv(0);
        this._psuWriteLock.lock();
        try {
            if (this._uGroups.get(name) != null) {
                throw new IllegalArgumentException("Duplicated entry : " + name);
            }
            UGroup group = new UGroup(name);
            this._uGroups.put(group.getName(), group);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_create_unit_$_1(Args args) {
        String name = args.argv(0);
        Unit unit = null;
        this._psuWriteLock.lock();
        try {
            if (args.hasOption("net")) {
                NetUnit net = new NetUnit(name);
                this._netHandler.add(net);
                unit = net;
            } else if (args.hasOption("store")) {
                unit = new Unit(name, 1);
            } else if (args.hasOption("dcache")) {
                unit = new Unit(name, 2);
            } else if (args.hasOption("protocol")) {
                unit = new ProtocolUnit(name);
            }
            if (unit == null) {
                throw new IllegalArgumentException("Unit type missing net/store/dcache/protocol");
            }
            String canonicalName = name;
            if (this._units.get(canonicalName) != null) {
                throw new IllegalArgumentException("Duplicated entry : " + canonicalName);
            }
            this._units.put(canonicalName, unit);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_create_linkGroup_$_1(Args args) {
        String newGroupName = args.argv(0);
        boolean reset = args.hasOption("reset");
        this._psuWriteLock.lock();
        try {
            if (this._linkGroups.containsKey(newGroupName) && !reset) {
                throw new IllegalArgumentException("LinkGroup already exists : " + newGroupName);
            }
            LinkGroup newGroup = new LinkGroup(newGroupName);
            this._linkGroups.put(newGroupName, newGroup);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ac_psux_ls_pool_$_0_1(Args args) {
        Object[] xlsResult = null;
        this._psuReadLock.lock();
        try {
            if (args.argc() == 0) {
                xlsResult = this._pools.keySet().toArray();
            } else {
                String poolName = args.argv(0);
                Pool pool = this._pools.get(poolName);
                if (pool == null) {
                    throw new IllegalArgumentException("Not found : " + poolName);
                }
                Object[] result = new Object[]{poolName, pool._pGroupList.keySet().toArray(), pool._linkList.keySet().toArray(), pool._enabled, pool.getActive(), pool._rdOnly};
                xlsResult = result;
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return xlsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ac_psux_ls_pgroup_$_0_1(Args args) {
        Object[] xlsResult = null;
        this._psuReadLock.lock();
        try {
            if (args.argc() == 0) {
                xlsResult = this._pGroups.keySet().toArray();
            } else {
                String groupName = args.argv(0);
                PGroup group = this._pGroups.get(groupName);
                if (group == null) {
                    throw new IllegalArgumentException("Not found : " + groupName);
                }
                Object[] result = new Object[]{groupName, group._poolList.keySet().toArray(), group._linkList.keySet().toArray()};
                xlsResult = result;
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return xlsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PoolSelectionUnit.SelectionPoolGroup> getPoolGroups() {
        this._psuReadLock.lock();
        try {
            ArrayList<PoolSelectionUnit.SelectionPoolGroup> arrayList = new ArrayList<PoolSelectionUnit.SelectionPoolGroup>(this._pGroups.values());
            return arrayList;
        }
        finally {
            this._psuReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ac_psux_ls_unit_$_0_1(Args args) {
        Object[] xlsResult = null;
        this._psuReadLock.lock();
        try {
            if (args.argc() == 0) {
                xlsResult = this._units.keySet().toArray();
            } else {
                String unitName = args.argv(0);
                Unit unit = this._units.get(unitName);
                if (unit == null) {
                    throw new IllegalArgumentException("Not found : " + unitName);
                }
                Object[] result = new Object[]{unitName, unit._type == 1 ? "Store" : (unit._type == 4 ? "Protocol" : (unit._type == 2 ? "dCache" : (unit._type == 3 ? "Net" : "Unknown"))), unit._uGroupList.keySet().toArray()};
                xlsResult = result;
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return xlsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ac_psux_ls_ugroup_$_0_1(Args args) {
        Object[] xlsResult = null;
        this._psuReadLock.lock();
        try {
            if (args.argc() == 0) {
                xlsResult = this._uGroups.keySet().toArray();
            } else {
                String groupName = args.argv(0);
                UGroup group = this._uGroups.get(groupName);
                if (group == null) {
                    throw new IllegalArgumentException("Not found : " + groupName);
                }
                Object[] result = new Object[]{groupName, group._unitList.keySet().toArray(), group._linkList.keySet().toArray()};
                xlsResult = result;
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return xlsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object ac_psux_ls_link_$_0_1(Args args) {
        boolean resolve = args.hasOption("resolve");
        Object xlsResult = null;
        this._psuReadLock.lock();
        try {
            if (args.argc() == 0) {
                if (!args.hasOption("x")) {
                    xlsResult = this._links.keySet().toArray();
                } else {
                    ArrayList<Object[]> array = new ArrayList<Object[]>();
                    for (Link link : this._links.values()) {
                        array.add(this.fillLinkProperties(link, resolve));
                    }
                    xlsResult = array;
                }
            } else {
                String linkName = args.argv(0);
                Link link = this._links.get(linkName);
                if (link == null) {
                    throw new IllegalArgumentException("Not found : " + linkName);
                }
                xlsResult = this.fillLinkProperties(link, resolve);
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return xlsResult;
    }

    private Object[] fillLinkProperties(Link link, boolean resolve) {
        ArrayList<String> pools = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        for (PoolCore core : link._poolList.values()) {
            if (core instanceof Pool) {
                pools.add(core.getName());
                continue;
            }
            groups.add(core.getName());
            if (!resolve) continue;
            PGroup pg = (PGroup)core;
            if (pg._poolList == null) continue;
            for (String poolName : pg._poolList.keySet()) {
                pools.add(poolName);
            }
        }
        Object[] result = new Object[resolve ? 13 : 9];
        result[0] = link._name;
        result[1] = link._readPref;
        result[2] = link._cachePref;
        result[3] = link._writePref;
        result[4] = link._uGroupList.keySet().toArray();
        result[5] = pools.toArray();
        result[6] = groups.toArray();
        result[7] = link._p2pPref;
        result[8] = link._tag;
        if (!resolve || link._uGroupList == null) {
            return result;
        }
        ArrayList<String> net = new ArrayList<String>();
        ArrayList<String> protocol = new ArrayList<String>();
        ArrayList<String> dcache = new ArrayList<String>();
        ArrayList<String> store = new ArrayList<String>();
        for (UGroup ug : link._uGroupList.values()) {
            if (ug._unitList == null) continue;
            for (Unit unit : ug._unitList.values()) {
                switch (unit._type) {
                    case 3: {
                        net.add(unit._name);
                        break;
                    }
                    case 4: {
                        protocol.add(unit._name);
                        break;
                    }
                    case 2: {
                        dcache.add(unit._name);
                        break;
                    }
                    case 1: {
                        store.add(unit._name);
                    }
                }
            }
            result[9] = store.toArray();
            result[10] = net.toArray();
            result[11] = dcache.toArray();
            result[12] = protocol.toArray();
        }
        return result;
    }

    public Object ac_psux_match_$_5(Args args) {
        StorageInfo si = GenericStorageInfo.valueOf(args.argv(1), args.argv(2));
        PoolPreferenceLevel[] list = this.match(PoolSelectionUnit.DirectionType.valueOf(args.argv(0).toUpperCase()), args.argv(3).equals("*") ? null : args.argv(3), args.argv(4).equals("*") ? null : args.argv(4), si, args.getOpt("linkGroup"));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_ls_pool_$_0_99(Args args) {
        StringBuilder sb = new StringBuilder();
        boolean more = args.hasOption("a");
        boolean detail = args.hasOption("l") || more;
        this._psuReadLock.lock();
        try {
            Collection<Pool> pools;
            if (args.argc() == 0) {
                pools = this._pools.values();
            } else {
                pools = new ArrayList<Pool>();
                for (int n = 0; n < args.argc(); ++n) {
                    pools.addAll(this.getPools(Glob.parseGlobToPattern((String)args.argv(n))));
                }
            }
            for (Pool pool : pools) {
                if (!detail) {
                    sb.append(pool.getName()).append("\n");
                    continue;
                }
                sb.append(pool).append("\n");
                sb.append(" linkList   :\n");
                for (Link link : pool._linkList.values()) {
                    sb.append("   ").append(link).append("\n");
                }
                if (!more) continue;
                sb.append(" pGroupList : \n");
                for (PGroup group : pool._pGroupList.values()) {
                    sb.append("   ").append(group).append("\n");
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_ls_pgroup_$_0_99(Args args) {
        StringBuilder sb = new StringBuilder();
        boolean more = args.hasOption("a");
        boolean detail = args.hasOption("l") || more;
        this._psuReadLock.lock();
        try {
            Iterator<PGroup> i;
            if (args.argc() == 0) {
                i = this._pGroups.values().iterator();
            } else {
                ArrayList<PGroup> l = new ArrayList<PGroup>();
                for (int n = 0; n < args.argc(); ++n) {
                    PGroup o = this._pGroups.get(args.argv(n));
                    if (o == null) continue;
                    l.add(o);
                }
                i = l.iterator();
            }
            while (i.hasNext()) {
                PGroup group = i.next();
                sb.append(group.getName()).append("\n");
                if (!detail) continue;
                sb.append(" linkList :\n");
                for (Link link : group._linkList.values()) {
                    sb.append("   ").append(link.toString()).append("\n");
                }
                sb.append(" poolList :\n");
                for (Pool pool : group._poolList.values()) {
                    sb.append("   ").append(pool.toString()).append("\n");
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_ls_link_$_0_99(Args args) {
        StringBuilder sb = new StringBuilder();
        boolean more = args.hasOption("a");
        boolean detail = args.hasOption("l") || more;
        this._psuReadLock.lock();
        try {
            Iterator<Link> i;
            if (args.argc() == 0) {
                i = this._links.values().iterator();
            } else {
                ArrayList<Link> l = new ArrayList<Link>();
                for (int n = 0; n < args.argc(); ++n) {
                    Link o = this._links.get(args.argv(n));
                    if (o == null) continue;
                    l.add(o);
                }
                i = l.iterator();
            }
            while (i.hasNext()) {
                Link link = i.next();
                sb.append(link.getName()).append("\n");
                if (!detail) continue;
                sb.append(" readPref  : ").append(link._readPref).append("\n");
                sb.append(" cachePref : ").append(link._cachePref).append("\n");
                sb.append(" writePref : ").append(link._writePref).append("\n");
                sb.append(" p2pPref   : ").append(link._p2pPref).append("\n");
                sb.append(" section   : ").append(link._tag == null ? "None" : link._tag).append("\n");
                sb.append(" linkGroup : ").append(link.getLinkGroup() == null ? "None" : link.getLinkGroup().getName()).append("\n");
                sb.append(" UGroups :\n");
                for (UGroup group : link._uGroupList.values()) {
                    sb.append("   ").append(group.toString()).append("\n");
                }
                if (!more) continue;
                sb.append(" poolList  :\n");
                for (PoolCore core : link._poolList.values()) {
                    sb.append("   ").append(core.toString()).append("\n");
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_ls_ugroup_$_0_99(Args args) {
        StringBuilder sb = new StringBuilder();
        boolean more = args.hasOption("a");
        boolean detail = args.hasOption("l") || more;
        this._psuReadLock.lock();
        try {
            Iterator<UGroup> i;
            if (args.argc() == 0) {
                i = this._uGroups.values().iterator();
            } else {
                ArrayList<UGroup> l = new ArrayList<UGroup>();
                for (int n = 0; n < args.argc(); ++n) {
                    UGroup o = this._uGroups.get(args.argv(n));
                    if (o == null) continue;
                    l.add(o);
                }
                i = l.iterator();
            }
            while (i.hasNext()) {
                UGroup group = i.next();
                sb.append(group.getName()).append("\n");
                if (!detail) continue;
                sb.append(" unitList :\n");
                for (Unit unit : group._unitList.values()) {
                    sb.append("   ").append(unit.toString()).append("\n");
                }
                if (!more) continue;
                sb.append(" linkList :\n");
                for (Link link : group._linkList.values()) {
                    sb.append("   ").append(link.toString()).append("\n");
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_ls_netunits(Args args) {
        StringBuilder sb = new StringBuilder();
        this._psuReadLock.lock();
        try {
            for (int i = 0; i < this._netHandler._netList.length; ++i) {
                Map<Long, NetUnit> map = this._netHandler._netList[i];
                if (map == null) continue;
                String stringMask = this._netHandler.bitsToString(i);
                sb.append(stringMask).append("/").append(i).append("\n");
                for (NetUnit net : map.values()) {
                    sb.append("   ").append(net.getHostAddress().getHostName());
                    if (i > 0) {
                        sb.append("/").append(stringMask);
                    }
                    sb.append("\n");
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_ls_unit_$_0_99(Args args) {
        StringBuilder sb = new StringBuilder();
        boolean more = args.hasOption("a");
        boolean detail = args.hasOption("l") || more;
        this._psuReadLock.lock();
        try {
            Iterator<Unit> i;
            if (args.argc() == 0) {
                i = this._units.values().iterator();
            } else {
                ArrayList<Unit> l = new ArrayList<Unit>();
                for (int n = 0; n < args.argc(); ++n) {
                    Unit o = this._units.get(args.argv(n));
                    if (o == null) continue;
                    l.add(o);
                }
                i = l.iterator();
            }
            while (i.hasNext()) {
                Unit unit = i.next();
                if (detail) {
                    sb.append(unit.toString()).append("\n");
                    if (!more) continue;
                    sb.append(" uGroupList :\n");
                    for (UGroup group : unit._uGroupList.values()) {
                        sb.append("   ").append(group.toString()).append("\n");
                    }
                    continue;
                }
                sb.append(unit.getName()).append("\n");
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_ls_linkGroup_$_0_99(Args args) {
        StringBuilder sb = new StringBuilder();
        boolean isLongOutput = args.hasOption("l");
        this._psuReadLock.lock();
        try {
            if (args.argc() != 0) {
                int count = args.argc();
                for (int i = 0; i < count; ++i) {
                    LinkGroup linkGroup = this._linkGroups.get(args.argv(i));
                    if (linkGroup == null) {
                        throw new IllegalArgumentException("LinkGroup not found : " + args.argv(i));
                    }
                    if (isLongOutput) {
                        sb.append(linkGroup).append("\n");
                        continue;
                    }
                    sb.append(args.argv(i)).append("\n");
                }
            } else {
                Set<String> allGroups = this._linkGroups.keySet();
                for (String groupName : allGroups) {
                    LinkGroup linkGroup = this._linkGroups.get(groupName);
                    if (linkGroup == null) {
                        throw new IllegalArgumentException("LinkGroup not found : " + groupName);
                    }
                    if (isLongOutput) {
                        sb.append(linkGroup).append("\n");
                        continue;
                    }
                    sb.append(groupName).append("\n");
                }
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return sb.toString();
    }

    public String ac_psu_dump_setup(Args args) {
        StringWriter s = new StringWriter();
        this.printSetup(new PrintWriter(s));
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_remove_unit_$_1(Args args) {
        String unitName = args.argv(0);
        this._psuWriteLock.lock();
        try {
            Unit unit;
            if (args.hasOption("net")) {
                NetUnit netUnit = this._netHandler.find(new NetUnit(unitName));
                if (netUnit == null) {
                    throw new IllegalArgumentException("Not found in netList : " + unitName);
                }
                unitName = netUnit.getName();
            }
            if ((unit = this._units.get(unitName)) == null) {
                throw new IllegalArgumentException("Unit not found : " + unitName);
            }
            if (unit instanceof NetUnit) {
                this._netHandler.remove((NetUnit)unit);
            }
            for (UGroup group : unit._uGroupList.values()) {
                group._unitList.remove(unit.getCanonicalName());
            }
            this._units.remove(unitName);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_remove_ugroup_$_1(Args args) {
        String groupName = args.argv(0);
        this._psuWriteLock.lock();
        try {
            UGroup group = this._uGroups.get(groupName);
            if (group == null) {
                throw new IllegalArgumentException("UGroup not found : " + groupName);
            }
            if (group._unitList.size() > 0) {
                throw new IllegalArgumentException("UGroup not empty : " + groupName);
            }
            if (group._linkList.size() > 0) {
                throw new IllegalArgumentException("Still link(s) pointing to us : " + groupName);
            }
            this._uGroups.remove(groupName);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_remove_pgroup_$_1(Args args) {
        String name = args.argv(0);
        this._psuWriteLock.lock();
        try {
            PGroup group = this._pGroups.get(name);
            if (group == null) {
                throw new IllegalArgumentException("PGroup not found : " + name);
            }
            if (group._poolList.size() != 0) {
                throw new IllegalArgumentException("PGroup not empty : " + name);
            }
            PGroup core = group;
            for (Link link : core._linkList.values()) {
                link._poolList.remove(core.getName());
            }
            this._pGroups.remove(name);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_remove_pool_$_1(Args args) {
        String name = args.argv(0);
        this._psuWriteLock.lock();
        try {
            Pool pool = this._pools.get(name);
            if (pool == null) {
                throw new IllegalArgumentException("Pool not found : " + name);
            }
            for (PGroup group : pool._pGroupList.values()) {
                group._poolList.remove(pool.getName());
            }
            Pool core = pool;
            for (Link link : core._linkList.values()) {
                link._poolList.remove(((PoolCore)core).getName());
            }
            this._pools.remove(name);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_removefrom_ugroup_$_2(Args args) {
        String groupName = args.argv(0);
        String unitName = args.argv(1);
        this._psuWriteLock.lock();
        try {
            Unit unit;
            UGroup group = this._uGroups.get(groupName);
            if (group == null) {
                throw new IllegalArgumentException("UGroup not found : " + groupName);
            }
            if (args.hasOption("net")) {
                NetUnit netUnit = this._netHandler.find(new NetUnit(unitName));
                if (netUnit == null) {
                    throw new IllegalArgumentException("Not found in netList : " + unitName);
                }
                unitName = netUnit.getName();
            }
            if ((unit = this._units.get(unitName)) == null) {
                throw new IllegalArgumentException("Unit not found : " + unitName);
            }
            String canonicalName = unit.getCanonicalName();
            if (group._unitList.get(canonicalName) == null) {
                throw new IllegalArgumentException(unitName + " not member of " + groupName);
            }
            group._unitList.remove(canonicalName);
            unit._uGroupList.remove(groupName);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_removefrom_pgroup_$_2(Args args) {
        String groupName = args.argv(0);
        String poolName = args.argv(1);
        this._psuWriteLock.lock();
        try {
            Pool pool = this._pools.get(poolName);
            if (pool == null) {
                throw new IllegalArgumentException("Pool not found : " + poolName);
            }
            PGroup group = this._pGroups.get(groupName);
            if (group == null) {
                throw new IllegalArgumentException("PGroup not found : " + groupName);
            }
            if (group._poolList.get(poolName) == null) {
                throw new IllegalArgumentException(poolName + " not member of " + groupName);
            }
            group._poolList.remove(poolName);
            pool._pGroupList.remove(groupName);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_removefrom_linkGroup_$_2(Args args) {
        String linkGroupName = args.argv(0);
        String linkName = args.argv(1);
        this._psuWriteLock.lock();
        try {
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            Link link = this._links.get(linkName);
            if (link == null) {
                throw new IllegalArgumentException("Link is not found : " + linkName);
            }
            if (!linkGroup.remove(link)) {
                throw new IllegalArgumentException("Link [" + linkName + "] is not part of group : " + linkGroupName);
            }
            link.setLinkGroup(null);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_remove_linkGroup_$_1(Args args) {
        String linkGroupName = args.argv(0);
        this._psuWriteLock.lock();
        try {
            LinkGroup linkGroup = this._linkGroups.remove(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            for (PoolSelectionUnit.SelectionLink link : linkGroup.getAllLinks()) {
                if (!(link instanceof Link)) continue;
                ((Link)link).setLinkGroup(null);
            }
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_remove_link_$_1(Args args) {
        String name = args.argv(0);
        this._psuWriteLock.lock();
        try {
            LinkGroup lGroup;
            Link link = this._links.get(name);
            if (link == null) {
                throw new IllegalArgumentException("Link not found : " + name);
            }
            for (PoolCore core : link._poolList.values()) {
                core._linkList.remove(name);
            }
            for (UGroup group : link._uGroupList.values()) {
                group._linkList.remove(name);
            }
            Iterator<Serializable> i$ = this._linkGroups.values().iterator();
            while (i$.hasNext() && !(lGroup = (LinkGroup)i$.next()).remove(link)) {
            }
            this._links.remove(name);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    public String ac_psu_addto_pgroup_$_2(Args args) {
        String pGroupName = args.argv(0);
        String poolName = args.argv(1);
        this.addtoPoolGroup(pGroupName, poolName);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addtoPoolGroup(String pGroupName, String poolName) throws IllegalArgumentException {
        this._psuWriteLock.lock();
        try {
            PGroup group = this._pGroups.get(pGroupName);
            if (group == null) {
                throw new IllegalArgumentException("Not found : " + pGroupName);
            }
            Pool pool = this._pools.get(poolName);
            if (pool == null) {
                throw new IllegalArgumentException("Not found : " + poolName);
            }
            pool._pGroupList.put(group.getName(), group);
            group._poolList.put(pool.getName(), pool);
        }
        finally {
            this._psuWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_addto_ugroup_$_2(Args args) {
        String uGroupName = args.argv(0);
        String unitName = args.argv(1);
        this._psuWriteLock.lock();
        try {
            UGroup group;
            if (args.hasOption("net")) {
                NetUnit netUnit = this._netHandler.find(new NetUnit(unitName));
                if (netUnit == null) {
                    throw new IllegalArgumentException("Not found in netList : " + unitName);
                }
                unitName = netUnit.getName();
            }
            if ((group = this._uGroups.get(uGroupName)) == null) {
                throw new IllegalArgumentException("Not found : " + uGroupName);
            }
            Unit unit = this._units.get(unitName);
            if (unit == null) {
                throw new IllegalArgumentException("Not found : " + unitName);
            }
            String canonicalName = unit.getCanonicalName();
            if (group._unitList.get(canonicalName) != null) {
                throw new IllegalArgumentException(unitName + " already member of " + uGroupName);
            }
            unit._uGroupList.put(group.getName(), group);
            group._unitList.put(canonicalName, unit);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_addto_linkGroup_$_2(Args args) {
        String linkGroupName = args.argv(0);
        String linkName = args.argv(1);
        this._psuWriteLock.lock();
        try {
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkName);
            }
            Link link = this._links.get(linkName);
            if (link == null) {
                throw new IllegalArgumentException("Link not found : " + linkName);
            }
            for (LinkGroup group : this._linkGroups.values()) {
                if (!group.contains(link)) continue;
                throw new IllegalArgumentException("Link already in linkGroup `" + group.getName() + "`");
            }
            linkGroup.add(link);
            link.setLinkGroup(linkGroup);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_unlink_$_2(Args args) {
        String linkName = args.argv(0);
        String poolName = args.argv(1);
        this._psuWriteLock.lock();
        try {
            Link link = this._links.get(linkName);
            if (link == null) {
                throw new IllegalArgumentException("Not found : " + linkName);
            }
            PoolCore core = this._pools.get(poolName);
            if (core == null) {
                core = this._pGroups.get(poolName);
            }
            if (core == null) {
                throw new IllegalArgumentException("Not found : " + poolName);
            }
            if (core._linkList.get(linkName) == null) {
                throw new IllegalArgumentException(poolName + " not member of " + linkName);
            }
            core._linkList.remove(linkName);
            link._poolList.remove(poolName);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_add_link_$_2(Args args) {
        String linkName = args.argv(0);
        String poolName = args.argv(1);
        this._psuWriteLock.lock();
        try {
            Link link = this._links.get(linkName);
            if (link == null) {
                throw new IllegalArgumentException("Not found : " + linkName);
            }
            PoolCore core = this._pools.get(poolName);
            if (core == null) {
                core = this._pGroups.get(poolName);
            }
            if (core == null) {
                throw new IllegalArgumentException("Not found : " + poolName);
            }
            core._linkList.put(link.getName(), link);
            link._poolList.put(core.getName(), core);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_active_$_1(Args args) {
        String poolName = args.argv(0);
        boolean active = !args.hasOption("no");
        this._psuWriteLock.lock();
        try {
            if (poolName.equals("*")) {
                for (Pool pool : this._pools.values()) {
                    pool.setActive(active);
                }
            } else {
                Pool pool = this._pools.get(poolName);
                if (pool == null) {
                    throw new IllegalArgumentException("Pool not found : " + poolName);
                }
                pool.setActive(active);
            }
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_link_$_1(Args args) {
        String linkName = args.argv(0);
        this._psuWriteLock.lock();
        try {
            Link link = this._links.get(linkName);
            if (link == null) {
                throw new IllegalArgumentException("Not found : " + linkName);
            }
            String tmp = args.getOpt("readpref");
            if (tmp != null) {
                link._readPref = Integer.parseInt(tmp);
            }
            if ((tmp = args.getOpt("cachepref")) != null) {
                link._cachePref = Integer.parseInt(tmp);
            }
            if ((tmp = args.getOpt("writepref")) != null) {
                link._writePref = Integer.parseInt(tmp);
            }
            if ((tmp = args.getOpt("p2ppref")) != null) {
                link._p2pPref = Integer.parseInt(tmp);
            }
            if ((tmp = args.getOpt("section")) != null) {
                link._tag = tmp.equals("NONE") ? null : tmp;
            }
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_linkGroup_attribute_$_2(Args args) {
        this._psuWriteLock.lock();
        try {
            String linkGroupName = args.argv(0);
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            String[] attrKeyValue = args.argv(1).split("=");
            if (attrKeyValue.length == 1 || attrKeyValue[1] == null || attrKeyValue[1].length() == 0) {
                String string = "bad value";
                return string;
            }
            linkGroup.attribute(attrKeyValue[0], attrKeyValue[1], args.hasOption("r"));
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_remove_linkGroup_attribute_$_2(Args args) {
        this._psuWriteLock.lock();
        try {
            String linkGroupName = args.argv(0);
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            String[] attrKeyValue = args.argv(1).split("=");
            if (attrKeyValue.length == 1 || attrKeyValue[1] == null || attrKeyValue[1].length() == 0) {
                String string = "bad value";
                return string;
            }
            linkGroup.removeAttribute(attrKeyValue[0], attrKeyValue[1]);
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_linkGroup_custodialAllowed_$_2(Args args) {
        this._psuWriteLock.lock();
        try {
            String linkGroupName = args.argv(0);
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            linkGroup.setCustodialAllowed(Boolean.parseBoolean(args.argv(1)));
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_linkGroup_outputAllowed_$_2(Args args) {
        this._psuWriteLock.lock();
        try {
            String linkGroupName = args.argv(0);
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            linkGroup.setOutputAllowed(Boolean.parseBoolean(args.argv(1)));
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_linkGroup_replicaAllowed_$_2(Args args) {
        this._psuWriteLock.lock();
        try {
            String linkGroupName = args.argv(0);
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            linkGroup.setReplicaAllowed(Boolean.parseBoolean(args.argv(1)));
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_linkGroup_onlineAllowed_$_2(Args args) {
        this._psuWriteLock.lock();
        try {
            String linkGroupName = args.argv(0);
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            linkGroup.setOnlineAllowed(Boolean.parseBoolean(args.argv(1)));
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_psu_set_linkGroup_nearlineAllowed_$_2(Args args) {
        this._psuWriteLock.lock();
        try {
            String linkGroupName = args.argv(0);
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new IllegalArgumentException("LinkGroup not found : " + linkGroupName);
            }
            linkGroup.setNearlineAllowed(Boolean.parseBoolean(args.argv(1)));
        }
        finally {
            this._psuWriteLock.unlock();
        }
        return "";
    }

    public String ac_psu_clear_im_really_sure(Args args) {
        this.clear();
        return "Voila, now everthing is really gone";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLinkGroups() {
        String[] linkGroups;
        this._psuReadLock.lock();
        try {
            linkGroups = this._linkGroups.keySet().toArray(new String[this._linkGroups.size()]);
        }
        finally {
            this._psuReadLock.unlock();
        }
        return linkGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkGroup getLinkGroupByName(String linkGroupName) {
        LinkGroup linkGroup = null;
        this._psuReadLock.lock();
        try {
            linkGroup = this._linkGroups.get(linkGroupName);
        }
        finally {
            this._psuReadLock.unlock();
        }
        return linkGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLinksByGroupName(String linkGroupName) throws NoSuchElementException {
        String[] linkNames = null;
        this._psuReadLock.lock();
        try {
            LinkGroup linkGroup = this._linkGroups.get(linkGroupName);
            if (linkGroup == null) {
                throw new NoSuchElementException("LinkGroup not found : " + linkGroupName);
            }
            Collection<PoolSelectionUnit.SelectionLink> links = linkGroup.links();
            int count = links.size();
            linkNames = new String[count];
            int j = 0;
            for (PoolSelectionUnit.SelectionLink link : links) {
                linkNames[j++] = link.getName();
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return linkNames;
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionPoolGroup> getPoolGroupsOfPool(String PoolName) {
        this._psuReadLock.lock();
        try {
            Pool pool = this._pools.get(PoolName);
            if (pool != null) {
                ArrayList<PoolSelectionUnit.SelectionPoolGroup> arrayList = new ArrayList<PoolSelectionUnit.SelectionPoolGroup>(pool._pGroupList.values());
                return arrayList;
            }
            throw new NoSuchElementException(PoolName);
        }
        finally {
            this._psuReadLock.unlock();
        }
    }

    private boolean poolCanStageFile(Pool pool, StorageInfo file) {
        boolean rc = false;
        if (file.locations().isEmpty() && pool.getHsmInstances().contains(file.getHsm())) {
            rc = true;
        } else {
            for (URI uri : file.locations()) {
                if (!pool.getHsmInstances().contains(uri.getAuthority())) continue;
                rc = true;
            }
        }
        _log.debug("{}: matching hsm ({}) found?: {}", new Object[]{pool.getName(), file.getHsm(), rc});
        return rc;
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionPool> getPoolsByPoolGroup(String poolGroup) throws NoSuchElementException {
        PGroup group = this._pGroups.get(poolGroup);
        if (group == null) {
            throw new NoSuchElementException("No such pool group: " + poolGroup);
        }
        return new ArrayList<PoolSelectionUnit.SelectionPool>(group._poolList.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PoolSelectionUnit.SelectionPool> getAllDefinedPools(boolean enabledOnly) {
        ArrayList<PoolSelectionUnit.SelectionPool> pools = new ArrayList<PoolSelectionUnit.SelectionPool>(this._pools.size());
        this._psuReadLock.lock();
        try {
            for (Pool pool : this._pools.values()) {
                if (enabledOnly && !pool.isEnabled()) continue;
                pools.add(pool);
            }
        }
        finally {
            this._psuReadLock.unlock();
        }
        return pools;
    }

    private Collection<Pool> getPools(Pattern pattern) {
        return Maps.filterKeys(this._pools, (Predicate)Predicates.contains((Pattern)pattern)).values();
    }

    private String poolCountDescriptionFor(int count) {
        switch (count) {
            case 0: {
                return "No pools";
            }
            case 1: {
                return "One pool";
            }
        }
        return String.valueOf(count) + " pools";
    }
}

