/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.poolManager.PoolPreferenceLevel;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CostException;
import diskCacheV111.util.FileLocality;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.FileNotOnlineCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.PoolCostCheckable;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import dmg.cells.nucleus.CellMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PartitionManager;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.poolmanager.PoolMonitor;
import org.dcache.poolmanager.PoolSelector;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolMonitorV5
implements Serializable,
PoolMonitor {
    private static final Logger _log = LoggerFactory.getLogger(PoolMonitorV5.class);
    private static final long serialVersionUID = -2400834413958127412L;
    private PoolSelectionUnit _selectionUnit;
    private CostModule _costModule;
    private PartitionManager _partitionManager;

    @Override
    public PoolSelectionUnit getPoolSelectionUnit() {
        return this._selectionUnit;
    }

    public void setPoolSelectionUnit(PoolSelectionUnit selectionUnit) {
        this._selectionUnit = selectionUnit;
    }

    @Override
    public CostModule getCostModule() {
        return this._costModule;
    }

    public void setCostModule(CostModule costModule) {
        this._costModule = costModule;
    }

    @Override
    public PartitionManager getPartitionManager() {
        return this._partitionManager;
    }

    public void setPartitionManager(PartitionManager partitionManager) {
        this._partitionManager = partitionManager;
    }

    public void messageToCostModule(CellMessage cellMessage) {
        this._costModule.messageArrived(cellMessage);
    }

    @Override
    public PoolSelector getPoolSelector(FileAttributes fileAttributes, ProtocolInfo protocolInfo, String linkGroup) {
        return new PnfsFileLocation(fileAttributes, protocolInfo, linkGroup);
    }

    @Override
    public Collection<PoolCostCheckable> queryPoolsByLinkName(String linkName, long filesize) {
        Function<PoolSelectionUnit.SelectionPool, String> getName = new Function<PoolSelectionUnit.SelectionPool, String>(){

            public String apply(PoolSelectionUnit.SelectionPool pool) {
                return pool.getName();
            }
        };
        PoolSelectionUnit.SelectionLink link = this._selectionUnit.getLinkByName(linkName);
        return this.queryPoolsForCost(Iterables.transform(link.pools(), (Function)getName), filesize);
    }

    private List<PoolCostCheckable> queryPoolsForCost(Iterable<String> pools, long filesize) {
        ArrayList<PoolCostCheckable> list = new ArrayList<PoolCostCheckable>();
        for (String poolName : pools) {
            PoolCostCheckable costCheck = this._costModule.getPoolCost(poolName, filesize);
            if (costCheck == null) continue;
            list.add(costCheck);
            _log.info("queryPoolsForCost : costModule : " + poolName + " (" + filesize + ") " + costCheck);
        }
        return list;
    }

    private PoolManagerPoolInformation getPoolInformation(PoolSelectionUnit.SelectionPool pool) {
        String name = pool.getName();
        PoolManagerPoolInformation info = new PoolManagerPoolInformation(name);
        PoolCostCheckable cost = this._costModule.getPoolCost(name, 0L);
        if (!pool.isActive() || cost == null) {
            info.setSpaceCost(Double.POSITIVE_INFINITY);
            info.setCpuCost(Double.POSITIVE_INFINITY);
        } else {
            info.setSpaceCost(cost.getSpaceCost());
            info.setCpuCost(cost.getPerformanceCost());
        }
        info.setPoolCostInfo(this._costModule.getPoolCostInfo(name));
        return info;
    }

    private Collection<PoolManagerPoolInformation> getPoolInformation(Collection<PoolSelectionUnit.SelectionPool> pools) {
        ArrayList<PoolManagerPoolInformation> result = new ArrayList<PoolManagerPoolInformation>();
        for (PoolSelectionUnit.SelectionPool pool : pools) {
            result.add(this.getPoolInformation(pool));
        }
        return result;
    }

    @Override
    public PoolManagerPoolInformation getPoolInformation(String name) throws NoSuchElementException {
        PoolSelectionUnit.SelectionPool pool = this._selectionUnit.getPool(name);
        if (pool == null) {
            throw new NoSuchElementException("No such pool: " + name);
        }
        return this.getPoolInformation(pool);
    }

    @Override
    public Collection<PoolManagerPoolInformation> getPoolsByLink(String linkName) throws NoSuchElementException {
        PoolSelectionUnit.SelectionLink link = this._selectionUnit.getLinkByName(linkName);
        return new ArrayList<PoolManagerPoolInformation>(this.getPoolInformation(link.pools()));
    }

    @Override
    public Collection<PoolManagerPoolInformation> getPoolsByPoolGroup(String poolGroup) throws NoSuchElementException {
        Collection<PoolSelectionUnit.SelectionPool> pools = this._selectionUnit.getPoolsByPoolGroup(poolGroup);
        return new ArrayList<PoolManagerPoolInformation>(this.getPoolInformation(pools));
    }

    public static Set<FileAttribute> getRequiredAttributesForFileLocality() {
        return EnumSet.of(FileAttribute.STORAGEINFO, FileAttribute.SIZE, FileAttribute.LOCATIONS);
    }

    @Override
    public FileLocality getFileLocality(FileAttributes attributes, String hostName) {
        if (attributes.getFileType() == FileType.DIR || attributes.getSize() == 0L) {
            return FileLocality.NONE;
        }
        StorageInfo storageInfo = StorageInfos.extractFrom(attributes);
        PoolPreferenceLevel[] levels = this._selectionUnit.match(PoolSelectionUnit.DirectionType.READ, hostName, "*/*", storageInfo, null);
        Collection<String> locations = attributes.getLocations();
        for (PoolPreferenceLevel level : levels) {
            if (Collections.disjoint(level.getPoolList(), locations)) continue;
            return storageInfo.isStored() ? FileLocality.ONLINE_AND_NEARLINE : FileLocality.ONLINE;
        }
        if (storageInfo.isStored()) {
            return FileLocality.NEARLINE;
        }
        for (String name : locations) {
            PoolCostInfo cost;
            PoolSelectionUnit.SelectionPool pool = this._selectionUnit.getPool(name);
            if (pool == null || !pool.canReadForP2P() || (cost = this._costModule.getPoolCostInfo(name)) == null || cost.getP2pQueue().getMaxActive() <= 0) continue;
            return FileLocality.NEARLINE;
        }
        return FileLocality.UNAVAILABLE;
    }

    public class PnfsFileLocation
    implements PoolSelector {
        private Partition _partition;
        private final FileAttributes _fileAttributes;
        private final ProtocolInfo _protocolInfo;
        private final String _linkGroup;

        public PnfsFileLocation(FileAttributes fileAttributes, ProtocolInfo protocolInfo, String linkGroup) {
            this._fileAttributes = fileAttributes;
            this._protocolInfo = protocolInfo;
            this._linkGroup = linkGroup;
        }

        @Override
        public Partition getCurrentPartition() {
            return this._partition;
        }

        private PoolPreferenceLevel[] match(PoolSelectionUnit.DirectionType direction) {
            String hostName = this._protocolInfo instanceof IpProtocolInfo ? ((IpProtocolInfo)this._protocolInfo).getSocketAddress().getAddress().getHostAddress() : null;
            String protocol = this._protocolInfo.getProtocol() + "/" + this._protocolInfo.getMajorVersion();
            return PoolMonitorV5.this._selectionUnit.match(direction, hostName, protocol, StorageInfos.extractFrom(this._fileAttributes), this._linkGroup);
        }

        @Override
        public List<List<PoolInfo>> getReadPools() {
            Map<String, PoolInfo> onlineLocations = PoolMonitorV5.this._costModule.getPoolInfoAsMap(this._fileAttributes.getLocations());
            Function toPoolInfo = Functions.forMap(onlineLocations, null);
            ArrayList result = Lists.newArrayList();
            for (PoolPreferenceLevel level : this.match(PoolSelectionUnit.DirectionType.READ)) {
                ArrayList pools = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform(level.getPoolList(), (Function)toPoolInfo), (Predicate)Predicates.notNull()));
                if (pools.isEmpty()) continue;
                result.add(pools);
            }
            return result;
        }

        @Override
        public PoolInfo selectWritePool(long preallocated) throws CacheException {
            PoolPreferenceLevel[] levels = this.match(PoolSelectionUnit.DirectionType.WRITE);
            if (levels.length == 0) {
                throw new CacheException(19, "No write pools configured for <" + StorageInfos.extractFrom(this._fileAttributes) + "> in the linkGroup " + (this._linkGroup == null ? "[none]" : this._linkGroup));
            }
            for (PoolPreferenceLevel level : levels) {
                List<PoolInfo> pools = PoolMonitorV5.this._costModule.getPoolInfo(level.getPoolList());
                if (pools.isEmpty()) continue;
                Partition partition = PoolMonitorV5.this._partitionManager.getPartition(level.getTag());
                return partition.selectWritePool(PoolMonitorV5.this._costModule, pools, this._fileAttributes, preallocated);
            }
            throw new CacheException(20, "No write pool available for <" + StorageInfos.extractFrom(this._fileAttributes) + "> in the linkGroup " + (this._linkGroup == null ? "[none]" : this._linkGroup));
        }

        @Override
        public PoolInfo selectReadPool() throws CacheException {
            Collection<String> locations = this._fileAttributes.getLocations();
            _log.debug("[read] Expected from pnfs: {}", locations);
            Map<String, PoolInfo> onlinePools = PoolMonitorV5.this._costModule.getPoolInfoAsMap(locations);
            _log.debug("[read] Online pools: {}", onlinePools);
            if (onlinePools.isEmpty()) {
                throw new FileNotInCacheException("File not in any pool");
            }
            PoolPreferenceLevel[] level = this.match(PoolSelectionUnit.DirectionType.READ);
            if (level.length == 0) {
                throw new CacheException("No links for this request");
            }
            CostException fallback = null;
            for (int prio = 0; prio < level.length; ++prio) {
                List<String> poolNames = level[prio].getPoolList();
                _log.debug("[read] Allowed pools at level {}: {}", (Object)prio, poolNames);
                ArrayList<PoolInfo> pools = new ArrayList<PoolInfo>(poolNames.size());
                for (String poolName : poolNames) {
                    PoolInfo info = onlinePools.get(poolName);
                    if (info == null) continue;
                    pools.add(info);
                }
                _log.debug("[read] Available pools at level {}: {}", (Object)prio, pools);
                this._partition = PoolMonitorV5.this._partitionManager.getPartition(level[prio].getTag());
                if (pools.isEmpty()) continue;
                try {
                    return this._partition.selectReadPool(PoolMonitorV5.this._costModule, pools, this._fileAttributes);
                }
                catch (CostException e) {
                    if (!e.shouldFallBack()) {
                        throw e;
                    }
                    fallback = e;
                }
            }
            if (fallback != null) {
                throw fallback;
            }
            throw new PermissionDeniedCacheException("File is online, but not in read-allowed pool");
        }

        @Override
        public Partition.P2pPair selectPool2Pool(boolean force) throws CacheException {
            PoolPreferenceLevel[] levels;
            Collection<String> locations = this._fileAttributes.getLocations();
            _log.debug("[p2p] Expected source from pnfs: {}", locations);
            Map<String, PoolInfo> sources = PoolMonitorV5.this._costModule.getPoolInfoAsMap(locations);
            _log.debug("[p2p] Online source pools: {}", sources.values());
            if (sources.size() == 0) {
                throw new CacheException("P2P denied: No source pools available");
            }
            for (PoolPreferenceLevel level : levels = this.match(PoolSelectionUnit.DirectionType.P2P)) {
                List<PoolInfo> pools = PoolMonitorV5.this._costModule.getPoolInfo(Iterables.filter(level.getPoolList(), (Predicate)Predicates.not((Predicate)Predicates.in(sources.keySet()))));
                if (pools.isEmpty()) continue;
                _log.debug("[p2p] Online destination candidates: {}", pools);
                Partition partition = PoolMonitorV5.this._partitionManager.getPartition(level.getTag());
                return partition.selectPool2Pool(PoolMonitorV5.this._costModule, Lists.newArrayList(sources.values()), pools, this._fileAttributes, force);
            }
            throw new PermissionDeniedCacheException("P2P denied: No pool candidates available/configured/left for p2p or file already everywhere");
        }

        @Override
        public PoolInfo selectStagePool(String previousPool, String previousHost) throws CacheException {
            Collection<String> locations = this._fileAttributes.getLocations();
            _log.debug("[stage] Existing locations of the file: {}", locations);
            CostException fallback = null;
            for (PoolPreferenceLevel level : this.match(PoolSelectionUnit.DirectionType.CACHE)) {
                try {
                    List<PoolInfo> pools = PoolMonitorV5.this._costModule.getPoolInfo(Iterables.filter(level.getPoolList(), (Predicate)Predicates.not((Predicate)Predicates.in(locations))));
                    if (pools.isEmpty()) continue;
                    _log.debug("[stage] Online stage candidates: {}", pools);
                    Partition partition = PoolMonitorV5.this._partitionManager.getPartition(level.getTag());
                    return partition.selectStagePool(PoolMonitorV5.this._costModule, pools, previousPool, previousHost, this._fileAttributes);
                }
                catch (CostException e) {
                    if (!e.shouldFallBack()) {
                        throw e;
                    }
                    fallback = e;
                }
            }
            if (fallback != null) {
                throw fallback;
            }
            throw new CacheException(149, "No pool candidates available/configured/left for stage");
        }

        @Override
        public PoolInfo selectPinPool() throws CacheException {
            Ordering<String> ordering = new Ordering<String>(){
                final String id;
                {
                    this.id = PnfsFileLocation.this._fileAttributes.getPnfsId().toString();
                }

                public int compare(String pool1, String pool2) {
                    String s1 = this.id + pool1;
                    String s2 = this.id + pool2;
                    return Ints.compare((int)s1.hashCode(), (int)s2.hashCode());
                }
            };
            Collection<String> locations = this._fileAttributes.getLocations();
            _log.debug("[pin] Expected from pnfs: {}", locations);
            Map<String, PoolInfo> onlinePools = PoolMonitorV5.this._costModule.getPoolInfoAsMap(locations);
            _log.debug("[pin] Online pools: {}", onlinePools.values());
            boolean isRequestSatisfiable = false;
            for (PoolPreferenceLevel level : this.match(PoolSelectionUnit.DirectionType.READ)) {
                List<String> pools = level.getPoolList();
                if (pools.isEmpty()) continue;
                isRequestSatisfiable = true;
                Iterable pinnablePools = Iterables.filter(pools, (Predicate)Predicates.in(onlinePools.keySet()));
                if (Iterables.isEmpty((Iterable)pinnablePools)) continue;
                return onlinePools.get(ordering.min(pinnablePools));
            }
            if (isRequestSatisfiable && (!onlinePools.isEmpty() || this._fileAttributes.getStorageInfo().isStored())) {
                throw new FileNotOnlineCacheException("File is not on online");
            }
            throw new FileNotInCacheException("File is unavailable");
        }
    }
}

