/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterables;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.poolManager.PoolManagerCellInfo;
import diskCacheV111.poolManager.PoolPreferenceLevel;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.poolManager.RequestContainerV5;
import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.GenericStorageInfo;
import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.PoolCostCheckable;
import diskCacheV111.vehicles.PoolLinkGroupInfo;
import diskCacheV111.vehicles.PoolManagerGetPoolListMessage;
import diskCacheV111.vehicles.PoolManagerGetPoolMonitor;
import diskCacheV111.vehicles.PoolManagerGetPoolsByLinkMessage;
import diskCacheV111.vehicles.PoolManagerGetPoolsByNameMessage;
import diskCacheV111.vehicles.PoolManagerGetPoolsByPoolGroupMessage;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import diskCacheV111.vehicles.PoolManagerPoolModeMessage;
import diskCacheV111.vehicles.PoolManagerPoolUpMessage;
import diskCacheV111.vehicles.PoolMgrGetPoolByLink;
import diskCacheV111.vehicles.PoolMgrGetPoolLinkGroups;
import diskCacheV111.vehicles.PoolMgrQueryPoolsMsg;
import diskCacheV111.vehicles.PoolMgrSelectReadPoolMsg;
import diskCacheV111.vehicles.PoolMgrSelectWritePoolMsg;
import diskCacheV111.vehicles.PoolStatusChangedMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.QuotaMgrCheckQuotaMessage;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.poolmanager.PoolMonitor;
import org.dcache.poolmanager.PoolSelector;
import org.dcache.poolmanager.Utils;
import org.dcache.util.Version;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PoolManagerSelectLinkGroupForWriteMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolManagerV5
extends AbstractCellComponent
implements CellCommandListener,
CellMessageReceiver {
    private static final Version VERSION = Version.of(PoolManagerV5.class);
    private int _writeThreads;
    private int _readThreads;
    private int _counterPoolUp;
    private int _counterSelectWritePool;
    private int _counterSelectReadPool;
    private PoolSelectionUnit _selectionUnit;
    private PoolMonitor _poolMonitor;
    private CostModule _costModule;
    private CellPath _poolStatusRelayPath;
    private PnfsHandler _pnfsHandler;
    private RequestContainerV5 _requestContainer;
    private WatchdogThread _watchdog;
    private boolean _quotasEnabled;
    private String _quotaManager = "none";
    private static final Logger _log = LoggerFactory.getLogger(PoolManagerV5.class);
    private static final Logger _logPoolMonitor = LoggerFactory.getLogger((String)("logger.org.dcache.poolmonitor." + PoolManagerV5.class.getName()));
    public static final String hh_set_max_threads = "# OBSOLETE";
    public static final String hh_set_timeout_pool = "# OBSOLETE";
    public static final String hh_getpoolsbylink = "<linkName> [-size=<filesize>]";
    public static final String hh_get_av_pools = "<pnfsId> <hsm> <storageClass> <host>";

    public void setPoolSelectionUnit(PoolSelectionUnit selectionUnit) {
        this._selectionUnit = selectionUnit;
    }

    public void setCostModule(CostModule costModule) {
        this._costModule = costModule;
    }

    public void setPoolMonitor(PoolMonitor poolMonitor) {
        this._poolMonitor = poolMonitor;
    }

    public void setRequestContainer(RequestContainerV5 requestContainer) {
        this._requestContainer = requestContainer;
    }

    public void setPoolStatusRelayPath(CellPath poolStatusRelayPath) {
        this._poolStatusRelayPath = poolStatusRelayPath.hops() == 0 ? null : poolStatusRelayPath;
    }

    public void setQuotaManager(String quotaManager) {
        this._quotaManager = quotaManager;
        this._quotasEnabled = !this._quotaManager.equals("none");
    }

    public void setPnfsHandler(PnfsHandler pnfsHandler) {
        this._pnfsHandler = pnfsHandler;
    }

    public void init() {
        String watchdogParam = this.getArgs().getOpt("watchdog");
        this._watchdog = watchdogParam != null && watchdogParam.length() > 0 ? new WatchdogThread(watchdogParam) : new WatchdogThread();
        _log.info("Watchdog : " + this._watchdog);
    }

    @Override
    public CellInfo getCellInfo(CellInfo info) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (String pool : this._selectionUnit.getActivePools()) {
            builder.put((Object)pool, (Object)this._selectionUnit.getPool(pool).getAddress());
        }
        PoolManagerCellInfo pminfo = new PoolManagerCellInfo(info);
        pminfo.setCellVersion(new CellVersion(VERSION));
        pminfo.setPools((BiMap<String, CellAddressCore>)builder.build());
        return pminfo;
    }

    @Override
    public void printSetup(PrintWriter writer) {
        writer.print("#\n# Setup of ");
        writer.print(this.getCellName());
        writer.print(" (");
        writer.print(this.getClass().getName());
        writer.print(") at ");
        writer.println(new Date().toString());
        writer.println("#");
    }

    public PoolManagerPoolModeMessage messageArrived(PoolManagerPoolModeMessage msg) {
        PoolSelectionUnit.SelectionPool pool = this._selectionUnit.getPool(msg.getPoolName());
        if (pool == null) {
            msg.setFailed(563, (Serializable)((Object)("Pool not found : " + msg.getPoolName())));
        } else if (msg.getPoolMode() == 0) {
            msg.setPoolMode(0x10 | (pool.isReadOnly() ? 0 : 32));
        } else {
            pool.setReadOnly((msg.getPoolMode() & 0x20) == 0);
        }
        msg.setSucceeded();
        return msg;
    }

    private void runWatchdogSequence(long deathDetectedTimer) {
        for (String name : this._selectionUnit.getDefinedPools(false)) {
            PoolSelectionUnit.SelectionPool pool = this._selectionUnit.getPool(name);
            if (pool == null || pool.getActive() <= deathDetectedTimer || !pool.setSerialId(0L)) continue;
            if (_logPoolMonitor.isDebugEnabled()) {
                _logPoolMonitor.debug("Pool " + name + " declared as DOWN (no ping in " + deathDetectedTimer / 1000L + " seconds).");
            }
            this._requestContainer.poolStatusChanged(name, 2);
            this.sendPoolStatusRelay(name, 2, null, 666, "DEAD");
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("PoolManager V [$Id: PoolManagerV5.java,v 1.48 2007-10-10 08:05:34 tigran Exp $]");
        pw.println(" SelectionUnit : " + this._selectionUnit.getVersion());
        pw.println(" Write Threads : " + this._writeThreads);
        pw.println(" Read  Threads : " + this._readThreads);
        pw.println("Message counts");
        pw.println("           PoolUp : " + this._counterPoolUp);
        pw.println("   SelectReadPool : " + this._counterSelectReadPool);
        pw.println("  SelectWritePool : " + this._counterSelectWritePool);
        if (this._watchdog == null) {
            pw.println("         Watchdog : disabled");
        } else {
            pw.println("         Watchdog : " + this._watchdog);
        }
    }

    public String ac_set_max_threads_$_1(Args args) {
        return "'set max threads' is obsolete";
    }

    public String ac_set_timeout_pool_$_1(Args args) {
        return "'set timeout pool' is obsolete";
    }

    public String ac_getpoolsbylink_$_1(Args args) throws NumberFormatException {
        String sizeString = args.getOpt("size");
        long size = sizeString == null ? 50000000L : Long.parseLong(sizeString);
        String link = args.argv(0);
        StringBuilder sb = new StringBuilder();
        for (PoolCostCheckable pool : this._poolMonitor.queryPoolsByLinkName(link, size)) {
            sb.append(pool).append("\n");
        }
        return sb.toString();
    }

    public synchronized void messageArrived(CellMessage envelope, PoolManagerPoolUpMessage poolMessage) {
        ++this._counterPoolUp;
        String poolName = poolMessage.getPoolName();
        PoolSelectionUnit.SelectionPool pool = this._selectionUnit.getPool(poolName, true);
        PoolV2Mode newMode = poolMessage.getPoolMode();
        PoolV2Mode oldMode = pool.getPoolMode();
        if (_logPoolMonitor.isDebugEnabled()) {
            _logPoolMonitor.debug("PoolUp message from " + poolName + " with mode " + newMode + " and serialId " + poolMessage.getSerialId());
        }
        boolean disabled = newMode.getMode() == 1 || newMode.isDisabled(64) || newMode.isDisabled(63);
        long serial = disabled ? 0L : poolMessage.getSerialId();
        boolean changed = pool.setSerialId(serial) || pool.isActive() == disabled || newMode.getMode() != oldMode.getMode() || !pool.getHsmInstances().equals(poolMessage.getHsmInstances());
        pool.setAddress(envelope.getSourcePath().getSourceAddress());
        pool.setPoolMode(newMode);
        pool.setHsmInstances(poolMessage.getHsmInstances());
        pool.setActive(!disabled);
        if (changed) {
            _logPoolMonitor.warn("Pool " + poolName + " changed from mode " + oldMode + " to " + newMode);
            if (disabled) {
                this._requestContainer.poolStatusChanged(poolName, 2);
                this.sendPoolStatusRelay(poolName, 2, poolMessage.getPoolMode(), poolMessage.getCode(), poolMessage.getMessage());
            } else {
                this._requestContainer.poolStatusChanged(poolName, 1);
                this.sendPoolStatusRelay(poolName, 3);
            }
        }
    }

    private void sendPoolStatusRelay(String poolName, int status) {
        this.sendPoolStatusRelay(poolName, status, null, 0, null);
    }

    private void sendPoolStatusRelay(String poolName, int status, PoolV2Mode poolMode, int statusCode, String statusMessage) {
        if (this._poolStatusRelayPath == null) {
            return;
        }
        try {
            PoolStatusChangedMessage msg = new PoolStatusChangedMessage(poolName, status);
            msg.setPoolMode(poolMode);
            msg.setDetail(statusCode, statusMessage);
            _log.info("sendPoolStatusRelay : " + msg);
            this.sendMessage(new CellMessage(this._poolStatusRelayPath, (Serializable)msg));
        }
        catch (Exception ee) {
            _log.warn("Failed to send poolStatus changed message : " + ee);
        }
    }

    public PoolMgrGetPoolLinkGroups messageArrived(PoolMgrGetPoolLinkGroups msg) {
        Collection<PoolLinkGroupInfo> linkGroupInfos = Utils.linkGroupInfos(this._selectionUnit, this._costModule).values();
        PoolLinkGroupInfo[] poolLinkGroupInfos = linkGroupInfos.toArray(new PoolLinkGroupInfo[linkGroupInfos.size()]);
        msg.setPoolLinkGroupInfos(poolLinkGroupInfos);
        msg.setSucceeded();
        return msg;
    }

    public PoolManagerGetPoolListMessage messageArrived(PoolManagerGetPoolListMessage msg) {
        String[] pools = this._selectionUnit.getActivePools();
        msg.setPoolList(Arrays.asList(pools));
        msg.setSucceeded();
        return msg;
    }

    public PoolMgrGetPoolByLink messageArrived(PoolMgrGetPoolByLink msg) throws CacheException {
        String linkName = msg.getLinkName();
        long filesize = msg.getFilesize();
        Function<PoolSelectionUnit.SelectionPool, String> getName = new Function<PoolSelectionUnit.SelectionPool, String>(){

            public String apply(PoolSelectionUnit.SelectionPool pool) {
                return pool.getName();
            }
        };
        PoolSelectionUnit.SelectionLink link = this._selectionUnit.getLinkByName(linkName);
        List<PoolInfo> pools = this._costModule.getPoolInfo(Iterables.transform(link.pools(), (Function)getName));
        if (pools.isEmpty()) {
            throw new CacheException(57, "No appropriate pools found for link: " + linkName);
        }
        Partition partition = this._poolMonitor.getPartitionManager().getPartition(link.getTag());
        msg.setPoolName(partition.selectWritePool(this._costModule, pools, new FileAttributes(), filesize).getName());
        msg.setSucceeded();
        return msg;
    }

    public PoolManagerGetPoolsByNameMessage messageArrived(PoolManagerGetPoolsByNameMessage msg) {
        ArrayList<PoolManagerPoolInformation> pools = new ArrayList<PoolManagerPoolInformation>();
        for (String name : msg.getPoolNames()) {
            try {
                pools.add(this._poolMonitor.getPoolInformation(name));
            }
            catch (NoSuchElementException e) {}
        }
        msg.setPools(pools);
        msg.setSucceeded();
        return msg;
    }

    public PoolManagerGetPoolsByLinkMessage messageArrived(PoolManagerGetPoolsByLinkMessage msg) {
        try {
            msg.setPools(this._poolMonitor.getPoolsByLink(msg.getLink()));
            msg.setSucceeded();
        }
        catch (NoSuchElementException e) {
            List<PoolManagerPoolInformation> empty = Collections.emptyList();
            msg.setPools(empty);
            msg.setSucceeded();
        }
        return msg;
    }

    public PoolManagerGetPoolsByPoolGroupMessage messageArrived(PoolManagerGetPoolsByPoolGroupMessage msg) {
        try {
            msg.setPools(this._poolMonitor.getPoolsByPoolGroup(msg.getPoolGroup()));
            msg.setSucceeded();
        }
        catch (NoSuchElementException e) {
            List<PoolManagerPoolInformation> empty = Collections.emptyList();
            msg.setPools(empty);
            msg.setSucceeded();
        }
        return msg;
    }

    public PoolMgrQueryPoolsMsg messageArrived(PoolMgrQueryPoolsMsg msg) {
        PoolSelectionUnit.DirectionType accessType = msg.getAccessType();
        msg.setPoolList(PoolPreferenceLevel.fromPoolPreferenceLevelToList(this._selectionUnit.match(accessType, msg.getNetUnitName(), msg.getProtocolUnitName(), msg.getStorageInfo(), null)));
        msg.setSucceeded();
        return msg;
    }

    public String ac_get_av_pools_$_4(Args args) throws CacheException {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        XStorageInfo storageInfo = new XStorageInfo(args.argv(1), args.argv(2));
        XProtocolInfo protocolInfo = new XProtocolInfo(new InetSocketAddress(args.argv(3), 0));
        FileAttributes fileAttributes = this._pnfsHandler.getFileAttributes(pnfsId, PoolMgrSelectReadPoolMsg.getRequiredAttributes());
        fileAttributes.setStorageInfo(storageInfo);
        PoolSelector poolSelector = this._poolMonitor.getPoolSelector(fileAttributes, protocolInfo, null);
        List<List<PoolInfo>> available = poolSelector.getReadPools();
        StringBuilder sb = new StringBuilder();
        sb.append("Available and allowed\n");
        for (PoolInfo pool : (List)Iterables.getFirst(available, Collections.emptyList())) {
            sb.append("  ").append(pool).append("\n");
        }
        return sb.toString();
    }

    private boolean quotasExceeded(FileAttributes fileAttributes) {
        StorageInfo info = fileAttributes.getStorageInfo();
        String storageClass = info.getStorageClass() + "@" + info.getHsm();
        QuotaMgrCheckQuotaMessage quotas = new QuotaMgrCheckQuotaMessage(storageClass);
        CellMessage msg = new CellMessage(new CellPath(this._quotaManager), (Serializable)quotas);
        try {
            msg = this.sendAndWait(msg, 20000L);
            if (msg == null) {
                _log.warn("quotasExceeded of " + storageClass + " : request timed out");
                return false;
            }
            Serializable obj = msg.getMessageObject();
            if (!(obj instanceof QuotaMgrCheckQuotaMessage)) {
                _log.warn("quotasExceeded of " + storageClass + " : unexpected object arrived : " + obj.getClass().getName());
                return false;
            }
            return ((QuotaMgrCheckQuotaMessage)obj).isHardQuotaExceeded();
        }
        catch (Exception ee) {
            _log.warn("quotasExceeded of " + storageClass + " : Exception : " + ee);
            _log.warn(ee.toString());
            return false;
        }
    }

    public DelayedReply messageArrived(PoolManagerSelectLinkGroupForWriteMessage message) {
        return new LinkGroupSelectionTask(message);
    }

    public PoolManagerGetPoolMonitor messageArrived(PoolManagerGetPoolMonitor msg) {
        msg.setPoolMonitor(this._poolMonitor);
        return msg;
    }

    public DelayedReply messageArrived(CellMessage envelope, PoolMgrSelectWritePoolMsg msg) {
        return new WriteRequestHandler(envelope, msg);
    }

    public String ac_free_$_0(Args args) {
        Map<String, PoolLinkGroupInfo> linkGroupSize = Utils.linkGroupInfos(this._selectionUnit, this._costModule);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, PoolLinkGroupInfo> linkGourp : linkGroupSize.entrySet()) {
            sb.append(linkGourp.getKey()).append(" : ").append(linkGourp.getValue().getAvailableSpaceInBytes()).append("\n");
        }
        return sb.toString();
    }

    public class WriteRequestHandler
    extends DelayedReply
    implements Runnable {
        private CellMessage _envelope;
        private PoolMgrSelectWritePoolMsg _request;
        private PnfsId _pnfsId;

        public WriteRequestHandler(CellMessage envelope, PoolMgrSelectWritePoolMsg msg) {
            this._envelope = envelope;
            this._request = msg;
            this._pnfsId = this._request.getPnfsId();
            new Thread((Runnable)this, "writeHandler").start();
        }

        @Override
        public void run() {
            FileAttributes fileAttributes = this._request.getFileAttributes();
            StorageInfo storageInfo = fileAttributes.getStorageInfo();
            ProtocolInfo protocolInfo = this._request.getProtocolInfo();
            _log.info("{} write handler started", (Object)this._pnfsId);
            long started = System.currentTimeMillis();
            if (PoolManagerV5.this._quotasEnabled && PoolManagerV5.this.quotasExceeded(fileAttributes)) {
                this.requestFailed(55, "Quotas Exceeded for StorageClass : " + storageInfo.getStorageClass());
                return;
            }
            try {
                PoolInfo pool = PoolManagerV5.this._poolMonitor.getPoolSelector(fileAttributes, protocolInfo, this._request.getLinkGroup()).selectWritePool(this._request.getPreallocated());
                _log.info("{} write handler selected {} after {} ms", new Object[]{this._pnfsId, pool.getName(), System.currentTimeMillis() - started});
                this.requestSucceeded(pool);
            }
            catch (CacheException ce) {
                this.requestFailed(ce.getRc(), ce.getMessage());
            }
            catch (Exception ee) {
                this.requestFailed(17, ee.getMessage());
            }
        }

        protected void requestFailed(int errorCode, String errorMessage) {
            this._request.setFailed(errorCode, (Serializable)((Object)errorMessage));
            try {
                this.send(this._request);
            }
            catch (Exception e) {
                _log.warn("Exception requestFailed : " + e, (Throwable)e);
            }
        }

        protected void requestSucceeded(PoolInfo pool) {
            this._request.setPoolName(pool.getName());
            this._request.setPoolAddress(pool.getAddress());
            this._request.setSucceeded();
            try {
                this.send(this._request);
                if (!this._request.getSkipCostUpdate()) {
                    PoolManagerV5.this._costModule.messageArrived(this._envelope);
                }
            }
            catch (Exception e) {
                _log.warn("Exception in requestSucceeded : " + e, (Throwable)e);
            }
        }
    }

    public class LinkGroupSelectionTask
    extends DelayedReply
    implements Runnable {
        private final PoolManagerSelectLinkGroupForWriteMessage _message;
        private final CDC _cdc;

        public LinkGroupSelectionTask(PoolManagerSelectLinkGroupForWriteMessage message) {
            this._message = message;
            this._cdc = new CDC();
            new Thread((Runnable)this, "LinkGroupSelectionTask").start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long started = System.currentTimeMillis();
            try (CDC ignored = this._cdc.restore();){
                _log.info("Select link group handler started");
                this._message.setLinkGroups(this.selectLinkGroups());
                this._message.setSucceeded();
                _log.info("Select link group handler finished after {} ms", (Object)(System.currentTimeMillis() - started));
            }
            catch (Exception e) {
                this._message.setFailed(10011, (Serializable)((Object)e.getMessage()));
            }
            finally {
                try {
                    this.send(this._message);
                }
                catch (NoRouteToCellException e) {
                    _log.error("Failed to send reply: " + e.getMessage());
                }
                catch (InterruptedException e) {
                    _log.warn("Link group selection handler was interrupted");
                }
            }
        }

        protected List<String> selectLinkGroups() {
            FileAttributes fileAttributes = this._message.getFileAttributes();
            ProtocolInfo protocolInfo = this._message.getProtocolInfo();
            String protocol = protocolInfo.getProtocol() + "/" + protocolInfo.getMajorVersion();
            String hostName = protocolInfo instanceof IpProtocolInfo ? ((IpProtocolInfo)protocolInfo).getSocketAddress().getAddress().getHostAddress() : null;
            Collection<String> linkGroups = this._message.getLinkGroups();
            if (linkGroups == null) {
                linkGroups = Utils.linkGroupInfos(PoolManagerV5.this._selectionUnit, PoolManagerV5.this._costModule).keySet();
            }
            ArrayList<String> outputLinkGroups = new ArrayList<String>(linkGroups.size());
            for (String linkGroup : linkGroups) {
                PoolPreferenceLevel[] level = PoolManagerV5.this._selectionUnit.match(PoolSelectionUnit.DirectionType.WRITE, hostName, protocol, fileAttributes.getStorageInfo(), linkGroup);
                if (level.length <= 0) continue;
                outputLinkGroups.add(linkGroup);
            }
            return outputLinkGroups;
        }
    }

    private static class XStorageInfo
    extends GenericStorageInfo {
        private static final long serialVersionUID = -6624549402952279903L;

        private XStorageInfo(String hsm, String storageClass) {
            super(hsm, storageClass);
        }

        @Override
        public String getBitfileId() {
            return "";
        }

        @Override
        public boolean isStored() {
            return true;
        }
    }

    private static class XProtocolInfo
    implements IpProtocolInfo {
        private final InetSocketAddress _addr;
        private static final long serialVersionUID = -5817364111427851052L;

        private XProtocolInfo(InetSocketAddress addr) {
            this._addr = addr;
        }

        @Override
        public String getProtocol() {
            return "DCap";
        }

        @Override
        public int getMinorVersion() {
            return 0;
        }

        @Override
        public int getMajorVersion() {
            return 0;
        }

        @Override
        public String getVersionString() {
            return "0.0";
        }

        @Override
        public InetSocketAddress getSocketAddress() {
            return this._addr;
        }
    }

    private class WatchdogThread
    implements Runnable {
        private long _deathDetected = 600000L;
        private long _sleepTimer = 60000L;
        private long _watchdogSequenceCounter;

        public WatchdogThread() {
            new Thread((Runnable)this, "watchdog").start();
            _log.info("WatchdogThread initialized with : " + this);
        }

        public WatchdogThread(String parameter) {
            long deathDetected = 0L;
            long sleeping = 0L;
            try {
                String tmp;
                StringTokenizer st = new StringTokenizer(parameter, ":");
                if (st.hasMoreTokens() && (tmp = st.nextToken()).length() > 0) {
                    deathDetected = Long.parseLong(tmp);
                }
                if (st.hasMoreTokens() && (tmp = st.nextToken()).length() > 0) {
                    sleeping = Long.parseLong(tmp);
                }
                if (deathDetected < 10L || sleeping < 10L) {
                    throw new IllegalArgumentException("Timers to small : " + parameter);
                }
                if (deathDetected > 0L) {
                    this._deathDetected = deathDetected * 1000L;
                }
                if (sleeping > 0L) {
                    this._sleepTimer = sleeping * 1000L;
                }
            }
            catch (Exception ee) {
                _log.warn("WatchdogThread : illegal arguments [" + parameter + "] (using defaults) " + ee.getMessage());
            }
            new Thread((Runnable)this, "watchdog").start();
            _log.info("WatchdogThread initialized with : " + this);
        }

        @Override
        public void run() {
            _log.info("watchdog thread activated");
            while (true) {
                try {
                    Thread.sleep(this._sleepTimer);
                }
                catch (InterruptedException e) {
                    _log.info("watchdog thread interrupted");
                    break;
                }
                PoolManagerV5.this.runWatchdogSequence(this._deathDetected);
                ++this._watchdogSequenceCounter;
            }
            _log.info("watchdog finished");
        }

        public String toString() {
            return "DeathDetection=" + this._deathDetected / 1000L + ";Sleep=" + this._sleepTimer / 1000L + ";Counter=" + this._watchdogSequenceCounter + ";";
        }
    }
}

