/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolCostCheckable;
import diskCacheV111.vehicles.PoolFileCheckable;
import java.io.Serializable;
import java.util.Map;

public class PoolCheckAdapter
implements PoolCostCheckable,
PoolFileCheckable,
Serializable {
    private double _spaceCost;
    private double _performanceCost;
    private long _filesize;
    private String _poolName;
    private boolean _have;
    private boolean _waiting;
    private Map<String, String> _tagMap;
    private PnfsId _pnfsId;
    private static final long serialVersionUID = 5035648886552838987L;

    public PoolCheckAdapter(PoolCostCheckable costCheck) {
        this._poolName = costCheck.getPoolName();
        this._tagMap = costCheck.getTagMap();
        this._spaceCost = costCheck.getSpaceCost();
        this._performanceCost = costCheck.getPerformanceCost();
    }

    public PoolCheckAdapter(String poolName) {
        this._poolName = poolName;
    }

    public PoolCheckAdapter(String poolName, long filesize) {
        this(poolName);
        this._filesize = filesize;
    }

    @Override
    public double getSpaceCost() {
        return this._spaceCost;
    }

    @Override
    public void setSpaceCost(double spaceCost) {
        this._spaceCost = spaceCost;
    }

    @Override
    public double getPerformanceCost() {
        return this._performanceCost;
    }

    @Override
    public void setPerformanceCost(double performanceCost) {
        this._performanceCost = performanceCost;
    }

    @Override
    public long getFilesize() {
        return this._filesize;
    }

    @Override
    public void setPnfsId(PnfsId pnfsId) {
        this._pnfsId = pnfsId;
    }

    @Override
    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    @Override
    public boolean getHave() {
        return this._have;
    }

    @Override
    public void setHave(boolean have) {
        this._have = have;
    }

    @Override
    public boolean getWaiting() {
        return this._waiting;
    }

    @Override
    public void setWaiting(boolean waiting) {
        this._waiting = waiting;
    }

    @Override
    public String getPoolName() {
        return this._poolName;
    }

    @Override
    public void setTagMap(Map<String, String> map) {
        this._tagMap = map;
    }

    @Override
    public Map<String, String> getTagMap() {
        return this._tagMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._poolName).append("={");
        if (this._tagMap != null) {
            sb.append("Tag={").append(this._tagMap.toString()).append("};");
        }
        if (this._pnfsId != null) {
            sb.append("pnfsid=").append(this._pnfsId).append(";have=").append(this._have).append(";");
        }
        sb.append("size=").append(this._filesize).append(";SC=").append(this._spaceCost).append(";CC=").append(this._performanceCost).append(";");
        return sb.append("}").toString();
    }
}

