/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.PoolSelectionUnit;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class LinkGroup
implements PoolSelectionUnit.SelectionLinkGroup,
Serializable {
    private static final long serialVersionUID = 5425784079451748166L;
    private final String _name;
    private final Collection<PoolSelectionUnit.SelectionLink> _links = new HashSet<PoolSelectionUnit.SelectionLink>();
    private final Map<String, Set<String>> _attributes = new HashMap<String, Set<String>>();
    private boolean _isNearlineAllowed = true;
    private boolean _isOnlineAllowed;
    private boolean _isOutputAllowed = true;
    private boolean _isReplicaAllowed = true;
    private boolean _isCustodialAllowed = true;

    LinkGroup(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void add(PoolSelectionUnit.SelectionLink link) {
        this._links.add(link);
    }

    @Override
    public boolean remove(PoolSelectionUnit.SelectionLink link) {
        return this._links.remove(link);
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionLink> links() {
        return this._links;
    }

    @Override
    public void attribute(String attribute, String value, boolean replace) {
        Set<Object> valuesSet;
        if (!this._attributes.containsKey(attribute)) {
            valuesSet = new HashSet();
            this._attributes.put(attribute, valuesSet);
        } else {
            valuesSet = this._attributes.get(attribute);
            if (replace) {
                valuesSet.clear();
            }
        }
        valuesSet.add(value);
    }

    @Override
    public Set<String> attribute(String attribute) {
        return this._attributes.get(attribute);
    }

    @Override
    public void removeAttribute(String attribute, String value) {
        if (this._attributes.containsKey(attribute)) {
            Set<String> valuesSet = this._attributes.get(attribute);
            valuesSet.remove(value);
            if (valuesSet.isEmpty()) {
                this._attributes.remove(attribute);
            }
        }
    }

    @Override
    public Map<String, Set<String>> attributes() {
        return new HashMap<String, Set<String>>(this._attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._name);
        sb.append(" : ");
        if (!this._links.isEmpty()) {
            sb.append("[  ");
            for (PoolSelectionUnit.SelectionLink selectionLink : this._links) {
                sb.append(selectionLink.getName());
                sb.append(" ");
            }
            sb.append("]");
        } else {
            sb.append("[EMPTY]");
        }
        sb.append("\n");
        sb.append("    Attributes:\n");
        for (Map.Entry entry : this._attributes.entrySet()) {
            sb.append("           ").append((String)entry.getKey()).append(" = ");
            for (String aAttributeValue : (Set)entry.getValue()) {
                sb.append(aAttributeValue).append(" ");
            }
            sb.append("\n");
        }
        sb.append("    AccessLatency:\n");
        sb.append("           ").append("onlineAllowed=").append(this._isOnlineAllowed).append("\n");
        sb.append("           ").append("nearlineAllowed=").append(this._isNearlineAllowed).append("\n");
        sb.append("    RetentionPolicy:\n");
        sb.append("           ").append("custodialAllowed=").append(this._isCustodialAllowed).append("\n");
        sb.append("           ").append("outputAllowed=").append(this._isOutputAllowed).append("\n");
        sb.append("           ").append("replicaAllowed=").append(this._isReplicaAllowed).append("\n");
        return sb.toString();
    }

    public boolean contains(PoolSelectionUnit.SelectionLink link) {
        return this._links.contains(link);
    }

    public Collection<PoolSelectionUnit.SelectionLink> getAllLinks() {
        return this._links;
    }

    @Override
    public boolean isCustodialAllowed() {
        return this._isCustodialAllowed;
    }

    @Override
    public boolean isNearlineAllowed() {
        return this._isNearlineAllowed;
    }

    @Override
    public boolean isOnlineAllowed() {
        return this._isOnlineAllowed;
    }

    @Override
    public boolean isOutputAllowed() {
        return this._isOutputAllowed;
    }

    @Override
    public boolean isReplicaAllowed() {
        return this._isReplicaAllowed;
    }

    @Override
    public void setCustodialAllowed(boolean isAllowed) {
        this._isCustodialAllowed = isAllowed;
    }

    @Override
    public void setNearlineAllowed(boolean isAllowed) {
        this._isNearlineAllowed = isAllowed;
    }

    @Override
    public void setOnlineAllowed(boolean isAllowed) {
        this._isOnlineAllowed = isAllowed;
    }

    @Override
    public void setOutputAllowed(boolean isAllowed) {
        this._isOutputAllowed = isAllowed;
    }

    @Override
    public void setReplicaAllowed(boolean isAllowed) {
        this._isReplicaAllowed = isAllowed;
    }
}

