/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.Link;
import diskCacheV111.poolManager.PoolSelectionUnit;
import java.util.Comparator;

class LinkComparator
implements Comparator<Link> {
    private final PoolSelectionUnit.DirectionType _type;

    LinkComparator(PoolSelectionUnit.DirectionType type) {
        this._type = type;
    }

    @Override
    public int compare(Link link1, Link link2) {
        switch (this._type) {
            case READ: {
                return link1._readPref == link2._readPref ? link1._name.compareTo(link2._name) : (link1._readPref > link2._readPref ? -1 : 1);
            }
            case CACHE: {
                return link1._cachePref == link2._cachePref ? link1._name.compareTo(link2._name) : (link1._cachePref > link2._cachePref ? -1 : 1);
            }
            case WRITE: {
                return link1._writePref == link2._writePref ? link1._name.compareTo(link2._name) : (link1._writePref > link2._writePref ? -1 : 1);
            }
            case P2P: {
                int pref2;
                int pref1 = link1._p2pPref < 0 ? link1._readPref : link1._p2pPref;
                int n = pref2 = link2._p2pPref < 0 ? link2._readPref : link2._p2pPref;
                return pref1 == pref2 ? link1._name.compareTo(link2._name) : (pref1 > pref2 ? -1 : 1);
            }
        }
        throw new IllegalArgumentException("Wrong comparator mode");
    }
}

