/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.poolManager;

import diskCacheV111.poolManager.LinkGroup;
import diskCacheV111.poolManager.LinkReadWritePreferences;
import diskCacheV111.poolManager.PGroup;
import diskCacheV111.poolManager.Pool;
import diskCacheV111.poolManager.PoolCore;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.poolManager.UGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class Link
implements PoolSelectionUnit.SelectionLink,
Serializable {
    private static final long serialVersionUID = 4480385941491281821L;
    final String _name;
    final Map<String, PoolCore> _poolList = new HashMap<String, PoolCore>();
    final Map<String, UGroup> _uGroupList = new HashMap<String, UGroup>();
    int _readPref;
    int _writePref;
    int _cachePref;
    int _p2pPref = -1;
    String _tag;
    private LinkGroup _linkGroup;

    Link(String name) {
        this._name = name;
    }

    @Override
    public String getTag() {
        return this._tag;
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionPoolGroup> getPoolGroupsPointingTo() {
        ArrayList<PoolSelectionUnit.SelectionPoolGroup> pGroups = new ArrayList<PoolSelectionUnit.SelectionPoolGroup>();
        for (PoolCore pGroup : this._poolList.values()) {
            PGroup newPGroup = new PGroup(pGroup.getName());
            pGroups.add(newPGroup);
        }
        return pGroups;
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionUnitGroup> getUnitGroupsTargetedBy() {
        return new ArrayList<PoolSelectionUnit.SelectionUnitGroup>(this._uGroupList.values());
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public LinkReadWritePreferences getPreferences() {
        return new LinkReadWritePreferences(this._readPref, this._writePref, this._cachePref, this._p2pPref);
    }

    public String toString() {
        return this._name + "  (pref=" + this._readPref + "/" + this._cachePref + "/" + this._p2pPref + "/" + this._writePref + ";" + (this._tag == null ? "" : this._tag) + ";" + "ugroups=" + this._uGroupList.size() + ";pools=" + this._poolList.size() + ")";
    }

    public String getAttraction() {
        return "-readpref=" + this._readPref + " -writepref=" + this._writePref + " -cachepref=" + this._cachePref + " -p2ppref=" + this._p2pPref + (this._tag == null ? "" : " -section=" + this._tag);
    }

    @Override
    public Collection<PoolSelectionUnit.SelectionPool> pools() {
        ArrayList<PoolSelectionUnit.SelectionPool> list = new ArrayList<PoolSelectionUnit.SelectionPool>();
        for (PoolCore o : this._poolList.values()) {
            if (o instanceof Pool) {
                list.add((Pool)o);
                continue;
            }
            if (!(o instanceof PGroup)) continue;
            for (Pool pool : ((PGroup)o)._poolList.values()) {
                list.add(pool);
            }
        }
        return list;
    }

    public boolean exec(Map<String, String> variableMap) {
        return true;
    }

    public void setLinkGroup(LinkGroup lg) {
        this._linkGroup = lg;
    }

    public LinkGroup getLinkGroup() {
        return this._linkGroup;
    }
}

