/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace;

import com.google.common.base.Strings;
import diskCacheV111.namespace.NameSpaceProvider;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.InvalidMessageCacheException;
import diskCacheV111.util.MissingResourceCacheException;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsAddCacheLocationMessage;
import diskCacheV111.vehicles.PnfsClearCacheLocationMessage;
import diskCacheV111.vehicles.PnfsCreateDirectoryMessage;
import diskCacheV111.vehicles.PnfsCreateEntryMessage;
import diskCacheV111.vehicles.PnfsDeleteEntryMessage;
import diskCacheV111.vehicles.PnfsDeleteEntryNotificationMessage;
import diskCacheV111.vehicles.PnfsFlagMessage;
import diskCacheV111.vehicles.PnfsGetCacheLocationsMessage;
import diskCacheV111.vehicles.PnfsGetChecksumAllMessage;
import diskCacheV111.vehicles.PnfsGetChecksumMessage;
import diskCacheV111.vehicles.PnfsGetFileMetaDataMessage;
import diskCacheV111.vehicles.PnfsGetParentMessage;
import diskCacheV111.vehicles.PnfsGetStorageInfoMessage;
import diskCacheV111.vehicles.PnfsMapPathMessage;
import diskCacheV111.vehicles.PnfsMessage;
import diskCacheV111.vehicles.PnfsRenameMessage;
import diskCacheV111.vehicles.PnfsSetChecksumMessage;
import diskCacheV111.vehicles.PnfsSetFileMetaDataMessage;
import diskCacheV111.vehicles.PoolFileFlushedMessage;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.UOID;
import dmg.util.Args;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.AccessType;
import org.dcache.auth.Subjects;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.commons.stats.RequestCounters;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.namespace.ListHandler;
import org.dcache.namespace.PermissionHandler;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.util.MathUtils;
import org.dcache.util.PrefixMap;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsGetFileAttributes;
import org.dcache.vehicles.PnfsListDirectoryMessage;
import org.dcache.vehicles.PnfsRemoveChecksumMessage;
import org.dcache.vehicles.PnfsSetFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class PnfsManagerV3
extends AbstractCellComponent
implements CellCommandListener,
CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(PnfsManagerV3.class);
    private static final int THRESHOLD_DISABLED = 0;
    private static final int TTL_BUFFER_MAXIMUM = 10000;
    private static final float TTL_BUFFER_FRACTION = 0.1f;
    private final Random _random = new Random(System.currentTimeMillis());
    private final RequestExecutionTimeGauges<Class<? extends PnfsMessage>> _gauges = new RequestExecutionTimeGauges("PnfsManagerV3");
    private final RequestCounters<Class<?>> _foldedCounters = new RequestCounters("PnfsManagerV3.Folded");
    private final PrefixMap<Integer> _pathToDBCache = new PrefixMap();
    private final Class<?>[] DISCARD_EARLY = new Class[]{PnfsGetCacheLocationsMessage.class, PnfsGetStorageInfoMessage.class, PnfsMapPathMessage.class, PnfsGetFileMetaDataMessage.class, PnfsGetParentMessage.class, PnfsGetChecksumAllMessage.class, PnfsGetChecksumMessage.class, PnfsCreateEntryMessage.class, PnfsCreateDirectoryMessage.class, PnfsGetFileAttributes.class, PnfsListDirectoryMessage.class};
    private int _threads;
    private int _threadGroups;
    private int _directoryListLimit;
    private int _queueMaxSize;
    private int _cacheLocationThreads;
    private int _listThreads;
    private long _logSlowThreshold;
    private boolean _canFold;
    private BlockingQueue<CellMessage>[] _listQueues;
    private BlockingQueue<CellMessage>[] _locationFifos;
    private BlockingQueue<CellMessage>[] _fifos;
    private CellPath _cacheModificationRelay;
    private CellPath _pnfsDeleteNotificationRelay;
    private PermissionHandler _permissionHandler;
    private NameSpaceProvider _nameSpaceProvider;
    private NameSpaceProvider _cacheLocationProvider;
    public static final String hh_flags_set = "<pnfsId> <key=value> [...]";
    public static final String hh_flags_remove = "<pnfsId> <key> [...]";
    public static final String hh_flags_ls = "<pnfsId>";
    public static final String hh_pnfsidof = "<globalPath>";
    public static final String hh_cacheinfoof = "<pnfsid>|<globalPath>";
    public static final String hh_pathfinder = "<pnfsId>";
    public static final String hh_rename = " # rename <old name> <new name>";
    public static final String hh_set_meta = "<pnfsid>|<globalPath> <uid> <gid> <perm>";
    public static final String fh_storageinfoof = "   storageinfoof <pnfsid>|<globalPath> [-v] [-n] [-se]\n        -v    verbose\n        -n    don't resolve links\n        -se   suppress exceptions\n";
    public static final String hh_storageinfoof = "<pnfsid>|<globalPath> [-v] [-n] [-se]";
    public static final String fh_metadataof = "   storageinfoof <pnfsid>|<globalPath> [-v] [-n] [-se]\n        -v    verbose\n        -n    don't resolve links\n        -se   suppress exceptions\n";
    public static final String hh_metadataof = "<pnfsid>|<globalPath> [-v] [-n] [-se]";
    public static final String fh_dumpthreadqueues = "   dumpthreadqueues [<threadId>]\n        dumthreadqueus prints the context of\n        thread[s] queue[s] into the error log file";
    public static final String hh_dumpthreadqueues = "[<threadId>]\n";
    public static final String fh_set_file_size = "Updates the file's size in the namespace. This command has no effect on\nthe data stored on pools or on tape.\n\nSyntax:\n  set file size <pnfsid> <new size>\n\nIf the value of <new size> does not match the size of the stored data\nthen the file may become unavailable. Use with caution!\n";
    public static final String hh_set_file_size = "<pnfsid> <new size> # changes registered file size";
    public static final String hh_add_file_cache_location = "<pnfsid> <pool name>";
    public static final String hh_clear_file_cache_location = "<pnfsid> <pool name>";
    public static final String hh_add_file_checksum = "<pnfsid> <type> <checksum>";
    public static final String hh_clear_file_checksum = "<pnfsid> <type>";
    public static final String hh_get_file_checksum = "<pnfsid> <type>";
    public static final String hh_set_log_slow_threshold = "<timeout in ms>";
    public static final String fh_set_log_slow_threshold = "Set the threshold for reporting slow PNFS interactions.";
    public static final String fh_get_log_slow_threshold = "Return the current threshold for reporting slow PNFS interactions.";
    public static final String fh_set_log_slow_threshold_disabled = "Disable reporting of slow PNFS interactions.";
    public static final String fh_show_path_cache = "Shows cached information about mappings from path prefixes to\nname space database IDs. The cache is only populated if the\nnumber of thread groups is larger than 1.";

    private void populateRequestMap() {
        this._gauges.addGauge(PnfsAddCacheLocationMessage.class);
        this._gauges.addGauge(PnfsClearCacheLocationMessage.class);
        this._gauges.addGauge(PnfsGetCacheLocationsMessage.class);
        this._gauges.addGauge(PnfsCreateDirectoryMessage.class);
        this._gauges.addGauge(PnfsCreateEntryMessage.class);
        this._gauges.addGauge(PnfsDeleteEntryMessage.class);
        this._gauges.addGauge(PnfsGetStorageInfoMessage.class);
        this._gauges.addGauge(PnfsGetFileMetaDataMessage.class);
        this._gauges.addGauge(PnfsSetFileMetaDataMessage.class);
        this._gauges.addGauge(PnfsMapPathMessage.class);
        this._gauges.addGauge(PnfsRenameMessage.class);
        this._gauges.addGauge(PnfsFlagMessage.class);
        this._gauges.addGauge(PnfsSetChecksumMessage.class);
        this._gauges.addGauge(PnfsGetChecksumMessage.class);
        this._gauges.addGauge(PoolFileFlushedMessage.class);
        this._gauges.addGauge(PnfsGetChecksumAllMessage.class);
        this._gauges.addGauge(PnfsGetParentMessage.class);
        this._gauges.addGauge(PnfsSetFileAttributes.class);
        this._gauges.addGauge(PnfsGetFileAttributes.class);
        this._gauges.addGauge(PnfsListDirectoryMessage.class);
        this._gauges.addGauge(PnfsRemoveChecksumMessage.class);
    }

    public PnfsManagerV3() {
        this.populateRequestMap();
    }

    @Required
    public void setThreads(int threads) {
        this._threads = threads;
    }

    @Required
    public void setCacheLocationThreads(int threads) {
        this._cacheLocationThreads = threads;
    }

    @Required
    public void setListThreads(int threads) {
        this._listThreads = threads;
    }

    @Required
    public void setThreadGroups(int threadGroups) {
        this._threadGroups = threadGroups;
    }

    @Required
    public void setCacheModificationRelay(String path) {
        this._cacheModificationRelay = Strings.isNullOrEmpty((String)path) ? null : new CellPath(path);
        _log.info("CacheModificationRelay = {}", (Object)(this._cacheModificationRelay == null ? "NONE" : this._cacheModificationRelay.toString()));
    }

    @Required
    public void setPnfsDeleteNotificationRelay(String path) {
        this._pnfsDeleteNotificationRelay = Strings.isNullOrEmpty((String)path) ? null : new CellPath(path);
        _log.info("pnfsDeleteRelay = {}", (Object)(this._pnfsDeleteNotificationRelay == null ? "NONE" : this._pnfsDeleteNotificationRelay.toString()));
    }

    @Required
    public void setLogSlowThreshold(long threshold) {
        this._logSlowThreshold = threshold;
        _log.info("logSlowThreshold {}", (Object)(this._logSlowThreshold == 0L ? "NONE" : String.valueOf(this._logSlowThreshold)));
    }

    @Required
    public void setPermissionHandler(PermissionHandler handler) {
        this._permissionHandler = handler;
    }

    @Required
    public void setNameSpaceProvider(NameSpaceProvider provider) {
        this._nameSpaceProvider = provider;
    }

    @Required
    public void setCacheLocationProvider(NameSpaceProvider provider) {
        this._cacheLocationProvider = provider;
    }

    @Required
    public void setQueueMaxSize(int maxSize) {
        this._queueMaxSize = maxSize;
    }

    @Required
    public void setFolding(boolean folding) {
        this._canFold = folding;
    }

    @Required
    public void setDirectoryListLimit(int limit) {
        this._directoryListLimit = limit;
    }

    public void init() {
        int i;
        this._fifos = new BlockingQueue[this._threads * this._threadGroups];
        _log.info("Starting {} threads", (Object)this._fifos.length);
        for (i = 0; i < this._fifos.length; ++i) {
            this._fifos[i] = this._queueMaxSize > 0 ? new LinkedBlockingQueue<CellMessage>(this._queueMaxSize) : new LinkedBlockingQueue<CellMessage>();
            new Thread((Runnable)new ProcessThread(this._fifos[i]), "proc-" + i).start();
        }
        if (this._cacheLocationThreads > 0) {
            _log.info("Starting {} cache location threads", (Object)this._cacheLocationThreads);
            this._locationFifos = new BlockingQueue[this._cacheLocationThreads];
            for (i = 0; i < this._locationFifos.length; ++i) {
                this._locationFifos[i] = new LinkedBlockingQueue<CellMessage>();
                new Thread((Runnable)new ProcessThread(this._locationFifos[i]), "proc-loc-" + i).start();
            }
        } else {
            this._locationFifos = this._fifos;
        }
        this._listQueues = new BlockingQueue[this._threadGroups];
        for (i = 0; i < this._threadGroups; ++i) {
            this._listQueues[i] = new LinkedBlockingQueue<CellMessage>();
            for (int j = 0; j < this._listThreads; ++j) {
                new Thread((Runnable)new ProcessThread(this._listQueues[i]), "proc-list-" + i + "-" + j).start();
            }
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        int i;
        pw.println("$Revision$");
        pw.println("NameSpace Provider: ");
        pw.println(this._nameSpaceProvider.toString());
        pw.println("CacheLocation Provider: ");
        pw.println(this._cacheLocationProvider.toString());
        pw.println();
        pw.println("List queues (" + this._listQueues.length + ")");
        for (i = 0; i < this._listQueues.length; ++i) {
            pw.println("    [" + i + "] " + this._listQueues[i].size());
        }
        pw.println();
        pw.println("Threads (" + this._fifos.length + ") Queue");
        for (i = 0; i < this._fifos.length; ++i) {
            pw.println("    [" + i + "] " + this._fifos[i].size());
        }
        pw.println();
        pw.println("Thread groups (" + this._threadGroups + ")");
        for (i = 0; i < this._threadGroups; ++i) {
            int total = 0;
            for (int j = 0; j < this._threads; ++j) {
                total += this._fifos[i * this._threads + j].size();
            }
            pw.println("    [" + i + "] " + total);
        }
        pw.println();
        if (this._fifos != this._locationFifos) {
            pw.println("Cache Location Queues");
            for (i = 0; i < this._locationFifos.length; ++i) {
                pw.println("    [" + i + "] " + this._locationFifos[i].size());
            }
            pw.println();
        }
        pw.println("Statistics:");
        pw.println(this._gauges.toString());
        pw.println(this._foldedCounters.toString());
    }

    public String ac_pnfsidof_$_1(Args args) {
        StringBuilder sb = new StringBuilder();
        try {
            PnfsId pnfsId = this.pathToPnfsid(Subjects.ROOT, args.argv(0), false);
            sb.append(pnfsId.toString());
        }
        catch (Exception e) {
            sb.append("pnfsidof failed:").append(e.getMessage());
        }
        return sb.toString();
    }

    public String ac_cacheinfoof_$_1(Args args) {
        StringBuilder sb = new StringBuilder();
        try {
            PnfsId pnfsId;
            try {
                pnfsId = new PnfsId(args.argv(0));
            }
            catch (Exception ee) {
                pnfsId = this.pathToPnfsid(Subjects.ROOT, args.argv(0), true);
            }
            List<String> locations = this._cacheLocationProvider.getCacheLocation(Subjects.ROOT, pnfsId);
            for (String location : locations) {
                sb.append(" ").append(location);
            }
            sb.append("\n");
        }
        catch (Exception e) {
            sb.append("cacheinfoof failed: ").append(e.getMessage());
        }
        return sb.toString();
    }

    public String ac_pathfinder_$_1(Args args) throws Exception {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        return this._nameSpaceProvider.pnfsidToPath(Subjects.ROOT, pnfsId);
    }

    public String ac_rename_$_2(Args args) {
        PnfsId pnfsId;
        try {
            pnfsId = new PnfsId(args.argv(0));
        }
        catch (Exception ee) {
            try {
                pnfsId = this.pathToPnfsid(Subjects.ROOT, args.argv(0), true);
            }
            catch (Exception e) {
                return "rename failed: " + e.getMessage();
            }
        }
        try {
            String newName = args.argv(1);
            this.rename(Subjects.ROOT, pnfsId, newName, true);
        }
        catch (Exception e) {
            return "rename failed: " + e.getMessage();
        }
        return "";
    }

    public String ac_set_meta_$_4(Args args) {
        try {
            PnfsId pnfsId = PnfsId.isValid(args.argv(0)) ? new PnfsId(args.argv(0)) : this.pathToPnfsid(Subjects.ROOT, args.argv(0), true);
            FileAttributes attributes = new FileAttributes();
            attributes.setOwner(Integer.parseInt(args.argv(1)));
            attributes.setGroup(Integer.parseInt(args.argv(2)));
            attributes.setMode(Integer.parseInt(args.argv(3), 8));
            this._nameSpaceProvider.setFileAttributes(Subjects.ROOT, pnfsId, attributes);
            return "Ok";
        }
        catch (Exception e) {
            return "set metadata failed: + " + e.getMessage();
        }
    }

    public String ac_storageinfoof_$_1(Args args) {
        boolean v = args.hasOption("v");
        boolean n = args.hasOption("n");
        StringBuilder sb = new StringBuilder();
        try {
            PnfsId pnfsId;
            block8: {
                try {
                    pnfsId = new PnfsId(args.argv(0));
                    if (v) {
                        sb.append("PnfsId : ").append(pnfsId).append("\n");
                    }
                }
                catch (Exception ee) {
                    pnfsId = this.pathToPnfsid(Subjects.ROOT, args.argv(0), n);
                    if (v) {
                        sb.append("   Local Path : ").append(args.argv(0)).append("\n");
                    }
                    if (!v) break block8;
                    sb.append("       PnfsId : ").append(pnfsId).append("\n");
                }
            }
            FileAttributes attributes = this._nameSpaceProvider.getFileAttributes(Subjects.ROOT, pnfsId, EnumSet.of(FileAttribute.STORAGEINFO, FileAttribute.ACCESS_LATENCY, FileAttribute.RETENTION_POLICY, FileAttribute.SIZE));
            StorageInfo info = StorageInfos.extractFrom(attributes);
            if (v) {
                sb.append(" Storage Info : ").append(info).append("\n");
            } else {
                sb.append(info.toString()).append("\n");
            }
        }
        catch (Exception ee) {
            sb.append("storageinfoof failed : ").append(ee.getMessage());
        }
        return sb.toString();
    }

    public String ac_metadataof_$_1(Args args) {
        StringBuilder sb = new StringBuilder();
        boolean v = args.hasOption("v");
        boolean n = args.hasOption("n");
        try {
            PnfsId pnfsId;
            block8: {
                try {
                    pnfsId = new PnfsId(args.argv(0));
                    if (v) {
                        sb.append("PnfsId : ").append(pnfsId).append("\n");
                    }
                }
                catch (Exception ee) {
                    pnfsId = this.pathToPnfsid(Subjects.ROOT, args.argv(0), n);
                    if (v) {
                        sb.append("   Local Path : ").append(args.argv(0)).append("\n");
                    }
                    if (!v) break block8;
                    sb.append("       PnfsId : ").append(pnfsId).append("\n");
                }
            }
            FileMetaData info = new FileMetaData(this._nameSpaceProvider.getFileAttributes(Subjects.ROOT, pnfsId, FileMetaData.getKnownFileAttributes()));
            if (v) {
                sb.append("    Meta Data : ").append(info).append("\n");
            } else {
                sb.append(info.toString()).append("\n");
            }
        }
        catch (Exception ee) {
            sb.append("matadataof failed : ").append(ee.getMessage());
        }
        return sb.toString();
    }

    public String ac_flags_set_$_2_99(Args args) throws CacheException {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        HashMap<String, String> flags = new HashMap<String, String>();
        for (int i = 1; i < args.argc(); ++i) {
            String t = args.argv(i);
            int l = t.length();
            if (l <= 0) continue;
            int p = t.indexOf(61);
            if (p < 0 || p == l - 1) {
                flags.put(t, "");
                continue;
            }
            if (p <= 0) continue;
            flags.put(t.substring(0, p), t.substring(p + 1));
        }
        FileAttributes attributes = new FileAttributes();
        attributes.setFlags(flags);
        this._nameSpaceProvider.setFileAttributes(Subjects.ROOT, pnfsId, attributes);
        return "";
    }

    public String ac_flags_remove_$_2_99(Args args) throws Exception {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        for (int i = 1; i < args.argc(); ++i) {
            String t = args.argv(i);
            this._nameSpaceProvider.removeFileAttribute(Subjects.ROOT, pnfsId, t);
        }
        return "";
    }

    public String ac_flags_ls_$_1(Args args) throws CacheException {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        FileAttributes attributes = this._nameSpaceProvider.getFileAttributes(Subjects.ROOT, pnfsId, EnumSet.of(FileAttribute.FLAGS));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : attributes.getFlags().entrySet()) {
            sb.append(e.getKey()).append(" -> ").append(e.getValue()).append("\n");
        }
        return sb.toString();
    }

    public String ac_dumpthreadqueues_$_0_1(Args args) {
        if (args.argc() > 0) {
            int threadId = Integer.parseInt(args.argv(0));
            this.dumpThreadQueue(threadId);
            return "dumped";
        }
        for (int threadId = 0; threadId < this._fifos.length; ++threadId) {
            this.dumpThreadQueue(threadId);
        }
        return "dumped";
    }

    public String ac_set_file_size_$_2(Args args) throws Exception {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        FileAttributes attributes = new FileAttributes();
        attributes.setSize(Long.valueOf(args.argv(1)));
        this._nameSpaceProvider.setFileAttributes(Subjects.ROOT, pnfsId, attributes);
        return "";
    }

    public String ac_add_file_cache_location_$_2(Args args) throws Exception {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        String cacheLocation = args.argv(1);
        this._cacheLocationProvider.addCacheLocation(Subjects.ROOT, pnfsId, cacheLocation);
        return "";
    }

    public String ac_clear_file_cache_location_$_2(Args args) throws Exception {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        String cacheLocation = args.argv(1);
        this._cacheLocationProvider.clearCacheLocation(Subjects.ROOT, pnfsId, cacheLocation, false);
        return "";
    }

    public String ac_add_file_checksum_$_3(Args args) throws CacheException {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        ChecksumType type = ChecksumType.getChecksumType((String)args.argv(1));
        Checksum checksum = new Checksum(type, args.argv(2));
        FileAttributes attributes = new FileAttributes();
        attributes.setChecksums(Collections.singleton(checksum));
        this._nameSpaceProvider.setFileAttributes(Subjects.ROOT, pnfsId, attributes);
        return "";
    }

    public String ac_clear_file_checksum_$_2(Args args) throws CacheException {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        ChecksumType type = ChecksumType.getChecksumType((String)args.argv(1));
        this._nameSpaceProvider.removeChecksum(Subjects.ROOT, pnfsId, type);
        return "";
    }

    public String ac_get_file_checksum_$_2(Args args) throws CacheException, NoSuchAlgorithmException {
        ChecksumType type;
        PnfsId pnfsId = new PnfsId(args.argv(0));
        Checksum checksum = this.getChecksum(Subjects.ROOT, pnfsId, type = ChecksumType.getChecksumType((String)args.argv(1)));
        return checksum == null ? "" : checksum.toString();
    }

    public String ac_set_log_slow_threshold_$_1(Args args) {
        int newTimeout;
        try {
            newTimeout = Integer.parseInt(args.argv(0));
        }
        catch (NumberFormatException e) {
            return "Badly formatted number " + args.argv(0);
        }
        if (newTimeout <= 0) {
            return "Timeout must be greater than zero";
        }
        this._logSlowThreshold = newTimeout;
        return "";
    }

    public String ac_get_log_slow_threshold_$_0(Args args) {
        if (this._logSlowThreshold == 0L) {
            return "disabled";
        }
        return String.valueOf(this._logSlowThreshold) + " ms";
    }

    public String ac_set_log_slow_threshold_disabled_$_0(Args args) {
        this._logSlowThreshold = 0L;
        return "";
    }

    public String ac_show_path_cache(Args args) {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<FsPath, Integer> e : this._pathToDBCache.entrySet()) {
            s.append(String.format("%s -> %d\n", e.getKey(), e.getValue()));
        }
        return s.toString();
    }

    private void dumpThreadQueue(int queueId) {
        if (queueId < 0 || queueId >= this._fifos.length) {
            throw new IllegalArgumentException(" illegal queue #" + queueId);
        }
        BlockingQueue<CellMessage> fifo = this._fifos[queueId];
        Object[] fifoContent = fifo.toArray();
        _log.warn("PnfsManager thread #" + queueId + " queue dump (" + fifoContent.length + "):");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fifoContent.length; ++i) {
            sb.append("fifo[").append(i).append("] : ");
            sb.append(fifoContent[i]).append('\n');
        }
        _log.warn(sb.toString());
    }

    private Checksum getChecksum(Subject subject, PnfsId pnfsId, ChecksumType type) throws CacheException, NoSuchAlgorithmException {
        ChecksumFactory factory = ChecksumFactory.getFactory(type);
        FileAttributes attributes = this._nameSpaceProvider.getFileAttributes(subject, pnfsId, EnumSet.of(FileAttribute.CHECKSUM));
        return factory.find(attributes.getChecksums());
    }

    private void getChecksum(PnfsGetChecksumMessage msg) {
        try {
            PnfsId pnfsId = msg.getPnfsId();
            if (pnfsId == null) {
                throw new InvalidMessageCacheException("no pnfsid defined");
            }
            ChecksumType type = ChecksumType.getChecksumType((int)msg.getType());
            Checksum checksum = this.getChecksum(msg.getSubject(), pnfsId, type);
            if (checksum != null) {
                msg.setValue(checksum.getValue());
            }
        }
        catch (CacheException e) {
            _log.warn(e.toString());
            msg.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (Exception e) {
            _log.warn(e.toString());
            msg.setFailed(10011, (Serializable)((Object)e.getMessage()));
        }
    }

    private void listChecksumTypes(PnfsGetChecksumAllMessage msg) {
        PnfsId pnfsId = msg.getPnfsId();
        try {
            FileAttributes attributes = this._nameSpaceProvider.getFileAttributes(msg.getSubject(), pnfsId, EnumSet.of(FileAttribute.CHECKSUM));
            Set<Checksum> checksums = attributes.getChecksums();
            int[] types = new int[checksums.size()];
            int index = 0;
            for (Checksum checksum : checksums) {
                types[index++] = checksum.getType().getType();
            }
            msg.setValue(types);
        }
        catch (CacheException e) {
            _log.warn(e.toString());
            msg.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (Exception e) {
            _log.warn(e.toString());
            msg.setFailed(10011, (Serializable)((Object)e.getMessage()));
        }
    }

    private void setChecksum(PnfsSetChecksumMessage msg) {
        PnfsId pnfsId = msg.getPnfsId();
        String value = msg.getValue();
        try {
            ChecksumType type = ChecksumType.getChecksumType((int)msg.getType());
            Checksum checksum = new Checksum(type, value);
            FileAttributes attributes = new FileAttributes();
            attributes.setChecksums(Collections.singleton(checksum));
            this._nameSpaceProvider.setFileAttributes(msg.getSubject(), pnfsId, attributes);
        }
        catch (FileNotFoundCacheException e) {
            msg.setFailed(10001, (Serializable)((Object)e.getMessage()));
        }
        catch (CacheException e) {
            _log.warn("Unxpected CacheException: " + e);
            msg.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (Exception e) {
            _log.warn(e.toString());
            msg.setFailed(10011, (Serializable)((Object)e.getMessage()));
        }
    }

    private void updateFlag(PnfsFlagMessage pnfsMessage) {
        PnfsId pnfsId = pnfsMessage.getPnfsId();
        PnfsFlagMessage.FlagOperation operation = pnfsMessage.getOperation();
        String flagName = pnfsMessage.getFlagName();
        String value = pnfsMessage.getValue();
        Subject subject = pnfsMessage.getSubject();
        _log.info("update flag " + (Object)((Object)operation) + " flag=" + flagName + " value=" + value + " for " + pnfsId);
        try {
            if (operation == PnfsFlagMessage.FlagOperation.GET) {
                pnfsMessage.setValue(this.updateFlag(subject, pnfsId, operation, flagName, value));
            } else {
                this.updateFlag(subject, pnfsId, operation, flagName, value);
            }
        }
        catch (CacheException e) {
            _log.warn("Exception in updateFlag: " + e);
            pnfsMessage.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error("Exception in updateFlag", (Throwable)e);
            pnfsMessage.setFailed(10011, e);
        }
    }

    private String updateFlag(Subject subject, PnfsId pnfsId, PnfsFlagMessage.FlagOperation operation, String flagName, String value) throws CacheException {
        switch (operation) {
            case SET: {
                _log.info("flags set " + pnfsId + " " + flagName + "=" + value);
                FileAttributes attributes = new FileAttributes();
                attributes.setFlags(Collections.singletonMap(flagName, value));
                this._nameSpaceProvider.setFileAttributes(subject, pnfsId, attributes);
                break;
            }
            case SETNOOVERWRITE: {
                _log.info("flags set (dontoverwrite) " + pnfsId + " " + flagName + "=" + value);
                FileAttributes attributes = this._nameSpaceProvider.getFileAttributes(subject, pnfsId, EnumSet.of(FileAttribute.FLAGS));
                String current = attributes.getFlags().get(flagName);
                if (current != null && current.equals(value)) break;
                this.updateFlag(subject, pnfsId, PnfsFlagMessage.FlagOperation.SET, flagName, value);
                break;
            }
            case GET: {
                FileAttributes attributes = this._nameSpaceProvider.getFileAttributes(subject, pnfsId, EnumSet.of(FileAttribute.FLAGS));
                String v = attributes.getFlags().get(flagName);
                _log.info("flags ls " + pnfsId + " " + flagName + " -> " + v);
                return v;
            }
            case REMOVE: {
                _log.info("flags remove " + pnfsId + " " + flagName);
                this._nameSpaceProvider.removeFileAttribute(subject, pnfsId, flagName);
            }
        }
        return null;
    }

    public void addCacheLocation(PnfsAddCacheLocationMessage pnfsMessage) {
        _log.info("addCacheLocation : " + pnfsMessage.getPoolName() + " for " + pnfsMessage.getPnfsId());
        try {
            this.checkMask(pnfsMessage);
            this._cacheLocationProvider.addCacheLocation(pnfsMessage.getSubject(), pnfsMessage.getPnfsId(), pnfsMessage.getPoolName());
        }
        catch (FileNotFoundCacheException fnf) {
            pnfsMessage.setFailed(10001, (Serializable)((Object)fnf.getMessage()));
        }
        catch (CacheException e) {
            _log.warn("Exception in addCacheLocation: " + e);
            pnfsMessage.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error("Exception in addCacheLocation", (Throwable)e);
            pnfsMessage.setFailed(10011, (Serializable)((Object)"Exception in addCacheLocation"));
        }
    }

    public void clearCacheLocation(PnfsClearCacheLocationMessage pnfsMessage) {
        PnfsId pnfsId = pnfsMessage.getPnfsId();
        _log.info("clearCacheLocation : " + pnfsMessage.getPoolName() + " for " + pnfsId);
        try {
            this.checkMask(pnfsMessage);
            this._cacheLocationProvider.clearCacheLocation(pnfsMessage.getSubject(), pnfsId, pnfsMessage.getPoolName(), pnfsMessage.removeIfLast());
        }
        catch (FileNotFoundCacheException fnf) {
            pnfsMessage.setFailed(10001, (Serializable)((Object)fnf.getMessage()));
        }
        catch (CacheException e) {
            _log.warn("Exception in clearCacheLocation for " + pnfsId + ": " + e);
            pnfsMessage.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error("Exception in clearCacheLocation for " + pnfsId, (Throwable)e);
            pnfsMessage.setFailed(10011, (Serializable)((Object)e.getMessage()));
        }
    }

    public void getCacheLocations(PnfsGetCacheLocationsMessage pnfsMessage) {
        Subject subject = pnfsMessage.getSubject();
        try {
            PnfsId pnfsId = this.populatePnfsId(pnfsMessage);
            _log.info("get cache locations for " + pnfsId);
            this.checkMask(pnfsMessage);
            pnfsMessage.setCacheLocations(this._cacheLocationProvider.getCacheLocation(subject, pnfsId));
            pnfsMessage.setSucceeded();
        }
        catch (FileNotFoundCacheException fnf) {
            pnfsMessage.setFailed(10001, (Serializable)((Object)fnf.getMessage()));
        }
        catch (CacheException e) {
            _log.warn("Exception in getCacheLocations: " + e);
            pnfsMessage.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error("Exception in getCacheLocations", (Throwable)e);
            pnfsMessage.setFailed(10011, (Serializable)((Object)"Pnfs lookup failed"));
        }
    }

    public void createDirectory(PnfsCreateDirectoryMessage pnfsMessage) {
        _log.info("create directory " + pnfsMessage.getPath());
        try {
            File file = new File(pnfsMessage.getPath());
            this.checkMask(pnfsMessage.getSubject(), file.getParent(), pnfsMessage.getAccessMask());
            PnfsId pnfsId = this._nameSpaceProvider.createEntry(pnfsMessage.getSubject(), pnfsMessage.getPath(), pnfsMessage.getUid(), pnfsMessage.getGid(), pnfsMessage.getMode(), true);
            pnfsMessage.setPnfsId(pnfsId);
            pnfsMessage.setSucceeded();
            try {
                _log.info("Trying to get storageInfo for " + pnfsId);
                Set<FileAttribute> requested = pnfsMessage.getRequestedAttributes();
                FileAttributes attrs = this._nameSpaceProvider.getFileAttributes(Subjects.ROOT, pnfsId, requested);
                pnfsMessage.setFileAttributes(attrs);
            }
            catch (CacheException e) {
                _log.warn("Can't determine storageInfo: " + e);
            }
        }
        catch (CacheException e) {
            pnfsMessage.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error("Failed to create directory", (Throwable)e);
            pnfsMessage.setFailed(10011, e);
        }
    }

    public void createEntry(PnfsCreateEntryMessage pnfsMessage) {
        _log.info("create entry " + pnfsMessage.getPath());
        try {
            File file = new File(pnfsMessage.getPath());
            this.checkMask(pnfsMessage.getSubject(), file.getParent(), pnfsMessage.getAccessMask());
            PnfsId pnfsId = this._nameSpaceProvider.createEntry(pnfsMessage.getSubject(), pnfsMessage.getPath(), pnfsMessage.getUid(), pnfsMessage.getGid(), pnfsMessage.getMode(), false);
            pnfsMessage.setPnfsId(pnfsId);
            pnfsMessage.setSucceeded();
            try {
                _log.info("Trying to get storageInfo for " + pnfsId);
                Set<FileAttribute> requested = pnfsMessage.getRequestedAttributes();
                requested.add(FileAttribute.STORAGEINFO);
                FileAttributes attrs = this._nameSpaceProvider.getFileAttributes(Subjects.ROOT, pnfsId, requested);
                StorageInfo info = attrs.getStorageInfo();
                info.setKey("path", pnfsMessage.getPath());
                info.setKey("uid", Integer.toString(pnfsMessage.getUid()));
                info.setKey("gid", Integer.toString(pnfsMessage.getGid()));
                pnfsMessage.setFileAttributes(attrs);
            }
            catch (CacheException e) {
                _log.warn("Can't determine storageInfo: " + e);
            }
        }
        catch (CacheException e) {
            pnfsMessage.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error("Create entry failed", (Throwable)e);
            pnfsMessage.setFailed(10011, e);
        }
    }

    public void setFileMetaData(PnfsSetFileMetaDataMessage message) {
        try {
            PnfsId pnfsId = this.populatePnfsId(message);
            FileMetaData meta = message.getMetaData();
            _log.info("setFileMetaData=" + meta + " for " + pnfsId);
            this.checkMask(message);
            this._nameSpaceProvider.setFileAttributes(message.getSubject(), pnfsId, meta.toFileAttributes());
        }
        catch (CacheException e) {
            _log.warn("Failed to set meta data: " + e);
            message.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.warn("Failed to set meta data", (Throwable)e);
            message.setFailed(10011, e);
        }
    }

    private boolean isOfType(PnfsId pnfsid, Set<FileType> types) throws CacheException {
        if (types.equals(EnumSet.allOf(FileType.class))) {
            return true;
        }
        FileAttributes attributes = this._nameSpaceProvider.getFileAttributes(Subjects.ROOT, pnfsid, EnumSet.of(FileAttribute.TYPE));
        return types.contains((Object)attributes.getFileType());
    }

    public void deleteEntry(PnfsDeleteEntryMessage pnfsMessage) {
        String path = pnfsMessage.getPath();
        PnfsId pnfsId = pnfsMessage.getPnfsId();
        Subject subject = pnfsMessage.getSubject();
        Set<FileType> allowed = pnfsMessage.getAllowedFileTypes();
        try {
            if (path == null && pnfsId == null) {
                throw new CacheException(10015, "pnfsid or path have to be defined for PnfsDeleteEntryMessage");
            }
            if (path != null) {
                PnfsId pnfsIdFromPath = this.pathToPnfsid(subject, path, false);
                this.checkMask(pnfsMessage.getSubject(), pnfsIdFromPath, pnfsMessage.getAccessMask());
                if (pnfsId != null) {
                    if (!pnfsIdFromPath.equals(pnfsId)) {
                        throw new FileNotFoundCacheException("Pnfsid does not correspond to provided file");
                    }
                } else {
                    pnfsId = pnfsIdFromPath;
                    pnfsMessage.setPnfsId(pnfsId);
                }
                if (!this.isOfType(pnfsId, allowed)) {
                    throw new CacheException(10015, "Path exists but is not of the expected type");
                }
                _log.info("delete PNFS entry for " + path);
                this._nameSpaceProvider.deleteEntry(subject, path);
            } else {
                if (!this.isOfType(pnfsId, allowed)) {
                    throw new CacheException(10015, "Path exists but is not of the expected type");
                }
                this.checkMask(pnfsMessage);
                _log.info("delete PNFS entry for " + pnfsId);
                this._nameSpaceProvider.deleteEntry(subject, pnfsId);
            }
            pnfsMessage.setSucceeded();
        }
        catch (FileNotFoundCacheException e) {
            pnfsMessage.setFailed(10001, (Serializable)((Object)e.getMessage()));
        }
        catch (CacheException e) {
            _log.warn("Failed to delete entry: " + e.getMessage());
            pnfsMessage.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error("Failed to delete entry", (Throwable)e);
            pnfsMessage.setFailed(10011, e);
        }
        if (pnfsMessage.getReturnCode() == 0 && this._pnfsDeleteNotificationRelay != null) {
            PnfsDeleteEntryNotificationMessage deleteNotification = new PnfsDeleteEntryNotificationMessage(pnfsId, path);
            try {
                this.sendMessage(new CellMessage(this._pnfsDeleteNotificationRelay, (Serializable)deleteNotification));
            }
            catch (NoRouteToCellException e) {
                _log.error("Failed to relay " + deleteNotification + " to " + this._cacheModificationRelay + ": " + e.getMessage());
            }
        }
    }

    public void rename(PnfsRenameMessage msg) {
        try {
            PnfsId pnfsId = this.populatePnfsId(msg);
            String newName = msg.newName();
            _log.info("rename " + pnfsId + " to new name : " + newName);
            this.checkMask(msg);
            this.rename(msg.getSubject(), pnfsId, newName, msg.getOverwrite());
        }
        catch (CacheException e) {
            msg.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error(e.toString(), (Throwable)e);
            msg.setFailed(10011, (Serializable)((Object)"Pnfs rename failed"));
        }
    }

    private void rename(Subject subject, PnfsId pnfsId, String newName, boolean overwrite) throws CacheException {
        _log.info("Renaming " + pnfsId + " to " + newName);
        this._nameSpaceProvider.renameEntry(subject, pnfsId, newName, overwrite);
    }

    private void removeByPnfsId(Subject subject, PnfsId pnfsId) throws CacheException {
        _log.info("removeByPnfsId : " + pnfsId);
        this._nameSpaceProvider.deleteEntry(subject, pnfsId);
    }

    private String pathfinder(Subject subject, PnfsId pnfsId) throws CacheException {
        return this._nameSpaceProvider.pnfsidToPath(subject, pnfsId);
    }

    public void mapPath(PnfsMapPathMessage pnfsMessage) {
        PnfsId pnfsId = pnfsMessage.getPnfsId();
        String globalPath = pnfsMessage.getGlobalPath();
        Subject subject = pnfsMessage.getSubject();
        boolean shouldResolve = pnfsMessage.shouldResolve();
        if (pnfsId == null && globalPath == null) {
            pnfsMessage.setFailed(5, (Serializable)((Object)"Illegal Arguments : need path or pnfsid"));
            return;
        }
        try {
            if (globalPath == null) {
                _log.info("map:  id2path for " + pnfsId);
                pnfsMessage.setGlobalPath(this.pathfinder(subject, pnfsId));
            } else {
                _log.info("map:  path2id for " + globalPath);
                pnfsMessage.setPnfsId(this.pathToPnfsid(subject, globalPath, shouldResolve));
            }
            this.checkMask(pnfsMessage);
        }
        catch (FileNotFoundCacheException fnf) {
            pnfsMessage.setFailed(10001, (Serializable)((Object)fnf.getMessage()));
        }
        catch (CacheException ce) {
            pnfsMessage.setFailed(ce.getRc(), (Serializable)((Object)ce.getMessage()));
            _log.warn("mapPath: " + ce.getMessage());
        }
        catch (RuntimeException e) {
            _log.error("Exception in mapPath (pathfinder) " + e, (Throwable)e);
            pnfsMessage.setFailed(10011, e);
        }
    }

    private void getParent(PnfsGetParentMessage msg) {
        try {
            PnfsId pnfsId = this.populatePnfsId(msg);
            this.checkMask(msg);
            msg.setParent(this._nameSpaceProvider.getParentOf(msg.getSubject(), pnfsId));
        }
        catch (CacheException e) {
            _log.warn(e.toString());
            msg.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error(e.toString(), (Throwable)e);
            msg.setFailed(10011, (Serializable)((Object)e.getMessage()));
        }
    }

    private void listDirectory(CellMessage envelope, PnfsListDirectoryMessage msg) {
        if (!msg.getReplyRequired()) {
            return;
        }
        try {
            String path = msg.getPnfsPath();
            this.checkMask(msg.getSubject(), path, msg.getAccessMask());
            long delay = PnfsManagerV3.getAdjustedTtl(envelope);
            long initialDelay = delay == Long.MAX_VALUE ? Long.MAX_VALUE : delay - envelope.getLocalAge();
            CellPath source = envelope.getSourcePath().revert();
            ListHandlerImpl handler = new ListHandlerImpl(source, envelope.getUOID(), msg, initialDelay, delay);
            this._nameSpaceProvider.list(msg.getSubject(), path, msg.getPattern(), msg.getRange(), msg.getRequestedAttributes(), handler);
            msg.setFinal(true);
            msg.setSucceeded();
        }
        catch (FileNotFoundCacheException | NotDirCacheException e) {
            msg.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (CacheException e) {
            _log.warn(e.toString());
            msg.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error(e.toString(), (Throwable)e);
            msg.setFailed(10011, (Serializable)((Object)e.getMessage()));
        }
    }

    public void messageArrived(CellMessage envelope, PnfsListDirectoryMessage message) throws CacheException {
        int group;
        PnfsId pnfsId = message.getPnfsId();
        String path = message.getPnfsPath();
        if (pnfsId != null) {
            group = this.pnfsIdToThreadGroup(pnfsId);
            _log.info("Using list queue [{}] {}", (Object)pnfsId, (Object)group);
        } else if (path != null) {
            group = this.pathToThreadGroup(path);
            _log.info("Using list queue [{}] {}", (Object)path, (Object)group);
        } else {
            throw new InvalidMessageCacheException("Missing PNFS id and path");
        }
        if (!this._listQueues[group].offer(envelope)) {
            throw new MissingResourceCacheException("PnfsManager queue limit exceeded");
        }
    }

    public void messageArrived(CellMessage envelope, PnfsMessage message) throws CacheException {
        BlockingQueue<CellMessage> fifo;
        boolean isCacheOperation;
        PnfsId pnfsId = message.getPnfsId();
        String path = message.getPnfsPath();
        if (this._cacheModificationRelay != null && (message instanceof PnfsAddCacheLocationMessage || message instanceof PnfsClearCacheLocationMessage)) {
            this.forwardModifyCacheLocationMessage(message);
        }
        boolean bl = isCacheOperation = message instanceof PnfsAddCacheLocationMessage || message instanceof PnfsClearCacheLocationMessage || message instanceof PnfsGetCacheLocationsMessage;
        if (isCacheOperation && this._locationFifos != this._fifos) {
            int index;
            if (pnfsId != null) {
                index = (int)(Math.abs((long)pnfsId.hashCode()) % (long)this._locationFifos.length);
                _log.info("Using location thread [{}] {}", (Object)pnfsId, (Object)index);
            } else if (path != null) {
                index = (int)(Math.abs((long)path.hashCode()) % (long)this._locationFifos.length);
                _log.info("Using location thread [{}] {}", (Object)path, (Object)index);
            } else {
                index = this._random.nextInt(this._locationFifos.length);
                _log.info("Using random location thread {}", (Object)index);
            }
            fifo = this._locationFifos[index];
        } else {
            int index;
            if (pnfsId != null) {
                index = this.pnfsIdToThreadGroup(pnfsId) * this._threads + (int)(Math.abs((long)pnfsId.hashCode()) % (long)this._threads);
                _log.info("Using thread [{}] {}", (Object)pnfsId, (Object)index);
            } else if (path != null) {
                index = this.pathToThreadGroup(path) * this._threads + (int)(Math.abs((long)path.hashCode()) % (long)this._threads);
                _log.info("Using thread [{}] {}", (Object)path, (Object)index);
            } else {
                index = this._random.nextInt(this._fifos.length);
                _log.info("Using random thread {}", (Object)index);
            }
            fifo = this._fifos[index];
        }
        if (!fifo.offer(envelope)) {
            throw new MissingResourceCacheException("PnfsManager queue limit exceeded");
        }
    }

    private void forwardModifyCacheLocationMessage(PnfsMessage message) {
        try {
            this.sendMessage(new CellMessage(this._cacheModificationRelay, (Serializable)message));
        }
        catch (NoRouteToCellException e) {
            _log.error("Failed to relay " + message + " to " + this._cacheModificationRelay + ": " + e.getMessage());
        }
    }

    public void processPnfsMessage(CellMessage message, PnfsMessage pnfsMessage) {
        long ctime = System.currentTimeMillis();
        if (pnfsMessage instanceof PnfsAddCacheLocationMessage) {
            this.addCacheLocation((PnfsAddCacheLocationMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsClearCacheLocationMessage) {
            this.clearCacheLocation((PnfsClearCacheLocationMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsGetCacheLocationsMessage) {
            this.getCacheLocations((PnfsGetCacheLocationsMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsCreateDirectoryMessage) {
            this.createDirectory((PnfsCreateDirectoryMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsCreateEntryMessage) {
            this.createEntry((PnfsCreateEntryMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsDeleteEntryMessage) {
            this.deleteEntry((PnfsDeleteEntryMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsSetFileMetaDataMessage) {
            this.setFileMetaData((PnfsSetFileMetaDataMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsMapPathMessage) {
            this.mapPath((PnfsMapPathMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsRenameMessage) {
            this.rename((PnfsRenameMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsFlagMessage) {
            this.updateFlag((PnfsFlagMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsSetChecksumMessage) {
            this.setChecksum((PnfsSetChecksumMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsGetChecksumMessage) {
            this.getChecksum((PnfsGetChecksumMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PoolFileFlushedMessage) {
            this.processFlushMessage((PoolFileFlushedMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsGetChecksumAllMessage) {
            this.listChecksumTypes((PnfsGetChecksumAllMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsGetParentMessage) {
            this.getParent((PnfsGetParentMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsListDirectoryMessage) {
            this.listDirectory(message, (PnfsListDirectoryMessage)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsGetFileAttributes) {
            this.getFileAttributes((PnfsGetFileAttributes)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsSetFileAttributes) {
            this.setFileAttributes((PnfsSetFileAttributes)pnfsMessage);
        } else if (pnfsMessage instanceof PnfsRemoveChecksumMessage) {
            this.removeChecksum((PnfsRemoveChecksumMessage)pnfsMessage);
        } else {
            _log.warn("Unexpected message class [" + pnfsMessage.getClass() + "] from source [" + message.getSourcePath() + "]");
            return;
        }
        if (pnfsMessage.getReturnCode() == 10015) {
            _log.error("Inconsistent message " + pnfsMessage.getClass() + " received form " + message.getSourcePath());
        }
        long duration = System.currentTimeMillis() - ctime;
        this._gauges.update(pnfsMessage.getClass(), duration);
        String logMsg = pnfsMessage.getClass() + " processed in " + duration + " ms";
        if (this._logSlowThreshold != 0L && duration > this._logSlowThreshold) {
            _log.warn(logMsg);
        } else {
            _log.info(logMsg);
        }
        if (!pnfsMessage.getReplyRequired()) {
            return;
        }
        try {
            message.revertDirection();
            this.sendMessage(message);
        }
        catch (NoRouteToCellException e) {
            _log.warn("Failed to send reply: " + e.getMessage());
        }
    }

    public void processFlushMessage(PoolFileFlushedMessage pnfsMessage) {
        try {
            FileAttributes attributesToUpdate = new FileAttributes();
            attributesToUpdate.setStorageInfo(pnfsMessage.getFileAttributes().getStorageInfo());
            this._nameSpaceProvider.setFileAttributes(pnfsMessage.getSubject(), pnfsMessage.getPnfsId(), attributesToUpdate);
        }
        catch (CacheException e) {
            pnfsMessage.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.warn("Failed to process flush notification", (Throwable)e);
            pnfsMessage.setFailed(10011, e);
        }
    }

    private void removeChecksum(PnfsRemoveChecksumMessage message) {
        try {
            this._nameSpaceProvider.removeChecksum(message.getSubject(), message.getPnfsId(), message.getType());
        }
        catch (CacheException e) {
            message.setFailed(e.getRc(), (Serializable)((Object)e.getMessage()));
        }
        catch (RuntimeException e) {
            message.setFailed(10011, e);
        }
    }

    private PnfsId pathToPnfsid(Subject subject, String path, boolean resolve) throws CacheException {
        PnfsId pnfsId = this._nameSpaceProvider.pathToPnfsid(subject, path, resolve);
        this.updatePathToDatabaseIdCache(path, pnfsId.getDatabaseId());
        return pnfsId;
    }

    private void updatePathToDatabaseIdCache(String path, int id) {
        try {
            Integer db;
            if (this._threadGroups > 1 && ((db = this._pathToDBCache.get(new FsPath(path))) == null || db != id)) {
                String root = this.getDatabaseRoot(new File(path)).getPath();
                this._pathToDBCache.put(new FsPath(root), id);
                _log.info("Path cache updated: " + root + " -> " + id);
            }
        }
        catch (Exception e) {
            _log.warn("Error while resolving the database ID: " + e.getMessage());
        }
    }

    private File getDatabaseRoot(File file) throws Exception {
        PnfsId id;
        try {
            id = this._nameSpaceProvider.pathToPnfsid(Subjects.ROOT, file.getPath(), true);
        }
        catch (CacheException e) {
            file = file.getParentFile();
            if (file == null) {
                throw e;
            }
            return this.getDatabaseRoot(file);
        }
        try {
            String parent = file.getParent();
            if (parent == null) {
                return file;
            }
            PnfsId parentId = this._nameSpaceProvider.pathToPnfsid(Subjects.ROOT, parent, true);
            while (parentId.getDatabaseId() == id.getDatabaseId()) {
                file = new File(parent);
                if ((parent = file.getParent()) == null) {
                    return file;
                }
                parentId = this._nameSpaceProvider.pathToPnfsid(Subjects.ROOT, parent, true);
            }
            return file;
        }
        catch (CacheException e) {
            return file;
        }
    }

    private int pathToThreadGroup(String path) {
        if (this._threadGroups == 1) {
            return 0;
        }
        Integer db = this._pathToDBCache.get(new FsPath(path));
        if (db != null) {
            return db % this._threadGroups;
        }
        _log.info("Path cache miss for " + path);
        return MathUtils.absModulo(path.hashCode(), this._threadGroups);
    }

    private int pnfsIdToThreadGroup(PnfsId id) {
        return id.getDatabaseId() % this._threadGroups;
    }

    private boolean useEarlyDiscard(PnfsMessage message) {
        Class<?> msgClass = message.getClass();
        for (Class<?> c : this.DISCARD_EARLY) {
            if (!c.equals(msgClass)) continue;
            return true;
        }
        return false;
    }

    private void sendTimeout(CellMessage envelope, String error) {
        Message msg = (Message)envelope.getMessageObject();
        if (msg.getReplyRequired()) {
            try {
                msg.setFailed(10006, (Serializable)((Object)error));
                envelope.revertDirection();
                this.sendMessage(envelope);
            }
            catch (NoRouteToCellException e) {
                _log.warn("Failed to send reply: " + e.getMessage());
            }
        }
    }

    public void getFileAttributes(PnfsGetFileAttributes message) {
        try {
            FileAttributes attrs;
            Subject subject = message.getSubject();
            PnfsId pnfsId = this.populatePnfsId(message);
            this.checkMask(message);
            Set<FileAttribute> requested = message.getRequestedAttributes();
            if (requested.contains((Object)FileAttribute.STORAGEINFO)) {
                requested = EnumSet.copyOf(requested);
                requested.add(FileAttribute.OWNER);
                requested.add(FileAttribute.OWNER_GROUP);
            }
            if ((attrs = this._nameSpaceProvider.getFileAttributes(subject, pnfsId, requested)).isDefined(FileAttribute.STORAGEINFO)) {
                attrs.getStorageInfo().setKey("path", message.getPnfsPath());
                attrs.getStorageInfo().setKey("uid", Integer.toString(attrs.getOwner()));
                attrs.getStorageInfo().setKey("gid", Integer.toString(attrs.getGroup()));
            }
            message.setFileAttributes(attrs);
            message.setSucceeded();
        }
        catch (FileNotFoundCacheException e) {
            message.setFailed(e.getRc(), e);
        }
        catch (CacheException e) {
            _log.warn("Error while retrieving file attributes: " + e.getMessage());
            message.setFailed(e.getRc(), e);
        }
        catch (RuntimeException e) {
            _log.error("Error while retriving file attributes: " + e.getMessage(), (Throwable)e);
            message.setFailed(10011, e);
        }
    }

    public void setFileAttributes(PnfsSetFileAttributes message) {
        try {
            FileAttributes attr = message.getFileAttributes();
            PnfsId pnfsId = this.populatePnfsId(message);
            this.checkMask(message);
            if (attr.getDefinedAttributes().contains((Object)FileAttribute.LOCATIONS)) {
                for (String pool : attr.getLocations()) {
                    PnfsAddCacheLocationMessage msg = new PnfsAddCacheLocationMessage(pnfsId, pool);
                    this.forwardModifyCacheLocationMessage(msg);
                }
            }
            this._nameSpaceProvider.setFileAttributes(message.getSubject(), pnfsId, attr);
            message.setSucceeded();
        }
        catch (FileNotFoundCacheException e) {
            message.setFailed(e.getRc(), e);
        }
        catch (CacheException e) {
            _log.warn("Error while updating file attributes: " + e.getMessage());
            message.setFailed(e.getRc(), e);
        }
        catch (RuntimeException e) {
            _log.error("Error while updating file attributes: " + e.getMessage(), (Throwable)e);
            message.setFailed(10011, e);
        }
    }

    private PnfsId populatePnfsId(PnfsMessage message) throws CacheException {
        PnfsId pnfsId = message.getPnfsId();
        if (pnfsId == null) {
            String path = message.getPnfsPath();
            if (path == null) {
                throw new InvalidMessageCacheException("no pnfsid or path defined");
            }
            pnfsId = this.pathToPnfsid(message.getSubject(), path, true);
            message.setPnfsId(pnfsId);
        }
        return pnfsId;
    }

    private static long getAdjustedTtl(CellMessage message) {
        long ttl = message.getTtl();
        return ttl == Long.MAX_VALUE ? Long.MAX_VALUE : ttl - Math.min(10000L, (long)((float)ttl * 0.1f));
    }

    private void checkMask(PnfsMessage message) throws CacheException {
        this.checkMask(message.getSubject(), message.getPnfsId(), message.getAccessMask());
    }

    private void checkMask(Subject subject, PnfsId pnfsId, Set<AccessMask> mask) throws CacheException {
        Set<FileAttribute> required;
        FileAttributes attributes;
        if (!(Subjects.isRoot((Subject)subject) || mask.isEmpty() || this.checkMask(subject, mask, attributes = this._nameSpaceProvider.getFileAttributes(subject, pnfsId, required = this._permissionHandler.getRequiredAttributes())))) {
            throw new PermissionDeniedCacheException("Access denied");
        }
    }

    private void checkMask(Subject subject, String path, Set<AccessMask> mask) throws CacheException {
        if (!Subjects.isRoot((Subject)subject) && !mask.isEmpty()) {
            Set<FileAttribute> required = this._permissionHandler.getRequiredAttributes();
            PnfsId pnfsId = this.pathToPnfsid(Subjects.ROOT, path, false);
            FileAttributes attributes = this._nameSpaceProvider.getFileAttributes(subject, pnfsId, required);
            if (!this.checkMask(subject, mask, attributes)) {
                throw new PermissionDeniedCacheException("Access denied");
            }
        }
    }

    private boolean checkMask(Subject subject, Set<AccessMask> mask, FileAttributes attr) {
        AccessType access = AccessType.ACCESS_ALLOWED;
        for (AccessMask m : mask) {
            switch (m) {
                case READ_DATA: {
                    access = access.and(this._permissionHandler.canReadFile(subject, attr));
                    break;
                }
                case LIST_DIRECTORY: {
                    access = access.and(this._permissionHandler.canListDir(subject, attr));
                    break;
                }
                case WRITE_DATA: {
                    access = access.and(this._permissionHandler.canWriteFile(subject, attr));
                    break;
                }
                case ADD_FILE: {
                    access = access.and(this._permissionHandler.canCreateFile(subject, attr));
                    break;
                }
                case APPEND_DATA: {
                    access = access.and(this._permissionHandler.canWriteFile(subject, attr));
                    break;
                }
                case ADD_SUBDIRECTORY: {
                    access = access.and(this._permissionHandler.canCreateSubDir(subject, attr));
                    break;
                }
                case EXECUTE: {
                    access = access.and(this._permissionHandler.canLookup(subject, attr));
                    break;
                }
                case READ_ATTRIBUTES: 
                case WRITE_ATTRIBUTES: 
                case READ_ACL: 
                case WRITE_ACL: 
                case WRITE_OWNER: 
                case READ_NAMED_ATTRS: 
                case WRITE_NAMED_ATTRS: 
                case DELETE: 
                case DELETE_CHILD: 
                case SYNCHRONIZE: {
                    access = access.and(AccessType.ACCESS_UNDEFINED);
                }
            }
            if (access != AccessType.ACCESS_DENIED) continue;
            return false;
        }
        return access == AccessType.ACCESS_ALLOWED;
    }

    private class ProcessThread
    implements Runnable {
        private final BlockingQueue<CellMessage> _fifo;

        private ProcessThread(BlockingQueue<CellMessage> fifo) {
            this._fifo = fifo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            _log.info("Thread <" + Thread.currentThread().getName() + "> started");
            boolean done = false;
            while (!done) {
                CellMessage message;
                try {
                    message = this._fifo.take();
                }
                catch (InterruptedException e) {
                    done = true;
                    continue;
                }
                CDC.setMessageContext((CellMessage)message);
                try {
                    PnfsMessage pnfs = (PnfsMessage)message.getMessageObject();
                    if (message.getLocalAge() > PnfsManagerV3.getAdjustedTtl(message) && PnfsManagerV3.this.useEarlyDiscard(pnfs)) {
                        _log.warn("Discarding " + pnfs.getClass().getSimpleName() + " because its time to live has been exceeded.");
                        PnfsManagerV3.this.sendTimeout(message, "TTL exceeded");
                        continue;
                    }
                    PnfsManagerV3.this.processPnfsMessage(message, pnfs);
                    this.fold(pnfs);
                }
                catch (Throwable processException) {
                    _log.warn("processPnfsMessage : " + Thread.currentThread().getName() + " : " + processException);
                }
                finally {
                    CDC.clearMessageContext();
                }
            }
            _log.info("Thread <" + Thread.currentThread().getName() + "> finished");
        }

        protected void fold(PnfsMessage message) {
            if (PnfsManagerV3.this._canFold && message.getReturnCode() == 0) {
                CellMessage envelope;
                PnfsMessage other;
                Iterator i = this._fifo.iterator();
                while (i.hasNext() && !(other = (PnfsMessage)(envelope = (CellMessage)i.next()).getMessageObject()).invalidates(message)) {
                    if (!other.fold(message)) continue;
                    _log.info("Folded {}", (Object)other.getClass().getSimpleName());
                    PnfsManagerV3.this._foldedCounters.incrementRequests(message.getClass());
                    i.remove();
                    envelope.revertDirection();
                    try {
                        PnfsManagerV3.this.sendMessage(envelope);
                    }
                    catch (NoRouteToCellException e) {
                        _log.warn("Failed to send reply: " + e.getMessage());
                    }
                }
            }
        }
    }

    private class ListHandlerImpl
    implements ListHandler {
        private final CellPath _requestor;
        private final PnfsListDirectoryMessage _msg;
        private final long _delay;
        private final UOID _uoid;
        private long _deadline;

        public ListHandlerImpl(CellPath requestor, UOID uoid, PnfsListDirectoryMessage msg, long initialDelay, long delay) {
            this._msg = msg;
            this._requestor = requestor;
            this._uoid = uoid;
            this._delay = delay;
            this._deadline = delay == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + initialDelay;
        }

        private void sendPartialReply() {
            this._msg.setFinal(false);
            this._msg.setReply();
            try {
                CellMessage envelope = new CellMessage(this._requestor, (Serializable)this._msg);
                envelope.setLastUOID(this._uoid);
                PnfsManagerV3.this.sendMessage(envelope);
            }
            catch (NoRouteToCellException e) {
                _log.warn("Failed to send reply to " + this._requestor + ": " + e.getMessage());
            }
            this._msg.clear();
        }

        @Override
        public void addEntry(String name, FileAttributes attrs) {
            long now = System.currentTimeMillis();
            this._msg.addEntry(name, attrs);
            if (this._msg.getEntries().size() >= PnfsManagerV3.this._directoryListLimit || now > this._deadline) {
                this.sendPartialReply();
                this._deadline = this._delay == Long.MAX_VALUE ? Long.MAX_VALUE : now + this._delay;
            }
        }
    }
}

