/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.namespace;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsMessage;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.SyncFifo2;
import dmg.util.Args;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PnfsManagerBroker
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(PnfsManagerBroker.class);
    private String _cellName;
    private Args _args;
    private CellNucleus _nucleus;
    private SyncFifo2 _fifo = new SyncFifo2();
    private final Map<String, WorkerInstance> _pnfsManagers = new HashMap<String, WorkerInstance>();

    public PnfsManagerBroker(String cellName, String args) {
        super(cellName, PnfsManagerBroker.class.getName(), args, false);
        this._cellName = cellName;
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        this._pnfsManagers.put("default", new WorkerInstance("default"));
        this._nucleus.newThread((Runnable)new MessageWizard(this._fifo, this), "MessageWizard").start();
        this.useInterpreter(true);
        this.getNucleus().export();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_map_$_1(Args args) {
        String newItem = args.argv(0);
        Map<String, WorkerInstance> map = this._pnfsManagers;
        synchronized (map) {
            this._pnfsManagers.put(newItem, new WorkerInstance(newItem));
        }
        return "Ok";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_dump_$_0(Args args) {
        StringBuilder sb = new StringBuilder();
        Map<String, WorkerInstance> map = this._pnfsManagers;
        synchronized (map) {
            for (String element : this._pnfsManagers.keySet()) {
                sb.append(element).append("\n");
            }
        }
        return sb.toString();
    }

    public void messageArrived(CellMessage message) {
        Serializable pnfsMessage = message.getMessageObject();
        if (!(pnfsMessage instanceof Message)) {
            _log.info("Unexpected message class " + pnfsMessage.getClass());
            _log.info("source = " + message.getSourcePath());
            return;
        }
        if (pnfsMessage == null) {
            _log.info("Null message,  source = " + message.getSourcePath());
            return;
        }
        if (pnfsMessage instanceof PnfsMessage) {
            this._fifo.push((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("$Id: PnfsManagerBroker.java,v 1.7 2006-01-16 15:04:28 tigran Exp $").append("\n\n");
        Map<String, WorkerInstance> map = this._pnfsManagers;
        synchronized (map) {
            for (WorkerInstance worker : this._pnfsManagers.values()) {
                sb.append(worker.getName()).append(" : ").append(worker.getActions()).append("\n");
            }
        }
        return sb.toString();
    }

    private class WorkerInstance {
        String _name;
        long _actions;

        WorkerInstance(String name) {
            this._name = name;
        }

        long getActions() {
            return this._actions;
        }

        String getName() {
            return this._name;
        }

        void newAction() {
            ++this._actions;
        }
    }

    private class MessageBroker
    extends Thread {
        private CellPath _destination;
        private CellMessage _message;
        private CellNucleus _nucleus;
        private String _domain;
        private long _timeout = 600000L;

        MessageBroker(CellNucleus nucleus, CellMessage msg, CellPath dest, String domain) {
            this._message = msg;
            this._destination = dest;
            this._nucleus = nucleus;
            this._domain = domain;
        }

        @Override
        public void run() {
            try {
                CellMessage msg = new CellMessage(this._destination, this._message.getMessageObject());
                _log.info("forvarding message to cell " + this._destination.getCellName());
                if (!((PnfsMessage)this._message.getMessageObject()).getReplyRequired()) {
                    this._nucleus.sendMessage(msg);
                } else {
                    PnfsId pnfsId;
                    CellMessage reply = this._nucleus.sendAndWait(msg, this._timeout);
                    _log.info("reply to: " + this._message.getSourcePath() + " mgs=" + reply);
                    Serializable messageObject = reply.getMessageObject();
                    if (!this._domain.equals("default") && messageObject instanceof PnfsMessage && (pnfsId = ((PnfsMessage)messageObject).getPnfsId()) != null) {
                        ((PnfsMessage)messageObject).setPnfsId(new PnfsId(pnfsId.getId(), this._domain));
                    }
                    this._message.setMessageObject(reply.getMessageObject());
                    this._message.revertDirection();
                    this._nucleus.sendMessage(this._message);
                }
            }
            catch (NoRouteToCellException | InterruptedException nr) {
            }
            catch (Exception e) {
                _log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class MessageWizard
    implements Runnable {
        private SyncFifo2 _fifo;
        private CellAdapter _cell;
        private boolean _isStopped;

        MessageWizard(SyncFifo2 fifo, CellAdapter cell) {
            this._fifo = fifo;
            this._cell = cell;
        }

        @Override
        public void run() {
            while (!this._isStopped) {
                try {
                    CellMessage pnfsMessage = (CellMessage)this._fifo.pop();
                    this.forward(pnfsMessage);
                }
                catch (Exception e) {
                    _log.warn(e.getMessage(), (Throwable)e);
                    this._isStopped = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forward(CellMessage pnfsMessage) {
            PnfsMessage pnfsMessageObject = (PnfsMessage)pnfsMessage.getMessageObject();
            PnfsId pnfsId = pnfsMessageObject.getPnfsId();
            String pnfsInstance = null;
            if (pnfsId != null) {
                pnfsInstance = pnfsId.getDomain();
                pnfsMessageObject.setPnfsId(pnfsId);
            } else {
                String path = pnfsMessageObject.getPnfsPath();
                if (path != null) {
                    StringTokenizer st = new StringTokenizer(path, "[/]");
                    st.nextToken();
                    pnfsInstance = st.nextToken();
                }
            }
            if (pnfsInstance == null) {
                pnfsInstance = "default";
            }
            Map map = PnfsManagerBroker.this._pnfsManagers;
            synchronized (map) {
                WorkerInstance pManager = (WorkerInstance)PnfsManagerBroker.this._pnfsManagers.get(pnfsInstance);
                new MessageBroker(this._cell.getNucleus(), pnfsMessage, new CellPath(PnfsManagerBroker.this._cellName + "-" + pManager.getName()), pnfsInstance).start();
                pManager.newAction();
            }
        }
    }
}

