/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.hsmControl.flush.driver;

import diskCacheV111.hsmControl.flush.HsmFlushControlCore;
import diskCacheV111.hsmControl.flush.HsmFlushSchedulable;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.pools.StorageClassFlushInfo;
import dmg.cells.nucleus.CellAdapter;
import dmg.util.Args;
import dmg.util.CommandInterpreter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternateFlush
implements HsmFlushSchedulable {
    private static final Logger _log = LoggerFactory.getLogger(AlternateFlush.class);
    private HsmFlushControlCore _core;
    private CommandInterpreter _interpreter;
    private String _mode = "auto";
    private double _percentageToFlush = 0.5;
    private int _countToFlush = 5;
    private int _flushAtOnce;
    private EngineStack _engineStack = new EngineStack();
    private int _status;
    private static final int QUERY_ALL_POOLS_IO_MODE = 1;
    public static final String hh_dummy = "# dummy call";
    private boolean _ntf = true;
    private boolean _evt = true;

    public AlternateFlush(CellAdapter cell, HsmFlushControlCore core) {
        _log.info("AlternateFlush started");
        this._core = core;
        this._interpreter = new CommandInterpreter((Object)this);
    }

    @Override
    public void init() {
        int i;
        if (this._evt) {
            _log.info("EVENT : Initiating ...");
        }
        Args args = this._core.getDriverArgs();
        for (i = 0; i < args.argc(); ++i) {
            _log.info("    args " + i + " : " + args.argv(i));
        }
        for (i = 0; i < args.optc(); ++i) {
            _log.info("    opts " + args.optv(i) + "=" + args.getOpt(args.optv(i)));
        }
        for (HsmFlushControlCore.Pool pool : this._core.getConfiguredPools()) {
            _log.info("    configured pool : " + pool.toString());
        }
        Iterator<HsmFlushControlCore.Pool> i$ = this._core.getConfiguredPools().iterator();
        while (i$.hasNext()) {
            HsmFlushControlCore.Pool o;
            HsmFlushControlCore.Pool pool = o = i$.next();
            pool.setDriverHandle(new Pool(pool.getName(), pool));
            pool.setReadOnly(false);
            _log.info("init : setting readonly=false : " + pool.getName());
        }
    }

    @Override
    public void propertiesUpdated(Map<String, Object> properties) {
        if (this._evt) {
            _log.info("EVENT : propertiesUpdated : " + properties);
        }
        HashSet<String> keys = new HashSet<String>(properties.keySet());
        Iterator i$ = keys.iterator();
        block18: while (i$.hasNext()) {
            String key;
            switch (key = (String)i$.next()) {
                case "mode": {
                    Object obj = properties.get(key);
                    if (obj == null) continue block18;
                    String mode = obj.toString();
                    if (mode.equals("auto")) {
                        this._mode = "auto";
                        break;
                    }
                    if (!mode.equals("manual")) continue block18;
                    this._mode = "manual";
                    break;
                }
                case "flush.count": {
                    Object obj = properties.get(key);
                    if (obj == null) continue block18;
                    try {
                        int count = Integer.parseInt(obj.toString());
                        if (count < 1) {
                            throw new IllegalArgumentException("Value for " + key + " not supported " + obj);
                        }
                        this._countToFlush = count;
                    }
                    catch (Exception ee) {
                        _log.warn("Exception while seting " + key + " " + ee);
                    }
                    break;
                }
                case "flush.atonce": {
                    Object obj = properties.get(key);
                    if (obj == null) continue block18;
                    try {
                        int count = Integer.parseInt(obj.toString());
                        if (count < 1) {
                            throw new IllegalArgumentException("Value for " + key + " not supported " + obj);
                        }
                        this._flushAtOnce = count;
                    }
                    catch (Exception ee) {
                        _log.warn("Exception while seting " + key + " " + ee);
                    }
                    break;
                }
                case "flush.percentage": {
                    Object obj = properties.get(key);
                    if (obj == null) continue block18;
                    try {
                        double percent = Double.parseDouble(obj.toString());
                        if (percent < 0.0) {
                            throw new IllegalArgumentException("Value for " + key + " not supported " + obj);
                        }
                        this._percentageToFlush = percent;
                    }
                    catch (Exception ee) {
                        _log.warn("Exception while seting " + key + " " + ee);
                    }
                    break;
                }
                default: {
                    properties.remove(key);
                }
            }
        }
        properties.put("mode", this._mode);
        properties.put("flush.count", "" + this._countToFlush);
        properties.put("flush.percentage", "" + this._percentageToFlush);
        properties.put("flush.atonce", "" + this._flushAtOnce);
    }

    @Override
    public void poolIoModeUpdated(String poolName, HsmFlushControlCore.Pool pool) {
        if (this._evt) {
            _log.info("EVENT : poolIoModeUpdated : " + pool);
        }
        Pool ip = this.getInternalPool(pool);
        ip.modeReady = true;
        ip.update();
    }

    @Override
    public void flushingDone(String poolName, String storageClassName, HsmFlushControlCore.FlushInfo flushInfo) {
        HsmFlushControlCore.Pool pool;
        if (this._evt) {
            _log.info("EVENT : flushingDone : pool =" + poolName + ";class=" + storageClassName);
        }
        if ((pool = this._core.getPoolByName(poolName)) == null) {
            _log.warn("flushingDone for a non configured pool : " + poolName);
            return;
        }
        Pool ip = this.getInternalPool(pool);
        ip.update();
        ip.flushCounter--;
        if (ip.flushCounter <= 0) {
            ip.flushCounter = 0;
            _log.info("flushingDone : pool finished all flushing : " + poolName + " ; setting back to readWrite mode");
            pool.setReadOnly(false);
        }
    }

    @Override
    public void reset() {
        if (this._evt) {
            _log.info("EVENT : reset");
        }
    }

    @Override
    public void timer() {
        String poolName;
        if (this._evt) {
            _log.info("EVENT : timer");
        }
        HashSet<String> set = new HashSet<String>();
        HsmFlushControlCore.Pool pool = this.nextToFlush();
        while (pool != null && !set.contains(poolName = pool.getName())) {
            set.add(poolName);
            _log.info("timer : Good candidate to flush : " + poolName);
            Pool ip = this.getInternalPool(pool);
            if (ip.modeReady) {
                pool.setReadOnly(true);
                ip.flush();
            }
            pool = this.nextToFlush();
        }
    }

    @Override
    public void poolFlushInfoUpdated(String poolName, HsmFlushControlCore.Pool pool) {
        if (this._evt) {
            _log.info("EVENT : poolFlushInfoUpdated : " + pool.getName());
        }
        if (!pool.isActive()) {
            _log.info("poolFlushInfoUpdated : Pool : " + poolName + " inactive");
            return;
        }
        this.getInternalPool(pool).update();
    }

    @Override
    public void command(Args args) {
        if (this._evt) {
            _log.info("EVENT : command : " + args);
        }
        try {
            Serializable reply = this._interpreter.command(args);
            if (reply == null) {
                throw new Exception("Null pointer from command call");
            }
            _log.info("Command returns : " + reply.toString());
        }
        catch (Exception ee) {
            _log.warn("Command returns an exception (" + ee.getClass().getName() + ") : " + ee.toString());
        }
    }

    @Override
    public void prepareUnload() {
        if (this._evt) {
            _log.info("EVENT : Preparing unload (ignoring)");
        }
    }

    @Override
    public void configuredPoolAdded(String poolName) {
        HsmFlushControlCore.Pool pool;
        if (this._evt) {
            _log.info("EVENT : Configured pool added : " + poolName);
        }
        if ((pool = this._core.getPoolByName(poolName)) == null) {
            _log.warn("Pool not found in _core database : " + poolName);
            return;
        }
        Pool ip = this.getInternalPool(pool);
        pool.setReadOnly(false);
    }

    @Override
    public void poolSetupUpdated() {
        if (this._evt) {
            _log.info("EVENT : Pool Setup updated (ignoring)");
        }
    }

    @Override
    public void configuredPoolRemoved(String poolName) {
        if (this._evt) {
            _log.info("EVENT : Configured pool removed : " + poolName + "  (ignoring)");
        }
    }

    public String ac_dummy_$_1_99(Args args) {
        return args.toString();
    }

    public String ac_list_pools(Args args) {
        return null;
    }

    private Pool getInternalPool(HsmFlushControlCore.Pool pool) {
        Pool ip = (Pool)pool.getDriverHandle();
        if (ip == null) {
            _log.warn("getInternalPool : Unconfigured pool arrived " + pool.getName() + "; configuring");
            ip = new Pool(pool.getName(), pool);
            pool.setDriverHandle(ip);
        }
        return ip;
    }

    private int flushPool(HsmFlushControlCore.Pool pool) {
        int flushing = 0;
        for (HsmFlushControlCore.FlushInfoDetails o : pool.getFlushInfos()) {
            HsmFlushControlCore.FlushInfo info = (HsmFlushControlCore.FlushInfo)o;
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            long size = flush.getTotalPendingFileSize();
            _log.info("flushPool : class = " + info.getName() + " size = " + size + " flushing = " + info.isFlushing());
            try {
                if (size <= 0L || info.isFlushing()) continue;
                _log.info("flushPool : !!! flushing " + pool.getName() + " " + info.getName());
                info.flush(this._flushAtOnce);
                ++flushing;
            }
            catch (Exception ee) {
                _log.warn("flushPool : Problem flushing " + pool.getName() + " " + info.getName() + " " + ee);
            }
        }
        return flushing;
    }

    private int countTotalActivePool(HsmFlushControlCore.Pool pool) {
        int total = 0;
        for (HsmFlushControlCore.FlushInfoDetails o : pool.getFlushInfos()) {
            HsmFlushControlCore.FlushInfo info = (HsmFlushControlCore.FlushInfo)o;
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            total += flush.getActiveCount();
        }
        return total;
    }

    private int countTotalPendingPool(HsmFlushControlCore.Pool pool) {
        int total = 0;
        for (HsmFlushControlCore.FlushInfoDetails o : pool.getFlushInfos()) {
            HsmFlushControlCore.FlushInfo info = (HsmFlushControlCore.FlushInfo)o;
            StorageClassFlushInfo flush = info.getStorageClassFlushInfo();
            total += flush.getRequestCount();
        }
        return total;
    }

    private HsmFlushControlCore.Pool nextToFlush() {
        List<HsmFlushControlCore.Pool> pools = this._core.getConfiguredPools();
        ArrayList<Pool> list = new ArrayList<Pool>();
        for (HsmFlushControlCore.Pool pool : pools) {
            if (this._ntf) {
                _log.info("nextToFlush : checking pool " + pool);
            }
            if (!pool.isActive()) continue;
            Pool ip = (Pool)pool.getDriverHandle();
            if (ip.isFlushing()) {
                if (!this._ntf) continue;
                _log.info("nextToFlush : is already flushing " + pool.getName());
                continue;
            }
            list.add(ip);
        }
        if (list.size() < 2) {
            if (this._ntf) {
                _log.info("nextToFlush : currently not enough pools to write on (" + list.size() + ")");
            }
            return null;
        }
        if (this._ntf) {
            _log.info("nextToFlush : possible candidates : " + list);
        }
        Pool poolWithHighestCounter = null;
        Pool poolWithHighestPercentage = null;
        int highestCounter = -1;
        double highestPercentage = -1.0;
        for (Pool ip : list) {
            double percentage;
            if (ip.preciousFileCount > highestCounter) {
                poolWithHighestCounter = ip;
                highestCounter = ip.preciousFileCount;
            }
            if (!((percentage = (double)ip.preciousSpace / (double)ip.totalSpace) > highestPercentage)) continue;
            poolWithHighestPercentage = ip;
            highestPercentage = percentage;
        }
        if (this._ntf) {
            _log.info("nextToFlush : highest percentage found for : " + poolWithHighestPercentage.pool.getName() + " (" + highestPercentage + ")");
        }
        if (this._ntf) {
            _log.info("nextToFlush : highest counter    found for : " + poolWithHighestCounter.pool.getName() + " (" + highestCounter + ")");
        }
        if (highestPercentage > this._percentageToFlush) {
            return poolWithHighestPercentage.pool;
        }
        if (highestCounter > this._countToFlush) {
            return poolWithHighestCounter.pool;
        }
        return null;
    }

    private int countStorageClassesFlushing(HsmFlushControlCore.Pool pool) {
        int flushing = 0;
        for (HsmFlushControlCore.FlushInfoDetails o : pool.getFlushInfos()) {
            if (!((HsmFlushControlCore.FlushInfo)o).isFlushing()) continue;
            ++flushing;
        }
        return flushing;
    }

    private class EngineStack {
        private Stack<StackEntry> _stack = new Stack();

        private EngineStack() {
        }

        public void push(StackEntry entry) {
            this._stack.push(entry);
        }

        public StackEntry pop() {
            return this._stack.pop();
        }

        public boolean isEmpty() {
            return this._stack.empty();
        }

        public int getCurrentState() {
            return this._stack.empty() ? -1 : this._stack.peek().state;
        }
    }

    private class StackEntry {
        private long waitingSince = System.currentTimeMillis();
        private int state;

        private StackEntry(int state) {
            this.state = state;
        }
    }

    private class Pool
    implements HsmFlushControlCore.DriverHandle {
        private String name;
        private int flushCounter;
        private boolean modeReady;
        private long totalSpace;
        private long preciousSpace;
        private int preciousFileCount;
        private HsmFlushControlCore.Pool pool;

        private Pool(String name, HsmFlushControlCore.Pool pool) {
            this.name = name;
            this.pool = pool;
            this.update();
        }

        public void update() {
            PoolCellInfo cellInfo = this.pool.getCellInfo();
            if (cellInfo == null) {
                return;
            }
            PoolCostInfo costInfo = cellInfo.getPoolCostInfo();
            PoolCostInfo.PoolSpaceInfo spaceInfo = costInfo.getSpaceInfo();
            this.totalSpace = spaceInfo.getTotalSpace();
            this.preciousSpace = spaceInfo.getPreciousSpace();
            this.preciousFileCount = this.countTotalPending();
        }

        private void flush() {
            this.flushCounter += AlternateFlush.this.flushPool(this.pool);
        }

        private boolean isFlushing() {
            return this.flushCounter > 0;
        }

        private int countTotalPending() {
            return AlternateFlush.this.countTotalPendingPool(this.pool);
        }

        public String toString() {
            return this.name;
        }
    }
}

