/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.hsmControl.flush;

import diskCacheV111.hsmControl.flush.FlushControlCellInfo;
import diskCacheV111.hsmControl.flush.HsmFlushControlCore;
import diskCacheV111.hsmControl.flush.HttpFlushManagerHelper;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.pools.StorageClassFlushInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.util.HttpException;
import dmg.util.HttpRequest;
import dmg.util.HttpResponseEngine;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHsmFlushMgrEngineV1
implements HttpResponseEngine {
    private static final Logger _log = LoggerFactory.getLogger(HttpHsmFlushMgrEngineV1.class);
    private CellEndpoint _endpoint;
    private long _errorCounter;
    private long _requestCounter;
    private Object _updateLock = new Object();
    private String _flushManagerName = "FlushManager";
    private String _cssFile = "/flushManager/css/default.css";
    private List<String> _managerList = new ArrayList<String>();
    private SimpleDateFormat _formatter = new SimpleDateFormat("MM.dd HH:mm:ss");
    private HttpFlushManagerHelper.PoolEntryComparator _poolCompare;
    private HttpFlushManagerHelper.FlushEntryComparator _flushCompare;
    private String[] _poolTableTitle = new String[]{"Action", "PoolName", "Pool Mode", "Flushing", "Total Size", "Precious Size", "Fraction"};
    private String[] _flushTableTitle = new String[]{"Action", "PoolName", "StorageClass", "Status", "Total Size", "Precious Size", "Fraction", "Active", "Pending", "Failed"};

    public HttpHsmFlushMgrEngineV1(CellEndpoint endpoint, String[] argsString) {
        this._endpoint = endpoint;
        for (int i = 0; i < argsString.length; ++i) {
            _log.info("HttpPoolMgrEngineV3 : argument : " + i + " : " + argsString[i]);
            if (argsString[i].startsWith("css=")) {
                this.decodeCss(argsString[i].substring(4));
                continue;
            }
            if (!argsString[i].startsWith("mgr=")) continue;
            this.decodeManager(argsString[i].substring(4));
        }
        this._poolCompare = new HttpFlushManagerHelper.PoolEntryComparator();
        this._poolCompare.setColumn(0);
        this._flushCompare = new HttpFlushManagerHelper.FlushEntryComparator();
        this._flushCompare.setColumn(1);
        if (this._managerList.size() == 0) {
            this._managerList.add("FlushManager");
        }
        _log.info("Using Manager  : " + this._managerList);
        _log.info("Using CSS file : " + this._cssFile);
    }

    private void decodeManager(String managers) {
        managers = managers.trim();
        StringTokenizer st = new StringTokenizer(managers, ",");
        while (st.hasMoreTokens()) {
            this._managerList.add(st.nextToken());
        }
    }

    private void decodeCss(String cssDetails) {
        if ((cssDetails = cssDetails.trim()).length() > 0 && !cssDetails.equals("default")) {
            this._cssFile = cssDetails;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryUrl(HttpRequest request) throws HttpException {
        PrintWriter pw = request.getPrintWriter();
        String[] urlItems = request.getRequestTokens();
        request.printHttpHeader(0);
        ++this._requestCounter;
        try {
            if (urlItems.length < 1) {
                return;
            }
            if (urlItems.length > 1 && urlItems[1].equals("css")) {
                if (urlItems.length > 2) {
                    this.printCssFile(pw, urlItems[2]);
                }
            } else if (urlItems.length > 1 && urlItems[1].equals("mgr")) {
                String flushManagerName = "FlushManager";
                Map<Object, Object> optionsMap = new HashMap();
                if (urlItems.length > 2) {
                    flushManagerName = urlItems[2];
                }
                if (urlItems.length > 3) {
                    optionsMap = this.createMap(urlItems[3]);
                }
                _log.info("MAP -> " + optionsMap);
                this.printFlushHeader(pw, "Flush Info");
                this.printDirectory(pw);
                if (!flushManagerName.equals("*")) {
                    StringBuffer result = new StringBuffer();
                    this.doActionsIfNecessary(flushManagerName, optionsMap, result);
                    String errorString = result.toString();
                    if (errorString.length() > 0) {
                        pw.println("<hr>");
                        pw.println("<h2>The following errors were reported</h2>");
                        pw.println("<pre>");
                        pw.println(errorString);
                        pw.println("</pre>");
                        pw.println("<hr>");
                    }
                    try {
                        this.printUpdateThis(pw, flushManagerName);
                        this.printCellInfo(pw, flushManagerName);
                        this.printFlushManagerList(pw, flushManagerName, optionsMap);
                    }
                    catch (Exception ee) {
                        pw.println("<center><h2>Flush Manager " + flushManagerName + " seems not to be present</h2>");
                    }
                }
            }
        }
        catch (Exception ee) {
            ++this._errorCounter;
            this.showProblem(pw, ee.getMessage());
            pw.println("<ul>");
            for (int i = 0; i < urlItems.length; ++i) {
                pw.println("<li> [" + i + "] ");
                pw.println(urlItems[i]);
            }
            pw.println("</ul>");
        }
        finally {
            pw.println("<address>Last Modified : " + new Date() + " $Id: HttpHsmFlushMgrEngineV1.java,v 1.3 2006-05-20 10:40:02 patrick Exp $</address>");
            pw.println("</body>");
            pw.println("</html>");
        }
    }

    public void startup() {
    }

    public void shutdown() {
    }

    private void printUpdateThis(PrintWriter pw, String thisManager) {
        pw.println("<center><a class=\"big-link\" href=\"");
        pw.println(thisManager);
        pw.println("\"><span class=\"big-link\">");
        pw.println("Update this Flush Manager (" + thisManager + ")");
        pw.println("</span></a></center><hr>");
    }

    private Map<String, Object> createMap(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int pos = message.indexOf(63);
        if (pos < 0 || pos == message.length() - 1) {
            map.put("$MAIN$", message);
            return map;
        }
        map.put("$MAIN$", message.substring(pos));
        StringTokenizer st = new StringTokenizer(message.substring(pos + 1), "&");
        while (st.hasMoreTokens()) {
            StringTokenizer ss = new StringTokenizer(st.nextToken(), "=");
            try {
                String key = ss.nextToken();
                String value = ss.hasMoreTokens() ? ss.nextToken() : "true";
                Object o = map.get(key);
                if (o == null) {
                    map.put(key, value);
                    continue;
                }
                if (o instanceof List) {
                    ((List)o).add(value);
                    continue;
                }
                if (!(o instanceof String)) continue;
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(o);
                l.add(value);
                map.put(key, l);
            }
            catch (NoSuchElementException nsee) {}
        }
        return map;
    }

    private void printCellInfo(PrintWriter pw, String flushManagerName) throws Exception {
        CellMessage reply = this._endpoint.sendAndWait(new CellMessage(new CellPath(flushManagerName), (Serializable)((Object)"xgetcellinfo")), 20000L);
        if (reply == null) {
            this.showTimeout(pw);
            return;
        }
        Serializable o = reply.getMessageObject();
        if (o instanceof Exception) {
            this.showProblem(pw, flushManagerName + " seems not to be present");
        } else if (o instanceof String) {
            this.showProblem(pw, o.toString());
        } else if (o instanceof FlushControlCellInfo) {
            this.prepareCellInfo(pw, flushManagerName, (FlushControlCellInfo)o);
        } else {
            this.showProblem(pw, "Something really weird arrived : " + o.getClass().getName());
        }
    }

    private void prepareCellInfo(PrintWriter pw, String flushManagerName, FlushControlCellInfo info) {
        pw.println("<h2 class=\"s-table\">Manager : " + flushManagerName + "</h2>");
        pw.println("<center><table class=\"s-table\">");
        pw.println("<tr class=\"s-table\">");
        pw.println("<th class=\"s-table\">Cell Name</th>");
        pw.println("<th class=\"s-table\">Driver Class</th>");
        pw.println("<th class=\"s-table\">Control Type</th>");
        pw.println("</tr><tr class=\"s-table-b\">");
        pw.println("<td class=\"s-table\"><span class=\"s-table\">");
        pw.println(info.getCellName() + "@" + info.getDomainName());
        pw.println("</span></td>");
        pw.println("<td class=\"s-table\"><span class=\"s-table\">");
        pw.println(info.getDriverName());
        pw.println("</span></td>");
        pw.println("<td class=\"s-table\"><span class=\"s-table\">");
        pw.println(info.getIsControlled() ? "Centrally Controlled" : "Locally Controlled");
        pw.println("</span></td>");
        pw.println("</tr></table><br>");
        pw.println("<form action=\"submitonoff\" method=\"get\">");
        pw.println("<input type=\"submit\" value=\"Control Locally\" name=\"command\">");
        pw.println("<input type=\"submit\" value=\"Control Centrally\" name=\"command\">");
        pw.println("</form>");
        pw.println("</center>");
        pw.println("<hr>");
    }

    private void printFlushManagerList(PrintWriter pw, String flushManagerName, Map<?, ?> options) throws Exception {
        CellMessage reply = this._endpoint.sendAndWait(new CellMessage(new CellPath(flushManagerName), (Serializable)((Object)"ls pool -l -binary")), 20000L);
        if (reply == null) {
            this.showTimeout(pw);
            return;
        }
        Serializable o = reply.getMessageObject();
        if (o instanceof Exception) {
            this.showProblem(pw, flushManagerName + " seems not to be present");
        } else if (o instanceof String) {
            this.showProblem(pw, o.toString());
        } else if (o instanceof List) {
            this.preparePoolList(pw, flushManagerName, options, (List)((Object)o));
        } else {
            this.showProblem(pw, "Something really weird arrived : " + o.getClass().getName());
        }
    }

    private void doActionsIfNecessary(String flushManagerName, Map options, StringBuffer output) {
        block15: {
            List list;
            String command;
            block16: {
                List list2;
                block14: {
                    if (options == null || options.size() == 1) {
                        return;
                    }
                    command = (String)options.get("command");
                    if (command == null) {
                        return;
                    }
                    if (!command.startsWith("Control")) break block14;
                    boolean central = command.contains("Centrally");
                    CellPath path = new CellPath(flushManagerName);
                    String remote = "set control " + (central ? "on" : "off");
                    this.sendCommand(path, remote, output);
                    break block15;
                }
                if (!command.equals("Flush")) break block16;
                Object o = options.get("storageclass");
                if (o == null) {
                    return;
                }
                if (o instanceof String) {
                    list2 = new ArrayList();
                    list2.add(o);
                } else if (o instanceof List) {
                    list2 = (List)o;
                } else {
                    return;
                }
                CellPath path = new CellPath(flushManagerName);
                for (Object element : list2) {
                    StringTokenizer st = new StringTokenizer(element.toString(), "$");
                    String poolName = st.nextToken();
                    String storageClass = st.nextToken();
                    String remote = "flush pool " + poolName + " " + storageClass;
                    this.sendCommand(path, remote, output);
                }
                break block15;
            }
            if (!command.startsWith("Set") && !command.startsWith("Query")) break block15;
            boolean rdOnly = command.contains("Only");
            boolean query = command.contains("Query");
            Object o = options.get("pools");
            if (o == null) {
                return;
            }
            if (o instanceof String) {
                list = new ArrayList();
                list.add(o);
            } else if (o instanceof List) {
                list = (List)o;
            } else {
                return;
            }
            CellPath path = new CellPath(flushManagerName);
            for (Object element : list) {
                String poolName = element.toString();
                String remote = query ? "query pool mode " + poolName : "set pool " + poolName + " " + (rdOnly ? "rdonly" : "rw");
                this.sendCommand(path, remote, output);
            }
        }
    }

    private void sendCommand(CellPath path, String command, StringBuffer output) {
        try {
            CellMessage result = this._endpoint.sendAndWait(new CellMessage(path, (Serializable)((Object)command)), 20000L);
            if (result == null) {
                output.append("Command timed out : ").append(command).append("\n");
                return;
            }
            Serializable oo = result.getMessageObject();
            if (oo instanceof Exception) {
                throw (Exception)oo;
            }
        }
        catch (Exception ee) {
            output.append("Exception in command : ").append(command).append("\n");
            output.append("     ").append(ee.getClass().getName()).append(" -> ").append(ee.getMessage()).append("\n");
            _log.warn(ee.toString());
        }
    }

    private void preparePoolList(PrintWriter pw, String flushManagerName, Map<?, ?> options, List<HsmFlushControlCore.PoolDetails> list) {
        ArrayList<HttpFlushManagerHelper.PoolEntry> pools = new ArrayList<HttpFlushManagerHelper.PoolEntry>();
        ArrayList<HttpFlushManagerHelper.FlushEntry> flushs = new ArrayList<HttpFlushManagerHelper.FlushEntry>();
        for (HsmFlushControlCore.PoolDetails pool : list) {
            PoolCostInfo costInfo;
            String poolName = pool.getName();
            boolean isReadOnly = pool.isReadOnly();
            PoolCellInfo cellInfo = pool.getCellInfo();
            if (cellInfo == null || (costInfo = cellInfo.getPoolCostInfo()) == null) continue;
            PoolCostInfo.PoolSpaceInfo spaceInfo = costInfo.getSpaceInfo();
            PoolCostInfo.PoolQueueInfo queueInfo = costInfo.getStoreQueue();
            long totalSpace = spaceInfo.getTotalSpace();
            long preciousSpace = spaceInfo.getPreciousSpace();
            HttpFlushManagerHelper.PoolEntry pentry = new HttpFlushManagerHelper.PoolEntry();
            pentry._poolName = pool.getName();
            pentry._total = totalSpace;
            pentry._precious = preciousSpace;
            pentry._isReadOnly = isReadOnly;
            pentry._flushing = 0;
            pools.add(pentry);
            List<HsmFlushControlCore.FlushInfoDetails> flushes = pool.getFlushInfos();
            if (flushes == null || flushes.size() == 0) continue;
            Iterator<HsmFlushControlCore.FlushInfoDetails> i$ = flushes.iterator();
            while (i$.hasNext()) {
                HsmFlushControlCore.FlushInfoDetails flush1;
                HsmFlushControlCore.FlushInfoDetails flush = flush1 = i$.next();
                StorageClassFlushInfo info = flush.getStorageClassFlushInfo();
                HttpFlushManagerHelper.FlushEntry fentry = new HttpFlushManagerHelper.FlushEntry();
                fentry._poolName = pool.getName();
                fentry._storageClass = flush.getName();
                fentry._isFlushing = flush.isFlushing();
                fentry._total = totalSpace;
                fentry._precious = info.getTotalPendingFileSize();
                fentry._pending = info.getRequestCount();
                fentry._active = info.getActiveCount();
                fentry._failed = info.getFailedRequestCount();
                if (fentry._isFlushing) {
                    ++pentry._flushing;
                }
                flushs.add(fentry);
            }
        }
        Collections.sort(pools, this._poolCompare);
        Collections.sort(flushs, this._flushCompare);
        this.printFlushingPools(pw, flushManagerName, options, pools);
        this.printFlushingStorageClasses(pw, flushManagerName, options, flushs);
    }

    private void printFlushingPools(PrintWriter pw, String flushManagerName, Map<?, ?> options, List<HttpFlushManagerHelper.PoolEntry> pools) {
        pw.println("<form action=\"submitpools\" method=\"get\">");
        pw.println("<h2 class=\"s-table\">Flushing Pools</h2>");
        pw.println("<center><table class=\"s-table\">");
        pw.println("<tr class=\"s-table\">");
        for (String s : this._poolTableTitle) {
            pw.print("<th class=\"s-table\">");
            pw.print(s);
            pw.println("</th>");
        }
        pw.println("</tr>");
        int row = 0;
        for (HttpFlushManagerHelper.PoolEntry pentry : pools) {
            pw.print(row % 2 == 0 ? "<tr class=\"s-table-a\">" : "<tr class=\"s-table-b\">");
            pw.print("<td class=\"s-table\">");
            pw.print("<input type=\"checkbox\" name=\"pools\" value=\"");
            pw.print(pentry._poolName);
            pw.print("\">");
            pw.print("</input>");
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(pentry._poolName);
            pw.println("</td>");
            if (pentry._isReadOnly) {
                pw.print("<td class=\"s-table-e\">");
                pw.print("ReadOnly");
            } else {
                pw.print("<td class=\"s-table\">");
                pw.print("ReadWrite");
            }
            pw.println("</td>");
            pw.print(pentry._flushing > 0 ? "<td class=\"s-table-e\">" : "<td class=\"s-table\">");
            pw.print(pentry._flushing);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(pentry._total);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(pentry._precious);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print((float)((double)pentry._precious / (double)pentry._total / 100.0));
            pw.println("</td>");
            pw.println("</tr>");
            ++row;
        }
        pw.println("</table><br>");
        pw.println("<input type=\"submit\" value=\"Set Read Only\" name=\"command\">");
        pw.println("<input type=\"submit\" value=\"Set Read Write\" name=\"command\">");
        pw.println("<input type=\"submit\" value=\"Query\" name=\"command\">");
        pw.println("</center>");
        pw.println("</form>");
        pw.println("<hr>");
    }

    private void printFlushingStorageClasses(PrintWriter pw, String flushManagerName, Map<?, ?> options, List<HttpFlushManagerHelper.FlushEntry> pools) {
        pw.println("<form action=\"submitstorageclass\" method=\"get\">");
        pw.print("<h2 class=\"s-table\">Flushing Storage Classes</h2>");
        pw.print("<center><table class=\"s-table\">");
        pw.println("<tr class=\"s-table\">");
        for (String s : this._flushTableTitle) {
            pw.print("<th class=\"s-table\">");
            pw.print(s);
            pw.println("</th>");
        }
        pw.println("</tr>");
        int row = 0;
        for (HttpFlushManagerHelper.FlushEntry fentry : pools) {
            pw.print(fentry._isFlushing ? "<tr class=\"s-table-e\">" : (row % 2 == 0 ? "<tr class=\"s-table-a\">" : "<tr class=\"s-table-b\">"));
            pw.print("<td class=\"s-table\">");
            pw.print("<input type=\"checkbox\" name=\"storageclass\" value=\"");
            pw.print(fentry._poolName + "$" + fentry._storageClass);
            pw.print("\">");
            pw.print("</input>");
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(fentry._poolName);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(fentry._storageClass);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(fentry._isFlushing ? "Flushing" : "Idle");
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(fentry._total);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(fentry._precious);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print((float)((double)fentry._precious / (double)fentry._total / 100.0));
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(fentry._active);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(fentry._pending);
            pw.println("</td>");
            pw.print("<td class=\"s-table\">");
            pw.print(fentry._failed);
            pw.println("</td>");
            pw.println("</tr>");
            ++row;
        }
        pw.println("</table><br>");
        if (pools.size() > 0) {
            pw.println("<input type=\"submit\" value=\"Flush\" name=\"command\">");
        }
        pw.println("</center>");
        pw.println("</form>");
        pw.println("<hr>");
    }

    private void printFlushHeader(PrintWriter pw, String title) {
        pw.println("<html>");
        pw.println("<head><title>" + title + "</title>");
        pw.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this._cssFile + "\">");
        pw.println("</head>");
        pw.println("<body class=\"flush-body\">");
        pw.println("<table border=0 cellpadding=10 cellspacing=0 width=\"90%\">");
        pw.println("<tr><td align=center valign=center width=\"1%\">");
        pw.println("<a href=\"/\"><img border=0 src=\"/images/eagleredtrans.gif\"></a>");
        pw.println("<br><font color=red>Birds Home</font>");
        pw.println("</td><td align=center>");
        pw.println("<h1 class=\"m-title\">" + title + "</font></h1>");
        pw.println("</td></tr></table>");
    }

    private void printDirectory(PrintWriter pw) {
        this.printDirectory(pw, -1);
    }

    private void printDirectory(PrintWriter pw, int position) {
        pw.println("<br><center><h2 class=\"m-table\">Flush Managers</h2><table class=\"m-table\">");
        pw.println("<tr class=\"m-table\">");
        Iterator<String> i$ = this._managerList.iterator();
        while (i$.hasNext()) {
            String o;
            String managerName = o = i$.next();
            this.printDirEntry(pw, managerName, false, "/flushManager/mgr/" + managerName + "/*");
        }
        pw.println("</tr>");
        pw.println("</table></center>");
        pw.println("<br><hr>");
    }

    private void printDirEntry(PrintWriter pw, String text, boolean inUse, String link) {
        String alternateClass = inUse ? "class=\"m-table-active\"" : "class=\"m-table\"";
        pw.print("<td width=\"25%\" class=\"m-table\"><span ");
        pw.print(alternateClass);
        pw.print("><a ");
        pw.print(alternateClass);
        pw.print(" href=\"");
        pw.print(link);
        pw.print("\">");
        pw.print(text);
        pw.println("</a></span></td>");
    }

    private void printCssFile(PrintWriter pw, String filename) {
        if (!filename.equals("test.html") && filename.equals("default.css")) {
            this.printInternalCssFile(pw);
        }
    }

    private void printInternalCssFile(PrintWriter pw) {
        pw.println("body { background-color:orange ; }");
        pw.println("table.s-table { width:90% ; border:1px ; border-style:solid ; border-spacing:0px ; border-collapse:collapse ; }");
        pw.println("tr.s-table   { background-color:#115259 ; color:white; font-size:18 ; }");
        pw.println("tr.s-table-a { background-color:#bebebe ; text-align:center ; font-size:16 ; }");
        pw.println("tr.s-table-b { background-color:#efefef ; text-align:center ; font-size:16 ; }");
        pw.println("tr.s-table-e { background-color:red ; text-align:center ; font-size:16 ; }");
        pw.println("td.s-table {  border:1px  ; border-style:solid ; border-spacing:1px ; padding:3 ; }");
        pw.println("th.s-table {  border:1px  ; border-style:solid ; border-spacing:1px ;}");
        pw.println("td.s-table-disabled {  border:1px  ; border-style:solid ; border-spacing:0px ; padding:3 ;}");
        pw.println("td.s-table-e {  background-color:red ;}");
        pw.println("td.s-table-regular  {  border:1px  ; border-style:solid ; border-spacing:0px ; padding:3 ;}");
        pw.println("span.s-table-disabled { color:gray  ; }");
        pw.println("span.s-table-regular  { color:black  ; }");
        pw.println("a.s-table:visited  { text-decoration:none ; color:blue ; }");
        pw.println("a.s-table:link     { text-decoration:none ; color:blue ; }");
        pw.println("table.m-table { width:90% ; border:0px ; border-style:none ; border-spacing:0px ; border-collapse:collapse ; }");
        pw.println("td.m-table {  background-color:white ; text-align:center ; border:1px  ; border-style:solid ; border-spacing:1px ;}");
        pw.println("a.m-table:visited        { text-decoration:none ; }");
        pw.println("a.m-table-active:visited { text-decoration:none ; color:red ; }");
        pw.println("a.m-table:link        { text-decoration:none ; }");
        pw.println("a.m-table-active:link { text-decoration:none ; color:red ; }");
        pw.println("table.l-table { width:90% ; color:black ; table-layout:auto ;");
        pw.println("    border:1px ; border-style:none ; border-spacing:0px ; border-collapse:collapse ; }");
        pw.println("tr.l-table { background-color:green ; }");
        pw.println("td.l-table { background-color:white ; color:black ;");
        pw.println("width:10.5% ;");
        pw.println("padding:4 ; text-align:center ;");
        pw.println("border:1px ; border-style:solid ; border-spacing:0px ; border-collapse:collapse ; }");
        pw.println("span.l-table { font-size:16 ;}");
        pw.println("a.l-table:visited  { text-decoration:none ; color:blue ; }");
        pw.println("a.l-table:link     { text-decoration:none ; color:blue ; }");
        pw.println("table.f-table-a { width:90% ; color:black ; table-layout:auto ; background-color:white ;");
        pw.println("border:1px ; border-style:solid ; border-spacing:0px ; border-collapse:collapse ;}");
        pw.println("td.f-table-a { text-align:center ; padding:10 ; }");
        pw.println("span.f-table-a { text-align:center ; font-size:20px }");
        pw.println("table.f-table-b { width:100% ;  color:black ; table-layout:auto ; ");
        pw.println(" border:1px ; border-style:none ; border-spacing:0px ; border-collapse:collapse ; }");
        pw.println("th.f-table-b { width:20% ;}");
        pw.println("td.f-table-b { width:20% ; background-color:#eeeeee ; color:black ;");
        pw.println("padding:4 ; text-align:center ; border:1px ; border-style:solid ; border-spacing:0px ; }");
        pw.println("span.m-title { font-size:18 ; color=red ; }");
        pw.println("a.big-link:visited  { text-decoration:none ; color:red ; }");
        pw.println("a.big-link:link  { text-decoration:none ; color:red ; }");
        pw.println("span.big-link { font-size:24 ; text-align:center }");
    }

    private void showTimeout(PrintWriter pw) {
        pw.println("<font color=red><h1>Sorry, the request timed out</h1></font>");
    }

    private void showProblem(PrintWriter pw, String message) {
        pw.print("<font color=red><h1>");
        pw.print(message);
        pw.println("</h1></font>");
    }
}

