/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.hsmControl.flush;

import java.util.Comparator;

class HttpFlushManagerHelper {
    HttpFlushManagerHelper() {
    }

    static class FlushEntry {
        String _poolName;
        boolean _isFlushing;
        String _storageClass;
        long _total;
        long _precious;
        int _active;
        int _pending;
        int _failed;

        FlushEntry() {
        }
    }

    static class FlushEntryComparator
    extends EntryComparator<FlushEntry> {
        FlushEntryComparator() {
        }

        @Override
        public int compare(FlushEntry a, FlushEntry b) {
            FlushEntry[] info1 = new FlushEntry[]{a, b};
            FlushEntry[] info2 = new FlushEntry[]{b, a};
            FlushEntry[] info = this._topHigh ? info1 : info2;
            switch (this._sortColumn) {
                case 0: {
                    int t = info[0]._poolName.compareTo(info[1]._poolName);
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 1: {
                    int t = info[0]._storageClass.compareTo(info[1]._storageClass);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 2: {
                    int t = this.compareBoolean(info[0]._isFlushing, info[1]._isFlushing);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 3: {
                    int t = this.compareLong(info[0]._total, info[1]._total);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 4: {
                    int t = this.compareLong(info[0]._precious, info[1]._precious);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 5: {
                    int t = this.compareInt(info[0]._active, info[1]._active);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 6: {
                    int t = this.compareInt(info[0]._pending, info[1]._pending);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 7: {
                    int t = this.compareInt(info[0]._failed, info[1]._failed);
                    t = t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                    return t == 0 ? info[0]._storageClass.compareTo(info[1]._storageClass) : t;
                }
                case 8: {
                    return this.compareDouble((double)info[0]._precious / (double)info[0]._total, (double)info[1]._precious / (double)info[1]._total);
                }
            }
            return 0;
        }
    }

    static class PoolEntryComparator
    extends EntryComparator<PoolEntry> {
        PoolEntryComparator() {
        }

        @Override
        public int compare(PoolEntry a, PoolEntry b) {
            PoolEntry[] info1 = new PoolEntry[]{a, b};
            PoolEntry[] info2 = new PoolEntry[]{b, a};
            PoolEntry[] info = this._topHigh ? info1 : info2;
            switch (this._sortColumn) {
                case 0: {
                    return info[0]._poolName.compareTo(info[1]._poolName);
                }
                case 1: {
                    int t = this.compareBoolean(info[0]._isReadOnly, info[1]._isReadOnly);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 2: {
                    int t = this.compareInt(info[0]._flushing, info[1]._flushing);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 3: {
                    int t = this.compareLong(info[0]._total, info[1]._total);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 4: {
                    int t = this.compareLong(info[0]._precious, info[1]._precious);
                    return t == 0 ? info[0]._poolName.compareTo(info[1]._poolName) : t;
                }
                case 5: {
                    return this.compareDouble((double)info[0]._precious / (double)info[0]._total, (double)info[1]._precious / (double)info[1]._total);
                }
            }
            return 0;
        }
    }

    private static abstract class EntryComparator<T>
    implements Comparator<T> {
        boolean _topHigh;
        int _sortColumn;

        private EntryComparator() {
        }

        void setColumn(int column) {
            if (this._sortColumn == column) {
                this._topHigh = !this._topHigh;
            } else {
                this._sortColumn = column;
                this._topHigh = false;
            }
        }

        @Override
        public abstract int compare(T var1, T var2);

        int compareBoolean(boolean a, boolean b) {
            return a ^ b ? (a ? 1 : -1) : 0;
        }

        int compareInt(int a, int b) {
            return a == b ? 0 : (a > b ? 1 : -1);
        }

        int compareLong(long a, long b) {
            return a == b ? 0 : (a > b ? 1 : -1);
        }

        int compareDouble(double a, double b) {
            return a == b ? 0 : (a > b ? 1 : -1);
        }
    }

    static class PoolEntry {
        String _poolName;
        long _total;
        long _precious;
        int _flushing;
        boolean _isReadOnly;
        String _storageClass;

        PoolEntry() {
        }
    }
}

