/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPTransactionLog {
    private static final Logger _log = LoggerFactory.getLogger(FTPTransactionLog.class);
    private FileWriter LWriter;
    private File LogFilePath;
    private String root;
    private String tid;
    private boolean GotMiddle;

    public FTPTransactionLog(String root, String tid) {
        this(root);
        this.tid = tid;
    }

    public FTPTransactionLog(String root) {
        long time = System.currentTimeMillis();
        this.root = root;
        this.tid = "" + time;
        this.LWriter = null;
        this.GotMiddle = false;
    }

    public synchronized void finalize() throws Throwable {
        this.error("Transaction abandoned");
        super.finalize();
    }

    private synchronized void addLine(String line) {
        if (this.LWriter == null) {
            return;
        }
        try {
            long time = System.currentTimeMillis() / 1000L;
            this.LWriter.write(time + " " + line + "\n");
            this.LWriter.flush();
        }
        catch (IOException e) {
            _log.warn(e.toString(), (Throwable)e);
        }
    }

    public synchronized void begin(String user, String ftp_type, String rw, String path, InetAddress addr) {
        if (this.root == null) {
            return;
        }
        try {
            File rootDir = new File(this.root);
            if (!rootDir.exists()) {
                throw new IOException("Log root directory " + this.root + " not found");
            }
            String dirname = user;
            File userDir = new File(rootDir, dirname = dirname.replaceAll("/", ":"));
            if (!userDir.exists()) {
                userDir.mkdir();
            }
            this.LogFilePath = new File(userDir, this.tid + ".tlog");
            this.LWriter = new FileWriter(this.LogFilePath);
            File userNameFile = new File(userDir, "username");
            FileWriter userNameFileWriter = new FileWriter(userNameFile);
            userNameFileWriter.write(user);
            userNameFileWriter.close();
            try {
                String line = user + " \"" + ftp_type + "\" " + rw + " " + path + " " + addr.getCanonicalHostName();
                this.addLine(line);
            }
            catch (Exception ex) {
                _log.warn(ex.toString(), (Throwable)ex);
                this.addLine("Unable to process IP for transfer");
            }
        }
        catch (IOException e) {
            _log.warn(e.toString(), (Throwable)e);
        }
    }

    public synchronized void middle(long size) {
        this.addLine("" + size);
        this.GotMiddle = true;
    }

    public synchronized void error(String status) {
        if (!this.GotMiddle) {
            this.middle(0L);
        }
        this.addLine("ERROR " + status);
        this.close();
    }

    public synchronized void success() {
        if (!this.GotMiddle) {
            this.middle(0L);
        }
        this.addLine("OK");
        this.close();
    }

    private synchronized void close() {
        if (this.LWriter == null) {
            return;
        }
        try {
            this.LWriter.close();
        }
        catch (Exception e) {
            _log.warn(e.toString(), (Throwable)e);
        }
        this.LWriter = null;
    }
}

