/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.CopyManagerMessage;
import diskCacheV111.vehicles.DCapClientPortAvailableMessage;
import diskCacheV111.vehicles.DCapClientProtocolInfo;
import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.CellStub;
import org.dcache.util.RedirectedTransfer;
import org.dcache.util.Transfer;
import org.dcache.util.TransferRetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyManager
extends AbstractCell {
    private static final Logger _log = LoggerFactory.getLogger(CopyManager.class);
    private final Map<Long, CopyHandler> _activeTransfers = new ConcurrentHashMap<Long, CopyHandler>();
    private final Queue<CellMessage> _queue = new ArrayDeque<CellMessage>();
    private InetSocketAddress _localAddr;
    private long _moverTimeout = TimeUnit.HOURS.toMillis(24L);
    private int _bufferSize = 262144;
    private int _tcpBufferSize = 262144;
    private int _maxTransfers = 30;
    private int _numTransfers;
    private PnfsHandler _pnfs;
    private CellStub _poolManagerStub;
    private CellStub _poolStub;
    public static final String hh_set_max_transfers = "<#max transfers>";
    public static final String hh_set_mover_timeout = "<#seconds>";
    public static final String hh_set_pool_timeout = "<#seconds>";
    public static final String hh_set_pool_manager_timeout = "<#seconds>";
    public static final String hh_ls = "[-l] [<#transferId>]";
    public static final String hh_queue = "[-l]";

    public CopyManager(String cellName, String args) throws InterruptedException, ExecutionException {
        super(cellName, args);
        this.doInit();
    }

    @Override
    protected void init() throws Exception {
        Args args = this.getArgs();
        this._localAddr = new InetSocketAddress(InetAddress.getLocalHost(), 0);
        this._moverTimeout = args.getLongOption("mover_timeout") * 1000L;
        this._maxTransfers = args.getIntOption("max_transfers");
        this._pnfs = new PnfsHandler((CellEndpoint)this, new CellPath("PnfsManager"));
        this._poolManagerStub = new CellStub((CellEndpoint)this, new CellPath(args.getOpt("poolManager")), args.getLongOption("pool_manager_timeout") * 1000L);
        this._poolStub = new CellStub((CellEndpoint)this, null, args.getLongOption("pool_timeout") * 1000L);
    }

    public String ac_set_max_transfers_$_1(Args args) {
        int max = Integer.parseInt(args.argv(0));
        if (max <= 0) {
            return "Error, max transfers number should be greater than 0";
        }
        this.setMaxTransfers(max);
        return "set maximum number of active transfers to " + max;
    }

    public String ac_set_mover_timeout_$_1(Args args) {
        int timeout = Integer.parseInt(args.argv(0));
        if (timeout <= 0) {
            return "Error, mover timeout should be greater than 0";
        }
        this._moverTimeout = timeout * 1000;
        return "set mover timeout to " + timeout + " seconds";
    }

    public String ac_set_pool_timeout_$_1(Args args) {
        int timeout = Integer.parseInt(args.argv(0));
        if (timeout <= 0) {
            return "Error, pool timeout should be greater than 0";
        }
        this._poolStub.setTimeout(timeout * 1000);
        return "set pool timeout to " + timeout + " seconds";
    }

    public String ac_set_pool_manager_timeout_$_1(Args args) {
        int timeout = Integer.parseInt(args.argv(0));
        if (timeout <= 0) {
            return "Error, pool manger timeout should be greater than 0";
        }
        this._poolManagerStub.setTimeout(timeout * 1000);
        return "set pool manager timeout to " + timeout + " seconds";
    }

    public String ac_ls_$_0_1(Args args) {
        boolean long_format = args.hasOption("l");
        if (args.argc() > 0) {
            long id = Long.parseLong(args.argv(0));
            CopyHandler transferHandler = this._activeTransfers.get(id);
            if (transferHandler == null) {
                return "ID not found : " + id;
            }
            return " transfer id=" + id + " : " + transferHandler.toString(long_format);
        }
        StringBuilder sb = new StringBuilder();
        if (this._activeTransfers.isEmpty()) {
            return "No Active Transfers";
        }
        sb.append("  Active Transfers ");
        for (Map.Entry<Long, CopyHandler> entry : this._activeTransfers.entrySet()) {
            sb.append("\n#").append(entry.getKey());
            sb.append(" ").append(entry.getValue().toString(long_format));
        }
        return sb.toString();
    }

    public synchronized String ac_queue_$_0(Args args) {
        boolean long_format = args.hasOption("l");
        StringBuilder sb = new StringBuilder();
        if (this._queue.isEmpty()) {
            return "Queue is empty";
        }
        int i = 0;
        for (CellMessage envelope : this._queue) {
            sb.append("\n#").append(i++);
            CopyManagerMessage request = (CopyManagerMessage)envelope.getMessageObject();
            sb.append(" store src=");
            sb.append(request.getSrcPnfsPath());
            sb.append(" dest=");
            sb.append(request.getDstPnfsPath());
            if (!long_format) continue;
            sb.append("\n try#").append(request.getNumberOfPerformedRetries());
        }
        return sb.toString();
    }

    public synchronized void getInfo(PrintWriter pw) {
        pw.println("    CopyManager");
        pw.println("---------------------------------");
        pw.printf("Name   : %s\n", this.getCellName());
        pw.printf("number of active transfers : %d\n", this._numTransfers);
        pw.printf("number of queuedrequests : %d\n", this._queue.size());
        pw.printf("max number of active transfers  : %d\n", this.getMaxTransfers());
        pw.printf("PoolManager  : %s\n", this._poolManagerStub.getDestinationPath());
        pw.printf("PoolManager timeout : %d seconds\n", this._poolManagerStub.getTimeout() / 1000L);
        pw.printf("Pool timeout  : %d seconds\n", this._poolStub.getTimeout() / 1000L);
        pw.printf("Mover timeout  : %d seconds", this._moverTimeout / 1000L);
    }

    public void messageArrived(DoorTransferFinishedMessage message) {
        CopyHandler handler = this._activeTransfers.get(message.getId());
        if (handler != null) {
            handler.messageNotify(message);
        }
    }

    public void messageArrived(DCapClientPortAvailableMessage message) {
        CopyHandler handler = this._activeTransfers.get(message.getId());
        if (handler != null) {
            handler.messageNotify(message);
        }
    }

    public void messageArrived(CellMessage envelope, CopyManagerMessage message) {
        if (this.newTransfer()) {
            new Thread(new CopyHandler(envelope)).start();
        } else {
            this.putOnQueue(envelope);
        }
    }

    public void returnError(CellMessage envelope, String errormsg) {
        CopyManagerMessage request = (CopyManagerMessage)envelope.getMessageObject();
        request.setReturnCode(1);
        request.setDescription(errormsg);
        try {
            envelope.revertDirection();
            this.sendMessage(envelope);
        }
        catch (NoRouteToCellException e) {
            _log.warn(e.toString());
        }
    }

    public synchronized int getMaxTransfers() {
        return this._maxTransfers;
    }

    public synchronized void setMaxTransfers(int maxTransfers) {
        this._maxTransfers = maxTransfers;
        while (!this._queue.isEmpty() && this.newTransfer()) {
            CellMessage nextMessage = this._queue.remove();
            new Thread(new CopyHandler(nextMessage)).start();
        }
    }

    private synchronized boolean newTransfer() {
        _log.debug("newTransfer() numTransfers = {} maxTransfers = {}", (Object)this._numTransfers, (Object)this._maxTransfers);
        if (this._numTransfers == this._maxTransfers) {
            _log.debug("newTransfer() returns false");
            return false;
        }
        _log.debug("newTransfer() INCREMENT and return true");
        ++this._numTransfers;
        return true;
    }

    private synchronized void finishTransfer() {
        _log.debug("finishTransfer() numTransfers = {} DECREMENT", (Object)this._numTransfers);
        --this._numTransfers;
    }

    private synchronized void putOnQueue(CellMessage request) {
        this._queue.add(request);
    }

    private synchronized CellMessage nextFromQueue() {
        if (!this._queue.isEmpty() && this.newTransfer()) {
            return this._queue.remove();
        }
        return null;
    }

    private class CopyHandler
    implements Runnable {
        private CellMessage _envelope;
        private Transfer _source;
        private RedirectedTransfer<DCapClientPortAvailableMessage> _target;

        public synchronized void messageNotify(DoorTransferFinishedMessage message) {
            long id = message.getId();
            if (this._source != null && this._source.getSessionId() == id) {
                this._source.finished(message);
            } else if (this._target != null && this._target.getSessionId() == id) {
                this._target.finished(message);
            }
        }

        public synchronized void messageNotify(DCapClientPortAvailableMessage message) {
            if (this._target != null) {
                this._target.redirect(message);
            }
        }

        public CopyHandler(CellMessage envelope) {
            this._envelope = envelope;
        }

        public synchronized String toString(boolean long_format) {
            if (this._envelope == null) {
                return this.getState();
            }
            CopyManagerMessage message = (CopyManagerMessage)this._envelope.getMessageObject();
            StringBuilder sb = new StringBuilder();
            sb.append("store src=");
            sb.append(message.getSrcPnfsPath());
            sb.append(" dest=");
            sb.append(message.getDstPnfsPath());
            if (!long_format) {
                return sb.toString();
            }
            sb.append("\n   ").append(this.getState());
            sb.append("\n try#").append(message.getNumberOfPerformedRetries());
            if (this._source != null && this._source.getPnfsId() != null) {
                sb.append("\n   srcPnfsId=").append(this._source.getPnfsId());
            }
            if (this._target != null && this._target.getPnfsId() != null) {
                sb.append("\n   dstPnfsId=").append(this._target.getPnfsId());
            }
            if (this._source != null && this._source.getPool() != null) {
                sb.append("\n   srcPool=").append(this._source.getPool());
            }
            if (this._target != null && this._target.getPool() != null) {
                sb.append("\n   dstPool=").append(this._target.getPool());
            }
            return sb.toString();
        }

        public synchronized String getState() {
            String target;
            String source;
            String string = source = this._source != null ? this._source.getStatus() : null;
            if (source != null) {
                return source;
            }
            String string2 = target = this._target != null ? this._target.getStatus() : null;
            if (target != null) {
                return target;
            }
            return "Pending";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this._envelope != null) {
                boolean requeue = false;
                CopyManagerMessage message = (CopyManagerMessage)this._envelope.getMessageObject();
                try {
                    _log.info("starting processing transfer message with id {}", (Object)message.getId());
                    this.copy(message.getSubject(), new FsPath(message.getSrcPnfsPath()), new FsPath(message.getDstPnfsPath()));
                    message.setReturnCode(0);
                    message.setDescription("file " + message.getDstPnfsPath() + " has been copied from " + message.getSrcPnfsPath());
                }
                catch (CacheException e) {
                    int retries = message.getNumberOfRetries() - 1;
                    message.setNumberOfRetries(retries);
                    if (retries > 0) {
                        requeue = true;
                    } else {
                        message.setReturnCode(1);
                        message.setDescription("copy failed:" + e.getMessage());
                    }
                }
                catch (InterruptedException e) {
                    message.setReturnCode(1);
                    message.setDescription("copy was interrupted");
                }
                finally {
                    CopyManager.this.finishTransfer();
                    message.increaseNumberOfPerformedRetries();
                    if (requeue) {
                        _log.info("putting on queue for retry: {}", (Object)this._envelope);
                        CopyManager.this.putOnQueue(this._envelope);
                    } else {
                        try {
                            this._envelope.revertDirection();
                            CopyManager.this.sendMessage(this._envelope);
                        }
                        catch (Exception e) {
                            _log.warn(e.toString(), (Throwable)e);
                        }
                    }
                }
                CopyHandler copyHandler = this;
                synchronized (copyHandler) {
                    this._envelope = CopyManager.this.nextFromQueue();
                    this._source = null;
                    this._target = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(Subject subject, FsPath srcPnfsFilePath, FsPath dstPnfsFilePath) throws CacheException, InterruptedException {
            CopyHandler copyHandler = this;
            synchronized (copyHandler) {
                this._target = new RedirectedTransfer(CopyManager.this._pnfs, subject, dstPnfsFilePath);
                this._source = new Transfer(CopyManager.this._pnfs, subject, srcPnfsFilePath);
            }
            this._source.setPoolManagerStub(CopyManager.this._poolManagerStub);
            this._source.setPoolStub(CopyManager.this._poolStub);
            this._source.setDomainName(CopyManager.this.getCellDomainName());
            this._source.setCellName(CopyManager.this.getCellName());
            this._target.setPoolManagerStub(CopyManager.this._poolManagerStub);
            this._target.setPoolStub(CopyManager.this._poolStub);
            this._target.setDomainName(CopyManager.this.getCellDomainName());
            this._target.setCellName(CopyManager.this.getCellName());
            this._target.setWrite(true);
            boolean success = false;
            CopyManager.this._activeTransfers.put(this._target.getSessionId(), this);
            CopyManager.this._activeTransfers.put(this._source.getSessionId(), this);
            try {
                this._source.readNameSpaceEntry();
                this._target.createNameSpaceEntry();
                this._target.setProtocolInfo(this.createTargetProtocolInfo(this._target));
                this._target.setLength(this._source.getLength());
                this._target.selectPoolAndStartMover("pp", new TransferRetryPolicy(1, 0L, CopyManager.this._poolManagerStub.getTimeout(), CopyManager.this._poolStub.getTimeout()));
                this._target.waitForRedirect(CopyManager.this._moverTimeout);
                this._source.setProtocolInfo(this.createSourceProtocolInfo(this._target.getRedirect(), this._target.getSessionId()));
                this._source.selectPoolAndStartMover("p2p", new TransferRetryPolicy(1, 0L, CopyManager.this._poolManagerStub.getTimeout(), CopyManager.this._poolStub.getTimeout()));
                if (!this._source.waitForMover(CopyManager.this._moverTimeout)) {
                    throw new TimeoutCacheException("copy: wait for DoorTransferFinishedMessage expired");
                }
                if (!this._target.waitForMover(CopyManager.this._moverTimeout)) {
                    throw new TimeoutCacheException("copy: wait for DoorTransferFinishedMessage expired");
                }
                _log.info("transfer finished successfully");
                success = true;
            }
            catch (CacheException e) {
                this._source.setStatus("Failed: " + e.toString());
                _log.warn(e.toString());
                throw e;
            }
            catch (InterruptedException e) {
                this._source.setStatus("Failed: " + e.toString());
                throw e;
            }
            finally {
                if (!success) {
                    String status = this._source.getStatus();
                    this._source.killMover(0L);
                    this._target.killMover(1000L);
                    this._target.deleteNameSpaceEntry();
                    this._source.setStatus(status);
                } else {
                    this._source.setStatus("Success");
                }
                CopyManager.this._activeTransfers.remove(this._target.getSessionId());
                CopyManager.this._activeTransfers.remove(this._source.getSessionId());
            }
        }

        private ProtocolInfo createTargetProtocolInfo(RedirectedTransfer<DCapClientPortAvailableMessage> target) {
            return new DCapClientProtocolInfo("DCapClient", 1, 1, CopyManager.this._localAddr, CopyManager.this.getCellName(), CopyManager.this.getCellDomainName(), target.getSessionId(), CopyManager.this._bufferSize, CopyManager.this._tcpBufferSize);
        }

        private ProtocolInfo createSourceProtocolInfo(DCapClientPortAvailableMessage redirect, long id) {
            DCapProtocolInfo info = new DCapProtocolInfo("DCap", 3, 0, new InetSocketAddress(redirect.getHost(), redirect.getPort()));
            info.setSessionId((int)id);
            return info;
        }
    }
}

