/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.clients.vsp;

import diskCacheV111.clients.vsp.VspConnection;
import diskCacheV111.clients.vsp.VspDevice;
import dmg.util.Args;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class vsp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argss) {
        block61: {
            Args args = new Args(argss);
            if (args.argc() < 2) {
                System.err.println("Usage : ... [options] <filename> <pnfsid>");
                System.err.println("        ... [options] <pnfsId> <filename>");
                System.err.println("    options : ");
                System.err.println("       -host=<hostname> -port=<portnumber>");
                System.err.println("       -bs=<read/write blocksize>");
                System.err.println("       -reply=<replyHostName>");
                System.err.println("       -debug");
                System.exit(4);
            }
            String a1 = args.argv(0);
            String a2 = args.argv(1);
            boolean a1IsPnfsId = a1.charAt(0) == '0';
            boolean a2IsPnfsId = a2.charAt(0) == '0';
            boolean runDebug = args.hasOption("debug");
            if (a1IsPnfsId && a2IsPnfsId) {
                System.err.println("Can't copy pnfsId into pnfsId");
                System.exit(4);
            } else if (!a1IsPnfsId && !a2IsPnfsId) {
                System.err.println("Please use cp to copy regular files");
                System.exit(4);
            }
            String pnfsId = a1IsPnfsId ? args.argv(0) : args.argv(1);
            String filename = a1IsPnfsId ? args.argv(1) : args.argv(0);
            boolean write = a2IsPnfsId;
            boolean dummyWrite = filename.equals("/dev/null");
            int port = 22125;
            int blocksize = 4096;
            String host = args.getOpt("host");
            String replyHost = args.getOpt("reply");
            if (host == null) {
                host = "localhost";
            }
            String tmpString = args.getOpt("port");
            try {
                port = tmpString == null ? port : Integer.parseInt(tmpString);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Invalid portnumber : " + tmpString);
                System.exit(4);
            }
            tmpString = args.getOpt("bs");
            try {
                blocksize = tmpString == null ? blocksize : Integer.parseInt(tmpString);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Invalid blocksize : " + tmpString);
                System.exit(4);
            }
            System.out.println("Options :");
            System.out.println(" I/O direction : " + (write ? "PUT" : "GET"));
            System.out.println(" Server Host   : " + host);
            System.out.println(" Server Port   : " + port);
            System.out.println(" Blocksize     : " + blocksize);
            VspDevice vsp2 = null;
            try {
                vsp2 = new VspDevice(host, port, null);
            }
            catch (Exception ie) {
                System.err.println("Can't connect to (" + host + ":" + port + ") " + ie);
                System.exit(4);
            }
            byte[] dataBuffer = new byte[blocksize];
            if (replyHost != null) {
                vsp2.setHostname(replyHost);
            }
            vsp2.setDebugOutput(runDebug);
            try {
                VspConnection c;
                if (write) {
                    VspConnection c2;
                    FileInputStream is = new FileInputStream(filename);
                    try {
                        c2 = vsp2.open(pnfsId, "w");
                        c2.sync();
                        c2.setSynchronous(true);
                    }
                    catch (Exception ee) {
                        try {
                            is.close();
                        }
                        catch (Exception ed) {
                            // empty catch block
                        }
                        throw ee;
                    }
                    long startit = System.currentTimeMillis();
                    long sum = 0L;
                    try {
                        while (true) {
                            int rc = is.read(dataBuffer, 0, dataBuffer.length);
                            if (runDebug) {
                                System.out.println("Tranferring " + rc);
                            }
                            if (rc < 0) {
                                throw new IOException("negative value from read : " + rc);
                            }
                            if (rc == 0) {
                                break block61;
                            }
                            sum += (long)rc;
                            c2.write(dataBuffer, 0, rc);
                        }
                    }
                    finally {
                        long now = System.currentTimeMillis();
                        double rate = (double)sum / (double)(now - startit);
                        System.out.println("Rate : " + rate * 9.5367431640625E-4 + " Mbyes/sec");
                        try {
                            c2.close();
                        }
                        catch (Exception dee) {}
                        try {
                            is.close();
                        }
                        catch (Exception dee) {}
                    }
                }
                FileOutputStream os = new FileOutputStream(filename);
                try {
                    c = vsp2.open(pnfsId, "r");
                    c.sync();
                    c.setSynchronous(true);
                }
                catch (Exception ee) {
                    try {
                        os.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    throw ee;
                }
                try {
                    long startit = System.currentTimeMillis();
                    long sum = 0L;
                    while (true) {
                        int rc = (int)c.read(dataBuffer, 0, dataBuffer.length);
                        if (runDebug) {
                            System.out.println("Tranferring " + rc);
                        }
                        if (rc < 0) {
                            throw new IOException("negative value from read : " + rc);
                        }
                        if (rc == 0) break;
                        sum += (long)rc;
                        if (dummyWrite) continue;
                        os.write(dataBuffer, 0, rc);
                    }
                    long now = System.currentTimeMillis();
                    double rate = (double)sum / (double)(now - startit);
                    System.out.println("Rate : " + rate * 9.5367431640625E-4 + " Mbyes/sec");
                }
                finally {
                    try {
                        c.close();
                    }
                    catch (Exception dee) {}
                    try {
                        os.close();
                    }
                    catch (Exception dee) {}
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            finally {
                try {
                    vsp2.close();
                }
                catch (Exception vspce) {
                    System.err.println("VspClose reported : " + vspce);
                }
            }
        }
        System.exit(0);
    }
}

