/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.clients.vsp;

import dmg.util.Args;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

public class VspListener
implements Runnable {
    public static final int IOCMD_WRITE = 1;
    public static final int IOCMD_READ = 2;
    public static final int IOCMD_SEEK = 3;
    public static final int IOCMD_CLOSE = 4;
    public static final int IOCMD_INTERRUPT = 5;
    public static final int IOCMD_ACK = 6;
    public static final int IOCMD_FIN = 7;
    public static final int IOCMD_DATA = 8;
    public static final int IOCMD_LOCATE = 9;
    private static final int IOCMD_SEEK_SET = 0;
    private static final int IOCMD_SEEK_CURRENT = 1;
    private static final int IOCMD_SEEK_END = 2;
    private ServerSocket _listen;
    private Thread _acceptThread;
    private int _counter = 1;
    private Hashtable<Integer, IoChannel> _hash = new Hashtable();
    private String[] _commands = new String[]{"Unkown", "IOCMD_WRITE", "IOCMD_READ", "IOCMD_SEEK", "IOCMD_CLOSE", "IOCMD_INTERRUPT", "IOCMD_ACK", "IOCMD_FIN", "IOCMD_DATA", "IOCMD_LOCATE"};

    private String iocmdToString(int iocmd) {
        if (iocmd <= 0 || iocmd > 9) {
            return "Unkown";
        }
        return this._commands[iocmd];
    }

    public VspListener() throws Exception {
        this._listen = new ServerSocket(0);
        this._acceptThread = new Thread(this);
        this._acceptThread.start();
    }

    public void seek(int session, long offset, int whence) throws Exception {
        IoChannel io = this._hash.get(session);
        if (io == null) {
            throw new Exception("Session not found : " + session);
        }
        io.seek(offset, whence);
    }

    public void close(int session) throws Exception {
        IoChannel io = this._hash.get(session);
        if (io == null) {
            throw new Exception("Session not found : " + session);
        }
        io.close();
    }

    public void locate(int session) throws Exception {
        IoChannel io = this._hash.get(session);
        if (io == null) {
            throw new Exception("Session not found : " + session);
        }
        io.locate();
    }

    public void write(int session) throws Exception {
        IoChannel io = this._hash.get(session);
        if (io == null) {
            throw new Exception("Session not found : " + session);
        }
        io.write();
    }

    public void read(int session, long size) throws Exception {
        IoChannel io = this._hash.get(session);
        if (io == null) {
            throw new Exception("Session not found : " + session);
        }
        io.read(size);
    }

    public void data(int session, int size) throws Exception {
        IoChannel io = this._hash.get(session);
        if (io == null) {
            throw new Exception("Session not found : " + session);
        }
        io.data(size);
    }

    public Enumeration<IoChannel> elements() {
        return this._hash.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this._acceptThread == Thread.currentThread()) {
            try {
                while (true) {
                    VspListener vspListener = this;
                    synchronized (vspListener) {
                        Socket socket = this._listen.accept();
                        ++this._counter;
                        System.out.println("[m] Connection accepted : [" + this._counter + "]");
                        try {
                            this._hash.put(this._counter, new IoChannel(socket, this._counter));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (IOException ioe) {
                System.err.println("Error in accept ... ");
                System.exit(4);
            }
        }
    }

    public synchronized int getCounter() {
        return this._counter;
    }

    public int getListenPort() {
        return this._listen.getLocalPort();
    }

    public static void main(String[] xargs) {
        try {
            VspListener vsp2 = new VspListener();
            System.out.println("Listen Port : " + vsp2.getListenPort());
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            int session = 2;
            block40: while (true) {
                System.out.print("[" + session + "] < ");
                String line = br.readLine();
                if (line == null) break;
                Args args = new Args((CharSequence)line);
                if (args.argc() <= 0) continue;
                String command = args.argv(0);
                args.shift();
                switch (command) {
                    case "cd": {
                        if (args.argc() < 1) {
                            System.err.println("Syntax Error");
                            continue block40;
                        }
                        try {
                            session = Integer.parseInt(args.argv(0));
                        }
                        catch (Exception e) {
                            System.err.println("Syntax Error");
                        }
                        continue block40;
                    }
                    case "ls": {
                        Enumeration<IoChannel> e = vsp2.elements();
                        while (true) {
                            if (!e.hasMoreElements()) continue block40;
                            System.out.println(e.nextElement().toString());
                        }
                    }
                    case "read": {
                        if (args.argc() < 1) {
                            System.err.println("Syntax Error");
                            continue block40;
                        }
                        try {
                            long offset = Long.parseLong(args.argv(0));
                            vsp2.read(session, offset);
                        }
                        catch (Exception ee) {
                            System.err.println("Error " + ee);
                        }
                        continue block40;
                    }
                    case "data": {
                        if (args.argc() < 1) {
                            System.err.println("Syntax Error");
                            continue block40;
                        }
                        try {
                            int offset = Integer.parseInt(args.argv(0));
                            vsp2.data(session, offset);
                        }
                        catch (Exception ee) {
                            System.err.println("Error " + ee);
                        }
                        continue block40;
                    }
                    case "write": {
                        if (args.argc() < 0) {
                            System.err.println("Syntax Error");
                            continue block40;
                        }
                        try {
                            vsp2.write(session);
                        }
                        catch (Exception ee) {
                            System.err.println("Error " + ee);
                        }
                        continue block40;
                    }
                    case "locate": {
                        if (args.argc() < 0) {
                            System.err.println("Syntax Error");
                            continue block40;
                        }
                        try {
                            vsp2.locate(session);
                        }
                        catch (Exception ee) {
                            System.err.println("Error " + ee);
                        }
                        continue block40;
                    }
                    case "close": {
                        if (args.argc() < 0) {
                            System.err.println("Syntax Error");
                            continue block40;
                        }
                        try {
                            vsp2.close(session);
                        }
                        catch (Exception ee) {
                            System.err.println("Error " + ee);
                        }
                        continue block40;
                    }
                    case "seek": {
                        if (args.argc() < 2) {
                            System.err.println("Syntax Error");
                            continue block40;
                        }
                        try {
                            long offset = Long.parseLong(args.argv(0));
                            int whence = Integer.parseInt(args.argv(1));
                            vsp2.seek(session, offset, whence);
                        }
                        catch (Exception ee) {
                            System.err.println("Error " + ee);
                        }
                        continue block40;
                    }
                    case "help": {
                        System.out.println("[0] > ls");
                        System.out.println("[0] > cd <session>");
                        System.out.println("[0] > exit");
                        System.out.println("[0] > close");
                        System.out.println("[0] > write");
                        System.out.println("[0] > data <bytes>");
                        System.out.println("[0] > read <bytes>");
                        System.out.println("[0] > seek <offset> <whence=0,1,2>");
                        continue block40;
                    }
                    case "exit": {
                        System.exit(4);
                    }
                }
                System.out.println("What ? ");
            }
            System.out.println("");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        System.exit(0);
    }

    private class IoChannel
    implements Runnable {
        private int _session;
        private Socket _socket;
        private DataInputStream _dataIn;
        private DataOutputStream _dataOut;
        private Thread _worker;

        private IoChannel(Socket socket, int session) throws IOException {
            this._session = session;
            this._socket = socket;
            try {
                this._dataIn = new DataInputStream(this._socket.getInputStream());
                this._dataOut = new DataOutputStream(this._socket.getOutputStream());
                this.say("");
                int remoteSession = this._dataIn.readInt();
                this.say("Remote session is " + remoteSession);
                int chSize = this._dataIn.readInt();
                this.say("Challenge Size is " + chSize);
                this._dataIn.skipBytes(chSize);
            }
            catch (IOException e) {
                System.err.println("[" + this._session + "] : exc : " + e);
                try {
                    this._socket.close();
                }
                catch (IOException ii) {
                    // empty catch block
                }
                throw e;
            }
            this._worker = new Thread(this);
            this._worker.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block10: while (true) {
                    int len;
                    try {
                        len = this._dataIn.readInt();
                    }
                    catch (EOFException eofe) {
                        this.say("connection closed");
                        throw eofe;
                    }
                    if (len < 4) {
                        throw new Exception("Protocol violation (len)");
                    }
                    int command = this._dataIn.readInt();
                    switch (command) {
                        case 8: {
                            this.say("");
                            this.say("{datatransfermode}");
                            while (true) {
                                int datalen;
                                if ((datalen = this._dataIn.readInt()) < 0) {
                                    this.say("Data transfer delimiter");
                                    this.say("{commandmode}");
                                    continue block10;
                                }
                                this.say("Reading block of " + datalen);
                                if (datalen == 0) continue;
                                this._dataIn.skipBytes(datalen);
                            }
                        }
                        case 6: 
                        case 7: {
                            if (len < 12) {
                                throw new Exception("Protocol violation (len2)");
                            }
                            this.say("");
                            int iocmd = this._dataIn.readInt();
                            int rc = this._dataIn.readInt();
                            StringBuilder sb = new StringBuilder();
                            sb.append("{REQUEST_").append(command == 6 ? "ACK" : "FIN").append(" iocmd=");
                            sb.append(VspListener.this.iocmdToString(iocmd)).append(" rc=").append(rc).append("} ");
                            len -= 12;
                            if (rc == 0) {
                                int i = 0;
                                while (len >= 8) {
                                    long arg = this._dataIn.readLong();
                                    sb.append(";a[").append(i).append("]=").append(arg);
                                    ++i;
                                    len -= 8;
                                }
                                sb.append(";\n");
                            } else {
                                String str = this._dataIn.readUTF();
                                len -= str.length() + 2;
                                sb.append(";ErrorMessage='").append(str).append("'");
                            }
                            this.say(sb.toString());
                            this._dataIn.skipBytes(len);
                            continue block10;
                        }
                    }
                    this.say("Unknown command : " + command);
                }
            }
            catch (Exception e) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                VspListener.this._hash.remove(this._session);
                return;
            }
        }

        private void say(String s) {
            System.out.println("[" + this._session + "] > " + s);
        }

        public String toString() {
            return " session=" + this._session;
        }

        public void seek(long offset, int whence) throws IOException {
            this._dataOut.writeInt(16);
            this._dataOut.writeInt(3);
            this._dataOut.writeLong(offset);
            this._dataOut.writeInt(whence);
            this._dataOut.flush();
        }

        public void close() throws Exception {
            this._dataOut.writeInt(4);
            this._dataOut.writeInt(4);
            this._dataOut.flush();
        }

        public void write() throws Exception {
            this._dataOut.writeInt(4);
            this._dataOut.writeInt(1);
            this._dataOut.flush();
        }

        public void locate() throws Exception {
            this._dataOut.writeInt(4);
            this._dataOut.writeInt(9);
            this._dataOut.flush();
        }

        public void read(long size) throws Exception {
            this._dataOut.writeInt(12);
            this._dataOut.writeInt(2);
            this._dataOut.writeLong(size);
            this._dataOut.flush();
        }

        public void data(int size) throws Exception {
            int full = size / 1024;
            int res = size % 1024;
            this._dataOut.writeInt(4);
            this._dataOut.writeInt(8);
            byte[] data = new byte[1024];
            for (int i = 0; i < full; ++i) {
                this._dataOut.writeInt(1024);
                this._dataOut.write(data);
            }
            if (res > 0) {
                this._dataOut.writeInt(res);
                this._dataOut.write(data, 0, res);
            }
            this._dataOut.writeInt(-1);
            this._dataOut.flush();
        }
    }
}

