/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.clients.vsp;

import diskCacheV111.clients.vsp.VspConnection;
import diskCacheV111.clients.vsp.VspDataTransferrable;
import diskCacheV111.clients.vsp.VspDevice;
import dmg.util.Args;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class VspDeviceShell {
    public static void main(String[] arg) throws Exception {
        new VspDeviceShell(arg);
    }

    public VspDeviceShell(String[] arg) throws Exception {
        if (arg.length < 3) {
            System.err.println("Usage : ... <host> <port> <replyHost>");
            System.exit(4);
        }
        String host = arg[0];
        int port = Integer.parseInt(arg[1]);
        String replyHost = arg[2];
        VspDevice vsp2 = new VspDevice(host, port, replyHost);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        int session = 0;
        boolean debug = false;
        VspConnection _currentConnection = null;
        Hashtable<Integer, VspConnection> _hash = new Hashtable<Integer, VspConnection>();
        int _nextSession = 100;
        block72: while (true) {
            System.out.print("[" + session + "] > ");
            String line = br.readLine();
            if (line == null) break;
            Args args = new Args((CharSequence)line);
            if (args.argc() <= 0) continue;
            String command = args.argv(0);
            args.shift();
            block36 : switch (command) {
                case "cd": {
                    if (args.argc() < 1) {
                        System.err.println("cd <session>");
                        continue block72;
                    }
                    try {
                        int s = Integer.parseInt(args.argv(0));
                        if (s == 0) {
                            session = 0;
                            _currentConnection = null;
                            continue block72;
                        }
                        VspConnection c = (VspConnection)_hash.get(s);
                        if (c == null) {
                            System.err.println("No such session " + s);
                            continue block72;
                        }
                        _currentConnection = c;
                        session = s;
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                    }
                    continue block72;
                }
                case "ls": {
                    Iterator i$ = _hash.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block72;
                        Object key = i$.next();
                        System.out.println(key);
                    }
                }
                case "exit": {
                    System.exit(0);
                }
                case "close": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    try {
                        _currentConnection.close();
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                        if (!debug) continue block72;
                        e.printStackTrace();
                    }
                    continue block72;
                }
                case "remove": {
                    _hash.remove(session);
                    session = 0;
                    _currentConnection = null;
                    break;
                }
                case "sync": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    try {
                        _currentConnection.sync();
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                        if (!debug) continue block72;
                        e.printStackTrace();
                    }
                    continue block72;
                }
                case "show": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    try {
                        System.out.println("Position  : " + _currentConnection.getPosition());
                        System.out.println("Length    : " + _currentConnection.getLength());
                        System.out.println("BytesRead : " + _currentConnection.getBytesRead());
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                        if (!debug) continue block72;
                        e.printStackTrace();
                    }
                    continue block72;
                }
                case "query": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    try {
                        _currentConnection.query();
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                        if (!debug) continue block72;
                        e.printStackTrace();
                    }
                    continue block72;
                }
                case "setsync": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    if (args.argc() < 1) {
                        System.err.println("setsync on|off");
                        continue block72;
                    }
                    boolean sync = args.argv(0).equals("on");
                    _currentConnection.setSynchronous(sync);
                    break;
                }
                case "write": {
                    if (args.argc() < 1) {
                        System.err.println("write <bytes>");
                        continue block72;
                    }
                    int l = Integer.parseInt(args.argv(0));
                    byte[] d = new byte[l];
                    int m = 0;
                    while (true) {
                        Iterator<Object> iterator;
                        if (m >= 2) continue block72;
                        if (_currentConnection == null) {
                            iterator = _hash.values().iterator();
                        } else {
                            Vector<VspConnection> v = new Vector<VspConnection>();
                            v.addElement(_currentConnection);
                            iterator = v.iterator();
                        }
                        while (iterator.hasNext()) {
                            VspConnection c = (VspConnection)iterator.next();
                            try {
                                if (m == 0) {
                                    c.write(d, 0, l);
                                    continue;
                                }
                                c.sync();
                            }
                            catch (Exception e) {
                                System.err.println("E > " + e);
                                if (!debug) continue;
                                e.printStackTrace();
                            }
                        }
                        ++m;
                    }
                }
                case "read": {
                    if (args.argc() < 1) {
                        System.err.println("read <bytes>");
                        continue block72;
                    }
                    int l = Integer.parseInt(args.argv(0));
                    byte[] d = new byte[l];
                    int m = 0;
                    while (true) {
                        Iterator<Object> iterator;
                        if (m >= 2) continue block72;
                        if (_currentConnection == null) {
                            iterator = _hash.values().iterator();
                        } else {
                            Vector<VspConnection> v = new Vector<VspConnection>();
                            v.addElement(_currentConnection);
                            iterator = v.iterator();
                        }
                        while (iterator.hasNext()) {
                            VspConnection c = (VspConnection)iterator.next();
                            try {
                                if (m == 0) {
                                    c.read(d, 0, l);
                                    continue;
                                }
                                c.sync();
                            }
                            catch (Exception e) {
                                System.err.println("E > " + e);
                                if (!debug) continue;
                                e.printStackTrace();
                            }
                        }
                        ++m;
                    }
                }
                case "loopread": {
                    int xx;
                    if (args.argc() < 1) {
                        System.err.println("loopread <count> [<blocksize>/kbytes]");
                        continue block72;
                    }
                    final int count = Integer.parseInt(args.argv(0));
                    final int bsize = xx = args.argc() < 2 ? 0x100000 : Integer.parseInt(args.argv(1)) * 1024;
                    if (_currentConnection != null) {
                        System.out.println("Need to be run in '0' mode");
                        continue block72;
                    }
                    System.out.println("Switching to 'sync' mode");
                    for (Object o : _hash.values()) {
                        ((VspConnection)o).setSynchronous(true);
                    }
                    Iterator iterator = _hash.values().iterator();
                    int ix = 0;
                    while (true) {
                        if (!iterator.hasNext()) continue block72;
                        final VspConnection c = (VspConnection)iterator.next();
                        final int countPosition = ix++;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                System.out.println("Starting " + countPosition);
                                byte[] d = new byte[bsize];
                                long sum = 0L;
                                long start = System.currentTimeMillis();
                                try {
                                    for (int i = 0; i < count; ++i) {
                                        int r;
                                        do {
                                            r = (int)c.read(d, 0, d.length);
                                            sum += (long)r;
                                        } while (r >= d.length);
                                        c.seek(0L, 0);
                                    }
                                }
                                catch (Exception e) {
                                    System.err.println("E > " + e);
                                    e.printStackTrace();
                                }
                                long diff = System.currentTimeMillis() - start;
                                if (diff == 0L) {
                                    System.out.println("Done : ??? MB/sec");
                                } else {
                                    double rate = (double)sum / (double)diff / 1024.0 / 1024.0 * 1000.0;
                                    System.out.println("Done : " + rate + " MB/sec");
                                }
                            }
                        }).start();
                    }
                }
                case "sread": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    if (args.argc() < 1) {
                        System.err.println("sread <bytes>");
                        continue block72;
                    }
                    try {
                        int l = Integer.parseInt(args.argv(0));
                        byte[] d = new byte[l];
                        _currentConnection.read(d, 0, d.length);
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                        if (!debug) continue block72;
                        e.printStackTrace();
                    }
                    continue block72;
                }
                case "fullread": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    if (args.argc() < 1) {
                        System.err.println("fullread <bytes>");
                        continue block72;
                    }
                    try {
                        int l = Integer.parseInt(args.argv(0));
                        DataEater de = new DataEater();
                        long start = System.currentTimeMillis();
                        _currentConnection.read(l, de);
                        _currentConnection.sync();
                        System.out.println("Data transferred : " + de.getDataTransferred());
                        long diff = System.currentTimeMillis() - start;
                        if (diff == 0L) {
                            System.out.println("Done : ??? MB/sec");
                            break;
                        }
                        double rate = (double)de.getDataTransferred() / (double)diff / 1024.0 / 1024.0 * 1000.0;
                        System.out.println("Done : " + rate + " MB/sec");
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                        if (!debug) continue block72;
                        e.printStackTrace();
                    }
                    continue block72;
                }
                case "seek": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    if (args.argc() < 1) {
                        System.err.println("seek <offset> [<whence>]");
                        continue block72;
                    }
                    try {
                        long offset = Long.parseLong(args.argv(0));
                        int whence = 0;
                        if (args.argc() > 1) {
                            whence = Integer.parseInt(args.argv(1));
                        }
                        _currentConnection.seek(offset, whence);
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                        if (!debug) continue block72;
                        e.printStackTrace();
                    }
                    continue block72;
                }
                case "seekandread": {
                    if (_currentConnection == null) {
                        System.err.println("Not an active connection");
                        continue block72;
                    }
                    if (args.argc() < 2) {
                        System.err.println("seekandread <size> <offset> [<whence>]");
                        continue block72;
                    }
                    try {
                        int size = Integer.parseInt(args.argv(0));
                        long offset = Long.parseLong(args.argv(1));
                        int whence = 0;
                        if (args.argc() > 2) {
                            whence = Integer.parseInt(args.argv(2));
                        }
                        byte[] d = new byte[size];
                        _currentConnection.seek_and_read(d, 0, offset, whence, size);
                    }
                    catch (Exception e) {
                        System.err.println("E > " + e);
                        if (!debug) continue block72;
                        e.printStackTrace();
                    }
                    continue block72;
                }
                case "debug": {
                    vsp2.setDebugOutput(true);
                    debug = true;
                    break;
                }
                case "nodebug": {
                    vsp2.setDebugOutput(false);
                    debug = false;
                    break;
                }
                case "open": {
                    int c;
                    if (args.argc() < 2) {
                        System.err.println("open <pnfsId> <mode> [-count=<count>]");
                        continue block72;
                    }
                    String count = args.getOpt("count");
                    if (count == null) {
                        try {
                            VspConnection con = vsp2.open(args.argv(0), args.argv(1));
                            int s = ++_nextSession;
                            _hash.put(s, con);
                            _currentConnection = con;
                            session = s;
                        }
                        catch (Exception e) {
                            System.err.println("E > " + e);
                            if (!debug) continue block72;
                            e.printStackTrace();
                        }
                        continue block72;
                    }
                    try {
                        c = Integer.parseInt(count);
                    }
                    catch (IllegalArgumentException iae) {
                        System.err.println("Not an integer : " + count);
                        continue block72;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= c) continue block72;
                        try {
                            VspConnection con = vsp2.open(args.argv(0), args.argv(1));
                            int s = ++_nextSession;
                            _hash.put(s, con);
                            con.sync();
                            System.out.println("Session O.K : " + s);
                        }
                        catch (Exception e) {
                            System.err.println("E > " + e);
                            if (!debug) continue block72;
                            e.printStackTrace();
                            break block36;
                        }
                        _currentConnection = null;
                        session = 0;
                        ++i;
                    }
                }
                case "help": {
                    System.out.println(" I/O commands");
                    System.out.println(" ------------");
                    System.out.println("  open <pnfsId> r|w  [-count=<count>]# opens channel -> new <id>");
                    System.out.println("  close              # closes channel");
                    System.out.println("  read <bytes>       # requests <bytes> bytes");
                    System.out.println("  write <bytes>      # writes <bytes> bytes");
                    System.out.println("  query              # send stat command (see show)");
                    System.out.println("  show               # return result of stat");
                    System.out.println("  seek <position> <whence=0|1|2> # send seek request");
                    System.out.println("  sync               # synchronizes last command");
                    System.out.println("  loopread <count> [<blocksize>] # read all id's");
                    System.out.println(" Admin commands");
                    System.out.println(" --------------");
                    System.out.println("  ls                 # show active/inactive <ids>");
                    System.out.println("  debug|nodebug      # starts stops debug output");
                    System.out.println("  remove <id>        # removes and <id>");
                    System.out.println("  setsync on|off     # switches sync mode");
                    break;
                }
                default: {
                    System.err.println("command not known : " + command);
                }
            }
        }
    }

    private class DataEater
    implements VspDataTransferrable {
        private long _sum;

        private DataEater() {
        }

        public long getDataTransferred() {
            return this._sum;
        }

        @Override
        public void dataArrived(VspConnection vsp2, byte[] buffer, int offset, int size) {
            this._sum += (long)size;
        }
    }
}

