/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.clients.vsp;

import diskCacheV111.clients.vsp.VspRequest;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.VspArgs;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;

public class VspClient
implements Runnable {
    private final Hashtable<Integer, VspBaseRequest> _requestHash = new Hashtable();
    private ServerSocket _listen;
    private Socket _door;
    private BufferedReader _in;
    private PrintWriter _out;
    private Thread _commandThread;
    private Thread _serviceThread;
    private boolean _debug = true;
    private String _host;
    private int _port;
    private int _sessionId = 1;
    private boolean _online;

    private synchronized int nextSessionId() {
        return this._sessionId++;
    }

    public VspClient(String host, int port) throws CacheException {
        try {
            this._door = new Socket(host, port);
            this._in = new BufferedReader(new InputStreamReader(this._door.getInputStream()));
            this._out = new PrintWriter(new OutputStreamWriter(this._door.getOutputStream()));
            this.prepareService();
            this._serviceThread = new Thread(this);
            this._serviceThread.start();
            this._commandThread = new Thread(this);
            this._commandThread.start();
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CacheException(1, e.toString());
        }
    }

    private void prepareService() throws Exception {
        this._listen = new ServerSocket(0);
        this._host = this._listen.getInetAddress().getHostAddress();
        this._port = this._listen.getLocalPort();
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._commandThread) {
            try {
                this._out.println("0 0 client hello 0 0 0 0");
                this._out.flush();
                this.commandRun();
            }
            catch (Exception exception) {}
        } else if (Thread.currentThread() == this._serviceThread) {
            this.serviceRun();
        }
    }

    private void serviceRun() {
        try {
            Socket s;
            int sessionId = 0;
            while ((s = this._listen.accept()) != null) {
                try {
                    DataInputStream data = new DataInputStream(s.getInputStream());
                    sessionId = data.readInt();
                    VspBaseRequest request = this._requestHash.get(sessionId);
                    if (request == null) {
                        System.err.println("Unexpected data connection for " + sessionId);
                        try {
                            s.close();
                        }
                        catch (Exception xx) {
                            // empty catch block
                        }
                    }
                    if (this._debug) {
                        System.err.println("DataConnection for : " + sessionId);
                    }
                    request.dataConnectionArrived(s);
                }
                catch (Exception ie) {
                    System.err.println("Exception for data : " + sessionId + " : " + ie);
                    try {
                        s.close();
                    }
                    catch (Exception xx) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void commandRun() throws Exception {
        String line;
        while ((line = this._in.readLine()) != null) {
            VspArgs args = new VspArgs(line);
            System.err.println("Door : " + (Object)((Object)args));
            int sessionId = args.getSessionId();
            if (sessionId == 0) {
                this.masterSession(args);
                continue;
            }
            VspBaseRequest request = this._requestHash.get(sessionId);
            if (request == null) {
                System.err.println("Unexpected session id : " + sessionId);
                continue;
            }
            request.infoArrived(args);
        }
    }

    private synchronized void masterSession(VspArgs args) {
        if (args.getCommand().equals("welcome")) {
            this._online = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOnline() throws CacheException {
        if (this._debug) {
            System.err.println("Waiting for 'online'");
        }
        while (!this._online) {
            try {
                VspClient vspClient = this;
                synchronized (vspClient) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                throw new CacheException("Wait for online interrupted");
            }
        }
        if (this._debug) {
            System.err.println("Online .. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VspRequest putPnfs(String pnfsId, File localFile) throws CacheException {
        VspPutRequest vsp2;
        this.waitForOnline();
        if (!localFile.exists()) {
            throw new CacheException(6, "Local File doesn't exists : " + localFile);
        }
        Hashtable<Integer, VspBaseRequest> hashtable = this._requestHash;
        synchronized (hashtable) {
            vsp2 = new VspPutRequest(pnfsId, localFile);
            this._requestHash.put(vsp2.getSessionId(), vsp2);
            this._requestHash.notifyAll();
        }
        return vsp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VspRequest getPnfs(String pnfsId, File localFile) throws CacheException {
        VspGetRequest vsp2;
        this.waitForOnline();
        Hashtable<Integer, VspBaseRequest> hashtable = this._requestHash;
        synchronized (hashtable) {
            vsp2 = new VspGetRequest(pnfsId, localFile);
            this._requestHash.put(vsp2.getSessionId(), vsp2);
            this._requestHash.notifyAll();
        }
        return vsp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAll() {
        try {
            this.waitForOnline();
        }
        catch (Exception ee) {
            return;
        }
        Hashtable<Integer, VspBaseRequest> hashtable = this._requestHash;
        synchronized (hashtable) {
            int count;
            while ((count = this._requestHash.size()) > 0) {
                if (this._debug) {
                    System.err.println("Still " + count + " requests");
                }
                try {
                    this._requestHash.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public static void main(String[] args) {
        if (args.length < 3 || !args[0].equals("put") && !args[0].equals("get") && !args[0].equals("none")) {
            System.err.println("Usage : ... put|get <pnfsId> <fileName>");
            System.exit(4);
        }
        try {
            VspClient vsp2 = new VspClient("localhost", 22125);
            int m = args.length;
            int count = 0;
            while (true) {
                int n = 0;
                Vector<VspRequest> v = new Vector<VspRequest>();
                block17: do {
                    switch (args[n]) {
                        case "put": {
                            if (m - n < 3) {
                                System.err.println("Not enough arguments for 'put' ");
                                break block17;
                            }
                            try {
                                v.addElement(vsp2.putPnfs(args[n + 1], new File(args[n + 2])));
                            }
                            catch (Exception e) {
                                System.err.println("Problem for " + args[n + 1] + " " + e);
                            }
                            n += 3;
                            break;
                        }
                        case "get": {
                            if (m - n < 3) {
                                System.err.println("Not enough arguments for 'get' ");
                                break block17;
                            }
                            try {
                                v.addElement(vsp2.getPnfs(args[n + 1], new File(args[n + 2])));
                            }
                            catch (Exception e) {
                                System.err.println("Problem for " + args[n + 1] + " " + e);
                            }
                            n += 3;
                            break;
                        }
                        case "none": {
                            ++n;
                            break;
                        }
                        default: {
                            System.err.println("Scanning stopped at : " + args[n]);
                            break block17;
                        }
                    }
                } while (n < m);
                vsp2.waitForAll();
                for (Object o : v) {
                    System.out.println(o.toString());
                }
                System.out.println("-------------> Count : " + count++);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(4);
            return;
        }
    }

    private class VspBaseRequest
    implements VspRequest,
    Runnable {
        private int _rc = -1;
        private String _msg = "in process";
        protected String _pnfsId;
        protected File _file;
        protected DataOutputStream _dataOut;
        protected DataInputStream _dataIn;
        private Socket _socket;
        private boolean _ioFinished;
        private boolean _infoArrived;
        private int _sessionId;

        protected VspBaseRequest(String pnfsId, File file) {
            this._pnfsId = pnfsId;
            this._file = file;
            this._sessionId = VspClient.this.nextSessionId();
        }

        int getSessionId() {
            return this._sessionId;
        }

        public String toString() {
            return "[" + this._sessionId + "](" + this._rc + ") -> " + this._msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int skip = this._dataIn.readInt();
                if (VspClient.this._debug) {
                    System.err.println("Skipping " + skip);
                }
                this._dataIn.skipBytes(skip);
                this.runIo(this._dataIn, this._dataOut);
            }
            catch (Exception e) {
                System.err.println("Exception in run : " + e);
            }
            finally {
                try {
                    this._dataOut.close();
                }
                catch (IOException ee) {}
                try {
                    this._dataIn.close();
                }
                catch (IOException ee) {}
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {}
            }
            Hashtable hashtable = VspClient.this._requestHash;
            synchronized (hashtable) {
                this._ioFinished = true;
                this.whatNext();
            }
            if (VspClient.this._debug) {
                System.err.println("Session thread : " + this._sessionId + " finished");
            }
        }

        private void whatNext() {
            if (this._ioFinished && this._infoArrived) {
                VspClient.this._requestHash.remove(this._sessionId);
            }
            VspClient.this._requestHash.notifyAll();
        }

        public void runIo(DataInputStream in, DataOutputStream out) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void infoArrived(VspArgs args) {
            int rc = 3;
            if (args.getCommand().equals("ok")) {
                rc = 0;
                this.setResult(0, "o.k.");
            } else {
                String msg = "Failed";
                if (args.argc() > 0) {
                    try {
                        rc = Integer.parseInt(args.argv(0));
                    }
                    catch (Exception e) {
                        rc = 44;
                    }
                    if (args.argc() > 1) {
                        msg = args.argv(1);
                    }
                }
                this.setResult(rc, msg);
            }
            Hashtable hashtable = VspClient.this._requestHash;
            synchronized (hashtable) {
                if (rc != 0) {
                    this._ioFinished = true;
                }
                this._infoArrived = true;
                this.whatNext();
            }
        }

        private void dataConnectionArrived(Socket s) throws Exception {
            this._socket = s;
            this._dataIn = new DataInputStream(s.getInputStream());
            this._dataOut = new DataOutputStream(s.getOutputStream());
            if (VspClient.this._debug) {
                System.err.println("Starting io thread");
            }
            new Thread(this).start();
        }

        @Override
        public int getResultCode() {
            return this._rc;
        }

        @Override
        public String getResultMessage() {
            return this._msg;
        }

        private void setResult(int rc, String msg) {
            this._rc = rc;
            this._msg = msg;
        }
    }

    private class VspGetRequest
    extends VspBaseRequest {
        private VspGetRequest(String pnfsId, File file) {
            super(pnfsId, file);
            VspClient.this._out.println("" + this.getSessionId() + " 0 client get " + pnfsId + " " + VspClient.this._host + " " + VspClient.this._port);
            VspClient.this._out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runIo(DataInputStream in, DataOutputStream controlOut) throws Exception {
            controlOut.writeLong(0L);
            controlOut.writeLong(-1L);
            FileOutputStream out = new FileOutputStream(this._file);
            long total = 0L;
            long started = System.currentTimeMillis();
            try {
                int size;
                byte[] data = new byte[8192];
                while ((size = in.read(data)) > 0) {
                    total += (long)size;
                    out.write(data, 0, size);
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception eee) {}
                long diff = System.currentTimeMillis() - started;
                if (diff > 0L) {
                    System.out.println("Rate : " + (double)total / (double)diff / 1048.576);
                }
            }
        }
    }

    private class VspPutRequest
    extends VspBaseRequest {
        private VspPutRequest(String pnfsId, File file) {
            super(pnfsId, file);
            VspClient.this._out.println("" + this.getSessionId() + " 0 client put " + pnfsId + " 0 " + VspClient.this._host + " " + VspClient.this._port);
            VspClient.this._out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runIo(DataInputStream x, DataOutputStream out) throws Exception {
            FileInputStream in = new FileInputStream(this._file);
            try {
                int size;
                byte[] data = new byte[8192];
                while ((size = in.read(data)) > 0) {
                    this._dataOut.write(data, 0, size);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception eee) {}
            }
        }
    }
}

