/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.clients.vsp;

import diskCacheV111.clients.vsp.VspConnection;
import diskCacheV111.clients.vsp.VspDataTransferrable;
import diskCacheV111.clients.vsp.VspDevice;
import dmg.util.Args;

public class VspCheck1 {
    private int _count = 1;
    private String _host = "localhost";
    private int _port = 22125;
    private String[] _pnfsid;

    public static void main(String[] arg) throws Exception {
        new VspCheck1(arg);
    }

    public VspCheck1(String[] arg) throws Exception {
        int i;
        String tmp;
        Args args = new Args(arg);
        if (args.argc() < 1) {
            System.err.println("Usage : ...[options] <pnfsId1> [pnfsids ...]");
            System.err.println("      Options : [-host=<host>] [-port=<port>] [-parallel=<count>]");
            System.exit(4);
        }
        this._host = (tmp = args.getOpt("host")) == null ? "localhost" : tmp;
        tmp = args.getOpt("port");
        tmp = tmp == null ? "22125" : tmp;
        this._port = Integer.parseInt(tmp);
        tmp = args.getOpt("parallel");
        tmp = tmp == null ? "1" : tmp;
        this._count = Integer.parseInt(tmp);
        this._pnfsid = new String[args.argc()];
        for (i = 0; i < args.argc(); ++i) {
            this._pnfsid[i] = args.argv(i);
        }
        for (i = 0; i < this._count; ++i) {
            new WorkerThread(i).start();
        }
    }

    private class WorkerThread
    extends Thread {
        private int _id;
        private VspDevice _vsp;
        private final Object _ourLock = new Object();
        private int _counter;

        public WorkerThread(int id) throws Exception {
            this._vsp = new VspDevice(VspCheck1.this._host, VspCheck1.this._port, null);
            this._id = id;
            this._vsp.setDebugOutput(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.say("Starting");
            for (final String pnfsid : VspCheck1.this._pnfsid) {
                Object object = this._ourLock;
                synchronized (object) {
                    ++this._counter;
                }
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            WorkerThread.this.say(pnfsid + " STARTED");
                            VspConnection c = WorkerThread.this._vsp.open(pnfsid, "r");
                            WorkerThread.this.say(pnfsid + " SYNCing OPEN");
                            c.sync();
                            try {
                                WorkerThread.this.say(pnfsid + " OPENED");
                                c.setSynchronous(true);
                                DataEater de = new DataEater();
                                c.read(0x40000000L, de);
                                WorkerThread.this.say(de.toString());
                            }
                            catch (Exception iee) {
                                WorkerThread.this.say(pnfsid + " Exception in io : " + iee);
                            }
                            finally {
                                try {
                                    c.close();
                                }
                                catch (Exception fe) {}
                            }
                        }
                        catch (Exception ee) {
                            WorkerThread.this.say(pnfsid + " Exception in open: " + ee);
                        }
                        WorkerThread.this.say(pnfsid + " CLOSED");
                        Object object = WorkerThread.this._ourLock;
                        synchronized (object) {
                            WorkerThread.this._counter--;
                            WorkerThread.this._ourLock.notifyAll();
                        }
                    }
                }).start();
            }
            this.say("Waiting for all to finish");
            Object object = this._ourLock;
            synchronized (object) {
                while (this._counter > 0) {
                    this.say("Still " + this._counter);
                    try {
                        this._ourLock.wait();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                this._vsp.close();
            }
            catch (Exception exception) {
                this.say("Exception : " + exception);
            }
            this.say("Finished");
        }

        private void say(String s) {
            System.out.println("[" + this._id + "] " + s);
        }
    }

    private class DataEater
    implements VspDataTransferrable {
        private long _sum;
        private long _start = System.currentTimeMillis();

        private DataEater() {
        }

        public long getDataTransferred() {
            return this._sum;
        }

        @Override
        public void dataArrived(VspConnection vsp2, byte[] buffer, int offset, int size) {
            this._sum += (long)size;
        }

        public String toString() {
            long diff = System.currentTimeMillis() - this._start;
            if (diff == 0L) {
                return "" + this._sum / 1024L / 1024L + " MB read with ??? MB/sec";
            }
            double rate = (double)this._sum / (double)diff / 1024.0 / 1024.0 * 1000.0;
            return "" + this._sum / 1024L / 1024L + " MB read with " + rate + " MB/sec";
        }
    }
}

