/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.cells;

import com.google.common.collect.ImmutableSet;
import diskCacheV111.poolManager.PoolManagerCellInfo;
import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.util.HTMLBuilder;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.LoginBrokerInfo;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebCollectorV3
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(WebCollectorV3.class);
    protected static final String OPTION_REPEATHEADER = "repeatHeader";
    private final CellNucleus _nucleus;
    private final Args _args;
    private final Map<CellAddressCore, CellQueryInfo> _infoMap = new TreeMap<CellAddressCore, CellQueryInfo>();
    private final Object _infoLock = new Object();
    private Thread _collectThread;
    private Thread _senderThread;
    private long _counter;
    private int _repeatHeader = 30;
    private final Collection<CellAddressCore> _loginBrokerTable = new ArrayList<CellAddressCore>();
    private SleepHandler _sleepHandler;
    private SimpleDateFormat _formatter = new SimpleDateFormat("MM/dd HH:mm:ss");
    public static final String hh_set_repeat_header = "<repeatHeaderCount>|0";
    private final Map<String, Map<?, ?>> _poolGroup = new HashMap();
    public static final String hh_define_poolgroup = "<poolgroup> [poolName | /regExpr/ ] ... ";
    public static final String hh_watch = "<CellAddress> [...]";
    public static final String hh_dump_info = "[minPingTime] # dumps all info about watched cells";
    public static final String hh_unwatch = "<CellAddress> [...]";
    public static final String hh_set_interval = "[<pingInteval/sec>] [-short=<aggressiveInterval>]";
    private static final int HEADER_TOP = 0;
    private static final int HEADER_MIDDLE = 1;
    private static final int HEADER_BOTTOM = 2;

    public WebCollectorV3(String name, String args) throws Exception {
        super(name, WebCollectorV3.class.getName(), args, false);
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        try {
            String optionString;
            if (this._args.hasOption(OPTION_REPEATHEADER)) {
                optionString = null;
                try {
                    optionString = this._args.getOpt(OPTION_REPEATHEADER);
                    this._repeatHeader = Math.max(0, Integer.parseInt(optionString));
                }
                catch (NumberFormatException e) {
                    _log.warn("Parsing error in repeatHeader command : " + optionString);
                }
                _log.info("Repeat header set to " + this._repeatHeader);
            }
            boolean aggressive = (optionString = this._args.getOpt("aggressive")) != null && (optionString.equals("off") || optionString.equals("false"));
            aggressive = !aggressive;
            _log.info("Agressive mode : " + aggressive);
            this._sleepHandler = new SleepHandler(aggressive);
            for (int i = 0; i < this._args.argc(); ++i) {
                this.addQuery(new CellAddressCore(this._args.argv(i)));
            }
            String loginBrokers = this._args.getOpt("loginBroker");
            if (loginBrokers != null && !loginBrokers.isEmpty()) {
                for (String broker : loginBrokers.split(",")) {
                    _log.info("Login Broker : {}", (Object)broker);
                    CellAddressCore address = new CellAddressCore(broker);
                    this._loginBrokerTable.add(address);
                    this.addQuery(address);
                }
            }
            this._senderThread = this._nucleus.newThread((Runnable)this, "sender");
            this._senderThread.start();
            _log.info("Sender started");
            _log.info("Collector will be started a bit delayed");
            this._collectThread = this._nucleus.newThread((Runnable)this, "collector");
            this._collectThread.start();
        }
        catch (Exception e) {
            _log.warn("<init> of WebCollector reports : " + e.getMessage(), (Throwable)e);
            this.start();
            this.kill();
            throw e;
        }
        this.start();
    }

    private synchronized boolean addQuery(CellAddressCore address) {
        if (this._infoMap.get(address) != null) {
            return false;
        }
        _log.debug("Adding {)", (Object)address);
        this._infoMap.put(address, new CellQueryInfo(address));
        return true;
    }

    private synchronized void removeQuery(String destination) {
        _log.debug("Removing {}", (Object)destination);
        this._infoMap.remove(new CellAddressCore(destination));
    }

    @Override
    public void run() {
        Thread x = Thread.currentThread();
        if (x == this._senderThread) {
            this.runSender();
        } else {
            this.runCollector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCollector() {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e1) {
            return;
        }
        _log.info("Collector now started as well");
        try {
            while (!Thread.interrupted()) {
                Object e1 = this._infoLock;
                synchronized (e1) {
                    this.preparePage();
                }
                this._sleepHandler.sleep();
            }
        }
        catch (InterruptedException e) {
            _log.info("Collector Thread interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSender() {
        try {
            while (!Thread.interrupted()) {
                ++this._counter;
                for (CellAddressCore broker : this._loginBrokerTable) {
                    try {
                        CellPath path = new CellPath(broker);
                        _log.debug("Sending LoginBroker query to : {}", (Object)path);
                        this.sendMessage(new CellMessage(path, (Serializable)((Object)"ls -binary")));
                    }
                    catch (NoRouteToCellException ee) {}
                }
                Object i$ = this._infoLock;
                synchronized (i$) {
                    for (CellQueryInfo info : this._infoMap.values()) {
                        try {
                            _log.debug("Sending query to : {}", (Object)info.getName());
                            this.sendMessage(info.getCellMessage());
                        }
                        catch (NoRouteToCellException e) {}
                    }
                }
                this._sleepHandler.sleep();
            }
        }
        catch (InterruptedException iie) {
            _log.info("Sender Thread interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(CellMessage message) {
        Object object;
        CellPath path = message.getSourcePath();
        CellAddressCore address = path.getSourceAddress();
        CellQueryInfo info = this._infoMap.get(address);
        if (info == null && (info = this._infoMap.get(new CellAddressCore(address.getCellName()))) == null) {
            _log.info("Unexpected reply arrived from: {}", (Object)path);
            return;
        }
        Serializable reply = message.getMessageObject();
        int modified = 0;
        if (reply instanceof CellInfo) {
            _log.debug("CellInfo: {}", (Object)((CellInfo)reply).getCellName());
            info.infoArrived((CellInfo)reply);
        }
        if (reply instanceof PoolManagerCellInfo) {
            ImmutableSet<CellAddressCore> pools = ((PoolManagerCellInfo)reply).getPoolCells();
            object = this._infoLock;
            synchronized (object) {
                for (CellAddressCore pool : pools) {
                    if (!this.addQuery(pool)) continue;
                    ++modified;
                }
            }
        }
        if (reply instanceof LoginBrokerInfo[]) {
            LoginBrokerInfo[] brokerInfos = (LoginBrokerInfo[])reply;
            _log.debug("Login broker reply: {}", (Object)brokerInfos.length);
            object = this._infoLock;
            synchronized (object) {
                for (LoginBrokerInfo brokerInfo : brokerInfos) {
                    _log.debug("Login broker reports: {}@{}", (Object)brokerInfo.getCellName(), (Object)brokerInfo.getDomainName());
                    if (!this.addQuery(new CellAddressCore(brokerInfo.getCellName(), brokerInfo.getDomainName()))) continue;
                    ++modified;
                }
            }
        }
        this._sleepHandler.topologyChanged(modified > 0);
    }

    public synchronized String ac_set_repeat_header_$_1(Args args) {
        this._repeatHeader = Integer.parseInt(args.argv(0));
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_define_poolgroup_$_1_99(Args args) {
        String poolGroupName = args.argv(0);
        Map<String, Map<?, ?>> map = this._poolGroup;
        synchronized (map) {
            Map<?, ?> map2 = this._poolGroup.get(poolGroupName);
            if (map2 == null) {
                map2 = new HashMap();
                this._poolGroup.put(poolGroupName, map2);
            }
            int n = args.argc() - 1;
            for (int i = 0; i < n; ++i) {
                String poolName = args.argv(i);
            }
        }
        return "";
    }

    public String ac_watch_$_1_99(Args args) {
        for (int i = 0; i < args.argc(); ++i) {
            this.addQuery(new CellAddressCore(args.argv(i)));
        }
        return "";
    }

    public String ac_dump_info_$_0_1(Args args) {
        long minPingTime = 0L;
        StringBuilder buf = new StringBuilder();
        if (args.argc() > 0) {
            minPingTime = Long.parseLong(args.argv(0));
        }
        for (CellQueryInfo info : this._infoMap.values()) {
            CellInfo cellInfo = info.getCellInfo();
            long pingTime = info.getPingTime();
            if (pingTime <= minPingTime) continue;
            if (info.isOk()) {
                buf.append("").append(cellInfo.getDomainName()).append(" ").append(cellInfo).append(" ").append(pingTime).append("\n");
                continue;
            }
            if (!info.isPresent()) continue;
            buf.append("").append(cellInfo.getDomainName()).append(" ").append(cellInfo).append("\n");
        }
        return buf.toString();
    }

    public String ac_unwatch_$_1_99(Args args) {
        for (int i = 0; i < args.argc(); ++i) {
            this.removeQuery(args.argv(i));
        }
        return "";
    }

    public String ac_set_interval_$_1(Args args) {
        String opt;
        if (args.argc() > 0) {
            this._sleepHandler.setRegularPeriod(1000L * Long.parseLong(args.argv(0)));
        }
        if ((opt = args.getOpt("short")) != null) {
            this._sleepHandler.setShortPeriod(1000L * Long.parseLong(opt));
        }
        long _interval = 1000L * Long.parseLong(args.argv(0));
        return "Interval set to " + _interval + " [msecs]";
    }

    private void printPoolActionTableHeader(HTMLBuilder page, ActionHeaderExtension ext, int position) {
        int[][] program = new int[][]{{0, 1, 2, 3}, {0, 3, 2, 1, 2, 3}, {0, 3, 2, 1}};
        Set<String> moverSet = ext != null ? ext.getSet() : null;
        int diff = moverSet == null ? 0 : moverSet.size();
        block6: for (int i : program[position]) {
            switch (i) {
                case 0: {
                    int rowspan = program[position].length / 2;
                    page.beginRow(new String[0]);
                    page.th(rowspan, 1, "cell", "CellName");
                    page.th(rowspan, 1, "domain", "DomainName");
                    continue block6;
                }
                case 1: {
                    page.th(3, null, "Movers");
                    page.th(3, null, "Restores");
                    page.th(3, null, "Stores");
                    page.th(3, null, "P2P-Server");
                    page.th(3, null, "P2P-Client");
                    if (moverSet != null) {
                        for (String s : moverSet) {
                            page.th(3, null, s);
                        }
                    }
                    page.endRow();
                    continue block6;
                }
                case 2: {
                    page.beginRow(new String[0]);
                    continue block6;
                }
                case 3: {
                    int n = 5 + diff;
                    for (int h = 0; h < n; ++h) {
                        page.th("active", "Active");
                        page.th("max", "Max");
                        page.th("queued", "Queued");
                    }
                    page.endRow();
                }
            }
        }
    }

    private void printCellInfoRow(CellInfo info, long ping, HTMLBuilder page) {
        page.beginRow(null, "odd");
        page.td("cell", info.getCellName());
        page.td("domain", info.getDomainName());
        page.td("rp", info.getEventQueueSize());
        page.td("th", info.getThreadCount());
        page.td("ping", ping + " msec");
        page.td("time", this._formatter.format(info.getCreationTime()));
        try {
            page.td("version", info.getCellVersion());
        }
        catch (NoSuchMethodError e) {
            page.td("version", "not-implemented");
        }
        page.endRow();
    }

    private int[][] decodePoolCostInfo(PoolCostInfo costInfo) {
        PoolCostInfo.PoolQueueInfo mover = costInfo.getMoverQueue();
        PoolCostInfo.PoolQueueInfo restore = costInfo.getRestoreQueue();
        PoolCostInfo.PoolQueueInfo store = costInfo.getStoreQueue();
        PoolCostInfo.PoolQueueInfo p2pServer = costInfo.getP2pQueue();
        PoolCostInfo.PoolQueueInfo p2pClient = costInfo.getP2pClientQueue();
        int[][] rows = new int[][]{{mover.getActive(), mover.getMaxActive(), mover.getQueued()}, {restore.getActive(), restore.getMaxActive(), restore.getQueued()}, {store.getActive(), store.getMaxActive(), store.getQueued()}, (int[])(p2pServer == null ? null : new int[]{p2pServer.getActive(), p2pServer.getMaxActive(), p2pServer.getQueued()}), {p2pClient.getActive(), p2pClient.getMaxActive(), p2pClient.getQueued()}};
        return rows;
    }

    private double round(double value) {
        return Math.floor(value * 10.0) / 10.0;
    }

    private void printPoolInfoRow(PoolCellInfo cellInfo, HTMLBuilder page) {
        long mb = 0x100000L;
        PoolCostInfo.PoolSpaceInfo info = cellInfo.getPoolCostInfo().getSpaceInfo();
        if (cellInfo.getErrorCode() == 0) {
            long total = info.getTotalSpace();
            long freespace = info.getFreeSpace();
            long precious = info.getPreciousSpace();
            long removable = info.getRemovableSpace();
            double red = this.round((float)(100L * precious) / (float)total);
            double green = this.round((float)(100L * removable) / (float)total);
            double yellow = this.round((float)(100L * freespace) / (float)total);
            double blue = Math.max(0.0, 100.0 - red - green - yellow);
            _log.info(cellInfo.getCellName() + " : " + ";total=" + total + ";free=" + freespace + ";precious=" + precious + ";removable=" + removable);
            page.beginRow(null, "odd");
            page.td("cell", cellInfo.getCellName());
            page.td("domain", cellInfo.getDomainName());
            page.td("total", total / mb);
            page.td("free", freespace / mb);
            page.td("precious", precious / mb);
            page.td("layout", "<div>", "<div class=\"layout_precious\" style=\"width: ", String.format(Locale.US, "%.1f", red), "%\"></div>", "<div class=\"layout_rest\" style=\"width: ", String.format(Locale.US, "%.1f", blue), "%\"></div>", "<div class=\"layout_used\" style=\"width: ", String.format(Locale.US, "%.1f", green), "%\"></div>", "<div class=\"layout_free\" style=\"width: ", String.format(Locale.US, "%.1f", yellow), "%\"></div>", "</div>");
            page.endRow();
        } else {
            page.beginRow(null, "odd");
            page.td("cell", cellInfo.getCellName());
            page.td("domain", cellInfo.getDomainName());
            page.td("errorcode", "[", cellInfo.getErrorCode(), "]");
            page.td(3, "errormessage", cellInfo.getErrorMessage());
            page.endRow();
        }
    }

    private void printPoolActionRow(PoolCostEntry info, ActionHeaderExtension ext, HTMLBuilder page) {
        page.beginRow(null, "odd");
        page.td("cell", info._cellName);
        page.td("domain", info._domainName);
        for (int[] row : info._row) {
            if (row == null) {
                page.td(3, "integrated", "Integrated");
                continue;
            }
            page.td("active", row[0]);
            page.td("max", row[1]);
            if (row[2] > 0) {
                page.td("queued", row[2]);
                continue;
            }
            page.td("idle", 0);
        }
        if (ext != null) {
            for (int[] row : ext.getSortedMovers(info._movers)) {
                page.td("active", row[0]);
                page.td("max", row[1]);
                if (row[2] > 0) {
                    page.td("queued", row[2]);
                    continue;
                }
                page.td("idle", 0);
            }
        }
        page.endRow();
    }

    private void printOfflineCellInfoRow(String name, String domain, HTMLBuilder page) {
        page.beginRow(null, "odd");
        page.td("cell", name);
        page.td("domain", domain);
        page.td(5, "offline", "OFFLINE");
        page.endRow();
    }

    private void printCellInfoTable(HTMLBuilder page) {
        page.beginTable("sortable", "cell", "CellName", "domain", "DomainName", "rp", "RP", "th", "TH", "ping", "Ping", "time", "Creation Time", "version", "Version");
        for (CellQueryInfo info : this._infoMap.values()) {
            CellInfo cellInfo = info.getCellInfo();
            long pingTime = info.getPingTime();
            if (info.isOk()) {
                this.printCellInfoRow(cellInfo, pingTime, page);
                continue;
            }
            if (!info.isPresent()) continue;
            this.printOfflineCellInfoRow(info.getName(), cellInfo == null || cellInfo.getDomainName().length() == 0 ? "&lt;unknown&gt" : cellInfo.getDomainName(), page);
        }
        page.endTable();
    }

    private synchronized void printPoolInfoTable(HTMLBuilder page) {
        page.beginTable("sortable", "cell", "CellName", "domain", "DomainName", "total", "Total Space/MiB", "free", "Free Space/MiB", "precious", "Precious Space/MiB", "layout", "<span>Layout   (<span class=\"layout_precious\">precious/</span><span class=\"layout_used\">used/</span><span class=\"layout_free\">free</span>)</span>");
        for (CellQueryInfo info : this._infoMap.values()) {
            CellInfo cellInfo = info.getCellInfo();
            if (!info.isOk() || !(cellInfo instanceof PoolCellInfo)) continue;
            this.printPoolInfoRow((PoolCellInfo)cellInfo, page);
        }
        page.endTable();
    }

    private synchronized List<PoolCostEntry> preparePoolCostTable() {
        ArrayList<PoolCostEntry> list = new ArrayList<PoolCostEntry>();
        for (CellQueryInfo info : this._infoMap.values()) {
            PoolCellInfo pci;
            int[][] status;
            CellInfo cellInfo = info.getCellInfo();
            if (!info.isOk() || !(cellInfo instanceof PoolCellInfo) || (status = this.decodePoolCostInfo((pci = (PoolCellInfo)cellInfo).getPoolCostInfo())) == null) continue;
            list.add(new PoolCostEntry(pci.getCellName(), pci.getDomainName(), status, pci.getPoolCostInfo().getExtendedMoverHash()));
        }
        return list;
    }

    private synchronized void printPoolActionTable2(HTMLBuilder page) {
        _log.debug("Preparing pool cost table");
        List<PoolCostEntry> list = this.preparePoolCostTable();
        _log.debug("Preparing pool cost table done " + list.size());
        TreeMap<String, int[]> moverMap = new TreeMap<String, int[]>();
        int[][] total = new int[5][3];
        for (PoolCostEntry e : list) {
            if (e._movers != null) {
                for (Map.Entry<String, PoolCostInfo.NamedPoolQueueInfo> entry : e._movers.entrySet()) {
                    String queueName = entry.getKey();
                    int[] t = (int[])moverMap.get(queueName);
                    if (t == null) {
                        t = new int[3];
                        moverMap.put(queueName, t);
                    }
                    PoolCostInfo.PoolQueueInfo mover = entry.getValue();
                    t[0] = t[0] + mover.getActive();
                    t[1] = t[1] + mover.getMaxActive();
                    t[2] = t[2] + mover.getQueued();
                }
            }
            int[][] status = e._row;
            for (int j = 0; j < total.length; ++j) {
                for (int l = 0; l < total[j].length; ++l) {
                    if (status[j] == null) continue;
                    int[] nArray = total[j];
                    int n = l;
                    nArray[n] = nArray[n] + status[j][l];
                }
            }
        }
        ActionHeaderExtension extension = new ActionHeaderExtension(moverMap);
        page.beginTable(null, new String[0]);
        this.printPoolActionTableHeader(page, extension, 0);
        this.printPoolActionTableTotals(page, extension, total);
        int i = 0;
        for (PoolCostEntry e : list) {
            this.printPoolActionRow(e, extension, page);
            if (this._repeatHeader == 0 || ++i % this._repeatHeader != 0) continue;
            this.printPoolActionTableHeader(page, extension, 1);
        }
        this.printPoolActionTableTotals(page, extension, total);
        this.printPoolActionTableHeader(page, extension, 2);
        page.endTable();
    }

    private void printPoolActionTableTotals(HTMLBuilder page, ActionHeaderExtension extension, int[][] total) {
        Map<String, int[]> map;
        page.beginRow("total");
        page.th(2, null, "Total");
        for (int[] row : total) {
            page.td("active", row[0]);
            page.td("max", row[1]);
            page.td("queued", row[2]);
        }
        Map<String, int[]> map2 = map = extension == null ? null : extension.getTotals();
        if (map != null) {
            for (int[] row : map.values()) {
                page.td("active", row[0]);
                page.td("max", row[1]);
                page.td("queued", row[2]);
            }
        }
        page.endRow();
    }

    private void preparePage() {
        HTMLBuilder page = new HTMLBuilder(this._nucleus.getDomainContext());
        page.addHeader("/styles/cellInfo.css", "Services");
        this.printCellInfoTable(page);
        page.addFooter(this.getClass().getName() + " [$Revision: 1.30 $]");
        page.writeToContext("cellInfoTable.html");
        page = new HTMLBuilder(this._nucleus.getDomainContext());
        page.addHeader("/styles/usageInfo.css", "Disk Space Usage");
        this.printPoolInfoTable(page);
        page.addFooter(this.getClass().getName() + " [$Revision: 1.30 $]");
        page.writeToContext("poolUsageTable.html");
        page = new HTMLBuilder(this._nucleus.getDomainContext());
        page.addHeader("/styles/queueInfo.css", "Pool Request Queues");
        this.printPoolActionTable2(page);
        page.addFooter(this.getClass().getName() + " [$Revision: 1.30 $]");
        page.writeToContext("poolQueueTable.html");
    }

    public void cleanUp() {
        _log.info("Clean Up sequence started");
        _log.info("Waiting for collector thread to be finished");
        this._collectThread.interrupt();
        this._senderThread.interrupt();
        this._nucleus.getDomainContext().remove("cellInfoTable.html");
        _log.info("cellInfoTable.html removed from domain context");
        _log.info("Clean Up sequence done");
    }

    public void getInfo(PrintWriter pw) {
        pw.println("        Version : $Id: WebCollectorV3.java,v 1.30 2007-10-29 14:19:08 behrmann Exp $");
        pw.println("Update Interval : " + this._sleepHandler);
        pw.println("        Updates : " + this._counter);
        pw.println("       Watching : " + this._infoMap.size() + " cells");
    }

    private class PoolCostEntry {
        String _cellName;
        String _domainName;
        int[][] _row;
        Map<String, PoolCostInfo.NamedPoolQueueInfo> _movers;

        PoolCostEntry(String name, String domain, int[][] row) {
            this._cellName = name;
            this._domainName = domain;
            this._row = row;
            this._movers = null;
        }

        PoolCostEntry(String name, String domain, int[][] row, Map<String, PoolCostInfo.NamedPoolQueueInfo> movers) {
            this._cellName = name;
            this._domainName = domain;
            this._row = row;
            this._movers = movers;
        }
    }

    private class ActionHeaderExtension {
        private TreeMap<String, int[]> _map;

        private ActionHeaderExtension(TreeMap<String, int[]> map) {
            this._map = map == null ? new TreeMap() : map;
        }

        public String toString() {
            return this._map.toString();
        }

        int[][] getSortedMovers(Map<String, PoolCostInfo.NamedPoolQueueInfo> moverMap) {
            int[][] rows = new int[this._map.size()][];
            if (moverMap == null) {
                for (int i = 0; i < this._map.size(); ++i) {
                    rows[i] = new int[]{-1, -1, -1};
                }
            } else {
                int i = 0;
                for (String key : this._map.keySet()) {
                    PoolCostInfo.PoolQueueInfo mover = moverMap.get(key);
                    rows[i] = mover == null ? new int[]{-1, -1, -1} : new int[]{mover.getActive(), mover.getMaxActive(), mover.getQueued()};
                    ++i;
                }
            }
            return rows;
        }

        public Set<String> getSet() {
            return this._map.keySet();
        }

        public Map<String, int[]> getTotals() {
            return this._map;
        }
    }

    private class CellQueryInfo {
        private final CellAddressCore _destination;
        private long _diff = -1L;
        private long _start;
        private CellInfo _info;
        private final CellMessage _message;
        private long _lastMessage;
        private boolean _present;

        private CellQueryInfo(CellAddressCore destination) {
            this._destination = destination;
            this._message = new CellMessage(new CellPath(destination), (Serializable)((Object)"xgetcellinfo"));
        }

        private String getName() {
            return this._destination.getCellName();
        }

        private CellInfo getCellInfo() {
            return this._info;
        }

        private long getPingTime() {
            return this._diff;
        }

        private CellMessage getCellMessage() {
            this._start = System.currentTimeMillis();
            return this._message;
        }

        private void infoArrived(CellInfo info) {
            this._info = info;
            this._lastMessage = System.currentTimeMillis();
            this._diff = this._lastMessage - this._start;
            this._present = true;
        }

        private boolean isOk() {
            return System.currentTimeMillis() - this._lastMessage < 3L * WebCollectorV3.this._sleepHandler._regularPeriod;
        }

        private boolean isPresent() {
            return this._present;
        }
    }

    private class SleepHandler {
        private boolean _enabled = true;
        private boolean _mode = true;
        private long _started;
        private long _shortPeriod = 20000L;
        private long _regularPeriod = 120000L;
        private long _retentionFactor = 4L;

        private SleepHandler(boolean aggressive) {
            this._enabled = aggressive;
            this._mode = aggressive;
        }

        private synchronized void sleep() throws InterruptedException {
            long start = System.currentTimeMillis();
            this.wait(this._mode ? this._shortPeriod / 2L : this._regularPeriod / 2L);
            _log.debug("Woke up after " + (System.currentTimeMillis() - start) + " millis");
        }

        private synchronized void setShortPeriod(long shortPeriod) {
            this._shortPeriod = shortPeriod;
            this.notifyAll();
        }

        private synchronized void setRegularPeriod(long regularPeriod) {
            this._regularPeriod = regularPeriod;
            this.notifyAll();
        }

        private synchronized void topologyChanged(boolean modified) {
            if (!this._enabled) {
                return;
            }
            if (modified) {
                this._started = System.currentTimeMillis();
                if (!this._mode) {
                    this._mode = true;
                    this.notifyAll();
                    _log.info("Aggressive changed to ON");
                }
            } else if (this._mode && System.currentTimeMillis() - this._started > this._shortPeriod * this._retentionFactor) {
                this._mode = false;
                this.notifyAll();
                _log.info("Aggressive changed to OFF");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("E=").append(this._enabled).append(";A=").append(this._mode).append(";S=").append(this._shortPeriod).append(";Ret").append(this._retentionFactor).append(";R=").append(this._regularPeriod);
            return sb.toString();
        }
    }
}

