/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.admin;

import diskCacheV111.admin.UserMetaDataProvider;
import dmg.cells.nucleus.CellAdapter;
import dmg.util.Args;
import dmg.util.CollectionFactory;
import java.util.List;
import java.util.Map;
import org.dcache.auth.KAuthFile;
import org.dcache.auth.UserAuthRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMetaDataProviderFnal
implements UserMetaDataProvider {
    private static final Logger _log = LoggerFactory.getLogger(UserMetaDataProviderFnal.class);
    private final CellAdapter _cell;
    private final Map<String, Object> _context;
    private final Args _args;
    private final String _ourName;
    private int _requestCount;
    private final Map<String, Integer> _userStatistics = CollectionFactory.newHashMap();
    private String _kpwdFilePath;
    public static final String hh_ls = "";

    public UserMetaDataProviderFnal(CellAdapter cell) {
        this._cell = cell;
        this._context = this._cell.getDomainContext();
        this._args = this._cell.getArgs();
        this._ourName = this.getClass().getName();
        this._kpwdFilePath = (String)this._context.get("kpwd-file");
        String string = this._kpwdFilePath = this._kpwdFilePath == null ? this._args.getOpt("kpwd-file") : this._kpwdFilePath;
        if (this._kpwdFilePath == null) {
            throw new IllegalArgumentException(this._ourName + " : -kpwd-file not specified");
        }
    }

    public String ac_ls(Args args) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this._userStatistics.entrySet()) {
            sb.append(entry.getKey()).append("  ->  ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private void updateStatistics(String userName) {
        Integer count = this._userStatistics.get(userName);
        int c = count == null ? 0 : count;
        this._userStatistics.put(userName, c + 1);
        ++this._requestCount;
    }

    @Override
    public synchronized Map<String, String> getUserMetaData(String userName, String userRole, List<String> attributes) throws Exception {
        this.updateStatistics(userName);
        Map<String, String> result = this.getUserMD(userName, userRole);
        if (result.get("uid") == null || result.get("gid") == null || result.get("home") == null) {
            throw new IllegalArgumentException(this._ourName + " : insufficient info for user : " + userName + "->" + userRole);
        }
        return result;
    }

    private Map<String, String> getUserMD(String userPrincipal, String userRole) {
        UserAuthRecord pwdRecord;
        KAuthFile authf;
        Map answer = CollectionFactory.newHashMap();
        try {
            authf = new KAuthFile(this._kpwdFilePath);
        }
        catch (Exception e) {
            _log.warn("User authentication file not found: " + e);
            return answer;
        }
        if (userRole.startsWith("UNSPECIFIED")) {
            userRole = authf.getIdMapping(userPrincipal);
            _log.warn("userRole=" + userRole);
            if (userRole == null) {
                _log.warn("User " + userPrincipal + " not found.");
                return answer;
            }
        }
        if ((pwdRecord = authf.getUserRecord(userRole)) == null) {
            _log.warn("User " + userRole + " not found.");
            return answer;
        }
        if (!pwdRecord.hasSecureIdentity(userPrincipal)) {
            _log.warn(userPrincipal + ": Permission denied");
            return answer;
        }
        int uid = pwdRecord.UID;
        int gid = pwdRecord.GID;
        String home = pwdRecord.Home;
        answer.put("uid", String.valueOf(uid));
        answer.put("gid", String.valueOf(gid));
        answer.put("home", home);
        _log.info("User " + userRole + " logged in");
        return answer;
    }

    public String toString() {
        return "rc=" + this._requestCount;
    }
}

