/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.admin;

import diskCacheV111.admin.UserMetaDataProvider;
import dmg.cells.nucleus.CellAdapter;
import dmg.util.Args;
import dmg.util.CollectionFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class UserMetaDataProviderExample
implements UserMetaDataProvider {
    private final CellAdapter _cell;
    private final Map<String, Object> _context;
    private final Args _args;
    private final String _ourName;
    private String _baseDirectoryName;
    private File _baseDir;
    private int _requestCount;
    private final Map<String, Integer> _userStatistics = CollectionFactory.newHashMap();
    public static final String hh_ls = "";

    public UserMetaDataProviderExample(CellAdapter cell) {
        this._cell = cell;
        this._context = this._cell.getDomainContext();
        this._args = this._cell.getArgs();
        this._ourName = this.getClass().getName();
        this._baseDirectoryName = (String)this._context.get("umd-mapping");
        String string = this._baseDirectoryName = this._baseDirectoryName == null ? this._args.getOpt("umd-mapping") : this._baseDirectoryName;
        if (this._baseDirectoryName == null) {
            throw new IllegalArgumentException(this._ourName + " : Base directory not specified");
        }
        this._baseDir = new File(this._baseDirectoryName);
        if (!this._baseDir.isDirectory()) {
            throw new IllegalArgumentException(this._ourName + " : not a directory : " + this._baseDirectoryName);
        }
    }

    public String ac_ls(Args args) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this._userStatistics.entrySet()) {
            sb.append(entry.getKey()).append("  ->  ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private void updateStatistics(String userName) {
        Integer count = this._userStatistics.get(userName);
        int c = count == null ? 0 : count;
        this._userStatistics.put(userName, c + 1);
        ++this._requestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<String, String> getUserMetaData(String userName, String userRole, List<String> attributes) throws Exception {
        Map result;
        block14: {
            this.updateStatistics(userName);
            File userData = new File(this._baseDir, userName);
            if (!userData.exists()) {
                throw new IllegalArgumentException(this._ourName + " : user not found : " + userName);
            }
            BufferedReader br = new BufferedReader(new FileReader(userData));
            result = CollectionFactory.newHashMap();
            block9: while (true) {
                String line;
                while ((line = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line, "=");
                    try {
                        result.put(st.nextToken(), st.nextToken());
                        continue block9;
                    }
                    catch (Exception ee) {
                    }
                }
                break block14;
                {
                    continue block9;
                    break;
                }
                break;
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception ee) {}
            }
        }
        if (result.get("uid") == null || result.get("gid") == null || result.get("home") == null) {
            throw new IllegalArgumentException(this._ourName + " : insufficient info from user : " + userName);
        }
        Map answer = CollectionFactory.newHashMap();
        for (String attribute : attributes) {
            String key = attribute;
            String value = (String)result.get(key);
            if (value == null) continue;
            answer.put(key, value);
        }
        return answer;
    }

    public String toString() {
        return "rc=" + this._requestCount;
    }
}

