/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.admin;

import diskCacheV111.admin.ExecAuth;
import diskCacheV111.admin.PAM_Auth;
import diskCacheV111.admin.UserMetaDataProvider;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.security.digest.Crypt;
import dmg.util.AgingHash;
import dmg.util.Args;
import dmg.util.UserPasswords;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAMAuthentificator
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(PAMAuthentificator.class);
    private final int request_len = 5;
    private final int response_len = 6;
    private final CellNucleus _nucleus;
    private final String _cellName;
    private String _service;
    private PAM_Auth _pam;
    private ExecAuth _execAuth;
    private Args _args;
    private Date _started;
    private int _requestCount;
    private int _badRequestCount;
    private int _failedRequestCount;
    private static final int USER_SERVICE_FILE = 1;
    private static final int USER_SERVICE_NIS = 2;
    private static final int USER_SERVICE_LDAP = 3;
    private static final int USER_SERVICE_CLASS = 4;
    private UserPasswords _sysPassword;
    private UserPasswords _egPassword;
    private UserMetaDataProvider _userServiceProvider;
    private DirContext _userServiceNIS;
    private UserPasswords _userServiceFile;
    private int _userServiceType;
    private final Crypt _crypt;
    private static final String DUMMY_ADMIN = "5t2Hw7lNqVock";
    private static final long HASH_REFRESH = 14400000L;
    private AgingHash _map;
    public static final String hh_check_meta = "<user>";
    public static final String hh_check_auth = "<user> <password>";
    public static final String hh_user_map_ls = "# [-t]";
    public static final String hh_user_map_remove = "<userName> # remove user from hash";
    public static final String hh_user_map_add = "<userName> <uid> <gid> [<home> [<shell>]]";
    public static final String hh_user_map_reset = "# clear user map hash";

    public PAMAuthentificator(String cellName, String args) throws Exception {
        block15: {
            super(cellName, PAMAuthentificator.class.getName(), args, false);
            this.request_len = 5;
            this.response_len = 6;
            this._started = new Date();
            this._crypt = new Crypt();
            this._map = new AgingHash(400);
            this._nucleus = this.getNucleus();
            this._cellName = cellName;
            this._args = this.getArgs();
            this.useInterpreter(true);
            try {
                String tmp;
                this._service = this._args.getOpt("service");
                if (this._service == null) {
                    this._service = "dcache";
                    _log.info("'service' not defined. Using '" + this._service + "' as default service");
                }
                if ((tmp = this._args.getOpt("external")) == null) {
                    tmp = this._args.getOpt("syspassword");
                    if (tmp != null) {
                        this._sysPassword = new UserPasswords(new File(tmp));
                        _log.info("using as SystemPasswordfile : " + tmp);
                    }
                    if ((tmp = this._args.getOpt("dcachepassword")) != null) {
                        this._egPassword = new UserPasswords(new File(tmp));
                        _log.info("using as dCachePassword : " + tmp);
                    }
                    if ((tmp = this._args.getOpt("usepam")) != null) {
                        this._pam = new PAM_Auth(this._service);
                        _log.info("using PAM mudule");
                    }
                } else {
                    this._execAuth = new ExecAuth(tmp);
                }
                if ((tmp = this._args.getOpt("users")) == null) break block15;
                _log.info("using as userService : " + tmp);
                if (tmp.startsWith("nis:")) {
                    String provider = this._args.getOpt("provider");
                    provider = provider == null ? "com.sun.jndi.nis.NISCtxFactory" : provider;
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", provider);
                    env.put("java.naming.provider.url", tmp);
                    try {
                        this._userServiceNIS = new InitialDirContext(env);
                    }
                    catch (NamingException ne) {
                        _log.warn("Can't InitialDirContext(env) " + ne);
                        throw ne;
                    }
                    this._userServiceType = 2;
                    break block15;
                }
                if (tmp.startsWith("ldap:")) {
                    throw new IllegalArgumentException("LDap not yet supported");
                }
                if (tmp.startsWith("file:")) {
                    this._userServiceFile = new UserPasswords(new File(tmp.substring(5)));
                    this._userServiceType = 1;
                    break block15;
                }
                if (tmp.startsWith("class:")) {
                    this._userServiceProvider = this.initUserServiceProvider(tmp.substring(6));
                    this._userServiceType = 4;
                    break block15;
                }
                if (!tmp.contains(":")) {
                    this._userServiceFile = new UserPasswords(new File(tmp));
                    this._userServiceType = 1;
                    break block15;
                }
                throw new IllegalArgumentException("Invalid user service provider : " + tmp);
            }
            catch (Exception e) {
                this.start();
                this.kill();
                throw e;
            }
        }
        this.export();
        this.start();
    }

    private UserMetaDataProvider initUserServiceProvider(String className) throws Exception {
        Class[] argClasses = new Class[]{CellAdapter.class};
        Object[] argObjects = new Object[]{this};
        Class<UserMetaDataProvider> exec = Class.forName(className).asSubclass(UserMetaDataProvider.class);
        Constructor<UserMetaDataProvider> constructor = exec.getConstructor(argClasses);
        UserMetaDataProvider provider = constructor.newInstance(argObjects);
        this.addCommandListener(provider);
        return provider;
    }

    public void getInfo(PrintWriter pw) {
        try {
            pw.println("PAMAuthentificator");
            pw.println("        Request Count : " + this._requestCount);
            pw.println("    Bad Request Count : " + this._badRequestCount);
            pw.println(" Failed Request Count : " + this._failedRequestCount);
            pw.println("           PAM loaded : " + (this._pam == null ? "Not requested" : "" + this._pam.pamOk()));
            pw.println(" System Password File : " + (this._sysPassword == null ? "<null>" : this._sysPassword.toString()));
            pw.println(" dCache Password File : " + (this._egPassword == null ? "<null>" : this._egPassword.toString()));
            switch (this._userServiceType) {
                case 1: {
                    pw.println(" user metadata   File : " + (this._userServiceFile == null ? "<null>" : this._userServiceFile.toString()));
                    break;
                }
                case 2: {
                    pw.println(" user metadata   Nis  : " + this._userServiceNIS);
                    break;
                }
                case 3: {
                    pw.println(" user metadata   LDAP : " + this._userServiceNIS);
                    break;
                }
                case 4: {
                    pw.println(" user metadata   Class  : " + this._userServiceProvider.getClass().getName());
                    pw.println(" user metadata   Object : " + this._userServiceProvider);
                }
            }
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
    }

    private void updatePassword() {
        try {
            if (this._sysPassword != null) {
                this._sysPassword.update();
            }
        }
        catch (Exception ee) {
            _log.warn("Updating failed : " + this._sysPassword);
        }
        try {
            if (this._egPassword != null) {
                this._egPassword.update();
            }
        }
        catch (Exception ee) {
            _log.warn("Updating failed : " + this._egPassword);
        }
    }

    private boolean matchPassword(String userName, String password) {
        this.updatePassword();
        try {
            String pswd;
            if (userName.equals("admin")) {
                String pswd2;
                if (!(this._sysPassword != null && (pswd2 = this._sysPassword.getPassword(userName)) != null || this._egPassword != null && (pswd2 = this._egPassword.getPassword(userName)) != null)) {
                    pswd2 = DUMMY_ADMIN;
                }
                return this._crypt.crypt(pswd2, password).equals(pswd2);
            }
            if (!(this._sysPassword != null && (pswd = this._sysPassword.getPassword(userName)) != null || this._egPassword != null && (pswd = this._egPassword.getPassword(userName)) != null)) {
                return false;
            }
            return this._crypt.crypt(pswd, password).equals(pswd);
        }
        catch (Throwable t) {
            _log.warn("Found : " + t);
            return false;
        }
    }

    private boolean authenticate(String principal, String password) {
        password = password.trim();
        if (this._pam != null) {
            return this._pam.authenticate(principal, password);
        }
        if (this._execAuth != null) {
            try {
                String result = this._execAuth.command("check " + this._service + " " + principal + " " + password);
                return result.equals("true");
            }
            catch (Exception ee) {
                _log.warn(ee.toString(), (Throwable)ee);
                return false;
            }
        }
        return false;
    }

    private boolean checkAccess(String principal, String password) {
        boolean pamOk = false;
        try {
            pamOk = this.authenticate(principal, password);
        }
        catch (Exception ee) {
            _log.warn("_pam.authorize : " + ee);
        }
        if (!pamOk) {
            _log.info("pam _log.infos no to <" + principal + "> (switching to local)");
            try {
                return this.matchPassword(principal, password);
            }
            catch (Exception ee) {
                _log.warn("matchPassword : " + ee);
            }
        }
        return pamOk;
    }

    public void messageArrived(CellMessage msg) {
        Serializable answer;
        block16: {
            Serializable obj = msg.getMessageObject();
            try {
                _log.info("Message type : " + obj.getClass());
                if (obj instanceof Object[] && ((Object[])obj).length >= 3 && ((Object[])obj)[0].equals("request")) {
                    Object[] request = (Object[])obj;
                    String user = request[1] == null ? "unknown" : (String)request[1];
                    String command = (String)request[2];
                    _log.info(">" + command + "< request from " + user);
                    try {
                        switch (command) {
                            case "check-password": {
                                answer = this.acl_check_password(request);
                                break;
                            }
                            case "get-metainfo": {
                                answer = this.getMetaInfo(request);
                                break;
                            }
                            default: {
                                throw new Exception("Command not found : " + command);
                            }
                        }
                        break block16;
                    }
                    catch (Exception xe) {
                        throw new Exception("Problem : " + xe);
                    }
                }
                String r = "Illegal message object received from : " + msg.getSourcePath();
                _log.warn(r);
                throw new Exception(r);
            }
            catch (Exception iex) {
                answer = iex;
            }
        }
        if (answer instanceof Object[]) {
            ((Object[])answer)[0] = "response";
        }
        msg.revertDirection();
        msg.setMessageObject(answer);
        try {
            this.sendMessage(msg);
        }
        catch (Exception ioe) {
            _log.warn("Can't send acl_response : " + ioe, (Throwable)ioe);
        }
    }

    private Serializable getMetaInfo(Object[] request) throws Exception {
        return this._userServiceType == 1 ? this.acl_get_metainfo(request) : (this._userServiceType == 2 ? this.acl_get_metainfo_nis(request) : (this._userServiceType == 4 ? this.acl_get_metainfo_class(request) : new IllegalArgumentException("Panix " + this._userServiceType)));
    }

    private Serializable acl_get_metainfo(Object[] request) throws Exception {
        int i;
        if (request.length < 5 || request[3] == null || request[4] == null) {
            throw new IllegalArgumentException("Not enough or illegal arguments for 'get-metainfo'");
        }
        String userName = request[3].toString();
        if (this._userServiceFile == null) {
            throw new IllegalArgumentException("User service not configured");
        }
        this._userServiceFile.update();
        String[] dict = this._userServiceFile.getRecord(userName);
        if (dict == null) {
            throw new IllegalArgumentException("No such user : " + userName);
        }
        StringTokenizer st = new StringTokenizer(request[4].toString(), ",");
        ArrayList<String> result = new ArrayList<String>();
        block14: while (st.hasMoreTokens()) {
            String key;
            switch (key = st.nextToken()) {
                case "uid": {
                    result.add(dict.length > 2 ? dict[2] : null);
                    continue block14;
                }
                case "gid": {
                    result.add(dict.length > 3 ? dict[3] : null);
                    continue block14;
                }
                case "home": {
                    result.add(dict.length > 5 ? dict[5] : null);
                    continue block14;
                }
                case "fqn": {
                    result.add(dict.length > 4 ? dict[4] : null);
                    continue block14;
                }
                case "shell": {
                    result.add(dict.length > 6 ? dict[6] : null);
                    continue block14;
                }
            }
            result.add(null);
        }
        String[] r = new String[5 + result.size()];
        for (i = 0; i < 5; ++i) {
            r[i] = (String)request[i];
        }
        for (i = 5; i < r.length; ++i) {
            r[i] = (String)result.get(i - 5);
        }
        return r;
    }

    private Serializable acl_get_metainfo_class(Object[] request) throws Exception {
        int i;
        if (request.length < 5 || request[3] == null || request[4] == null) {
            throw new IllegalArgumentException("Not enough or illegal arguments for 'get-metainfo'");
        }
        String userName = request[3].toString();
        String principal = request[1].toString();
        if (this._userServiceProvider == null) {
            throw new IllegalArgumentException("User service not configured");
        }
        ArrayList<String> attrList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(request[4].toString(), ",");
        while (st.hasMoreTokens()) {
            attrList.add(st.nextToken());
        }
        Map<String, String> map = this._userServiceProvider.getUserMetaData(principal, userName, attrList);
        String[] r = new String[5 + attrList.size()];
        for (i = 0; i < 5; ++i) {
            r[i] = (String)request[i];
        }
        for (i = 5; i < r.length; ++i) {
            String t = map.get(attrList.get(i - 5));
            r[i] = t == null ? "Unknown" : t;
        }
        return r;
    }

    private Serializable acl_get_metainfo_nis(Object[] request) throws Exception {
        try {
            int i;
            Attributes answer;
            if (request.length < 5 || request[3] == null || request[4] == null) {
                throw new IllegalArgumentException("Not enough or illegal arguments for 'check-password'");
            }
            String userName = request[3].toString();
            if (this._userServiceNIS == null) {
                throw new IllegalArgumentException("User 'nis' service not configured");
            }
            UserRecord record = (UserRecord)this._map.get((Object)userName);
            if (record == null || record._timestamp != 0L && System.currentTimeMillis() - record._timestamp > 14400000L) {
                answer = this._userServiceNIS.getAttributes("system/passwd/" + userName);
                if (answer.size() == 0) {
                    throw new IllegalArgumentException("No such user : " + userName);
                }
                this._map.put((Object)userName, (Object)new UserRecord(answer));
            } else {
                answer = record._userRecord;
            }
            StringTokenizer st = new StringTokenizer(request[4].toString(), ",");
            ArrayList<Object> result = new ArrayList<Object>();
            block26: while (st.hasMoreTokens()) {
                String key;
                switch (key = st.nextToken()) {
                    case "uid": {
                        try {
                            result.add(answer.get("uidNumber").get());
                        }
                        catch (Exception e) {
                            result.add(null);
                        }
                        continue block26;
                    }
                    case "gid": {
                        try {
                            result.add(answer.get("gidNumber").get());
                        }
                        catch (Exception e) {
                            result.add(null);
                        }
                        continue block26;
                    }
                    case "home": {
                        try {
                            result.add(answer.get("homeDirectory").get());
                        }
                        catch (Exception e) {
                            result.add(null);
                        }
                        continue block26;
                    }
                    case "fqn": {
                        try {
                            result.add(answer.get("gecos").get());
                        }
                        catch (Exception e) {
                            result.add(null);
                        }
                        continue block26;
                    }
                    case "shell": {
                        try {
                            result.add(answer.get("loginShell").get());
                        }
                        catch (Exception e) {
                            result.add(null);
                        }
                        continue block26;
                    }
                }
                result.add(null);
            }
            String[] r = new String[5 + result.size()];
            for (i = 0; i < 5; ++i) {
                r[i] = (String)request[i];
            }
            for (i = 5; i < r.length; ++i) {
                r[i] = (String)result.get(i - 5);
            }
            return r;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            throw ee;
        }
    }

    private Serializable acl_check_password(Object[] request) {
        if (request.length < 5) {
            throw new IllegalArgumentException("Not enough arguments for 'check-password'");
        }
        Object[] response = new Object[6];
        System.arraycopy(request, 0, response, 0, 5);
        response[1] = request[3];
        String userName = (String)request[3];
        String password = (String)request[4];
        response[5] = this.checkAccess(userName, password);
        return response;
    }

    public String ac_check_meta_$_1(Args args) throws Exception {
        Object[] request = new Object[]{"request", "nobody", "get-metainfo", args.argv(0), "uid,gid,home,shell,fqn"};
        Serializable answer = this.getMetaInfo(request);
        if (answer instanceof Exception) {
            throw (Exception)answer;
        }
        Object[] a = (Object[])answer;
        StringBuilder sb = new StringBuilder();
        sb.append("  Uid : ").append(a[5]).append("\n");
        sb.append("  Gid : ").append(a[6]).append("\n");
        sb.append(" Home : ").append(a[7]).append("\n");
        sb.append("Shell : ").append(a[8]).append("\n");
        sb.append(" Name : ").append(a[9]).append("\n");
        return sb.toString();
    }

    public String ac_check_auth_$_2(Args args) {
        String pwd;
        String user = args.argv(0);
        boolean result = this.checkAccess(user, pwd = args.argv(1));
        return result ? "Authentication ok for user <" + user + ">" : "Authentication failed for user <" + user + ">";
    }

    public String ac_user_map_ls(Args args) {
        if (this._map == null) {
            throw new IllegalArgumentException("User map hash not needed");
        }
        Iterator i = this._map.keysIterator();
        StringBuilder sb = new StringBuilder();
        while (i.hasNext()) {
            sb.append(i.next()).append("\n");
        }
        return sb.toString();
    }

    public String ac_user_map_remove_$_1(Args args) {
        if (this._map == null) {
            throw new IllegalArgumentException("User map hash not needed");
        }
        if (this._map.remove((Object)args.argv(0)) == null) {
            throw new IllegalArgumentException("User name not in cache : " + args.argv(0));
        }
        return "";
    }

    public String ac_user_map_add_$_3_5(Args args) {
        String user = args.argv(0);
        String uid = args.argv(1);
        String gid = args.argv(2);
        String home = args.argc() > 3 ? args.argv(3) : "/dev/home";
        String shell = args.argc() > 4 ? args.argv(4) : "/bin/shell";
        BasicAttributes attr = new BasicAttributes();
        attr.put("uidNumber", uid);
        attr.put("gidNumber", gid);
        attr.put("homeDirectory", home);
        attr.put("loginShell", shell);
        attr.put("gecos", user);
        UserRecord ur = new UserRecord(attr);
        ur._timestamp = 0L;
        this._map.put((Object)user, (Object)ur);
        return "";
    }

    public String ac_user_map_reset(Args args) {
        if (this._map == null) {
            throw new IllegalArgumentException("User map hash not needed");
        }
        this._map.clear();
        return "";
    }

    private class UserRecord {
        private Attributes _userRecord;
        private long _timestamp;

        private UserRecord(Attributes userRecord) {
            this._userRecord = userRecord;
            this._timestamp = System.currentTimeMillis();
        }
    }
}

