/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jline.Completor;

public class HelpCompletor
implements Completor {
    final List<String> completions = new ArrayList<String>();

    public HelpCompletor(String help) {
        for (String line : help.split("\n")) {
            this.completions.add(this.scan(line.trim()));
        }
        Collections.sort(this.completions);
    }

    protected String scan(String line) {
        StringBuilder completion = new StringBuilder();
        for (String s : line.split(" ")) {
            if (s.startsWith("#")) break;
            if (s.contains("[") || s.contains("<") || s.contains("|") || s.startsWith("-")) continue;
            completion.append(s).append(" ");
        }
        return completion.toString();
    }

    public int complete(String buffer, int cursor, List candidates) {
        if (cursor < buffer.length()) {
            return -1;
        }
        String s = buffer.replaceAll("\\s+", " ");
        int i = Collections.binarySearch(this.completions, s);
        if (i < 0) {
            i = -i - 1;
        }
        while (i < this.completions.size() && this.completions.get(i).startsWith(s)) {
            candidates.add(this.completions.get(i));
            ++i;
        }
        return 0;
    }
}

