/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.admin;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellShell;
import dmg.util.Args;
import dmg.util.AuthorizedString;
import dmg.util.CommandExitException;
import dmg.util.CommandInterpreter;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminShell
extends CommandInterpreter {
    private static final Logger _log = LoggerFactory.getLogger(AdminShell.class);
    private CellNucleus _nucleus;
    private String _user;
    private CellPath _cellPath = new CellPath("AclCell");
    private CellShell _cellShell;
    private boolean _wasAdmin;
    public static final String hh_id = "[<newId>]";
    public static final String hh_cd = "<destinationCell>";
    public static final String hh_pwd = "";

    public AdminShell(String user, CellNucleus nucleus, Args args) {
        this._nucleus = nucleus;
        this._user = user;
        this._wasAdmin = this._user.equals("admin");
        for (int i = 0; i < args.argc(); ++i) {
            _log.info("arg[" + i + "]=" + args.argv(i));
        }
    }

    public String getPrompt() {
        return this._cellPath.getCellName() + "(" + this._user + ") >> ";
    }

    public String getHello() {
        return "\n    Welcome to the dCache Admin Interface (user=" + this._user + ")\n\n";
    }

    public String ac_id_$_0_1(Args args) {
        if (args.argc() == 1) {
            if (!this._user.equals("admin") && !this._wasAdmin) {
                throw new IllegalArgumentException("Not allowed");
            }
            this._user = args.argv(0);
            return hh_pwd;
        }
        return this._user + "\n";
    }

    public String ac_cd_$_1(Args args) {
        this._cellPath = new CellPath(args.argv(0));
        return hh_pwd;
    }

    public String ac_pwd_$_0(Args args) {
        return this._cellPath.toString() + "\n";
    }

    public Object executeCommand(String obj) throws Exception {
        _log.info("executeCommand : arriving as String : " + obj);
        return this._executeCommand(obj, false);
    }

    public Object executeCommand(Object obj) throws Exception {
        _log.info("executeCommand : arriving as Object : " + obj.toString());
        return this._executeCommand(obj.toString(), true);
    }

    public Object _executeCommand(String obj, boolean wasBinary) throws Exception {
        String str = obj;
        String tr = str.trim();
        if (tr.equals(hh_pwd)) {
            return hh_pwd;
        }
        if (tr.equals("logout")) {
            throw new CommandExitException();
        }
        if (tr.startsWith(".")) {
            tr = tr.substring(1);
            return this.command(tr);
        }
        Args xx = new Args((CharSequence)str);
        String path = xx.getOpt("cellPath");
        CellPath cellPath = path != null ? new CellPath(path) : this._cellPath;
        CellMessage res = this._nucleus.sendAndWait(new CellMessage(cellPath, (Serializable)new AuthorizedString(this._user, str + (wasBinary ? " -binary" : hh_pwd))), 10000L);
        if (res == null) {
            throw new Exception("Request timed out");
        }
        Serializable resObject = res.getMessageObject();
        _log.info("result from domain : " + resObject.getClass().getName());
        if (wasBinary) {
            return resObject;
        }
        if (resObject instanceof Exception) {
            throw (Exception)resObject;
        }
        String r = resObject.toString();
        if (r.length() == 0) {
            return hh_pwd;
        }
        if (r.substring(r.length() - 1).equals("\n")) {
            return r;
        }
        return r + "\n";
    }
}

