/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.send;

import io.milton.mail.StandardMessage;
import io.milton.mail.StandardMessageFactoryImpl;
import io.milton.mail.send.MailSender;
import io.milton.mail.send.MySmtpMessage;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSmtpMailSender
implements MailSender {
    private static final Logger log = LoggerFactory.getLogger(RemoteSmtpMailSender.class);
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private boolean started;
    private boolean useSsl = false;

    public RemoteSmtpMailSender(String host, String user, String password, int port) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.port = port;
    }

    @Override
    public void sendMail(String from, String fromPersonal, List<String> to, String replyTo, String subject, String text) {
        if (!this.started) {
            throw new RuntimeException("This mail sender is stopped");
        }
        try {
            MimeMessage mm = new MimeMessage(this.getSession());
            mm.setSubject(subject);
            InternetAddress ia = fromPersonal == null ? new InternetAddress(from) : new InternetAddress(from, fromPersonal);
            mm.setFrom((Address)ia);
            Address[] add = new Address[]{new InternetAddress(replyTo)};
            mm.setReplyTo(add);
            for (String sTo : to) {
                if (sTo == null || sTo.length() <= 0) continue;
                InternetAddress recip = null;
                try {
                    recip = new InternetAddress(sTo);
                }
                catch (AddressException addressException) {
                    throw new RuntimeException("Couldnt parse email address: " + sTo, addressException);
                }
                mm.addRecipient(Message.RecipientType.TO, (Address)recip);
            }
            mm.setContent((Object)text, "text/plain");
            this.sendMail(mm);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (MessagingException messagingException) {
            throw new RuntimeException(messagingException);
        }
    }

    @Override
    public void sendMail(MimeMessage mm) {
        if (!this.started) {
            throw new RuntimeException("This mail sender is stopped");
        }
        try {
            log.debug("sending to: " + this.host);
            Transport tr = this.useSsl ? this.getSession().getTransport("smtps") : this.getSession().getTransport("smtp");
            tr.connect(this.host, this.port, this.user, this.password);
            mm.saveChanges();
            tr.sendMessage((Message)mm, mm.getAllRecipients());
            tr.close();
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void sendMail(StandardMessage sm) {
        StandardMessageFactoryImpl smf = new StandardMessageFactoryImpl();
        MimeMessage mm = this.newMessage();
        smf.toMimeMessage(sm, mm);
        this.sendMail(mm);
    }

    @Override
    public Session getSession() {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        if (this.useSsl) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        if (log.isTraceEnabled()) {
            props.put("mail.debug", "true");
        }
        Session session = Session.getInstance((Properties)props, null);
        return session;
    }

    @Override
    public MimeMessage newMessage(MimeMessage mm) {
        try {
            return new MySmtpMessage(this.getSession(), mm);
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MimeMessage newMessage() {
        return new MimeMessage(this.getSession());
    }

    @Override
    public void start() {
        log.debug("started the service");
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }
}

