/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.send;

import com.sun.mail.smtp.SMTPMessage;
import io.milton.mail.StandardMessage;
import io.milton.mail.StandardMessageFactoryImpl;
import io.milton.mail.send.MailSender;
import io.milton.mail.send.MySmtpMessage;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockMailSender
implements MailSender {
    private static final Logger log = LoggerFactory.getLogger(MockMailSender.class);
    private boolean isStarted;
    private final List<SentMessage> sentMessages = new ArrayList<SentMessage>();
    private final List<MimeMessage> sentMimeMessages = new ArrayList<MimeMessage>();

    @Override
    public void start() {
        this.isStarted = true;
    }

    @Override
    public void stop() {
        this.isStarted = false;
    }

    @Override
    public void sendMail(String fromAddress, String fromPersonal, List<String> to, String replyTo, String subject, String text) {
        SentMessage msg = new SentMessage(fromAddress, fromPersonal, to, replyTo, subject, text);
        this.sentMessages.add(msg);
        System.out.println("sentMessages: " + this.sentMessages.size());
    }

    @Override
    public Session getSession() {
        return null;
    }

    @Override
    public void sendMail(MimeMessage mm) {
        this.sentMimeMessages.add(mm);
    }

    @Override
    public void sendMail(StandardMessage sm) {
        log.debug("sendMail: subject: " + sm.getSubject());
        System.out.println("sending email");
        StandardMessageFactoryImpl smf = new StandardMessageFactoryImpl();
        MimeMessage mm = this.newMessage();
        smf.toMimeMessage(sm, mm);
        this.sendMail(mm);
    }

    @Override
    public MimeMessage newMessage(MimeMessage mm) {
        try {
            return new MySmtpMessage(this.getSession(), mm);
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MimeMessage newMessage() {
        return new SMTPMessage(this.getSession());
    }

    public List<SentMessage> getSentMessages() {
        return this.sentMessages;
    }

    public List<MimeMessage> getSentMimeMessages() {
        return this.sentMimeMessages;
    }

    public class SentMessage {
        public final String fromAddress;
        public final String fromPersonal;
        public final List<String> to;
        public final String replyTo;
        public final String subject;
        public final String text;

        public SentMessage(String fromAddress, String fromPersonal, List<String> to, String replyTo, String subject, String text) {
            this.fromAddress = fromAddress;
            this.fromPersonal = fromPersonal;
            this.to = to;
            this.replyTo = replyTo;
            this.subject = subject;
            this.text = text;
        }
    }
}

